require("InventoryItems")
-- Place in this Lua script all the levels of your game
-- Title is mandatory and must be the first level.

-- Intro image is a splash screen which appears before actual loading screen.
-- If you don't want it to appear, just remove this line.

Flow.SetIntroImagePath("Screens\\jungle_fever_intro.jpeg")

-- This image should be used for static title screen background (as in TR1-TR3).
-- For now it is not implemented.

Flow.SetTitleScreenImagePath("Screens\\jungle_fever_title.jpeg")

-- Set overall amount of secrets in game.
-- If set to 0, secrets won't be displayed in statistics.

Flow.SetTotalSecretCount(10)

-- Disable/enable flycheat globally

Flow.EnableFlyCheat(false)

-- Disable/enable Lara drawing in title level

--Flow.EnableLaraInTitle(false)

-- Disable/enable level selection in title level

Flow.EnableLevelSelect(false)

-- Disable/enable mass pickup (collect all pickups at once)

Flow.EnableMassPickup(true)

--------------------------------------------------
-- Title level
Title = Level.new()

Title.ambientTrack = "200-The-nature-Ambient"
Title.levelFile = "Data\\Title.ten"
Title.loadScreenFile = "Screens\\jungle_fever.jpeg"
Title.scriptFile = "Scripts\\Title.lua"
Title.horizon = true
Title.farView = 50
Title.fog = Flow.Fog.new(Color.new(50,100,50), 5, 20)
Title.weather = WeatherType.Rain
Title.weatherStrength = 0.8

Flow.AddLevel(Title)

--------------------------------------------------
-- Intro Level
Intro = Level.new()

Intro.nameKey = "intro"
Intro.scriptFile = "Scripts\\Levels\\Intro.lua"
Intro.ambientTrack = "190-Endless-Ocean"
Intro.secrets = 1
Intro.horizon = true
Intro.levelFile = "Data\\Intro.ten"
Intro.loadScreenFile = "Screens\\intro.jpeg"
Intro.objects =  InventoryItems

Flow.AddLevel(Intro)
--------------------------------------------------
-- Jungle Fever Level
Jungle_Fever = Level.new()

Jungle_Fever.nameKey = "jungle_fever"
Jungle_Fever.scriptFile = "Scripts\\Levels\\Jungle_Fever.lua"
Jungle_Fever.ambientTrack = "219-Jungle"
Jungle_Fever.secrets = 9
Jungle_Fever.horizon = true
Jungle_Fever.farView = 50
Jungle_Fever.fog = Flow.Fog(Color(50,100,50), 5, 30)
Jungle_Fever.weather = WeatherType.Rain
Jungle_Fever.weatherStrength = 0.8
Jungle_Fever.levelFile = "Data\\Jungle_Fever.ten"
Jungle_Fever.loadScreenFile = "Screens\\jungle_fever.jpeg"
Jungle_Fever.objects =  InventoryItems

Flow.AddLevel(Jungle_Fever)