---- FILE: \Jungle_Feaver.lua

local EventSequence = require("Engine.EventSequence")
local Timer = require("Engine.Timer")
require("General")

LevelFuncs.OnLoad = function() 
	require("GameConfig")
	local validLanguages = { EN = true, DE = true }
	if not validLanguages[Language] then
	    error("Invalid language: " .. tostring(Language))
	end
	
	require("GameVarsStrings/" .. Language .. "/GameVarsStrings")
	require("NpcDialogs/" .. Language .. "/NpcDialogs")
	require("MerchantDialogs/" .. Language .. "/MerchantDialogs")
end

LevelFuncs.OnSave = function() end

LevelFuncs.OnStart = function() 
	require("GameConfig")
	local validLanguages = { EN = true, DE = true }
	if not validLanguages[Language] then
	    error("Invalid language: " .. tostring(Language))
	end
	require("GameVarsStrings/" .. Language .. "/GameVarsStrings")
	require("NpcDialogs/" .. Language .. "/NpcDialogs")
	require("MerchantDialogs/" .. Language .. "/MerchantDialogs")
	
	Initialize()
end

LevelFuncs.OnLoop = function() 
	StartSequences()
	ShowAmmoCounter()
	AddDustParticles()
	AddLeaveParticles()
	AddFireParticles()
	DeathEffect()
	ExchangePuzzleItem6()
	CheckForWorkingRaft()
	SetDialogWhenLaraHasToolbox()
	SetDialogWhenLaraHasShotgun()
	SetCollideWithStaticSpikes()
	PlayBackgroundAudios()
	CheckForAllBuddhas()
	CheckForEndGame()
end

LevelFuncs.OnEnd = function() end

function Initialize()
	TEN.Logic.AddCallback(TEN.Logic.CallbackPoint.POSTUSEITEM, LevelFuncs.PostUseFunction)
	
	LevelVars.WorkingRaft = 0
	LevelVars.PlayNormalBackgroundAudio = true
	LevelVars.PlayUnderwaterBackgroundAudio = false
	LevelVars.LaraHasFoundFourBhudda = false
	LevelVars.rb1 = {enabled = false}
	LevelVars.rb2 = {enabled = false}
	LevelVars.SASDragBlokeCollision = true
	LevelVars.LaraHasEndGame = false
	LevelVars.LaraTightrope = false
	LevelVars.StartSequenceCamera = true
	LevelVars.StartSequenceCamera2 = false
	LevelVars.StartSequence = true
	LevelVars.UseFireRope = false
	LevelVars.LaraHasInfoAboutHealingPlants = false

	SetStaticsSoftCollision()
	CustomizeWaterfallEmitters()
    
    local disableVolumes = {
		'merchant_jon_shotgun',
		'npc_jon_2',
		'npc_jon_3',
		'npc_jon_4',
		'npc_jon_5',
		'npc_jon_6',
		'npc_jon_7',
		'npc_jon_8',
		'npc_jon_9',
		'npc_jon_10',
		'npc_jon_11',
		'npc_jon_12',
		'move_raft',
		'merchant_yamandu',
		'yamandu_2',
		'yamandu_3',
		'yamandu_4',
		'yamandu_5',
		'yamandu_6',
		'yamandu_7',
		'yamandu_8',
		'yamandu_9',
		'yamandu_10',
		'yamandu_11',
		'yamandu_12',
		'volume_camera_elephant',
		'merchant_kairi',
		'kairi_2',
		'kairi_3',
		'kairi_4',
		'kairi_4a',
		'kairi_4b',
		'kairi_5',
		'kairi_6'
    }
	
	for index, disableVolume in pairs(disableVolumes) do
		volumeObj = GetVolumeByName(disableVolume)
    	volumeObj:Disable()
    end
    
    local Monkeys = GetMoveablesBySlot(111)
	for index, Monkey in pairs(Monkeys) do
		Monkey:SetOnHit(LevelFuncs.__OnMonkeyHit)
	end
	
	local Tigers = GetMoveablesBySlot(106)
	for index, Tiger in pairs(Tigers) do
		if Tiger:GetName() == 'tiger_692' then
			Tiger:SetOnKilled(LevelFuncs.__OnFirstTigerKill)
		end
	end
	
	Timer.Create(
		"openDoorAfterKeyHole1", --name
		10, -- seconds
		false, -- loop
		false, -- timer table
		LevelFuncs.__OpenDoorAfterKeyHole1 -- function
	)
	
	Timer.Create(
		"laraObserve", --name
		3, -- seconds
		false, -- loop
		false, -- timer table
		LevelFuncs.__LaraObserve -- function
	)
	
	EventSequence.Create(
        "startSequence", --name
        false, --loop
        false, --timer table
        1, LevelFuncs.__Start,
        6, LevelFuncs.__Start2,
        6, LevelFuncs.__Start3,
        4, LevelFuncs.__Start4,
        4, LevelFuncs.__Start5,
        4, LevelFuncs.__Start6,
        4, LevelFuncs.__Start7
    )
	
	EventSequence.Create(
        "lastSequence", --name
        false, --loop
        false, --timer table
        6, LevelFuncs.__Outro,
        10, LevelFuncs.__Outro2,
        12, LevelFuncs.__Outro3,
        8, LevelFuncs.__Outro4,
        11, LevelFuncs.__Outro5,
        20, LevelFuncs.__Outro6,
        18, LevelFuncs.LevelStats
    )
    
    Timer.Create(
		"FourBhudda", --name
		2, -- seconds
		false, -- loop
		false, -- timer table
		LevelFuncs.__PlayLaraFoundFourBuddha -- function
	)
end

function StartSequences()
	StartSequenceCamera()
	StartSequenceCamera2()
	StartSequence()
end

function StartSequenceCamera()
	if LevelVars.StartSequenceCamera then
		KeyClearAll()
		local Camera = GetCameraByName("startCamera")
		local Target = GetMoveableByName("startTarget")
		
		Camera:PlayCamera(Target)
	end
end

function StartSequenceCamera2()
	if LevelVars.StartSequenceCamera2 then
		KeyClearAll()
		local Camera = GetCameraByName("startCamera2")
		local Target = GetMoveableByName("startTarget2")
		
		Camera:PlayCamera(Target)
	end
end

function StartSequence()
	if LevelVars.StartSequence then
		LevelVars.StartSequence = false
		EventSequence.Get("startSequence"):Start()
	end
end

function LaraHasInfoAboutHealingPlants()
	LevelVars.LaraHasInfoAboutHealingPlants = true
end

function CheckForAllBuddhas()
	if GetItemCount(ObjID.PUZZLE_ITEM10) == 4 and not LevelVars.LaraHasFoundFourBhudda then
		LevelVars.LaraHasFoundFourBhudda = true
		
		local timer = Timer.Get("FourBhudda")
		timer:Start()
	end
end

LevelFuncs.__PlayLaraFoundFourBuddha = function(activator)
	if LevelVars.LaraHasInfoAboutHealingPlants then
		PlayNpcString("lara_found_four_buddha")
	end
end

LevelFuncs.CheckForFirstHealingPlant = function(activator)
	if LevelVars.LaraHasInfoAboutHealingPlants then
		PlayNpcString("lara_found_first_healing_plant")
	end
end

function PlayBackgroundAudios()

    local MaxAirValue = 1800
    local CurrentRoom = Lara:GetRoom()
    
    if not LevelVars.PlayNormalBackgroundAudio and not CurrentRoom:GetFlag(RoomFlagID.WATER) and Lara:GetAir() == MaxAirValue then
        LevelVars.PlayUnderwaterBackgroundAudio = false
        LevelVars.PlayNormalBackgroundAudio = true
        PlayAudioTrack("219-Jungle", SoundTrackType.LOOPED)
    end
    
    if not LevelVars.PlayUnderwaterBackgroundAudio and CurrentRoom:GetFlag(RoomFlagID.WATER) and Lara:GetAir() < MaxAirValue then
        LevelVars.PlayUnderwaterBackgroundAudio = true
        LevelVars.PlayNormalBackgroundAudio = false
        PlayAudioTrack("230-Jungle-Underwater", SoundTrackType.LOOPED)
    end
end

LevelFuncs.__Start = function()
	PlayNpcString("start1")
end

LevelFuncs.__Start2 = function()
	PlayNpcString("start2")
end

LevelFuncs.__Start3 = function()
	PlayNpcString("start3")
end

LevelFuncs.__Start4 = function()
	PlayNpcString("start4")
end

LevelFuncs.__Start5 = function()
	PlayNpcString("start5")
end

LevelFuncs.__Start6 = function()
	PlayNpcString("start6")
end

LevelFuncs.__Start7 = function()
	LevelVars.StartSequenceCamera = false
	LevelVars.StartSequenceCamera2 = true
	FlipMap(2)
end

LevelFuncs.StartFirstFlyBy = function()
	LevelVars.StartSequenceCamera2 = false
	PlayFlyBy(1)
	PlayNpcString("intro", true)
end

LevelFuncs.EnableMoveable = function(activator, objectName)
	GetMoveableByName(objectName):Enable()
end

LevelFuncs.DisableMoveable = function(activator, objectName)
	GetMoveableByName(objectName):Disable()
end

LevelFuncs.EnableRaisingBlock = function(activator, objectName)
	
	local obj = GetMoveableByName(objectName)
		
	if activator:GetObjectID() ~= ObjID.PUSHABLE_OBJECT8 
       and activator:GetObjectID() ~= ObjID.LARA 
       or LevelVars[objectName].enabled then
        return
    end

	if activator:GetObjectID() == ObjID.LARA and Lara:GetAirborne() == false then
		LevelVars[objectName].enabled = true
		obj:Enable()
	end
end

LevelFuncs.DisableRaisingBlock = function(activator, objectName)
	
	local obj = GetMoveableByName(objectName)
	Volume = GetVolumeByName('volume_' .. objectName)
	
	if activator:GetObjectID() ~= ObjID.PUSHABLE_OBJECT8 
       and activator:GetObjectID() ~= ObjID.LARA
       or not LevelVars[objectName].enabled then
        return
    end
    
    local pb1 = GetMoveableByName('pb1')
    local pb2 = GetMoveableByName('pb2')
    
    if (Volume:IsMoveableInside(pb1) or Volume:IsMoveableInside(pb2)) and activator:GetObjectID() == ObjID.LARA then
		return
	end
	
	LevelVars[objectName].enabled = false

	obj:Disable()
end


LevelFuncs.MakeLaraWet = function(activator)
	Lara:SetWet(200)
end

LevelFuncs.__OnMonkeyHit = function(monkey)
	if monkey:GetHP() < 1 then
		GameVars.KilledMonkeys = GameVars.KilledMonkeys + 1
		PlayNpcString("lara_killed_monkey")
		SetKairiDialogWhenLaraKillsMonkey()
	end
end

LevelFuncs.__OnFirstTigerKill = function(tiger)
	PlayNpcString("lara_kills_first_jaguar")
end

LevelFuncs.__LaraObserve = function(activator)
	PlayNpcString("lara_observe")
end

LevelFuncs.RaftNotWorking = function()
	PlayNpcString("lara_raft_dont_work")
end

LevelFuncs.DangerBelow = function()
	PlayNpcString("lara_danger_below")
end

LevelFuncs.CaveJump = function()
	PlayNpcString("lara_cave_jump")
end

LevelFuncs.DisableCaveJump = function()
	print("here")
	local volume = GetVolumeByName("lara_cave_jump")
    volume:Disable()
end

LevelFuncs.StartRaft = function()
	LevelVars.WorkingRaft = LevelVars.WorkingRaft + 1
end

LevelFuncs.StartRaft2 = function()
	LevelVars.WorkingRaft = LevelVars.WorkingRaft + 1
end

LevelFuncs.StartRaft3 = function()
	LevelVars.WorkingRaft = LevelVars.WorkingRaft + 1
end

LevelFuncs.CloseUnderWaterTrapdoor = function()
	GetMoveableByName("Underwater_Trapdoor"):Disable()
end

LevelFuncs.SpikyPassage = function(activator)
	GetMoveableByName("spiky_ceiling_1807"):Enable()
	GetMoveableByName("spiky_ceiling_1808"):Enable()
	GetMoveableByName("spiky_ceiling_1811"):Enable()
	GetMoveableByName("spiky_wall_1806"):Enable()
end

LevelFuncs.SpikyFloor = function(activator)
	GetMoveableByName("spiky_ceiling_1865"):Enable()
	GetMoveableByName("spiky_ceiling_1866"):Enable()
	GetMoveableByName("spiky_ceiling_1867"):Enable()
	GetMoveableByName("spiky_ceiling_1868"):Enable()
end

LevelFuncs.ShowCameraAtSpikyFloor = function(activator)
	local Camera = GetCameraByName("camera_spiky_floor")
	Camera:PlayCamera()
end

LevelFuncs.ShowCameraAtClimbingRoute = function(activator)
	local Camera = GetCameraByName("camera_climbing_route")
	Camera:PlayCamera()
end

LevelFuncs.ShowCameraAtElephant = function(activator)
	local Camera = GetCameraByName("camera_elephant")
	Camera:PlayCamera(GetMoveableByName("CameraTargetElephant"))
end

LevelFuncs.ShowCameraAtTightRope = function(activator)
	if Lara:GetState() > 119 then
		PlayAudioTrack("150-Ancient-Empires-And-Civilizations", SoundTrackType.ONESHOT)
		local Camera = GetCameraByName("camera_tight_rope")
		Camera:PlayCamera()
	end
end

LevelFuncs.ShowCameraAtShivaStatue = function(activator)
	local Camera = GetCameraByName("camera_shiva_statue")
	Camera:PlayCamera()
end

LevelFuncs.LaraFoundFirstSecret = function(activator)
	PlayNpcString("lara_found_first_secret")
end

LevelFuncs.LaraFoundShotgun = function(activator)
	PlayNpcString("lara_found_shotgun")
end

LevelFuncs.LaraFoundUzi = function(activator)
	PlayNpcString("lara_found_uzi")
end

LevelFuncs.LaraFoundUziTwo = function(activator)
	PlayNpcString("lara_found_uzi_two")
end

LevelFuncs.LaraFoundRevolver = function(activator)
	PlayNpcString("lara_found_revolver")
end

LevelFuncs.LaraFoundCrowbar = function(activator)
	PlayNpcString("lara_found_crowbar")
end

LevelFuncs.LaraFoundDeepCave = function(activator)
	PlayNpcString("lara_found_deep_cave")
end

LevelFuncs.LaraTightRope = function(activator)
	if Lara:GetState() > 119 and not LevelVars.LaraTightrope then
		LevelVars.LaraTightrope = true
		PlayNpcString("lara_tightrope")
	end
end

-- Move the round table with Item up
LevelFuncs.MovePedestalUp = function(activator)
	local items = {
        "PuzzleItem9MoveUp","PedestalMoveUp"
    }
	for index, item in pairs(items) do
    	LevelFuncs.Engine.Node.ChangeMoveablePositionOverTimespan(item, TEN.Vec3(0,-768,0), true, 6, true)
    end
    PlaySound(2012)
end

LevelFuncs.RemoveCollisionFromSASDragBloke = function(activator)
	if activator:GetObjectID() ~= ObjID.SAS_DRAG_BLOKE and LevelVars.SASDragBlokeCollision then
		return
	end
	LevelVars.SASDragBlokeCollision = false
	GetMoveableByName("SasDragBloke"):SetCollidable(false)
end

LevelFuncs.StartTimerForDoorAfterKeyHole1 = function(activator)
	local timer = Timer.Get("openDoorAfterKeyHole1")
	timer:Start()
end

LevelFuncs.__OpenDoorAfterKeyHole1 = function(activator)
	GetMoveableByName("DoorAfterKeyHole1"):Enable()
end

LevelFuncs.__CollidedWithStaticSpikes = function(obj1, obj2)
	local healthpointsLostPerFrame = 5
	
	if obj2:GetObjectID() ~= ObjID.LARA then
		return
	end
	
	PlaySound(31,obj2:GetPosition())
	EmitBlood((obj2:GetJointPosition(math.random(0,14))),20)
	obj2:SetHP(obj2:GetHP() - healthpointsLostPerFrame)
end

function SetCollideWithStaticSpikes()
	local moveableSlots = {
        1224 --'ANIMATING25'
    }
    for index, moveableSlot in pairs(moveableSlots) do
        local moveables = GetMoveablesBySlot(moveableSlot)
        for index, moveable in pairs(moveables) do
            moveable:SetOnCollidedWithObject(LevelFuncs.__CollidedWithStaticSpikes)
        end
    end
end

function CheckForWorkingRaft()

	if LevelVars.WorkingRaft >= 3 then
		PlayNpcString("lara_raft_work")
		
		LevelVars.WorkingRaft = 0
		
		local volumeRaftDontWork = GetVolumeByName("lara_raft_dont_work")
	    volumeRaftDontWork:Disable()
	    	
	    local volumeMoveRaft = GetVolumeByName("move_raft")
	    volumeMoveRaft:Enable()
	    
	    GameVars.WorkingRaft = 0
	end
end

LevelFuncs.MoveRaft = function()
	local Door = GetMoveableByName("door_after_raft")
	Door:Enable()
	PlayFlyBy(2)
	PlayAudioTrack("100-Flow-of-Nature")
	PlaySound(2008)
	LevelFuncs.Engine.Node.ChangeMoveablePositionOverTimespan("raft", TEN.Vec3(5888,0,0), true, 15, true)
	LevelFuncs.Engine.Node.ChangeMoveablePositionOverTimespan("raft2", TEN.Vec3(5888,0,0), true, 15, true)
	LevelFuncs.Engine.Node.ChangeMoveablePositionOverTimespan("raft3", TEN.Vec3(5888,0,0), true, 15, true)
end

LevelFuncs.TrailAmmo = function()
	PlayNpcString("trail_ammo")
end

LevelFuncs.CheckBurnFirerope = function()

	if Lara:TorchIsLit() and KeyIsHit(ActionID.ACTION) and LevelVars.UseFireRope == false then
		
		Lara:SetAnim(430)
		PlayNpcString("lara_broke_elephant")
		
		local volumeObj = GetVolumeByName("volume_camera_elephant")
    	volumeObj:Enable()
		
		local Firerope = GetMoveableByName("Firerope")
		Firerope:SetEffect(EffectID.FIRE)

		local FireropeTimer  = EventSequence.Create("FireropeTimer",
	        false, -- kein Loop Modus
	        {seconds = false, deciseconds = false},
	        6, LevelFuncs.FireBurnedRope,
	        6, LevelFuncs.__DisableElephantCamera
	    )
	    
	    FireropeTimer:Start()

	end
end

LevelFuncs.FireBurnedRope = function()
	local Firerope = GetMoveableByName("Firerope")
	local Rollingball = GetMoveableByName("RollingBallBreakElephant")
	
	Firerope:Shatter()
	Rollingball:Enable()
	LevelVars.UseFireRope = true
	
end

LevelFuncs.BrokeElephant = function()
	local Elephant = GetStaticByName("Elephant")
	Elephant:Shatter()
	
	local Rollingball = GetMoveableByName("RollingBallBreakElephant")
	Rollingball:Shatter()
	PlaySound(1135)
	
	
end

LevelFuncs.__DisableElephantCamera = function()
	local volumeObj = GetVolumeByName("volume_camera_elephant")
    volumeObj:Disable()
end

LevelFuncs.BrokeRollingBallEvent = function()
	
	local BrokeRollingBallEvent = EventSequence.Create("BrokeRollingball",
        false, -- kein Loop Modus
        {seconds = false, deciseconds = false},
        0, LevelFuncs.BrokeRollingball,
        0.5, LevelFuncs.EnableFlipmapOne
    )
    
    BrokeRollingBallEvent:Start()
end

LevelFuncs.BrokeRollingball = function()
	local RollingballFloorCrash = GetMoveableByName("RollingballFloorCrash")
	RollingballFloorCrash:Shatter()
end

LevelFuncs.EnableFlyByZero = function()
	PlayFlyBy(0)
end

LevelFuncs.EnableFlipmapOne = function()
	FlipMap(1)
end

LevelFuncs.ObserveLaraBeginning = function()
	GetMoveableByName("observer_start1"):Destroy()
	GetMoveableByName("observer_start2"):Destroy()
	GetMoveableByName("startHeli"):Destroy()
	GetSoundSourceByName("startHeliSound"):SetPosition(Vec3(137728, -19200, 182784))
end

LevelFuncs.ObserveLara = function()
	GetMoveableByName("observer"):Destroy()
	GetMoveableByName("observer2"):Destroy()
	
	local timer = Timer.Get("laraObserve")
	timer:Start()
end

LevelFuncs.PostUseFunction = function(objectNumber)
	
	-- Heal Lara with Herbs
	if objectNumber == ObjID.PUZZLE_ITEM16 then
		if Lara:GetPoison() > 0 then
		
			TEN.Inventory.ClearUsedItem()
			PlaySound(116)
			Lara:SetPoison(0)
			
			TakeItem(ObjID.PUZZLE_ITEM16)
		end
	end
	
	-- Shotgun Puzzle Item 6 is not used, because it will change to SHOTGUN_ITEM
	if objectNumber == ObjID.PUZZLE_ITEM6 then
		TEN.Inventory.ClearUsedItem()
	end
end

LevelFuncs.InteractWithNpc = function(activator, npcIdentifier)
	InteractWithNpc(
		npcIdentifier, 
		GameVars.Npcs[npcIdentifier]["npcName"],
		GameVars.Npcs[npcIdentifier]["text"],
		GameVars.Npcs[npcIdentifier]["noAudio"],
		GameVars.Npcs[npcIdentifier]["displayTextDuration"],
		GameVars.Npcs[npcIdentifier]["startDirectly"],
		GameVars.Npcs[npcIdentifier]["dontConfirm"],
		GameVars.Npcs[npcIdentifier]["npcNameColor"],
		GameVars.Npcs[npcIdentifier]["textColor"],
		GameVars.Npcs[npcIdentifier]["confirmText"],
		GameVars.Npcs[npcIdentifier]["confirmTextColor"],
		GameVars.Npcs[npcIdentifier]["nextVolume"],
		GameVars.Npcs[npcIdentifier]["preCallFunction"],
		GameVars.Npcs[npcIdentifier]["callFunction"],
		GameVars.Npcs[npcIdentifier]["npcNameStringX"],
		GameVars.Npcs[npcIdentifier]["npcNameStringY"],
		GameVars.Npcs[npcIdentifier]["npcTextStringX"],
		GameVars.Npcs[npcIdentifier]["npcTextStringY"],
		GameVars.Npcs[npcIdentifier]["npcConfirmTextStringX"],
		GameVars.Npcs[npcIdentifier]["npcConfirmTextStringY"],
		GameVars.Npcs[npcIdentifier]["alternateAudio"]
	)
end

LevelFuncs.StopInteractWithNpc = function(activator, callFunction)
	StopInteractWithNpc(callFunction)
end
 
LevelFuncs.InteractWithMerchant = function(activator, MerchantIdentifier)
    InteractWithMerchant(
        MerchantIdentifier,
        GameVars.Merchants[MerchantIdentifier]["BuyItemName"],             			-- Name of the item for buying
        GameVars.Merchants[MerchantIdentifier]["BuyItemValue"],            			-- Amount of items for buying
        GameVars.Merchants[MerchantIdentifier]["BuyItemSlot"],             			-- Slot of buy item
        GameVars.Merchants[MerchantIdentifier]["BuyItemLimit"],            			-- Limit for buy item
        GameVars.Merchants[MerchantIdentifier]["BuyItemVisibleItem"],          		-- Placeholder item slot for buy item
        GameVars.Merchants[MerchantIdentifier]["BuyAnimation"],         			-- Animation for Lara after buying
        GameVars.Merchants[MerchantIdentifier]["PaymentItemName"],      			-- Item name for payment
        GameVars.Merchants[MerchantIdentifier]["PaymentItemSlot"],      			-- Item slot for payment
        GameVars.Merchants[MerchantIdentifier]["PaymentItemCost"],      			-- Costs for buying item
        GameVars.Merchants[MerchantIdentifier]["AskForBuyingText"],    				-- First text for buying
        GameVars.Merchants[MerchantIdentifier]["TradeString"],    					-- Text with buy and pay values
        GameVars.Merchants[MerchantIdentifier]["ActionYes"],    					-- Text for button interactions (yes)
        GameVars.Merchants[MerchantIdentifier]["ActionNo"],    						-- Text for button interactions (no)
        GameVars.Merchants[MerchantIdentifier]["ThanksText"],           			-- Text when Lara buys it
        GameVars.Merchants[MerchantIdentifier]["ThanksTextDuration"],    			-- Duration of text when Lara buys it
        GameVars.Merchants[MerchantIdentifier]["NotEnoughMoneyText"],    			-- Text if Lara doesn't have enough money
        GameVars.Merchants[MerchantIdentifier]["NotEnoughMoneyTextDuration"], 		-- Duration of text if Lara doesn't have enough money
        GameVars.Merchants[MerchantIdentifier]["NextTimeText"],         			-- Text when Lara doesn't buy it
        GameVars.Merchants[MerchantIdentifier]["NextTimeTextDuration"],  			-- Duration of text when Lara doesn't buy it
        GameVars.Merchants[MerchantIdentifier]["BuyLimitReachedText"],   			-- Text when Lara reaches the buy limit
        GameVars.Merchants[MerchantIdentifier]["BuyLimitReachedTextDuration"], 		-- Duration of text when Lara reaches the buy limit
        GameVars.Merchants[MerchantIdentifier]["MerchantName"], 					-- Name of the Merchant
        GameVars.Merchants[MerchantIdentifier]["BuyItemValueRandomFrom"], 			-- Random Amount of Buy Item (From Value)
        GameVars.Merchants[MerchantIdentifier]["BuyItemValueRandomTo"] 				-- Random Amount of Buy Item (To Value)
    )
end

LevelFuncs.StopInteractWithMerchant = function(activator)
	StopInteractWithMerchant()
end

LevelFuncs.AddSecret = function(activator, secret)
	AddSecret(tonumber(secret))
end

function SetStaticsSoftCollision()
	local staticSlots = {
		0,2,4,5,6,7,11,12,13,15,17,18,20,21,22,23,32,33,34,36,37,38,39,42,43,45,47,48,49,50,52,65,67,70,71,72,73,74,78,79,80,81,82,83,85,86,87,89,90,91,98,99,100,102,103,111,118,119,129,130,140,146,148,174,175,183,188,193,195,199,206,209,210,903
	}
	
	for index, staticSlot in pairs(staticSlots) do
		local statics = GetStaticsBySlot(staticSlot)
		
		for index, static in pairs(statics) do
		    static:SetSolid(false)
		end
	end
end

function ExchangePuzzleItem6()
	local brokenShotgunCombined = ObjID.PUZZLE_ITEM6
	local npcIdentifier = "lara_shotgun_repair"
	
	if GetItemCount(brokenShotgunCombined) > 0 then
		GiveItem(ObjID.SHOTGUN_ITEM)
		TakeItem(brokenShotgunCombined)
		
		PlayNpcString(npcIdentifier)
	end 
end

function SetDialogWhenLaraHasToolbox()
	local toolbox = ObjID.PUZZLE_ITEM6_COMBO2
	
	if GetItemCount(toolbox) > 0 then
		if Language == 'EN' then
			GameVars.Merchants.merchant_jon_shotgun.LimitAlternate = 'limitAlternate'
			GameVars.Merchants.merchant_jon_shotgun.BuyLimitReachedText = [[
Ohhh - right, almost forgot – the shotgun’s broken. 
But as I can see, you've already found my toolbox.
I think you can use it to fix it.
Again. Sorry about that.
        ]]
		end
		
		if Language == 'DE' then
			GameVars.Merchants.merchant_jon_shotgun.LimitAlternate = 'limitAlternate'
			GameVars.Merchants.merchant_jon_shotgun.BuyLimitReachedText = [[
Ach ja, fast vergessen – die Schrotflinte ist leider kaputt. 
Aber wie ich sehe, hast du schon meinen 
Werkzeugkasten gefunden. Ich denke du 
kannst sie damit reparieren.
Sorry.
        ]]
		end
	end
end

function SetDialogWhenLaraHasShotgun()
	local shotgun = ObjID.SHOTGUN_ITEM
	
	if GetItemCount(shotgun) > 0 then
		if Language == 'EN' then
			GameVars.Merchants.merchant_jon_shotgun.LimitAlternate = 'limitAlternate2'
			GameVars.Merchants.merchant_jon_shotgun.BuyLimitReachedText = [[
Wow. You now have a shotgun?
Maybe its time to rumble this jungle.
Maybe we'll see each other again.
        ]]
		end
		
		if Language == 'DE' then
			GameVars.Merchants.merchant_jon_shotgun.LimitAlternate = 'limitAlternate2'
			GameVars.Merchants.merchant_jon_shotgun.BuyLimitReachedText = [[
Perfekt. Du hast nun eine Schrotflinte.
Dann mach den Dschungel damit unsicher!
Wir sehen uns vielleicht nochmal wieder.
        ]]
		end
	end 
end

function SetKairiDialogWhenLaraKillsMonkey()
	GameVars.Npcs.kairi_3.nextVolume = 'kairi_4a'
end

function GiveKeyItem3()
	GiveItem(ObjID.KEY_ITEM3, 1, true)
end

function AddLastSecret()
	if GameVars.KilledMonkeys == 0 then
		GiveItem(ObjID.PICKUP_ITEM3, 1, true)
		AddSecret(9)
	end
end

function CheckForEndGame()
	if not LevelVars.LaraHasEndGame then
		local LastArtefakt = ObjID.PICKUP_ITEM2
		if GetItemCount(LastArtefakt) > 0 then
		
			local MerchantKairiVolume = GetVolumeByName("merchant_kairi")
    		MerchantKairiVolume:Disable()
    		
    		local Kairi6Volume = GetVolumeByName("kairi_6")
    		Kairi6Volume:Enable()
    		
    		LevelVars.LaraHasEndGame = true
    		
		end
	end
end

function EndGame()
	local Teleporter = GetMoveableByName("teleporter_end")

	-- Move Lara zum Teleporter
	Lara:SetPosition(Teleporter:GetPosition())
	Lara:SetRotation(Teleporter:GetRotation())
	
	PlayFlyBy(5)
	PlayAudioTrack("155-Echoes-In-The-Shadowed-Realms", SoundTrackType.ONESHOT)
end

LevelFuncs.FinishLevelSequence = function()
	EventSequence.Get("lastSequence"):Start()
end

LevelFuncs.LaraKneeling = function()
	Lara:SetAnim(17, ObjID.LARA_EXTRA_ANIMS)
end

LevelFuncs.TextEnd = function()
	PlayNpcString("end")
end

LevelFuncs.TextEnd2 = function()
	PlayNpcString("end2")
end

LevelFuncs.TextEnd3 = function()
	PlayNpcString("end3")
end

LevelFuncs.__Outro = function()
	PlayNpcString("outro", true)
end

LevelFuncs.__Outro2 = function()
	PlayNpcString("outro2", true)
end

LevelFuncs.__Outro3 = function()
	PlayNpcString("outro3", true)
end

LevelFuncs.__Outro4 = function()
	PlayNpcString("outro4", true)
end

LevelFuncs.__Outro5 = function()
	PlayNpcString("outro5", true)
end

LevelFuncs.__Outro6 = function()
	PlayNpcString("outro6", true)
end

LevelFuncs.Test = function()
	PlayNpcString("outro4", true)
end

-- Level Statistics Screen. Code by Stranger1992 and TrainWreck.

LevelFuncs.LevelStats = function()

    TEN.Logic.AddCallback(TEN.Logic.CallbackPoint.PREFREEZE,LevelFuncs.EndLevelStats)
    -- Make game greyscale
    TEN.View.SetPostProcessMode(PostProcessMode.MONOCHROME)
    TEN.View.SetPostProcessStrength(1.0)
    TEN.View.SetPostProcessTint(Color(25,50,25))
    Flow.SetFreezeMode(Flow.FreezeMode.SPECTATOR)
    TEN.Input.KeyClearAll()

end

LevelFuncs.EndLevelStats = function()
    -- Move to next level or next Lara Start Pos when ACTION is pressed
    
    if TEN.Input.KeyIsHit(ActionID.ACTION) then 
        
        TEN.Logic.RemoveCallback(TEN.Logic.CallbackPoint.PREFREEZE,LevelFuncs.EndLevelStats)
        Flow.SetFreezeMode(Flow.FreezeMode.NONE)
        TEN.View.FadeOut()
        
	    -- GRAPHICS    
	    --[[
	    local bg = DisplaySprite(
			ObjID.BAR_BORDER_GRAPHIC,
			1,
			Vec2(50,48),
			0,
			Vec2(60,60),
			Color(20,157,0,128)	
		)
		
		bg:Draw(0, View.AlignMode.CENTER, View.ScaleMode.STRETCH,Effects.BlendID.ADDITIVE)
		]]
	    EndLevel(99) --Add number of level here as an argument.
	    return
	end
    	-- Draw Borders

    LevelFuncs.ShowLevelStats()
end

function PlayAudio153()
	PlayAudioTrack("153-Kairi_Sequence", SoundTrackType.ONESHOT)
end

LevelFuncs.ShowLevelStats = function()

    local levelStats = Flow.GetStatistics()
    local level = Flow.GetCurrentLevel()

    -- Define transformations of elements (done with screen percentage to accommodate different aspect ratios)
    
	-- text 	    
    local levelNameX, levelNameY = PercentToScreen(50, 20) -- Position
    local headingsX, headingsY = PercentToScreen(25, 30)   -- Position
    local dataX, dataY = PercentToScreen(65, 30.5)         -- Position
    local controlX,controlY = PercentToScreen(50,90)       -- Position
    
    -- borders
    
    local mainBorderX, mainBorderY = PercentToScreen(50,50)	-- Position
    local mainBorderScaleX, mainBorderScaleY = Vec2(100,100)

    -- Define color of text (RGBA)
    local textColor = Color(255, 255, 255, 255)
    
    local textColorGreen = Color(0,155,75)

    -- Define scale of text (float)
    local textScale = 1

    -- DisplayStrings
    -- Set up all constant text fields (i.e., things that won't change)
    local headings = DisplayString(
        "Time Taken\nSecrets\nPickups\nKills\nAmmo Used\nMedipacks Used\nDistance Travelled",
        Vec2(headingsX, headingsY),
        textScale, -- text scale (x%, y%)
        textColor, -- text color (RGBA)
        false -- used for translations.
    )

    -- Correctly define and display stats
    local levelName = DisplayString(
        tostring(Flow.GetString(level.nameKey)), -- Gets current level name as defined in Gameflow.lua
        Vec2(levelNameX, levelNameY), -- text position (x%, y%)
        textScale, -- text scale (x%, y%)
        textColor, -- text color (RGBA)
        false -- used for translations.
    )

    local stats = DisplayString(
        tostring(levelStats.timeTaken):sub(1, -4) .. "\n" ..
        tostring(Flow.GetSecretCount()) .. " / " .. tostring(Flow.GetTotalSecretCount()) .. "\n" ..
        tostring(levelStats.pickups) .. "\n" ..
        tostring(levelStats.kills) .. "\n" ..
        tostring(levelStats.ammoUsed) .. "\n" ..
        tostring(levelStats.healthPacksUsed) .. "\n" ..
        string.format("%.1f", levelStats.distanceTraveled / 420) .. " m",
        Vec2(dataX, dataY),
        textScale, -- text scale (x%, y%)
        textColor, -- text color (RGBA)
        false -- used for translations.
    )
    
	local controlText = "Press ACTION to continue"
	
	if Language == 'DE' then
	    controlText = "Drücke AKTION um fortzufahren"
	end
	
	local control = DisplayString(
	    controlText,
	    Vec2(controlX, controlY),
	    textScale / 2, -- text scale (x%, y%)
	    textColorGreen, -- text color (RGBA)
	    false -- used for translations.
	)

    -- Set text effects
    levelName:SetFlags({ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW })
    headings:SetFlags({ TEN.Strings.DisplayStringOption.SHADOW })
    stats:SetFlags({ TEN.Strings.DisplayStringOption.SHADOW })
    control:SetFlags({ TEN.Strings.DisplayStringOption.SHADOW, TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.BLINK })

    -- Show strings
    ShowString(levelName, 1 / 30 ) 
    ShowString(headings, 1 / 30 )
    ShowString(stats, 1 / 30 )
    ShowString(control, 1 / 30 )
    
    --[[
	local bg = DisplaySprite(
		ObjID.BAR_BORDER_GRAPHIC,
		1,
		Vec2(50,48),
		0,
		Vec2(60,60),
		Color(20,157,0,128)	
	)
	
	bg:Draw(0, View.AlignMode.CENTER, View.ScaleMode.STRETCH,Effects.BlendID.ADDITIVE)
	]]
end