-- FILE: \Npc.lua
-- function when Lara is inside the volume box

local npcName
local npcText
local displayTextDuration
local npcNameColor
local npcTextColor
local npcTextString
local npcNameStringX
local npcNameStringY
local npcTextStringX
local npcTextStringY
local npcConfirmTextStringX
local npcConfirmTextStringY
local noAudio
local alternateAudio

function InteractWithNpc(
	npcIdentifier, 
	npcName,
	npcText,
	noAudio,
	displayTextDuration,
	startDirectly,
	dontConfirm,
	npcNameColor,
	npcTextColor,
	confirmText,
	confirmTextColor,
	nextVolume,
	preCallFunction,
	callFunction,
	npcNameStringX,
	npcNameStringY,
	npcTextStringX,
	npcTextStringY,
	npcConfirmTextStringX,
	npcConfirmTextStringY,
	alternateAudio
)

	if GameVars.StartDialog then
		KeyClear(ActionID.LOOK)
		KeyClear(ActionID.DRAW)
		KeyClear(ActionID.CROUCH)
		KeyClear(ActionID.JUMP)
		KeyClear(ActionID.ROLL)

		SetPostProcessMode(PostProcessMode.MONOCHROME)
		SetPostProcessStrength(0.8)
		SetPostProcessTint(Color(200,200,200))
		
	end
	
    -- if ACTION is hit and Lara has not Start the dialog    
    if startDirectly or (KeyIsHit(GameVars.StartKey) and not GameVars.StartDialog and Lara:GetHandStatus() == 0) then
		
		if preCallFunction and _G[preCallFunction] then
	    	_G[preCallFunction]()
		end
	
		-- hide previously strings
    	HideAllDisplayStrings()
    	
		if not noAudio then
			if not alternateAudio then
				PlayAudioTrack(Language .. "/npc/" .. npcIdentifier, SoundTrackType.VOICE)
			else
				PlayAudioTrack(Language .. "/npc/" .. alternateAudio, SoundTrackType.VOICE)
			end
		end
    	
    	-- NPC Name String
    	npcNameStringX = npcNameStringX or 10
    	npcNameStringY = npcNameStringY or 10
		local x1, y1 = PercentToScreen(npcNameStringX, npcNameStringY)
    	npcNameColor = npcNameColor or Color(255, 200, 0)
    	if npcName then
    		DisplayStrings.npcNameString = DisplayString(npcName, x1, y1, npcNameColor)
    	end
    	
    	-- NPC Text String
    	npcTextStringX = npcTextStringX or 10
    	npcTextStringY = npcTextStringY or 15
    	local x2, y2 = PercentToScreen(npcTextStringX, npcTextStringY)
    	npcTextColor = npcTextColor or Color(255, 255, 255)
    	DisplayStrings.npcTextString = DisplayString(npcText, x2, y2, npcTextColor)
    	
    	displayTextDuration = displayTextDuration or nil

        -- Show the strings
        if DisplayStrings.npcNameString and (noAudio or Subtitles) then
        	ShowString(DisplayStrings.npcNameString, displayTextDuration)
        end
        
        if DisplayStrings.npcTextString and (noAudio or Subtitles) then
        	ShowString(DisplayStrings.npcTextString, displayTextDuration)
        end
        
        if not dontConfirm then
        	-- Set Cine Bars
        	SetCineBars(GameVars.CineBarsWeight, GameVars.CineBarsCreationSpeed) 
        	
    		-- NPC Confirm String
	    	npcConfirmTextStringX = npcConfirmTextStringX or 10
	    	npcConfirmTextStringY = npcConfirmTextStringY or 75
	    	local x3, y3 = PercentToScreen(npcConfirmTextStringX, npcConfirmTextStringY)
    		confirmTextColor = confirmTextColor or Color(255, 255, 255)
    		DisplayStrings.npcConfirmTextString = DisplayString(confirmText, x3, y3, confirmTextColor, false, {Strings.DisplayStringOption.SHADOW, Strings.DisplayStringOption.BLINK})
    		ShowString(DisplayStrings.npcConfirmTextString, displayTextDuration)
    		
    		-- Start dialog
        	GameVars.StartDialog = true
    	end
	elseif KeyIsHit(GameVars.ConfirmKey) and GameVars.StartDialog and Lara:GetHandStatus() == 0 then
    	StopInteractWithNpc(npcIdentifier, nextVolume, callFunction)
    end
end

-- function when Lara leave the volume box
function StopInteractWithNpc(npcIdentifier, nextVolume, callFunction)
	
	StopAudioTrack(SoundTrackType.VOICE)
	GameVars.StartDialog = false
	
	SetPostProcessMode(PostProcessMode.NONE)

    -- remove cinebars (set 0 with speed of 90)
    SetCineBars(0, GameVars.CineBarsCreationSpeed)
    -- hide strings
    HideAllDisplayStrings()
	
	-- set next Dialog
	if npcIdentifier and nextVolume then
		local volumeObjCurrent = GetVolumeByName(npcIdentifier)
		volumeObjCurrent:Disable()
		local volumeObjNext = GetVolumeByName(nextVolume)
		volumeObjNext:Enable()
	end
    
    if callFunction and _G[callFunction] then
    	_G[callFunction]()
	end
end

