local frameCounter = 0
local frameInterval = 2  -- Anzahl der Frames, nach denen die Partikel spawnen

function AddFireParticles()
    -- Erst prüfen, ob Partikel-Logik ausgeführt werden soll
    frameCounter = frameCounter + 1  
    if frameCounter < frameInterval then
        return
    end
    frameCounter = 0  -- Zähler zurücksetzen
    
    -- ######################################################
    -- ################### Customizing ######################
    -- ######################################################
    local staticStartSlots = {}
    local moveableStartSlots = { 359,360 }
    
    local positionTolerance = { x = 64, y = 128, z = 64 }
    local spriteIndex = {0}
    local gravityMax = -9
    local rotationMax = 1
    local colorFrom = Color(255,128,0)
    local colorTo = Color(255,128,0)
    local mode = TEN.Effects.BlendID.SCREEN
    local startSize = 3 -- must be higher value than endsize
    local endSize = 2 -- must be lower value than endsize
    local lifeTime = 2
    local distanceFromLara = 6144

    -- ######################################################
    -- ########### End Customizing ##########################
    -- ######################################################
    local objectsForParticles = {}

	-- Statische Objekte sammeln
    for _, slot in pairs(staticStartSlots) do
        for _, obj in pairs(GetStaticsBySlot(slot)) do
            if CalculateDistance(obj:GetPosition(), Lara:GetPosition()) < distanceFromLara then
                table.insert(objectsForParticles, obj)
            end
        end
    end

    -- Bewegliche Objekte sammeln
    for _, slot in pairs(moveableStartSlots) do
        for _, obj in pairs(GetMoveablesBySlot(slot)) do
            if CalculateDistance(obj:GetPosition(), Lara:GetPosition()) < distanceFromLara then
                table.insert(objectsForParticles, obj)
            end
        end
    end

    for _, obj in pairs(objectsForParticles) do
        local pos = obj:GetPosition()

        -- Zufällige Abweichungen für Position
        local x = pos.x + math.random(-positionTolerance.x, positionTolerance.x)
        local y = pos.y - 512 + math.random(-positionTolerance.y, positionTolerance.y)
        local z = pos.z + math.random(-positionTolerance.y, positionTolerance.y)
		
		local gravity = math.random(gravityMax, -3)
        rotation = math.random(0, rotationMax)
        local size = math.random(endSize, startSize)

        EmitParticle(
            Vec3(x, y, z), -- Startposition
            Vec3(0, -5, 0), -- Geschwindigkeit
            spriteIndex[math.random(1, #spriteIndex)], -- Sprite-Index
            gravity, -- Gravitation
            rotation, -- Rotation
            colorFrom, -- Startfarbe
            colorTo, -- Endfarbe
            mode, -- Blend-Modus
            size, -- Startgröße
            size, -- Endgröße
            lifeTime, -- Lebensdauer
            false, -- Schaden
            false -- Gift
        )
    end
end
