-- FILE: \General.lua
require("GameVars")
require("Npc")
require("Merchant")
require("DustParticles")
require("LeaveParticles")
require("FireParticles")

function DeathEffect()
   local noEffectUntilHealthPercentage = 0.33 -- Damit sind 33% gemeint - unter diesem Wert soll die Farbsättigung abnehmen
   local maxHealth = 1000 -- Laras maximale Gesundheit
   local currentHealth = Lara:GetHP() -- Hole Laras aktuelle Gesundheit
   -- Kalkuliere die aktuelle Prozentzahl von Laras Gesundheit
   local healthPercentage = currentHealth / maxHealth
    
   -- Kalkuliere den Farbsättigung, 0 ist schwarz weiß, 1 ist normal
   local saturation
   if healthPercentage < noEffectUntilHealthPercentage then
       saturation = 1 - (healthPercentage / noEffectUntilHealthPercentage)
   else
       saturation = 0  -- Kein Effekt über den Prozentwert von noEffectUntilHealthPercentage
   end
   -- Setze die Farbsättigung
   LevelFuncs.Engine.Node.SetPostProcessDisplay(1, saturation, TEN.Color(128, 128, 128))
end

function TestItems()
	GiveItem(ObjID.CROWBAR_ITEM,1)
	GiveItem(ObjID.KEY_ITEM1,1)
	GiveItem(ObjID.KEY_ITEM3,1)
	GiveItem(ObjID.KEY_ITEM4,1)
	GiveItem(ObjID.KEY_ITEM5,1)
	GiveItem(ObjID.KEY_ITEM6,1)
	GiveItem(ObjID.PICKUP_ITEM2,1)
	GiveItem(ObjID.PICKUP_ITEM3,1)
	GiveItem(ObjID.PUZZLE_ITEM1,1)
	GiveItem(ObjID.PUZZLE_ITEM2,2)
	GiveItem(ObjID.PUZZLE_ITEM3,1)
	GiveItem(ObjID.PUZZLE_ITEM5,3)
	GiveItem(ObjID.PUZZLE_ITEM6_COMBO1,1)
	GiveItem(ObjID.PUZZLE_ITEM6_COMBO2,1)
	GiveItem(ObjID.PUZZLE_ITEM7_COMBO1,1)
	GiveItem(ObjID.PUZZLE_ITEM7_COMBO2,1)
	GiveItem(ObjID.PUZZLE_ITEM9,1)
	GiveItem(ObjID.PUZZLE_ITEM10,4)
	GiveItem(ObjID.PUZZLE_ITEM12,1)
	GiveItem(ObjID.PUZZLE_ITEM16,10)
	GiveItem(ObjID.SHOTGUN_ITEM,1)
end

function HideAllDisplayStrings()
	for index, value in pairs(DisplayStrings) do
		if value then
			HideString(value)
		end
	end
end

function PlayNpcString(npcIdentifier, noAudio)
	
	InteractWithNpc(
		npcIdentifier,
		GameVars.Npcs[npcIdentifier]["npcName"],
		GameVars.Npcs[npcIdentifier]["text"],
		noAudio,
		GameVars.Npcs[npcIdentifier]["displayTextDuration"],
		true, --start directly
		true, --dont confirm,
		GameVars.Npcs[npcIdentifier]["npcNameColor"] or nil, --NPC Name Color
		GameVars.Npcs[npcIdentifier]["textColor"] or nil --Text Color
	)
end

function ShowAmmoCounter()
    local handStatus = Lara:GetHandStatus()
    local weaponType = Lara:GetWeaponType()
    local ammo_type
    local zero_ammo = 0
    local ammo_text_counter = 0    

    if (Lara:GetAmmoCount() == -1) then
        unlimited = true
        ammo_text_counter = ""
        zero_ammo = 2
        ammo_type = 1
    else 
    	if Lara:GetWeaponType() ~= WeaponType.FLARE and Lara:GetWeaponType() ~= WeaponType.TORCH and Lara:GetHandStatus() == 4 then
	        ammo_type = Lara:GetAmmoType()
	        unlimited = false
		    if (Lara:GetAmmoCount() == 0) then
		        zero_ammo = 1
		        ammo_text_counter = ""
		    else
		        zero_ammo = 0
		        ammo_text_counter = '' .. Lara:GetAmmoCount()
		    end
		end
	end

	if handStatus == 4 and weaponType ~= WeaponType.FLARE and weaponType ~= WeaponType.TORCH then
    	LevelFuncs.Engine.Node.DisplaySprite(ObjID.CUSTOM_AMMO_GRAPHICS, ammo_type, Color(255,255,255), 4, 11, 0, 6, 6, 0, 0, 0, 9)
    	LevelFuncs.Engine.Node.DrawText(ammo_text_counter, 5.5, 8.7, 0, 1, Color(255,255,255), 1)
		if (Lara:GetAmmoCount() == 0) then
			LevelFuncs.Engine.Node.DisplaySprite(ObjID.CUSTOM_AMMO_GRAPHICS, 15, Color(255,255,255), 4, 11, 0, 6, 6, 1, 0, 0, 9)
		end
	end
end

function ShowText(text, posX, posY, textColor, duration)
	npcTextString = DisplayString(text, posX, posY, textColor)
	ShowString(npcTextString, duration)
end

-- internal function for buying items
function Buy(buyItem, buyValue, payItem, payValue)
	TakeItem(payItem, payValue)
	GiveItem(buyItem, buyValue, true)
end

function FasterShimmey()
    local LEFT = 569
    local RIGHT = 570
    if Lara:GetAnim() == 137 and KeyIsHeld(ActionID.RIGHT) then
        Lara:SetAnim(RIGHT)
    end
    if Lara:GetAnim() == 136 and KeyIsHeld(ActionID.LEFT) then
        Lara:SetAnim(LEFT)
    end
    if Lara:GetAnim() == RIGHT and Lara:GetFrame() == Lara:GetEndFrame() then
        if KeyIsHeld(ActionID.RIGHT) then
            Lara:SetAnim(RIGHT)
        elseif KeyIsHeld(ActionID.ACTION) and KeyIsHeld(ActionID.RIGHT) then
            Lara:SetAnim(137)
        end
    end
    if Lara:GetAnim() == LEFT and Lara:GetFrame() == Lara:GetEndFrame() then
        if KeyIsHeld(ActionID.LEFT) then
            Lara:SetAnim(LEFT)
        elseif KeyIsHeld(ActionID.ACTION) and KeyIsHeld(ActionID.LEFT) then
            Lara:SetAnim(136)
        end
    end
    if Lara:GetAnim() == RIGHT and KeyIsHeld(ActionID.ACTION) and (not KeyIsHeld(ActionID.RIGHT)) and Lara:GetFrame() == 27 then
        Lara:SetAnim(45)
    end
    if Lara:GetAnim() == LEFT and KeyIsHeld(ActionID.ACTION) and (not KeyIsHeld(ActionID.LEFT)) and Lara:GetFrame() == 27 then
        Lara:SetAnim(45)
    end
end

function CustomizeWaterfallEmitters()

	-- First Waterfall in Start Area
	local WaterfallEmitter1 = GetMoveableByName('waterfall_emitter_1')
	
	WaterfallEmitter1:SetItemFlags(150, 0)
	WaterfallEmitter1:SetItemFlags(4, 1)
	WaterfallEmitter1:SetItemFlags(80, 2)
	WaterfallEmitter1:SetItemFlags(4, 3)
	
	-- Second Waterfall with Toolbox
	local WaterfallEmitter2 = GetMoveableByName('waterfall_emitter_2')
	
	WaterfallEmitter2:SetItemFlags(150, 0)
	WaterfallEmitter2:SetItemFlags(4, 1)
	WaterfallEmitter2:SetItemFlags(150, 2)
	WaterfallEmitter2:SetItemFlags(4, 3)
	
	-- three Waterfalls in Big Area
	local WaterfallEmitter3 = GetMoveableByName('waterfall_emitter_3')
	
	WaterfallEmitter3:SetItemFlags(150, 0)
	WaterfallEmitter3:SetItemFlags(4, 1)
	WaterfallEmitter3:SetItemFlags(80, 2)
	WaterfallEmitter3:SetItemFlags(4, 3)
	
	local WaterfallEmitter4 = GetMoveableByName('waterfall_emitter_4')
	
	WaterfallEmitter4:SetItemFlags(150, 0)
	WaterfallEmitter4:SetItemFlags(4, 1)
	WaterfallEmitter4:SetItemFlags(80, 2)
	WaterfallEmitter4:SetItemFlags(4, 3)
	
	local WaterfallEmitter5 = GetMoveableByName('waterfall_emitter_5')
	
	WaterfallEmitter5:SetItemFlags(150, 0)
	WaterfallEmitter5:SetItemFlags(4, 1)
	WaterfallEmitter5:SetItemFlags(80, 2)
	WaterfallEmitter5:SetItemFlags(4, 3)
	
	-- Biggest Waterfall
	local WaterfallEmitter6 = GetMoveableByName('waterfall_emitter_6')
	
	WaterfallEmitter6:SetItemFlags(150, 0)
	WaterfallEmitter6:SetItemFlags(3, 1)
	WaterfallEmitter6:SetItemFlags(200, 2)
	WaterfallEmitter6:SetItemFlags(3, 3)
	
	local WaterfallEmitter7 = GetMoveableByName('waterfall_emitter_7')
	
	WaterfallEmitter7:SetItemFlags(150, 0)
	WaterfallEmitter7:SetItemFlags(3, 1)
	WaterfallEmitter7:SetItemFlags(200, 2)
	WaterfallEmitter7:SetItemFlags(3, 3)
	
	-- Cave North
	local WaterfallEmitter8 = GetMoveableByName('waterfall_emitter_8')
	
	WaterfallEmitter8:SetItemFlags(110, 0)
	WaterfallEmitter8:SetItemFlags(3, 1)
	WaterfallEmitter8:SetItemFlags(200, 2)
	WaterfallEmitter8:SetItemFlags(3, 3)
	
	-- Cave South
	local WaterfallEmitter9 = GetMoveableByName('waterfall_emitter_9')
	
	WaterfallEmitter9:SetItemFlags(150, 0)
	WaterfallEmitter9:SetItemFlags(3, 1)
	WaterfallEmitter9:SetItemFlags(200, 2)
	WaterfallEmitter9:SetItemFlags(3, 3)
	
	-- Waterfalls at Temple
	local WaterfallEmitter10 = GetMoveableByName('waterfall_emitter_10')
	
	WaterfallEmitter10:SetItemFlags(110, 0)
	WaterfallEmitter10:SetItemFlags(4, 1)
	WaterfallEmitter10:SetItemFlags(80, 2)
	WaterfallEmitter10:SetItemFlags(4, 3)
	
	local WaterfallEmitter11 = GetMoveableByName('waterfall_emitter_11')
	
	WaterfallEmitter11:SetItemFlags(110, 0)
	WaterfallEmitter11:SetItemFlags(4, 1)
	WaterfallEmitter11:SetItemFlags(80, 2)
	WaterfallEmitter11:SetItemFlags(4, 3)
	
	-- Waterfalls at Mountain
	local WaterfallEmitter12 = GetMoveableByName('waterfall_emitter_12')
	
	WaterfallEmitter12:SetItemFlags(110, 0)
	WaterfallEmitter12:SetItemFlags(4, 1)
	WaterfallEmitter12:SetItemFlags(80, 2)
	WaterfallEmitter12:SetItemFlags(4, 3)
	
	local WaterfallEmitter13 = GetMoveableByName('waterfall_emitter_13')
	
	WaterfallEmitter13:SetItemFlags(110, 0)
	WaterfallEmitter13:SetItemFlags(4, 1)
	WaterfallEmitter13:SetItemFlags(80, 2)
	WaterfallEmitter13:SetItemFlags(4, 3)
	
	local WaterfallEmitter14 = GetMoveableByName('waterfall_emitter_14')
	
	WaterfallEmitter14:SetItemFlags(110, 0)
	WaterfallEmitter14:SetItemFlags(4, 1)
	WaterfallEmitter14:SetItemFlags(80, 2)
	WaterfallEmitter14:SetItemFlags(4, 3)
	
	-- 2 Square Waterfalls Northside at Mountain
	local WaterfallEmitter15 = GetMoveableByName('waterfall_emitter_15')
	
	WaterfallEmitter15:SetItemFlags(110, 0)
	WaterfallEmitter15:SetItemFlags(4, 1)
	WaterfallEmitter15:SetItemFlags(80, 2)
	WaterfallEmitter15:SetItemFlags(4, 3)
	
	local WaterfallEmitter16 = GetMoveableByName('waterfall_emitter_16')
	
	WaterfallEmitter16:SetItemFlags(110, 0)
	WaterfallEmitter16:SetItemFlags(4, 1)
	WaterfallEmitter16:SetItemFlags(80, 2)
	WaterfallEmitter16:SetItemFlags(4, 3)
	
	local WaterfallEmitter17 = GetMoveableByName('waterfall_emitter_17')
	
	WaterfallEmitter17:SetItemFlags(110, 0)
	WaterfallEmitter17:SetItemFlags(4, 1)
	WaterfallEmitter17:SetItemFlags(80, 2)
	WaterfallEmitter17:SetItemFlags(4, 3)
	
	-- 1 Square Waterfalls Northside at Mountain
	local WaterfallEmitter18 = GetMoveableByName('waterfall_emitter_18')
	
	WaterfallEmitter18:SetItemFlags(100, 0)
	WaterfallEmitter18:SetItemFlags(3, 1)
	WaterfallEmitter18:SetItemFlags(50, 2)
	WaterfallEmitter18:SetItemFlags(3, 3)
	
	local WaterfallEmitter19 = GetMoveableByName('waterfall_emitter_19')
	
	WaterfallEmitter19:SetItemFlags(100, 0)
	WaterfallEmitter19:SetItemFlags(3, 1)
	WaterfallEmitter19:SetItemFlags(50, 2)
	WaterfallEmitter19:SetItemFlags(3, 3)
	
	local WaterfallEmitter20 = GetMoveableByName('waterfall_emitter_20')
	
	WaterfallEmitter20:SetItemFlags(100, 0)
	WaterfallEmitter20:SetItemFlags(4, 1)
	WaterfallEmitter20:SetItemFlags(50, 2)
	WaterfallEmitter20:SetItemFlags(4, 3)
	
	local WaterfallEmitter21 = GetMoveableByName('waterfall_emitter_21')
	
	WaterfallEmitter21:SetItemFlags(100, 0)
	WaterfallEmitter21:SetItemFlags(4, 1)
	WaterfallEmitter21:SetItemFlags(50, 2)
	WaterfallEmitter21:SetItemFlags(4, 3)
end