local frameCounter = 0
local frameInterval = 10  -- Number of frames after which the particles spawn

function AddLeaveParticles()

    frameCounter = frameCounter + 1  
    if frameCounter < frameInterval then
        return
    end
    frameCounter = 0
    
    -- ######################################################
    -- ################### Customizing ######################
    -- ######################################################
    local staticStartSlots = {}
    local moveableStartSlots = { 1021 }
    
    local positionTolerance = { x = 1024, y = 1024, z = 1024 }
    local velocityMax = 5 --values from 2 - X
    local spriteIndex = {33,34,35,36,37}
    local gravityMax = 6 --values from 2 - X
    local rotationMax = 5 --values from 2 - X
    local colorFrom = Color(200,200,200)
    local colorTo = Color(200,200,200)
    local mode = TEN.Effects.BlendID.ALPHABLEND
    local minSize = 15 -- must be lower value than endsize
    local maxSize = 20 -- must be higher value than endsize
    local lifeTime = 12 
    local distanceFromLara = 6144

    -- ######################################################
    -- ########### End Customizing ##########################
    -- ######################################################
    local objectsForParticles = {}
	
	-- Collect static objects
    for _, slot in pairs(staticStartSlots) do
        for _, obj in pairs(GetStaticsBySlot(slot)) do
            if CalculateDistance(obj:GetPosition(), Lara:GetPosition()) < distanceFromLara then
                table.insert(objectsForParticles, obj)
            end
        end
    end

    -- Collect moveable objects
    for _, slot in pairs(moveableStartSlots) do
        for _, obj in pairs(GetMoveablesBySlot(slot)) do
            if CalculateDistance(obj:GetPosition(), Lara:GetPosition()) < distanceFromLara then
                table.insert(objectsForParticles, obj)
            end
        end
    end

    for _, obj in pairs(objectsForParticles) do
        local pos = obj:GetPosition()

        -- Random deviations for position
        local x = pos.x + math.random(-positionTolerance.x, positionTolerance.x)
        local y = pos.y - math.random(-positionTolerance.y, positionTolerance.y)
        local z = pos.z + math.random(-positionTolerance.z, positionTolerance.z)
		
		-- Random deviations for speed, gravity, rotation and size
		local velocity = math.random(20, velocityMax * 10) / 10  -- Fix for decimal values
		local gravity = math.random(2, gravityMax)
        local rotation = math.random(20, rotationMax * 10) / 10  -- Fix for decimal values
        local size = math.random(minSize, maxSize)

        EmitParticle(
            Vec3(x, y, z), -- Start position
            Vec3(0, velocity, 0), -- velocity
            spriteIndex[math.random(1, #spriteIndex)], -- Sprite-Index
            gravity, -- gravity
            rotation, -- rotation
            colorFrom, -- start color
            colorTo, -- end color
            mode, -- Blend-Mode
            size, -- start size
            size, -- end size
            lifeTime, -- life size
            false, -- damage
            false -- poison
        )
    end
end
