-- FILE: Levels\Intro.lua

local EventSequence = require("Engine.EventSequence")
local Timer = require("Engine.Timer")

require("General")

LevelFuncs.OnLoad = function() 
	
	require("GameConfig")
	local validLanguages = { EN = true, DE = true }
	if not validLanguages[Language] then
	    error("Invalid language: " .. tostring(Language))
	end
	
	require("GameVarsStrings/" .. Language .. "/GameVarsStrings")
	require("NpcDialogs/" .. Language .. "/NpcDialogs")
	require("MerchantDialogs/" .. Language .. "/MerchantDialogs")
	
end

LevelFuncs.OnSave = function() end
LevelFuncs.OnStart = function() 

	require("GameConfig")
	local validLanguages = { EN = true, DE = true }
	if not validLanguages[Language] then
	    error("Invalid language: " .. tostring(Language))
	end
	require("GameVarsStrings/" .. Language .. "/GameVarsStrings")
	require("NpcDialogs/" .. Language .. "/NpcDialogs")
	require("MerchantDialogs/" .. Language .. "/MerchantDialogs")
	
	Initialize()
end

LevelFuncs.OnLoop = function() 
	ShowAmmoCounter()
	AddDustParticles()
	AddFireParticles()
	DeathEffect()
	CheckForAllItems()
	PlayHeliSound()
end

LevelFuncs.OnEnd = function() end
LevelFuncs.OnUseItem = function() end
LevelFuncs.OnFreeze = function() end

function Initialize()
	SetStaticsSoftCollision()
	
	if not GameVars.SetInitialItems then
        SetItemCount(ObjID.BIGMEDI_ITEM, 0)
        SetItemCount(ObjID.FLARE_INV_ITEM, 0)
        SetItemCount(ObjID.SMALLMEDI_ITEM, 0)
        GameVars.SetInitialItems = true
    end
    
    LevelVars.CollectedItems = 0
    LevelVars.LaraHasCollectedAllItems = false
    LevelVars.PlayHeliSound = false
    
    EventSequence.Create(
        "JungleFeverSequence", --name
        false, --loop
        false, --timer table
        1, LevelFuncs.__PlayFlyby1,
        14, LevelFuncs.__PlayHeliSound
    )
end

function SetStaticsSoftCollision()
	GetVolumeByName('SecretBox'):Disable()
	local staticSlots = {
		4,18,19,20,21,25,29,34,41,44,45,47,48,49,70,71,81,102,107,139,174,178,255,620,621,999
	}
	
	for index, staticSlot in pairs(staticSlots) do
		local statics = GetStaticsBySlot(staticSlot)
		
		for index, static in pairs(statics) do
		    static:SetSolid(false)
		end
	end
end

function PlayHeliSound()
	if LevelVars.PlayHeliSound == true then
		PlaySound(665)
	end
end

LevelFuncs.LaraPickupJungleFever = function()
	EventSequence.Get("JungleFeverSequence"):Start()
end

LevelFuncs.__PlayFlyby1 = function()
	PlayFlyBy(1)
end

LevelFuncs.__PlayHeliSound = function()
	LevelVars.PlayHeliSound = true
end

LevelFuncs.Manor1 = function()
	PlayNpcString("manor1")
end

LevelFuncs.Manor2 = function()
	PlayNpcString("manor2")
end

LevelFuncs.Manor3 = function()
	PlayNpcString("manor3")
end

LevelFuncs.Manor4 = function()
	PlayNpcString("manor4")
end

LevelFuncs.MoveChandeliersDown = function(activator)
	PlayNpcString("manorSecret")
	GetVolumeByName('SecretBox'):Enable()
	
	local items = {
        "chandelier1_1","chandelier1_2","chandelier1_3","chandelier1_4","chandelier1_5",
        "chandelier2_1","chandelier2_2","chandelier2_3","chandelier2_4","chandelier2_5"
    }

	for index, item in pairs(items) do
    	LevelFuncs.Engine.Node.ChangeMoveablePositionOverTimespan(item, TEN.Vec3(0,1024,0), true, 4, true)
    end
    
    PlaySound(2014)
end

LevelFuncs.AddItemForCheck = function(activator)
	LevelVars.CollectedItems = LevelVars.CollectedItems + 1
end

function CheckForAllItems()
	if not LevelVars.LaraHasCollectedAllItems and LevelVars.CollectedItems == 3 then
		PlayNpcString("manor5")
		LevelVars.LaraHasCollectedAllItems = true
	end
end