-- FILE: \Merchant.lua
local nextTime
local notEnoughMoney
local thanks
local FormattedPaymentString
local FormattedAvailablePaymentItemsString
local asksForBuying
local asksForBuying2
local availablePaymentItems
local actionYes
local actionNo
local paymentItem
local merchantName
local limitAlternate

function InteractWithMerchant(
	MerchantIdentifier,
	BuyItemName, 
	BuyItemValue, 
	BuyItemSlot, 
	BuyItemLimit,
	BuyItemVisibleItem,
	BuyAnimation,
	PaymentItemName,
	PaymentItemSlot,
	PaymentItemCost,
	AskForBuyingText,
	TradeString,
	ActionYes,
	ActionNo,
	ThanksText,
	ThanksTextDuration,
	NotEnoughMoneyText,
	NotEnoughMoneyTextDuration,
	NextTimeText,
	NextTimeTextDuration,
	BuyLimitReachedText,
	BuyLimitReachedTextDuration,
	MerchantName,
	BuyItemValueRandomFrom,
	BuyItemValueRandomTo
)
	buy = false
	
	local leftX, upY = PercentToScreen(10, 10)
	local leftX2, upY2 = PercentToScreen(10, 15)
	local halfwayX, halfwayY = PercentToScreen(25, 40)
	local availableItemsX, availableItemsY = PercentToScreen(50, 65)
	local actionYesX, actionYesY = PercentToScreen(10, 65)
	local actionNoX, actionNoY = PercentToScreen(10, 70)
	
	FormattedTradeString = string.format(
        GameVars.Merchants.default[TradeString],
        PaymentItemCost, 
        Flow.GetString(PaymentItemName),
        BuyItemValue, 
        Flow.GetString(BuyItemName)
    )

    FormattedAvailablePaymentItemsString = string.format(
    	GameVars.MerchantAvailablePaymentItems,
    	tostring(GetItemCount(PaymentItemSlot)),
    	Flow.GetString(PaymentItemName)
    )
    
    if GameVars.StartDialog then
    	KeyClear(ActionID.LOOK)
    	KeyClear(ActionID.DRAW)
		KeyClear(ActionID.CROUCH)
		KeyClear(ActionID.JUMP)
		KeyClear(ActionID.ROLL)
		
		SetPostProcessMode(PostProcessMode.MONOCHROME)
		SetPostProcessStrength(0.8)
		SetPostProcessTint(Color(200,200,200))
	end

	-- if ACTION is hit and Lara has not Start the dialog
	if KeyIsHit(GameVars.StartKey) and not GameVars.StartDialog and Lara:GetHandStatus() == 0 then
	
		HideAllDisplayStrings()
		
		DisplayStrings.merchantName = DisplayString(MerchantName, leftX, upY, Color(255, 200, 0))
		DisplayStrings.nextTime = DisplayString(NextTimeText, leftX2, upY2, Color(255,255,255))
		DisplayStrings.notEnoughMoney = DisplayString(NotEnoughMoneyText, leftX2, upY2, Color(255,255,255))
		DisplayStrings.asksForBuying = DisplayString(AskForBuyingText, leftX2, upY2, Color(255,255,255))
		DisplayStrings.asksForBuying2 = DisplayString(FormattedTradeString, halfwayX, halfwayY, Color(255,255,0))
		DisplayStrings.availablePaymentItems = DisplayString(FormattedAvailablePaymentItemsString, availableItemsX, availableItemsY, Color(32,255,128), false, {Strings.DisplayStringOption.SHADOW})
		DisplayStrings.actionYes = DisplayString(ActionYes, actionYesX, actionYesY, Color(0,155,75), false, {Strings.DisplayStringOption.SHADOW, Strings.DisplayStringOption.BLINK})
		DisplayStrings.actionNo = DisplayString(ActionNo, actionNoX, actionNoY, Color(200,10,10), false, {Strings.DisplayStringOption.SHADOW})
		DisplayStrings.thanks = DisplayString(ThanksText, leftX2, upY2, Color.new(255,255,255))
		DisplayStrings.buyLimitReached = DisplayString(BuyLimitReachedText, leftX2, upY2, Color(255,255,255))
		
		GameVars.EndDialog = false
		-- Start dialog
		GameVars.StartDialog = true
		-- Set Cine Bars
		SetCineBars(GameVars.CineBarsWeight, GameVars.CineBarsCreationSpeed)
			
		-- Initial abort buying and hide strings
		buy = false
			
		if BuyItemLimit > GameVars.MerchantTradeCount[MerchantIdentifier] then 
			
			if DisplayStrings.merchantName then
				ShowString(DisplayStrings.merchantName)
			end
			
			if DisplayStrings.asksForBuying then
				ShowString(DisplayStrings.asksForBuying)
			end
			
			if DisplayStrings.asksForBuying2 then
				ShowString(DisplayStrings.asksForBuying2)
			end
			
			if DisplayStrings.availablePaymentItems then
				ShowString(DisplayStrings.availablePaymentItems)
			end
			
			if DisplayStrings.actionYes then
				ShowString(DisplayStrings.actionYes)
			end
			
			if DisplayStrings.actionNo then
				ShowString(DisplayStrings.actionNo)
			end
			
			PlayAudioTrack(Language .. "/merchant/" .. MerchantIdentifier .. "/" .. "ask", SoundTrackType.VOICE)
		
		else
			-- limit is reached
			
			DisplayStrings.merchantName = DisplayString(MerchantName, leftX, upY, Color(255, 200, 0))
			DisplayStrings.nextTime = DisplayString(NextTimeText, leftX2, upY2, Color(255,255,255))
			DisplayStrings.notEnoughMoney = DisplayString(NotEnoughMoneyText, leftX2, upY2, Color(255,255,255))
			DisplayStrings.asksForBuying = DisplayString(AskForBuyingText, leftX2, upY2, Color(255,255,255))
			DisplayStrings.asksForBuying2 = DisplayString(FormattedTradeString, halfwayX, halfwayY, Color(255,255,0))
			DisplayStrings.availablePaymentItems = DisplayString(FormattedAvailablePaymentItemsString, availableItemsX, availableItemsY, Color(32,255,128), false, {Strings.DisplayStringOption.SHADOW})
			DisplayStrings.actionYes = DisplayString(ActionYes, actionYesX, actionYesY, Color(0,155,75), false, {Strings.DisplayStringOption.SHADOW, Strings.DisplayStringOption.BLINK})
			DisplayStrings.actionNo = DisplayString(ActionNo, actionNoX, actionNoY, Color(200,10,10), false, {Strings.DisplayStringOption.SHADOW})
			DisplayStrings.thanks = DisplayString(ThanksText, leftX2, upY2, Color.new(255,255,255))
			DisplayStrings.buyLimitReached = DisplayString(BuyLimitReachedText, leftX2, upY2, Color(255,255,255))
			
			if GameVars.Merchants[MerchantIdentifier].LimitAlternate then
				PlayAudioTrack(Language .. "/merchant/" .. MerchantIdentifier .. "/" .. GameVars.Merchants[MerchantIdentifier].LimitAlternate, SoundTrackType.VOICE)
			else
				PlayAudioTrack(Language .. "/merchant/" .. MerchantIdentifier .. "/" .. "limit", SoundTrackType.VOICE)
			end
			
			if DisplayStrings.merchantName then
				ShowString(DisplayStrings.merchantName)
			end
			
			if DisplayStrings.buyLimitReached then
				ShowString(DisplayStrings.buyLimitReached)
			end
			
			SetPostProcessMode(PostProcessMode.MONOCHROME)
			SetPostProcessStrength(0.8)
			SetPostProcessTint(Color(200,200,200))
		end
		
	-- otherwise
	else
		
		-- if ACTION is hit and Lara has started the dialog and not buy and not end the dialog
		if KeyIsHit(GameVars.ConfirmKey) and GameVars.StartDialog and not buy and not GameVars.EndDialog and BuyItemLimit > GameVars.MerchantTradeCount[MerchantIdentifier] and Lara:GetHandStatus() == 0 then
			
			HideAllDisplayStrings()
			
			if (GetItemCount(PaymentItemSlot) >= PaymentItemCost) then

				buy = true
				PlayAudioTrack(Language .. "/merchant/" .. MerchantIdentifier .. "/" .. "thanks", SoundTrackType.VOICE)
				
				if DisplayStrings.merchantName then
					ShowString(DisplayStrings.merchantName)
				end
				
				if DisplayStrings.thanks then
					ShowString(DisplayStrings.thanks)
				end
				
				-- buy x items and remove y items for payment
				
				if not BuyItemValue and BuyItemValueRandomFrom and BuyItemValueRandomTo then
					BuyItemValue = math.random(BuyItemValueRandomFrom, BuyItemValueRandomTo)
				end
				
				Buy(BuyItemSlot, BuyItemValue, PaymentItemSlot, PaymentItemCost)
				Lara:SetAnim(BuyAnimation)
				
				--GameVars.Merchants[MerchantIdentifier]["BuyItemLimit"] = BuyItemLimit - 1
				GameVars.MerchantTradeCount[MerchantIdentifier] = GameVars.MerchantTradeCount[MerchantIdentifier] + 1
				
				if BuyItemVisibleItem then
					-- "Remove" Animating from Market

					for index, moveable in pairs(BuyItemVisibleItem) do
						local item = GetMoveableByName(moveable)
						if item:GetStatus(MoveableStatus.INACTIVE) == 0 then
							item:SetVisible(false)
							break
						end
					end
				end
			else
				-- not enough money
				buy = false
				
				if DisplayStrings.merchantName then
					ShowString(DisplayStrings.merchantName)
				end
				
				if DisplayStrings.notEnoughMoney then
					ShowString(DisplayStrings.notEnoughMoney)
				end
				
				PlayAudioTrack(Language .. "/merchant/" .. MerchantIdentifier .. "/" .. "money", SoundTrackType.VOICE)
			end
			-- remove cinebars (set 0 with speed of 90)
			SetCineBars(0, GameVars.CineBarsCreationSpeed)
			GameVars.EndDialog = true
			GameVars.StartDialog = false
			SetPostProcessMode(PostProcessMode.NONE)
		end
		
		-- if CANCEL is hit and Lara has started the dialog and not end the dialog
		if KeyIsHit(GameVars.CancelKey) and GameVars.StartDialog and not GameVars.EndDialog and BuyItemLimit > GameVars.MerchantTradeCount[MerchantIdentifier] then
		
			HideAllDisplayStrings()
			
			PlayAudioTrack(Language .. "/merchant/" .. MerchantIdentifier .. "/" .. "next", SoundTrackType.VOICE)
			buy = false
			GameVars.EndDialog = true
			-- remove cinebars (set 0 with speed of 90)
			SetCineBars(0, GameVars.CineBarsCreationSpeed)
			GameVars.StartDialog = false
				
			if DisplayStrings.merchantName then
				ShowString(DisplayStrings.merchantName)
			end
			
			if DisplayStrings.nextTime then
				ShowString(DisplayStrings.nextTime)
			end
			
			SetPostProcessMode(PostProcessMode.NONE)
		end
	end
end

-- function when Lara leave the volume box
function StopInteractWithMerchant()
	-- hide all strings
	HideAllDisplayStrings()
	StopAudioTrack(SoundTrackType.VOICE)
	GameVars.StartDialog = false
	GameVars.EndDialog = true
	-- remove cinebars (set 0 with speed of 90)
	SetCineBars(0, GameVars.CineBarsCreationSpeed)
	SetPostProcessMode(PostProcessMode.NONE)
end