-- FILE: \NpcDialogs\EN\NpcDialogs.lua
GameVars.Npcs = {
	["manor1"] = { 
		["npcName"] = "Lara",
		["text"] = [[
Father… you found it, but you never returned it. 
Was this your greatest discovery… or your greatest mistake?
        ]],
        ["displayTextDuration"] = 12,
    },
    ["manor2"] = { 
		["npcName"] = "Lara",
		["text"] = [[
Jungle Fever… to us, just an artifact. 
But to them, it’s their heart, 
their bond with nature. 
And I’ve kept it locked away here all these years.
        ]],
        ["displayTextDuration"] = 15,
    },
    ["manor3"] = { 
		["npcName"] = "Lara",
		["text"] = [[
The jungle won’t welcome me… it will test me. 
Dangers, traps, maybe even those who would 
take the artifact for themselves. 
But I won’t let it fall into the wrong hands again.
        ]],
        ["displayTextDuration"] = 16,
    },
    ["manor4"] = { 
		["npcName"] = "Lara",
		["text"] = [[
All right… I’ll pack my gear. 
Then I’m taking it with me. 
Time to head back into the jungle.
        ]],
        ["displayTextDuration"] = 9,
    },
    ["manor5"] = { 
		["npcName"] = "Lara",
		["text"] = [[
That’s all – time to head into the jungle.
        ]],
        ["displayTextDuration"] = 5,
    },
    ["manorSecret"] = { 
		["npcName"] = "Lara",
		["text"] = [[
Croft Manor - never a dull moment.
        ]],
        ["displayTextDuration"] = 5,
    },
    ["start1"] = { 
		["npcName"] = "Pilot",
		["text"] = [[
We're almost there, Lara! 
But the trees are too tall 
and dense. I can not go any lower!
        ]]
    },
    ["start2"] = { 
		["npcName"] = "Lara",
		["text"] = [[
No problem! There's a river down there. 
I'll just jump!
        ]]
    },
    ["start3"] = { 
		["npcName"] = "Pilot",
		["text"] = [[
Are you sure? 
The river current might be strong!
        ]]
    },
    ["start4"] = { 
		["npcName"] = "Lara",
		["text"] = [[
I can handle it. 
Open the door!
        ]]
    },
    ["start5"] = { 
		["npcName"] = "Pilot",
		["text"] = [[
Alright. 
Good luck down there!
        ]]
    },
    ["start6"] = { 
		["npcName"] = "Lara",
		["text"] = [[
Thanks! 
See you on the way back!
        ]]
    },
	["intro"] = { 
		["npcName"] = "Tomb Raider: Jungle Fever",
		["text"] = [[
Somewhere in the Jungle of Laos, 2025
        ]],
        ["textColor"] = Color(184, 184, 148),
        ["noAudio"] = true,
        ["displayTextDuration"] = 7,
    },
	["npc_jon_1"] = { -- English (US) - Tony
		["npcName"] = "Jon",
		["text"] = [[
Wow, what an arrival. Waterfalls? Bold choice. Or crazy.
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["nextVolume"] = "npc_jon_2"
    },
    ["npc_jon_2"] = { -- Freya English (Australia)
		["npcName"] = "Lara",
		["text"] = [[
Bold or crazy – call it what you will. 
Lara Croft. And you are?
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["nextVolume"] = "npc_jon_3"
    },
    ["npc_jon_3"] = { 
		["npcName"] = "Jon",
		["text"] = [[
Jon. Explorer. Or at least, I thought I was. This jungle? 
Is a death trap. Leopards, snakes, vicious fish, wild tribes...
My buddy didn’t make it, hm.. Poison got him.
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["nextVolume"] = "npc_jon_4"
    },
    ["npc_jon_4"] = {
		["npcName"] = "Lara",
		["text"] = [[
Poison?
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["nextVolume"] = "npc_jon_5"
    },
    ["npc_jon_5"] = { 
		["npcName"] = "Jon",
		["text"] = [[
Snakes, or maybe the tribes’ darts. Either way, 
I’ve been wandering for days, lost and out of luck.
But if I’m lucky, the vicious fish disappear for a while—
but luck isn’t exactly on my side out here.
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["nextVolume"] = "npc_jon_6"
    },
    ["npc_jon_6"] = { 
		["npcName"] = "Lara",
		["text"] = [[
Then why are you still here?
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["nextVolume"] = "npc_jon_7"
    },
    ["npc_jon_7"] = { 
		["npcName"] = "Jon",
		["text"] = [[
Can’t leave without some healing plants. 
Three should do it.
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["nextVolume"] = "npc_jon_8",
        ["preCallFunction"] = "LaraHasInfoAboutHealingPlants"
    },
    ["npc_jon_8"] = { 
		["npcName"] = "Lara",
		["text"] = [[
And the catch?
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["nextVolume"] = "npc_jon_9"
    },
    ["npc_jon_9"] = {
		["npcName"] = "Jon",
		["text"] = [[
My shotgun. Yours if you get me the plants. 
I don’t need it anymore.
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["nextVolume"] = "npc_jon_10"
    },
    ["npc_jon_10"] = { 
		["npcName"] = "Lara",
		["text"] = [[
Deal. Wait here.
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["nextVolume"] = "npc_jon_11"
    },
    ["npc_jon_11"] = { 
		["npcName"] = "Jon",
		["text"] = [[
Oh, I’m not going anywhere. 
Just… watch out for everything. It’s all out to kill you.
And the monkeys... they are the sacred ones of this jungle. 
The natives worship them like gods, 
so you’d better not waste a bullet on them 
if you don’t want to bring their wrath upon you.
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["nextVolume"] = "npc_jon_12"
    },
    ["npc_jon_12"] = { 
		["npcName"] = "Lara",
		["text"] = [[
Don't worry, I'll take care of it.
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["nextVolume"] = "merchant_jon_shotgun"
    },
    ["lara_found_first_healing_plant"] = { 
		["npcName"] = "Lara",
		["text"] = [[
Looks like Jon’s miracle herb. 
Hopefully, it heals more than it kills.
        ]],
        ["displayTextDuration"] = 6,
    },
    ["lara_kills_first_jaguar"] = { 
		["npcName"] = "Lara",
		["text"] = [[
A pitty. Rest in peace, big cat – but I still prefer house cats.
        ]],
        ["displayTextDuration"] = 8,
    },
    ["lara_shotgun_repair"] = { 
		["npcName"] = "Lara",
		["text"] = [[
Well, who’d have thought I’m better at fixing shotguns
than Jon is at keeping promises.
        ]],
        ["displayTextDuration"] = 8,
    },
    ["lara_observe"] = { 
		["npcName"] = "Lara",
		["text"] = [[
Apparently, I'm being watched...
        ]],
        ["displayTextDuration"] = 5,
    },
    ["lara_raft_dont_work"] = { 
		["npcName"] = "Lara",
		["text"] = [[
Hmm, the raft doesn't work. 
Some pieces are missing...
        ]],
        ["displayTextDuration"] = 6,
    },
    ["lara_raft_work"] = { 
		["npcName"] = "Lara",
		["text"] = [[
I think the raft will work now.
        ]],
        ["displayTextDuration"] = 5,
    },
    ["lara_killed_monkey"] = { 
		["npcName"] = "Lara",
		["text"] = [[
Hmm. Why exactly did I shoot that monkey?
        ]],
        ["displayTextDuration"] = 5,
    },
    ["trail_ammo"] = { 
		["npcName"] = "Lara",
		["text"] = [[
Hmm... a trail of ammunition...
        ]],
        ["displayTextDuration"] = 5,
    },
    ["lara_danger_below"] = { 
		["npcName"] = "Lara",
		["text"] = [[
Hmm, it looks like down here they won't so lucky.
This is going to be fun.
        ]],
        ["displayTextDuration"] = 8,
    },
    ["yamandu_1"] = {  
		["npcName"] = "Lara",
		["text"] = [[
I didn't expect to find anyone here. 
Who are you?
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["nextVolume"] = "yamandu_2"
    },
    ["yamandu_2"] = {  -- Pepe Spanish
		["npcName"] = "Yamandú",
		["text"] = [[
Oh, hello.
I am Yamandú...
from the people beyond the ruins.
I’m just here searching.
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["nextVolume"] = "yamandu_3"
    },
    ["yamandu_3"] = {  -- Freya English (Australia)
		["npcName"] = "Lara",
		["text"] = [[
Lara Croft. What are you searching for?
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["nextVolume"] = "yamandu_4"
    },
    ["yamandu_4"] = {  
		["npcName"] = "Yamandú",
		["text"] = [[
Memories. Four small Buddha statues... 
They belonged to my children. 
They shaped them from clay... 
before the river took them.
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["nextVolume"] = "yamandu_5"
    },
    ["yamandu_5"] = {  
		["npcName"] = "Lara",
		["text"] = [[
I'm sorry.
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["nextVolume"] = "yamandu_6"
    },
    ["yamandu_6"] = {  
		["npcName"] = "Yamandú",
		["text"] = [[
Others took them from me. Enemies of my people. 
They scattered them – in the temples, 
among the stones... 
as if they mean nothing. But they mean everything.
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["nextVolume"] = "yamandu_7"
    },
    ["yamandu_7"] = {  
		["npcName"] = "Lara",
		["text"] = [[
Have you tried to get them back?
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["nextVolume"] = "yamandu_8"
    },
    ["yamandu_8"] = {  
		["npcName"] = "Yamandú",
		["text"] = [[
I am too weak. 
Days without food... 
and the ruins are dangerous. 
Beasts, traps, the enemies of my people. 
I can’t anymore.
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["nextVolume"] = "yamandu_9"
    },
    ["yamandu_9"] = {  
		["npcName"] = "Lara",
		["text"] = [[
Hmm. I'll keep my eyes open.
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["nextVolume"] = "yamandu_10"
    },
    ["yamandu_10"] = {  
		["npcName"] = "Yamandú",
		["text"] = [[
You would do that? 
For a stranger?
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["nextVolume"] = "yamandu_11"
    },
    ["yamandu_11"] = {  
		["npcName"] = "Lara",
		["text"] = [[
Some memories shouldn’t be lost.
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["nextVolume"] = "yamandu_12"
    },
    ["yamandu_12"] = {  
		["npcName"] = "Yamandú",
		["text"] = [[
Before my strength faded, 
I managed to take something from 
the enemies of my people...
This key... I don’t know what it unlocks, 
but perhaps it will be more of 
use to you than me.
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["nextVolume"] = "merchant_yamandu",
        ["callFunction"] = "GiveKeyItem3"
    },
    ["lara_cave_jump"] = { 
		["npcName"] = "Lara",
		["text"] = [[
Looks like the platform isn't in position. 
Maybe I can raise it and jump across!
        ]],
        ["displayTextDuration"] = 7,
    },
    ["lara_broke_elephant"] = { 
		["npcName"] = "Lara",
		["text"] = [[
Ah, wonderful. An ancient masterpiece. 
It would be a real shame if 
someone were to destroy it…

Oops.
        ]],
        ["displayTextDuration"] = 12,
    },
    ["lara_found_shotgun"] = { 
		["npcName"] = "Lara",
		["text"] = [[
Oh wow.
This shotgun looks almost 
brand new - unlike your buddy there Jon.
Hmm. How long have you 
been camping here exactly?
        ]],
        ["displayTextDuration"] = 12,
    },
    ["lara_found_uzi"] = { 
		["npcName"] = "Lara",
		["text"] = [[
Oh, a Weapon!
Looks like the owner really needed it –
too bad he ran out of ammo faster 
than he could save his life.
        ]],
        ["displayTextDuration"] = 10,
    },
    ["lara_found_four_buddha"] = { 
		["npcName"] = "Lara",
		["text"] = [[
With all four Buddha sculptures 
Yamandú can finally find peace.
Time to bring them to him.
        ]],
        ["displayTextDuration"] = 8,
    },
    ["lara_found_revolver"] = { 
		["npcName"] = "Lara",
		["text"] = [[
A revolver, a skeleton...
Well, either he wanted to enjoy the view, 
or got chased up here – or had the dumbest 
escape plan of all time.
        ]],
        ["displayTextDuration"] = 15,
    },
    ["lara_found_uzi_two"] = { 
		["npcName"] = "Lara",
		["text"] = [[
Hm, looks like he got locked in -
too bad his weapon didn’t help him out. 
At least the long walk with the 
torch was worth it for me.
        ]],
        ["displayTextDuration"] = 10,
    },
    ["lara_found_crowbar"] = { 
		["npcName"] = "Lara",
		["text"] = [[
Well, I doubt he’ll mind if I borrow something.
        ]],
        ["displayTextDuration"] = 4,
    },
    ["lara_found_deep_cave"] = { 
		["npcName"] = "Lara",
		["text"] = [[
Skeletons, ammo, and a bit of dust – 
fantastic. But who even gets the idea 
to come down here?
        ]],
        ["displayTextDuration"] = 10,
    },
    ["lara_tightrope"] = { 
		["npcName"] = "Lara",
		["text"] = [[
Slow and steady... any movement could make me fall.
        ]],
        ["displayTextDuration"] = 6,
    },
    ["lara_found_first_secret"] = { 
		["npcName"] = "Lara",
		["text"] = [[
How long have you been lying there?
And what on earth have you two been up to up here?
        ]],
        ["displayTextDuration"] = 7,
    },
    ["kairi_1"] = {  
		["npcName"] = "Lara",
		["text"] = [[
I am here to return the Jungle Fever artifact. 
It belongs to you.
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["preCallFunction"] = "PlayAudio153",
        ["nextVolume"] = "kairi_2"
    },
    ["kairi_2"] = {   -- Cesar augusto
		["npcName"] = "Kaíri",
		["text"] = [[
You have returned our heart of nature...
The spirits of the jungle will honor your name, Lara.
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["nextVolume"] = "kairi_3"
    },
    ["kairi_3"] = {
		["npcName"] = "Kaíri",
		["text"] = [[
Our hunters have been watching you. They saw 
you speaking with Jon and Yamandú. 
You even helped Yamandú find his peace.
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["nextVolume"] = "kairi_4"
    },
    ["kairi_4"] = {
		["npcName"] = "Kaíri",
		["text"] = [[
And they said you only fought 
when it was necessary – none of your weapons 
killed a monkey.
You understand the jungle more than many strangers. 
The spirits of the animals will bless your path.
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["callFunction"] = "AddLastSecret",
        ["nextVolume"] = "kairi_5"
    },
    ["kairi_4a"] = {
		["npcName"] = "Kaíri",
		["text"] = [[
And they said you shooted when it was necessary...
But you killed monkeys.

The monkeys are part of the jungle, just like us.
Their lives are just as valuable.

Was it really necessary?
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["callFunction"] = "AddLastSecret",
        ["nextVolume"] = "kairi_4b"
    },
    ["kairi_4b"] = {
		["npcName"] = "Kaíri",
		["text"] = [[
Perhaps you understand the jungle
differently than we do.

But you returned the artifact.
That shows that your heart is not
blind to what is right.
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["callFunction"] = "AddLastSecret",
        ["nextVolume"] = "kairi_5"
    },
    ["kairi_5"] = {
		["npcName"] = "Lara",
		["text"] = [[
I am not here to take, but to return.
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["nextVolume"] = "merchant_kairi"
    },
    ["kairi_6"] = {
		["npcName"] = "Kaíri",
		["text"] = [[
Come with us, Lara. The tribe wants to meet you. 
We will sing, tell stories, and show you 
what it means to be one with the jungle.
        ]],
        ["textColor"] = Color(255, 255, 255),
        ["confirmText"] = GameVars.ConfirmText,
        ["confirmTextColor"] = Color(75, 255, 75),
        ["callFunction"] = "EndGame"
    },
    ["end"] = { 
    	["npcName"] = "Tomb Raider: Jungle Fever",
		["text"] = [[
In the flickering flames, 
ancient legends awaken – 
and the jungle breathes once more.
        ]], 
        ["textColor"] = Color(184, 184, 148),
    },
    ["end2"] = { 
    	["npcName"] = "Tomb Raider: Jungle Fever",
		["text"] = [[
The "Jungle Fever" has returned, 
yet its true power remains a mystery.
        ]],
        ["textColor"] = Color(184, 184, 148),
    },
    ["end3"] = { 
    	["npcName"] = "Tomb Raider: Jungle Fever",
		["text"] = [[
One chapter ends, 
but the echo of adventure never fades…
        ]],
        ["textColor"] = Color(184, 184, 148),
    },
    ["outro"] = { 
    	["npcName"] = "Tomb Raider: Jungle Fever",
		["text"] = [[
Thanks for playing :)
I hope you enjoyed it and had 
just as much fun playing as I did creating it! :)
        ]],
        ["textColor"] = Color(184, 184, 148),
        ["noAudio"] = true,
    },
    ["outro2"] = { 
    	["npcName"] = "Tomb Raider: Jungle Fever",
		["text"] = [[
Voiceovers - english version:

"Lara" by AgentXP
"Jon" by stranger1992
"Pilot" by Kubsy
"Yamandú" by NanakiAzakee
"Kaíri" by Szybkomir

Thanks so much!
        ]],
        ["textColor"] = Color(184, 184, 148),
        ["noAudio"] = true,
    },
    ["outro3"] = { 
    	["npcName"] = "Tomb Raider: Jungle Fever",
		["text"] = [[
A huge thank you to my level testers,
who not only found tons of bugs but also
supported me with great ideas!
        ]],
        ["textColor"] = Color(184, 184, 148),
        ["noAudio"] = true,
    },
    ["outro4"] = { 
    	["npcName"] = "Tomb Raider: Jungle Fever",
		["text"] = [[
Markus
illyaine
NanakiAzakee
TrTimes
MichaelMann
        ]],
        ["textColor"] = Color(184, 184, 148),
        ["noAudio"] = true,
    },
    ["outro5"] = { 
    	["npcName"] = "Tomb Raider: Jungle Fever",
		["text"] = [[
A huge thank you to the TEN (TombEngine) Team, 
without whom this level wouldn’t have been possible.

Special thanks to illyaine, who supported me with ideas, 
textures, objects, and much more.

I’m also truly grateful to everyone who 
helped me along the way.

And of course, a big thank you 
to the amazing TRLE community!
        ]],
        ["textColor"] = Color(184, 184, 148),
        ["noAudio"] = true,
    },
	["outro6"] = { 
		["npcName"] = "Tomb Raider: Jungle Fever",
		["text"] = [[
Lara is already looking forward to the next adventure :)

I would really appreciate it if you could 
leave me a review on trle.net or trcustoms.org! :) :) :)

See you!

l.m. (Leif Melles)
        ]],
        ["textColor"] = Color(184, 184, 148),
        ["noAudio"] = true,
    },
}
