//These variables will get set automatically
texture tex1;
texture tex2;

float CurrentEye;
float CurrentBrightness;

sampler s0 = sampler_state { texture = <tex1>; };
sampler s1 = sampler_state { texture = <tex2>; };

//Use these to modify the behaviour of the dll
int ToggleKey=107;
float ReactionSpeed=5.5;

//Use these to modify the behaviour of the shader
static const float BloomScale = 0.66;
static const float HDRScale = -1.6;
static const float HDRAdjust = 0.33;

//static const float2 rcpres = { 0.0041666666666666666666666666666667, 0.0055555555555555555555555555555556 };
//static const float2 rcpres = { 0.00625, 0.0083333333333333333333333333333333 };
static const float2 rcpres = { 0.0025, 0.0033333333333333333333333333333333 };
//static const float2 rcpres = { 0.0020833333333333333333333333333333, 0.0027777777777777777777777777777778 };
//static const float2 rcpres = { 0.001953125, 0.0026041666666666666666666666666667 };
//static const float2 rcpres = { 0.0015625, 0.0020833333333 };
//static const float2 rcpres = { 0.00078125, 0.0010416666666666666666666666666667 };

float2 PixelKernelH[13] =
{
    { -6, 0 },
    { -5, 0 },
    { -4, 0 },
    { -3, 0 },
    { -2, 0 },
    { -1, 0 },
    {  0, 0 },
    {  1, 0 },
    {  2, 0 },
    {  3, 0 },
    {  4, 0 },
    {  5, 0 },
    {  6, 0 },
};

float2 PixelKernelV[13] =
{
    { 0, -6 },
    { 0, -5 },
    { 0, -4 },
    { 0, -3 },
    { 0, -2 },
    { 0, -1 },
    { 0,  0 },
    { 0,  1 },
    { 0,  2 },
    { 0,  3 },
    { 0,  4 },
    { 0,  5 },
    { 0,  6 },
};

static const float BlurWeights[13] = 
{
    0.002216,
    0.008764,
    0.026995,
    0.064759,
    0.120985,
    0.176033,
    0.199471,
    0.176033,
    0.120985,
    0.064759,
    0.026995,
    0.008764,
    0.002216,
};

float4 Bloom( in float2 Tex : TEXCOORD0 ) : COLOR0
{
    float4 Color = tex2D( s0, Tex );
    Color *= 1.01+((CurrentEye - 0.5)*HDRScale);
    Color *= 1+((CurrentBrightness - CurrentEye)*2);  //Uncomment this line for abrubt brightness changes

//float4 Color2=-0.140;
    float4 Color2=-0.195;
    for (int i = 0; i < 13; i++)
    {    
        Color2 += tex2D( s1, Tex + (PixelKernelH[i]*rcpres) ) * BlurWeights[i];
        Color2 += tex2D( s1, Tex + (PixelKernelV[i]*rcpres) ) * BlurWeights[i];
    }
    Color2 *= BloomScale;

    return saturate(Color + Color2);
}
float4 HDRBrightPass( in float2 Tex : TEXCOORD0 ) : COLOR0
{
	float4 color = tex2D( s0, Tex );
	//color += saturate(tex2D( s1, Tex ) - (CurrentEye + 0.1)); //Uncomment this line for retina burn
	float4 adjust = (color-CurrentEye)-HDRAdjust;
	color = saturate(adjust*adjust*adjust*adjust*adjust*360);
	color.a = 1;
	return color;
}

technique T0
{
    pass p0 { PixelShader = compile ps_2_0 HDRBrightPass(); }
    pass p1 { PixelShader = compile ps_2_0 Bloom();         }
}

//color = saturate(adjust*adjust*adjust*adjust*adjust*360);