/* opengl extensions */
#if defined __WIN32__ || !defined GL_ARB_multitexture
PFNGLACTIVETEXTUREARBPROC glActiveTextureARB = NULL;
PFNGLMULTITEXCOORD4FARBPROC glMultiTexCoord4fARB = NULL;
PFNGLMULTITEXCOORD4FVARBPROC glMultiTexCoord4fvARB = NULL;
#endif
PFNGLCREATESHADEROBJECTARBPROC glCreateShaderObjectARB = NULL;
PFNGLSHADERSOURCEARBPROC glShaderSourceARB = NULL;
PFNGLCOMPILESHADERARBPROC glCompileShaderARB = NULL;
PFNGLCREATEPROGRAMOBJECTARBPROC glCreateProgramObjectARB = NULL;
PFNGLATTACHOBJECTARBPROC glAttachObjectARB = NULL;
PFNGLLINKPROGRAMARBPROC glLinkProgramARB = NULL;
PFNGLUSEPROGRAMOBJECTARBPROC glUseProgramObjectARB = NULL;
PFNGLUNIFORM1IARBPROC glUniform1iARB = NULL;
PFNGLUNIFORM1FARBPROC glUniform1fARB = NULL;
PFNGLUNIFORM2FARBPROC glUniform2fARB = NULL;
PFNGLUNIFORM3FARBPROC glUniform3fARB = NULL;
PFNGLUNIFORM4FARBPROC glUniform4fARB = NULL;
PFNGLGETUNIFORMLOCATIONARBPROC glGetUniformLocationARB = NULL;
PFNGLDETACHOBJECTARBPROC glDetachObjectARB = NULL;
PFNGLDELETEOBJECTARBPROC glDeleteObjectARB = NULL;
PFNGLGETOBJECTPARAMETERIVARBPROC glGetObjectParameterivARB = NULL;
PFNGLGETINFOLOGARBPROC glGetInfoLogARB = NULL;
PFNGLBLENDFUNCSEPARATEPROC glBlendFuncSeparate = NULL;
PFNGLGENERATEMIPMAPEXTPROC glGenerateMipmap = NULL;

GLuint ogl_sfactor[16] = { 
	GL_ZERO,
	GL_SRC_ALPHA,
	GL_DST_COLOR,
	GL_DST_ALPHA,
	GL_ONE,
	GL_ONE_MINUS_SRC_ALPHA,
	GL_ONE_MINUS_DST_COLOR,
	GL_ONE_MINUS_DST_ALPHA,
	GL_ZERO,
	GL_ZERO,
	GL_ZERO,
	GL_ZERO,
	GL_ZERO,
	GL_ZERO,
	GL_ZERO,
	GL_SRC_ALPHA_SATURATE };

GLuint ogl_dfactor[16] = { 
	GL_ZERO,
	GL_SRC_ALPHA,
	GL_SRC_COLOR,
	GL_DST_ALPHA,
	GL_ONE,
	GL_ONE_MINUS_SRC_ALPHA,
	GL_ONE_MINUS_SRC_COLOR,
	GL_ONE_MINUS_DST_ALPHA,
	GL_ZERO,
	GL_ZERO,
	GL_ZERO,
	GL_ZERO,
	GL_ZERO,
	GL_ZERO,
	GL_ZERO,
	GL_ONE /* A_COLORBEFOREFOG */ };


static Bitu ogl_texture_index = 1;
static bool ogl_started = false;

/* texture data */
struct ogl_texture_data {
	GLuint texID;
	bool enable;
};

/* triangle vertex map data */
struct ogl_vertex_map_data {
	float sw,tw,z,w;
	float s,t;
};

/* triangle vertex data */
struct ogl_vertex_data {
	float x,y,d,w,z;
	float r,g,b,a;
	ogl_vertex_map_data m[2];
};

/* texture cache buffer */
Bit32u texrgb[256*256];

/* texture address map */
std::map <const Bit32u, GLuint> textures[2];
/* shaders map */
std::map <const int, GLhandleARB> shaders;


static void ogl_load() {

#if defined __WIN32__ || !defined GL_ARB_multitexture
	glActiveTextureARB = (PFNGLACTIVETEXTUREARBPROC)SDL_GL_GetProcAddress("glActiveTextureARB");
	if (!glActiveTextureARB) E_Exit ("opengl: glActiveTextureARB extension not supported"); 

	glMultiTexCoord4fARB = (PFNGLMULTITEXCOORD4FARBPROC)SDL_GL_GetProcAddress("glMultiTexCoord4fARB");
	if (!glMultiTexCoord4fARB) E_Exit ("opengl: glMultiTexCoord4fARB extension not supported"); 

	glMultiTexCoord4fvARB = (PFNGLMULTITEXCOORD4FVARBPROC)SDL_GL_GetProcAddress("glMultiTexCoord4fvARB");
	if (!glMultiTexCoord4fvARB) E_Exit ("opengl: glMultiTexCoord4fvARB extension not supported"); 
#endif

    glCreateShaderObjectARB = (PFNGLCREATESHADEROBJECTARBPROC)SDL_GL_GetProcAddress("glCreateShaderObjectARB");
	if (!glCreateShaderObjectARB) E_Exit ("opengl: glCreateShaderObjectARB extension not supported"); 

	glShaderSourceARB = (PFNGLSHADERSOURCEARBPROC)SDL_GL_GetProcAddress("glShaderSourceARB");
	if (!glShaderSourceARB) E_Exit ("opengl: glShaderSourceARB extension not supported"); 

    glCompileShaderARB = (PFNGLCOMPILESHADERARBPROC)SDL_GL_GetProcAddress("glCompileShaderARB");
	if (!glCompileShaderARB) E_Exit ("opengl: glCompileShaderARB extension not supported"); 

    glCreateProgramObjectARB = (PFNGLCREATEPROGRAMOBJECTARBPROC)SDL_GL_GetProcAddress("glCreateProgramObjectARB");
	if (!glCreateProgramObjectARB) E_Exit ("opengl: glCreateProgramObjectARB extension not supported"); 

    glAttachObjectARB = (PFNGLATTACHOBJECTARBPROC)SDL_GL_GetProcAddress("glAttachObjectARB");
	if (!glAttachObjectARB) E_Exit ("opengl: glAttachObjectARB extension not supported"); 

    glLinkProgramARB = (PFNGLLINKPROGRAMARBPROC)SDL_GL_GetProcAddress("glLinkProgramARB");
	if (!glLinkProgramARB) E_Exit ("opengl: glLinkProgramARB extension not supported"); 

    glUseProgramObjectARB = (PFNGLUSEPROGRAMOBJECTARBPROC)SDL_GL_GetProcAddress("glUseProgramObjectARB");
	if (!glUseProgramObjectARB) E_Exit ("opengl: glUseProgramObjectARB extension not supported"); 

    glUniform1iARB = (PFNGLUNIFORM1IARBPROC)SDL_GL_GetProcAddress("glUniform1iARB");
	if (!glUniform1iARB) E_Exit ("opengl: glUniform1iARB extension not supported"); 

    glUniform1fARB = (PFNGLUNIFORM1FARBPROC)SDL_GL_GetProcAddress("glUniform1fARB");
	if (!glUniform1fARB) E_Exit ("opengl: glUniform1fARB extension not supported"); 

    glUniform2fARB = (PFNGLUNIFORM2FARBPROC)SDL_GL_GetProcAddress("glUniform2fARB");
	if (!glUniform2fARB) E_Exit ("opengl: glUniform2fARB extension not supported"); 

    glUniform3fARB = (PFNGLUNIFORM3FARBPROC)SDL_GL_GetProcAddress("glUniform3fARB");
	if (!glUniform3fARB) E_Exit ("opengl: glUniform3fARB extension not supported"); 

    glUniform4fARB = (PFNGLUNIFORM4FARBPROC)SDL_GL_GetProcAddress("glUniform4fARB");
	if (!glUniform4fARB) E_Exit ("opengl: glUniform4fARB extension not supported"); 

    glGetUniformLocationARB = (PFNGLGETUNIFORMLOCATIONARBPROC)SDL_GL_GetProcAddress("glGetUniformLocationARB");
	if (!glGetUniformLocationARB) E_Exit ("opengl: glGetUniformLocationARB extension not supported"); 

    glDetachObjectARB = (PFNGLDETACHOBJECTARBPROC)SDL_GL_GetProcAddress("glDetachObjectARB");
	if (!glDetachObjectARB) E_Exit ("opengl: glDetachObjectARB extension not supported"); 

    glDeleteObjectARB  = (PFNGLDELETEOBJECTARBPROC)SDL_GL_GetProcAddress("glDeleteObjectARB");
	if (!glDeleteObjectARB) E_Exit ("opengl: glDeleteObjectARB extension not supported"); 

	glGetObjectParameterivARB = (PFNGLGETOBJECTPARAMETERIVARBPROC)SDL_GL_GetProcAddress("glGetObjectParameterivARB"); 
	if (!glGetObjectParameterivARB) E_Exit ("opengl: glGetObjectParameterivARB extension not supported"); 

	glGetInfoLogARB = (PFNGLGETINFOLOGARBPROC)SDL_GL_GetProcAddress("glGetInfoLogARB"); 
	if (!glGetInfoLogARB) E_Exit ("opengl: glGetInfoLogARB extension not supported"); 

	glBlendFuncSeparate = (PFNGLBLENDFUNCSEPARATEPROC)SDL_GL_GetProcAddress("glBlendFuncSeparate");
	if (!glBlendFuncSeparate) E_Exit ("opengl: glBlendFuncSeparate extension not supported"); 

	glGenerateMipmap = (PFNGLGENERATEMIPMAPEXTPROC)SDL_GL_GetProcAddress("glGenerateMipmap");
	if (!glGenerateMipmap) E_Exit ("opengl: glBlendFuncSeparate extension not supported");
}

static void ogl_get_depth(voodoo_state* VV, Bit32s ITERZ, Bit64s ITERW, Bit32s *depthval)
{
	Bit32s wfloat;
	Bit32u FBZMODE = VV->reg[fbzMode].u;
	Bit32u FBZCOLORPATH = VV->reg[fbzColorPath].u;

	/* compute "floating point" W value (used for depth and fog) */
	if ((ITERW) & U64(0xffff00000000))
		wfloat = 0x0000;
	else
	{
		Bit32u temp = (Bit32u)(ITERW);
		if ((temp & 0xffff0000) == 0)
			wfloat = 0xffff;
		else
		{
			int exp = count_leading_zeros(temp);
			wfloat = ((exp << 12) | ((~temp >> (19 - exp)) & 0xfff)) + 1;
		}
	}

	/* compute depth value (W or Z) for this pixel */
	if (FBZMODE_WBUFFER_SELECT(FBZMODE) == 0)
		CLAMPED_Z(ITERZ, FBZCOLORPATH, *depthval);
	else if (FBZMODE_DEPTH_FLOAT_SELECT(FBZMODE) == 0)
		*depthval = wfloat;
	else
	{
		if ((ITERZ) & 0xf0000000)
			*depthval = 0x0000;
		else
		{
			Bit32u temp = (ITERZ) << 4;
			if ((temp & 0xffff0000) == 0)
				*depthval = 0xffff;
			else
			{
				int exp = count_leading_zeros(temp);
				*depthval = ((exp << 12) | ((~temp >> (19 - exp)) & 0xfff)) + 1;
			}
		}
	}

	/* add the bias */
	if (FBZMODE_ENABLE_DEPTH_BIAS(FBZMODE))
	{
		*depthval += (Bit16s)(VV)->reg[zaColor].u;
		CLAMP(*depthval, 0, 0xffff);
	}
	//if (FBZMODE_DEPTH_SOURCE_COMPARE(FBZMODE))
	//	*depthval = (Bit16u)(VV)->reg[zaColor].u;
}


void ogl_get_vertex_data(Bit32u x, Bit32u y, const void *extradata, ogl_vertex_data *vd) {
	const poly_extra_data *extra = (const poly_extra_data *)extradata;
	Bit32s iterr, iterg, iterb, itera;
	Bit32s iterz, d;
	Bit64s iterw;
	Bit32s dx, dy;

	dx = x - extra->ax;
	dy = y - extra->ay;
	iterr = extra->startr + ((dy * extra->drdy)>>4) + ((dx * extra->drdx)>>4);
	iterg = extra->startg + ((dy * extra->dgdy)>>4) + ((dx * extra->dgdx)>>4);
	iterb = extra->startb + ((dy * extra->dbdy)>>4) + ((dx * extra->dbdx)>>4);
	itera = extra->starta + ((dy * extra->dady)>>4) + ((dx * extra->dadx)>>4);
	iterz = extra->startz + ((dy * extra->dzdy)>>4) + ((dx * extra->dzdx)>>4);
	iterw = extra->startw + ((dy * extra->dwdy)>>4) + ((dx * extra->dwdx)>>4);

	for (int i=0;i<extra->texcount;i++) {
		voodoo_state *v=(voodoo_state*)extra->state;
		Bit64s iters,itert,iterw;
		Bit32u smax,tmax;
		Bit32s s, t, lod;

		Bit32u texmode=v->tmu[i].reg[textureMode].u;

		Bit32s oow;

		Bit32u ilod = v->tmu[i].lodmin >> 8;
		if (!((v->tmu[i].lodmask >> ilod) & 1))
			ilod++;

		smax = (v->tmu[i].wmask >> ilod) + 1;
		tmax = (v->tmu[i].hmask >> ilod) + 1;

		iterw = v->tmu[i].startw + ((dy * v->tmu[i].dwdy)>>4) + ((dx * v->tmu[i].dwdx)>>4);
		iters = v->tmu[i].starts + ((dy * v->tmu[i].dsdy)>>4) + ((dx * v->tmu[i].dsdx)>>4);
		itert = v->tmu[i].startt + ((dy * v->tmu[i].dtdy)>>4) + ((dx * v->tmu[i].dtdx)>>4);

		/* determine the S/T/LOD values for this texture */
		if (TEXMODE_ENABLE_PERSPECTIVE(texmode))
		{
			oow = fast_reciplog((iterw), &lod);
			s = ((Bit64s)oow * (iters)) >> 29;
			t = ((Bit64s)oow * (itert)) >> 29;
		}
		else
		{
			s = (iters) >> 14;
			t = (itert) >> 14;
		}

		/* clamp W */
		if (TEXMODE_CLAMP_NEG_W(texmode) && (iterw) < 0)
			s = t = 0;

		vd->m[i].s = (float)((float)s/(float)(smax*(1<<(18+ilod))));
		vd->m[i].t = (float)((float)t/(float)(tmax*(1<<(18+ilod))));
		vd->m[i].w = (float)((float)iterw/(float)(0xffffff));

		vd->m[i].sw = vd->m[i].s * vd->m[i].w;
		vd->m[i].tw = vd->m[i].t * vd->m[i].w;
		vd->m[i].z  = 0.0f;

	};

	vd->r = (float)((float)iterr/(float)(1<<20));
	vd->g = (float)((float)iterg/(float)(1<<20));
	vd->b = (float)((float)iterb/(float)(1<<20));
	vd->a = (float)((float)itera/(float)(1<<20));
	vd->z = (float)((float)iterz/(float)(1<<20));
	vd->w = (float)((float)iterw/(float)(0xffffff));

	ogl_get_depth(v,iterz,iterw,&d);
	vd->d = (float)((float)d/(float)(0xffff));

	vd->x = (float)x/16.0f;
	vd->y = (float)y/16.0f;
}

void ogl_cache_texture(const poly_extra_data *extra, ogl_texture_data *td) {
	voodoo_state *v=(voodoo_state*)extra->state;
	Bit32u texbase;	

	Bit32s smax, tmax;
	Bit8u *texptr8;
	Bit16u *texptr16;
	Bit32u *texrgbp;
	GLuint texID;

	Bit32u TEXMODE;

	for (int j=0;j<2;j++) {
		TEXMODE = j==0 ? extra->r_textureMode0 : extra->r_textureMode1;

		Bit32u ilod = v->tmu[j].lodmin >> 8;
		if (!((v->tmu[j].lodmask >> ilod) & 1))
			ilod++;

		texbase = v->tmu[j].lodoffset[ilod];

		if ( extra->texcount && (extra->texcount >= j) && (v->tmu[j].lodmin < (8 << 8)) ) {
			if (textures[j].find(texbase) == textures[j].end()) {
				smax = (v->tmu[j].wmask >> ilod) + 1;
				tmax = (v->tmu[j].hmask >> ilod) + 1;

				texptr8 = (Bit8u *)&v->tmu[j].ram[(texbase) & v->tmu[j].mask];
				texptr16 = (Bit16u *)&v->tmu[j].ram[(texbase) & v->tmu[j].mask];
				texrgbp = (Bit32u *)&texrgb[0];
				memset(texrgbp,0,256*256*4);

				if (TEXMODE_FORMAT(v->tmu[j].reg[textureMode].u) < 8)
					for (int i=0; i<(smax*tmax); i++) {
						Bitu data = v->tmu[j].lookup[*texptr8++];
							*texrgbp = (data&0xff000000) | ((data<<16)&0x00ff0000) | (data&0x0000ff00) | ((data>>16)&0x000000ff);
						texrgbp++;
					}
				else if (TEXMODE_FORMAT(v->tmu[j].reg[textureMode].u) >= 10 && TEXMODE_FORMAT(v->tmu[j].reg[textureMode].u) <= 12)
					for (int i=0; i<(smax*tmax); i++) {
						Bitu data = v->tmu[j].lookup[*texptr16++];
							*texrgbp = (data&0xff000000) | ((data<<16)&0x00ff0000) | (data&0x0000ff00) | ((data>>16)&0x000000ff);
						texrgbp++;
					}
				else {
					for (int i=0; i<(smax*tmax); i++) {
						Bitu data = (v->tmu[j].lookup[*texptr16 & 0xFF] & 0xFFFFFF) | ((*texptr16 & 0xff00) << 16);
							*texrgbp = (data&0xff000000) | ((data<<16)&0x00ff0000) | (data&0x0000ff00) | ((data>>16)&0x000000ff);
						texrgbp++;
						texptr16++;
					}
				}

				texrgbp = (Bit32u *)&texrgb[0];
				texID = ogl_texture_index++;

				glGenTextures(1, &texID);
				glBindTexture(GL_TEXTURE_2D, texID);
				glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_LINEAR); 
				glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR); 
				glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,TEXMODE_CLAMP_S(TEXMODE)?GL_CLAMP_TO_EDGE:GL_REPEAT);
				glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,TEXMODE_CLAMP_T(TEXMODE)?GL_CLAMP_TO_EDGE:GL_REPEAT);
				glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, smax, tmax, 0, GL_RGBA, GL_UNSIGNED_BYTE, texrgbp);
				glGenerateMipmap(GL_TEXTURE_2D);
				textures[j][texbase] = texID;

			} else {
				texID = textures[j][texbase];
			}

			td[j].texID = texID;
			td[j].enable = true;

		} else {
			td[j].enable = false;
		}
	}
}

GLhandleARB m_hProgramObject   = 0;
GLhandleARB m_hVertexShader    = 0;
GLhandleARB m_hFragmentShader  = 0;


void ogl_printInfoLog(GLhandleARB obj)
{
    int infologLength = 0;
    int charsWritten  = 0;
    char *infoLog;

    glGetObjectParameterivARB(obj, GL_OBJECT_INFO_LOG_LENGTH_ARB, &infologLength);

    if (infologLength > 0)
    {
		infoLog = (char *)malloc(infologLength);
		glGetInfoLogARB(obj, infologLength, &charsWritten, infoLog);
		LOG_MSG("%s\n",infoLog);
		free(infoLog);
    }
}

void ogl_sh_tex_combine(std::string *strFShader, const int TMU, const poly_extra_data *extra) {
	voodoo_state *v=(voodoo_state*)extra->state;

	Bitu TEXMODE     = v->tmu[TMU].reg[textureMode].u;

	if (!TEXMODE_TC_ZERO_OTHER(TEXMODE))
		*strFShader += "tt.rgb = cother.rgb;";
	else
		*strFShader += "tt.rgb = vec3(0.0);";

	if (!TEXMODE_TCA_ZERO_OTHER(TEXMODE)) 
		*strFShader += "tt.a = cother.a;";
	else
		*strFShader += "tt.a = 0.0;";

	if (TEXMODE_TC_SUB_CLOCAL(TEXMODE))
		*strFShader += "tt.rgb -= clocal.rgb;";
	if (TEXMODE_TCA_SUB_CLOCAL(TEXMODE))
		*strFShader += "tt.a -= clocal.a;";

	switch (TEXMODE_TC_MSELECT(TEXMODE)) 
	{
	default:
	case 0:
		*strFShader += "blend.rgb = vec3(0.0);";
		break;
	case 1:
		*strFShader += "blend.rgb = clocal.rgb;";
		break;
	case 2:
		*strFShader += "blend.rgb = vec3(cother.a);";
		break;
	case 3:
		*strFShader += "blend.rgb = vec3(clocal.a);";
		break;
	case 4:
		// detail //
		break;
	case 5: 
		// LOD //
		break;
	}

	switch (TEXMODE_TCA_MSELECT(TEXMODE)) 
	{
	default:
	case 0:
		*strFShader += "blend.a = 0.0;";
		break;
	case 1:
		*strFShader += "blend.a = clocal.a;";
		break;
	case 2:
		*strFShader += "blend.a = cother.a;";
		break;
	case 3:
		*strFShader += "blend.a = clocal.a;";
		break;
	case 4:
		// detail //
		break;
	case 5: 
		// LOD //
		break;
	}

	if (!TEXMODE_TC_REVERSE_BLEND(TEXMODE))
		*strFShader += "blend.rgb = vec3(1.0) - blend.rgb;";

	if (!TEXMODE_TCA_REVERSE_BLEND(TEXMODE))
		*strFShader += "blend.a = 1.0 - blend.a;";

	*strFShader += "tt *= blend;";

	switch (TEXMODE_TC_ADD_ACLOCAL(TEXMODE)) 
	{
	case 3:
	case 0:
		break;
	case 1:
		*strFShader += "tt.rgb += clocal.rgb;";
		break;
	case 2:
		*strFShader += "tt.rgb += vec3(clocal.a);";
		break;
	}

	if (TEXMODE_TCA_ADD_ACLOCAL(TEXMODE))
		*strFShader += "tt.a += clocal.a;";

	*strFShader += "clocal = tt;";
	
	if (TEXMODE_TC_INVERT_OUTPUT(TEXMODE))
		*strFShader += "clocal.rgb = vec3(1.0)-clocal.rgb;";

	if (TEXMODE_TCA_INVERT_OUTPUT(TEXMODE))
		*strFShader += "clocal.a = 1.0 - clocal.a;";

}

void ogl_sh_color_path(std::string *strFShader, const poly_extra_data *extra) {
	voodoo_state *v=(voodoo_state*)extra->state;

	Bitu FBZCOLORPATH = v->reg[fbzColorPath].u;
	Bitu FBZMODE = v->reg[fbzMode].u;
	Bitu ALPHAMODE = v->reg[alphaMode].u;

	switch (FBZCP_CC_RGBSELECT(FBZCOLORPATH)) 
	{
	case 0:
		*strFShader += "cother = gl_Color;";
		break;
	case 1:
		*strFShader += "cother = texel;";
		break;
	case 2:
		*strFShader += "cother = color1;";
		break;
	default:
		*strFShader += "cother = vec4(0.0);";
	}
		
	// TODO fix chroma key //
	if (FBZMODE_ENABLE_CHROMAKEY(FBZMODE)) 
//		if (!CHROMARANGE_ENABLE(v->reg[chromaRange].u))
			*strFShader +=	"if (distance (cother.rgb , chromaKey.rgb) < 0.001) discard;";
//		else {
//			*strFShader +=	"if ((cother.rgb >= (chromaKey.rgb-0.01)) && (cother.rgb <= (chromaRange.rgb+0.01))) discard;";
//		}
								

	switch (FBZCP_CC_ASELECT(FBZCOLORPATH))
	{
	case 0:
		*strFShader += "cother.a = gl_Color.a;";
		break;
	case 1:
		*strFShader += "cother.a = texel.a;";
		break;
	case 2:
		*strFShader += "cother.a = color1.a;";
		break;
	default:
		*strFShader += "cother.a = 0.0;";
		break;
	}

	// TODO check alpha mask //
//	if (FBZMODE_ENABLE_ALPHA_MASK(FBZMODE))
//		*strFShader += "if (cother.a > 0.0) discard;";

	if (ALPHAMODE_ALPHATEST(ALPHAMODE))
		switch (ALPHAMODE_ALPHAFUNCTION(ALPHAMODE)) {
			case 0:
				*strFShader += "discard;";
				break;
			case 1:
				*strFShader += "if (cother.a >= alphaRef) discard;";
				break;
			case 2:
//				*strFShader += "if (cother.a != alphaRef) discard;";
				*strFShader += "if (distance(cother.a , alphaRef) > 0.001) discard;";
				break;
			case 3:
				*strFShader += "if (cother.a >  alphaRef) discard;";
				break;
			case 4:
				*strFShader += "if (cother.a <= alphaRef) discard;";
				break;
			case 5:
//				*strFShader += "if (cother.a == alphaRef) discard;";
				*strFShader += "if (distance(cother.a , alphaRef) < 0.001) discard;";
				break;
			case 6:
				*strFShader += "if (cother.a <  alphaRef) discard;";
				break;
			case 7:
				break;
	}

	if (FBZCP_CC_LOCALSELECT_OVERRIDE(FBZCOLORPATH) == 0)
	{
		if (FBZCP_CC_LOCALSELECT(FBZCOLORPATH) == 0)
			*strFShader += "clocal = gl_Color;";
		else
			*strFShader += "clocal = color0;";
	}
	else
	{
		*strFShader +=	"if (texel.a < 0.5) {"	//is this correct??
							"clocal = gl_Color "
						"} else {"
							"clocal = color0 };";
	}

	switch (FBZCP_CCA_LOCALSELECT(FBZCOLORPATH)) 
	{
	default:
	case 0:
		*strFShader += "clocal.a = gl_Color.a;";
		break;
	case 1:
		*strFShader += "clocal.a = color0.a;";
		break;
	case 2:
		*strFShader += "clocal.a = gl_color.a;"; // TODO CLAMPED_Z
		break;
	case 3:
		// voodoo2 only
		break;
	}

	if (FBZCP_CC_ZERO_OTHER(FBZCOLORPATH) == 0)
		*strFShader += "tt.rgb = cother.rgb;";
	else
		*strFShader += "tt.rgb = vec3(0.0);";

	if (FBZCP_CCA_ZERO_OTHER(FBZCOLORPATH) == 0)
		*strFShader += "tt.a = cother.a;";
	else
		*strFShader += "tt.a = 0.0;";

	if (FBZCP_CC_SUB_CLOCAL(FBZCOLORPATH))
		*strFShader += "tt.rgb -= clocal.rgb;";

	if (FBZCP_CCA_SUB_CLOCAL(FBZCOLORPATH))
		*strFShader += "tt.a -= clocal.a;";

	switch (FBZCP_CC_MSELECT(FBZCOLORPATH))
	{
	default:
	case 0:
		*strFShader += "blend.rgb = vec3(0.0);";
		break;
	case 1:
		*strFShader += "blend.rgb = clocal.rgb;";
		break;
	case 2:
		*strFShader += "blend.rgb = vec3(cother.a);";
		break;
	case 3:
		*strFShader += "blend.rgb = vec3(clocal.a);";
		break;
	case 4:
		*strFShader += "blend.rgb = vec3(texel.a);";
		break;
	case 5:
		// voodoo2 only
		*strFShader += "blend.rgb = texel.rgb;";
		break;
	}

	switch (FBZCP_CCA_MSELECT(FBZCOLORPATH))
	{
	default:
	case 0:
		*strFShader += "blend.a = 0.0;";
		break;
	case 1:
		*strFShader += "blend.a = clocal.a;";
		break;
	case 2:
		*strFShader += "blend.a = cother.a;";
		break;
	case 3:
		*strFShader += "blend.a = clocal.a;";
		break;
	case 4:
		*strFShader += "blend.a = texel.a;";
		break;
	}

	if (!FBZCP_CC_REVERSE_BLEND(FBZCOLORPATH))
		*strFShader += "blend.rgb = vec3(1.0) - blend.rgb;";

	if (!FBZCP_CCA_REVERSE_BLEND(FBZCOLORPATH))
		*strFShader += "blend.a = 1.0 - blend.a;";

	*strFShader += "tt *= blend;";

	switch (FBZCP_CC_ADD_ACLOCAL(FBZCOLORPATH))
	{
	case 3:
	case 0:
		break;
	case 1:
		*strFShader += "tt.rgb += clocal.rgb;";
		break;
	case 2:
		*strFShader += "tt.rgb += vec3(clocal.a);";
		break;
	}

	if (FBZCP_CCA_ADD_ACLOCAL(FBZCOLORPATH))
		*strFShader += "tt.a += clocal.a;";

	// clamp ?? //

	*strFShader += "pixel = tt;";

	if (FBZCP_CC_INVERT_OUTPUT(FBZCOLORPATH))
		*strFShader += "pixel.rgb = vec3(1.0) - tt.rgb;";

	if (FBZCP_CCA_INVERT_OUTPUT(FBZCOLORPATH))
		*strFShader += "pixel.a = 1.0 - tt.a;";

}


void ogl_shaders(const poly_extra_data *extra) {
	voodoo_state *v=(voodoo_state*)extra->state;

	GLint res;
	std::string strVShader, strFShader;

	/* shaders extensions not loaded */
	if (!glCreateShaderObjectARB) return;

	Bitu FBZCOLORPATH = extra->r_fbzColorPath;
	Bitu FBZMODE      = extra->r_fbzMode;
	Bitu FOGMODE      = extra->r_fogMode;
	Bitu ALPHAMODE    = extra->r_alphaMode;
	Bitu TEXMODE0     = extra->r_textureMode0;
	Bitu TEXMODE1     = extra->r_textureMode1;
	Bitu texcount     = extra->texcount;

	raster_info curinfo;
	int hash;

	/* build an info struct with all the parameters */
	curinfo.eff_color_path = normalize_color_path(FBZCOLORPATH);
	curinfo.eff_alpha_mode = normalize_alpha_mode(ALPHAMODE);
	curinfo.eff_fog_mode   = normalize_fog_mode(FOGMODE);
	curinfo.eff_fbz_mode   = normalize_fbz_mode(FBZMODE);
	curinfo.eff_tex_mode_0 = (texcount >= 1) ? normalize_tex_mode(TEXMODE0) : 0xffffffff;
	curinfo.eff_tex_mode_1 = (texcount >= 2) ? normalize_tex_mode(TEXMODE1) : 0xffffffff;

	/* compute the hash */
	hash = compute_raster_hash(&curinfo);

	/* build a new shader program */
	if ((shaders.find(hash) == shaders.end())) {

		/* create vertex shader */
		m_hVertexShader = glCreateShaderObjectARB(GL_VERTEX_SHADER_ARB);

		strVShader = 
			"void main()"
			"{"
				"gl_TexCoord[0] = gl_MultiTexCoord0;"
				"gl_TexCoord[1] = gl_MultiTexCoord1;"
				"gl_FrontColor = gl_Color;"
				"gl_Position = ftransform();"
			"}";

		const char *szVShader = strVShader.c_str();
		glShaderSourceARB(m_hVertexShader, 1, &szVShader, NULL);
		glCompileShaderARB(m_hVertexShader);
		glGetObjectParameterivARB(m_hVertexShader, GL_OBJECT_COMPILE_STATUS_ARB, &res);
		if(res == 0) {
			ogl_printInfoLog(m_hVertexShader);
			E_Exit("ERROR: Error compiling vertex shader");
			return;
		}

		/* create fragment shader */
		m_hFragmentShader = glCreateShaderObjectARB(GL_FRAGMENT_SHADER_ARB);
		strFShader = 
			"uniform sampler2D tex0;"
			"uniform sampler2D tex1;"
			"uniform vec4 color0;"
			"uniform vec4 color1;"
			"uniform vec4 chromaKey;"
			"uniform vec4 chromaRange;"
			"uniform float alphaRef;"
			"uniform float zaColor;"

			"void main()"
			"{"
				"vec4 pixel  = vec4(0.0);"
				"vec4 texel  = vec4(1.0);"
				"vec4 clocal = vec4(1.0);"
				"vec4 cother = vec4(0.0);"
				"vec4 tt     = vec4(0.0);"
				"vec4 blend  = vec4(0.0);";

				// TODO glsl depth test? //

				if (texcount >= 2 && v->tmu[1].lodmin < (8 << 8))
				{
					strFShader += "clocal = texture2DProj(tex1,gl_TexCoord[1]);";
					ogl_sh_tex_combine(&strFShader, 1, extra);
					strFShader += "cother = clocal;";
					strFShader += "texel = clocal;";
				}

				if (texcount >= 1 && v->tmu[0].lodmin < (8 << 8))
				{
					strFShader += "clocal = texture2DProj(tex0,gl_TexCoord[0]);";
					ogl_sh_tex_combine(&strFShader, 0, extra);
					strFShader += "texel = clocal;";
				}

				// TODO Clamped ARGB //

				ogl_sh_color_path(&strFShader, extra);

				// TODO fogging //

				if (FBZMODE_RGB_BUFFER_MASK(FBZMODE))
					strFShader += "gl_FragColor = pixel;";

				strFShader += 
			"}";

		const char *szFShader = strFShader.c_str();
		glShaderSourceARB(m_hFragmentShader, 1, &szFShader, NULL);

		glCompileShaderARB(m_hFragmentShader);
		glGetObjectParameterivARB(m_hFragmentShader, GL_OBJECT_COMPILE_STATUS_ARB, &res);
		if(res == 0) {
			ogl_printInfoLog(m_hFragmentShader);
			E_Exit("ERROR: Error compiling fragment shader");
			return;
		}

		
		/* create program object */
		m_hProgramObject = glCreateProgramObjectARB();

		glAttachObjectARB(m_hProgramObject, m_hVertexShader);
		glAttachObjectARB(m_hProgramObject, m_hFragmentShader);

		glLinkProgramARB(m_hProgramObject);

		glGetObjectParameterivARB(m_hProgramObject, GL_OBJECT_LINK_STATUS_ARB, &res);
		if(res == 0) {
			ogl_printInfoLog(m_hProgramObject);
			E_Exit("ERROR: Error linking program");
			return;
		}

		/* use this shader */
		glUseProgramObjectARB(m_hProgramObject);
		shaders[hash] = m_hProgramObject;

		//LOG_MSG("Shaders active");

	} else {
		/* use existing shader program */
		int hashedProgram = shaders[hash];
		if (hashedProgram != m_hProgramObject) {
			glUseProgramObjectARB(hashedProgram);
			m_hProgramObject = hashedProgram;
		}
	}

}


void ogl_draw_triangle(poly_extra_data *extra) {
	voodoo_state *v=extra->state;
	ogl_texture_data td[2];
	ogl_vertex_data vd[3];

	if (!ogl_started) return;

	Bitu ALPHAMODE = extra->r_alphaMode;
	Bitu FBZMODE   = extra->r_fbzMode;

	ogl_cache_texture(extra,td);
	ogl_shaders(extra);

	glUniform4fARB(glGetUniformLocationARB(m_hProgramObject, "chromaKey"), v->reg[chromaKey].rgb.r/256.0f, v->reg[chromaKey].rgb.g/256.0f, v->reg[chromaKey].rgb.b/256.0f,0);
	glUniform4fARB(glGetUniformLocationARB(m_hProgramObject, "chromaRange"), v->reg[chromaRange].rgb.r/256.0f, v->reg[chromaRange].rgb.g/256.0f, v->reg[chromaRange].rgb.b/256.0f,0);
	glUniform4fARB(glGetUniformLocationARB(m_hProgramObject, "color0"), v->reg[color0].rgb.r/256.0f, v->reg[color0].rgb.g/256.0f, v->reg[color0].rgb.b/256.0f, v->reg[color0].rgb.a/256.0f);
	glUniform4fARB(glGetUniformLocationARB(m_hProgramObject, "color1"), v->reg[color1].rgb.r/256.0f, v->reg[color1].rgb.g/256.0f, v->reg[color1].rgb.b/256.0f, v->reg[color1].rgb.a/256.0f);
	glUniform1fARB(glGetUniformLocationARB(m_hProgramObject, "alphaRef"), v->reg[alphaMode].rgb.a/256.0f);
	glUniform1fARB(glGetUniformLocationARB(m_hProgramObject, "zaColor"), (float)((Bit16u)v->reg[zaColor].u)/65536.0f);

	if (extra->texcount > 0) {
		
		if ( td[1].enable ) {
			Bitu TEXMODE = extra->r_textureMode1;
			glActiveTextureARB(GL_TEXTURE1_ARB);
			glBindTexture (GL_TEXTURE_2D, td[1].texID);
			glUniform1iARB(glGetUniformLocationARB(m_hProgramObject,"tex1"),1);

			GLint minFilter;
			minFilter = GL_NEAREST + TEXMODE_MINIFICATION_FILTER(TEXMODE);
			if (v->tmu[1].lodmin != v->tmu[1].lodmax)
				minFilter += 0x0100 + TEXMODE_TRILINEAR(TEXMODE)*2;
			glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,minFilter); 
			glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_NEAREST+TEXMODE_MAGNIFICATION_FILTER(TEXMODE)); 
			glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,TEXMODE_CLAMP_S(TEXMODE)?GL_CLAMP_TO_EDGE:GL_REPEAT);
			glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,TEXMODE_CLAMP_T(TEXMODE)?GL_CLAMP_TO_EDGE:GL_REPEAT);
		}

		if ( td[0].enable ) {
			Bitu TEXMODE = extra->r_textureMode0;
			glActiveTextureARB(GL_TEXTURE0_ARB);
			glBindTexture (GL_TEXTURE_2D, td[0].texID);
			glUniform1iARB(glGetUniformLocationARB(m_hProgramObject,"tex0"),0);

			GLint minFilter;
			minFilter = GL_NEAREST + TEXMODE_MINIFICATION_FILTER(TEXMODE);
			if (v->tmu[0].lodmin != v->tmu[0].lodmax)
				minFilter += 0x0100 + TEXMODE_TRILINEAR(TEXMODE)*2;
			glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,minFilter); 
			glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_NEAREST+TEXMODE_MAGNIFICATION_FILTER(TEXMODE)); 
			glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,TEXMODE_CLAMP_S(TEXMODE)?GL_CLAMP_TO_EDGE:GL_REPEAT);
			glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,TEXMODE_CLAMP_T(TEXMODE)?GL_CLAMP_TO_EDGE:GL_REPEAT);
		}

	}

	if (FBZMODE_ENABLE_DEPTHBUF(FBZMODE) && FBZMODE_AUX_BUFFER_MASK(FBZMODE)) {
		glEnable(GL_DEPTH_TEST);
		glDepthFunc(GL_NEVER+FBZMODE_DEPTH_FUNCTION(FBZMODE));
	}
	else
		glDisable(GL_DEPTH_TEST);

	if (ALPHAMODE_ALPHABLEND(ALPHAMODE)) {
		glBlendFuncSeparate(ogl_sfactor[ALPHAMODE_SRCRGBBLEND(ALPHAMODE)], ogl_dfactor[ALPHAMODE_DSTRGBBLEND(ALPHAMODE)], 
			                            ALPHAMODE_SRCALPHABLEND(ALPHAMODE)==4, ALPHAMODE_DSTALPHABLEND(ALPHAMODE)==4);
		glEnable(GL_BLEND);
	} else {
		glDisable(GL_BLEND);
	}

	ogl_get_vertex_data(v->fbi.ax, v->fbi.ay, (void*)extra, &vd[0]);
	ogl_get_vertex_data(v->fbi.bx, v->fbi.by, (void*)extra, &vd[1]);
	ogl_get_vertex_data(v->fbi.cx, v->fbi.cy, (void*)extra, &vd[2]);

	glBegin(GL_TRIANGLES);

	for (int i=0;i<3;i++) 
	{
		glColor4fv(&vd[i].r); 
		if ( td[0].enable ) glMultiTexCoord4fvARB(GL_TEXTURE0_ARB,&vd[i].m[0].sw); 
		if ( td[1].enable ) glMultiTexCoord4fvARB(GL_TEXTURE1_ARB,&vd[i].m[1].sw); 

		if (FBZMODE_AUX_BUFFER_MASK(FBZMODE))
			glVertex3fv(&vd[i].x); 
		else
			glVertex2fv(&vd[i].x); 
	}

	glEnd();

}


void ogl_swap_buffer() {
	SDL_GL_SwapBuffers ( );
}


void ogl_texture_clear(Bit32u texbase, int TMU) {
	std::map<const Bit32u, GLuint>::iterator t;
	t=textures[TMU].find(texbase);
	if (t != textures[TMU].end()) {
		glDeleteTextures(1,&t->second);
		textures[TMU].erase(t);
	}

}

void ogl_draw_pixel (int x, int y, int r, int g, int b) {
	// TODO redo everything //
	if (m_hProgramObject != 0) {
		glUseProgramObjectARB(0);
		m_hProgramObject = 0;
	}

	glColor3f((float)r/256, (float)g/256, (float)b/256);
	glBegin(GL_POINTS);
	glVertex2i(x, y);
	glEnd();
}

void ogl_draw_pixel_pipeline (int x, int y, int r, int g, int b, int a, Bit32s iterz, Bit64s iterw) {
	Bit32s d;
	// TODO redo everything //
	if (m_hProgramObject != 0) {
		glUseProgramObjectARB(0);
		m_hProgramObject = 0;
	}
	if (FBZMODE_ENABLE_DEPTHBUF(v->reg[fbzMode].u) && FBZMODE_AUX_BUFFER_MASK(v->reg[fbzMode].u)) {
		glEnable(GL_DEPTH_TEST);
		glDepthFunc(GL_NEVER+FBZMODE_DEPTH_FUNCTION(v->reg[fbzMode].u));

		ogl_get_depth(v,iterz, iterw, &d);

		glColor3f((float)r/256, (float)g/256, (float)b/256);
		glBegin(GL_POINTS);
		glVertex3f((float)x, (float)y, (float)((float)d/(float)(0xffff)));
		glEnd();
	}
	else
	{
		glDisable(GL_DEPTH_TEST);
		glColor3f((float)r/256, (float)g/256, (float)b/256);
		glBegin(GL_POINTS);
		glVertex2f((float)x, (float)y);
		glEnd();
	}

}

void ogl_fastfill(poly_extra_data *extra) {
	// TODO actual fastfill routine emulation //

	glClearDepth((float)((Bit16u)v->reg[zaColor].u)/65536.0f);

	glClear ( (GL_COLOR_BUFFER_BIT * FBZMODE_RGB_BUFFER_MASK(v->reg[fbzMode].u))
		    | (GL_DEPTH_BUFFER_BIT * (FBZMODE_AUX_BUFFER_MASK(v->reg[fbzMode].u) && v->fbi.auxoffs != ~0)));
}

void ogl_set_window(voodoo_state *v) {

	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);

	glHint(GL_CLIP_VOLUME_CLIPPING_HINT_EXT,GL_FASTEST);

	glMatrixMode( GL_PROJECTION );
	glLoadIdentity( );
	if (FBZMODE_Y_ORIGIN(v->reg[fbzMode].u))
		glOrtho( 0, v->fbi.width, 0, v->fbi.height, 0.0f, -1.0f );
	else
		glOrtho( 0, v->fbi.width, v->fbi.height, 0, 0.0f, -1.0f );
	glViewport( 0, 0, v->fbi.width, v->fbi.height );
	glMatrixMode( GL_MODELVIEW );
	glLoadIdentity( );
}

void ogl_init(voodoo_state *v) {
	bool ogl_multisampling = false;

	std::map<const Bit32u, GLuint>::iterator t;

	SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE, 24);
	if (ogl_multisampling) {
		SDL_GL_SetAttribute(SDL_GL_MULTISAMPLEBUFFERS, 1);
		SDL_GL_SetAttribute(SDL_GL_MULTISAMPLESAMPLES, 4);
	}

	if (SDL_SetVideoMode(v->fbi.width, v->fbi.height, 32, SDL_OPENGL) == 0)
		E_Exit("opengl init error");
	void GFX_SetIcon(void); GFX_SetIcon();
#ifdef WIN32
	void DOSBox_RefreshMenu2(void); DOSBox_RefreshMenu2();
#endif
	
	for (int j=0; j<2; j++) {
		for (t=textures[j].begin(); t!=textures[j].end(); t++)
			glDeleteTextures(1,&t->second);
		if (!textures[j].empty()) textures[j].clear();
	}

	if (!shaders.empty()) shaders.clear(); // TODO delete shaders?? //

	if (ogl_multisampling)
		glEnable(GL_MULTISAMPLE);

	ogl_set_window(v);
	ogl_load();

	ogl_started = true;
}

