-- Place in this LUA script all the levels of your game
-- Title is mandatory and must be the first level

local Flow = TEN.Flow
local Level = Flow.Level
local Color = TEN.Color
local Rotation = TEN.Rotation
local InventoryItem = Flow.InventoryItem
local InvID = Flow.InvID
local RotationAxis = Flow.RotationAxis
local ItemAction = Flow.ItemAction

-- Title level
Flow.SetIntroImagePath("SCREENS\\MAIN.PNG","SCREENS\\MAINFR.PNG");
Flow.SetTitleScreenImagePath("Screens\\Main.png","Screens\\MainFR.png")
Flow.SetFarView(65);

title = Level.new();

title.ambientTrack = "Free (Waltz Mix)";
title.levelFile = "Data\\title.trc";
title.scriptFile = "Scripts\\title.lua";
title.loadScreenFile = "Screens\\Main.png";
title.loadScreenFileFR = "Screens\\MainFR.png";

Flow.AddLevel(title);

armsrace = Level.new();

armsrace.nameKey = "level_armsrace";
armsrace.scriptFile = "Scripts\\armsrace.lua";
armsrace.ambientTrack = "111";
armsrace.levelFile = "Data\\armsrace.trc";
armsrace.loadScreenFile = "Screens\\Main.png";
armsrace.loadScreenFileFR = "Screens\\MainFR.png";
armsrace.horizon = true
armsrace.farView = 65;
--armsrace.colAddHorizon = true
--armsrace.layer1 = Flow.SkyLayer.new(Color.new(0, 255, 255), 15)
--armsrace.fog = Flow.Fog.new(Color.new(0,0,0),20,25)

armsrace.objects = {
	InventoryItem.new(
		"key_item1",
		InvID.KEY_ITEM1,
		0,
		0.5,
		Rotation.new(-90, 60, 85),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"key_item4",
		InvID.KEY_ITEM4,
		0,
		0.5,
		Rotation.new(-90, 60, 85),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),InventoryItem.new(
		"key_item3",
		InvID.KEY_ITEM3,
		0,
		0.5,
		Rotation.new(-90, 60, 85),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),InventoryItem.new(
		"key_item12",
		InvID.KEY_ITEM12,
		0,
		0.5,
		Rotation.new(-90, 60, 85),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),

};

Flow.AddLevel(armsrace);