local enemyHpString = DisplayString('', 0, 0, Color(0, 0, 0), false)
LevelFuncs.__ShowHpEnemy = function()
    if Lara:GetTarget() ~= nil then
        if LevelVars.enemyHpShadow then
            enemyHpString:SetFlags({ TEN.Strings.DisplayStringOption.SHADOW })
        end
        enemyHpString:SetPosition(PercentToScreen(LevelVars.enemyHpPosX, LevelVars.enemyHpPoY))
        enemyHpString:SetColor(LevelVars.enemyHpColor)
        local textHP = ''
        if LevelVars.showEnemyName then
            textHP = Lara:GetTarget():GetName()
        end
        if textHP == '' then
            textHP = textHP .. LevelVars.enemyHpString
        else
            textHP = textHP .. ' ' .. LevelVars.enemyHpString
        end
        if LevelVars.enemyHpString == '' then
            textHP = textHP .. Lara:GetTarget():GetHP()
        else
            textHP = textHP .. ' ' .. Lara:GetTarget():GetHP()
        end
        enemyHpString:SetKey(textHP)
        if not IsStringDisplaying(enemyHpString) then
            ShowString(enemyHpString)
        end
    else
        HideString(enemyHpString)
    end
end
local ammoMessage = DisplayString('', 0, 0, Color(0, 0, 0), false)
local weaponNameT = { 'pistols', 'revolver', 'uzis', 'shotgun', 'hk', 'crossbow', '7', '8', 'grenade_launcher',
    'harpoon_gun', 'rocket_launcher' }
LevelFuncs.__ShowAmmoCounter = function()
    if Lara:GetHandStatus() == 4 then
        ammoMessage:SetPosition(PercentToScreen(LevelVars.AmmoCounterPosX, LevelVars.AmmoCounterPosY))
        ammoMessage:SetColor(LevelVars.AmmoCounterColor)
        if LevelVars.AmmoCounterShadow then
            ammoMessage:SetFlags({ TEN.Strings.DisplayStringOption.SHADOW })
        end
        local textA = ''
        if LevelVars.ammoCounterWeaponName then
            textA = GetString(weaponNameT[Lara:GetWeaponType()])
        end
        if textA ~= '' then
            if LevelVars.ammoCounterTextA == '' then
                textA = textA .. LevelVars.ammoCounterTextA
            else
                textA = textA .. ' ' .. LevelVars.ammoCounterTextA
            end
        else
            textA = textA .. LevelVars.ammoCounterTextA
        end
        if not (Lara:GetAmmoCount() == -1) then
            if textA ~= '' then
                ammoMessage:SetKey(textA .. ' ' .. Lara:GetAmmoCount())
            else
                ammoMessage:SetKey(textA .. Lara:GetAmmoCount())
            end
        else
            if LevelVars.ammoCounterTextI == '' then
                ammoMessage:SetKey(textA)
            else
                if textA == '' then
                    ammoMessage:SetKey(textA .. LevelVars.ammoCounterTextI)
                else
                    ammoMessage:SetKey(textA .. ' ' .. LevelVars.ammoCounterTextI)
                end
            end
        end
        if not IsStringDisplaying(ammoMessage) then
            ShowString(ammoMessage)
        end
    else
        HideString(ammoMessage)
    end
end

-- !Name "Show enemy hp"
-- !Conditional "False"
-- !Description "Show the name and HP of a targeted enemy"
-- !Section "Miscellaneous"
-- !Arguments "NewLine, Boolean, 80, Show enemy name"
-- !Arguments "NewLine, String, 80, [ NoMultiline ], Hp string"
-- !Arguments "Boolean , 20, Translated"
-- !Arguments "NewLine, Numerical, 30, [ 0 | 1000 | 1 | 0.1], Position x"
-- !Arguments "Numerical, 30, [ 0 | 1000 | 1 | 0.1 ], Position y"
-- !Arguments "Color, 18.5, Text color"
-- !Arguments "Boolean , 20, Shadow"
LevelFuncs.Engine.Node.ShowEnemyHP = function(showEnemyName, hpString, translated, posX, posY, color, shadow)
    LevelVars.showEnemyName = showEnemyName
    LevelVars.enemyHpString = (translated) and GetString(hpString) or hpString
    LevelVars.enemyHpPosX = posX
    LevelVars.enemyHpPoY = posY
    LevelVars.enemyHpColor = color
    LevelVars.enemyHpShadow = shadow
    if LevelVars.enemyHpString ~= ' String not found. ' then
        AddCallback(TEN.Logic.CallbackPoint.POSTCONTROLPHASE, LevelFuncs.__ShowHpEnemy)
        PrintLog('Enemy hp viewer initialized correctly', LogLevel.INFO)
    else
        PrintLog('Error in the "Show hp enemy" node. Hp string not found', LogLevel.ERROR)
    end
end

-- !Name "Remove show enemy hp"
-- !Conditional "False"
-- !Description "Remove display HP of a targeted enemy"
-- !Section "Miscellaneous"
LevelFuncs.Engine.Node.RemoveShowEnemyHP = function()
    RemoveCallback(TEN.Logic.CallbackPoint.POSTCONTROLPHASE, LevelFuncs.__ShowHpEnemy)
    HideString(enemyHpString)
end

-- !Name "Show ammo counter"
-- !Conditional "False"
-- !Description "Displays the number of available ammo of the weapon in hand"
-- !Section "Miscellaneous"
-- !Arguments "NewLine, Boolean, 80, Show weapon name"
-- !Arguments "NewLine, String, 80, [ NoMultiline ], Text before ammo count "
-- !Arguments "Boolean , 20, Translated"
-- !Arguments "NewLine, String, 80, [ NoMultiline ], Text for infinite ammo"
-- !Arguments "Boolean , 20, Translated"
-- !Arguments "NewLine, Numerical, 29.2, [ 0 | 1000 | 1 | 0.1], Counter position x"
-- !Arguments "Numerical, 29.2, [ 0 | 1000 | 1 | 0.1 ], Counter Position y"
-- !Arguments "Color, 20.1, Counter text color"
-- !Arguments "Boolean , 20, Shadow"
LevelFuncs.Engine.Node.ShowAmmoCounter = function(weaponName, textAmmo, translAmmo, textInfinite, translInfinite, posX,
                                                  posY, color, shadow)
    LevelVars.ammoCounterWeaponName = weaponName
    LevelVars.ammoCounterTextA = (translAmmo) and GetString(textAmmo) or textAmmo
    LevelVars.ammoCounterTextI = (translInfinite) and GetString(textInfinite) or textInfinite
    LevelVars.AmmoCounterColor = color
    LevelVars.AmmoCounterPosX = posX
    LevelVars.AmmoCounterPosY = posY
    LevelVars.AmmoCounterShadow = shadow
    if LevelVars.ammoCounterTextA ~= 'String not found. ' and LevelVars.ammoCounterTextI ~= 'String not found.' then
        AddCallback(TEN.Logic.CallbackPoint.POSTCONTROLPHASE, LevelFuncs.__ShowAmmoCounter)
        PrintLog('Ammo counter initialized correctly', LogLevel.INFO)
    else
        local error = ''
        error = (LevelVars.ammoCounterTextA == 'String not found. ') and ' Text ammo not found.' or ''
        error = (LevelVars.ammoCounterTextI == 'String not found.') and error .. ' Text infinite not found.' or ''
        PrintLog('Error in the "Show ammo counter" node.' .. error, LogLevel.ERROR)
    end
end

-- !Name "Remove ammo counter"
-- !Conditional "False"
-- !Description "Remove the number of available ammo"
-- !Section "Miscellaneous"
LevelFuncs.Engine.Node.RemoveAmmoCounter = function()
    RemoveCallback(TEN.Logic.CallbackPoint.POSTCONTROLPHASE, LevelFuncs.__ShowAmmoCounter)
    HideString(ammoMessage)
end
