-- Place in this Lua script all the levels of your game
-- Title is mandatory and must be the first level.

-- Intro image is a splash screen which appears before actual loading screen.
-- If you don't want it to appear, just remove this line.

-- Flow.SetIntroImagePath("Screens\\towerbridge.jpg")

-- This image should be used for static title screen background (as in TR1-TR3).
-- For now it is not implemented.

Flow.SetTitleScreenImagePath("Screens\\towerbridge.jpg")

-- Set overall amount of secrets in game.
-- If set to 0, secrets won't be displayed in statistics.

Flow.SetTotalSecretCount(11)

-- Disable/enable flycheat globally

Flow.EnableFlyCheat(false)

-- Disable/enable Lara drawing in title level

Flow.EnableLaraInTitle(true)

-- Disable/enable level selection in title level

Flow.EnableLevelSelect(false)

-- Disable/enable mass pickup (collect all pickups at once)

Flow.EnableMassPickup(true)

-- Disable pixel filtering for textures

Flow.EnablePointFilter(true)

--------------------------------------------------

-- Title level

title = Level.new()

title.ambientTrack = "110"
title.levelFile = "Data\\title.ten"
title.scriptFile = "Scripts\\title.lua"
title.loadScreenFile = "Screens\\towerbridge.jpg"

Flow.AddLevel(title)

--------------------------------------------------

-- First level

towerbridge = Level.new()

towerbridge.nameKey = "tower_bridge"
towerbridge.scriptFile = "Scripts\\Tower_Bridge.lua"
towerbridge.ambientTrack = "108"
towerbridge.levelFile = "Data\\Tower_Bridge.ten"
towerbridge.loadScreenFile = "Screens\\towerbridge.jpg"

-- 0 is no weather, 1 is rain, 2 is snow.
-- Strength varies from 0 to 1 (floating-point value, e.g. 0.5 means half-strength).

towerbridge.weather = 1
towerbridge.weatherStrength = 0.99

towerbridge.horizon = true
towerbridge.farView = 180
towerbridge.layer1 = Flow.SkyLayer.new(Color.new(18, 20, 40), 5)
-- towerbridge.fog = Flow.Fog.new(Color.new(74, 69, 86), 30, 150)
-- towerbridge.fog = Flow.Fog.new(Color.new(21, 22, 21), 100, 190)
towerbridge.fog = Flow.Fog.new(Color.new(169, 151, 128), 1, 190)
-- towerbridge.secrets = 10

towerbridge.objects = {
    InventoryItem.new(
        "polaroid1",
        ObjID.EXAMINE1,
        -10,
        1.1,
        Rotation.new(270, 0, 0),
        RotationAxis.Y,
        -1,
        ItemAction.EXAMINE
    ),
    InventoryItem.new(
        "polaroid2",
        ObjID.EXAMINE2,
        -10,
        1.1,
        Rotation.new(270, 0, 0),
        RotationAxis.Y,
        -1,
        ItemAction.EXAMINE
    ),
    InventoryItem.new(
        "polaroid3",
        ObjID.EXAMINE3,
        -10,
        1.1,
        Rotation.new(270, 0, 0),
        RotationAxis.Y,
        -1,
        ItemAction.EXAMINE
    ),
    InventoryItem.new(
        "polaroid4",
        ObjID.EXAMINE4,
        -10,
        1.1,
        Rotation.new(270, 0, 0),
        RotationAxis.Y,
        -1,
        ItemAction.EXAMINE
    ),
    InventoryItem.new(
        "polaroid5",
        ObjID.EXAMINE5,
        -10,
        1.1,
        Rotation.new(270, 0, 0),
        RotationAxis.Y,
        -1,
        ItemAction.EXAMINE
    ),
    InventoryItem.new(
        "polaroid6",
        ObjID.EXAMINE6,
        -10,
        1.1,
        Rotation.new(270, 0, 0),
        RotationAxis.Y,
        -1,
        ItemAction.EXAMINE
    ),
    InventoryItem.new(
        "polaroid7",
        ObjID.EXAMINE7,
        -10,
        1.1,
        Rotation.new(270, 0, 0),
        RotationAxis.Y,
        -1,
        ItemAction.EXAMINE
    ),
    InventoryItem.new(
        "polaroid8",
        ObjID.EXAMINE8,
        -10,
        1.1,
        Rotation.new(270, 0, 0),
        RotationAxis.Y,
        -1,
        ItemAction.EXAMINE
    ),
    InventoryItem.new(
        "polaroid9",
        ObjID.PUZZLE_ITEM15,
        -10,
        1.1,
        Rotation.new(270, 0, 0),
        RotationAxis.Y,
        -1,
        ItemAction.EXAMINE
    ),
    InventoryItem.new(
        "polaroid10",
        ObjID.PUZZLE_ITEM16,
        -10,
        1.1,
        Rotation.new(270, 0, 0),
        RotationAxis.Y,
        -1,
        ItemAction.EXAMINE
    ),
    InventoryItem.new(
        "snowglobe",
        ObjID.PICKUP_ITEM1,
        0,
        0.5,
        Rotation.new(0, 0, 0),
        RotationAxis.Y,
        -1,
        ItemAction.USE
    ),
    InventoryItem.new(
        "tut1_ba_cartouche",
        ObjID.PUZZLE_ITEM3,
        0,
        0.5,
        Rotation.new(0, 0, 0),
        RotationAxis.Y,
        -1,
        ItemAction.USE
    ),
    InventoryItem.new(
        "tut1_hand_orion",
        ObjID.PUZZLE_ITEM6,
        0,
        0.5,
        Rotation.new(270, 180, 0),
        RotationAxis.Y,
        -1,
        ItemAction.USE
    ),
    InventoryItem.new(
        "tut1_hand_sirius",
        ObjID.PUZZLE_ITEM8,
        0,
        0.5,
        Rotation.new(270, 180, 0),
        RotationAxis.X,
        -1,
        ItemAction.USE
    ),
    InventoryItem.new(
        "key1",
        ObjID.KEY_ITEM1,
        0,
        0.5,
        Rotation.new(270, 180, 0),
        RotationAxis.Y,
        -1,
        ItemAction.USE
    ),
    InventoryItem.new(
        "key2",
        ObjID.KEY_ITEM2,
        0,
        0.5,
        Rotation.new(270, 180, 0),
        RotationAxis.Y,
        -1,
        ItemAction.USE
    ),
    InventoryItem.new(
        "key3",
        ObjID.KEY_ITEM3,
        0,
        0.5,
        Rotation.new(270, 180, 0),
        RotationAxis.Y,
        -1,
        ItemAction.USE
    ),
    InventoryItem.new(
        "key8",
        ObjID.KEY_ITEM8,
        0,
        0.5,
        Rotation.new(270, 180, 0),
        RotationAxis.Y,
        -1,
        ItemAction.USE
    )
};

Flow.AddLevel(towerbridge)