-- New level script file.
-- To include other script files, you can use require("filename") command.
local CutsceneScript = require("Engine.CutsceneScript")
local phrase = DisplayString('test', 50, 50, Color(50, 250, 250), false,
    { TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW })
LevelFuncs.ShowPhrase = function(time, text, x, y, color)
    phrase:SetKey(text)
    phrase:SetColor(color)
    phrase:SetPosition(PercentToScreen(x, y))
    ShowString(phrase, time)
end

local EventSequence = require("Engine.EventSequence")
local Timer = require("Engine.Timer")

-- Hold Lua name of current actor speaking.
LevelVars.CurrentActorSpeaking = {}
-- Hold Lua name of last actor speaking (use this to make them go back to normal when not speaking.)
LevelVars.LastActorSpeaking = {}

-- Put Lua name of object here with their corresponding head bone number.
LevelVars.ActorHeadBoneTable = {
    natla = 8,
    lara_1 = 14
}

LevelVars.natlaWeights = {
    {0.01, ObjID.ANIMATING19},
    {0.1, ObjID.ACTOR1_SPEECH_HEAD1},
    {0.4, ObjID.ACTOR1_SPEECH_HEAD2}
}

LevelVars.LaraWeights = {
    {0.01, ObjID.LARA_SKIN},
    {0.05, ObjID.LARA_SPEECH_HEAD3},
    {0.1, ObjID.LARA_SPEECH_HEAD2},
    {0.4, ObjID.LARA_SPEECH_HEAD1}
}

LevelVars.ActorMouthWeights = {
    lara_1 = LevelVars.LaraWeights,
    natla = LevelVars.natlaWeights
}

LevelFuncs.SetActorSpeaking = function(lua_name)
	print("Setting current speaking actor to: " .. lua_name)
    LevelVars.CurrentActorSpeaking = lua_name
end

-- Called when entering a level, either after leveljump, new game or loading game
LevelFuncs.OnStart = function()
    SetStaticsSoftCollision()
	LevelVars.LastActorSpeaking = ''
	LevelVars.CurrentActorSpeaking = ''
end

-- Called after loading from a save
LevelFuncs.OnLoad = function()
end

-- Called after saving game
LevelFuncs.OnSave = function()
end

-- Called on every frame of the game
-- dt stands for "delta time", and holds the time in seconds since the last call to OnControlPhase
LevelFuncs.OnControlPhase = function()
--    ShowAmmoCounter()
	local subtitle = GetCurrentSubtitle()
	if (subtitle ~= nil and subtitle ~= '') then  
		local x, y = PercentToScreen(50, 83)
		local str = DisplayString(subtitle, x, y, TEN.Color(125,205,255), false,
		{ DisplayStringOption.SHADOW, DisplayStringOption.CENTER })
	ShowString(str, 1/30)
	end
	
	-- If anyone is speaking, we want to make their mouths move.
	if LevelVars.CurrentActorSpeaking and LevelVars.CurrentActorSpeaking ~= '' then
    
        local actor = GetMoveableByName(LevelVars.CurrentActorSpeaking)
        local head_bone = LevelVars.ActorHeadBoneTable[LevelVars.CurrentActorSpeaking]

        -- Someone is talking, so get current voice track loudness.
        local voice_level = GetAudioTrackLoudness(SoundTrackType.VOICE)
        
        for _, i in ipairs(LevelVars.ActorMouthWeights[LevelVars.CurrentActorSpeaking]) do
        	local weight = i[1]
        	local meshswap = i[2]
        	
            if voice_level >= weight then
                actor:SwapMesh(head_bone, meshswap)
        end
        
		if LevelVars.LastActorSpeaking ~= LevelVars.CurrentActorSpeaking and LevelVars.LastActorSpeaking ~= '' then
			print(LevelVars.CurrentActorSpeaking .. "is now speaking...")
			print("Looking for ".. tostring(LevelVars.LastActorSpeaking))
			local old_actor = GetMoveableByName(LevelVars.LastActorSpeaking)
    		old_actor:UnswapMesh(LevelVars.ActorHeadBoneTable[LevelVars.LastActorSpeaking])
        end
        
        LevelVars.LastActorSpeaking = LevelVars.CurrentActorSpeaking
    end
    -- Otherwise, if we just stopped speaking, check who was last speaking and close their mouth.
    else
		if LevelVars.LastActorSpeaking ~= LevelVars.CurrentActorSpeaking and LevelVars.LastActorSpeaking ~= '' then
    	print(LevelVars.LastActorSpeaking .. " is no longer speaking, so reverting their head meshswap...")
        local actor = GetMoveableByName(LevelVars.LastActorSpeaking)
        actor:UnswapMesh(LevelVars.ActorHeadBoneTable[LevelVars.LastActorSpeaking])
        LevelVars.LastActorSpeaking = ''
        end
    end
end

-- Called when level is ended, either after leveljump, quitting to title or loading game
LevelFuncs.OnEnd = function()
end

-- An example function which prints a string and leaves it on screen for 1 second.
-- Argument should be typed in TE trigger manager window's argument text field.

LevelFuncs.PrintText = function(Triggerer, Argument)
    local TestText = DisplayString(Argument, 100, 100, Color.new(250, 250, 250))
    ShowString(TestText, 1)
end

LevelFuncs.MoveObject = function(activator, direction)
    local offset = Vec3(0, 0, 0)

    if (direction == "west") then
        offset.x = 11
    elseif (direction == "east") then
        offset.x = -11
    elseif (direction == "north") then
        offset.z = -11
    elseif (direction == "south") then
        offset.z = 11
    end

    activator:SetPosition(activator:GetPosition() + offset)
end

function SetStaticsSoftCollision()
    local staticSlots = {
        1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 14, 15, 17, 23, 24, 29, 31, 32, 33, 34, 35, 36, 42, 43, 73, 74, 77, 78, 79,
        80, 82, 83, 84, 85, 86, 90, 91, 100, 101, 102, 103, 104, 105, 106, 107, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122
    }

    for index, staticSlot in pairs(staticSlots) do
        local statics = GetStaticsBySlot(staticSlot)

        for index, static in pairs(statics) do
            static:SetSolid(false)
        end
    end
end

LevelFuncs.Nothing = function()
    print('nothing')
end
local myTimer = nil

LevelFuncs.TriggerTimer = function(obj)
    myTimer = Timer.Create("my_timer",
        78,
        false,
        { minutes = true, seconds = true, deciseconds = true },
        LevelFuncs.Nothing)
    myTimer:Start()
end

LevelFuncs.StopTimer = function(obj)
    myTimer:Stop()
end

LevelFuncs.CloseDoorsTimer = function()
    local doorTimer1 = GetMoveableByName("door_type5_1840")
    local doorTimer2 = GetMoveableByName("door_type8_1880")
    doorTimer1:Disable()
    doorTimer2:Disable()
end

LevelFuncs.natlaTalk = function ()
	LevelFuncs.Engine.Node.PlayAudioTrack("024_Cutscene", SoundTrackType.VOICE)
	
	local natlaCutscene = CutsceneScript.Create("natlaCutscene", false,
		0.0, { LevelFuncs.SetActorSpeaking, "natla"},
		1.25, { LevelFuncs.SetActorSpeaking, "lara_1"},
		5.6, { LevelFuncs.SetActorSpeaking, "natla"},
		8.8, { LevelFuncs.SetActorSpeaking, "lara_1"},
		10.6, { LevelFuncs.SetActorSpeaking, "natla" },
		14.7, { LevelFuncs.SetActorSpeaking, "lara_1"},
		21.9, { LevelFuncs.SetActorSpeaking, "natla" },
		37.27, { LevelFuncs.SetActorSpeaking, "lara_1"},
		39.7, { LevelFuncs.SetActorSpeaking, "natla" },
		45.46, { LevelFuncs.SetActorSpeaking, "lara_1"},
		56.86, { LevelFuncs.SetActorSpeaking, "natla" }
	)
	natlaCutscene:Start()
end

LevelFuncs.natlaComment = function ()
	LevelFuncs.Engine.Node.PlayAudioTrack("026_snowglobe", SoundTrackType.VOICE)
	
	local natlaCutscene2 = CutsceneScript.Create("natlaCutscene2", false,
		0.0, { LevelFuncs.SetActorSpeaking, "natla"}
	)
	natlaCutscene2:Start()
end