-- Place in this Lua script all the levels of your game
-- Title is mandatory and must be the first level.

-- Intro image is a splash screen which appears before actual loading screen.
-- If you don't want it to appear, just remove this line.

Flow.SetIntroImagePath("Screens\\main.jpg")

-- This image should be used for static title screen background (as in TR1-TR3).
-- For now it is not implemented.

Flow.SetTitleScreenImagePath("Screens\\main.jpg")

-- Set overall amount of secrets in game.
-- If set to 0, secrets won't be displayed in statistics.

Flow.SetTotalSecretCount(0)

-- Disable/enable flycheat globally

Flow.EnableFlyCheat(false)

-- Disable/enable Lara drawing in title level

Flow.EnableLaraInTitle(true)

-- Disable/enable level selection in title level

Flow.EnableLevelSelect(false)

-- Disable/enable mass pickup (collect all pickups at once)

Flow.EnableMassPickup(true)

Flow.SetIntroImagePath("main.jpg")

--------------------------------------------------

-- Title level

title = Level.new()

title.ambientTrack = "104"
title.levelFile = "Data\\Meteorite_Cavern_title.ten"
title.scriptFile = "Scripts\\title.lua"

Flow.AddLevel(title)

--------------------------------------------------
-- Mode Select (Level 1)
Mode_Select_Level = Level.new()

Mode_Select_Level.nameKey = "Mode_Select_Level"
Mode_Select_Level.scriptFile = "Scripts\\Part_1_End.lua"
Mode_Select_Level.ambientTrack = "001 level statistic"
Mode_Select_Level.horizon = true
Mode_Select_Level.levelFile = "Data\\Mode_Select_Level.ten"
Mode_Select_Level.loadScreenFile = "Screens\\main.jpg"

Flow.AddLevel(Mode_Select_Level)

--------------------------------------------------

--------------------------------------------------
-- Escape from Meteorite Cavern (Level 2)
Meteorite_Cavern = Level.new()

Meteorite_Cavern.nameKey = "Meteorite_Cavern"
Meteorite_Cavern.scriptFile = "Scripts\\Meteorite_Cavern.lua"
Meteorite_Cavern.ambientTrack = "113"
Meteorite_Cavern.horizon = true
Meteorite_Cavern.levelFile = "Data\\Meteorite_Cavern.ten"
Meteorite_Cavern.loadScreenFile = "Screens\\ANTARC_v2.JPG"
Meteorite_Cavern.weather = WeatherType.Snow
Meteorite_Cavern.weatherStrength = 1.0
Meteorite_Cavern.secrets = 3

Meteorite_Cavern.objects = {
	InventoryItem.new(
		"Meteorite_Artifacts",
		ObjID.PICKUP_ITEM1,
		100,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.EXAMINE
	),
	InventoryItem.new(
		"Telegram_Willard",
		ObjID.EXAMINE1_COMBO1,
		100,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.EXAMINE
	),
	InventoryItem.new(
		"Merc_Note",
		ObjID.EXAMINE2,
		100,
		0.5,
		Rotation.new(270, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.EXAMINE
	),
	InventoryItem.new(
		"Silver_Key",
		ObjID.KEY_ITEM1,
		100,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"Helicopter_Keys",
		ObjID.KEY_ITEM2,
		100,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.EXAMINE
	),
	InventoryItem.new(
		"Blue_Star_Escape_Key",
		ObjID.KEY_ITEM3,
		100,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	)
}

Flow.AddLevel(Meteorite_Cavern)
--------------------------------------------------
-- Highland Fling (Level 3)
Highland_Fling = Level.new()

Highland_Fling.nameKey = "Highland_Fling"
Highland_Fling.scriptFile = "Scripts\\Highland_Fling.lua"
Highland_Fling.ambientTrack = "112"
Highland_Fling.horizon = true
Highland_Fling.levelFile = "Data\\Highland_Fling.ten"
Highland_Fling.loadScreenFile = "Screens\\Highland.jpg"
Highland_Fling.weather = WeatherType.Rain
Highland_Fling.weatherStrength = 1.0

Highland_Fling.secrets = 5

Highland_Fling.objects = {
	InventoryItem.new(
		"Lock_Pick",
		ObjID.PUZZLE_ITEM1,
		0,
		0.5,
		Rotation.new(270, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"Purple_Rose",
		ObjID.PUZZLE_ITEM2,
		0,
		0.5,
		Rotation.new(270, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"Celtic_Sword",
		ObjID.PUZZLE_ITEM3,
		100,
		0.5,
		Rotation.new(270, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"Brittle_Knife",
		ObjID.PUZZLE_ITEM4,
		0,
		0.5,
		Rotation.new(270, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"Scottish_Tomb_Stone",
		ObjID.KEY_ITEM1,
		100,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"Skull_Key",
		ObjID.KEY_ITEM2,
		30,
		0.5,
		Rotation.new(270, 0, 90),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"Telegram_Willard",
		ObjID.EXAMINE1_COMBO1,
		100,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.EXAMINE
	),
	InventoryItem.new(
		"Merc_Note",
		ObjID.EXAMINE2,
		100,
		0.5,
		Rotation.new(270, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.EXAMINE
	),
	InventoryItem.new(
		"Meteorite_Artifacts",
		ObjID.PICKUP_ITEM1,
		100,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.EXAMINE
	),
	InventoryItem.new(
		"Blue_Star_Key",
		ObjID.KEY_ITEM3,
		100,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	)
}

Flow.AddLevel(Highland_Fling)

--------------------------------------------------
-- Willard's Lair (Level 3)
Willards_Lair = Level.new()

Willards_Lair.nameKey = "Willards_Lair"
Willards_Lair.scriptFile = "Scripts\\Willards_Lair.lua"
Willards_Lair.ambientTrack = "101"
Willards_Lair.horizon = true
Willards_Lair.levelFile = "Data\\Willards_Lair.ten"
Willards_Lair.loadScreenFile = "Screens\\Willard.jpg"
Willards_Lair.weather = WeatherType.Rain
Willards_Lair.weatherStrength = 1.0

Willards_Lair.secrets = 3

Willards_Lair.objects = {
	InventoryItem.new(
		"Lock_Pick",
		ObjID.PUZZLE_ITEM1,
		0,
		0.5,
		Rotation.new(270, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"Purple_Rose",
		ObjID.PUZZLE_ITEM2,
		0,
		0.5,
		Rotation.new(270, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"Celtic_Sword",
		ObjID.PUZZLE_ITEM3,
		100,
		0.5,
		Rotation.new(270, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"Brittle_Knife",
		ObjID.PUZZLE_ITEM4,
		0,
		0.5,
		Rotation.new(270, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"Scottish_Tomb_Stone",
		ObjID.KEY_ITEM1,
		100,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"Skull_Key",
		ObjID.KEY_ITEM2,
		30,
		0.5,
		Rotation.new(270, 0, 90),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"Telegram_Willard",
		ObjID.EXAMINE1_COMBO1,
		100,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.EXAMINE
	),
	InventoryItem.new(
		"Merc_Note",
		ObjID.EXAMINE2,
		100,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.EXAMINE
	),
	InventoryItem.new(
		"Meteorite_Artifacts",
		ObjID.PICKUP_ITEM1,
		100,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.EXAMINE
	)
}

Flow.AddLevel(Willards_Lair)

--------------------------------------------------
-- Part 1 End (Level 4)
Part_1_End = Level.new()

Part_1_End.nameKey = "Part_1_End"
Part_1_End.scriptFile = "Scripts\\Part_1_End.lua"
Part_1_End.ambientTrack = "001 level statistic"
Part_1_End.horizon = true
Part_1_End.levelFile = "Data\\Part_1_End.ten"
Part_1_End.loadScreenFile = "Screens\\main.jpg"

Flow.AddLevel(Part_1_End)

--------------------------------------------------
-- Laras Home (Level 5)
Lara_Home = Level.new()

Lara_Home.nameKey = "Lara_Home"
Lara_Home.scriptFile = "Scripts\\Lara_Home.lua"
Lara_Home.ambientTrack = "115"
Lara_Home.horizon = true
Lara_Home.levelFile = "Data\\Lara_Home.ten"
Lara_Home.loadScreenFile = "Screens\\FKCM.jpg"

Flow.AddLevel(Lara_Home)
--------------------------------------------------
-- Shakespeare Cliff (Level 6)
Shakespeare_Cliff = Level.new()

Shakespeare_Cliff.nameKey = "Shakespeare_Cliff"
Shakespeare_Cliff.scriptFile = "Scripts\\Shakespeare_Cliff.lua"
Shakespeare_Cliff.ambientTrack = "112"
Shakespeare_Cliff.horizon = true
Shakespeare_Cliff.levelFile = "Data\\Shakespeare_Cliff.ten"
Shakespeare_Cliff.loadScreenFile = "Screens\\Chunnel.jpg"
Shakespeare_Cliff.weather = WeatherType.Rain
Shakespeare_Cliff.weatherStrength = 0.85

Shakespeare_Cliff.objects = {
	InventoryItem.new(
		"Drill_Key_A",
		ObjID.PUZZLE_ITEM2,
		100,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"Drill_Keycard_A",
		ObjID.KEY_ITEM1,
		100,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	)
}

Flow.AddLevel(Shakespeare_Cliff)

--------------------------------------------------
-- Sleeping_With_The_Fishes (Level 7)
Sleeping_With_The_Fishes = Level.new()

Sleeping_With_The_Fishes.nameKey = "Sleeping_With_The_Fishes"
Sleeping_With_The_Fishes.scriptFile = "Scripts\\Sleeping_With_The_Fishes.lua"
Sleeping_With_The_Fishes.ambientTrack = "110"
Sleeping_With_The_Fishes.horizon = true
Sleeping_With_The_Fishes.levelFile = "Data\\Sleeping_With_The_Fishes.ten"
Sleeping_With_The_Fishes.loadScreenFile = "Screens\\undersea.jpg"
Sleeping_With_The_Fishes.fog = Flow.Fog.new(Color.new(22, 46, 95), 1, 30)

Flow.AddLevel(Sleeping_With_The_Fishes)

--------------------------------------------------
-- Part 2 End (Level 8)
Part_2_End = Level.new()

Part_2_End.nameKey = "Part_2_End"
Part_2_End.scriptFile = "Scripts\\Part_1_End.lua"
Part_2_End.ambientTrack = "001 level statistic"
Part_2_End.horizon = true
Part_2_End.levelFile = "Data\\Part_2_End.ten"
Part_2_End.loadScreenFile = "Screens\\main.jpg"

Flow.AddLevel(Part_2_End)

--------------------------------------------------
-- Madhouse (Level 9)
Madhouse = Level.new()
Madhouse.nameKey = "Madhouse"
Madhouse.scriptFile = "Scripts\\Madhouse.lua"
Madhouse.ambientTrack = "110"
Madhouse.horizon = true
Madhouse.levelFile = "Data\\Madhouse.ten"
Madhouse.loadScreenFile = "Screens\\zoo.jpg"
Madhouse.weather = WeatherType.Rain
Madhouse.weatherStrength = 1.0

Flow.AddLevel(Madhouse)

--------------------------------------------------
-- Reunion (Level 10)
Reunion = Level.new()

Reunion.nameKey = "Reunion"
Reunion.scriptFile = "Scripts\\Reunion.lua"
Reunion.ambientTrack = "112"
Reunion.horizon = true
Reunion.levelFile = "Data\\Reunion.ten"
Reunion.loadScreenFile = "Screens\\Slinc.jpg"
Reunion.weather = WeatherType.Rain
Reunion.weatherStrength = 0.85

Flow.AddLevel(Reunion)



--------------------------------------------------
-- Escape from Meteorite Cavern (Level 1)
Meteorite_Cavern_Classic = Level.new()

Meteorite_Cavern_Classic.nameKey = "Meteorite_Cavern_Classic"
Meteorite_Cavern_Classic.scriptFile = "Scripts\\Meteorite_Cavern_Classic.lua"
Meteorite_Cavern_Classic.ambientTrack = "113"
Meteorite_Cavern_Classic.horizon = true
Meteorite_Cavern_Classic.levelFile = "Data\\Meteorite_Cavern_Classic.ten"
Meteorite_Cavern_Classic.loadScreenFile = "Screens\\ANTARC.JPG"
Meteorite_Cavern_Classic.weather = WeatherType.Snow
Meteorite_Cavern_Classic.weatherStrength = 1.0
Meteorite_Cavern_Classic.secrets = 4

Meteorite_Cavern_Classic.objects = {
	InventoryItem.new(
		"Meteorite_Artifacts",
		ObjID.PICKUP_ITEM1,
		100,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.EXAMINE
	),
	InventoryItem.new(
		"Telegram_Willard",
		ObjID.EXAMINE1_COMBO1,
		100,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.EXAMINE
	),
	InventoryItem.new(
		"Merc_Note",
		ObjID.EXAMINE2,
		100,
		0.5,
		Rotation.new(270, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.EXAMINE
	),
	InventoryItem.new(
		"Silver_Key",
		ObjID.KEY_ITEM1,
		100,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"Helicopter_Keys",
		ObjID.KEY_ITEM2,
		100,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.EXAMINE
	),
	InventoryItem.new(
		"Blue_Star_Escape_Key",
		ObjID.KEY_ITEM3,
		100,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	)
}

Flow.AddLevel(Meteorite_Cavern_Classic)

--------------------------------------------------
-- Highland Fling (Level 3)
Highland_Fling_Classic = Level.new()

Highland_Fling_Classic.nameKey = "Highland_Fling_Classic"
Highland_Fling_Classic.scriptFile = "Scripts\\Highland_Fling.lua"
Highland_Fling_Classic.ambientTrack = "112"
Highland_Fling_Classic.horizon = true
Highland_Fling_Classic.levelFile = "Data\\Highland_Fling_Classic.ten"
Highland_Fling_Classic.loadScreenFile = "Screens\\Highland.jpg"
Highland_Fling_Classic.weather = WeatherType.Rain
Highland_Fling_Classic.weatherStrength = 1.0

Highland_Fling_Classic.secrets = 9

Highland_Fling_Classic.objects = {
	InventoryItem.new(
		"Lock_Pick",
		ObjID.PUZZLE_ITEM1,
		0,
		0.5,
		Rotation.new(270, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"Purple_Rose",
		ObjID.PUZZLE_ITEM2,
		0,
		0.5,
		Rotation.new(270, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"Celtic_Sword",
		ObjID.PUZZLE_ITEM3,
		100,
		0.5,
		Rotation.new(270, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"Brittle_Knife",
		ObjID.PUZZLE_ITEM4,
		0,
		0.5,
		Rotation.new(270, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"Scottish_Tomb_Stone",
		ObjID.KEY_ITEM1,
		100,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"Skull_Key",
		ObjID.KEY_ITEM2,
		30,
		0.5,
		Rotation.new(270, 0, 90),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"Telegram_Willard",
		ObjID.EXAMINE1_COMBO1,
		100,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.EXAMINE
	),
	InventoryItem.new(
		"Merc_Note",
		ObjID.EXAMINE2,
		100,
		0.5,
		Rotation.new(270, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.EXAMINE
	),
	InventoryItem.new(
		"Meteorite_Artifacts",
		ObjID.PICKUP_ITEM1,
		100,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.EXAMINE
	),
	InventoryItem.new(
		"Blue_Star_Key",
		ObjID.KEY_ITEM3,
		100,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	)
}

Flow.AddLevel(Highland_Fling_Classic)

--------------------------------------------------
-- Outfit Test
Outfit_Test = Level.new()

Outfit_Test.nameKey = "Outfit_Test"
Outfit_Test.scriptFile = "Scripts\\Outfit_Test.lua"
Outfit_Test.ambientTrack = "112"
Outfit_Test.horizon = true
Outfit_Test.levelFile = "Data\\Outfit_Test.ten"
Outfit_Test.loadScreenFile = "Screens\\House.jpg"

Flow.AddLevel(Outfit_Test)