---- FILE: \Highland_Fling.lua

LevelFuncs.OnLoad = function() end
LevelFuncs.OnSave = function() end
LevelFuncs.OnStart = function() end
LevelFuncs.OnControlPhase = function() 
	SprintSlide("LARA_MAIN")
	TR3_INV_SFX_OPEN()
end
LevelFuncs.OnEnd = function() end

-- Timer Functions
local Timer = require("Engine.Timer")

-- EventSequences
local EventSequence = require("Engine.EventSequence")

local useTimer = 1.0

-- This function triggers the timer
LevelFuncs.Sword_Bridge_Door_Timer = function(numSeconds)
	local my_Sword_Bridge_Door_Timer = Timer.Create("my_Sword_Bridge_Door_Timer",
		numSeconds,
        false,
        {minutes = false, seconds = true, deciseconds = true})
    my_Sword_Bridge_Door_Timer:Start()
end

LevelFuncs.Left_Bridge_Tower_Door_Timer = function(numSeconds)
    local my_Left_Bridge_Tower_Door_Timer = Timer.Create("my_Left_Bridge_Tower_Door_Timer",
        numSeconds,
        false,
        {minutes = false, seconds = true, deciseconds = true})
    my_Left_Bridge_Tower_Door_Timer:Start()
end

LevelFuncs.Left_Bridge_Door_Timer = function(numSeconds)
    local my_Left_Bridge_Door_Timer = Timer.Create("my_Left_Bridge_Door_Timer",
        numSeconds,
        false,
        {minutes = false, seconds = true, deciseconds = true})
    my_Left_Bridge_Door_Timer:Start()
end

LevelFuncs.TriggerTimer = function(numSeconds)
    local myTimer = Timer.Create("my_Timer",
        numSeconds,
        false,
        {minutes = false, seconds = true, deciseconds = true})
    myTimer:Start()
end



LevelFuncs.GetStatistics = function(nextLevel, totalSecretsSoFar)

	-- flag for demo functionality HEHE
	local isDemo = false
	
	-- play level end stats
	TEN.Misc.PlayAudioTrack("001 level statistic", 1)
	
	-- get the collected secrets for the level
	local secretsCollected = GetSecretCount()
	
	-- compute the missed secrets
	local missedSecrets = totalSecretsSoFar - secretsCollected
	
	-- display level end stats
	LevelFuncs.Engine.Node.DrawText("Escape From Meteorite Cavern", 37, 50, true, true, TEN.Color(255,255,255))
	LevelFuncs.Engine.Node.DrawText("LEVEL STATISTICS", 37, 60, true, true, TEN.Color(255,255,255))
	
	-- display secrets missed if applicable
	if missedSecrets == 0.0 then
		LevelFuncs.Engine.Node.DrawText("Collected All Secrets!", 37, 70, true, true, TEN.Color(255,255,255))
	else
		LevelFuncs.Engine.Node.DrawText("TOTAL SECRETS MISSED", 37, 70, true, true, TEN.Color(255,255,255))
		LevelFuncs.Engine.Node.DrawText(tostring(missedSecrets), 37, 75, true, true, TEN.Color(255,255,255))
	end 
	
	-- display prompt to proceed
	LevelFuncs.Engine.Node.DrawText("Press the LOOK Key to Continue", 50, 85, true, true, TEN.Color(255,255,255))
	
	-- end level when any movement key is pressed (or any movement key)
	if EndLevelKeyIsHit() then
		-- remove key item 2 (helicopter keys) from inventory
		LevelFuncs.Engine.Node.RemoveInventoryItem(TEN.Objects.ObjID.KEY_ITEM2, 1)
		-- determine which level to jump to
		if isDemo == true then 
			if missedSecrets == 0.0 then
				-- proceed to bonus level if all secrets were collected
				LevelFuncs.Engine.Node.EndLevel(nextLevel)
			else
				-- otherwise return to title screen
				LevelFuncs.Engine.Node.EndLevel(99)
			end
		-- else not a demo
		else
			-- proceed to next level
			LevelFuncs.Engine.Node.EndLevel(nextLevel)
		end
	end
end

function EndLevelKeyIsHit()
	-- returns true if the following keys are hit:
	-- INVENTORY, BACK, LOOK, ROLL, DRAW
	-- (bitch don't ask me what the values are for each key. All I know is 13 is inventory (taylor's version))
	return (LevelFuncs.Engine.Node.KeyIsHit(13) or LevelFuncs.Engine.Node.KeyIsHit(1) or LevelFuncs.Engine.Node.KeyIsHit(11) or 
			LevelFuncs.Engine.Node.KeyIsHit(12) or LevelFuncs.Engine.Node.KeyIsHit(9))
end

-- DisplayText() : Will display text on screen for numSec seconds
function DisplayText (text, numSec, xPos, yPos)
    local string = DisplayString(text, xPos, yPos, Color.new(250,250,250))
    ShowString(string, numSec)
end

function SprintSlide(lara_obj)
	-- lara_obj = "lara_17"
	-- if Lara is sprinting
	if (LevelFuncs.Engine.Node.TestMoveableAnimation(lara_obj, 223)) then
		-- if the player presses the WALK key
		if (LevelFuncs.Engine.Node.KeyIsHeld(6)) then
			-- if the key was hit in the frame range [9,18]
			if (LevelFuncs.Engine.Node.TestMoveableFrameNumber(lara_obj, 9, 18)) then
				-- play anim 957 (sprint slide right)
				LevelFuncs.Engine.Node.SetMoveableAnimation(lara_obj, 957)
			elseif (LevelFuncs.Engine.Node.TestMoveableFrameNumber(lara_obj, 0, 9)) then
				-- play anim 956 (sprint slide left)
				LevelFuncs.Engine.Node.SetMoveableAnimation(lara_obj, 956)
			end
		end
	-- else if Lara is running sprint left
	elseif (LevelFuncs.Engine.Node.TestMoveableAnimation(lara_obj, 224)) then
		-- if the player presses the WALK key
		if (LevelFuncs.Engine.Node.KeyIsHeld(6)) then
			-- play anim 956 (sprint slide left)
			LevelFuncs.Engine.Node.SetMoveableAnimation(lara_obj, 956)
		end
	-- else if Lara is run to sprint right
	elseif (LevelFuncs.Engine.Node.TestMoveableAnimation(lara_obj, 225)) then
		-- if the player presses the WALK key
		if (LevelFuncs.Engine.Node.KeyIsHeld(6)) then
			-- play anim 957 (sprint slide right)
			LevelFuncs.Engine.Node.SetMoveableAnimation(lara_obj, 957)
		end
	end
	-- if Lara is running
	if (LevelFuncs.Engine.Node.TestMoveableAnimation(lara_obj, 0)) then
		-- if the player presses the WALK key
		if (LevelFuncs.Engine.Node.KeyIsHeld(6)) and (LevelFuncs.Engine.Node.KeyIsHeld(7)) then
			-- if the key was hit in the frame range [9,18]
			if (LevelFuncs.Engine.Node.TestMoveableFrameNumber(lara_obj, 9, 18)) then
				-- play anim 957 (sprint slide right)
				LevelFuncs.Engine.Node.SetMoveableAnimation(lara_obj, 957)
			elseif (LevelFuncs.Engine.Node.TestMoveableFrameNumber(lara_obj, 0, 9)) then
				-- play anim 956 (sprint slide left)
				LevelFuncs.Engine.Node.SetMoveableAnimation(lara_obj, 956)
			end
		end
	end
	---- else if Lara crouches left while sprint sliding
	--elseif (LevelFuncs.Engine.Node.TestMoveableAnimation(lara_obj, 962)) then 
		---- if the player presses CROUCH
		--if (LevelFuncs.Engine.Node.KeyIsHeld(8)) then
			---- play anim 952 (sprint slide left to crouch)
			--LevelFuncs.Engine.Node.SetMoveableAnimation(lara_obj, 952)
		--end
	---- else if Lara crouches right while sprint sliding
	--elseif (LevelFuncs.Engine.Node.TestMoveableAnimation(lara_obj, 963)) then 
		---- if the player presses CROUCH
		--if (LevelFuncs.Engine.Node.KeyIsHeld(8)) then
			---- play anim 953 (sprint slide right to crouch)
			--LevelFuncs.Engine.Node.SetMoveableAnimation(lara_obj, 953)
		--end 
	--end
	
end

function TR3_INV_SFX_OPEN()
	if (LevelFuncs.Engine.Node.KeyIsHit(37)) then
		LevelFuncs.Engine.Node.PlaySoundAroundMoveable("LARA_MAIN", 109)
	end
	if (LevelFuncs.Engine.Node.KeyIsHit(38)) then
		LevelFuncs.Engine.Node.PlaySoundAroundMoveable("LARA_MAIN", 109)
	end
end

LevelFuncs.AddSecretID = function(secretID)
	Flow.AddSecret(tonumber(secretID))
	LevelFuncs.Engine.Node.PlayAudioTrack("005", 0)
end