---- FILE: \Meteorite_Cavern.lua

LevelFuncs.OnLoad = function() end
LevelFuncs.OnSave = function() end
LevelFuncs.OnStart = function() end
LevelFuncs.OnControlPhase = function() 
	SprintSlide("LARA_MAIN")
end
LevelFuncs.OnEnd = function() end


LevelFuncs.GetStatistics = function(nextLevel, totalSecretsSoFar)

	-- flag for demo functionality HEHE
	local isDemo = false
	
	-- play level end stats
	TEN.Misc.PlayAudioTrack("001 level statistic", 1)
	
	-- get the collected secrets for the level
	local secretsCollected = GetSecretCount()
	
	-- compute the missed secrets
	local missedSecrets = totalSecretsSoFar - secretsCollected
	
	-- display level end stats
	LevelFuncs.Engine.Node.DrawText("Escape From Meteorite Cavern", 37, 50, true, true, TEN.Color(255,255,255))
	LevelFuncs.Engine.Node.DrawText("LEVEL STATISTICS", 37, 60, true, true, TEN.Color(255,255,255))
	
	-- display secrets missed if applicable
	if missedSecrets == 0.0 then
		LevelFuncs.Engine.Node.DrawText("Collected All Secrets!", 37, 70, true, true, TEN.Color(255,255,255))
	else
		LevelFuncs.Engine.Node.DrawText("TOTAL SECRETS MISSED", 37, 70, true, true, TEN.Color(255,255,255))
		LevelFuncs.Engine.Node.DrawText(tostring(missedSecrets), 37, 75, true, true, TEN.Color(255,255,255))
	end 
	
	-- display prompt to proceed
	LevelFuncs.Engine.Node.DrawText("Press the LOOK Key to Continue", 50, 85, true, true, TEN.Color(255,255,255))
	
	-- end level when any movement key is pressed (or any movement key)
	if EndLevelKeyIsHit() then
		-- remove key item 2 (helicopter keys) from inventory
		LevelFuncs.Engine.Node.RemoveInventoryItem(TEN.Objects.ObjID.KEY_ITEM2, 1)
		-- determine which level to jump to
		if isDemo == true then 
			if missedSecrets == 0.0 then
				-- proceed to bonus level if all secrets were collected
				LevelFuncs.Engine.Node.EndLevel(nextLevel)
			else
				-- otherwise return to title screen
				LevelFuncs.Engine.Node.EndLevel(99)
			end
		-- else not a demo
		else
			-- proceed to next level
			LevelFuncs.Engine.Node.EndLevel(2)
		end
	end
end

function EndLevelKeyIsHit()
	-- returns true if the following keys are hit:
	-- INVENTORY, BACK, LOOK, ROLL, DRAW
	-- (bitch don't ask me what the values are for each key. All I know is 13 is inventory (taylor's version))
	return (LevelFuncs.Engine.Node.KeyIsHit(13) or LevelFuncs.Engine.Node.KeyIsHit(1) or LevelFuncs.Engine.Node.KeyIsHit(11) or 
			LevelFuncs.Engine.Node.KeyIsHit(12) or LevelFuncs.Engine.Node.KeyIsHit(9))
end

-- DisplayText() : Will display text on screen for numSec seconds
function DisplayText (text, numSec, xPos, yPos)
    local string = DisplayString(text, xPos, yPos, Color.new(250,250,250))
    ShowString(string, numSec)
end

LevelFuncs.ExportedNodeFunction = function(activator)
	LevelFuncs.Engine.Node.DrawText("LEVEL COMPLETE!", 50, 60, true, false, TEN.Color(255,255,255))
	LevelFuncs.Engine.Node.DrawText("SECRETS MISSED: ", 50, 80, true, false, TEN.Color(255,255,255))
end


LevelFuncs.UW_MUTANT_PUZZLE = function(mutantName, volName)
	-- if Lara equipped a flare
	if (LevelFuncs.Engine.Node.TestLaraWeaponType(7)) then
		-- stun the swimmer mutant (play anim 1)
		LevelFuncs.Engine.Node.SetMoveableAnimation(mutantName, 1)
		-- disable the volume box
		LevelFuncs.Engine.Node.DisableVolume(volName)
	else
		-- if Lara is close to the swimmer mutant
		if (LevelFuncs.Engine.Node.TestMoveableDistance(2, 1000, 0, "LARA_MAIN", mutantName)) then
			-- trigger swimmer mutant attack anim (play anim 3)
			LevelFuncs.Engine.Node.SetMoveableAnimation(mutantName, 3)
			-- kill Lara
			LevelFuncs.Engine.Node.SetMoveableHitPoints(1, 0, "LARA_MAIN")
			-- shatter Lara's head mesh
			LevelFuncs.Engine.Node.ShatterMoveableMesh("LARA_MAIN", 14)
			-- disable the volume box
			LevelFuncs.Engine.Node.DisableVolume(volName)
		end
	end
end


function SprintSlide(lara_obj)
	-- lara_obj = "lara_17"
	-- if Lara is sprinting
	if (LevelFuncs.Engine.Node.TestMoveableAnimation(lara_obj, 223)) then
		-- if the player presses the WALK key
		if (LevelFuncs.Engine.Node.KeyIsHeld(6)) then
			-- if the key was hit in the frame range [9,18]
			if (LevelFuncs.Engine.Node.TestMoveableFrameNumber(lara_obj, 9, 18)) then
				-- play anim 957 (sprint slide right)
				LevelFuncs.Engine.Node.SetMoveableAnimation(lara_obj, 957)
			elseif (LevelFuncs.Engine.Node.TestMoveableFrameNumber(lara_obj, 0, 9)) then
				-- play anim 956 (sprint slide left)
				LevelFuncs.Engine.Node.SetMoveableAnimation(lara_obj, 956)
			end
		end
	-- else if Lara is running sprint left
	elseif (LevelFuncs.Engine.Node.TestMoveableAnimation(lara_obj, 224)) then
		-- if the player presses the WALK key
		if (LevelFuncs.Engine.Node.KeyIsHeld(6)) then
			-- play anim 956 (sprint slide left)
			LevelFuncs.Engine.Node.SetMoveableAnimation(lara_obj, 956)
		end
	-- else if Lara is run to sprint right
	elseif (LevelFuncs.Engine.Node.TestMoveableAnimation(lara_obj, 225)) then
		-- if the player presses the WALK key
		if (LevelFuncs.Engine.Node.KeyIsHeld(6)) then
			-- play anim 957 (sprint slide right)
			LevelFuncs.Engine.Node.SetMoveableAnimation(lara_obj, 957)
		end
	end
	-- if Lara is running
	if (LevelFuncs.Engine.Node.TestMoveableAnimation(lara_obj, 0)) then
		-- if the player presses the WALK key
		if (LevelFuncs.Engine.Node.KeyIsHeld(6)) and (LevelFuncs.Engine.Node.KeyIsHeld(7)) then
			-- if the key was hit in the frame range [9,18]
			if (LevelFuncs.Engine.Node.TestMoveableFrameNumber(lara_obj, 9, 18)) then
				-- play anim 957 (sprint slide right)
				LevelFuncs.Engine.Node.SetMoveableAnimation(lara_obj, 957)
			elseif (LevelFuncs.Engine.Node.TestMoveableFrameNumber(lara_obj, 0, 9)) then
				-- play anim 956 (sprint slide left)
				LevelFuncs.Engine.Node.SetMoveableAnimation(lara_obj, 956)
			end
		end
	end
	---- else if Lara crouches left while sprint sliding
	--elseif (LevelFuncs.Engine.Node.TestMoveableAnimation(lara_obj, 962)) then 
		---- if the player presses CROUCH
		--if (LevelFuncs.Engine.Node.KeyIsHeld(8)) then
			---- play anim 952 (sprint slide left to crouch)
			--LevelFuncs.Engine.Node.SetMoveableAnimation(lara_obj, 952)
		--end
	---- else if Lara crouches right while sprint sliding
	--elseif (LevelFuncs.Engine.Node.TestMoveableAnimation(lara_obj, 963)) then 
		---- if the player presses CROUCH
		--if (LevelFuncs.Engine.Node.KeyIsHeld(8)) then
			---- play anim 953 (sprint slide right to crouch)
			--LevelFuncs.Engine.Node.SetMoveableAnimation(lara_obj, 953)
		--end 
	--end
	
end