-- Place in this Lua script all the levels of your game
-- Title is mandatory and must be the first level.

-- Intro image is a splash screen which appears before actual loading screen.
-- If you don't want it to appear, just remove this line.

Flow.SetIntroImagePath("Screens\\main.jpg")

-- This image should be used for static title screen background (as in TR1-TR3).
-- For now it is not implemented.

Flow.SetTitleScreenImagePath("Screens\\title.jpg")

-- Set overall amount of secrets in game.
-- If set to 0, secrets won't be displayed in statistics.

Flow.SetTotalSecretCount(0)

-- Disable/enable flycheat globally

Flow.EnableFlyCheat(false)

-- Disable/enable Lara drawing in title level

Flow.EnableLaraInTitle(true)

-- Disable/enable level selection in title level

Flow.EnableLevelSelect(false)

-- Disable/enable mass pickup (collect all pickups at once)

Flow.EnableMassPickup(true)

--------------------------------------------------

-- Title level

title = Level.new()

title.ambientTrack = "104"
title.levelFile = "Data\\title.ten"
title.scriptFile = "Scripts\\title.lua"
title.horizon = true
title.loadScreenFile = "Screens\\Main.png"


Flow.AddLevel(title)

--------------------------------------------------

lvl1 = Level.new()

lvl1.nameKey = "lvl1"
lvl1.scriptFile = "Scripts\\lvl1.lua"
lvl1.ambientTrack = "110"
lvl1.horizon = true
lvl1.levelFile = "Data\\lvl1.ten"
lvl1.loadScreenFile = "Screens\\rome.jpg"

lvl1.secrets = (5)

lvl1.objects = {
	InventoryItem.new(
		"main",
		ObjID.PUZZLE_ITEM1,
		0,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"crystal",
		ObjID.PUZZLE_ITEM2,
		0,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"sand",
		ObjID.PUZZLE_ITEM3,
		0,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"bell",
		ObjID.PUZZLE_ITEM4,
		0,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"sword",
		ObjID.PUZZLE_ITEM5,
		0,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"steeple",
		ObjID.KEY_ITEM1,
		0,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"steeple2",
		ObjID.KEY_ITEM3,
		0,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"maze",
		ObjID.KEY_ITEM2,
		0,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"red",
		ObjID.KEY_ITEM5,
		0,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"blue",
		ObjID.KEY_ITEM7,
		0,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"nut",
		ObjID.PICKUP_ITEM3,
		0,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"map",
		ObjID.EXAMINE1,
		0,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.EXAMINE
	),
}

Flow.AddLevel(lvl1)

Home_Sweet_Home = Level.new()

Home_Sweet_Home.nameKey = "Home_Sweet_Home"
Home_Sweet_Home.scriptFile = "Scripts\\Home_Sweet_Home.lua"
Home_Sweet_Home.ambientTrack = "106"
Home_Sweet_Home.horizon = true
Home_Sweet_Home.levelFile = "Data\\Home_Sweet_Home.ten"
Home_Sweet_Home.loadScreenFile = "Screens\\rome.jpg"

Home_Sweet_Home.secrets = (5)

Home_Sweet_Home.objects = {
	InventoryItem.new(
		"infada1",
		ObjID.PICKUP_ITEM1,
		0,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"infada5",
		ObjID.PICKUP_ITEM2,
		0,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"infada3",
		ObjID.PICKUP_ITEM4,
		0,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"infada2",
		ObjID.PICKUP_ITEM5,
		0,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"infada4",
		ObjID.PICKUP_ITEM6,
		0,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"room",
		ObjID.KEY_ITEM10,
		0,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),

}

Flow.AddLevel(Home_Sweet_Home)
