-- Place in this Lua script all the levels of your game
-- Title is mandatory and must be the first level.

-- Intro image is a splash screen which appears before actual loading screen.
-- If you don't want it to appear, just remove this line.

Flow.SetIntroImagePath("Screens\\rome.jpg")

-- This image should be used for static title screen background (as in TR1-TR3).
-- For now it is not implemented.

Flow.SetTitleScreenImagePath("Screens\\title.jpg")

-- Set overall amount of secrets in game.
-- If set to 0, secrets won't be displayed in statistics.

Flow.SetTotalSecretCount(15)

-- Disable/enable flycheat globally

Flow.EnableFlyCheat(false)

-- Disable/enable Lara drawing in title level

Flow.EnableLaraInTitle(false)

-- Disable/enable level selection in title level

Flow.EnableLevelSelect(false)

-- Disable/enable mass pickup (collect all pickups at once)

Flow.EnableMassPickup(true)

--------------------------------------------------

-- Title level

title = Level.new()

title.ambientTrack = "104_Title_Theme"
title.levelFile = "Data\\title.ten"
title.scriptFile = "Scripts\\title.lua"
title.loadScreenFile = "Screens\\main.jpg"

Flow.AddLevel(title)

--------------------------------------------------

-- Level 1

sewers = Level.new()

sewers.nameKey = "sewers"
sewers.scriptFile = "Scripts\\Sewers.lua"
sewers.ambientTrack = "254_Sewers"
sewers.levelFile = "Data\\Sewers.ten"
sewers.loadScreenFile = "Screens\\Sewers.jpg"

-- 0 is no weather, 1 is rain, 2 is snow.
-- Strength varies from 0 to 1 (floating-point value, e.g. 0.5 means half-strength).

sewers.weather = 1
sewers.weatherStrength = 0.6

-- Level Horizon and View

sewers.horizon = true
sewers.farView = 35
sewers.layer1 = Flow.SkyLayer.new(Color.new(255, 255, 255), 16)
sewers.fog = Flow.Fog.new(Color.new(0, 0, 0), 12, 20)

-- Level Effects

sewers.rumble = false

-- Item IDs

sewers.objects = {
	InventoryItem.new(
		"special_key",
		ObjID.KEY_ITEM4,
		0,
		1,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.EXAMINE
	)
}

Flow.AddLevel(sewers)

-- Level 2

Aldwych_Underground = Level.new()

Aldwych_Underground.nameKey = "Aldwych_Underground"
Aldwych_Underground.scriptFile = "Scripts\\Levels\\Aldwych_Underground.lua"
Aldwych_Underground.ambientTrack = "252_Underground"
Aldwych_Underground.horizon = false
Aldwych_Underground.levelFile = "Data\\Aldwych_Underground.ten"
Aldwych_Underground.loadScreenFile = "Screens\\underground.jpg"

-- Item IDs

Aldwych_Underground.objects = {
	InventoryItem.new(
		"bore_key",
		ObjID.KEY_ITEM2,
		0,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"gate_key",
		ObjID.KEY_ITEM1,
		0,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"special_key",
		ObjID.KEY_ITEM4,
		0,
		1,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.EXAMINE
	)
}

Flow.AddLevel(Aldwych_Underground)

-- Level 3

Ancient_City = Level.new()

Ancient_City.nameKey = "Ancient_City"
Ancient_City.scriptFile = "Scripts\\Levels\\Ancient_City.lua"
Ancient_City.ambientTrack = "250_Eternal_City"
Ancient_City.horizon = true
Ancient_City.levelFile = "Data\\Ancient_City.ten"
Ancient_City.loadScreenFile = "Screens\\ancient_city.jpg"

-- Item IDs

Ancient_City.objects = {
	InventoryItem.new(
		"special_key",
		ObjID.KEY_ITEM4,
		0,
		1,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.EXAMINE
	),
	InventoryItem.new(
		"rusted_key",
		ObjID.KEY_ITEM1,
		0,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"eye_of_dragnoth",
		ObjID.EXAMINE1,
		0,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.EXAMINE
	),
	InventoryItem.new(
		"dynamite",
		ObjID.PUZZLE_ITEM1,
		0,
		0.5,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
}

Flow.AddLevel(Ancient_City)

-- Credits

Credits = Level.new()

Credits.nameKey = "Credits"
Credits.scriptFile = "Scripts\\Levels\\Credits.lua"
Credits.ambientTrack = "249_The_End"
Credits.horizon = true
Credits.levelFile = "Data\\Credits.ten"
Credits.loadScreenFile = "null"

Flow.AddLevel(Credits)
