---- FILE: \Highland_Fling.lua

--package.preload["MISC_LOOP_FUNCTIONS"] = function() require ("MISC_LOOP_FUNCTIONS") end require ("Levels.MISC_LOOP_FUNCTIONS")
---@diagnostic disable: duplicate-set-field
require("Levels.MISC_LOOP_FUNCTIONS")

-- Timer Functions
local Timer = require("Engine.Timer")

local TimerOptions = {TEN.Strings.DisplayStringOption.CENTER,
            		  TEN.Strings.DisplayStringOption.SHADOW,
            		  TEN.Strings.DisplayStringOption.BLINK}

-- EventSequences
local EventSequence = require("Engine.EventSequence")

local useTimer = 1.0

LevelFuncs.OnLoad = function() end
LevelFuncs.OnSave = function() end
LevelFuncs.OnStart = function() 
	LevelFuncs.BlinkOrganizer()
	Flow.SetTotalSecretCount(25)
	LevelFuncs.Engine.Node.ModifyLevelVariable("tile_1", 4, 0)
	LevelFuncs.Engine.Node.ModifyLevelVariable("tile_2", 4, 0)
	LevelFuncs.Engine.Node.ModifyLevelVariable("tile_3", 4, 0)
	LevelFuncs.Engine.Node.ModifyLevelVariable("tile_4", 4, 0)
	LevelFuncs.Engine.Node.ModifyLevelVariable("tile_5", 4, 0)
	LevelVars.SplatCounter = 0
end
LevelFuncs.OnControlPhase = function() 
	Platform_Puzzle_Check()
	Knock_Out_Baddies()
	showStatsSpritesBackGround()
end
LevelFuncs.OnEnd = function() end


----------------
--- BLINKING ---
----------------
LevelFuncs.BlinkOrganizer = function ()
	local lara_blink_org = EventSequence.Create(
						"lara_blink_org", -- sequence's name
						true, -- loop
						false, -- no countdown is displayed
						0,
						LevelFuncs.BlinkOff, 
						3, 
						LevelFuncs.BlinkOn,
						1,
						LevelFuncs.BlinkOff
						)
	-- event sequences are inactive to begin with and so need to be started
    lara_blink_org:Start()
end

LevelFuncs.BlinkOn = function ()
	LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 14, TEN.Objects.ObjID.LARA_SPEECH_HEAD3, 14)
	print("BLINKING ON")
end
LevelFuncs.BlinkOff = function ()
	LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 14, TEN.Objects.ObjID.LARA_SKIN, 14)
	print("BLINKING OFF")
end



-- This function triggers the timer
LevelFuncs.Sword_Bridge_Door_Timer = function(numSeconds)
	local my_Sword_Bridge_Door_Timer = Timer.Create("my_Sword_Bridge_Door_Timer",
		tonumber(numSeconds),
        false,
        {minutes = false, seconds = true, deciseconds = true})
	my_Sword_Bridge_Door_Timer:SetTextOption(TimerOptions)
    my_Sword_Bridge_Door_Timer:Start()
end

LevelFuncs.Left_Bridge_Tower_Door_Timer = function(numSeconds)
    local my_Left_Bridge_Tower_Door_Timer = Timer.Create("my_Left_Bridge_Tower_Door_Timer",
        tonumber(numSeconds),
        false,
        {minutes = false, seconds = true, deciseconds = true})
    my_Left_Bridge_Tower_Door_Timer:SetTextOption(TimerOptions)
	my_Left_Bridge_Tower_Door_Timer:Start()
end

LevelFuncs.Left_Bridge_Door_Timer = function(numSeconds)
    local my_Left_Bridge_Door_Timer = Timer.Create("my_Left_Bridge_Door_Timer",
        tonumber(numSeconds),
        false,
        {minutes = false, seconds = true, deciseconds = true})
    my_Left_Bridge_Door_Timer:SetTextOption(TimerOptions)
	my_Left_Bridge_Door_Timer:Start()
end

LevelFuncs.TriggerTimer = function(numSeconds)
	print("" .. tostring(numSeconds) .. " seconds")
    local myTimer = Timer.Create("my_Timer",
                                 tonumber(numSeconds),
                                 false,
                                 {minutes = false, seconds = true, deciseconds = true})
    myTimer:SetTextOption(TimerOptions)
	myTimer:Start()
end



LevelFuncs.GetStatistics = function(nextLevel, totalSecretsSoFar)

	-- flag for demo functionality HEHE
	local isDemo = false
	
	-- play level end stats
	TEN.Misc.PlayAudioTrack("001 level statistic", 1)
	
	-- get the collected secrets for the level
	local secretsCollected = GetSecretCount()
	
	-- compute the missed secrets
	local missedSecrets = totalSecretsSoFar - secretsCollected
	
	-- display level end stats
	LevelFuncs.Engine.Node.DrawText("Escape From Meteorite Cavern", 37, 50, true, true, TEN.Color(255,255,255))
	LevelFuncs.Engine.Node.DrawText("LEVEL STATISTICS", 37, 60, true, true, TEN.Color(255,255,255))
	
	-- display secrets missed if applicable
	if missedSecrets == 0.0 then
		LevelFuncs.Engine.Node.DrawText("Collected All Secrets!", 37, 70, true, true, TEN.Color(255,255,255))
	else
		LevelFuncs.Engine.Node.DrawText("TOTAL SECRETS MISSED", 37, 70, true, true, TEN.Color(255,255,255))
		LevelFuncs.Engine.Node.DrawText(tostring(missedSecrets), 37, 75, true, true, TEN.Color(255,255,255))
	end 
	
	-- display prompt to proceed
	LevelFuncs.Engine.Node.DrawText("Press the LOOK Key to Continue", 50, 85, true, true, TEN.Color(255,255,255))
	
	-- end level when any movement key is pressed (or any movement key)
	if EndLevelKeyIsHit() then
		-- remove key item 2 (helicopter keys) from inventory
		LevelFuncs.Engine.Node.RemoveInventoryItem(TEN.Objects.ObjID.KEY_ITEM2, 1)
		-- determine which level to jump to
		if isDemo == true then 
			if missedSecrets == 0.0 then
				-- proceed to bonus level if all secrets were collected
				LevelFuncs.Engine.Node.EndLevel(nextLevel)
			else
				-- otherwise return to title screen
				LevelFuncs.Engine.Node.EndLevel(99)
			end
		-- else not a demo
		else
			-- proceed to next level
			LevelFuncs.Engine.Node.EndLevel(nextLevel)
		end
	end
end

function EndLevelKeyIsHit()
	-- returns true if the following keys are hit:
	-- INVENTORY, BACK, LOOK, ROLL, DRAW
	-- (bitch don't ask me what the values are for each key. All I know is 13 is inventory (taylor's version))
	return (LevelFuncs.Engine.Node.KeyIsHit(13) or LevelFuncs.Engine.Node.KeyIsHit(1) or LevelFuncs.Engine.Node.KeyIsHit(11) or 
			LevelFuncs.Engine.Node.KeyIsHit(12) or LevelFuncs.Engine.Node.KeyIsHit(9))
end

-- DisplayText() : Will display text on screen for numSec seconds
function DisplayText (text, numSec, xPos, yPos)
    local string = DisplayString(text, xPos, yPos, Color.new(250,250,250))
    ShowString(string, numSec)
end

LevelFuncs.AddSecretID = function(secretID)
	Flow.AddSecret(tonumber(secretID))
	LevelFuncs.Engine.Node.PlayAudioTrack("005", 0)
end

function Platform_Puzzle_Check()
	if LevelFuncs.Engine.Node.TestLevelVariable("tile_1", 0, 1) and LevelFuncs.Engine.Node.TestLevelVariable("tile_2", 0, 1) and 
	   LevelFuncs.Engine.Node.TestLevelVariable("tile_3", 0, 1) and LevelFuncs.Engine.Node.TestLevelVariable("tile_4", 0, 1) and 
	   LevelFuncs.Engine.Node.TestLevelVariable("tile_5", 0, 1) then
	   
	   LevelFuncs.Engine.Node.DisableMoveable("raising_block2_1263", 0)
	   LevelFuncs.Engine.Node.DisableMoveable("raising_block2_1491", 0)
	   
	else
	   LevelFuncs.Engine.Node.EnableMoveable("raising_block2_1263", 0)
	   LevelFuncs.Engine.Node.EnableMoveable("raising_block2_1491", 0)
	end
end

-----------------------------
--- PHYSICAL COMBAT BEGIN ---
-----------------------------
local canPulseAgain = true
function Knock_Out_Baddy(baddy_name, moveableSlot)
	-- if enemy is within 128 units of Lara
	local baddyPosition = TEN.Objects.GetMoveableByName(baddy_name):GetPosition()
	local laraPosition = TEN.Objects.GetMoveableByName("LARA_MAIN"):GetPosition()
	local distanceFromLara = math.abs(laraPosition:Distance(baddyPosition))
	local baddyObj = TEN.Objects.GetMoveableByName(baddy_name)
	
	if distanceFromLara <= 256.0 and baddyObj:GetActive() then
		--print("distance : " .. distanceFromLara)
		-- SPRINT SLIDE KNOCKOUT LOGIC
		-- if lara is performing a sprint slide
		if (LevelFuncs.Engine.Node.TestMoveableAnimation("LARA_MAIN", 956) or LevelFuncs.Engine.Node.TestMoveableAnimation("LARA_MAIN", 957)) then
			SetBaddyKnockoutAnim(moveableSlot, baddy_name, 0)
		-- else use kick mechanics
		else
			-- KNEE AND TWIST KICK LOGIC
			print("distance : " .. distanceFromLara)
			if Input.IsKeyPulsed(Input.ActionID.ACTION, 3, 2) and canPulseAgain == true and
			   LevelFuncs.Engine.Node.TestLaraVehicle() == false then -- and lara is not on a vehicle
				canPulseAgain = false
				local attackAnimIDs = {}
				-- Get the random attack anim for Lara
				if Lara:GetHandStatus() == Objects.HandStatus.WEAPON_DRAW or Lara:GetHandStatus() == Objects.HandStatus.WEAPON_READY then
					attackAnimIDs = {976} -- 976, 1005, 1003
				else
					attackAnimIDs = {977, 976, 1005, 1006}
				end
				local randomAttackAnim = attackAnimIDs[math.random(1, #attackAnimIDs)]

				if moveableSlot == ObjID.SMALL_SCORPION then
					randomAttackAnim = 1003
					LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 1162)
				end

				lara : SetAnim(randomAttackAnim)
				LevelFuncs.LaraKickOrganizer(moveableSlot, baddy_name, randomAttackAnim)
			end
		end
	end
end

function SetBaddyKnockoutAnim(moveableSlot, baddy_name, laraAttackAnim)
	baddy_obj = Objects.GetMoveableByName(baddy_name)
	-- determine the knock out anim based off the moveable slot
	if moveableSlot == ObjID.SAS_CAIRO then -- SAS

		defenseAnimIDs = {23, 23, 23, 26}
		randomDefenseAnim = defenseAnimIDs[math.random(1, #defenseAnimIDs)]

		-- if lara does a low kick or a pistol kick
		if laraAttackAnim == 1006 or laraAttackAnim == 1005 then
			-- do a defense anim
			LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 26)
		else
			-- do the fall back anim
			LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 23)
		end

	elseif moveableSlot == ObjID.FLAMETHROWER_BADDY then -- flamethrower
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 24)
	elseif moveableSlot == ObjID.MP_WITH_GUN then -- mp with gun
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 39)
	elseif moveableSlot == ObjID.TRIBESMAN_WITH_AX then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 31)
	elseif moveableSlot == ObjID.DOG then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 25)
	elseif moveableSlot == ObjID.BADDY2 then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 71)
	elseif moveableSlot == ObjID.SMALL_SCORPION then
		local new_splat_name = "splat_EW_" .. tostring(LevelVars.SplatCounter)
		LevelVars.SplatCounter = LevelVars.SplatCounter + 1
		local spider_position = baddy_obj:GetPosition()
		local new_splat = Moveable(TEN.Objects.ObjID.ANIMATING36, -- object id
								  new_splat_name, -- name
								  spider_position) -- position
		LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, 
                                                                new_splat_name, 
                                                                baddy_name)
		-- shatter moveable
		LevelFuncs.Engine.Node.ShatterMoveable(baddy_name)
		baddy_obj:Destroy()
		LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 1163)
	end
end

LevelFuncs.LaraKickOrganizer = function(moveableSlot, baddy_name, laraAttackAnim)
	local attack_org = EventSequence.Create(
						"attack_org", -- sequence's name
						false, -- loop
						false, -- no countdown is displayed
						0.4,
						{LevelFuncs.KickAManBecauseItsWhatHeDeservesBINCH, moveableSlot, baddy_name, laraAttackAnim}, 
						0.9, 
						LevelFuncs.RestoreLaraWeaponStatus,
						0.01,
						LevelFuncs.RestoreLaraAnim
						)
	-- event sequences are inactive to begin with and so need to be started
    attack_org:Start()
end

LevelFuncs.KickAManBecauseItsWhatHeDeservesBINCH = function(moveableSlot, baddy_name, laraAttackAnim)
	SetBaddyKnockoutAnim(moveableSlot, baddy_name, laraAttackAnim)
end

LevelFuncs.RestoreLaraWeaponStatus = function()
	if Lara:GetHandStatus() == Objects.HandStatus.WEAPON_DRAW or Lara:GetHandStatus() == Objects.HandStatus.WEAPON_READY then
		-- init weaponLaraSlot
		local weaponLaraSlot = 0
		if Lara:GetWeaponType() == Objects.WeaponType.PISTOLS then
			weaponLaraSlot = 2
		elseif Lara:GetWeaponType() == Objects.WeaponType.UZIS then
			weaponLaraSlot = 3
		elseif Lara:GetWeaponType() == Objects.WeaponType.SHOTGUN then
			weaponLaraSlot = 4
		elseif Lara:GetWeaponType() == Objects.WeaponType.REVOLVER then
			weaponLaraSlot = 5
		elseif Lara:GetWeaponType() == Objects.WeaponType.CROSSBOW then
			weaponLaraSlot = 6
		elseif Lara:GetWeaponType() == Objects.WeaponType.HK then
			weaponLaraSlot = 7
		elseif Lara:GetWeaponType() == Objects.WeaponType.GRENADE_LAUNCHER then
			weaponLaraSlot = 8
		elseif Lara:GetWeaponType() == Objects.WeaponType.ROCKET_LAUNCHER then
			weaponLaraSlot = 9
		elseif Lara:GetWeaponType() == Objects.WeaponType.HARPOON_GUN then
			weaponLaraSlot = 10
		end
		print("WEAPON ID: "..Lara:GetWeaponType())
		LevelFuncs.Engine.Node.SetLaraWeaponType(Lara:GetWeaponType(), true)
		lara : SetAnim(0, weaponLaraSlot) -- perform anim 4 LARA_PISTOLS is slot 2
	end
end

LevelFuncs.RestoreLaraAnim = function()
	canPulseAgain = true
	if Lara:GetHandStatus() == Objects.HandStatus.WEAPON_DRAW or Lara:GetHandStatus() == Objects.HandStatus.WEAPON_READY then
		lara : SetAnim(103) -- perform anim 4 LARA_PISTOLS is slot 2
	end
end

function Knock_Out_Baddies()
    local moveableSlots = {
        ObjID.SAS_CAIRO, --'SAS CAIRO'
        ObjID.FLAMETHROWER_BADDY, -- FlameThrower Baddy
        ObjID.MP_WITH_GUN, -- 'MP wiht Gun'
        ObjID.BADDY2, -- 'Baddy2'
        ObjID.TRIBESMAN_WITH_AX  -- scottsman
    }
    for index, moveableSlot in pairs(moveableSlots) do
        local moveables = GetMoveablesBySlot(moveableSlot)
        for index, moveable in pairs(moveables) do
			if moveable:GetActive() and moveable:GetHP() >= 1 then
				if moveableSlot == ObjID.SAS_CAIRO then -- if the moveable is a SAS
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.FLAMETHROWER_BADDY then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.MP_WITH_GUN then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.TRIBESMAN_WITH_AX then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.DOG then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.BADDY2 then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.SMALL_SCORPION then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
			end
        end
    end
end
---------------------------
--- PHYSICAL COMBAT END ---
---------------------------


local endTimeTaken = tostring(Flow.GetStatistics().timeTaken) -- this will be a toString(Time()) 
local statsHeader_str = TEN.Strings.DisplayString("Highland Fling", 
											   TEN.Vec2(TEN.Util.PercentToScreen(50, 20)), -- pos
											   1.0, -- scale
											   TEN.Color(255,255,255), -- color
											   false, --translated bool
											   {TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW} -- flags
											   )
											   
LevelFuncs.DisplayStats = function()
	LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, "LARA_MAIN", "END_LSP")
	LevelFuncs.Engine.Node.PlayFlyBy(18)
	LevelFuncs.Engine.Node.PlayAudioTrack("001", 1)
	LevelFuncs.Engine.Node.SetMoveableAnimation("LARA_MAIN", 975)
	
	TEN.Strings.ShowString(statsHeader_str)
	local leftJustify = 30
	local rightJustify = 70
	local yStatsPos = 30
	-- time taken
	--local endTimeTakenFormatted = "".. endTimeTaken.h .. ":" .. endTimeTaken.m .. ":" .. endTimeTaken.s
	LevelFuncs.Engine.Node.DrawText("Time Taken: ", leftJustify, yStatsPos, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(endTimeTaken, rightJustify, yStatsPos, 2, 1, TEN.Color(255,255,255), 0.8)
	-- secrets found
	local secretsFound = ""..Flow.GetStatistics().secrets
	LevelFuncs.Engine.Node.DrawText("Secrets Found: ", leftJustify, yStatsPos+5, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(secretsFound, rightJustify, yStatsPos+5, 2, 1, TEN.Color(255,255,255), 0.8)
	-- Pickups
	local pickupsFound = ""..Flow.GetStatistics().pickups
	LevelFuncs.Engine.Node.DrawText("Pickups: ", leftJustify, yStatsPos+10, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(pickupsFound, rightJustify, yStatsPos+10, 2, 1, TEN.Color(255,255,255), 0.8)
	-- Kills
	local killsStats = ""..Flow.GetStatistics().kills
	LevelFuncs.Engine.Node.DrawText("Kills: ", leftJustify, yStatsPos+15, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(killsStats, rightJustify, yStatsPos+15, 2, 1, TEN.Color(255,255,255), 0.8)
	-- Ammo Used/Hits
	local ammoUsedHits = ""..Flow.GetStatistics().ammoUsed .. "/" .. Flow.GetStatistics().ammoHits
	LevelFuncs.Engine.Node.DrawText("Ammo Used/Hits: ", leftJustify, yStatsPos+20, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(ammoUsedHits, rightJustify, yStatsPos+20, 2, 1, TEN.Color(255,255,255), 0.8)
	-- Medipacks Used
	local healthPacksUsed = ""..Flow.GetStatistics().healthPacksUsed
	LevelFuncs.Engine.Node.DrawText("Medi Packs Used: ", leftJustify, yStatsPos+25, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(healthPacksUsed, rightJustify, yStatsPos+25, 2, 1, TEN.Color(255,255,255), 0.8)
	-- Distance Travelled in km
	-- convert to km : 1 m = 240 units -> 1km - 0.240 units
	local distanceTravelled = "" .. string.format("%.2f", (Flow.GetStatistics().distanceTraveled / 240) ) .. "m"
	LevelFuncs.Engine.Node.DrawText("Distance Travelled: ", leftJustify, yStatsPos+30, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(distanceTravelled, rightJustify, yStatsPos+30, 2, 1, TEN.Color(255,255,255), 0.8)
	
	LevelFuncs.Engine.Node.DrawText("(Press ACTION to continue)", 50, yStatsPos+40, 1, 3, TEN.Color(255,255,255), 0.8)
end
											   
function showStatsSpritesBackGround()
	-- text background blur (for easier viewing)
	if TEN.Strings.IsStringDisplaying(statsHeader_str) then
		--LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 50, 0, 100, 100, 0, 0, 2, 9)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 48, 0, 60, 80, 0, 0, 2, 9)
	end
end

LevelFuncs.GetEndLevelTime = function()
	endTimeTaken = tostring(Flow.GetStatistics().timeTaken)
end

local TilePuzzleHintOptions = 1
LevelFuncs.TilePuzzleHint = function()
	-- if lara is idle (anim 103)
	if lara : GetAnim() == 103 or 
	   lara:GetAnim() == 984 or lara:GetAnim() == 985 or
	   (lara:GetAnim() == 1025 and lara:GetAnim() == 1029) then
		-- print a hint
		LevelFuncs.Engine.Node.DrawText("Press ACTION to use HINT CRYSTAL", 50, 85, 1, 3, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 87, 0, 50, 9, 0, 0, 2, 9)
	elseif lara : GetAnim() == 999 then
		LevelFuncs.Engine.Node.DrawText("Press ACTION to exit", 50, 85, 1, 3, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 87, 0, 40, 9, 0, 0, 2, 9)
	end
	-- if lara is idle (anim 103)
	if lara : GetAnim() == 103 or 
	   lara:GetAnim() == 984 or lara:GetAnim() == 985 or
	   (lara:GetAnim() == 1025 and lara:GetAnim() == 1029) then
		-- if the player presses ACTION
		if IsKeyPulsed(Input.ActionID.ACTION, 2, 2) then
			-- perform animation 998 (crystal start)
			lara : SetAnim(998)
		end
	end

	-- if lara is crystal idle (anim 999)
	if lara : GetAnim() == 999 then 
		LevelFuncs.Engine.Node.DrawText("There must be \nsomething special \nabout the \nraised tiles...", 35, 40, 1, 1, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 35, 49, 0, 30, 30, 0, 0, 2, 9)
		LevelFuncs.Engine.Node.DrawText("Maybe stepping\non them could \nunblock a path?", 65, 42, 1, 1, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 65, 49, 0, 30, 30, 0, 0, 2, 9)
		-- play cam hint
		LevelFuncs.Engine.Node.ActivateCamera("camera_1834", "camera_target_1835")
		-- if the player presses ACTION
		if IsKeyPulsed(Input.ActionID.ACTION, 2, 2) then
			-- perform animation 998 (crystal start)
			lara : SetAnim(1000)
		end
	end
end

LevelFuncs.HintTestTemplate = function()
	-- if lara is idle (anim 103)
	if lara : GetAnim() == 103 or 
	   lara:GetAnim() == 984 or lara:GetAnim() == 985 or
	   (lara:GetAnim() == 1025 and lara:GetAnim() == 1029) then
		-- print a hint
		LevelFuncs.Engine.Node.DrawText("Press ACTION to use HINT CRYSTAL", 50, 85, 1, 3, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 87, 0, 50, 9, 0, 0, 2, 9)
	elseif lara : GetAnim() == 999 then
		LevelFuncs.Engine.Node.DrawText("(Press ACTION to exit)", 50, 85, 1, 3, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 87, 0, 40, 9, 0, 0, 2, 9)
	end
	
	-- if lara is idle (anim 103)
	if lara : GetAnim() == 103 or 
	   lara:GetAnim() == 984 or lara:GetAnim() == 985 or
	   (lara:GetAnim() == 1025 and lara:GetAnim() == 1029) then
		-- if the player presses ACTION
		if IsKeyPulsed(Input.ActionID.ACTION, 2, 2) then
			-- perform animation 998 (crystal start)
			lara : SetAnim(998)
		end
	end

	-- if lara is crystal idle (anim 999)
	if lara : GetAnim() == 999 then 
	
		-- << HINT LOGIC BEGIN >>
		-- play cam hint
		-- LevelFuncs.Engine.Node.ActivateCamera("camera_1834", "camera_target_1835")
		
		-- << HINT LOGIC END >>
		
		-- if the player presses ACTION
		if IsKeyPulsed(Input.ActionID.ACTION, 2, 2) then
			-- perform animation 998 (crystal start)
			lara : SetAnim(1000)
		end
	end
end