-- FILE: \Lara_Home.lua
---@diagnostic disable: duplicate-set-field

-- this flag is used to check if the level is a demo or the final build
local isArkDemo = 0
local EventSequence = require("Engine.EventSequence")

--package.preload["MISC_LOOP_FUNCTIONS"] = function() require ("MISC_LOOP_FUNCTIONS") end require ("Levels.MISC_LOOP_FUNCTIONS")
require("Levels.MISC_LOOP_FUNCTIONS")

LevelFuncs.OnLoad = function() end
LevelFuncs.OnSave = function() end
LevelFuncs.OnStart = function() 
	--View.PlayVideo("Previously_On.mp4")
	Flow.SetTotalSecretCount(26)
	LevelVars.SplatCounter = 0
end
LevelFuncs.OnControlPhase = function() 
	IsRobotDed()
	didYouCollectAllFourScarabs()
	drawSubSprite()
	showStatsSpritesBackGround()
	Knock_Out_Baddies()
	-- ShowBossHP()
end
LevelFuncs.OnEnd = function() end



LevelFuncs.UseHammer = function()
    LevelFuncs.Engine.Node.EnableMoveable("hammer_1077")
end

LevelFuncs.ShatterMoveableWithBeetle = function()
    LevelFuncs.Engine.Node.ShatterMoveable("pushable_object5_1076")
end

LevelFuncs.EnableBeetle4 = function()
    LevelFuncs.Engine.Node.EnableMoveable("puzzle_item3_1080")
end

LevelFuncs.ShatterPushableForBeetle = function()
	local shatterSequence = EventSequence.Create
	(
    	"Shatter_Pushable_For_Beetle", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.


    	-- The below section is where you put all the events you want
    	-- in your sequence, in the order you want them,
    	-- with the timings between)

    	--3.0, -- I made an enumerator for this so I don't have to change all manually
    	--LevelFuncs.UseHammer,
    	--2.0,
    	--LevelFuncs.ShatterMoveableWithBeetle,
    	--0.5,
    	--LevelFuncs.EnableBeetle4
    	
    	3.0, -- I made an enumerator for this so I don't have to change all manually
    	LevelFuncs.UseHammer,
    	2.0,
    	LevelFuncs.ShatterMoveableWithBeetle,
    	0.5,
    	LevelFuncs.EnableBeetle4
    )

   -- last : now we have created the Event Sequence: you must Start it:
    shatterSequence:Start()
end

LevelFuncs.LowerBeetle = function()


end

function SwapClothes(lara_obj)
	local lara = TEN.Objects.GetMoveableByName(lara_obj)
	if (LevelFuncs.Engine.Node.KeyIsHit(8) and LevelFuncs.Engine.Node.KeyIsHit(6)) then
		lara:GetMeshCount()
		if lara:GetMeshSwapped(7) then
			lara:UnswapMesh(7)
			lara:UnswapMesh(0)
			lara:UnswapMesh(1)
			lara:UnswapMesh(4)
		else
			lara:SwapMesh(7, 25)
			lara:SwapMesh(0, 25)
			lara:SwapMesh(1, 25)
			lara:SwapMesh(4, 25)
		end
	end 
end

LevelFuncs.lower_scarab_door = function(activator)
	FadeIn(1.5)
	-- LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, "puzzle_hole3_735", "lara_start_pos_1138")
	LevelFuncs.Engine.Node.SetMoveableAnimation("animating34_1112", 1)
	LevelFuncs.Engine.Node.SetMoveableAnimation("animating34_1115", 1)
	-- LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, "puzzle_hole3_736", "lara_start_pos_1138")
	LevelFuncs.Engine.Node.SetMoveableAnimation("animating34_1114", 1)
	LevelFuncs.Engine.Node.SetMoveableAnimation("animating34_1113", 1)
	-- LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, "puzzle_hole3_737", "lara_start_pos_1138")
	LevelFuncs.Engine.Node.UndrawWeapon()
	-- LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, "puzzle_hole3_738", "lara_start_pos_1138")
	LevelFuncs.Engine.Node.SetMoveableAnimation("LARA_MAIN", 967)
	LevelFuncs.Engine.Node.PlayFlyBy(4)
	LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, "LARA_MAIN", "lara_start_pos_1109")
	LevelFuncs.Engine.Node.PlayAudioTrack("022 fight start", 0)
end

LevelFuncs.draw_weapons = function(activator)
	LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 13, TEN.Objects.ObjID.PISTOLS_ANIM, 13)
	LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 10, TEN.Objects.ObjID.PISTOLS_ANIM, 10)
end

LevelFuncs.trigger_cyborg_func = function(activator)
	LevelFuncs.Engine.Node.EnableMoveable("horseman_1097", 0)
	horseman_obj = TEN.Objects.GetMoveableByName("horseman_1097")
	horseman_obj:SetHP(200)
	
end

LevelFuncs.set_battle_stance_func = function(activator)
	LevelFuncs.Engine.Node.SetMoveableAnimation("LARA_MAIN", 103)
	LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, "LARA_MAIN", "lara_start_pos_1110")
	LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 13, TEN.Objects.ObjID.LARA_SKIN, 13)
	LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 10, TEN.Objects.ObjID.LARA_SKIN, 10)
end

-- function ShowBossHP()
-- 	LevelFuncs.Engine.Node.ConstructEnemyBar("horseman_1097", "S.I.M.O.N.", 50, 80, 1, 3, 1, TEN.Color(255,255,255), 0, TEN.Color(255,255,255), 1, TEN.Color(255,0,0), 20, 86, 0, 60, 89, 20, 86, 0, 60, 89, false, false)
-- end

LevelFuncs.RobotCutOrganizer = function()
	local robot_fight_org = EventSequence.Create
	(
    	"robot_fight_org", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.
    	0.0,
    	LevelFuncs.CutFadeOut,
    	1.5,
    	LevelFuncs.lower_scarab_door,
    	7.0, -- I made an enumerator for this so I don't have to change all manually
    	LevelFuncs.draw_weapons,
    	3.0,
    	LevelFuncs.trigger_cyborg_func,
    	3.0,
    	LevelFuncs.set_battle_stance_func
    )

   -- last : now we have created the Event Sequence: you must Start it:
    robot_fight_org:Start()
end

LevelFuncs.PlayAllTheBops = function(activator)
	FadeIn(1.5)
	LevelFuncs.Engine.Node.PlayFlyBy(7)
	LevelFuncs.Engine.Node.PlayAudioTrack("023 fight end", 0)
	LevelFuncs.Engine.Node.SetLaraWeaponType(0, false)
	LevelFuncs.Engine.Node.UndrawWeapon()
	
	LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, "LARA_MAIN", "lara_start_pos_1126")
end

LevelFuncs.DuaLilDance = function(activator)
	LevelFuncs.Engine.Node.SetMoveableAnimation("LARA_MAIN", 968)
end

LevelFuncs.OpenEgyptDoor = function(activator)
	LevelFuncs.Engine.Node.EnableMoveable("door_type6_888", 0)
	LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, "LARA_MAIN", "lara_start_pos_1126")
end

LevelFuncs.RobotDedOrganizer = function()
	local robot_ded_org = EventSequence.Create
	(
    	"robot_ded_org", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.
    	2.0, 
    	LevelFuncs.CutFadeOut,
    	2.0, -- I made an enumerator for this so I don't have to change all manually
    	LevelFuncs.PlayAllTheBops,
    	6.0,
    	LevelFuncs.OpenEgyptDoor,
    	11.0,
    	LevelFuncs.DuaLilDance
    )

   -- last : now we have created the Event Sequence: you must Start it:
    robot_ded_org:Start()
end

function IsRobotDed()
	if (LevelFuncs.Engine.Node.TestHitPoints("horseman_1097", 2, 1)) then
		LevelFuncs.Engine.Node.EnableMoveable("rollingball_1124", 0)
	end
end

function didYouCollectAllFourScarabs()
	if (LevelFuncs.Engine.Node.TestInventoryItemCount(TEN.Objects.ObjID.PUZZLE_ITEM3, 5, 4)) then
		LevelFuncs.Engine.Node.DisableVolume("volume_1169")
		LevelFuncs.Engine.Node.EnableMoveable("rollingball_1104", 0)
	end
end

LevelFuncs.CutFadeOut = function()
	LevelFuncs.Engine.Node.UndrawWeapon()
	FadeOut(1.0);
end;

LevelFuncs.CutFadeIn = function()
	FadeIn(1.5);
end;

LevelFuncs.clearSprites = function()
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 0)
end

LevelFuncs.EndingCutPart1Org = function()

	-- USE THIS FOR FINAL BUILD!
	local ending_part1 = EventSequence.Create
	(
    	"ending_part1", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.
    	0.0, 
    	LevelFuncs.CutFadeOut,
    	1.5, -- I made an enumerator for this so I don't have to change all manually
    	LevelFuncs.teleportLara_1,
    	6.6,
    	LevelFuncs.LaraStandIdle,
    	28.0, -- originally 23.0
    	LevelFuncs.EnablePart2Cut
    	
    )
    
    -- USE THIS FOR ARK DEMO
    local ending_part2 = EventSequence.Create
	(
    	"ending_part1", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.
    	0.0, -- I made an enumerator for this so I don't have to change all manually
    	LevelFuncs.teleportLara_1_DEMO,
    	6.6,
    	LevelFuncs.LaraStandIdle,
    	28.0, -- originally 23.0
    	LevelFuncs.EnablePart2Cut
    	
    )

   -- last : now we have created the Event Sequence: you must Start it:
   if isArkDemo == 1 then
    ending_part2:Start()
   else
    ending_part1:Start()
   end
end

LevelFuncs.teleportLara_1 = function(activator)
	FadeIn(0.5)
	LevelFuncs.Engine.Node.UndrawWeapon()
	LevelFuncs.Engine.Node.SetMoveableAnimation("LARA_MAIN", 974)
	LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, "LARA_MAIN", "lara_start_pos_1148")
	
	LevelFuncs.Engine.Node.EnableMoveable("winston_anim", 0)
	LevelFuncs.Engine.Node.PlayAudioTrack("024 ending_Cut", 0)
	LevelFuncs.Engine.Node.PlayFlyBy(10)
	
end

LevelFuncs.teleportLara_1_DEMO = function(activator)
	FadeIn(0.5)
	LevelFuncs.Engine.Node.UndrawWeapon()
	LevelFuncs.Engine.Node.SetMoveableAnimation("LARA_MAIN", 974)
	LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, "LARA_MAIN", "lara_start_pos_1148")
	
	LevelFuncs.Engine.Node.EnableMoveable("winston_anim", 0)
	LevelFuncs.Engine.Node.PlayAudioTrack("024 ending_Cut", 0)
	LevelFuncs.Engine.Node.PlayFlyBy(10)
	
end

LevelFuncs.LaraStandIdle = function()
	LevelFuncs.Engine.Node.SetMoveableAnimation("LARA_MAIN", 975)
	LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, "LARA_MAIN", "lara_start_pos_1154")
end;

LevelFuncs.EnablePart2Cut = function()
	LevelFuncs.Engine.Node.EnableMoveable("rollingball_1143", 0)
end;

LevelFuncs.EndingCutPart2Org = function()
	local ending_part2 = EventSequence.Create
	(
    	"ending_part2", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.
    	2.0, 
    	LevelFuncs.CutFadeOut,
    	4.0, -- I made an enumerator for this so I don't have to change all manually
    	LevelFuncs.teleportLara_2,
    	4.0,
    	LevelFuncs.LaraYuckOldTea,
    	7.0,
    	LevelFuncs.Act2Teaser,
    	6.0,
		LevelFuncs.DisplayStats
    	-- LevelFuncs.EndLevel
    )

   -- last : now we have created the Event Sequence: you must Start it:
    ending_part2:Start()
end

LevelFuncs.teleportLara_2 = function(activator)
	FadeIn(0.5)
	LevelFuncs.Engine.Node.SetMoveableAnimation("LARA_MAIN", 970)
	LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, "LARA_MAIN", "lara_start_pos_1143")
	
	-- this one uggo
	--LevelFuncs.Engine.Node.SetMoveableAnimation("LARA_MAIN", 972)
	--LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, "LARA_MAIN", "lara_start_pos_1147")
	
	LevelFuncs.Engine.Node.PlayFlyBy(9)
	
end

LevelFuncs.LaraYuckOldTea = function(activator)
	--LevelFuncs.Engine.Node.PlayAudioTrack("026 yuck_cold_tea", 0)
	LevelFuncs.Engine.Node.PlayAudioTrack("026 yuck_cold_tea", 2)
end

LevelFuncs.EndLevel = function(activator)
	LevelFuncs.Engine.Node.EnableMoveable("rollingball_1145", 0)
	-- LevelFuncs.Engine.Node.EnableMoveable("rollingball_1146", 0)
end

LevelFuncs.Act2Teaser = function(activator)
	--LevelFuncs.Engine.Node.DrawTextForTimespan(10, "The adventure continues in Act 2", 50, 10, 1, 3, TEN.Color(255,255,255), 1)
	--LevelFuncs.Engine.Node.DrawTextForTimespan(10, "Thank You for Playing!", 50, 20, 1, 3, TEN.Color(255,255,255), 1)
	--LevelFuncs.Engine.Node.DrawTextForTimespan(10, "TO BE CONTINUED", 50, 75, 1, 3, TEN.Color(255,255,255), 2)
end

LevelFuncs.AddSecretID = function(secretID)
	Flow.AddSecret(tonumber(secretID))
	LevelFuncs.Engine.Node.PlayAudioTrack("005", 0)
end

local flags = {TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW}
local stringTest = TEN.Strings.DisplayString("", TEN.Vec2(0,0), 1.0, TEN.Color(255,255,255), false, flags)
local showSprite = false

local winstonTimeSpan1 = 6.0
local laraTimeSpan1 = 7.0
local winstonTimeSpan2 = 4.0
local laraTimeSpan2 = 9.0
local winstonTimeSpan3 = 8.0
local laraTimeSpan3 = 3.0
local laraTimeSpan4 = 8.0

LevelFuncs.EndingCutSubPart1Org = function()
	
	local endingcutsub_part1 = EventSequence.Create
	(
    	"endingcutsub_part1", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.
    	3.0, 
    	LevelFuncs.EndingCut_Winston1,
    	winstonTimeSpan1-0.1,
		LevelFuncs.clearSprites,
		0.1,
    	LevelFuncs.EndingCut_Lara1,
    	laraTimeSpan1-0.1,
		LevelFuncs.clearSprites,
		0.1,
    	LevelFuncs.EndingCut_Winston2,
    	winstonTimeSpan2-0.1,
		LevelFuncs.clearSprites,
		0.1,
    	LevelFuncs.EndingCut_Lara2,
    	laraTimeSpan2-0.1,
		LevelFuncs.clearSprites,
		0.1,
    	LevelFuncs.EndingCut_Winston3,
    	winstonTimeSpan3-0.1,
		LevelFuncs.clearSprites,
		0.1,
    	LevelFuncs.EndingCut_Lara3,
    	laraTimeSpan3-0.1,
		LevelFuncs.clearSprites,
		0.1 + 5.0, -- 3 + 5
    	LevelFuncs.EndingCut_Lara4,
		8.0,
		LevelFuncs.clearSprites
    )

   -- last : now we have created the Event Sequence: you must Start it:
    endingcutsub_part1:Start()
end

local subXpos = 15

-- Cutscene Strings (hate that I'm doing this but whatever lmao)
local winston1_str = TEN.Strings.DisplayString("Winston: \nGood morning Lara, I hope you had a good training session for your Egypt expedition.", 
											   TEN.Vec2(TEN.Util.PercentToScreen(subXpos, 75)), -- pos
											   0.7, -- scale
											   TEN.Color(255,194,10), -- color
											   false, --translated bool
											   {TEN.Strings.DisplayStringOption.SHADOW} -- flags
											   )
											   
LevelFuncs.EndingCut_Winston1 = function()
	TEN.Strings.ShowString(winston1_str, -- DisplayString to display
						   winstonTimeSpan1-0.1, -- time span 
						   true -- autoDelete
						   )
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 2)
end

local lara1_str = TEN.Strings.DisplayString("Lara: \nThank you Winston. I did. I will make arrangements soon. \nThe fabled Amulet of Horus awaits.", 
											   TEN.Vec2(TEN.Util.PercentToScreen(subXpos, 75)), -- pos
											   0.7, -- scale
											   TEN.Color(12,123,220), -- color
											   false, --translated bool
											   {TEN.Strings.DisplayStringOption.SHADOW} -- flags
											   )

LevelFuncs.EndingCut_Lara1 = function()
	TEN.Strings.ShowString(lara1_str, -- DisplayString to display
						   laraTimeSpan1-0.1, -- time span 
						   true -- autoDelete
						   )
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
end

local winston2_str = TEN.Strings.DisplayString("Winston: \nGiving up on the lost artifact so easily, are you?", 
										 	   TEN.Vec2(TEN.Util.PercentToScreen(subXpos, 75)), -- pos
									     	   0.7, -- scale
										 	   TEN.Color(255,194,10), -- color
										 	   false, --translated bool
										 	   {TEN.Strings.DisplayStringOption.SHADOW} -- flags
										 	   )


LevelFuncs.EndingCut_Winston2 = function()
	TEN.Strings.ShowString(winston2_str, -- DisplayString to display
						   winstonTimeSpan2-0.1, -- time span 
						   true -- autoDelete
						   )
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 2)
end

local lara2_str = TEN.Strings.DisplayString("Lara: \nFinding Atlantis was never this vexing! Even the dagger of Xian had some clues... \nwhy can't I find any leads on the fifth artifact?", 
											TEN.Vec2(TEN.Util.PercentToScreen(subXpos, 75)), -- pos
											0.7, -- scale
											TEN.Color(12,123,220), -- color
											false, --translated bool
											{TEN.Strings.DisplayStringOption.SHADOW} -- flags
											)

LevelFuncs.EndingCut_Lara2 = function()
	TEN.Strings.ShowString(lara2_str, -- DisplayString to display
						   laraTimeSpan2-0.1, -- time span 
						   true -- autoDelete
						   )
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
end

local winston3_str = TEN.Strings.DisplayString("Winston: \nI'm sure you'll figure something out. \nI took the liberty of setting your tea with today's paper in your bedroom. \nYou might like the headlines.",
											   TEN.Vec2(TEN.Util.PercentToScreen(subXpos, 73)), -- pos
									     	   0.7, -- scale
										 	   TEN.Color(255,194,10), -- color
										 	   false, --translated bool
										 	   {TEN.Strings.DisplayStringOption.SHADOW} -- flags
										 	   )

LevelFuncs.EndingCut_Winston3 = function()
	TEN.Strings.ShowString(winston3_str, -- DisplayString to display
						   winstonTimeSpan3-0.1, -- time span 
						   true -- autoDelete
						   )
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 2)
end

local lara3_str = TEN.Strings.DisplayString("Lara: \nThanks Winston!", 
											TEN.Vec2(TEN.Util.PercentToScreen(subXpos, 75)), -- pos
											0.7, -- scale
											TEN.Color(12,123,220), -- color
											false, --translated bool
											{TEN.Strings.DisplayStringOption.SHADOW} -- flags
											)

LevelFuncs.EndingCut_Lara3 = function()
	TEN.Strings.ShowString(lara3_str, -- DisplayString to display
						   laraTimeSpan3-1, -- time span 
						   true -- autoDelete
						   )
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
end

local lara4_str = TEN.Strings.DisplayString("Lara: \nYuck! I hate cold tea... but I do like a piping hot trail! \nTime to visit Shakespeare Cliff!", 
											TEN.Vec2(TEN.Util.PercentToScreen(subXpos, 75)), -- pos
											0.7, -- scale
											TEN.Color(12,123,220), -- color
											false, --translated bool
											{TEN.Strings.DisplayStringOption.SHADOW} -- flags
											)

LevelFuncs.EndingCut_Lara4 = function()
	TEN.Strings.ShowString(lara4_str, -- DisplayString to display
						   laraTimeSpan4-0.1, -- time span 
						   true -- autoDelete
						   )
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
end


function drawSubSprite()
	-- -- text background blur (for easier viewing)
	-- if TEN.Strings.IsStringDisplaying(winston1_str) or TEN.Strings.IsStringDisplaying(lara1_str) or 
	--    TEN.Strings.IsStringDisplaying(winston2_str) or TEN.Strings.IsStringDisplaying(lara2_str) or 
	--    TEN.Strings.IsStringDisplaying(winston3_str) or TEN.Strings.IsStringDisplaying(lara3_str) or 
	--                                                    TEN.Strings.IsStringDisplaying(lara4_str) then
	-- 	LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 82, 0, 100, 27, 0, 0, 2, 9)
	-- end
	
	-- Lara view (for easier viewing)
	-- if TEN.Strings.IsStringDisplaying(lara1_str) or 
	--    TEN.Strings.IsStringDisplaying(lara2_str) or 
	--    TEN.Strings.IsStringDisplaying(lara3_str) or 
	--    TEN.Strings.IsStringDisplaying(lara4_str) then
	if LevelFuncs.Engine.Node.TestMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1) then
		
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 82, 0, 100, 27, 0, 0, 2, 9)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 13, TEN.Color(255,255,255), 10, 82, 0, 25, 25, 0, 0, 0, 9)
	end
	
	-- Winston view (for easier viewing)
	-- if TEN.Strings.IsStringDisplaying(winston1_str) or 
	--    TEN.Strings.IsStringDisplaying(winston2_str) or 
	--    TEN.Strings.IsStringDisplaying(winston3_str) then
	if LevelFuncs.Engine.Node.TestMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 2) then
		
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 82, 0, 100, 27, 0, 0, 2, 9)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 14, TEN.Color(255,255,255), 10, 82, 0, 25, 25, 0, 0, 0, 9)
	end
end

local statsHeader_str = TEN.Strings.DisplayString("Finder's Khepers", 
											   TEN.Vec2(TEN.Util.PercentToScreen(50, 20)), -- pos
											   1.0, -- scale
											   TEN.Color(255,255,255), -- color
											   false, --translated bool
											   {TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW} -- flags
											   )
											   
LevelFuncs.DisplayStats = function()
	LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, "LARA_MAIN", "END_LSP")
	LevelFuncs.Engine.Node.PlayFlyBy(33)
	LevelFuncs.Engine.Node.PlayAudioTrack("001", 1)
	LevelFuncs.Engine.Node.SetMoveableAnimation("LARA_MAIN", 975)
	
	TEN.Strings.ShowString(statsHeader_str)
	local leftJustify = 30
	local rightJustify = 70
	local yStatsPos = 30
	-- time taken
	local timeTaken = tostring(Flow.GetStatistics().timeTaken)
	LevelFuncs.Engine.Node.DrawText("Time Taken: ", leftJustify, yStatsPos, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(endTimeTaken, rightJustify, yStatsPos, 2, 1, TEN.Color(255,255,255), 0.8)
	-- secrets found
	local secretsFound = ""..Flow.GetStatistics().secrets
	LevelFuncs.Engine.Node.DrawText("Secrets Found: ", leftJustify, yStatsPos+5, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(secretsFound, rightJustify, yStatsPos+5, 2, 1, TEN.Color(255,255,255), 0.8)
	-- Pickups
	local pickupsFound = ""..Flow.GetStatistics().pickups
	LevelFuncs.Engine.Node.DrawText("Pickups: ", leftJustify, yStatsPos+10, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(pickupsFound, rightJustify, yStatsPos+10, 2, 1, TEN.Color(255,255,255), 0.8)
	-- Kills
	local killsStats = ""..Flow.GetStatistics().kills
	LevelFuncs.Engine.Node.DrawText("Kills: ", leftJustify, yStatsPos+15, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(killsStats, rightJustify, yStatsPos+15, 2, 1, TEN.Color(255,255,255), 0.8)
	-- Ammo Used/Hits
	local ammoUsedHits = ""..Flow.GetStatistics().ammoUsed .. "/" .. Flow.GetStatistics().ammoHits
	LevelFuncs.Engine.Node.DrawText("Ammo Used/Hits: ", leftJustify, yStatsPos+20, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(ammoUsedHits, rightJustify, yStatsPos+20, 2, 1, TEN.Color(255,255,255), 0.8)
	-- Medipacks Used
	local healthPacksUsed = ""..Flow.GetStatistics().healthPacksUsed
	LevelFuncs.Engine.Node.DrawText("Medi Packs Used: ", leftJustify, yStatsPos+25, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(healthPacksUsed, rightJustify, yStatsPos+25, 2, 1, TEN.Color(255,255,255), 0.8)
	-- Distance Travelled in km
	-- convert to km : 1 m = 240 units -> 1km - 0.240 units
	local distanceTravelled = "" .. string.format("%.2f", (Flow.GetStatistics().distanceTraveled / 240) ) .. "m"
	LevelFuncs.Engine.Node.DrawText("Distance Travelled: ", leftJustify, yStatsPos+30, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(distanceTravelled, rightJustify, yStatsPos+30, 2, 1, TEN.Color(255,255,255), 0.8)
	
	LevelFuncs.Engine.Node.DrawText("(Press ACTION to continue)", 50, yStatsPos+40, 1, 3, TEN.Color(255,255,255), 0.8)
end

LevelFuncs.GetEndLevelTime = function()
	endTimeTaken = tostring(Flow.GetStatistics().timeTaken)
end

											   
function showStatsSpritesBackGround()
	-- text background blur (for easier viewing)
	if TEN.Strings.IsStringDisplaying(statsHeader_str) then
		--LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 50, 0, 100, 100, 0, 0, 2, 9)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 48, 0, 60, 80, 0, 0, 2, 9)
		
	else
		TEN.Strings.HideString(statsHeader_str)
	end

end

-----------------------------
--- PHYSICAL COMBAT BEGIN ---
-----------------------------
local canPulseAgain = true
function Knock_Out_Baddy(baddy_name, moveableSlot)
	-- if enemy is within 128 units of Lara
	local baddyPosition = TEN.Objects.GetMoveableByName(baddy_name):GetPosition()
	local laraPosition = TEN.Objects.GetMoveableByName("LARA_MAIN"):GetPosition()
	local distanceFromLara = math.abs(laraPosition:Distance(baddyPosition))
	local baddyObj = TEN.Objects.GetMoveableByName(baddy_name)
	
	if distanceFromLara <= 256.0 and baddyObj:GetActive() then
		--print("distance : " .. distanceFromLara)
		-- SPRINT SLIDE KNOCKOUT LOGIC
		-- if lara is performing a sprint slide
		if (LevelFuncs.Engine.Node.TestMoveableAnimation("LARA_MAIN", 956) or LevelFuncs.Engine.Node.TestMoveableAnimation("LARA_MAIN", 957)) then
			SetBaddyKnockoutAnim(moveableSlot, baddy_name, 0)
		-- else use kick mechanics
		else
			-- KNEE AND TWIST KICK LOGIC
			print("distance : " .. distanceFromLara)
			if Input.IsKeyPulsed(Input.ActionID.ACTION, 3, 2) and canPulseAgain == true and
			   LevelFuncs.Engine.Node.TestLaraVehicle() == false then -- and lara is not on a vehicle
				canPulseAgain = false
				local attackAnimIDs = {}
				-- Get the random attack anim for Lara
				if Lara:GetHandStatus() == Objects.HandStatus.WEAPON_DRAW or Lara:GetHandStatus() == Objects.HandStatus.WEAPON_READY then
					attackAnimIDs = {976} -- 976, 1005, 1003
				else
					attackAnimIDs = {977, 976, 1005, 1006}
				end
				local randomAttackAnim = attackAnimIDs[math.random(1, #attackAnimIDs)]

				if moveableSlot == ObjID.SMALL_SCORPION then
					randomAttackAnim = 1003
				end

				lara : SetAnim(randomAttackAnim)
				LevelFuncs.LaraKickOrganizer(moveableSlot, baddy_name, randomAttackAnim)
			end
		end
	end
end

function SetBaddyKnockoutAnim(moveableSlot, baddy_name, laraAttackAnim)
	baddy_obj = Objects.GetMoveableByName(baddy_name)
	-- determine the knock out anim based off the moveable slot
	if moveableSlot == ObjID.SAS_CAIRO then -- SAS

		defenseAnimIDs = {23, 23, 23, 26}
		randomDefenseAnim = defenseAnimIDs[math.random(1, #defenseAnimIDs)]

		-- if lara does a low kick or a pistol kick
		if laraAttackAnim == 1006 or laraAttackAnim == 1005 then
			-- do a defense anim
			LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 26)
		else
			-- do the fall back anim
			LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 23)
		end

	elseif moveableSlot == ObjID.FLAMETHROWER_BADDY then -- flamethrower
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 24)
	elseif moveableSlot == ObjID.MP_WITH_GUN then -- mp with gun
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 39)
	elseif moveableSlot == ObjID.TRIBESMAN_WITH_AX then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 31)
	elseif moveableSlot == ObjID.DOG then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 25)
	elseif moveableSlot == ObjID.BADDY2 then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 71)
	elseif moveableSlot == ObjID.HORSEMAN then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 3)
	elseif moveableSlot == ObjID.SMALL_SCORPION then
		local new_splat_name = "splat_EW_" .. tostring(LevelVars.SplatCounter)
		LevelVars.SplatCounter = LevelVars.SplatCounter + 1
		local spider_position = baddy_obj:GetPosition()
		local new_splat = Moveable(TEN.Objects.ObjID.ANIMATING36, -- object id
								  new_splat_name, -- name
								  spider_position) -- position
		LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, 
                                                                new_splat_name, 
                                                                baddy_name)
		-- shatter moveable
		LevelFuncs.Engine.Node.ShatterMoveable(baddy_name)
		baddy_obj:Destroy()
		LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 1163)
	end
end

LevelFuncs.LaraKickOrganizer = function(moveableSlot, baddy_name, laraAttackAnim)
	local attack_org = EventSequence.Create(
						"attack_org", -- sequence's name
						false, -- loop
						false, -- no countdown is displayed
						0.4,
						{LevelFuncs.KickAManBecauseItsWhatHeDeservesBINCH, moveableSlot, baddy_name, laraAttackAnim}, 
						0.9, 
						LevelFuncs.RestoreLaraWeaponStatus,
						0.01,
						LevelFuncs.RestoreLaraAnim
						)
	-- event sequences are inactive to begin with and so need to be started
    attack_org:Start()
end

LevelFuncs.KickAManBecauseItsWhatHeDeservesBINCH = function(moveableSlot, baddy_name, laraAttackAnim)
	SetBaddyKnockoutAnim(moveableSlot, baddy_name, laraAttackAnim)
end

LevelFuncs.RestoreLaraWeaponStatus = function()
	if Lara:GetHandStatus() == Objects.HandStatus.WEAPON_DRAW or Lara:GetHandStatus() == Objects.HandStatus.WEAPON_READY then
		-- init weaponLaraSlot
		local weaponLaraSlot = 0
		if Lara:GetWeaponType() == Objects.WeaponType.PISTOLS then
			weaponLaraSlot = 2
		elseif Lara:GetWeaponType() == Objects.WeaponType.UZIS then
			weaponLaraSlot = 3
		elseif Lara:GetWeaponType() == Objects.WeaponType.SHOTGUN then
			weaponLaraSlot = 4
		elseif Lara:GetWeaponType() == Objects.WeaponType.REVOLVER then
			weaponLaraSlot = 5
		elseif Lara:GetWeaponType() == Objects.WeaponType.CROSSBOW then
			weaponLaraSlot = 6
		elseif Lara:GetWeaponType() == Objects.WeaponType.HK then
			weaponLaraSlot = 7
		elseif Lara:GetWeaponType() == Objects.WeaponType.GRENADE_LAUNCHER then
			weaponLaraSlot = 8
		elseif Lara:GetWeaponType() == Objects.WeaponType.ROCKET_LAUNCHER then
			weaponLaraSlot = 9
		elseif Lara:GetWeaponType() == Objects.WeaponType.HARPOON_GUN then
			weaponLaraSlot = 10
		end
		print("WEAPON ID: "..Lara:GetWeaponType())
		LevelFuncs.Engine.Node.SetLaraWeaponType(Lara:GetWeaponType(), true)
		lara : SetAnim(0, weaponLaraSlot) -- perform anim 4 LARA_PISTOLS is slot 2
	end
end

LevelFuncs.RestoreLaraAnim = function()
	canPulseAgain = true
	if Lara:GetHandStatus() == Objects.HandStatus.WEAPON_DRAW or Lara:GetHandStatus() == Objects.HandStatus.WEAPON_READY then
		lara : SetAnim(103) -- perform anim 4 LARA_PISTOLS is slot 2
	end
end

function Knock_Out_Baddies()
    local moveableSlots = {
        ObjID.SAS_CAIRO, --'SAS CAIRO'
        ObjID.FLAMETHROWER_BADDY, -- FlameThrower Baddy
        ObjID.MP_WITH_GUN, -- 'MP wiht Gun'
        ObjID.BADDY2, -- 'Baddy2'
        ObjID.TRIBESMAN_WITH_AX,  -- scottsman
		ObjID.SMALL_SCORPION,
		ObjID.HORSEMAN
    }
    for index, moveableSlot in pairs(moveableSlots) do
        local moveables = GetMoveablesBySlot(moveableSlot)
        for index, moveable in pairs(moveables) do
			if moveable:GetActive() and moveable:GetHP() >= 1 then
				if moveableSlot == ObjID.SAS_CAIRO then -- if the moveable is a SAS
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.FLAMETHROWER_BADDY then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.MP_WITH_GUN then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.TRIBESMAN_WITH_AX then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.DOG then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.BADDY2 then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.SMALL_SCORPION then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.HORSEMAN then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
			end
        end
    end
end
---------------------------
--- PHYSICAL COMBAT END ---
---------------------------