-- FILE: \Levels\Swingpole.lua
---@diagnostic disable: duplicate-set-field
lara = TEN.Objects.GetMoveableByName("LARA_MAIN")
lara_name = "LARA_MAIN"
LevelFuncs.MISC_LOOP_FUNCTIONS = function()
	DeathEffect()
	LowSprintEffect()
	TR3_INV_SFX_OPEN()
	ShowAmmoCounter()
	SwingPoleExpansion()
	-- SafetyGrab()
	SprintSlide()
	QuickTurnAnimations()
	StumbleToRun()
	LedgeDiveFall()
	DustyFX()
	SwimBubbles()
end

-- Add the following line:
AddCallback(Logic.CallbackPoint.PRELOOP, LevelFuncs.MISC_LOOP_FUNCTIONS)
-- Note: usually PRELOOP should be what you're looking for.
-- I don't know the details, but sometimes you might need
-- POSTLOOP instead, so if you have issues, try that one.

function DustyFX()
    -- if gravel sfx is playing
    if (LevelFuncs.Engine.Node.SoundIsPlaying(290)) or  -- gravel
       (LevelFuncs.Engine.Node.SoundIsPlaying(32)) or   -- rolling
       (LevelFuncs.Engine.Node.SoundIsPlaying(3)) or    -- slipping down slope
       (LevelFuncs.Engine.Node.SoundIsPlaying(24)) then  -- crawling
		-- feet
        LevelFuncs.Engine.Node.ParticleEmitter(lara_name, 3, 0, 
                                                TEN.Vec3(0,0,0), 0, 0, 
                                                TEN.Color(35,35,35), TEN.Color(0,0,0), 
                                                2, 32, 32, 1, false, false)
	    LevelFuncs.Engine.Node.ParticleEmitter(lara_name, 6, 0, 
                                                TEN.Vec3(0,0,0), 0, 0, 
                                                TEN.Color(35,35,35), TEN.Color(0,0,0), 
                                                2, 32, 32, 1, false, false)
	end
	if lara:GetAnim() == 136 or lara:GetAnim() == 137 then -- shimmying
		-- hand
        LevelFuncs.Engine.Node.ParticleEmitter(lara_name, 10, 0, 
                                                TEN.Vec3(0,0,0), 0, 0, 
                                                TEN.Color(35,35,35), TEN.Color(0,0,0), 
                                                2, 32, 32, 2, false, false)
	    LevelFuncs.Engine.Node.ParticleEmitter(lara_name, 13, 0, 
                                                TEN.Vec3(0,0,0), 0, 0, 
                                                TEN.Color(35,35,35), TEN.Color(0,0,0), 
                                                2, 32, 32, 2, false, false)
	end
end

function SwimBubbles()
	if LevelFuncs.Engine.Node.SoundIsPlaying(35) then -- swim
		-- hand
		LevelFuncs.Engine.Node.ParticleEmitter(lara_name, 10, 17, 
                                                TEN.Vec3(0,0,0), 0, 0, 
                                                TEN.Color(35,35,35), TEN.Color(0,0,0), 
                                                2, 32, 32, 1, false, false)
	    LevelFuncs.Engine.Node.ParticleEmitter(lara_name, 13, 17, 
                                                TEN.Vec3(0,0,0), 0, 0, 
                                                TEN.Color(35,35,35), TEN.Color(0,0,0), 
                                                2, 32, 32, 1, false, false)
		-- feet
		LevelFuncs.Engine.Node.ParticleEmitter(lara_name, 3, 17, 
                                                TEN.Vec3(0,0,0), 0, 0, 
                                                TEN.Color(35,35,35), TEN.Color(0,0,0), 
                                                2, 32, 32, 1, false, false)
	    LevelFuncs.Engine.Node.ParticleEmitter(lara_name, 6, 17, 
                                                TEN.Vec3(0,0,0), 0, 0, 
                                                TEN.Color(35,35,35), TEN.Color(0,0,0), 
                                                2, 32, 32, 1, false, false)
	end
end


function LedgeDiveFall()
	-- check to trigger the safety grab
	if lara:GetAnim() == 35 and lara:GetFrame() >= 0 and lara:GetFrame() <= 1 and Input.IsKeyHeld(Input.ActionID.WALK) then
		lara:SetAnim(1032)
	end
end

function DeathEffect()
	local play_hurt_anim = true
    local noEffectUntilHealthPercentage = 0.33 -- This means 33% - below this value the color saturation should decrease
    local maxHealth = 1000 -- Lara's maximum health
    local currentHealth = Lara:GetHP() -- Get Lara's current health
    -- Calculate the current percentage of Lara's health
    local healthPercentage = currentHealth / maxHealth


    if healthPercentage < noEffectUntilHealthPercentage then
		-- play heartbeat on loop
    	LevelFuncs.Engine.Node.PlaySoundAroundMoveable("LARA_MAIN", 1158)
		if lara:GetAnim() >= 1025 and lara:GetAnim() <= 1027  then
			LevelFuncs.Engine.Node.PlaySoundAroundMoveable("LARA_MAIN", 1159)
		end
	end

	if play_hurt_anim == true then
		if healthPercentage < noEffectUntilHealthPercentage and
		   lara:GetAnim() == 103 and IsLaraNearKeyOrPuzzleHole() == false then
			lara : SetAnim(984)
	    end

		-- if Lara is in the hurt status
		if lara:GetAnim() == 985 then
			if healthPercentage >= noEffectUntilHealthPercentage or
			IsLaraNearKeyOrPuzzleHole() == true then
				-- segue back to 103
				lara:SetAnim(1028)
			end

		elseif lara:GetAnim() == 1026 then
			if healthPercentage >= noEffectUntilHealthPercentage or
			IsLaraNearKeyOrPuzzleHole() == true then
				-- segue back to 103
				lara:SetAnim(1029)
			end
		end
	end
end

function IsLaraNearKeyOrPuzzleHole()
	local KeyPuzzleHoleSlots = {
		393, -- pushable object 1
		404, -- zipline
		435, -- pushable object climbable 1
		436, -- pushable object climbable 2
		500, -- puzzle item 1
		501, -- puzzle item 2
		512, -- puzzle item 13
		513, -- puzzle item 14
		514, -- puzzle item 15
		515, -- puzzle item 16
		548, -- key item 1
		550, -- key item 3
		551, -- key item 4
		552, -- key item 5
		553, -- key item 6
		751, -- crowbar
		752, -- torch
		751, -- crowbar
		952, -- uzi
		953, -- uzi ammo
		954, -- shotgun
		955, -- shotgun ammo
		956, -- shotgun ammo
		957, -- revolver
		958, -- revolver ammo
		959, -- crossbow
		960, -- crossbow ammo
		961, -- crossbow ammo
		962, -- crossbow ammo
		964, -- hk
		965, -- hk ammo
		966, -- grenade
		967, -- grenade ammo
		968, -- grenade ammo
		969, -- grenade ammo
		971, -- rocekt
		972, -- rocekt ammo
		974, -- harpoon
		975, -- harpoon ammo
		978, -- big medi
		979, -- small medi
		980, -- lasersight
		983, -- flare item
		984, -- flare
        668, -- puzzle hole 1
		669, -- puzzle hole 2
		700, -- key hole 1
		702, -- key hole 3
		703, -- key hole 4
		800, -- switch type 1
		801, -- switch type 2
		802, -- switch type 3
		803, -- switch type 4
		806, -- switch type 7
		820, -- airlock switch
		821, -- wall switch
		823, -- ceiling type 1
		827, -- lever type
		828 -- jump switch
    }

	-- init empty list of all interactive items
	local interactiveObjects = {}
	local numEntries = 0
	-- for all moveable slots
	for index, keyPuzzleHoleSlot in pairs(KeyPuzzleHoleSlots) do
		-- get the associated moveables for that slot
        local keyPuzzleHoles = GetMoveablesBySlot(keyPuzzleHoleSlot)
		-- get length of table
		local numEntriesForSlot = #keyPuzzleHoles
		if numEntriesForSlot > 0 then
			-- append table of elements over to interactiveObjects
			table.move(keyPuzzleHoles, 1, numEntriesForSlot, #interactiveObjects+1, interactiveObjects)
			numEntries = numEntries + numEntriesForSlot
		end
	end
	-- parse through all the moveables in
	for index, currObj in pairs(interactiveObjects) do
		-- do the distance check logic
		-- print(currObj:GetName())
		local keyHolePosition = currObj:GetPosition()
		local laraPosition = lara:GetPosition()
		local distanceFromLara = math.abs(laraPosition:Distance(keyHolePosition))
		-- if lara is near the hole 650.0
		if distanceFromLara <= 700.0 then
			-- print("Lara is near " .. currObj:GetName())
			return true
		end
	end

	return false
end

function LowSprintEffect()
   local noEffectUntilSprintPercentage = 0.50 -- This means 50% - below this value the color saturation should decrease
   local maxSprint = 120 -- Lara's maximum health
   local currentSprintEnergy = Lara:GetStamina()
   -- Calculate the current percentage of Lara's health
   local sprintPercentage = currentSprintEnergy / maxSprint

   if sprintPercentage < noEffectUntilSprintPercentage then
       -- play heartbeat on loop
       LevelFuncs.Engine.Node.PlaySoundAroundMoveable("LARA_MAIN", 1159)
   end
end

function PlayHurtLara()
	lara : SetAnim(985)
end

function StumbleToRun()
	local stumbleAnimIDs = {1007, 1023, 1090} -- 1024 is gecko
	local randomStumbleAnim = stumbleAnimIDs[math.random(1, #stumbleAnimIDs)]
	-- if player is RUNNING
	if lara:GetAnim()==24 then
		-- if player presses ROLL button
		if Input.IsKeyHeld(Input.ActionID.ARROW_UP) then
			-- check frame range to determine next anim
			if (lara:GetFrame() >= 0 and lara:GetFrame() <= 2) then
				lara:SetAnim(randomStumbleAnim) -- 1023 or 1007
			end
		end
	end
end

function QuickTurnAnimations()
	local isLaraOnVehicle = LevelFuncs.Engine.Node.TestLaraVehicle()
	if isLaraOnVehicle == false then
		-- if player is RUNNING
		if lara:GetAnim()==0 then
			-- if player presses ROLL button
			-- if Input.IsKeyHeld(Input.ActionID.ARROW_UP) and Input.IsKeyHeld(Input.ActionID.ARROW_DOWN) then
			if (Input.IsKeyHeld(Input.ActionID.WALK) and Input.IsKeyHeld(Input.ActionID.ROLL)) or 
				(Input.IsKeyHeld(Input.ActionID.WALK) and Input.IsKeyHeld(Input.ActionID.ARROW_DOWN) ) then
				-- check frame range to determine next anim
				if (lara:GetFrame() >= 0 and lara:GetFrame() <= 5) or lara:GetFrame() >= 20 then
					-- set turn LEFT
					lara:SetAnim(1008)
				elseif (lara:GetFrame() >= 6 and lara:GetFrame() <= 19) then
					-- set turn RIGHT
					lara:SetAnim(1010)
				end
			end
		end
		
		-- if the player is WALKING
		if lara:GetAnim()==1 then
			-- if player presses ROLL button
			if Input.IsKeyHeld(Input.ActionID.ROLL) or 
			(Input.IsKeyHeld(Input.ActionID.ARROW_UP) and Input.IsKeyHeld(Input.ActionID.ARROW_DOWN)) then
				-- check frame range to determine next anim
				local frameToSet = 1
				if (lara:GetFrame() >= 0 and lara:GetFrame() <= 6) or lara:GetFrame() >= 34 then
					-- set turn LEFT
					lara:SetAnim(1012)
					lara:SetFrame(frameToSet)
				elseif (lara:GetFrame() >= 16 and lara:GetFrame() <= 24) then
					-- set turn RIGHT
					lara:SetAnim(1014)
					lara:SetFrame(frameToSet)
				end
			end
		end

		-- running 180 logic
		if (lara:GetAnim()==1008 or lara:GetAnim()==1010) and 
		lara:GetFrame() == 16 then
			if lara:GetAnim() == 1008 then 
				local currRot = lara:GetRotation()
				lara : SetRotation(Rotation(0,currRot.y - 180.0,0))
				lara:SetAnim(1009)
			end
			if lara:GetAnim() == 1010 then
				local currRot = lara:GetRotation()
				lara : SetRotation(Rotation(0,currRot.y - 180.0,0))
				lara:SetAnim(1011)
			end
		end

		-- walking 180 logic
		if (lara:GetAnim()==1012 or lara:GetAnim()==1014) and 
		lara:GetFrame() == 8 then
			if lara:GetAnim() == 1012 then 
				local currRot = lara:GetRotation()
				lara : SetRotation(Rotation(0,currRot.y - 180.0,0))
				lara:SetAnim(1013)
			end
			if lara:GetAnim() == 1014 then
				local currRot = lara:GetRotation()
				lara : SetRotation(Rotation(0,currRot.y - 180.0,0))
				lara:SetAnim(1015)
			end
		end
	end
end

function SwingPoleExpansion()

	if ( lara : GetAnim()== 461) then
		KeyClear(2)
		KeyClear(3)
		LevelFuncs.Engine.Node.ModifyGameVariable("OnSwingpole", 4, 1)
	end
	if (LevelFuncs.Engine.Node.TestGameVariable("OnSwingpole", 0, 1))then
		LevelFuncs.Engine.Node.ModifyGameVariable("DoubleJump", 4, 1)
	
		--Swingpole
		-- if lara is swinging and the player presses JUMP
		if ( lara : GetAnim()== 462 and lara : GetFrame()== 6 and IsKeyHeld(9)) then -- 9 : JUMP
			Lara : SetAirborne(false)
			lara : SetAnim(463)
			LevelFuncs.Engine.Node.ModifyGameVariable("OnSwingpole", 4, 0)
			end --jump
		-- if lara is swinging and the player not presses FORWARD
		if ( lara : GetAnim()== 462 and lara : GetFrame()== 0 and not IsKeyHeld(0)) then
			Lara : SetAirborne(false)
			lara : SetAnim(622)
			KeyClear(2)
			KeyClear(3)
			end --Stop
		-- if lara is hanging and not pressing ACTION
		if ( lara : GetAnim()== 619 and not IsKeyHeld(11)) then
			Lara : SetAirborne(true)
			lara : SetAnim(618)
			LevelFuncs.Engine.Node.ModifyGameVariable("OnSwingpole", 4, 0)
			end --fall
		-- if lara is hanging and pressing FORWARD
		if ( lara : GetAnim()== 619 and  IsKeyHeld(0)) then
			Lara : SetAirborne(false)
			lara : SetAnim(612)
			KeyClear(2)
			KeyClear(3)
			end --Startagain
		-- if lara is hanging and pressing BACK
		if ( lara : GetAnim()== 619 and  IsKeyHeld(1)) then
			local a = false
			Lara : SetAirborne(false)
			lara : SetAnim(613)
			KeyClear(2)
			KeyClear(3)
			if(LevelFuncs.Engine.Node.TestGameVariable("SwingPoleBlockRight", 0, 1))then
				 LevelFuncs.Engine.Node.ModifyGameVariable("SwingPoleBlockRight", 4, 0)
				 LevelFuncs.Engine.Node.ModifyGameVariable("SwingPoleBlockLeft", 4, 1)
				 a = true
			end
			if(LevelFuncs.Engine.Node.TestGameVariable("SwingPoleBlockLeft", 0, 1) and a ==false)then
				 LevelFuncs.Engine.Node.ModifyGameVariable("SwingPoleBlockRight", 4, 1)
				 LevelFuncs.Engine.Node.ModifyGameVariable("SwingPoleBlockLeft", 4, 0)
			end
			end-- turnlow
		if ( lara : GetAnim()== 462 and lara : GetFrame()== 6 and IsKeyHeld(1)) or 
		   ( lara : GetAnim()== 462 and lara : GetFrame()== 6 and IsKeyHeld(Input.ActionID.ROLL)) then
			Lara : SetAirborne(false)
			lara : SetAnim(620)
			KeyClear(2)
			KeyClear(3)
			end--turn mid
		if ( lara : GetAnim()== 462 and lara : GetFrame()== 20 and IsKeyHeld(1)) or 
		   ( lara : GetAnim()== 462 and lara : GetFrame()== 20 and IsKeyHeld(Input.ActionID.ROLL)) then
			Lara : SetAirborne(false)
			lara : SetAnim(615)
			KeyClear(2)
			KeyClear(3)
			end--turn high
		if ( lara : GetAnim()== 462 and lara : GetFrame()== 20 and IsKeyHeld(7)) then
			Lara : SetAirborne(false)
			lara : SetAnim(632)
			KeyClear(2)
			KeyClear(3)
			end--fasterA
		if ( lara : GetAnim()== 462 and lara : GetFrame()== 2 and IsKeyHeld(7)) then
			Lara : SetAirborne(false)
			lara : SetAnim(634)
			KeyClear(2)
			KeyClear(3)
			end--fasterB
		if ( lara : GetAnim()== 630 and lara : GetFrame()== 20 and not IsKeyHeld(7)) then
			Lara : SetAirborne(false)
			lara : SetAnim(631)
			KeyClear(2)
			KeyClear(3)
			end--slowerA
		if ( lara : GetAnim()== 630 and lara : GetFrame()== 1 and not IsKeyHeld(7)) then
			Lara : SetAirborne(false)
			lara : SetAnim(633)
			KeyClear(2)
			KeyClear(3)
			end--slowerB
			
		if ( lara : GetAnim()== 630 and lara : GetFrame()== 3 and  IsKeyHeld(9)) then
			Lara : SetAirborne(false)
			lara : SetAnim(635)
			LevelFuncs.Engine.Node.ModifyGameVariable("OnSwingpole", 4, 0)
			end--fasterjump
		if ( lara : GetAnim()== 619 and  IsKeyHeld(2)and LevelFuncs.Engine.Node.TestGameVariable("SwingPoleBlockLeft", 0, 0)) then
			Lara : SetAirborne(false)
			lara : SetAnim(640)
			LevelFuncs.Engine.Node.ModifyGameVariable("SwingPoleBlockRight", 4, 0)
			end--pole shimmyleft
		if ( lara : GetAnim()== 619 and  IsKeyHeld(3) and LevelFuncs.Engine.Node.TestGameVariable("SwingPoleBlockRight", 0, 0)) then
			Lara : SetAirborne(false)
			lara : SetAnim(641)
			LevelFuncs.Engine.Node.ModifyGameVariable("SwingPoleBlockLeft", 4, 0)
			end--pole shimmyright
		if ( lara : GetAnim()== 640 and not IsKeyHeld(2) ) then
			Lara : SetAirborne(false)
			lara : SetAnim(619)
	
			end--pole shimmyleft stop
		if ( lara : GetAnim()== 641 and not IsKeyHeld(3)) then
			Lara : SetAirborne(false)
			lara : SetAnim(619)
			end--pole shimmyright stop
		
		-- if lara is hanging and pressing CROUCH
		if ( lara : GetAnim()== 619 and  IsKeyHeld(8)) then
			Lara : SetAirborne(false)
			lara : SetAnim(623)
			end--swingpole climp up from hang
		-- if lara is swinging and pressing CROUCH
		if ( lara : GetAnim()== 612 and lara : GetFrame()== 35 and  IsKeyHeld(8)) then
			Lara : SetAirborne(false)
			lara : SetAnim(644)
			end--swingpole climp up from start swing
		-- if lara is swinging and pressing CROUCH
		if ( lara : GetAnim()== 462 and lara : GetFrame()== 19 and  IsKeyHeld(8)) then
			Lara : SetAirborne(false)
			lara : SetAnim(645)
			end--swingpole climp up while swinging
		-- if lara is swinging and pressing CROUCH
		if ( lara : GetAnim()== 462 and lara : GetFrame()== 19 and not IsKeyHeld(0)) then
			Lara : SetAirborne(false)
			lara : SetAnim(645)
			end--swingpole climp up while swinging
		-- if lara is swinging and pressing CROUCH
		if ( lara : GetAnim()== 643 and lara : GetFrame()== 29 and  IsKeyHeld(8)) then
			Lara : SetAirborne(false)
			lara : SetAnim(647)
			end--swingpole climp up from handstand
		-- if lara is perched and pressed DOWN
		if ( lara : GetAnim()== 624 and  IsKeyHeld(1)) then
			Lara : SetAirborne(false)
			lara : SetAnim(625)
			end--swingpole climp down
		
		-- if lara is hanging and pressing JUMP
		if ( lara : GetAnim()== 619 and  IsKeyHeld(9)) then
			Lara : SetAirborne(false)
			lara : SetAnim(646)
			end--swingpole climp up from hang
		-- if lara is perched and pressed DOWN (LEFT ARM)
		if ( lara : GetAnim()== 647 and  IsKeyHeld(1)) then
			Lara : SetAirborne(false)
			lara : SetAnim(648)
			end--swingpole climp down
		-- if lara is perched and pressed JUMP (LEFT ARM)
		if ( lara : GetAnim()== 647 and  IsKeyHeld(9)) then
			Lara : SetAirborne(false)
			lara : SetAnim(649)
			end--swingpole climp down
		-- if lara is perched and pressed DOWN (RIGHT ARM)
		if ( lara : GetAnim()== 666 and  IsKeyHeld(1)) then
			Lara : SetAirborne(false)
			lara : SetAnim(667)
			end--swingpole climp down
		-- if lara is perched and pressed JUMP (RIGHT ARM)
		if ( lara : GetAnim()== 666 and  IsKeyHeld(9)) then
			Lara : SetAirborne(false)
			lara : SetAnim(649)
			end--swingpole climp down
			
		-- FIX THE TIGHTROPE ANIMS
		-- TRNG POLE PERCH TO TIGHTROPE MECHANIC
		local yrotation = tonumber (string.sub(tostring(lara : GetRotation()),13,17))
		--local yrotation = tonumber (lara : GetRotation())
		-- LEFT ARM SET
		-- if lara is perched and pressed LEFT
		if ( (lara : GetAnim()== 647 or lara : GetAnim()== 666) and  IsKeyHeld(2)) then
			Lara : SetAirborne(false)
			currRot = lara:GetRotation()
			lara : SetRotation(Rotation(0,currRot.y - 90.0,0))
			lara : SetAnim(651)
			
			end--swingpole to tightrope Left (left arm)
		-- if lara is perched and pressed RIGHT
		if ( (lara : GetAnim()== 647 or lara : GetAnim()== 666) and  IsKeyHeld(3)) then
			Lara : SetAirborne(false)
			lara : SetAnim(663)
			currRot = lara:GetRotation()
			lara : SetRotation(Rotation(0,currRot.y + 90.0,0))
			end--swingpole to tightrope right (left arm)
		-- if lara is standing on tightrope and pressed UP (LEFT)
		if ( lara : GetAnim()== 654 and IsKeyHeld(0)) then
			Lara : SetAirborne(false)
			lara : SetAnim(656)
			end--tightrope left to walk Left (left arm)
		-- if lara is standing on tightrope and pressed UP (LEFT)
		if ( lara : GetAnim()== 668 and IsKeyHeld(0)) then
			Lara : SetAirborne(false)
			lara : SetAnim(661)
			end--tightrope left to walk Left (left arm)
		-- if lara is walking on tightrope and stopped pressing up (LEFT)
		if ( lara : GetAnim()== 659 and not IsKeyHeld(0)) then
			Lara : SetAirborne(false)
			lara : SetAnim(657)
			end--tightrope left to walk Left (left arm) 
		-- if lara is standing on tightrope and pressed CROUCH (LEFT)
		if ( lara : GetAnim()== 654 and IsKeyHeld(8)) then
			Lara : SetAirborne(false)
			lara : SetAnim(653)
			currRot = lara:GetRotation()
			lara : SetRotation(Rotation(0,currRot.y + 90.0,0))
			end
		-- if lara is standing on tightrope and pressed CROUCH (RIGHT)
		if ( lara : GetAnim()== 668 and IsKeyHeld(8)) then
			Lara : SetAirborne(false)
			currRot = lara:GetRotation()
			lara : SetRotation(Rotation(0,currRot.y - 90.0,0))
			lara : SetAnim(665)
			end
		-- if lara is standing on a tightrope and pressed JUMP
		if ( (lara : GetAnim()== 654 or lara : GetAnim()== 668) and  IsKeyHeld(9)) then
			Lara : SetAirborne(true)
			lara : SetAnim(669)
			end--swingpole to tightrope Left (left arm) 
		-- if lara is standing on a tightrope and pressed DOWN
		if ( (lara : GetAnim()== 654 or lara : GetAnim()== 668) and  IsKeyHeld(1)) then
			Lara : SetAirborne(false)
			lara : SetAnim(658)
			end--swingpole to tightrope Left (left arm) 
		-- if lara is walking on tightrope (left foot forward) and presses DASH
		if ( (lara : GetAnim()== 654 or lara : GetAnim()== 655 or lara : GetAnim()== 659) and  IsKeyHeld(7)) then
			Lara : SetAirborne(false)
			lara : SetAnim(670)
			end--swingpole to tightrope Left (left arm) 
		-- if lara is walking on tightrope (right foot forward) and presses DASH
		if ( (lara : GetAnim()== 668 or lara : GetAnim()== 669) and  IsKeyHeld(7)) then
			Lara : SetAirborne(false)
			lara : SetAnim(670)
			end--swingpole to tightrope Left (left arm) 
		
		-- if lara is perched and pressed LEFT (DAWOS)
		if ( lara : GetAnim()== 624 and  IsKeyHeld(2) and LevelFuncs.Engine.Node.TestGameVariable("SwingPoleBlockLeft", 0, 0)) then
			Lara : SetAirborne(false)
			lara : SetAnim(626)
			LevelFuncs.Engine.Node.ModifyGameVariable("SwingPoleBlockRight", 4, 0)
		end--swingpole climp left
		-- if Lara is perched and pressed RIGHT
		if ( lara : GetAnim()== 624 and  IsKeyHeld(3) and LevelFuncs.Engine.Node.TestGameVariable("SwingPoleBlockRight", 0, 0)) then
			Lara : SetAirborne(false)
			lara : SetAnim(628)
			LevelFuncs.Engine.Node.ModifyGameVariable("SwingPoleBlockLeft", 4, 0)
		end--swingpole climp right
		
		if ( lara : GetAnim()== 626 and  not IsKeyHeld(2)) then
			Lara : SetAirborne(false)
			lara : SetAnim(624)
		end--bar top climb left stop
		if ( lara : GetAnim()== 628 and  not IsKeyHeld(3)) then
			Lara : SetAirborne(false)
			lara : SetAnim(624)
		end--bar top climb right stop
		
		local yrotation = tonumber (string.sub(tostring(lara : GetRotation()),13,17))	
			
		if ( (lara : GetAnim()== 624 or lara : GetAnim()== 626) and  IsKeyHeld(2) and  IsKeyHeld(9)) then
			Lara : SetAirborne(false)
			currRot = lara:GetRotation()
			lara : SetRotation(Rotation(0,currRot.y - 90.0,0))
			lara : SetAnim(627)
			LevelFuncs.Engine.Node.ModifyGameVariable("OnSwingpole", 4, 0)
		end--bar top jump left
		if (( lara : GetAnim()== 624 or lara : GetAnim()== 628) and  IsKeyHeld(3)and  IsKeyHeld(9)) then
			Lara : SetAirborne(false)
			currRot = lara:GetRotation()
			lara : SetRotation(Rotation(0,currRot.y + 90.0,0))
			lara : SetAnim(629)
			LevelFuncs.Engine.Node.ModifyGameVariable("OnSwingpole", 4, 0)
		end--bar top jump right
		
		if (( lara : GetAnim()== 624)and  IsKeyHeld(0)and  IsKeyHeld(9)) then
			Lara : SetAirborne(false)
			lara : SetAnim(636)
			LevelFuncs.Engine.Node.ModifyGameVariable("OnSwingpole", 4, 0)
		end--bar top jump forward
		
		
		
	end
end

function TR3_INV_SFX_OPEN()
	if (LevelFuncs.Engine.Node.KeyIsHit(37)) then
		LevelFuncs.Engine.Node.PlaySoundAroundMoveable("LARA_MAIN", 109)
	end
	if (LevelFuncs.Engine.Node.KeyIsHit(38)) then
		LevelFuncs.Engine.Node.PlaySoundAroundMoveable("LARA_MAIN", 109)
	end
end


function ShowAmmoCounter()
    local weaponType = " "
    local ammoCounterPosX = 100 -- X Position of counter.
    local ammoCounterPosY = 300 -- Y Position of counter.
    local holdWeapon = Lara:GetHandStatus() -- Check Lara's hand status.
    local ammoCounterColor = Color(255, 255, 255) 
    local ammoMessage = DisplayString(
    "Ammo: ".. Lara:GetHandStatus(), 100,
    300, Color(255, 255, 255))

    if (holdWeapon == 4 and not(Lara:GetWeaponType() == 7) and not(Lara:GetWeaponType() == 8)) then
	    	-- get the weapon type
	    if Lara:GetWeaponType() == 1 then
	    	LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 3, TEN.Color(255,255,255), 5, 12, 0, 12, 7, 0, 0, 0, 9)
	    elseif Lara:GetWeaponType() == 2 then
	    	LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 4, TEN.Color(255,255,255), 5, 12, 0, 12, 7, 0, 0, 0, 9)
	    elseif Lara:GetWeaponType() == 3 then
	    	LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 5, TEN.Color(255,255,255), 5, 12, 0, 12, 7, 0, 0, 0, 9)
	    elseif Lara:GetWeaponType() == 4 then
	    	LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 6, TEN.Color(255,255,255), 5, 12, 0, 12, 7, 0, 0, 0, 9)
	    elseif Lara:GetWeaponType() == 5 then
	    	LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 7, TEN.Color(255,255,255), 5, 12, 0, 12, 7, 0, 0, 0, 9)
	    elseif Lara:GetWeaponType() == 6 then
	    	LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 8, TEN.Color(255,255,255), 5, 12, 0, 12, 7, 0, 0, 0, 9)
	    elseif Lara:GetWeaponType() == 9 then
	    	LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 9, TEN.Color(255,255,255), 5, 12, 0, 12, 7, 0, 0, 0, 9)
	    elseif Lara:GetWeaponType() == 10 then
	    	LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 10, TEN.Color(255,255,255), 5, 12, 0, 12, 7, 0, 0, 0, 9)
	    elseif Lara:GetWeaponType() == 11 then
	    	LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 11, TEN.Color(255,255,255), 5, 12, 0, 12, 7, 0, 0, 0, 9)
	    end
	    
		if (Lara:GetAmmoCount() == -1) then
			LevelFuncs.Engine.Node.DrawText("Unlimited", 9, 10, 0, 3, TEN.Color(255,255,255), 0.8)
		else
			LevelFuncs.Engine.Node.DrawText(""..Lara:GetAmmoCount(), 9, 10, 0, 3, TEN.Color(255,255,255), 0.8)
		end
    else
        HideString(ammoMessage)
    end
end

function SprintSlide()
	-- if Lara is sprinting
	if lara:GetAnim() == 223 then
		-- if the player presses the WALK key
		if Input.IsKeyHeld(ActionID.WALK) then
			-- if the key was hit in the frame range [9,18]
			if lara:GetFrame() >= 9 and lara:GetFrame() <= 18 then
				-- play anim 957 (sprint slide right)
				lara:SetAnim(957)
			elseif lara:GetFrame() >= 0 and lara:GetFrame() < 9 then
				-- play anim 956 (sprint slide left)
				lara:SetAnim(956)
			end
		end
	-- else if Lara is running sprint left
	elseif lara:GetAnim() == 224 then
		-- if the player presses the WALK key
		if Input.IsKeyHeld(ActionID.WALK) then
			-- play anim 956 (sprint slide left)
			lara:SetAnim(956)
		end
	-- else if Lara is run to sprint right
	elseif lara:GetAnim() == 225 then
		-- if the player presses the WALK key
		if Input.IsKeyHeld(ActionID.WALK) then
			-- play anim 957 (sprint slide right)
			lara:SetAnim(957)
		end
	end
	-- if Lara is running
	local isLaraOnVehicle = LevelFuncs.Engine.Node.TestLaraVehicle()
	if lara:GetAnim() == 0 and isLaraOnVehicle == false then
		-- if the player presses the WALK key
		if Input.IsKeyHeld(ActionID.SPRINT) and Input.IsKeyHeld(ActionID.WALK) then
			-- if the key was hit in the frame range [9,18]
			if lara:GetFrame() >= 9 and lara:GetFrame() <= 18 then
				-- play anim 957 (sprint slide right)
				lara:SetAnim(957)
			elseif lara:GetFrame() >= 0 and lara:GetFrame() < 9 then
				-- play anim 956 (sprint slide left)
				lara:SetAnim(956)
			end
		end
	end
	---- else if Lara crouches left while sprint sliding
	--elseif (LevelFuncs.Engine.Node.TestMoveableAnimation(lara_obj, 962)) then 
		---- if the player presses CROUCH
		--if (LevelFuncs.Engine.Node.KeyIsHeld(8)) then
			---- play anim 952 (sprint slide left to crouch)
			--LevelFuncs.Engine.Node.SetMoveableAnimation(lara_obj, 952)
		--end
	---- else if Lara crouches right while sprint sliding
	--elseif (LevelFuncs.Engine.Node.TestMoveableAnimation(lara_obj, 963)) then 
		---- if the player presses CROUCH
		--if (LevelFuncs.Engine.Node.KeyIsHeld(8)) then
			---- play anim 953 (sprint slide right to crouch)
			--LevelFuncs.Engine.Node.SetMoveableAnimation(lara_obj, 953)
		--end 
	--end
	
end

function SafetyGrab()
	-- check to trigger the safety grab
	if lara:GetAnim() == 34 and lara:GetFrame() >= 0 and lara:GetFrame() <= 1 and Input.IsKeyHeld(Input.ActionID.ACTION) then
		lara:SetAnim(982)
	end

	-- if Lara if performing the RUNNING_QUICK_SAVE_START anim
	-- my Lara object has it in slot 982. Update yours accordingly --1016
	if lara : GetAnim()== 982 or lara : GetAnim()== 1016 then
		-- set airborne to false 
		Lara : SetAirborne(false)
	end --run safety grab start
	
	-- if Lara if performing the RUNNING_QUICK_SAVE_END anim
	-- my Lara object has it in slot 983. Update yours accordingly --1017
	if lara : GetAnim()== 983 or lara : GetAnim()== 1017 then
		Lara : SetAirborne(true)
	end --run safety grab end
end

LevelFuncs.BLUE_GOO_KILL = function()
	LevelFuncs.Engine.Node.SetMoveableAnimation("LARA_MAIN", 980)
	--LevelFuncs.Engine.Node.RunLuaScript(LevelFuncs.BloodifyLara, "")
	LevelFuncs.Engine.Node.ParticleEmitter("LARA_MAIN", 0, 0, TEN.Vec3(2,3,4), 0, 0, TEN.Color(0,255,255), TEN.Color(128,255,255), 2, 64, 1024, 6, false, false)
	LevelFuncs.Engine.Node.SetMoveableHitPoints(1, 0, "LARA_MAIN")
end

LevelFuncs.AddSecretID = function(secretID)
	Flow.AddSecret(tonumber(secretID))
	LevelFuncs.Engine.Node.PlayAudioTrack("005", 0)
end