-- Place in this Lua script all the levels of your game
-- Title is mandatory and must be the first level.

-- Intro image is a splash screen which appears before actual loading screen.
-- If you don't want it to appear, just remove this line.

Flow.SetIntroImagePath("Screens\\main.jpg")

-- This image should be used for static title screen background (as in TR1-TR3).
-- For now it is not implemented.

Flow.SetTitleScreenImagePath("Screens\\main.jpg")

-- Set overall amount of secrets in game.
-- If set to 0, secrets won't be displayed in statistics.

Flow.SetTotalSecretCount(42)

-- Disable/enable flycheat globally

Flow.EnableFlyCheat(true)

-- Disable/enable Lara drawing in title level

Flow.EnableLaraInTitle(false)

-- Disable/enable level selection in title level

Flow.EnableLevelSelect(false)

-- Disable/enable mass pickup (collect all pickups at once)

Flow.EnableMassPickup(true)

--------------------------------------------------

-- Title level

title = Level.new()

title.ambientTrack = "104"
title.levelFile = "Data\\title.ten"
title.scriptFile = "Scripts\\title.lua"
title.loadScreenFile = "Screens\\Main.png"
title.horizon = true
Flow.AddLevel(title)

--------------------------------------------------



	Prologue = Level.new()

Prologue.nameKey = "Prologue"
Prologue.scriptFile = "Scripts\\Prologue.lua"
Prologue.ambientTrack = "108"
Prologue.horizon = true
Prologue.levelFile = "Data\\Prologue.ten"
Prologue.loadScreenFile = "Screens\\barhout.jpg"
Prologue.objects = {

----------KEYS AND PUZZLES---------



-------SECRETS------
InventoryItem.new("secret1", ObjID.PICKUP_ITEM14, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("secret2", ObjID.PICKUP_ITEM15, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("secret3", ObjID.PICKUP_ITEM16, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),

-------DEFAULT ITEMS------

InventoryItem.new("small_medipack", ObjID.SMALLMEDI_ITEM, 40, 0.7, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("large_medipack", ObjID.BIGMEDI_ITEM, 38, 0.6, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("revolver", ObjID.REVOLVER_ITEM, 40, 0.8, Rotation.new(70, 0, 80), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("harpoon_gun", ObjID.HARPOON_ITEM, 10, 0.8, Rotation.new(120, 00, 50), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("uzis", ObjID.UZI_ITEM, 0, 0.8, Rotation.new(70, 0, 80), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("flares", ObjID.FLARE_INV_ITEM, 0, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),


    -------OTHERS------
InventoryItem.new("pickup1", ObjID.PICKUP_ITEM1, 0, 0.5, Rotation.new(45, 45, 45), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("lockstone", ObjID.PUZZLE_ITEM16, 0, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("puzzle15", ObjID.PUZZLE_ITEM15, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("mirror_seal", ObjID.PUZZLE_ITEM15_COMBO1, 0, 0.5, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE),
InventoryItem.new("mirror_gem", ObjID.PUZZLE_ITEM15_COMBO2, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE);

}

Flow.AddLevel(Prologue)

	The_Cold_Waste = Level.new()

The_Cold_Waste.nameKey = "The_Cold_Waste"
The_Cold_Waste.scriptFile = "Scripts\\The_Cold_Waste.lua"
The_Cold_Waste.ambientTrack = "107"
The_Cold_Waste.horizon = true
The_Cold_Waste.levelFile = "Data\\The_Cold_Waste.ten"
The_Cold_Waste.loadScreenFile = "Screens\\coldwaste.jpg"
The_Cold_Waste.layer2 = Flow.SkyLayer.new(Color.new(122, 158, 177), 60)
The_Cold_Waste.weather = WeatherType.Snow
The_Cold_Waste.weatherStrength = 1.0
The_Cold_Waste.storm = true
The_Cold_Waste.objects = {


----------KEYS AND PUZZLES---------
InventoryItem.new("level2key_item1", ObjID.KEY_ITEM1, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("level2key_item2", ObjID.KEY_ITEM2, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),


-------SECRETS------
InventoryItem.new("secret1", ObjID.PICKUP_ITEM14, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("secret2", ObjID.PICKUP_ITEM15, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("secret3", ObjID.PICKUP_ITEM16, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),

-------DEFAULT ITEMS------

InventoryItem.new("small_medipack", ObjID.SMALLMEDI_ITEM, 40, 0.7, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("large_medipack", ObjID.BIGMEDI_ITEM, 38, 0.6, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("flares", ObjID.FLARE_INV_ITEM, 0, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),


-------OTHERS------
InventoryItem.new("pickup1", ObjID.PICKUP_ITEM1, 0, 0.5, Rotation.new(45, 45, 45), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("lockstone", ObjID.PUZZLE_ITEM16, 0, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("puzzle15", ObjID.PUZZLE_ITEM15, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("mirror_seal", ObjID.PUZZLE_ITEM15_COMBO1, 0, 0.5, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE),
InventoryItem.new("mirror_gem", ObjID.PUZZLE_ITEM15_COMBO2, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE);

-------SOULS------
InventoryItem.new("fragment1", ObjID.PICKUP_ITEM13, 0, 0.7, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.COMBINE);

}

Flow.AddLevel(The_Cold_Waste)

	Sarkomand = Level.new()

Sarkomand.nameKey = "Sarkomand"
Sarkomand.scriptFile = "Scripts\\Sarkomand.lua"
Sarkomand.ambientTrack = "107"
Sarkomand.horizon = true
Sarkomand.storm = true
Sarkomand.layer2 = Flow.SkyLayer.new(Color.new(170, 191, 198), 60)
Sarkomand.levelFile = "Data\\Sarkomand.ten"
Sarkomand.loadScreenFile = "Screens\\sarkomand.jpg"
Sarkomand.weather = WeatherType.Snow
Sarkomand.weatherStrength = 1.0
Sarkomand.objects = {

----------KEYS AND PUZZLES---------

InventoryItem.new("level3key_item1", ObjID.KEY_ITEM1, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("level3key_item2", ObjID.KEY_ITEM7, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("level3key_item5", ObjID.KEY_ITEM5, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("level3puzzle_item1", ObjID.PUZZLE_ITEM1, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),

-------SECRETS------
InventoryItem.new("secret1", ObjID.PICKUP_ITEM14, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("secret2", ObjID.PICKUP_ITEM15, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("secret3", ObjID.PICKUP_ITEM16, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),

-------DEFAULT ITEMS------

InventoryItem.new("small_medipack", ObjID.SMALLMEDI_ITEM, 40, 0.7, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("large_medipack", ObjID.BIGMEDI_ITEM, 38, 0.6, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("flares", ObjID.FLARE_INV_ITEM, 0, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),

    -------OTHERS------
InventoryItem.new("pickup1", ObjID.PICKUP_ITEM1, 0, 0.5, Rotation.new(45, 45, 45), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("lockstone", ObjID.PUZZLE_ITEM16, 0, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("puzzle15", ObjID.PUZZLE_ITEM15, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("mirror_seal", ObjID.PUZZLE_ITEM15_COMBO1, 0, 0.5, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE),
InventoryItem.new("mirror_gem", ObjID.PUZZLE_ITEM15_COMBO2, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE);


}

Flow.AddLevel(Sarkomand)

	Ygiroth = Level.new()

Ygiroth.nameKey = "Ygiroth"
Ygiroth.scriptFile = "Scripts\\Ygiroth.lua"
Ygiroth.ambientTrack = "122"
Ygiroth.horizon = true
Ygiroth.layer2 = Flow.SkyLayer.new(Color.new(122, 158, 177), 60)
Ygiroth.weather = WeatherType.Snow
Ygiroth.storm = true
Ygiroth.levelFile = "Data\\Ygiroth.ten"
Ygiroth.loadScreenFile = "Screens\\ygiroth.jpg"
Ygiroth.objects = {

----------KEYS AND PUZZLES---------

InventoryItem.new("level4key_item2", ObjID.KEY_ITEM2, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("level4key_item3", ObjID.KEY_ITEM3, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("level4key_item4", ObjID.KEY_ITEM4, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("level4puzzle_item3", ObjID.PUZZLE_ITEM3, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),

-------SECRETS------
InventoryItem.new("secret1", ObjID.PICKUP_ITEM14, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("secret2", ObjID.PICKUP_ITEM15, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("secret3", ObjID.PICKUP_ITEM16, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),

-------DEFAULT ITEMS------

InventoryItem.new("small_medipack", ObjID.SMALLMEDI_ITEM, 40, 0.7, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("large_medipack", ObjID.BIGMEDI_ITEM, 38, 0.6, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("flares", ObjID.FLARE_INV_ITEM, 0, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),


    -------OTHERS------
InventoryItem.new("pickup1", ObjID.PICKUP_ITEM1, 0, 0.5, Rotation.new(45, 45, 45), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("lockstone", ObjID.PUZZLE_ITEM16, 0, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("puzzle15", ObjID.PUZZLE_ITEM15, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("mirror_seal", ObjID.PUZZLE_ITEM15_COMBO1, 0, 0.5, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE),
InventoryItem.new("mirror_gem", ObjID.PUZZLE_ITEM15_COMBO2, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE),

-------SOULS------
InventoryItem.new("fragment2", ObjID.PICKUP_ITEM13, 0, 0.7, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.COMBINE);

}

Flow.AddLevel(Ygiroth)

	The_Enchanted_Woods = Level.new()

The_Enchanted_Woods.nameKey = "The_Enchanted_Woods"
The_Enchanted_Woods.scriptFile = "Scripts\\The_Enchanted_Woods.lua"
The_Enchanted_Woods.ambientTrack = "122"
The_Enchanted_Woods.horizon = true
The_Enchanted_Woods.levelFile = "Data\\The_Enchanted_Woods.ten"
The_Enchanted_Woods.loadScreenFile = "Screens\\inganok.jpg"
The_Enchanted_Woods.objects = {

----------KEYS AND PUZZLES---------

InventoryItem.new("level5key_item1", ObjID.KEY_ITEM1, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("level5key_item2", ObjID.KEY_ITEM2, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("level5key_item3", ObjID.KEY_ITEM3, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("level5key_item4", ObjID.KEY_ITEM4, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),

-------SECRETS------
InventoryItem.new("secret1", ObjID.PICKUP_ITEM14, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("secret2", ObjID.PICKUP_ITEM15, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("secret3", ObjID.PICKUP_ITEM16, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),

-------DEFAULT ITEMS------

InventoryItem.new("small_medipack", ObjID.SMALLMEDI_ITEM, 40, 0.7, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("large_medipack", ObjID.BIGMEDI_ITEM, 38, 0.6, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("flares", ObjID.FLARE_INV_ITEM, 0, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),


    -------OTHERS------
InventoryItem.new("pickup1", ObjID.PICKUP_ITEM1, 0, 0.5, Rotation.new(45, 45, 45), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("lockstone", ObjID.PUZZLE_ITEM16, 0, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("puzzle15", ObjID.PUZZLE_ITEM15, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("mirror_seal", ObjID.PUZZLE_ITEM15_COMBO1, 0, 0.5, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE),
InventoryItem.new("mirror_gem", ObjID.PUZZLE_ITEM15_COMBO2, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE);

-------SOULS------
InventoryItem.new("fragment3", ObjID.PICKUP_ITEM13, 0, 0.7, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.COMBINE);

}
Flow.AddLevel(The_Enchanted_Woods)



	The_Ruins_of_Oriab = Level.new()

The_Ruins_of_Oriab.nameKey = "The_Ruins_of_Oriab"
The_Ruins_of_Oriab.scriptFile = "Scripts\\The_Ruins_of_Oriab.lua"
The_Ruins_of_Oriab.ambientTrack = "109"
The_Ruins_of_Oriab.horizon = true
The_Ruins_of_Oriab.levelFile = "Data\\The_Ruins_of_Oriab.ten"
The_Ruins_of_Oriab.loadScreenFile = "Screens\\oriab.jpg"
The_Ruins_of_Oriab.objects = {

----------KEYS AND PUZZLES---------

InventoryItem.new("level6key_item1", ObjID.KEY_ITEM1, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("level6key_item2", ObjID.KEY_ITEM2, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("level6key_item3", ObjID.KEY_ITEM3, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("level6key_item12", ObjID.KEY_ITEM12, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),

-------SECRETS------
InventoryItem.new("secret1", ObjID.PICKUP_ITEM14, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("secret2", ObjID.PICKUP_ITEM15, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("secret3", ObjID.PICKUP_ITEM16, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),

-------DEFAULT ITEMS------

InventoryItem.new("small_medipack", ObjID.SMALLMEDI_ITEM, 40, 0.7, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("large_medipack", ObjID.BIGMEDI_ITEM, 38, 0.6, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("flares", ObjID.FLARE_INV_ITEM, 0, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),


    -------OTHERS------
InventoryItem.new("pickup1", ObjID.PICKUP_ITEM1, 0, 0.5, Rotation.new(45, 45, 45), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("lockstone", ObjID.PUZZLE_ITEM16, 0, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("puzzle15", ObjID.PUZZLE_ITEM15, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("mirror_seal", ObjID.PUZZLE_ITEM15_COMBO1, 0, 0.5, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE),
InventoryItem.new("mirror_gem", ObjID.PUZZLE_ITEM15_COMBO2, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE);

-------SOULS------
InventoryItem.new("fragment3", ObjID.PICKUP_ITEM13, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE);
}

Flow.AddLevel(The_Ruins_of_Oriab)

	Tyrhhia = Level.new()

Tyrhhia.nameKey = "Tyrhhia"
Tyrhhia.scriptFile = "Scripts\\Tyrhhia.lua"
Tyrhhia.ambientTrack = "117"
Tyrhhia.horizon = true
Tyrhhia.levelFile = "Data\\Tyrhhia.ten"
Tyrhhia.loadScreenFile = "Screens\\tyrhhia.jpg"
Tyrhhia.objects = {

----------KEYS AND PUZZLES---------

InventoryItem.new("level7key_item1", ObjID.KEY_ITEM1, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("level7puzzle_item1", ObjID.PUZZLE_ITEM1, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("level7puzzle_item2", ObjID.PUZZLE_ITEM2, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),

-------SECRETS------
InventoryItem.new("secret1", ObjID.PICKUP_ITEM14, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("secret2", ObjID.PICKUP_ITEM15, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("secret3", ObjID.PICKUP_ITEM16, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),

-------DEFAULT ITEMS------

InventoryItem.new("small_medipack", ObjID.SMALLMEDI_ITEM, 40, 0.7, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("large_medipack", ObjID.BIGMEDI_ITEM, 38, 0.6, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("flares", ObjID.FLARE_INV_ITEM, 0, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),


    -------OTHERS------
InventoryItem.new("pickup1", ObjID.PICKUP_ITEM1, 0, 0.5, Rotation.new(45, 45, 45), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("lockstone", ObjID.PUZZLE_ITEM16, 0, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("puzzle15", ObjID.PUZZLE_ITEM15, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("mirror_seal", ObjID.PUZZLE_ITEM15_COMBO1, 0, 0.5, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE),
InventoryItem.new("mirror_gem", ObjID.PUZZLE_ITEM15_COMBO2, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE),

-------SOULS------
InventoryItem.new("fragment4", ObjID.PICKUP_ITEM13, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE);

}
Flow.AddLevel(Tyrhhia)



	River_Naraxa = Level.new()

River_Naraxa.nameKey = "River_Naraxa"
River_Naraxa.scriptFile = "Scripts\\River_Naraxa.lua"
River_Naraxa.ambientTrack = "117"
River_Naraxa.horizon = true
River_Naraxa.levelFile = "Data\\River_Naraxa.ten"
River_Naraxa.loadScreenFile = "Screens\\river.jpg"
River_Naraxa.objects = {

----------KEYS AND PUZZLES---------



-------SECRETS------
InventoryItem.new("secret1", ObjID.PICKUP_ITEM14, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("secret2", ObjID.PICKUP_ITEM15, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("secret3", ObjID.PICKUP_ITEM16, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),

-------DEFAULT ITEMS------

InventoryItem.new("small_medipack", ObjID.SMALLMEDI_ITEM, 40, 0.7, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("large_medipack", ObjID.BIGMEDI_ITEM, 38, 0.6, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("flares", ObjID.FLARE_INV_ITEM, 0, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),


    -------OTHERS------
InventoryItem.new("pickup1", ObjID.PICKUP_ITEM1, 0, 0.5, Rotation.new(45, 45, 45), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("lockstone", ObjID.PUZZLE_ITEM16, 0, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("puzzle15", ObjID.PUZZLE_ITEM15, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("mirror_seal", ObjID.PUZZLE_ITEM15_COMBO1, 0, 0.5, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE),
InventoryItem.new("mirror_gem", ObjID.PUZZLE_ITEM15_COMBO2, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE);



}

Flow.AddLevel(River_Naraxa)

	Celephais = Level.new()



Celephais.nameKey = "Celephais"
Celephais.scriptFile = "Scripts\\Celephais.lua"
Celephais.ambientTrack = "110"
Celephais.horizon = true
Celephais.farView = 900
Celephais.levelFile = "Data\\Celephais.ten"
Celephais.loadScreenFile = "Screens\\celephais.jpg"
Celephais.objects = {

----------KEYS AND PUZZLES---------

InventoryItem.new("level9key_item1", ObjID.KEY_ITEM1, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("level9key_item2", ObjID.KEY_ITEM2, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("level9key_item3", ObjID.KEY_ITEM3, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("level9key_item5", ObjID.KEY_ITEM5, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("level9key_item6", ObjID.KEY_ITEM6, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("level9key_item8", ObjID.KEY_ITEM8, 40, 0.5, Rotation.new(90, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("level9puzzle_item1", ObjID.PUZZLE_ITEM1, 40, 0.5, Rotation.new(90, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("level9puzzle_item3", ObjID.PUZZLE_ITEM3, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),

-------SECRETS------
InventoryItem.new("secret1", ObjID.PICKUP_ITEM14, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("secret2", ObjID.PICKUP_ITEM15, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("secret3", ObjID.PICKUP_ITEM16, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),

-------DEFAULT ITEMS------

InventoryItem.new("small_medipack", ObjID.SMALLMEDI_ITEM, 40, 0.7, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("large_medipack", ObjID.BIGMEDI_ITEM, 38, 0.6, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("flares", ObjID.FLARE_INV_ITEM, 0, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),


    -------OTHERS------
InventoryItem.new("pickup1", ObjID.PICKUP_ITEM1, 0, 0.5, Rotation.new(45, 45, 45), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("lockstone", ObjID.PUZZLE_ITEM16, 0, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("puzzle15", ObjID.PUZZLE_ITEM15, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("mirror_seal", ObjID.PUZZLE_ITEM15_COMBO1, 0, 0.5, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE),
InventoryItem.new("mirror_gem", ObjID.PUZZLE_ITEM15_COMBO2, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE);

}

Flow.AddLevel(Celephais)
Celephais.farView = 200


	The_Palace_of_Kuranes = Level.new()

The_Palace_of_Kuranes.nameKey = "The_Palace_of_Kuranes"
The_Palace_of_Kuranes.scriptFile = "Scripts\\The_Palace_of_Kuranes.lua"
The_Palace_of_Kuranes.ambientTrack = "119"
The_Palace_of_Kuranes.horizon = true
The_Palace_of_Kuranes.levelFile = "Data\\The_Palace_of_Kuranes.ten"
The_Palace_of_Kuranes.loadScreenFile = "Screens\\serannian.jpg"
The_Palace_of_Kuranes.farView = 900
The_Palace_of_Kuranes.objects = {

----------KEYS AND PUZZLES---------



-------SECRETS------
InventoryItem.new("secret1", ObjID.PICKUP_ITEM14, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("secret2", ObjID.PICKUP_ITEM15, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("secret3", ObjID.PICKUP_ITEM16, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),

-------DEFAULT ITEMS------

InventoryItem.new("small_medipack", ObjID.SMALLMEDI_ITEM, 40, 0.7, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("large_medipack", ObjID.BIGMEDI_ITEM, 38, 0.6, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("flares", ObjID.FLARE_INV_ITEM, 0, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),


    -------OTHERS------
InventoryItem.new("pickup1", ObjID.PICKUP_ITEM1, 0, 0.5, Rotation.new(45, 45, 45), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("lockstone", ObjID.PUZZLE_ITEM16, 0, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("puzzle15", ObjID.PUZZLE_ITEM15, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("mirror_seal", ObjID.PUZZLE_ITEM15_COMBO1, 0, 0.5, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE),
InventoryItem.new("mirror_gem", ObjID.PUZZLE_ITEM15_COMBO2, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE);

-------SOULS------
InventoryItem.new("fragment5", ObjID.PICKUP_ITEM13, 0, 0.7, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.COMBINE);

}

Flow.AddLevel(The_Palace_of_Kuranes)

	The_Wastelands = Level.new()

The_Wastelands.nameKey = "The_Wastelands"
The_Wastelands.scriptFile = "Scripts\\The_Wastelands.lua"
The_Wastelands.ambientTrack = "129"
The_Wastelands.horizon = true
The_Wastelands.levelFile = "Data\\The_Wastelands.ten"
The_Wastelands.loadScreenFile = "Screens\\wastelands.jpg"
The_Wastelands.objects = {

----------KEYS AND PUZZLES---------



-------SECRETS------
InventoryItem.new("secret1", ObjID.PICKUP_ITEM14, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("secret2", ObjID.PICKUP_ITEM15, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("secret3", ObjID.PICKUP_ITEM16, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),

-------DEFAULT ITEMS------

InventoryItem.new("small_medipack", ObjID.SMALLMEDI_ITEM, 40, 0.7, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("large_medipack", ObjID.BIGMEDI_ITEM, 38, 0.6, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("flares", ObjID.FLARE_INV_ITEM, 0, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),


    -------OTHERS------
InventoryItem.new("pickup1", ObjID.PICKUP_ITEM1, 0, 0.5, Rotation.new(45, 45, 45), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("lockstone", ObjID.PUZZLE_ITEM16, 0, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("puzzle15", ObjID.PUZZLE_ITEM15, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("mirror_seal", ObjID.PUZZLE_ITEM15_COMBO1, 0, 0.5, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE),
InventoryItem.new("mirror_gem", ObjID.PUZZLE_ITEM15_COMBO2, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE);

}


Flow.AddLevel(The_Wastelands)

	Zakarion = Level.new()

Zakarion.nameKey = "Zakarion"
Zakarion.scriptFile = "Scripts\\Zakarion.lua"
Zakarion.ambientTrack = "130"
Zakarion.horizon = true
Zakarion.levelFile = "Data\\Zakarion.ten"
Zakarion.loadScreenFile = "Screens\\zakarion.jpg"

Zakarion.objects = {



----------KEYS AND PUZZLES---------

InventoryItem.new("level12puzzle_item10", ObjID.PUZZLE_ITEM10, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("level12puzzle_item2", ObjID.PUZZLE_ITEM2, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),

-------SECRETS------
InventoryItem.new("secret1", ObjID.PICKUP_ITEM14, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("secret2", ObjID.PICKUP_ITEM15, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("secret3", ObjID.PICKUP_ITEM16, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),

-------DEFAULT ITEMS------

InventoryItem.new("small_medipack", ObjID.SMALLMEDI_ITEM, 40, 0.7, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("large_medipack", ObjID.BIGMEDI_ITEM, 38, 0.6, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("flares", ObjID.FLARE_INV_ITEM, 0, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),


    -------OTHERS------
InventoryItem.new("pickup1", ObjID.PICKUP_ITEM1, 0, 0.5, Rotation.new(45, 45, 45), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("lockstone", ObjID.PUZZLE_ITEM16, 0, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("puzzle15", ObjID.PUZZLE_ITEM15, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("mirror_seal", ObjID.PUZZLE_ITEM15_COMBO1, 0, 0.5, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE),
InventoryItem.new("mirror_gem", ObjID.PUZZLE_ITEM15_COMBO2, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE);

}

Flow.AddLevel(Zakarion)

	Mysteries_of_Thorabon = Level.new()

Mysteries_of_Thorabon.nameKey = "Mysteries_of_Thorabon"
Mysteries_of_Thorabon.scriptFile = "Scripts\\Mysteries_of_Thorabon.lua"
Mysteries_of_Thorabon.ambientTrack = "105"
Mysteries_of_Thorabon.horizon = true
Mysteries_of_Thorabon.layer1 = Flow.SkyLayer.new(Color.new(50, 50, 52), 45)
Mysteries_of_Thorabon.layer2 = Flow.SkyLayer.new(Color.new(30, 30, 50), 60)
Mysteries_of_Thorabon.levelFile = "Data\\Mysteries_of_Thorabon.ten"
Mysteries_of_Thorabon.loadScreenFile = "Screens\\thorabon.jpg"
Mysteries_of_Thorabon.objects = {

----------KEYS AND PUZZLES---------

InventoryItem.new("level13key_item1", ObjID.KEY_ITEM1, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("level13puzzle_item1", ObjID.PUZZLE_ITEM1, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("level13puzzle_item2", ObjID.PUZZLE_ITEM2, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),

-------SECRETS------
InventoryItem.new("secret1", ObjID.PICKUP_ITEM14, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("secret2", ObjID.PICKUP_ITEM15, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("secret3", ObjID.PICKUP_ITEM16, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),

-------DEFAULT ITEMS------

InventoryItem.new("small_medipack", ObjID.SMALLMEDI_ITEM, 40, 0.7, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("large_medipack", ObjID.BIGMEDI_ITEM, 38, 0.6, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("flares", ObjID.FLARE_INV_ITEM, 0, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),


    -------OTHERS------
InventoryItem.new("pickup1", ObjID.PICKUP_ITEM1, 0, 0.5, Rotation.new(45, 45, 45), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("lockstone", ObjID.PUZZLE_ITEM16, 0, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("puzzle15", ObjID.PUZZLE_ITEM15, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("mirror_seal", ObjID.PUZZLE_ITEM15_COMBO1, 0, 0.5, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE),
InventoryItem.new("mirror_gem", ObjID.PUZZLE_ITEM15_COMBO2, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE);

}



Flow.AddLevel(Mysteries_of_Thorabon)

	The_Gardens_of_Yin = Level.new()
The_Gardens_of_Yin.farView = 900
The_Gardens_of_Yin.nameKey = "The_Gardens_of_Yin"
The_Gardens_of_Yin.scriptFile = "Scripts\\The_Gardens_of_Yin.lua"
The_Gardens_of_Yin.ambientTrack = "106"
The_Gardens_of_Yin.horizon = true
The_Gardens_of_Yin.layer1 = Flow.SkyLayer.new(Color.new(197, 148, 33), 45)
The_Gardens_of_Yin.layer2 = Flow.SkyLayer.new(Color.new(236, 207, 140), 60)
The_Gardens_of_Yin.levelFile = "Data\\The_Gardens_of_Yin.ten"
The_Gardens_of_Yin.loadScreenFile = "Screens\\gardens.jpg"
The_Gardens_of_Yin.objects = {

----------KEYS AND PUZZLES---------

InventoryItem.new("level14key_item1", ObjID.KEY_ITEM1, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("level14puzzle_item1", ObjID.PUZZLE_ITEM1, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("level14puzzle_item2", ObjID.PUZZLE_ITEM2, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),

-------SECRETS------
InventoryItem.new("secret1", ObjID.PICKUP_ITEM14, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("secret2", ObjID.PICKUP_ITEM15, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("secret3", ObjID.PICKUP_ITEM16, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),

-------DEFAULT ITEMS------

InventoryItem.new("small_medipack", ObjID.SMALLMEDI_ITEM, 40, 0.7, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("large_medipack", ObjID.BIGMEDI_ITEM, 38, 0.6, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("flares", ObjID.FLARE_INV_ITEM, 0, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),

    -------OTHERS------
InventoryItem.new("pickup1", ObjID.PICKUP_ITEM1, 0, 0.5, Rotation.new(45, 45, 45), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("lockstone", ObjID.PUZZLE_ITEM16, 0, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("puzzle15", ObjID.PUZZLE_ITEM15, 0, 0.5, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("mirror_seal", ObjID.PUZZLE_ITEM15_COMBO1, 0, 0.5, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE),
InventoryItem.new("mirror_gem", ObjID.PUZZLE_ITEM15_COMBO2, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE);



}

Flow.AddLevel(The_Gardens_of_Yin)

	Ex_Oblivione = Level.new()

Ex_Oblivione.nameKey = "Ex_Oblivione"
Ex_Oblivione.scriptFile = "Scripts\\Ex_Oblivione.lua"
Ex_Oblivione.ambientTrack = "106"
Ex_Oblivione.horizon = true
Ex_Oblivione.levelFile = "Data\\Ex_Oblivione.ten"
Ex_Oblivione.loadScreenFile = "Screens\\finale.jpg"
Ex_Oblivione.objects = {


----------KEYS AND PUZZLES---------



-------SECRETS------
InventoryItem.new("secret1", ObjID.PICKUP_ITEM14, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("secret2", ObjID.PICKUP_ITEM15, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("secret3", ObjID.PICKUP_ITEM16, 40, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),

-------DEFAULT ITEMS------

InventoryItem.new("small_medipack", ObjID.SMALLMEDI_ITEM, 40, 0.7, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("large_medipack", ObjID.BIGMEDI_ITEM, 38, 0.6, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("flares", ObjID.FLARE_INV_ITEM, 0, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),


    -------OTHERS------
InventoryItem.new("pickup1", ObjID.PICKUP_ITEM1, 0, 0.5, Rotation.new(45, 45, 45), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("lockstone", ObjID.PUZZLE_ITEM16, 0, 0.5, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("puzzle15", ObjID.PUZZLE_ITEM15, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.USE),
InventoryItem.new("mirror_seal", ObjID.PUZZLE_ITEM15_COMBO1, 0, 0.5, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE),
InventoryItem.new("mirror_gem", ObjID.PUZZLE_ITEM15_COMBO2, 0, 0.7, Rotation.new(90, 0, 90), RotationAxis.Y, 0, ItemAction.COMBINE);

-------SOULS------
InventoryItem.new("fragment6", ObjID.PICKUP_ITEM13, 0, 0.7, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.COMBINE);

}

Flow.AddLevel(Ex_Oblivione)







