--[[
NOTE: It's possible to expand string entry tables with extra language variations
corresponding to languages in the table at the end of this file.
--]]

local strings =
{
	actions_accelerate = { "Accelerate" },
	actions_reverse = { "Reverse" },
	actions_speed = { "Speed" },
	actions_slow = { "Slow" },
	actions_brake = { "Brake/Dismount" },
	actions_fire = { "Fire" },
	actions_action = { "Action" },
	actions_sprint = { "Sprint" },
	actions_draw = { "Draw" },
	actions_crouch = { "Crouch" },
	actions_inventory = { "Inventory" },
	actions_jump = { "Jump" },
	actions_look = { "Look" },
	actions_backward = { "Backward" },
	actions_forward = { "Forward" },
	actions_left = { "Left" },
	actions_right = { "Right" },
	actions_roll = { "Roll" },
	actions_step_left = { "Step Left" },
	actions_step_right = { "Step Right" },
	actions_pause = { "Pause" },
	actions_walk = { "Walk" },
	actions_save = { "Save" },
	actions_load = { "Load" },
	actions_select = { "Select" },
	actions_deselect = { "Deselect" },
	actions_large_medipack = { "Large Medipack" },
	actions_flare = { "Flare" },
	actions_next_weapon = { "Next Weapon" },
	actions_previous_weapon = { "Previous Weapon" },
	actions_small_medipack = { "Small Medipack" },
	actions_weapon_1 = { "Weapon 1" },
	actions_weapon_2 = { "Weapon 2" },
	actions_weapon_3 = { "Weapon 3" },
	actions_weapon_4 = { "Weapon 4" },
	actions_weapon_5 = { "Weapon 5" },
	actions_weapon_6 = { "Weapon 6" },
	actions_weapon_7 = { "Weapon 7" },
	actions_weapon_8 = { "Weapon 8" },
	actions_weapon_9 = { "Weapon 9" },
	actions_weapon_10 = { "Weapon 10" },
	window_title = { "TombEngine" },
	all = { "All" },
	apply = { "Apply" },
	auto_target = { "Automatic Targeting" },
	back = { "Back" },
	binoculars = { "Binoculars" },
	close = { "Close" },
	cancel = { "Cancel" },
	caustics = { "Underwater Caustics" },
	choose_ammo = { "Choose Ammo" },
	choose_weapon = { "Choose Weapon" },
	combine = { "Combine" },
	combine_with = { "Combine With" },
	controls = { "Controls" },
	reset_to_defaults = { "Reset to Defaults" },
	crossbow = { "Crossbow" },
	crossbow_normal_ammo = { "Crossbow Normal Ammo" },
	crossbow_poison_ammo = { "Crossbow Poison Ammo" },
	crossbow_explosive_ammo = { "Crossbow Explosive Ammo" },
	crossbow_lasersight = { "Crossbow + Lasersight" },
	crowbar = { "Crowbar" },
	diary = { "Al Azif - Necronomicon" },
	disabled = { "Disabled" },
	display = { "Display Settings" },
	display_adapter = { "Display Adapter" },
	distance_travelled = { "Distance Travelled" },
	enable_sound = { "Enable Sounds" },
	enabled = { "Enabled" },
	equip = { "Equip" },
	examine = { "Examine" },
	exit_game = { "Exit Game" },
	exit_to_title = { "Exit to Title" },
	flares = { "Flares" },
	general_actions = { "General Actions"},
	grenade_launcher = { "Grenade Launcher" },
	grenade_launcher_normal_ammo = { "Grenade Launcher Normal Ammo" },
	grenade_launcher_super_ammo = { "Grenade Launcher Super Ammo" },
	grenade_launcher_flash_ammo = { "Grenade Launcher Flash Ammo" },
	harpoon_gun = { "Harpoon Gun" },
	harpoon_gun_ammo = { "Harpoon Gun Ammo" },
	headset = { "Headset" },
	hk = { "MP5" },
	hk_ammo = { "MP5 Ammo" },
	hk_burst_mode = { "Burst Mode" },
	hk_rapid_mode = { "Rapid Mode" },
	hk_lasersight = { "MP5 + Lasersight" },
	hk_sniper_mode = { "Sniper Mode" },
	lara_home = { "Lara's Home" },
	large_medipack = { "Radiant Life Potion" },
	lasersight = { "Lasersight" },
	menu_actions = { "Menu Actions" },
	music_volume = { "Music Volume" },
	new_game = { "New Game" },
	none = { "None" },
	ok = { "OK" },
	options = { "Options" },
	other_settings = { "Sound and Gameplay" },
	output_settings = { "Output Settings" },
	passport = { "Passport" },
	pistol_ammo = { "Pistol Ammo" },
	pistols = { "Pistols" },
	player = { "Player" },
	render_options = { "Render Options" },
	reverb = { "Reverb" },
	revolver = { "Desert Eagle" },
	revolver_ammo = { "Desert Eagle Ammo" },
	revolver_lasersight = { "Desert Eagle + Lasersight" },
	rocket_launcher_ammo = { "Rocket Launcher Ammo" },
	rocket_launcher = { "Rocket Launcher" },
	rumble = { "Rumble" },
	subtitles = { "Subtitles" },
	save_game = { "Save Game" },
	savegame_timestamp = { "%02d Days %02d:%02d:%02d" },
	screen_resolution = { "Screen Resolution" },
	level_secrets_found = { "Secrets Found in Level" },
	total_secrets_found = { "Secrets Found Total" },
	select_level = { "Select Level" },
	separate = { "Separate" },
	sfx_volume = { "SFX Volume" },
	shadows = { "Shadows" },
	shotgun = { "Shotgun" },
	shotgun_normal_ammo = { "Shotgun Normal Ammo" },
	shotgun_wideshot_ammo = { "Shotgun Wideshot Ammo" },
	small_medipack = { "Life Potion" },
	sound = { "Sound" },
	silencer = { "Silencer" },
	view = { "View" },
	thumbstick_camera = { "Thumbstick Camera" },
	time_taken = { "Time Taken" },
	statistics = { "Statistics" },
	torch = { "Torch" },
	empty = { "Empty" },
	use = { "Use" },
	ammo_used = { "Ammo Used" },
	used_medipacks = { "Life Potions Used" },
	uzi_ammo = { "Uzi Ammo" },
	uzis = { "Uzis" },
	volumetric_fog = { "Volumetric Fog" },
	antialiasing = { "Antialiasing" },
	low = { "Low" },
	medium = { "Medium" },
	high = { "High" },
	waiting_for_input = { "Waiting For Input" },
	windowed = { "Windowed" },
	load_game = { "Load Game" },
	quick_actions = { "Quick Actions" },
	vehicle_actions = { "Vehicle Actions" },
	test_level = { "Test Level" },
	waterskin_small_empty = { "Small Waterskin (Empty)" },
	waterskin_small_1l = { "Small Waterskin (1L)" },
	waterskin_small_2l = { "Small Waterskin (2L)" },
	waterskin_small_3l = { "Small Waterskin (3L)" },
	waterskin_large_empty = { "Large Waterskin (Empty)" },
	waterskin_large_1l = { "Large Waterskin (1L)" },
	waterskin_large_2l = { "Large Waterskin (2L)" },
	waterskin_large_3l = { "Large Waterskin (3L)" },
	waterskin_large_4l = { "Large Waterskin (4L)" },
	waterskin_large_5l = { "Large Waterskin (5L)" },
	torch2 = { "Torch 2" },
	mechanical_scarab = { "Mechanical Scarab With Winding Key" },
	mechanical_scarab_1 = { "Mechanical Scarab (No Winding Key)" },
	mechanical_scarab_2 = { "Mechanical Scarab Winding Key" },
	-- Level Strings
	title = { "Title" },
	test_level = { "Prologue" },
	Prologue = { "Prologue: The Nameless City" },
	The_Cold_Waste = { "The Cold Waste" },
	Sarkomand = { "Sarkomand" },
	Ygiroth = { "Ygiroth" },
	Return_to_Inganok = { "The Enchanted Woods" },
	The_Ruins_of_Oriab = { "Oriab - Port of Baharna" },
	River_Naraxa = { "River Naraxa" },
	Celephais = { "Celephais" },
	The_Courtyard = { "The Courtyard" },
	The_Palace_of_Kuranes = { "Serannian - The Sky City" },
	The_Wastelands = { "The Wastelands" },
	Zakarion = { "Zakarion" },
	Mysteries_of_Thorabon = { "Fortress of Thorabon" },
	The_Gardens_of_Yin = { "The Gardens of Yin" },
	Ex_Oblivione = { "Golden Valley - Finale" },
	Tyrhhia = { "Tyrhhia" },
	The_Enchanted_Woods = { "The Enchanted Woods" },
	
--------------------- Item strings -----------------------

-- Cold Waste

	level2key_item1 = { "River Gateway Key" },
	level2key_item2 = { "Red Key" },

-- Sarkomand

	level3key_item1 = { "Golden Key" },
	level3key_item2 = { "Tower Key" },
	level3key_item5 = { "Dynamite Detonator" },
	level3puzzle_item1 = { "Lunar Ruby" },

-- Ygiroth

	level4key_item2 = { "Sanctuary Key" },
	level4key_item3 = { "Stairway Key" },
	level4key_item4 = { "Passage Key" },
	level4puzzle_item3 = { "Blue Gem" },

-- Enchanted Woods

	level5key_item1 = { "Minor Chapel Key" },
	level5key_item2 = { "Courtyard Key" },
	level5key_item3 = { "Storage Key" },
	level5key_item4 = { "Garden Key" },

-- Oriab

	level6key_item1 = { "Library Key" },
	level6key_item2 = { "Outdoors Gate Key" },
	level6key_item3 = { "House Key" },
	level6key_item12 = { "Yard Key" },

-- Tyrhhia

	level7key_item1 = { "Hut Key" },
	level7puzzle_item1 = { "Lotus Sphere" },
	level7puzzle_item2 = { "Incense" },

-- Celephais

	level9key_item1 = { "Long Key" },
	level9key_item2 = { "Lower Church Key" },
	level9key_item3 = { "Archives Key" },
	level9key_item5 = { "Courtyard Key" },
	level9key_item6 = { "Infinite Building Key" },
	level9key_item8 = { "Party Access Card" },
	level9puzzle_item1 = { "Mechanism Cogwheel" },
	level9puzzle_item3 = { "Idol" },

-- Zakarion

	level12puzzle_item10 = { "Ruby Rose" },
	level12puzzle_item2 = { "Silver Rose" },

-- Thorabon

	level13key_item1 = { "Golden Key" },
	level13puzzle_item1 = { "Divine Ruby" },
	level13puzzle_item2 = { "Golden Medal" },
	
	
-- Yin

	level14key_item1 = { "Blue Key" },
	level14puzzle_item1 = { "Golden Figurine"},
	level14puzzle_item2 = { "Golden Deity"},

-- Souls

	fragment1 = { "Birdmonster Fragment" },
	fragment2 = { "Fragment of the High-Priest" },
	fragment3 = { "Fragment of the Guardian Statue" },
	fragment4 = { "Fragment of the Black Princess" },
	fragment5 = { "Fragment of Kuranes" },
	fragment6 = { "Fragment of the Crawling Chaos" },

-- Various

	mirror_gem = { "Mirror Gem" },
	mirror_seal = { "Mirror Seal" },
	lockstone = { "Pnakotic Lockstone" },
	secret1 = { "Silver Dragon" },
	secret2 = { "Emerald Dragon" },
	secret3 = { "Golden Dragon" },
	puzzle15 = { "Mirror of Dreams" },
	pickup1 = { "Al-Azif Necronomicon" },
	puzzle15 = { "Mirror of Dreams" },
	puzzle14 = { "Papyrus of the Dream Sages" }

}

TEN.Flow.SetStrings(strings)

local languages =
{
	"English",
	"Italian",
	"German",
	"French",
	"Dutch",
	"Spanish",
	"Japanese",
	"Russian"
}

TEN.Flow.SetLanguageNames(languages)

