-- Place in this Lua script all the levels of your game
-- Title is mandatory and must be the first level.

-- Intro image is a splash screen which appears before actual loading screen.
-- If you don't want it to appear, just remove this line.

Flow.SetIntroImagePath("Screens\\logopart2.png")

-- Intro video plays right after or instead of intro image, if specified.
-- If you don't want it to appear, just remove this line.

Flow.SetIntroVideoPath("Fmv\\intro.mp4")

-- Set overall amount of secrets in game.
-- If set to 0, secrets won't be displayed in statistics.

Flow.SetTotalSecretCount(4)

-- Enable/Disable Point Filter (square, unsmoothed pixels).

Flow.EnablePointFilter(false)

-- Enable/Disable saving and loading of savegames.

Flow.EnableLoadSave(true)

-- Disable/enable flycheat globally

Flow.EnableFlyCheat(true)

-- Disable/enable Lara drawing in title level

Flow.EnableLaraInTitle(false)

-- Disable/enable level selection in title level

Flow.EnableLevelSelect(false)

-- Disable/enable mass pickup (collect all pickups at once)

Flow.EnableMassPickup(true)

--------------------------------------------------

-- Title level

title = Level.new()

title.ambientTrack = "108"
title.levelFile = "Data\\title.ten"
title.scriptFile = "Scripts\\Levels\\title.lua"
title.loadScreenFile = "Screens\\logopart2.png"

Flow.AddLevel(title)

--------------------------------------------------
-- Boss level

Boss = TEN.Flow.Level()

Boss.nameKey = "The Lost City of Topaz"
Boss.scriptFile = "Scripts\\Levels\\Boss.lua"
Boss.ambientTrack = "108"
Boss.horizon1.enabled = true
Boss.levelFile = "Data\\Boss.ten"
Boss.loadScreenFile = "Screens\\a1.jpg"

Boss.objects = {
    InventoryItem("PuzzleItem2", ObjID.PUZZLE_ITEM2,
                  0,            -- yOffset (0 va benissimo per iniziare)
                  0.7,          -- scale (0.6–0.9 tipico)
                  Rotation.new(0, 0, 0),
                  RotationAxis.Y,
                  -1,           -- meshBits (non usato)
                  ItemAction.USE),
     InventoryItem("PuzzleItem1", ObjID.PUZZLE_ITEM1,
                  0,            -- yOffset (0 va benissimo per iniziare)
                  0.7,          -- scale (0.6–0.9 tipico)
                  Rotation.new(0, 0, 0),
                  RotationAxis.Y,
                  -1,           -- meshBits (non usato)
                  ItemAction.USE),
     InventoryItem("Seraph", ObjID.PUZZLE_ITEM4,
                  0,            -- yOffset (0 va benissimo per iniziare)
                  0.7,          -- scale (0.6–0.9 tipico)
                  Rotation.new(0, 0, 0),
                  RotationAxis.Y,
                  -1,           -- meshBits (non usato)
                  ItemAction.USE);             
}

TEN.Flow.AddLevel(Boss)

--------------------------------------------------








--------------------------------------------------
