-- FILE: Scripts\Levels\Boss.lua

------------------------------------------------------------------------
-- FUOCHI posizioni e size


---------------------------------------------------------------------
-- FUOCHI in alto
    local pos_fire1 = Vec3(50176, 13184, 67584)
    local pos_fire2 = Vec3(55296, 13184, 67584)
    local pos_fire3 = Vec3(44544, 13184, 67584)

	    local sizell = 12
	    
	    
	    
-- FUOCO su tetto  altare  
    local pos_fire4 = Vec3(50176, 16768, 73216)  

	     local sizeff = 8

			 
			
-- FUOCHI in room1			
			
	 local pos_room1 = Vec3(3584, -2820, 5632)
	 local pos_room2 = Vec3(3584, -2824, 4608)
	 local pos_room3 = Vec3(3584, -2828, 3584)
	 local size_room = 4
	  
	 
	 
-- FUOCHI in room primo topazio			
			
	 local pos_room4 = Vec3(18944, -6848, 25088)
	 local pos_room5 = Vec3(16896, -6848, 25088)
	  
	 local size_room = 4
	  
	 
	 
-- FUOCHI in room secondo e terzo topazio			
			
	 local pos_room6 = Vec3(56832, 576, 36352)
	 local pos_room7 = Vec3(58880, 576, 36352)
	 local pos_room8 = Vec3(58880, 576, 40448)
	 local pos_room9 = Vec3(56832, 576, 40448)
	  
	 local size_room = 4
	  
	  
-- FUOCHI in room CENTAURO boss	
			
	 local pos_room10 = Vec3(18432, 15232, 57856)
	 local pos_room11 = Vec3(21504, 15232, 57856)
	  
	 local size_roomC = 7
	 -- fuochi corridoio
	 local pos_roomR1 = Vec3(23040, 18688, 50688)
	 local pos_roomR2 = Vec3(23040, 18688, 51712)
	 local pos_roomR3 = Vec3(23040, 18688, 52736)
	 local pos_roomR4 = Vec3(23040, 18688, 53760)
	 local pos_roomR5 = Vec3(23040, 18688, 54784)
	 local pos_roomR6 = Vec3(23040, 18688, 55808)
	 
	 local pos_roomL1 = Vec3(16896, 18688, 50688)
	 local pos_roomL2 = Vec3(16896, 18688, 51712)
	 local pos_roomL3 = Vec3(16896, 18688, 52736)
	 local pos_roomL4 = Vec3(16896, 18688, 53760)
	 local pos_roomL5 = Vec3(16896, 18688, 54784)
	 local pos_roomL6 = Vec3(16896, 18688, 55808)
	 
	 local size_roomCORR = 2
	 
-- FUOCHI ARENA MINOTAURO			


 
	 local pos_room12 = Vec3(17920, 256, 17920)
	 local pos_room13 = Vec3(17920, 256, 10752)
	 local pos_room14 = Vec3(10752, 256, 10752)
	 local pos_room15 = Vec3(10752, 256, 17408)
	 local pos_room16 = Vec3(12800, 256, 12800)
     local pos_room17 = Vec3(12800, 256, 15872)
     local pos_room18 = Vec3(15872, 256, 15872)
     local pos_room19 = Vec3(15872, 256, 12800)

	 local size_roomM = 4
	  
-- FUOCO pozza room altare	  
	local pos_fiamme = Vec3(53760, 22272, 64512)  
	local size_roomPA = 7
	
-- FUOCHI tomba Malachia

	 local pos_room20 = Vec3(59904, 28416, 83456)
--	 local pos_room21 = Vec3(62976, 28416, 83456)
--	 local pos_room22 = Vec3(62976, 28416, 80384)
	 local pos_room23 = Vec3(60928, 28416, 80384)
	 local pos_room24 = Vec3(60928, 27520, 78336)
	 local pos_room25 = Vec3(58880, 27520, 78336)
	 local size_roomMALA = 2
	 
	 local lara_tomba = true
	 
LevelFuncs.OnFuochiTombaMalachia = function()
	lara_tomba = true
	 
end
 
--------------------------------------------------------------------------------    
-- POSIZIONI nebbie pozze

local spots_pozze_nebbia = {
    Vec3(53760, 20736, 67072),
    Vec3(46592, 20736, 67072),
    Vec3(43520, 20864, 73216),
}

local timers = {}

-- Sprite ID morbido (scegli tu quello che ti piace: es. 10, 12, 18, 22, 31)
local SMOKE_SPRITE_ID = 1

local function spawnNebbia(pos)
    Effects.EmitFlow(
        pos,           
        Vec3(0, -8, 0),                  -- sale piano
        12,                              -- raggio emissione
        16.5,                             -- vita (secondi) delle particelle
        8,                               -- attrito
        600,                              -- size massimo
        Color(120, 40, 20, 255),          -- colore iniziale  
        Color(60, 20, 10, 0),            -- colore finale  
        Objects.ObjID.DEFAULT_SPRITES,
        SMOKE_SPRITE_ID
    )
    Effects.EmitFlow(
        pos,          
        Vec3(0, -8, 0),                  -- sale piano
        12,                              -- raggio emissione
        16.5,                             -- vita (secondi) delle particelle
        8,                               -- attrito
        600,                              -- size massimo
        Color(128, 0, 0, 255),          -- colore iniziale  
        Color(69, 5, 18, 0),            -- colore finale  
        Objects.ObjID.DEFAULT_SPRITES,
        SMOKE_SPRITE_ID
    )
end

-----------------------------------------------------------------------
-- BLOCCHI INVISIBILI static

local piastrella1
local piastrella2
local piastrella3

LevelFuncs.OnVisible = function()

	if piastrella1 then piastrella1:Enable() end
    if piastrella2 then piastrella2:Enable() end
    if piastrella3 then piastrella3:Enable() end

end

LevelFuncs.OnInvisible = function()

	if piastrella1 then piastrella1:Disable() end
    if piastrella2 then piastrella2:Disable() end
    if piastrella3 then piastrella3:Disable() end

end



-- ==== CONFIG UI GLOBALE (del file) ====
local BLINK_LIMIT   = 0.15   -- soglia in frazione di HP (0–1)
local ALPHA_SPEED   = 35     -- opzionale: stessa velocità di fade per tutte


-- === CONFIG ===
local BOSS_NAME = "demigod1_2"   -- deve coincidere col Lua name in Tomb Editor
local START_HP  = 250           -- HP iniziali del boss

local BOSS_NAME2 = "centaur_mutant_81"   -- deve coincidere col Lua name in Tomb Editor
local START_HP2  = 400           -- HP iniziali del boss

local BOSS_NAME3 = "claw_mutant_126"   -- deve coincidere col Lua name in Tomb Editor
local START_HP3  = 350           -- HP iniziali del boss

local BOSS_NAME4 = "claw_mutant_127"   -- deve coincidere col Lua name in Tomb Editor
local START_HP4  = 350           -- HP iniziali del boss



 


-- helper
local function IsActorAlive(actor_name)
    local m = GetMoveableByName(actor_name)
    if not m or not m:GetValid() then return false end

    return m:GetStatus() == Objects.MoveableStatus.ACTIVE and m:GetHP() > 0
end
-- (GetStatus / MoveableStatus e GetHP sono nella API Moveable.) :contentReference[oaicite:1]{index=1}


-- === IMPORT barra HP ===
local ok, CustomBar = pcall(require, "CustomBar")
if not ok then
    CustomBar = require("Engine.CustomBar") -- fallback se il progetto la tiene in /Engine
end

--------------------------------------------------------------------------------------------------------

-- ===== Ammo HUD universale con Shotgun dettagliato =====

local WEAPON_UI = {
    [Objects.WeaponType.PISTOLS]  = { label = "Pistols",  y = 50,  color = Color(255, 255,   0, 255) },
    [Objects.WeaponType.UZI]      = { label = "Uzi",      y = 70,  color = Color(  0, 200, 255, 255) },
    [Objects.WeaponType.SHOTGUN]  = { label = "Shotgun",  y = 90,  color = Color(255, 100, 100, 255) },
--    [Objects.WeaponType.REVOLVER] = { label = "Revolver", y = 110, color = Color(255, 180,  60, 255) },
}

 

 



--------------------------------------------------------------------------------------------------------
-- EARTHQUAKE
--------------------------------------------------------------------------------------------------------

-- usa Count call = 1 nelle chiamate dal node editor
intensityEQ = 400 
intensityEQsoft = 300

LevelFuncs.OnQuake = function()
    intensity = tonumber(intensityEQ)  
    Effects.MakeEarthquake(intensityEQ)
--    Sound.PlaySound(359)                 -- rumble SFX  
end
LevelFuncs.OnQuakeSound = function()  
    Sound.PlayAudioTrack("eql", Sound.SoundTrackType.ONESHOT)
end

LevelFuncs.OnQuakeSOFT = function()
    intensity = tonumber(intensityEQsoft)  
    Effects.MakeEarthquake(intensityEQsoft)
--    Sound.PlaySound(359)                 -- rumble SFX  
end
LevelFuncs.OnQuakeSoundSOFT = function()  
    Sound.PlayAudioTrack("eqs", Sound.SoundTrackType.ONESHOT)
end
 

---------------------------------------------------------------------------------------------------------




------------------------------------------------------------------------------



--
-- --------------------
-- ==== SOUNDTRACK ====
-- --------------------
-- I file audio vanno nella cartella Engine/Audio del progetto, salvati in formato ogg.

-- Array di flags per la soundtrack del livello
-- Un flag per ogni brano, da cambiare da false a true dopo che il brano è estato eseguito, per evitare
-- che il brano riparta se si ripassa nel volume
-- Stato persistente per le musiche "suona-una-volta"
MusicOnce = MusicOnce or {}
local function PlayOnce(track_name, loop, key)
    key = key or track_name
    if MusicOnce[key] then return end
    local tt = loop and Sound.SoundTrackType.LOOPED or Sound.SoundTrackType.ONESHOT
    Sound.PlayAudioTrack(track_name, tt)
    MusicOnce[key] = true
end


 

LevelFuncs.OnMusicEPIC34 = function()
     PlayOnce("epic34_2", false, "EPIC34")
end


LevelFuncs.OnMusicDRUMS = function()
    PlayOnce("drums", false, "DRUMS")
end
 
 

 
LevelFuncs.OnMusicVIOLIN = function()
    PlayOnce("violin", false, "VIOLIN")
end


LevelFuncs.OnMusicAIDAWN = function()
    PlayOnce("aidawn", false, "AIDAWN")
    
end


LevelFuncs.OnMusicAPOS = function()
    PlayOnce("apos", false, "APOS")
    
end

LevelFuncs.OnMusicAPOL = function()
    PlayOnce("apolong", false, "APOLONG")
    
end


LevelFuncs.OnMusicCAMERA1 = function()
--    if IsActorAlive("bat_246") then
        PlayOnce("percamerasu1", false, "CAMERA1")
--    end
end

LevelFuncs.OnMusicSTANZATOPAZIO = function()
--    if IsActorAlive("bat_252") then
        PlayOnce("letthemystery", false, "STANZATOPAZIO")
  --  end
end

LevelFuncs.OnMusicSTANZATOPAZIOexit = function()
    if IsActorAlive("bat_254") then
        PlayOnce("enchanted", false, "STANZATOPAZIOEXIT")
    end
end

LevelFuncs.OnMusicCAVERNADOPOMINO = function()
    if IsActorAlive("bat_255") then
        PlayOnce("dreamscape", false, "CAVERNADOPOMINO")
    end
end

LevelFuncs.OnMusicMYSTERY70 = function()
--    if IsActorAlive("bat_256") then
        PlayOnce("mystery70", false, "MYSTERY70")
  --  end
end

LevelFuncs.OnMusicDARKMYSTERY = function()
--    if IsActorAlive("bat_258") then
        PlayOnce("darkmystery", false, "DARKMYSTERY")
--    end
end


LevelFuncs.OnMusicSECRET3 = function()
  --  if IsActorAlive("bat_260") then
        PlayOnce("inspi", false, "SECRET3")
   -- end
end

LevelFuncs.OnMusicENTRATAMAIN = function()
 --   if IsActorAlive("bat_263") then
        PlayOnce("scaryhorror", false, "ENTRATAMAIN")
  --  end
end

LevelFuncs.OnMusicPORTEAPERTE = function()
--    if IsActorAlive("bat_267") then
        PlayOnce("scaryhorrormusic", false, "PORTEAPERTE")
--    end
end

LevelFuncs.OnMusicTOPOF = function()
--    if IsActorAlive("bat_270") then
        PlayOnce("unity30sec", false, "TOPOF")
  --  end
end

LevelFuncs.OnMusicBADDY = function()
    if IsActorAlive("baddy2_241") then
        PlayOnce("049", false, "BADDY")
    end
end



LevelFuncs.OnMusicPIZZICATOENERGY = function()
    PlayOnce("pizzicatoenergy", false, "PIZZICATOENERGY")
    
end


LevelFuncs.OnMusicPICKUP = function()
    PlayOnce("simplicity", false, "KEY055")
    
end


LevelFuncs.OnMusicNUOTATALUNGA = function()
    PlayOnce("nuotatalunga", false, "NUOTATALUNGA")
    
end


LevelFuncs.OnMusicCLAWMUTANTfinale = function()
    if IsActorAlive("claw_mutant_204") then
        PlayOnce("horrorfinale", false, "CLAWMUTANTfinale")
    end
end

LevelFuncs.OnMusicEPICGLITCH30 = function()
        if IsActorAlive("bat_294") then
        PlayOnce("epicglitch30", false, "EPICGLITCH30")
        end
end


LevelFuncs.OnMusicCENTAURBOSS = function()
    if IsActorAlive("centaur_mutant_81") then
        PlayOnce("heroestour", false, "CENTAURBOSS")
    end
end


LevelFuncs.OnMusicWINGEDMUMMY = function()
    if IsActorAlive("winged_mummy_82") then
        PlayOnce("scarysoundhorror", false, "WINGEDMUMMY")
    end
end


LevelFuncs.OnMusicMALA = function()
 --   if IsActorAlive("bat_280") then
        PlayOnce("unity1min", false, "MALA")
   -- end
end

 

---------------------------------------------------------------------------------------------------


-- Helper sicuro per mostrare/nascondere le barre senza errori a log
local function hide_bar_safe(name, hidden)
    if CustomBar and CustomBar.HideBar then
        CustomBar.HideBar(name, hidden)
    elseif CustomBar and CustomBar.SetBarHidden then
        -- fallback per build in cui l'API abbia nome diverso
        CustomBar.SetBarHidden(name, hidden)
    else
        -- no-op: niente log di errore
    end
end



-- === Handlers colpo boss (definite a livello file) ===
LevelFuncs.OnBossHit = function(hitObj)
    local hpBefore = hitObj:GetHP()
    hitObj:SetHP(math.max(0, hpBefore - 1))
    print(("[Boss.lua] OnHit -> HP: %d -> %d"):format(hpBefore, hitObj:GetHP()))
end




-- ====== PRIMO BOSS: minotauro ======


local lastHP = nil
local boss   = nil

-------------------------------------------------------------------



-- === VOLUME → MUSICA SE BOSS1 SPAWNED ===
-- Nota: questa sezione va dopo "local boss = nil" del Boss1

-- Ritorna true se il boss1 esiste già in scena e non è morto
-- Sostituisci la vecchia is_boss1_spawned_alive() con questa
local function is_boss1_spawned_alive()
    local b = TEN.Objects.GetMoveableByName(BOSS_NAME)
    if not b or (b.GetValid and not b:GetValid()) then return false end
    -- FIX principale: deve essere attivo (triggerato), non solo “esistente”
    if b.GetActive and not b:GetActive() then return false end
    -- Ulteriore guardia (facoltativa ma utile):
    if b.GetStatus and b:GetStatus() ~= TEN.Objects.MoveableStatus.ACTIVE then return false end
    local hp = (b.GetHP and b:GetHP()) or 0
    return hp > 0
end


-- Da collegare al volume (On Enter) nel Node Editor
LevelFuncs.OnVolume_Boss1_Music = function()
    if is_boss1_spawned_alive() then
        -- Usa la function che suona la musica 
         
        LevelFuncs.OnMusicAPOS()
         
    end
end



--------------------------------------------------------------------

-- === STATE & BARRIERA (solo barra, no death logic) ===
local bar_created  = false
local bar_shown    = false
local tile_ok_once = false  -- diventa true una volta e resta tale

local function update_bar_visibility()
    if bar_shown then return end
    if not CustomBar then return end

    boss = boss or TEN.Objects.GetMoveableByName(BOSS_NAME)
    if not boss then return end

    if tile_ok_once then
        if not bar_created then
            -- payload completo (come nel backup) + showBar=false per evitare flicker
            local bgPos  = TEN.Vec2(50, 92)
            local bgSize = TEN.Vec2(40, 3)
            local leftX  = bgPos.x - (bgSize.x / 2)

            CustomBar.CreateEnemyHpBar({
                barName      = "boss_hp",
                object       = BOSS_NAME,

                objectIdBg   = TEN.Objects.ObjID.DIARY_SPRITES,
                spriteIdBg   = 1,
                colorBg      = TEN.Color(0, 0, 0),
                posBg        = bgPos,
                rotBg        = 0,
                scaleBg      = bgSize,
                alignModeBg  = TEN.View.AlignMode.CENTER,
                scaleModeBg  = TEN.View.ScaleMode.STRETCH,
                blendModeBg  = TEN.Effects.BlendID.ALPHABLEND,

                objectIdBar  = TEN.Objects.ObjID.DIARY_SPRITES,
                spriteIdBar  = 1,
                colorBar     = TEN.Color(0, 160, 255),
                posBar       = TEN.Vec2(leftX, bgPos.y),
                rot          = 0,
                scaleBar     = TEN.Vec2(bgSize.x - 2, bgSize.y - 1),
                alignMode    = TEN.View.AlignMode.CENTER_LEFT,
                scaleMode    = TEN.View.ScaleMode.STRETCH,
                blendMode    = TEN.Effects.BlendID.ALPHABLEND,

                hideText     = true,
                alphaBlendSpeed = ALPHA_SPEED,
                blink        = true,
                blinkLimit   = BLINK_LIMIT,
                showBar      = false
            })
            bar_created = true
            print("[Boss.lua] Boss bar created (hidden).")
        end

--        if CustomBar.HideBar then
--            CustomBar.HideBar("boss_hp", false) -- mostra
--        end

        hide_bar_safe("boss_hp", false)


        bar_shown = true
        print("[Boss.lua] Boss bar shown.")
    end
end


-- chiamata dal volume SOLO all’ingresso della tile
LevelFuncs.OnBossTileEnter = function()
    tile_ok_once = true
    update_bar_visibility()
end


 

-- ====== SECONDO BOSS: stato ======
local lastHP2 = nil
local boss2   = nil

local bar_created2  = false
local bar_shown2    = false
local tile_ok_once2 = false


local function try_bind_boss2()
    if boss2 then return end
    boss2 = TEN.Objects.GetMoveableByName(BOSS_NAME2)
    if boss2 then
        if START_HP2 and START_HP2 > 0 then boss2:SetHP(START_HP2) end
        LevelFuncs.OnBoss2Hit = function(hitObj)
            local hpBefore = hitObj:GetHP()
            hitObj:SetHP(hpBefore - 1)
            print(("[Boss.lua] OnHit2 -> HP: %d -> %d"):format(hpBefore, hitObj:GetHP()))
        end
        boss2:SetOnHit(LevelFuncs.OnBossHit)
        lastHP2 = boss2:GetHP()
        print("[Boss.lua] Boss2 bind OK, HP:", lastHP2)
        if tile_ok_once2 then update_bar_visibility2() end
    end
end


-- ====== SECONDO BOSS: barra ======
local function update_bar_visibility2()

    local BLACK_BG  = TEN.Color(0, 0, 0)    -- bordo/incorniciatura
    local ORANGE_BAR = TEN.Color(255, 190, 30)  -- arancione brillante



    if bar_shown2 then return end
    if not CustomBar then return end

    boss2 = boss2 or TEN.Objects.GetMoveableByName(BOSS_NAME2)
    if not boss2 then return end

    if tile_ok_once2 then
        if not bar_created2 then
            -- posizione leggermente più in basso per non sovrapporsi alla prima
            local bgPos  = TEN.Vec2(50, 92)  
            local bgSize = TEN.Vec2(40, 3)
            local leftX  = bgPos.x - (bgSize.x / 2)

            CustomBar.CreateEnemyHpBar({
                barName      = "boss_hp2",
                object       = BOSS_NAME2,

                objectIdBg   = TEN.Objects.ObjID.DIARY_SPRITES,
                spriteIdBg   = 1,
                colorBg      = BLACK_BG,
                posBg        = bgPos,
                rotBg        = 0,
                scaleBg      = bgSize,
                alignModeBg  = TEN.View.AlignMode.CENTER,
                scaleModeBg  = TEN.View.ScaleMode.STRETCH,
                blendModeBg  = TEN.Effects.BlendID.ALPHABLEND,

                objectIdBar  = TEN.Objects.ObjID.DIARY_SPRITES,
                spriteIdBar  = 1,
                colorBar     = ORANGE_BAR,
                posBar       = TEN.Vec2(leftX, bgPos.y),
                rot          = 0,
                scaleBar     = TEN.Vec2(bgSize.x - 2, bgSize.y - 1),
                alignMode    = TEN.View.AlignMode.CENTER_LEFT,
                scaleMode    = TEN.View.ScaleMode.STRETCH,
                blendMode    = TEN.Effects.BlendID.ALPHABLEND,

                hideText     = true,
                alphaBlendSpeed = ALPHA_SPEED,
                blink        = true,
                blinkLimit   = BLINK_LIMIT,
                showBar      = false
            })
            bar_created2 = true
            print("[Boss.lua] Boss2 bar created (hidden).")
        end

--        if CustomBar.HideBar then
--            CustomBar.HideBar("boss_hp2", false)
--        end


         hide_bar_safe("boss_hp2", false)


        bar_shown2 = true
        print("[Boss.lua] Boss2 bar shown.")
    end
end

-- Evento volumetrico dedicato al secondo boss
LevelFuncs.OnBossTileEnter2 = function()
    tile_ok_once2 = true
    print("[Boss.lua] OnBossTileEnter2 fired")
    update_bar_visibility2()
end





-- UI positions (una sopra l’altra, visibili)
local UI_Y3 = 92
local UI_Y4 = 84

-- Colori (bordo nero + barra verde / rossa brillante)
local BLACK_BG    = TEN.Color(0, 0, 0)
local GREEN_BAR   = TEN.Color(30, 200, 80)   -- smeraldo
local BLUE_BAR     = TEN.Color(0, 128, 255)   

-- ====== BOSS 3: stato ======
local lastHP3, boss3 = nil, nil
local bar_created3, bar_shown3, tile_ok_once3 = false, false, false

-- ====== BOSS 4: stato ======
local lastHP4, boss4 = nil, nil
local bar_created4, bar_shown4, tile_ok_once4 = false, false, false


-- ====== BOSS 3: bootstrap barra (no show qui) ======
local function update_bar_visibility3()
    if not CustomBar then return end
    if bar_created3 then return end
    if not tile_ok_once3 then return end
    boss3 = boss3 or TEN.Objects.GetMoveableByName(BOSS_NAME3)
    if not boss3 then return end
    ensure_bar3()     -- crea la barra se manca (resta nascosta)
    -- NON toccare bar_shown3: il toggle contestuale in OnLoop gestisce show/hide
end

-- ====== BOSS 4: bootstrap barra (no show qui) ======
local function update_bar_visibility4()
    if not CustomBar then return end
    if bar_created4 then return end
    if not tile_ok_once4 then return end
    boss4 = boss4 or TEN.Objects.GetMoveableByName(BOSS_NAME4)
    if not boss4 then return end
    ensure_bar4()
    -- idem: niente show qui
end



local function try_bind_boss3()
    if boss3 then return end
    boss3 = TEN.Objects.GetMoveableByName(BOSS_NAME3)
    if boss3 then
        if START_HP3 and START_HP3 > 0 then boss3:SetHP(START_HP3) end
        LevelFuncs.OnBoss3Hit = function(hitObj)
            hitObj:SetHP(math.max(0, hitObj:GetHP() - 1))
        end
        boss3:SetOnHit(LevelFuncs.OnBossHit)
        lastHP3 = boss3:GetHP()
        if tile_ok_once3 then ensure_bar3() end
    end
end

local function try_bind_boss4()
    if boss4 then return end
    boss4 = TEN.Objects.GetMoveableByName(BOSS_NAME4)
    if boss4 then
        if START_HP4 and START_HP4 > 0 then boss4:SetHP(START_HP4) end
        LevelFuncs.OnBoss4Hit = function(hitObj)
            hitObj:SetHP(math.max(0, hitObj:GetHP() - 1))
        end
        boss4:SetOnHit(LevelFuncs.OnBossHit)
        lastHP4 = boss4:GetHP()
        if tile_ok_once4 then ensure_bar4() end
    end
end



local function ensure_bar3()
    if bar_created3 or not CustomBar then return end
    local bgPos  = TEN.Vec2(50, UI_Y3)
    local bgSize = TEN.Vec2(42, 4)
    local leftX  = bgPos.x - (bgSize.x / 2)

    CustomBar.CreateEnemyHpBar({
        barName      = "boss_hp3",
        object       = BOSS_NAME3,

        objectIdBg   = TEN.Objects.ObjID.DIARY_SPRITES,
        spriteIdBg   = 1,
        colorBg      = BLACK_BG,
        posBg        = bgPos,
        rotBg        = 0,
        scaleBg      = bgSize,
        alignModeBg  = TEN.View.AlignMode.CENTER,
        scaleModeBg  = TEN.View.ScaleMode.STRETCH,
        blendModeBg  = TEN.Effects.BlendID.ALPHABLEND,

        objectIdBar  = TEN.Objects.ObjID.DIARY_SPRITES,
        spriteIdBar  = 1,
        colorBar     = GREEN_BAR,
        posBar       = TEN.Vec2(leftX, bgPos.y),
        rot          = 0,
        scaleBar     = TEN.Vec2(bgSize.x - 2, bgSize.y - 1),
        alignMode    = TEN.View.AlignMode.CENTER_LEFT,
        scaleMode    = TEN.View.ScaleMode.STRETCH,
        blendMode    = TEN.Effects.BlendID.ALPHABLEND,

        hideText        = true,
        alphaBlendSpeed = ALPHA_SPEED,
        blink           = true,
        blinkLimit      = BLINK_LIMIT,
        showBar         = false   -- <-- IMPORTANTISSIMO: la mostriamo in OnLoop
    })
    bar_created3 = true
end

local function ensure_bar4()
    if bar_created4 or not CustomBar then return end
    local bgPos  = TEN.Vec2(50, UI_Y4)
    local bgSize = TEN.Vec2(42, 4)
    local leftX  = bgPos.x - (bgSize.x / 2)

    CustomBar.CreateEnemyHpBar({
        barName      = "boss_hp4",
        object       = BOSS_NAME4,

        objectIdBg   = TEN.Objects.ObjID.DIARY_SPRITES,
        spriteIdBg   = 1,
        colorBg      = BLACK_BG,
        posBg        = bgPos,
        rotBg        = 0,
        scaleBg      = bgSize,
        alignModeBg  = TEN.View.AlignMode.CENTER,
        scaleModeBg  = TEN.View.ScaleMode.STRETCH,
        blendModeBg  = TEN.Effects.BlendID.ALPHABLEND,

        objectIdBar  = TEN.Objects.ObjID.DIARY_SPRITES,
        spriteIdBar  = 1,
        colorBar     = BLUE_BAR,
        posBar       = TEN.Vec2(leftX, bgPos.y),
        rot          = 0,
        scaleBar     = TEN.Vec2(bgSize.x - 2, bgSize.y - 1),
        alignMode    = TEN.View.AlignMode.CENTER_LEFT,
        scaleMode    = TEN.View.ScaleMode.STRETCH,
        blendMode    = TEN.Effects.BlendID.ALPHABLEND,

        hideText        = true,
        alphaBlendSpeed = ALPHA_SPEED,
        blink           = true,
        blinkLimit      = BLINK_LIMIT,
        showBar         = false
    })
    bar_created4 = true
end


LevelFuncs.OnBossTileEnter3 = function()
    tile_ok_once3 = true
    ensure_bar3()   -- crea subito la barra (nascosta) se il boss esiste
end

LevelFuncs.OnBossTileEnter4 = function()
    tile_ok_once4 = true
    ensure_bar4()
end


 

LevelFuncs.OnLoad = function()



--	bat246 = GetMoveableByName("bat_246")
--	bat252 = GetMoveableByName("bat_252")

    -- Boss1
    boss = TEN.Objects.GetMoveableByName(BOSS_NAME)
    if boss then
        boss:SetOnHit(LevelFuncs.OnBossHit)
        lastHP = boss:GetHP()
        print("[Boss.lua] OnLoad: re-hook OnHit Boss1, HP:", lastHP)
    end

    -- Boss2
    boss2 = TEN.Objects.GetMoveableByName(BOSS_NAME2)
    if boss2 then
        boss2:SetOnHit(LevelFuncs.OnBossHit)
        lastHP2 = boss2:GetHP()
        print("[Boss.lua] OnLoad: re-hook OnHit Boss2, HP:", lastHP2)
    end

    -- Boss3
    boss3 = TEN.Objects.GetMoveableByName(BOSS_NAME3)
    if boss3 then
        boss3:SetOnHit(LevelFuncs.OnBossHit)
        lastHP3 = boss3:GetHP()
        print("[Boss.lua] OnLoad: re-hook OnHit Boss3, HP:", lastHP3)
        if tile_ok_once3 then ensure_bar3() end
    end

    -- Boss4
    boss4 = TEN.Objects.GetMoveableByName(BOSS_NAME4)
    if boss4 then
        boss4:SetOnHit(LevelFuncs.OnBossHit)
        lastHP4 = boss4:GetHP()
        print("[Boss.lua] OnLoad: re-hook OnHit Boss4, HP:", lastHP4)
        if tile_ok_once4 then ensure_bar4() end
    end



 

end



 





LevelFuncs.OnSave  = function() 

 


end

LevelFuncs.OnStart = function()




 



    boss = TEN.Objects.GetMoveableByName(BOSS_NAME)
    if boss then
        boss:SetHP(START_HP)
        print(("[Boss.lua] '%s' HP iniziali: %d"):format(BOSS_NAME, START_HP))

        

        -- hook OnHit
        
        boss:SetOnHit(LevelFuncs.OnBossHit)

--        boss:SetOnKilled(function(obj)
--            print("[Boss.lua] KILLED (anim:", obj:GetAnim(), ")")
--        end)

        lastHP = boss:GetHP()
    else
        print("[Boss.lua] Boss non ancora presente, barra non creata.")
    end



    -- ===== Boss 2 (nuovo) =====
    boss2 = TEN.Objects.GetMoveableByName(BOSS_NAME2)
    if boss2 then
        boss2:SetHP(START_HP2)
        print(("[Boss.lua] '%s' HP iniziali: %d"):format(BOSS_NAME2, START_HP2))

         
        boss2:SetOnHit(LevelFuncs.OnBossHit)

 

        lastHP2 = boss2:GetHP()
    else
        print("[Boss.lua] Boss2 non ancora presente, barra2 non creata.")
    end




        -- ===== Boss 3 =====
    boss3 = TEN.Objects.GetMoveableByName(BOSS_NAME3)
    if boss3 then
        boss3:SetHP(START_HP3)
        print(("[Boss.lua] '%s' HP iniziali: %d"):format(BOSS_NAME3, START_HP3))

         
        boss3:SetOnHit(LevelFuncs.OnBossHit)

        -- opzionale: solo log
--        boss3:SetOnKilled(function(obj)
--            print("[Boss.lua] BOSS3 KILLED (anim:", obj:GetAnim(), ")")
--        end)

        lastHP3 = boss3:GetHP()
    else
        print("[Boss.lua] Boss3 non ancora presente, barra3 non creata.")
    end

    -- ===== Boss 4 =====
    boss4 = TEN.Objects.GetMoveableByName(BOSS_NAME4)
    if boss4 then
        boss4:SetHP(START_HP4)
        print(("[Boss.lua] '%s' HP iniziali: %d"):format(BOSS_NAME4, START_HP4))

         
        boss4:SetOnHit(LevelFuncs.OnBossHit)

--        boss4:SetOnKilled(function(obj)
--            print("[Boss.lua] BOSS4 KILLED (anim:", obj:GetAnim(), ")")
--        end)

        lastHP4 = boss4:GetHP()
    else
        print("[Boss.lua] Boss4 non ancora presente, barra4 non creata.")
    end

----------------------------------------------------------------------------------------
-- SCRITTA INIZIALE
 	local pos1 = Vec2(PercentToScreen(50, 88))
 	local pos2 = Vec2(PercentToScreen(50, 94))
 	-- crea l'oggetto stringa
    local s1 = DisplayString(
        "Somewhere around Zafferana Etnea, Italy",
        pos1,
        1.0,                          -- scala (facoltativa)
        Color(255, 255, 255, 255)     -- colore
        -- , false                    -- translated (facoltativo)
    )

    -- opzionale: centra rispetto a 'pos' e aggiungi ombra
    s1:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }

    -- MOSTRA per 6s e poi elimina l'oggetto (autoDelete=true)
    Strings.ShowString(s1, 6, true)
    
    local s2 = DisplayString(
        "Lara is looking for the entrance to the lost city of Topaz",
        pos2,
        1.0,                          -- scala (facoltativa)
        Color(0, 128, 160, 255)     -- colore
        -- , false                    -- translated (facoltativo)
    )

    -- opzionale: centra rispetto a 'pos' e aggiungi ombra
    s2:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }

    -- MOSTRA per 6s e poi elimina l'oggetto (autoDelete=true)
    Strings.ShowString(s2, 6, true)
----------------------------------------------------------------------------------------------------------




-----------------------------
-- settiamo le piastrelle di room 1 a invisibili


	piastrella1 = TEN.Objects.GetStaticByName("static_mesh_273")
	piastrella2 = TEN.Objects.GetStaticByName("static_mesh_274")
	piastrella3 = TEN.Objects.GetStaticByName("static_mesh_275")
	
	
	if piastrella1 then
        piastrella1:Disable()   
    end
    if piastrella2 then
        piastrella2:Disable()   
    end
    if piastrella3 then
        piastrella3:Disable()   
    end


----------------------------

-- inizializza i timer (randomizzati per non avere puff sincronizzati)
    for i=1,#spots_pozze_nebbia do
        timers[i] = math.random(120, 240)  -- 2–4 secondi
    end

end -- end OnStart


LevelFuncs.OnLoop = function()


    
    
    
    -- prova sempre a prendere i riferimenti (spawn tardivo)
    boss  = boss  or TEN.Objects.GetMoveableByName(BOSS_NAME)
    
    try_bind_boss2()
    try_bind_boss3()
    try_bind_boss4() 
    
    -- mostra barre se serve
    if not bar_shown  then update_bar_visibility()  end
    if not bar_shown2 then update_bar_visibility2() end
    if not bar_shown3  then update_bar_visibility3()  end
    if not bar_shown4 then update_bar_visibility4() end

    -- debug HP boss1
    if boss then
        local hp = boss:GetHP()
        if hp ~= lastHP then
            print("[Boss.lua] HP boss1 cambiati ->", hp)
            lastHP = hp
        end
    end

    -- debug HP boss2
    if boss2 then
        local hp2 = boss2:GetHP()
        if hp2 ~= lastHP2 then
            print("[Boss.lua] HP boss2 cambiati ->", hp2)
            lastHP2 = hp2
        end
    end


    -- porta fuori dallo scope degli if
    local want3, want4 = false, false


    -- barra 3: visibile solo se Lara LO PUNTA
    if tile_ok_once3 and boss3 and bar_created3 then
        want3 = boss3:GetHitStatus()  -- true se mirato
        if want3 ~= bar_shown3 then
--            CustomBar.HideBar("boss_hp3", not want3)
              hide_bar_safe("boss_hp3", not want3) 
            bar_shown3 = want3
        end
    end

    -- barra 4: idem
    if tile_ok_once4 and boss4 and bar_created4 then
        want4 = boss4:GetHitStatus()
        if want4 ~= bar_shown4 then
 --           CustomBar.HideBar("boss_hp4", not want4)
             hide_bar_safe("boss_hp4", not want4)
            bar_shown4 = want4
        end
    end

    


 


---------------------------------------------------------------------
-- === HUD AMMO + NOME ARMA (OnLoop) ===

--	local wt = Objects.LaraObject.GetWeaponType(Lara)
	-- wt == 1 → Pistols a munizioni infinite: ignoriamo
--	if wt ~= 1 then
--	    local tttt = Lara:GetHandStatus()  -- 4 = WEAPON_READY
--	    if tttt == 4 then
	        -- prendi UI (label, y, color) dalla tabella; fallback se manca
--	        local ui    = WEAPON_UI[wt]
--	        local label = (ui and ui.label) or tostring(wt)
--	        local y     = (ui and ui.y)     or 60
--	        local col   = (ui and ui.color) or Color(255,255,255,255)
	
--	        local ammo  = Lara:GetAmmoCount()
--	        local text  = string.format("%s: %s", label, tostring(ammo))
	
--	        local s = DisplayString(text, Vec2(40, y), 1.0, col, false)
--	        Strings.ShowString(s, 0.1, true)
--	    end
--	end

-- === HUD AMMO + NOME ARMA + tag N/W per Shotgun (OnLoop) ===

	-- === aggiunta: colore rosso/blu per Shotgun ===
	local wt = Objects.LaraObject.GetWeaponType(Lara)
	if wt ~= 1 then
	    local tttt = Lara:GetHandStatus()  -- 4 = WEAPON_READY
	    if tttt == 4 then
	        local ui    = WEAPON_UI[wt]
	        local label = (ui and ui.label) or tostring(wt)
	        local y     = (ui and ui.y)     or 60
	        local col   = (ui and ui.color) or Color(255,255,255,255)
	
	        if wt == Objects.WeaponType.SHOTGUN then
	            local at    = Lara:GetAmmoType()
	            local isWide = (at == Objects.AmmoType.SHOTGUN_WIDE)
	            label = string.format("%s (%s)", label, isWide and "W" or "N")
	            -- 🔴 normale = rosso, 🔵 wide = blu
	            col   = isWide and Color(0,160,255,255) or Color(255,80,80,255)
	        end
	
	        local ammo  = Lara:GetAmmoCount()
	        local text  = string.format("%s: %s", label, tostring(ammo))
	
	        local s = DisplayString(text, Vec2(40, y), 1.0, col, false)
	        Strings.ShowString(s, 0.1, true)
	    end
	end




---------------------------------------------------------------------
-- FUOCHI in alto
     
	    
	    
	    Effects.EmitFire(pos_fire1,sizell)
	    Effects.EmitFire(pos_fire2,sizell)
	    Effects.EmitFire(pos_fire3,sizell)

-- FUOCO su tetto  altare  
     

			Effects.EmitFire(pos_fire4,sizeff)
			
-- FUOCHI in room1			
			
	 
	 Effects.EmitFire(pos_room1,size_room)
	 Effects.EmitFire(pos_room2,size_room)
	 Effects.EmitFire(pos_room3,size_room)
	 
	 
-- FUOCHI in room primo topazio			
			
	 
	 Effects.EmitFire(pos_room4,size_room)
	 Effects.EmitFire(pos_room5,size_room)
	 
	 
-- FUOCHI in room secondo e terzo topazio			
			
	 
	 Effects.EmitFire(pos_room6,size_room)
	 Effects.EmitFire(pos_room7,size_room)
	 Effects.EmitFire(pos_room8,size_room)
	 Effects.EmitFire(pos_room9,size_room)
	  
-- FUOCHI in room CENTAURO boss	
			
	  
	 Effects.EmitFire(pos_room10,size_roomC)
	 Effects.EmitFire(pos_room11,size_roomC)
	 
	 
	 -- fuochi corridoio
	 Effects.EmitFire(pos_roomR1,size_roomCORR)
	 Effects.EmitFire(pos_roomR2,size_roomCORR)
	 Effects.EmitFire(pos_roomR3,size_roomCORR)
	 Effects.EmitFire(pos_roomR4,size_roomCORR)
	 Effects.EmitFire(pos_roomR5,size_roomCORR)
	 Effects.EmitFire(pos_roomR6,size_roomCORR)
	 
	 Effects.EmitFire(pos_roomL1,size_roomCORR)
	 Effects.EmitFire(pos_roomL2,size_roomCORR)
	 Effects.EmitFire(pos_roomL3,size_roomCORR)
	 Effects.EmitFire(pos_roomL4,size_roomCORR)
	 Effects.EmitFire(pos_roomL5,size_roomCORR)
	 Effects.EmitFire(pos_roomL6,size_roomCORR)
	  
	 
	 
-- FUOCHI pozza room altare	

	 Effects.EmitFire(pos_fiamme,size_roomPA)
	 
	 
	 
	 
-- FUOCHI ARENA MINOTAURO			


if is_boss1_spawned_alive() then

	  
	 Effects.EmitFire(pos_room12,size_roomM)
	 Effects.EmitFire(pos_room13,size_roomM)
	 Effects.EmitFire(pos_room14,size_roomM)
	 Effects.EmitFire(pos_room15,size_roomM)	 
	 Effects.EmitFire(pos_room16,size_roomM)
	 Effects.EmitFire(pos_room17,size_roomM)
	 Effects.EmitFire(pos_room18,size_roomM)
	 Effects.EmitFire(pos_room19,size_roomM)

end

--          postest = Vec3(10752, 256, 10752)
--          Effects.EmitFire(postest,size_roomM)
          

-- FUOCHI TOMBA MALACHIA
if lara_tomba then
--	 Effects.EmitFire(pos_room20,size_roomMALA)
--	 Effects.EmitFire(pos_room21,size_roomMALA)
--	 Effects.EmitFire(pos_room22,size_roomMALA)
--	 Effects.EmitFire(pos_room23,size_roomMALA)
	 Effects.EmitFire(pos_room24,size_roomMALA)
	 Effects.EmitFire(pos_room25,size_roomMALA)
end


--------------------------------------------------------------------------------    

---------------------------------------------------------------------
-- POZZE con timer randomizzate
     for i,posA in ipairs(spots_pozze_nebbia) do
        timers[i] = timers[i] - 1
        if timers[i] <= 0 then
            spawnNebbia(posA)
            timers[i] = math.random(140, 280)  -- reset
        end
    end
----------------------------------------------------------------------------------------    

end   -- end di OnLoop


 


 

 
LevelFuncs.OnEnd = function()
      
end

LevelFuncs.OnFreeze = function()
     
    
         
end








LevelFuncs.OnUseItem  = function() end




 






