-- Place in this Lua script all the levels of your game
-- Title is mandatory and must be the first level.

-- Intro image is a splash screen which appears before actual loading screen.
-- If you don't want it to appear, just remove this line.

-- Flow.SetIntroImagePath("Screens\\main.jpg")

-- Set overall amount of secrets in game.
-- If set to 0, secrets won't be displayed in statistics.

Flow.SetTotalSecretCount(8)

-- Enable/Disable Point Filter (square, unsmoothed pixels).

Flow.EnablePointFilter(false)

-- Enable/Disable saving and loading of savegames.

Flow.EnableLoadSave(true)

-- Disable/enable flycheat globally

Flow.EnableFlyCheat(true)

-- Disable/enable Lara drawing in title level

Flow.EnableLaraInTitle(false)

-- Disable/enable level selection in title level

Flow.EnableLevelSelect(true)

-- Disable/enable mass pickup (collect all pickups at once)

Flow.EnableMassPickup(true)

--------------------------------------------------

-- Title level

title = Level.new()

title.ambientTrack = "006"
title.levelFile = "Data\\title.ten"
title.scriptFile = "Scripts\\Levels\\title.lua"
title.loadScreenFile = "Screens\\main.jpg"

Flow.AddLevel(title)

--------------------------------------------------
-- Tomb_Portal level

Tomb_Portal = TEN.Flow.Level()

Tomb_Portal.nameKey = "Tomb_Portal"
Tomb_Portal.scriptFile = "Scripts\\Levels\\Tomb_Portal.lua"
Tomb_Portal.ambientTrack = "005"
Tomb_Portal.horizon1.enabled = false
Tomb_Portal.levelFile = "Data\\Tomb_Portal.ten"
Tomb_Portal.loadScreenFile = "Screens\\rome.jpg"
Tomb_Portal.secrets = 8
Tomb_Portal.fog = Flow.Fog(Color(180,79,10), 10,300)

TEN.Flow.AddLevel(Tomb_Portal)

--------------------------------------------------
