-- Place in this Lua script all the levels of your game
-- Title is mandatory and must be the first level.

-- Intro image is a splash screen which appears before actual loading screen.
-- If you don't want it to appear, just remove this line.

Flow.SetIntroImagePath("Screens\\splashacca1.jpg")

-- Intro video plays right after or instead of intro image, if specified.
-- If you don't want it to appear, just remove this line.

Flow.SetIntroVideoPath("Fmv\\introduzione.mp4")

-- Set overall amount of secrets in game.
-- If set to 0, secrets won't be displayed in statistics.

Flow.SetTotalSecretCount(11)

-- Enable/Disable Point Filter (square, unsmoothed pixels).

Flow.EnablePointFilter(false)

-- Enable/Disable saving and loading of savegames.

Flow.EnableLoadSave(true)

-- Disable/enable flycheat globally

Flow.EnableFlyCheat(false)

-- Disable/enable Lara drawing in title level

Flow.EnableLaraInTitle(false)

-- Disable/enable level selection in title level

Flow.EnableLevelSelect(true)

-- Disable/enable mass pickup (collect all pickups at once)

Flow.EnableMassPickup(true)

Flow.EnableHomeLevel(true)

--------------------------------------------------

-- Title level

title = Level.new()

title.ambientTrack = "998" -- musica background nel menu iniziale
title.levelFile = "Data\\title.ten"
title.scriptFile = "Scripts\\Levels\\title.lua"
title.loadScreenFile = "Screens\\combocopertina.jpg"

Flow.AddLevel(title)


--------------------------------------------------

-- home level

home = TEN.Flow.Level()

home.nameKey = "home"
home.scriptFile = "Scripts\\Levels\\home.lua"
home.ambientTrack = "113"
home.horizon1.enabled = true
home.levelFile = "Data\\home.ten"
home.loadScreenFile = "Screens\\cri1.jpg"

home.objects = {
    InventoryItem("PuzzleItem2crypt", ObjID.PUZZLE_ITEM2,
                  0,            -- yOffset (0 va benissimo per iniziare)
                  0.7,          -- scale (0.6–0.9 tipico)
                  Rotation.new(0, 0, 0),
                  RotationAxis.Y,
                  -1,           -- meshBits (non usato)
                  ItemAction.USE),
     InventoryItem("PuzzleItem4crypt", ObjID.PUZZLE_ITEM4, -- LIBRO
                  0,            -- yOffset (0 va benissimo per iniziare)
                  0.7,          -- scale (0.6–0.9 tipico)
                  Rotation.new(0, 0, 0),
                  RotationAxis.Y,
                  -1,           -- meshBits (non usato)
                  ItemAction.USE);             
}

TEN.Flow.AddLevel(home)

--------------------------------------------------

--------------------------------------------------
-- Boss level

Boss = TEN.Flow.Level()

Boss.nameKey = "Boss"
Boss.scriptFile = "Scripts\\Levels\\Boss.lua"
Boss.ambientTrack = "113"
Boss.horizon1.enabled = true
Boss.levelFile = "Data\\Boss.ten"
Boss.loadScreenFile = "Screens\\to1.jpg"

Boss.secrets = 5

Boss.objects = {
    InventoryItem("PuzzleItem2", ObjID.PUZZLE_ITEM2,
                  0,            -- yOffset (0 va benissimo per iniziare)
                  0.7,          -- scale (0.6–0.9 tipico)
                  Rotation.new(0, 0, 0),
                  RotationAxis.Y,
                  -1,           -- meshBits (non usato)
                  ItemAction.USE),
     InventoryItem("PuzzleItem1", ObjID.PUZZLE_ITEM1,
                  0,            -- yOffset (0 va benissimo per iniziare)
                  0.7,          -- scale (0.6–0.9 tipico)
                  Rotation.new(0, 0, 0),
                  RotationAxis.Y,
                  -1,           -- meshBits (non usato)
                  ItemAction.USE),
     InventoryItem("Seraph", ObjID.PUZZLE_ITEM4,
                  0,            -- yOffset (0 va benissimo per iniziare)
                  0.7,          -- scale (0.6–0.9 tipico)
                  Rotation.new(0, 0, 0),
                  RotationAxis.Y,
                  -1,           -- meshBits (non usato)
                  ItemAction.USE);             
}

TEN.Flow.AddLevel(Boss)

--------------------------------------------------








--------------------------------------------------

-- Matera level

Matera = TEN.Flow.Level()

--Matera.nameKey = "The Tower of Lamentations"
Matera.nameKey = "Matera"

Matera.scriptFile = "Scripts\\Levels\\Matera.lua"

--------------------------------------------------------
--  113: Tomb Raider 3 Tinnos
--  114: horror background atmosphere 012 pixabay
Matera.ambientTrack = "113"
Matera.horizon1.enabled = true
Matera.levelFile = "Data\\Matera.ten"
Matera.loadScreenFile = "Screens\\lame2.jpg"

Matera.secrets = 3


Matera.objects = {
    InventoryItem("PuzzleItem2matera", ObjID.PUZZLE_ITEM2,
                  0,            -- yOffset (0 va benissimo per iniziare)
                  0.7,          -- scale (0.6–0.9 tipico)
                  Rotation.new(0, 0, 0),
                  RotationAxis.Y,
                  -1,           -- meshBits (non usato)
                  ItemAction.USE),
     InventoryItem("PuzzleItem1matera", ObjID.PUZZLE_ITEM1, -- LIBRO
                  0,            -- yOffset (0 va benissimo per iniziare)
                  0.7,          -- scale (0.6–0.9 tipico)
                  Rotation.new(0, 0, 0),
                  RotationAxis.Y,
                  -1,           -- meshBits (non usato)
                  ItemAction.USE);             
}

TEN.Flow.AddLevel(Matera)

--------------------------------------------------

-- Catacombs level

Catacombs = TEN.Flow.Level()

Catacombs.nameKey = "Catacombs"
Catacombs.scriptFile = "Scripts\\Levels\\Catacombs.lua"

--------------------------------------------------------
--  113: Tomb Raider 3 Tinnos
--  114: horror background atmosphere 012 pixabay

Catacombs.ambientTrack = "113"
Catacombs.horizon1.enabled = true
Catacombs.levelFile = "Data\\Catacombs.ten"
Catacombs.loadScreenFile = "Screens\\te1.jpg"

Catacombs.secrets = 3

Catacombs.objects = {
    InventoryItem("PuzzleItem2catacombs", ObjID.PUZZLE_ITEM2,
                  0,            -- yOffset (0 va benissimo per iniziare)
                  0.7,          -- scale (0.6–0.9 tipico)
                  Rotation.new(0, 0, 0),
                  RotationAxis.Y,
                  -1,           -- meshBits (non usato)
                  ItemAction.USE),
     InventoryItem("PuzzleItem1catacombs", ObjID.PUZZLE_ITEM1, -- LIBRO
                  0,            -- yOffset (0 va benissimo per iniziare)
                  0.7,          -- scale (0.6–0.9 tipico)
                  Rotation.new(0, 0, 0),
                  RotationAxis.Y,
                  -1,           -- meshBits (non usato)
                  ItemAction.USE),
     InventoryItem("PuzzleItem4catacombs", ObjID.PUZZLE_ITEM4, -- SERAPH
                  0,            -- yOffset (0 va benissimo per iniziare)
                  0.7,          -- scale (0.6–0.9 tipico)
                  Rotation.new(0, 0, 0),
                  RotationAxis.Y,
                  -1,           -- meshBits (non usato)
                  ItemAction.USE);             
}

TEN.Flow.AddLevel(Catacombs)

 




-- Credits level

Credits = TEN.Flow.Level()

Credits.nameKey = "Credits"
Credits.scriptFile = "Scripts\\Levels\\Credits.lua"
Credits.ambientTrack = "998" -- musica background nel menu iniziale
Credits.horizon1.enabled = true
Credits.levelFile = "Data\\Credits.ten"
Credits.loadScreenFile = "Screens\\sololibro.jpg"

TEN.Flow.AddLevel(Credits)

--------------------------------------------------
