-- FILE: Scripts\Levels\Boss.lua




---------------------------------------------------------------------

local flag_camera_minotauro = false


--------------------------------------------------------------------
-- FUNCTION per fuoco custom


local function EmitFuocoMio(posizione, stren, ii)

			Effects.EmitFire(posizione, stren)
		    Effects.EmitLight(
		        posizione,                        -- posizione
		        Color(255, 140, 40),        -- colore
		        12,                         -- raggio
		        16,                         -- falloff
		        "lucefireandlight_" .. ii     -- chiave univoca per ogni luce
		    )

end 

---------------------------------------------------------------
-- FUNCTION aggiunta per Disable door prima piscina

LevelFuncs.OnGatePiscinaDisable = function()

    TEN.Objects.GetMoveableByName("door_type9_356"):Disable()

end


---------------------------------------------------------------
-- functions per emissione fuochi camera alta

 



local function FuochiCameraAltaOn()
	local posAlta = {Vec3(16896, -6912, 24064), 
				 Vec3(18944, -6912, 24064)}
				 
	local stren = 1
	local indici = {131, 132}

--	if flag_fuochi_cameraalta then
		for kk = 1, #posAlta do
	    	EmitFuocoMio(posAlta[kk], stren, indici[kk])
		end
--	end


end

				 



--------------------------------------------------------------------
-- FUNCTIONs per emissione archi



local flagArchi = false
local flagSpegniArcoLetale = false
local timeArchi = 0.0
local flagFuocoTinnos = false
local flagArchiStdby = true

local TinnosMonsterSecond = TEN.Objects.GetMoveableByName("claw_mutant_338")
local TinnosMonsterSecondStatua = TEN.Objects.GetStaticByName("static_mesh_339")
local DoorFantasma = TEN.Objects.GetMoveableByName("door_type8_343")
local DoorIntermezza = TEN.Objects.GetMoveableByName("door_type9_348")
local flagPortaIntermezza = false

LevelFuncs.OnLaraHaDueItem = function()

--	 if TinnosMonsterSecond and TinnosMonsterSecondStatua then
		 
		 TinnosMonsterSecondStatua:Shatter()
		
		 
		 TinnosMonsterSecond:Enable()
		 Sound.PlaySound(1199) -- custom suono  
		 
		 flagFuocoTinnos = true
		 flagPortaIntermezza = true
		  
--	 end
	 
end

local function archiTopaz(dt)
--EmitLightningArc(origin, target, [color], [life], [amplitude], [beamWidth], [detail], [smooth], [endDrift])   


	
	
	local omega1 = 3.0
	local omega2 = 1.5 * omega1
	local pi = 3.1415
	local ampliRed1 = 50
	local ampliBlu1 = 12
	local ampliRed2 = 12
	local ampliGreen2 = 60
	local red1 = 122 + ampliRed1 * math.sin(omega1 * timeArchi + pi)
	local blu1 = 224 + ampliBlu1 * math.sin(omega1 * timeArchi)
	local red2 = 224 + ampliRed2 * math.sin(omega2 * timeArchi + pi)
	local green2 = 160 + ampliGreen2 * math.sin(omega2 * timeArchi) 
	local color1 = Color(red1, 59, blu1)
	local color2 = Color(red2, green2, 64)

    local baseR, baseG, baseB = 80, 237, 180
    local ampG = 18      
    local ampB = 10
    local omegaC = 1.2
    local pulsG = ampG * math.sin(omegaC * timeArchi)
    local pulsB = ampB * math.sin(omegaC * timeArchi + math.pi/2)
    local rC = baseR
    local gC = baseG + pulsG
    local bC = baseB + pulsB
    local colorCentrale = Color(rC, gC, bC)   -- colore archi centrali time-dependent






    
	
	local lifetime = 1.0
	local amplitude = 20
	local beamwidth = 10
	local detail = 20
	local smooth = true

	local origStby1 = Vec3(51712, 12800, 36352)
	local destStby1 = Vec3(51712, 12032, 36352)
	local origStby2 = Vec3(53760, 12800, 38400)
	local destStby2 = Vec3(53760, 12032, 38400)
	local origStby3 = Vec3(49664, 12800, 38400)
	local destStby3 = Vec3(49664, 12032, 38400)
	local origStby4 = Vec3(51712, 12800, 40448)
	local destStby4 = Vec3(51712, 12032, 40448)

    local origStdbyCentrale = Vec3(51712, 12672, 38400)
    local destStdbyCentrale = Vec3(51712, 11904, 38400)

    local origStby5 = Vec3(51712, 11904, 38400)
	local destStby5 = Vec3(51712, 6656, 38400)

	if flagArchiStdby then     -- piccoli archi accesi 
	
	
		EmitLightningArc(origStby1, destStby1, color1, lifetime, amplitude, beamwidth, detail, smooth)
		EmitLightningArc(origStby4, destStby4, color1, lifetime, amplitude, beamwidth, detail, smooth)
		EmitLightningArc(origStby2, destStby2, color2, lifetime, amplitude, beamwidth, detail, smooth)
		EmitLightningArc(origStby3, destStby3, color2, lifetime, amplitude, beamwidth, detail, smooth)

        EmitLightningArc(origStdbyCentrale, destStdbyCentrale, colorCentrale, lifetime, amplitude, beamwidth, detail, smooth)

        
	
		Effects.EmitLight(
			        origStby1,                        -- posizione
			        Color(255, 140, 40),        -- colore
			        12,                         -- raggio
			        16,                         -- falloff
			        "lucefireandlight_" .. 1001     -- chiave univoca per ogni luce
			    )
	
		Effects.EmitLight(
			        origStby2,                        -- posizione
			        Color(255, 140, 40),        -- colore
			        12,                         -- raggio
			        16,                         -- falloff
			        "lucefireandlight_" .. 1002     -- chiave univoca per ogni luce
			    )
			    
		Effects.EmitLight(
			        origStby3,                        -- posizione
			        Color(255, 140, 40),        -- colore
			        12,                         -- raggio
			        16,                         -- falloff
			        "lucefireandlight_" .. 1001     -- chiave univoca per ogni luce
			    )
	
		Effects.EmitLight(
			        origStby4,                        -- posizione
			        Color(255, 140, 40),        -- colore
			        12,                         -- raggio
			        16,                         -- falloff
			        "lucefireandlight_" .. 1002     -- chiave univoca per ogni luce
			    )	    
	
	end

	if flagFuocoTinnos then
		local posStatua = Vec3(59904, 6912, 42496)
		local posFuocoTinnos1 = Vec3(62976, 6400, 44544)
		local posFuocoTinnos2 = Vec3(62976, 6400, 42496)
		EmitFuocoMio(posStatua, 3, 245)
		EmitFuocoMio(posFuocoTinnos1, 1, 246)
		EmitFuocoMio(posFuocoTinnos2, 1, 247)
	end

	 

	if DoorFantasma:GetAnim()==1 or DoorFantasma:GetAnim()==2 then
		flagSpegniArcoLetale = true
		flagPortaIntermezza = false		
		flagArchiStdby = true
	end

	timeArchi = timeArchi + dt

	local origin1 = Vec3(49664, 11904, 38400)
    local origin2 = Vec3(53760, 11904, 38400)
    local origin3 = Vec3(51712, 11904, 40448)
    local origin4 = Vec3(51712, 11904, 36352)

	--local target1 = Vec3(51712, 12032, 36352)
	 
	--local target2 = Vec3(53760, 12032, 38400)

    local targetArchiKill = Vec3(51712, 11904, 38400)
	
	local LaraPosition = Lara:GetPosition()
	local targetLara = Vec3(LaraPosition.x, LaraPosition.y - 512, LaraPosition.z)
	
	
	
	
	
	
	local roomArcoLetale1 = TEN.Objects.GetRoomByName("PUZZLE2livello1")
    local roomArcoLetale2 = TEN.Objects.GetRoomByName("PUZZLE2livello2aaa")
    local roomArcoLetale3 = TEN.Objects.GetRoomByName("arcoletale3")
    local roomArcoLetale4 = TEN.Objects.GetRoomByName("arcoletale4")
    local roomArcoLetale5 = TEN.Objects.GetRoomByName("ROOMpuzzleLIVELLO1")
    local roomArcoLetale6 = TEN.Objects.GetRoomByName("connettoreAAA")
	local roomroomArcoLetale1Number = roomArcoLetale1:GetRoomNumber()
    local roomroomArcoLetale2Number = roomArcoLetale2:GetRoomNumber()
    local roomroomArcoLetale3Number = roomArcoLetale3:GetRoomNumber()
    local roomroomArcoLetale4Number = roomArcoLetale4:GetRoomNumber()
    local roomroomArcoLetale5Number = roomArcoLetale5:GetRoomNumber()
    local roomroomArcoLetale6Number = roomArcoLetale6:GetRoomNumber()


    local lethalRooms = {
                            roomroomArcoLetale1Number,
                            roomroomArcoLetale2Number,
                            roomroomArcoLetale3Number,
                            roomroomArcoLetale4Number,
                            roomroomArcoLetale5Number,
                            roomroomArcoLetale6Number
                        }



	local roomLara = Lara:GetRoomNumber()
	
	
	local conteggio = GetItemCount(501) -- conta quanti puzzle 2 items ci sono in inventario
	
	if conteggio == 2 then 
		flagArchi = true
	--	TEN.Objects.GetMoveableByName("door_type9_102"):Enable()
--		TEN.Objects.GetMoveableByName("door_type9_348"):Enable()
		TEN.Objects.GetMoveableByName("door_type9_349"):Enable() -- door intermedia nel labirinto
	end 
	
	local lifetime2 = 1.0
	local amplitude2 = 100
	local beamwidth2 = 10
	local detail2 = 20

    local laraHealthInitArchi  
	
	if flagArchi and not flagSpegniArcoLetale then 

        
	
		flagArchiStdby = false
	
		EmitLightningArc(origin1, targetArchiKill, color1, lifetime2, amplitude2, beamwidth2, detail2, smooth)
		EmitLightningArc(origin2, targetArchiKill, color2, lifetime2, amplitude2, beamwidth2, detail2, smooth)
        EmitLightningArc(origin3, targetArchiKill, color1, lifetime2, amplitude2, beamwidth2, detail2, smooth)
		EmitLightningArc(origin4, targetArchiKill, color2, lifetime2, amplitude2, beamwidth2, detail2, smooth)

        EmitLightningArc(origStby5, destStby5, color1, lifetime, amplitude, beamwidth, detail, smooth)
		
		Effects.EmitLight(
			        origin1,                        -- posizione
			        Color(255, 140, 40),        -- colore
			        12,                         -- raggio
			        16,                         -- falloff
			        "lucefireandlight_" .. 282     -- chiave univoca per ogni luce
			    )
	
		Effects.EmitLight(
			        origin2,                        -- posizione
			        Color(255, 140, 40),        -- colore
			        12,                         -- raggio
			        16,                         -- falloff
			        "lucefireandlight_" .. 283     -- chiave univoca per ogni luce
			    )
			    
			    
                for _, r in ipairs(lethalRooms) do

                    if roomLara == r then
                        EmitLightningArc(targetArchiKill, targetLara, color2, lifetime, amplitude, beamwidth, detail, smooth) -- arco che colpisce Lara

                        
                        local velocityArco = 750.0
                        
                        --Lara:SetHP(0)
                        laraHealthInitArchi = Lara:GetHP()
                        Lara:SetHP(laraHealthInitArchi - velocityArco * dt)
                    end

                end
	end  
	
end

------------------------------------------------------------------------------------
-----   BADDY porte Topaz aperte

LevelFuncs.OnBaddyPorteAperte = function()
	local badias = TEN.Objects.GetMoveableByName("baddy2_354")
	
	badias:Enable()
end

---------------------------------------------------------------------------
-- PORTE BOSS 3 e 4 
-- si aprono quando entrambi i boss sono sconfitti

local doorTinnosMonster1
local doorTinnosMonster2

local function InizializzaPorteTinnos()

	doorTinnosMonster1 = TEN.Objects.GetMoveableByName("door_type4_312")
	doorTinnosMonster2 = TEN.Objects.GetMoveableByName("door_type3_311")

end

local TinnosPorteFlag = false
local Boss3Set = false
local Boss4Set = false

local function ApriPorteTinnos()

	doorTinnosMonster1:Enable()
 	doorTinnosMonster2:Enable()
 	TinnosPorteFlag = true

end
 
--------------------------------------------------------------------
-- require
local AudioDurations = require("Levels.AudioDurations")
local EventSequence = require("Engine.EventSequence")

local pendolo1
local pendolo2
local pendolo3

local pendolo_flags = {false, false, false}
local tPendolo = 0.0
local nFrames = 88        -- quanti frame ha l'animazione del pendolo nel WAD
local PeriodPendolo = 3.0 -- tempo di un ciclo completo (oscillazione)




local function InizializzaPendoli()
	pendolo1 = TEN.Objects.GetMoveableByName("fire_pendulum_282")
	pendolo2 = TEN.Objects.GetMoveableByName("fire_pendulum_283")
	pendolo3 = TEN.Objects.GetMoveableByName("fire_pendulum_284")
	
	
	for _,p in ipairs({pendolo1, pendolo2, pendolo3}) do
	    if p then
	        p:SetAnim(0)
	        p:SetFrame(0)
	    end
	end

end

LevelFuncs.OnPendoloTrigger1 = function()
--	pendolo1:Enable()
	pendolo_flags[1] = true
end

LevelFuncs.OnPendoloTrigger2 = function()
--	pendolo2:Enable()
	pendolo_flags[2] = true
end

LevelFuncs.OnPendoloTrigger3 = function()
--	pendolo3:Enable()
	pendolo_flags[3] = true
end


LevelFuncs.OnPendoliSequence = function()

	

	local delaypendoli1 = 0.25 -- secondi
	local delaypendoli2 = 1.25 -- secondi
	local pendoloSequence = EventSequence.Create
	    (
	    "pendolo_sequence",  
	    false, -- ff sequence loops then true, if not: false.
	    false, -- in-game timer 
		delaypendoli1,
	    LevelFuncs.OnPendoloTrigger1,
	    delaypendoli2,
	    LevelFuncs.OnPendoloTrigger2,
	    delaypendoli2,
	    LevelFuncs.OnPendoloTrigger3 
	    )
	
	   
	    pendoloSequence:Start()
 

end

-- === FUOCHI CUSTOM DEI PENDOLI ===
local joint_coppa = 5
local offsetFiammaPendolo = Vec3(0, -256, 0)
local forzaFiamma = 32

-- Palette colori pendoli Tinnos
local FlameColorsPendoli = {
    -- Pendolo 1 → azzurro ghiaccio
    { Color(110,180,235,255), Color(0,40,80,0) },

    -- Pendolo 2 → azzurro-violetto intermedio
    { Color(150,140,255,255), Color(40,20,100,0) },

    -- Pendolo 3 → violetto profondo
    { Color(180,100,255,255), Color(60,10,120,0) }
}


-- Funzione che emette le particelle di fiamma dalla coppa del pendolo
function EmitFlameAtLocal(obj, meshIndex, offset, strength, paletteIndex)
    if not obj then return end
    offset   = offset   or Vec3(0,0,0)
    strength = strength or 32
    paletteIndex = paletteIndex or 1

    local colors = FlameColorsPendoli[paletteIndex]
    local base = obj:GetJointPosition(meshIndex, offset)
    local up   = obj:GetJointPosition(meshIndex, offset + Vec3(0,-128,0))
    local dir  = (up - base):Normalize() * strength

    for i=1,8 do
        local jitter = Vec3((math.random()-0.5)*8, (math.random()-0.5)*8, (math.random()-0.5)*8)
        Effects.EmitParticle(
            base,
            dir + jitter,
            math.random(0,1),
            0, 0,
            colors[1], colors[2],
            TEN.Effects.BlendID.ADDITIVE,
            64, 128,
            0.3 + math.random()*0.3,
            true, false,
            Objects.ObjID.DEFAULT_SPRITES,
            0
        )
    end
end



--------------------------------------------------
------------------------------------------------------------------------------------------
-- DIARIO

local CustomDiary = require("Engine.CustomDiary")
CustomDiary.ImportDiary("DiarySetup")
local diary = CustomDiary.Get(TEN.Objects.ObjID.DIARY_ITEM)
--print("Diary object is:", diary)
local sflag = 0



LevelFuncs.OnDiaryIntro = function()

		local pos = Vec2(PercentToScreen(50, 92))
 		local duration = 8.0  

    	local s = DisplayString(
        "Notes added to the diary. Press H to check",
        pos,
        1.0,
        Color(200, 220, 255)  
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true) 
    Sound.PlaySound(1198) -- custom suono notifica
	 

end

LevelFuncs.OnBookExit = function()


	local id_puzzle1 = 500
	local count_puzzle1 = GetItemCount(id_puzzle1)
	
	print("count puzzle", count_puzzle1, "SFLAG", sflag)
 
	if count_puzzle1 == 1 and sflag == 2 then
		diary:UnlockPages(9, false)
		sflag = 3
		
		local pos = Vec2(PercentToScreen(50, 92))
 		local duration = 8.0  

    	local s = DisplayString(
        "Notes added to the diary. Press H to check",
        pos,
        1.0,
        Color(200, 220, 255)  
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true) 
    Sound.PlaySound(1198) -- custom suono notifica
	end

end

LevelFuncs.OnLapislazzuli = function()


		 
 
	 
		diary:UnlockPages(5, false)
		sflag = 1
		
		print("SFLAG Lapislazzuli", sflag)
		
		local pos = Vec2(PercentToScreen(50, 92))
 		local duration = 8.0  

    	local s = DisplayString(
        "Notes added to the diary. Press H to check",
        pos,
        1.0,
        Color(200, 220, 255)  
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true) 
    Sound.PlaySound(1198) -- custom suono notifica
	 

end


LevelFuncs.OnTinnosMonsters = function()


	
 
	 
		diary:UnlockPages(6, false)
		sflag = 2
		
		print("SFLAG TinnosMonsters", sflag)
		
		local pos = Vec2(PercentToScreen(50, 92))
 		local duration = 8.0  

    	local s = DisplayString(
        "Notes added to the diary. Press H to check",
        pos,
        1.0,
        Color(200, 220, 255)  
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true) 
    Sound.PlaySound(1198) -- custom suono notifica
	 

end

------------------------------------------------------------------------------------------


------------------------------------------------------------------------
-- CUSTOM CAMERAS
-- solo per registrare cutscenes
-- camera_279: a muro, frontale
-- camera_280: vicina allo switch, per ripreendere Lara che cammina di fianco ai mosaici

local CameraMalachiaName = "camera_279"    
local CameraMalachia
local CameraMalachiaFlag = false
LevelFuncs.OnCameraMalachia = function()
	CameraMalachiaFlag = false -- metti a true per registrare
end
LevelFuncs.OnCameraMalachiaFalse = function()
	CameraMalachiaFlag = false  
end

 


---------------------------------------------------------------------
-- TESTI LARA

LevelFuncs.OnLaraFaithLeap = function()
    local pos = Vec2(PercentToScreen(50, 86))
    local track = "LaraFaithLeap"
	local duration = AudioDurations[track] or 8.0  -- fallback se manca
--     local duration = 8.0
    local s = DisplayString(
        "Hmm... a saint walking on air between two mountains... flames suspended in the void... \n Looks like this puzzle calls for a leap of faith across invisible platforms",
        pos,
        1.0,
        Color(200, 220, 255) -- bianco
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true)   
    Sound.PlayAudioTrack(track, Sound.SoundTrackType.ONESHOT)
end


--LevelFuncs.OnLaraLapis = function()
--    local pos = Vec2(PercentToScreen(50, 82))
--    local track = "LaraLapis"
--	local duration = AudioDurations[track] or 8.0  -- fallback se manca
--     local duration = 8.0
--    local s = DisplayString(
--        "Another structure with lapis lazuli walls... Clearly this place was once touched by Sumerian hands. \n Brother John Blackarrow was right in his writings: \n the mythical City of Topaz must be far older than the first known civilizations",
--        pos,
--        1.0,
--        Color(200, 220, 255) -- bianco
--    )
--    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
--    Strings.ShowString(s, duration, true)   
--    Sound.PlayAudioTrack(track, Sound.SoundTrackType.ONESHOT)
--end


--LevelFuncs.OnLaraCreatures = function()
--    local pos = Vec2(PercentToScreen(50, 86))
--    local track = "LaraCreatures"
--	local duration = AudioDurations[track] or 8.0  -- fallback se manca
--     local duration = 8.0
--    local s = DisplayString(
--        "Creatures of Tinnos... So Brother John Blackarrow was right once again. \n The building of the City of Topaz must have involved both the people of Tinnos and Atlantis",
--        pos,
--        1.0,
--        Color(200, 220, 255) -- bianco
--    )
--    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
--    Strings.ShowString(s, duration, true)   
--    Sound.PlayAudioTrack(track, Sound.SoundTrackType.ONESHOT)
--end

--------------------------------------------------------------------
-- CUSTOM FLARE

local flare_on = false
local flare_pitch = 0
----------------------------------------------------------------------
-- SWITCH per SHATTER e uscita MINOTAURO

local SwitchNameAlto = "switch_type2_17"
local SW1 
local BoxMinotName = "static_mesh_276"
local BoxMinot

local base_BoxMinot
local base_BoxMinot_x
local base_BoxMinot_z

local CameraBoxMinotName = "camera_277"
local CameraBoxMinot
local BaddyCameraName = "baddy1_278"
local BaddyCamera

local FuocoDopo = Vec3(13824, 256, 18944)
local SizeFuocoDopo = 6
local fire_flag_dopo = false


-- parametri salita box minotauro

local OPEN_DY = -1984       -- offset di apertura: negativo = su
local OPEN_TIME  = 14.0     -- tempo di apertura del portone



local opening = false
local t_open = 0.0

local dust_timer = 0

-- Tremolio
local SHAKE_AMP_Y  = 16    -- ampiezza max tremolio verticale (unità)
local SHAKE_AMP_XZ = 8     -- ampiezza max su X/Z
local SHAKE_UPDATE = 0.07  -- aggiorna target jitter ogni ~0.07s

local shake_timer = 0
local shake_tx, shake_ty, shake_tz = 0, 0, 0   -- target
local shake_x,  shake_y,  shake_z  = 0, 0, 0   -- stato filtrato

local ZampilloPos1 = Vec3(13312, 256, 18432)
local ZampilloPos2 = Vec3(14336, 256, 18432)
local ZampilloPos3 = Vec3(13568, 256, 18432)
local ZampilloPos4 = Vec3(13824, 256, 18432)
local ZampilloPos5 = Vec3(13312, 256, 18944)
local ZampilloPos6 = Vec3(14336, 256, 18944)

local function EmitSparks(pos, strength, n, size0, size1, life)
    strength = strength or 12
    n       = n or 4
    size0   = size0 or 4
    size1   = size1 or 12
    life    = life or (0.2 + math.random()*0.35)
    gravityForThis = 50.0

    for i = 1, n do
        local jitter = Vec3( (math.random()-0.5)*16, (math.random()-0.5)*8, (math.random()-0.5)*16 )
        local vel    = Vec3( (math.random()-0.5)*40, -(strength + math.random()*0.5*strength), (math.random()-0.5)*40 )
        Effects.EmitParticle(
            pos + jitter,
            vel,
            math.random(0,1),
            gravityForThis, 0,  -- gravity/rotVel
            Color(255,240,180,255),   -- chiaro/luccicante
            Color(255,80,20,0),       -- sfuma caldo e trasparente
            TEN.Effects.BlendID.ADDITIVE,
            size0, size1,
            life,
            false, false,
            Objects.ObjID.DEFAULT_SPRITES,
            0
        )
    end
end



 

------------------------------------------------------------------------
-- FUOCHI posizioni e size



---------------------------------------------------------------------
-- FUOCHI in alto
    local pos_fire1 = Vec3(50176, 13184, 67584)
    local pos_fire2 = Vec3(55296, 13184, 67584)
    local pos_fire3 = Vec3(44544, 13184, 67584)

	    local sizell = 12
	    
	    
	    
-- FUOCO su tetto  altare  
    local pos_fire4 = Vec3(50176, 16768, 73216)  

	     local sizeff = 8

			 
			
-- FUOCHI in room1			
			
	 local pos_room1 = Vec3(3584, -2820, 5632)
	 local pos_room2 = Vec3(3584, -2824, 4608)
	 local pos_room3 = Vec3(3584, -2828, 3584)
	 local size_room = 4
	  
	 
	 
-- FUOCHI in room primo topazio			
			
	 local pos_room4 = Vec3(18944, -6848, 25088)
	 local pos_room5 = Vec3(16896, -6848, 25088)
	  
	 local size_room = 4
	  
	 
	 
-- FUOCHI in room secondo e terzo topazio			
			
	 local pos_room6 = Vec3(56832, 576, 36352)
	 local pos_room7 = Vec3(58880, 576, 36352)
	 local pos_room8 = Vec3(58880, 576, 40448)
	 local pos_room9 = Vec3(56832, 576, 40448)
	  
	 local size_room = 4
	  
	  
-- FUOCHI in room CENTAURO boss	
			
	 local pos_room10 = Vec3(18432, 15232, 57856)
	 local pos_room11 = Vec3(21504, 15232, 57856)
	  
	 local size_roomC = 7
	 -- fuochi corridoio
	 local pos_roomR1 = Vec3(23040, 18688, 50688)
	 local pos_roomR2 = Vec3(23040, 18688, 51712)
	 local pos_roomR3 = Vec3(23040, 18688, 52736)
	 local pos_roomR4 = Vec3(23040, 18688, 53760)
	 local pos_roomR5 = Vec3(23040, 18688, 54784)
	 local pos_roomR6 = Vec3(23040, 18688, 55808)
	 
	 local pos_roomL1 = Vec3(16896, 18688, 50688)
	 local pos_roomL2 = Vec3(16896, 18688, 51712)
	 local pos_roomL3 = Vec3(16896, 18688, 52736)
	 local pos_roomL4 = Vec3(16896, 18688, 53760)
	 local pos_roomL5 = Vec3(16896, 18688, 54784)
	 local pos_roomL6 = Vec3(16896, 18688, 55808)
	 
	 local size_roomCORR = 2
	 
-- FUOCHI ARENA MINOTAURO			


 
	 local pos_room12 = Vec3(17920, -896, 17920)  
	 local pos_room13 = Vec3(17920, -896, 10752)
	 local pos_room14 = Vec3(10752, -896, 10752)
	 local pos_room15 = Vec3(10752, -896, 17920)--   
	 local pos_room16 = Vec3(12800, 256, 12800)
     local pos_room17 = Vec3(12800, 256, 15872)
     local pos_room18 = Vec3(15872, 256, 15872)
     local pos_room19 = Vec3(15872, 256, 12800)

	 local size_roomM = 4
	 
	 local pos_roomdiama_1 = Vec3(39424, 18176, 48640)
	 local pos_roomdiama_2 = Vec3(41472, 18176, 48640)
	 local size_roomdiama = 1
	 
	 
-- FUOCO pozza room altare	  
	local pos_fiamme = Vec3(53760, 22272, 64512)  
	local size_roomPA = 7
	
-- FUOCHI tomba Malachia

	 local pos_room20 = Vec3(59904, 28416, 83456)
--	 local pos_room21 = Vec3(62976, 28416, 83456)
--	 local pos_room22 = Vec3(62976, 28416, 80384)
	 local pos_room23 = Vec3(60928, 28416, 80384)
	 local pos_room24 = Vec3(60928, 27520, 78336)
	 local pos_room25 = Vec3(58880, 27520, 78336)
	 local size_roomMALA = 2
	 
	 local lara_tomba = true
	 
LevelFuncs.OnFuochiTombaMalachia = function()
	lara_tomba = true
	 
end
 
--------------------------------------------------------------------------------    
-- POSIZIONI nebbie pozze

local spots_pozze_nebbia = {
    Vec3(53760, 20736, 67072),
    Vec3(46592, 20736, 67072),
    Vec3(43520, 20864, 73216),
}

local timers = {}

-- Sprite ID morbido (scegli tu quello che ti piace: es. 10, 12, 18, 22, 31)
local SMOKE_SPRITE_ID = 1

local function spawnNebbia(pos)
    Effects.EmitFlow(
        pos,           
        Vec3(0, -8, 0),                  -- sale piano
        12,                              -- raggio emissione
        16.5,                             -- vita (secondi) delle particelle
        8,                               -- attrito
        600,                              -- size massimo
        Color(120, 40, 20, 255),          -- colore iniziale  
        Color(60, 20, 10, 0),            -- colore finale  
        Objects.ObjID.DEFAULT_SPRITES,
        SMOKE_SPRITE_ID
    )
    Effects.EmitFlow(
        pos,          
        Vec3(0, -8, 0),                  -- sale piano
        12,                              -- raggio emissione
        16.5,                             -- vita (secondi) delle particelle
        8,                               -- attrito
        600,                              -- size massimo
        Color(128, 0, 0, 255),          -- colore iniziale  
        Color(69, 5, 18, 0),            -- colore finale  
        Objects.ObjID.DEFAULT_SPRITES,
        SMOKE_SPRITE_ID
    )
end

-----------------------------------------------------------------------
-- BLOCCHI INVISIBILI static

local piastrella1
local piastrella2
local piastrella3
local piastrelle_visibili = false

LevelFuncs.OnVisible = function()

	if piastrella1 then piastrella1:Enable() end
    if piastrella2 then piastrella2:Enable() end
    if piastrella3 then piastrella3:Enable() end
    piastrelle_visibili = true

end

LevelFuncs.OnInvisible = function()

	if piastrella1 then piastrella1:Disable() end
    if piastrella2 then piastrella2:Disable() end
    if piastrella3 then piastrella3:Disable() end
    piastrelle_visibili = false

end



-- ==== CONFIG UI GLOBALE (del file) ====
local BLINK_LIMIT   = 0.15   -- soglia in frazione di HP (0–1)
local ALPHA_SPEED   = 35     -- opzionale: stessa velocità di fade per tutte


-- === CONFIG ===
local BOSS_NAME = "demigod1_2"   -- deve coincidere col Lua name in Tomb Editor
local START_HP  = 250           -- HP iniziali del boss

local BOSS_NAME2 = "centaur_mutant_81"   -- deve coincidere col Lua name in Tomb Editor
local START_HP2  = 500           -- HP iniziali del boss

local BOSS_NAME3 = "claw_mutant_126"   -- deve coincidere col Lua name in Tomb Editor
local START_HP3  = 250           -- HP iniziali del boss

local BOSS_NAME4 = "claw_mutant_127"   -- deve coincidere col Lua name in Tomb Editor
local START_HP4  = 250           -- HP iniziali del boss



 


-- helper
local function IsActorAlive(actor_name)
    local m = GetMoveableByName(actor_name)
    if not m or not m:GetValid() then return false end

    return m:GetStatus() == Objects.MoveableStatus.ACTIVE and m:GetHP() > 0
end
-- (GetStatus / MoveableStatus e GetHP sono nella API Moveable.) :contentReference[oaicite:1]{index=1}


-- === IMPORT barra HP ===
local ok, CustomBar = pcall(require, "CustomBar")
if not ok then
    CustomBar = require("Engine.CustomBar") -- fallback se il progetto la tiene in /Engine
end

--------------------------------------------------------------------------------------------------------

-- ===== Ammo HUD universale con Shotgun dettagliato =====

local WEAPON_UI = {
    [Objects.WeaponType.PISTOLS]  = { label = "Pistols",  y = 50,  color = Color(255, 255,   0, 255) },
    [Objects.WeaponType.UZI]      = { label = "Uzi",      y = 70,  color = Color(  0, 200, 255, 255) },
    [Objects.WeaponType.SHOTGUN]  = { label = "Shotgun",  y = 70,  color = Color(255, 100, 100, 255) },
--    [Objects.WeaponType.REVOLVER] = { label = "Revolver", y = 110, color = Color(255, 180,  60, 255) },
}

 

 



--------------------------------------------------------------------------------------------------------
-- EARTHQUAKE
--------------------------------------------------------------------------------------------------------

-- usa Count call = 1 nelle chiamate dal node editor
intensityEQ = 400 
intensityEQsoft = 300

LevelFuncs.OnQuake = function()
    intensity = tonumber(intensityEQ)  
    Effects.MakeEarthquake(intensityEQ)
--    Sound.PlaySound(359)                 -- rumble SFX  
end
LevelFuncs.OnQuakeSound = function()  
    Sound.PlayAudioTrack("eql", Sound.SoundTrackType.ONESHOT)
end

LevelFuncs.OnQuakeSOFT = function()
    intensity = tonumber(intensityEQsoft)  
    Effects.MakeEarthquake(intensityEQsoft)
--    Sound.PlaySound(359)                 -- rumble SFX  
end
LevelFuncs.OnQuakeSoundSOFT = function()  
    Sound.PlayAudioTrack("eqs", Sound.SoundTrackType.ONESHOT)
end
 

---------------------------------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- FUNCTION di fine livello per statistiche
-- da matchare con blocco in OnLoop e in OnFreeze

local level_time = 0 -- per timer
                     -- inizializzato in OnStart, aggiornato in OnLoop(dt), salvato e riletto in OnSave e OnLoad
local stats_active = false
local function ShowStatsHUD()

	stats_active = true
    Flow.SetFreezeMode(Flow.FreezeMode.FULL)
    Input.ClearAllKeys()
    
    -- MUSIC STATS
	local statsMusic = "datr3finelivello"   
	local ttFINE = Sound.SoundTrackType.ONESHOT
	Sound.PlayAudioTrack(statsMusic, ttFINE)
    
    local lvl = Flow.GetCurrentLevel()
	local levelName = Flow.GetString(lvl.nameKey)

	
    local stats = Flow.GetStatistics()

    -- tempo HH:MM:SS da level_time
    local lt = level_time or 0
    local h = math.floor(lt / 3600)
    local m = math.floor((lt % 3600) / 60)
    local s = math.floor(lt % 60)
    local time_str = string.format("%02d:%02d:%02d", h, m, s)

    -- segreti livello / gioco
    local lvl = Flow.GetCurrentLevel()
    local secrets_level_total  = (lvl and lvl.secrets) and tonumber(lvl.secrets) or 0
    local secrets_level_found  = tonumber(stats.secrets)  or 0
    local secrets_game_found   = tonumber(Flow.GetSecretCount())     or 0
    local secrets_game_total   = tonumber(Flow.GetTotalSecretCount()) or 0

    local kills    = tonumber(stats.kills)    or 0
    local ammoUsed = tonumber(stats.ammoUsed) or 0

    -- posizioni
    local pos_levname = Vec2(PercentToScreen(50, 47))
    local pos_title = Vec2(PercentToScreen(50, 55))
	
	local pos_line  = Vec2(PercentToScreen(50, 63))
    local pos_stats = Vec2(PercentToScreen(50, 70))

    -- titolo
    
    local tempoEsposizione = 300
    
    local levName = DisplayString(levelName, pos_levname, 1.2, Color(165,42,42))
    levName:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(levName, tempoEsposizione, true)
    
    local title = DisplayString("Statistics", pos_title, 1.2, Color(150, 200, 255))
    title:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(title, tempoEsposizione, true)
    
    

    -- separatore ASCII (niente Unicode)
    local sep = DisplayString("========================", pos_line, 1.0, Color(150, 200, 255))
    sep:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(sep, tempoEsposizione, true)

    -- blocco dettagli
    local text = string.format(
        "Time: %s\nSecrets: %d/%d (%d/%d)\nKills: %d\nAmmo used: %d",
        time_str,
        secrets_level_found, secrets_level_total,
        secrets_game_found,  secrets_game_total,
        kills, ammoUsed
    )

    local sstr = DisplayString(text, pos_stats, 1.0, Color(200, 220, 255))
    sstr:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(sstr, tempoEsposizione, true)
end

LevelFuncs.OnFineLivello = function()
	ShowStatsHUD()
end
-----------------------------------------------------------------------------------------------------------


------------------------------------------------------------------------------



--
-- --------------------
-- ==== SOUNDTRACK ====
-- --------------------
-- I file audio vanno nella cartella Engine/Audio del progetto, salvati in formato ogg.

-- Array di flags per la soundtrack del livello
-- Un flag per ogni brano, da cambiare da false a true dopo che il brano è estato eseguito, per evitare
-- che il brano riparta se si ripassa nel volume
-- Stato persistente per le musiche "suona-una-volta"
MusicOnce = MusicOnce or {}
local function PlayOnce(track_name, loop, key)
    key = key or track_name
    if MusicOnce[key] then return end
    local tt = loop and Sound.SoundTrackType.LOOPED or Sound.SoundTrackType.ONESHOT
    Sound.PlayAudioTrack(track_name, tt)
    MusicOnce[key] = true
end


 

LevelFuncs.OnMusicEPIC34 = function()
     PlayOnce("epic34_2", false, "EPIC34")
end


LevelFuncs.OnMusicDRUMS = function()
    PlayOnce("drums", false, "DRUMS")
end
 
 

 
LevelFuncs.OnMusicVIOLIN = function()
    PlayOnce("violin", false, "VIOLIN")
end


LevelFuncs.OnMusicAIDAWN = function()
    PlayOnce("aidawn", false, "AIDAWN")
    
end


LevelFuncs.OnMusicAPOS = function()
    PlayOnce("apos", false, "APOS")
    
end

LevelFuncs.OnMusicAPOL = function()
    PlayOnce("apolong", false, "APOLONG")
    
end


LevelFuncs.OnMusicCAMERA1 = function()
--    if IsActorAlive("bat_246") then
        PlayOnce("percamerasu1", false, "CAMERA1")
--    end
end

LevelFuncs.OnMusicSTANZATOPAZIO = function()
--    if IsActorAlive("bat_252") then
        PlayOnce("letthemystery", false, "STANZATOPAZIO")
  --  end
end

LevelFuncs.OnMusicSTANZATOPAZIOexit = function()
    if IsActorAlive("bat_254") then
        PlayOnce("enchanted", false, "STANZATOPAZIOEXIT")
    end
end

LevelFuncs.OnMusicCAVERNADOPOMINO = function()
--    if IsActorAlive("bat_255") then
		local ttwrai = Sound.SoundTrackType.ONESHOT
		local TrackNameWrai = "052" 
        Sound.PlayAudioTrack(TrackNameWrai, ttwrai)
--    end
end

LevelFuncs.OnMusicMYSTERY70 = function()
--    if IsActorAlive("bat_256") then
        PlayOnce("mystery70", false, "MYSTERY70")
  --  end
end

LevelFuncs.OnMusicDARKMYSTERY = function()
--    if IsActorAlive("bat_258") then
        PlayOnce("darkmystery", false, "DARKMYSTERY")
--    end
end


LevelFuncs.OnMusicSECRET3 = function()
  --  if IsActorAlive("bat_260") then
        PlayOnce("inspi", false, "SECRET3")
   -- end
end

LevelFuncs.OnMusicENTRATAMAIN = function()
 --   if IsActorAlive("bat_263") then
        PlayOnce("scaryhorror", false, "ENTRATAMAIN")
  --  end
end

LevelFuncs.OnMusicPORTEAPERTE = function()
--    if IsActorAlive("bat_267") then
        PlayOnce("scaryhorrormusic", false, "PORTEAPERTE")
--    end
end

LevelFuncs.OnMusicTOPOF = function()
--    if IsActorAlive("bat_270") then
        PlayOnce("unity30sec", false, "TOPOF")
  --  end
end

LevelFuncs.OnMusicBADDY = function()
    if IsActorAlive("baddy2_241") then
        PlayOnce("049", false, "BADDY")
    end
end



LevelFuncs.OnMusicPIZZICATOENERGY = function()
    PlayOnce("pizzicatoenergy", false, "PIZZICATOENERGY")
    
end


LevelFuncs.OnMusicPICKUP = function()
    PlayOnce("simplicity", false, "KEY055")
    
end


LevelFuncs.OnMusicNUOTATALUNGA = function()
    PlayOnce("nuotatalunga", false, "NUOTATALUNGA")
    
end


LevelFuncs.OnMusicCLAWMUTANTfinale = function()
--     
	    TEN.Objects.GetMoveableByName("claw_mutant_204"):Enable()
         
--     
end

LevelFuncs.OnMusicEPICGLITCH30 = function()
        if IsActorAlive("bat_294") then
        PlayOnce("epicglitch30", false, "EPICGLITCH30")
        end
end


LevelFuncs.OnMusicCENTAURBOSS = function()
    if IsActorAlive("centaur_mutant_81") then
        PlayOnce("heroestour", false, "CENTAURBOSS")
    end
end


LevelFuncs.OnMusicWINGEDMUMMY = function()
    if IsActorAlive("winged_mummy_82") then
        PlayOnce("scarysoundhorror", false, "WINGEDMUMMY")
    end
end

local video_active = false
local video_name = "permalachianuovo25fps"
LevelFuncs.OnMusicMALA = function()
	video_active = true
    View.PlayVideo(video_name)
   
--   local poslaraafter = Vec3(59904, 28416, 83456)
--   Lara:SetPosition(poslaraafter)
end

 

---------------------------------------------------------------------------------------------------


-- Helper sicuro per mostrare/nascondere le barre senza errori a log
local function hide_bar_safe(name, hidden)
    if CustomBar and CustomBar.HideBar then
        CustomBar.HideBar(name, hidden)
    elseif CustomBar and CustomBar.SetBarHidden then
        -- fallback per build in cui l'API abbia nome diverso
        CustomBar.SetBarHidden(name, hidden)
    else
        -- no-op: niente log di errore
    end
end



-- === Handlers colpo boss (definite a livello file) ===
LevelFuncs.OnBossHit = function(hitObj)
    local hpBefore = hitObj:GetHP()
    hitObj:SetHP(math.max(0, hpBefore - 1))
    print(("[Boss.lua] OnHit -> HP: %d -> %d"):format(hpBefore, hitObj:GetHP()))
end




-- ====== PRIMO BOSS: minotauro ======


local lastHP = nil
local boss   = nil

-------------------------------------------------------------------



-- === VOLUME → MUSICA SE BOSS1 SPAWNED ===
-- Nota: questa sezione va dopo "local boss = nil" del Boss1

-- Ritorna true se il boss1 esiste già in scena e non è morto
-- Sostituisci la vecchia is_boss1_spawned_alive() con questa
local function is_boss1_spawned_alive()
    local b = TEN.Objects.GetMoveableByName(BOSS_NAME)
    if not b or (b.GetValid and not b:GetValid()) then return false end
    -- FIX principale: deve essere attivo (triggerato), non solo “esistente”
    if b.GetActive and not b:GetActive() then return false end
    -- Ulteriore guardia (facoltativa ma utile):
    if b.GetStatus and b:GetStatus() ~= TEN.Objects.MoveableStatus.ACTIVE then return false end
    local hp = (b.GetHP and b:GetHP()) or 0
    return hp > 0
end


-- Da collegare al volume (On Enter) nel Node Editor
LevelFuncs.OnVolume_Boss1_Music = function()
    if is_boss1_spawned_alive() then
        -- Usa la function che suona la musica 
         
        LevelFuncs.OnMusicAPOS()
         
    end
end



--------------------------------------------------------------------

-- === STATE & BARRIERA (solo barra, no death logic) ===
local bar_created  = false
local bar_shown    = false
local tile_ok_once = false  -- diventa true una volta e resta tale

local function update_bar_visibility()
    if bar_shown then return end
    if not CustomBar then return end

    boss = boss or TEN.Objects.GetMoveableByName(BOSS_NAME)
    if not boss then return end

    if tile_ok_once then
        if not bar_created then
            -- payload completo (come nel backup) + showBar=false per evitare flicker
            local bgPos  = TEN.Vec2(50, 92)
            local bgSize = TEN.Vec2(40, 3)
            local leftX  = bgPos.x - (bgSize.x / 2)

            CustomBar.CreateEnemyHpBar({
                barName      = "boss_hp",
                object       = BOSS_NAME,

                objectIdBg   = TEN.Objects.ObjID.DIARY_SPRITES,
                spriteIdBg   = 1,
                colorBg      = TEN.Color(0, 0, 0),
                posBg        = bgPos,
                rotBg        = 0,
                scaleBg      = bgSize,
                alignModeBg  = TEN.View.AlignMode.CENTER,
                scaleModeBg  = TEN.View.ScaleMode.STRETCH,
                blendModeBg  = TEN.Effects.BlendID.ALPHABLEND,

                objectIdBar  = TEN.Objects.ObjID.DIARY_SPRITES,
                spriteIdBar  = 1,
                colorBar     = TEN.Color(0, 160, 255),
                posBar       = TEN.Vec2(leftX, bgPos.y),
                rot          = 0,
                scaleBar     = TEN.Vec2(bgSize.x - 2, bgSize.y - 1),
                alignMode    = TEN.View.AlignMode.CENTER_LEFT,
                scaleMode    = TEN.View.ScaleMode.STRETCH,
                blendMode    = TEN.Effects.BlendID.ALPHABLEND,

                hideText     = true,
                alphaBlendSpeed = ALPHA_SPEED,
                blink        = true,
                blinkLimit   = BLINK_LIMIT,
                showBar      = false
            })
            bar_created = true
            print("[Boss.lua] Boss bar created (hidden).")
        end

--        if CustomBar.HideBar then
--            CustomBar.HideBar("boss_hp", false) -- mostra
--        end

        hide_bar_safe("boss_hp", false)


        bar_shown = true
        print("[Boss.lua] Boss bar shown.")
    end
end


-- chiamata dal volume SOLO all’ingresso della tile
LevelFuncs.OnBossTileEnter = function()


    if not fire_flag_dopo then
        Sound.PlaySound(1199)
    end

	fire_flag_dopo = true

	if BoxMinot then
        
        BoxMinot:Shatter()
    else
        print("ATTENZIONE: BoxMinot non trovato!")
    end

    tile_ok_once = true


    if is_boss1_spawned_alive() then
        -- Usa la function che suona la musica 
         
        LevelFuncs.OnMusicAPOS()
         
    end

    update_bar_visibility()
    
end


 

-- ====== SECONDO BOSS: stato ======
local lastHP2 = nil
local boss2   = nil

local bar_created2  = false
local bar_shown2    = false
local tile_ok_once2 = false


local function try_bind_boss2()
    if boss2 then return end
    boss2 = TEN.Objects.GetMoveableByName(BOSS_NAME2)
    if boss2 then
        if START_HP2 and START_HP2 > 0 then boss2:SetHP(START_HP2) end
        LevelFuncs.OnBoss2Hit = function(hitObj)
            local hpBefore = hitObj:GetHP()
            hitObj:SetHP(hpBefore - 1)
            print(("[Boss.lua] OnHit2 -> HP: %d -> %d"):format(hpBefore, hitObj:GetHP()))
        end
        boss2:SetOnHit(LevelFuncs.OnBossHit)
        lastHP2 = boss2:GetHP()
        print("[Boss.lua] Boss2 bind OK, HP:", lastHP2)
        if tile_ok_once2 then update_bar_visibility2() end
    end
end


-- ====== SECONDO BOSS: barra ======
local function update_bar_visibility2()

    local BLACK_BG  = TEN.Color(0, 0, 0)    -- bordo/incorniciatura
    local ORANGE_BAR = TEN.Color(255, 190, 30)  -- arancione brillante



    if bar_shown2 then return end
    if not CustomBar then return end

    boss2 = boss2 or TEN.Objects.GetMoveableByName(BOSS_NAME2)
    if not boss2 then return end

    if tile_ok_once2 then
        if not bar_created2 then
            -- posizione leggermente più in basso per non sovrapporsi alla prima
            local bgPos  = TEN.Vec2(50, 92)  
            local bgSize = TEN.Vec2(40, 3)
            local leftX  = bgPos.x - (bgSize.x / 2)

            CustomBar.CreateEnemyHpBar({
                barName      = "boss_hp2",
                object       = BOSS_NAME2,

                objectIdBg   = TEN.Objects.ObjID.DIARY_SPRITES,
                spriteIdBg   = 1,
                colorBg      = BLACK_BG,
                posBg        = bgPos,
                rotBg        = 0,
                scaleBg      = bgSize,
                alignModeBg  = TEN.View.AlignMode.CENTER,
                scaleModeBg  = TEN.View.ScaleMode.STRETCH,
                blendModeBg  = TEN.Effects.BlendID.ALPHABLEND,

                objectIdBar  = TEN.Objects.ObjID.DIARY_SPRITES,
                spriteIdBar  = 1,
                colorBar     = ORANGE_BAR,
                posBar       = TEN.Vec2(leftX, bgPos.y),
                rot          = 0,
                scaleBar     = TEN.Vec2(bgSize.x - 2, bgSize.y - 1),
                alignMode    = TEN.View.AlignMode.CENTER_LEFT,
                scaleMode    = TEN.View.ScaleMode.STRETCH,
                blendMode    = TEN.Effects.BlendID.ALPHABLEND,

                hideText     = true,
                alphaBlendSpeed = ALPHA_SPEED,
                blink        = true,
                blinkLimit   = BLINK_LIMIT,
                showBar      = false
            })
            bar_created2 = true
            print("[Boss.lua] Boss2 bar created (hidden).")
        end

--        if CustomBar.HideBar then
--            CustomBar.HideBar("boss_hp2", false)
--        end


         hide_bar_safe("boss_hp2", false)


        bar_shown2 = true
        print("[Boss.lua] Boss2 bar shown.")
    end
end

-- Evento volumetrico dedicato al secondo boss
LevelFuncs.OnBossTileEnter2 = function()
    tile_ok_once2 = true
    print("[Boss.lua] OnBossTileEnter2 fired")
    update_bar_visibility2()
end





-- UI positions (una sopra l’altra, visibili)
local UI_Y3 = 92
local UI_Y4 = 84

-- Colori (bordo nero + barra verde / rossa brillante)
local BLACK_BG    = TEN.Color(0, 0, 0)
local GREEN_BAR   = TEN.Color(30, 200, 80)   -- smeraldo
local BLUE_BAR     = TEN.Color(0, 128, 255)   

-- ====== BOSS 3: stato ======
local lastHP3, boss3 = nil, nil
local bar_created3, bar_shown3, tile_ok_once3 = false, false, false

-- ====== BOSS 4: stato ======
local lastHP4, boss4 = nil, nil
local bar_created4, bar_shown4, tile_ok_once4 = false, false, false


-- ====== BOSS 3: bootstrap barra (no show qui) ======
local function update_bar_visibility3()
    if not CustomBar then return end
    if bar_created3 then return end
    if not tile_ok_once3 then return end
    boss3 = boss3 or TEN.Objects.GetMoveableByName(BOSS_NAME3)
    if not boss3 then return end
    ensure_bar3()     -- crea la barra se manca (resta nascosta)
    -- NON toccare bar_shown3: il toggle contestuale in OnLoop gestisce show/hide
end

-- ====== BOSS 4: bootstrap barra (no show qui) ======
local function update_bar_visibility4()
    if not CustomBar then return end
    if bar_created4 then return end
    if not tile_ok_once4 then return end
    boss4 = boss4 or TEN.Objects.GetMoveableByName(BOSS_NAME4)
    if not boss4 then return end
    ensure_bar4()
    -- idem: niente show qui
end



local function try_bind_boss3()
    if boss3 then return end
    boss3 = TEN.Objects.GetMoveableByName(BOSS_NAME3)
    if boss3 then
        if START_HP3 and START_HP3 > 0 then boss3:SetHP(START_HP3) end
        LevelFuncs.OnBoss3Hit = function(hitObj)
            hitObj:SetHP(math.max(0, hitObj:GetHP() - 1))
        end
        boss3:SetOnHit(LevelFuncs.OnBossHit)
        lastHP3 = boss3:GetHP()
        if tile_ok_once3 then ensure_bar3() end
    end
end

local function try_bind_boss4()
    if boss4 then return end
    boss4 = TEN.Objects.GetMoveableByName(BOSS_NAME4)
    if boss4 then
        if START_HP4 and START_HP4 > 0 then boss4:SetHP(START_HP4) end
        LevelFuncs.OnBoss4Hit = function(hitObj)
            hitObj:SetHP(math.max(0, hitObj:GetHP() - 1))
        end
        boss4:SetOnHit(LevelFuncs.OnBossHit)
        boss4:SetOnKilled(LevelFuncs.Boss4Killed)   -- <-- spostato qui
        if tile_ok_once4 then ensure_bar4() end
    end
end



local function ensure_bar3()
    if bar_created3 or not CustomBar then return end
    local bgPos  = TEN.Vec2(50, UI_Y3)
    local bgSize = TEN.Vec2(42, 4)
    local leftX  = bgPos.x - (bgSize.x / 2)

    CustomBar.CreateEnemyHpBar({
        barName      = "boss_hp3",
        object       = BOSS_NAME3,

        objectIdBg   = TEN.Objects.ObjID.DIARY_SPRITES,
        spriteIdBg   = 1,
        colorBg      = BLACK_BG,
        posBg        = bgPos,
        rotBg        = 0,
        scaleBg      = bgSize,
        alignModeBg  = TEN.View.AlignMode.CENTER,
        scaleModeBg  = TEN.View.ScaleMode.STRETCH,
        blendModeBg  = TEN.Effects.BlendID.ALPHABLEND,

        objectIdBar  = TEN.Objects.ObjID.DIARY_SPRITES,
        spriteIdBar  = 1,
        colorBar     = GREEN_BAR,
        posBar       = TEN.Vec2(leftX, bgPos.y),
        rot          = 0,
        scaleBar     = TEN.Vec2(bgSize.x - 2, bgSize.y - 1),
        alignMode    = TEN.View.AlignMode.CENTER_LEFT,
        scaleMode    = TEN.View.ScaleMode.STRETCH,
        blendMode    = TEN.Effects.BlendID.ALPHABLEND,

        hideText        = true,
        alphaBlendSpeed = ALPHA_SPEED,
        blink           = true,
        blinkLimit      = BLINK_LIMIT,
        showBar         = false   -- <-- IMPORTANTISSIMO: la mostriamo in OnLoop
    })
    bar_created3 = true
end

local function ensure_bar4()
    if bar_created4 or not CustomBar then return end
    local bgPos  = TEN.Vec2(50, UI_Y4)
    local bgSize = TEN.Vec2(42, 4)
    local leftX  = bgPos.x - (bgSize.x / 2)

    CustomBar.CreateEnemyHpBar({
        barName      = "boss_hp4",
        object       = BOSS_NAME4,

        objectIdBg   = TEN.Objects.ObjID.DIARY_SPRITES,
        spriteIdBg   = 1,
        colorBg      = BLACK_BG,
        posBg        = bgPos,
        rotBg        = 0,
        scaleBg      = bgSize,
        alignModeBg  = TEN.View.AlignMode.CENTER,
        scaleModeBg  = TEN.View.ScaleMode.STRETCH,
        blendModeBg  = TEN.Effects.BlendID.ALPHABLEND,

        objectIdBar  = TEN.Objects.ObjID.DIARY_SPRITES,
        spriteIdBar  = 1,
        colorBar     = BLUE_BAR,
        posBar       = TEN.Vec2(leftX, bgPos.y),
        rot          = 0,
        scaleBar     = TEN.Vec2(bgSize.x - 2, bgSize.y - 1),
        alignMode    = TEN.View.AlignMode.CENTER_LEFT,
        scaleMode    = TEN.View.ScaleMode.STRETCH,
        blendMode    = TEN.Effects.BlendID.ALPHABLEND,

        hideText        = true,
        alphaBlendSpeed = ALPHA_SPEED,
        blink           = true,
        blinkLimit      = BLINK_LIMIT,
        showBar         = false
    })
    bar_created4 = true
end

-------------------------------------------------------------------------------------
-- le lascio come memoir ma non sono più usate
-- sono sostituite dalla LevelFuncs.OnBossTinnos
LevelFuncs.OnBossTileEnter3 = function()
	TEN.Objects.GetStaticByName("static_mesh_353"):Shatter()
	TEN.Objects.GetMoveableByName("claw_mutant_126"):Enable()
    tile_ok_once3 = true
    ensure_bar3()   -- crea subito la barra (nascosta) se il boss esiste
end

LevelFuncs.OnBossTileEnter4 = function()
	TEN.Objects.GetStaticByName("static_mesh_354"):Shatter()
	TEN.Objects.GetMoveableByName("claw_mutant_127"):Enable()
    tile_ok_once4 = true
    ensure_bar4()
end
---------------------------------------------------------------------------
--  enabling dei boss di Tinnos finali

local flagTinnosBoss = false
LevelFuncs.OnBossTinnos = function()
	local track_name = "apos"
	local tt = Sound.SoundTrackType.ONESHOT
	Sound.PlaySound(1199)
	Sound.PlayAudioTrack(track_name, tt)
	
	TEN.Objects.GetStaticByName("static_mesh_353"):Shatter()
	TEN.Objects.GetMoveableByName("claw_mutant_126"):Enable()
    tile_ok_once3 = true
    ensure_bar3()
    
    TEN.Objects.GetStaticByName("static_mesh_354"):Shatter()
	TEN.Objects.GetMoveableByName("claw_mutant_127"):Enable()
    tile_ok_once4 = true
    ensure_bar4()
    
    flagTinnosBoss = true
    
end

local function fuochiBossTinnos()
	local posfuoc1 = Vec3(48640, 19072, 68096)
	local posfuoc2 = Vec3(51712, 19072, 68096)
	local stren = 3
	local ilab1 = 1455
	local ilab2 = 1456
	if flagTinnosBoss then
		EmitFuocoMio(posfuoc1, stren, ilab1)
		EmitFuocoMio(posfuoc2, stren, ilab2)
	end
end
 
------------------------------------------------------------------------------------------ 

LevelFuncs.OnLoad = function()

--	flag_fuochi_cameraalta = LevelVars.flag_fuochi_cameraalta or false

--	tile_ok_once = LevelVars.tile_ok_once or false
--	tile_ok_once2 = LevelVars.tile_ok_once2 or false
--	tile_ok_once3 = LevelVars.tile_ok_once3 or false
  --  tile_ok_once4 = LevelVars.tile_ok_once4 or false
  
  flagTinnosBoss = LevelVars.flagTinnosBoss or false



 tPendolo = LevelVars.tPendolo or 0.0

-------------------------------------------------
-- PORTA INTERMEZZA

 
flagPortaIntermezza = LevelVars.flagPortaIntermezza or false
---------------------------------------------------------------------
-- FLAG archi 

	flagArchi = LevelVars.flagArchi or false
	timeArchi = LevelVars.timeArchi or 0.0
	flagSpegniArcoLetale = LevelVars.flagSpegniArcoLetale or false
	flagFuocoTinnos = LevelVars.flagFuocoTinnos or false
	flagArchiStdby = LevelVars.flagArchiStdby or true

--------------------------------------------------------------------
-- PENDOLI TINNOS

	InizializzaPendoli()
	
	pendolo_flags = LevelVars.pendolo_flags or {false,false,false}
	
-------------------------------------------------------------------
-- PORTONI TINNOS
	InizializzaPorteTinnos()

    flag_camera_minotauro = LevelVars.flag_camera_minotauro or false
    TinnosPorteFlag = LevelVars.TinnosPorteFlag or false
    Boss3Set = LevelVars.Boss3Set or false
    Boss4Set = LevelVars.Boss4Set or false
    
    
     
 


-------------------------------------------------------------------------------
-- piastrelle invisibili

	piastrella1 = TEN.Objects.GetStaticByName("static_mesh_273")
	piastrella2 = TEN.Objects.GetStaticByName("static_mesh_274")
	piastrella3 = TEN.Objects.GetStaticByName("static_mesh_275")
	
	piastrelle_visibili = LevelVars.piastrelle_visibili or false
	
	if piastrella1 and not piastrelle_visibili then
        piastrella1:Disable()   
    end
    if piastrella2 and not piastrelle_visibili then
        piastrella2:Disable()   
    end
    if piastrella3 and not piastrelle_visibili then
        piastrella3:Disable()   
    end
    
    
-------------------------------------------------------------------------------
-- timer per emissione nebbia

for i=1,#spots_pozze_nebbia do
    timers[i] = math.random(120, 240)
end


-------------------------------------------------------------------------------
-- box minotauro

     SW1 = TEN.Objects.GetMoveableByName(SwitchNameAlto)
     BoxMinot = TEN.Objects.GetStaticByName(BoxMinotName)


     
--        base_BoxMinot = BoxMinot:GetPosition().y
        base_BoxMinot_x = BoxMinot:GetPosition().x
        base_BoxMinot_z = BoxMinot:GetPosition().z
    
    CameraBoxMinot = TEN.Objects.GetCameraByName(CameraBoxMinotName)
    BaddyCamera = TEN.Objects.GetMoveableByName(BaddyCameraName)
    
    
    opening = LevelVars.opening or false
    t_open  = LevelVars.t_open  or 0.0
    
    if BoxMinot and LevelVars.BoxMinot_y then
	    base_BoxMinot = LevelVars.BoxMinot_y - OPEN_DY * (t_open / OPEN_TIME)
	end

 
--------------------------------- 

    -- Boss1
    boss = TEN.Objects.GetMoveableByName(BOSS_NAME)
    if boss then
        boss:SetOnHit(LevelFuncs.OnBossHit)
        lastHP = boss:GetHP()
        print("[Boss.lua] OnLoad: re-hook OnHit Boss1, HP:", lastHP)
    end

    -- Boss2
    boss2 = TEN.Objects.GetMoveableByName(BOSS_NAME2)
    if boss2 then
        boss2:SetOnHit(LevelFuncs.OnBossHit)
        lastHP2 = boss2:GetHP()
        print("[Boss.lua] OnLoad: re-hook OnHit Boss2, HP:", lastHP2)
    end

    -- Boss3
    boss3 = TEN.Objects.GetMoveableByName(BOSS_NAME3)
    if boss3 then
        boss3:SetOnHit(LevelFuncs.OnBossHit)
        lastHP3 = boss3:GetHP()
        print("[Boss.lua] OnLoad: re-hook OnHit Boss3, HP:", lastHP3)
        if tile_ok_once3 then ensure_bar3() end
    end

    -- Boss4
    boss4 = TEN.Objects.GetMoveableByName(BOSS_NAME4)
    if boss4 then
        boss4:SetOnHit(LevelFuncs.OnBossHit)
        lastHP4 = boss4:GetHP()
        print("[Boss.lua] OnLoad: re-hook OnHit Boss4, HP:", lastHP4)
        if tile_ok_once4 then ensure_bar4() end
    end


	level_time = LevelVars.level_time or 0 -- per timer statistiche
	
	flare_on = LevelVars.flare_on or false
	flare_pitch = LevelVars.flare_pitch or 0
 
 
-----------------------------------------------------
-- CAMERE per CUTSCENES

CameraMalachia = TEN.Objects.GetCameraByName(CameraMalachiaName)
CameraMalachiaFlag = LevelVars.CameraMalachiaFlag or false

sflag = LevelVars.sflag or 0


 

end  -- end OnLoad



 




local logo 


LevelFuncs.OnStart = function()

--------------------------------------------------------
-- PER PROVE, da rimuovere in release
--Inventory.SetItemCount(501, 2) -- puzzle item 2
--Inventory.SetItemCount(503, 2)
--TEN.Objects.GetMoveableByName("door_type8_23"):Enable()
--TEN.Objects.GetMoveableByName("door_type8_357"):Enable()
 
--TEN.Objects.GetMoveableByName("door_type9_355"):Enable()
--TEN.Objects.GetMoveableByName("door_type9_353"):Enable()
--TEN.Objects.GetMoveableByName("door_type9_125"):Enable()
--TEN.Objects.GetMoveableByName("door_type8_217"):Enable()
--TEN.Objects.GetMoveableByName("door_type8_216"):Enable()
 
 


----------------------------------------------------------------

----------------------------------------------------------------------------------
-- RESETTA HP LARA se si arriva da Crypt

	Lara:SetHP(1000)
 
--  logo = TEN.DisplaySprite(
--    1354,--Objects.ObjID.DEFAULT_SPRITES, -- objectID (sequenza sprite)
--    12,                            -- index nella sequenza
--    Vec2(50, 50),                  -- pos in percento (x=50%, y=50%)
--    0.0,                           -- rot in gradi
--    Vec2(50, 50),                  -- scale in percento (w=50%, h=50%)
--    Color(255,255,255,255)         -- colore (facoltativo)
--  )
   
------------------------------------------------------------
-- PORTA INTERMEZZA



diary:UnlockPages(4,false)  -- sblocca fino alla pagina 4

--------------------------------------------------------------------
-- PENDOLI TINNOS

	InizializzaPendoli()
	
-------------------------------------------------------------------
-- PORTONI TINNOS	
	InizializzaPorteTinnos()


-----------------------------------------------------
-- CAMERE per CUTSCENES

CameraMalachia = TEN.Objects.GetCameraByName(CameraMalachiaName)

-- azzera flare
	Inventory.SetItemCount(983, 0)
--Inventory.SetItemCount(954, 1) -- shotgun per recording
--Inventory.SetItemCount(503, 2) -- seraphs per recording

-- inventario shotgun e medikit
	Inventory.SetItemCount(954, 1)	   -- shotgun 
	Inventory.SetItemCount(955, 6)    -- cartucce rosse
	Inventory.SetItemCount(956, 0)    -- cartucce blu
	Inventory.SetItemCount(978, 1)    -- medikit grande
	Inventory.SetItemCount(979, 4)    -- medikit piccolo


----------------------------------------------------------------------------------------------------------
-- SET LARA's WEAPONS and shows the shotgun in game even if not active

	Lara:SetWeaponType(WeaponType.SHOTGUN, false)
    Lara:SetWeaponType(WeaponType.PISTOLS, false)
 
-------------------------------------------------------------------------------------------

	level_time = 0      -- inizio timer per statistiche
	
	
------------------------------------------------------------------------------------------	
-- BOX MINOTAURO
     SW1 = TEN.Objects.GetMoveableByName(SwitchNameAlto)
     BoxMinot = TEN.Objects.GetStaticByName(BoxMinotName)


     
        base_BoxMinot = BoxMinot:GetPosition().y
        base_BoxMinot_x = BoxMinot:GetPosition().x
        base_BoxMinot_z = BoxMinot:GetPosition().z
    
    CameraBoxMinot = TEN.Objects.GetCameraByName(CameraBoxMinotName)
    BaddyCamera = TEN.Objects.GetMoveableByName(BaddyCameraName)

-------------------------------------------------------------------------------------------

    boss = TEN.Objects.GetMoveableByName(BOSS_NAME)
    if boss then
        boss:SetHP(START_HP)
        print(("[Boss.lua] '%s' HP iniziali: %d"):format(BOSS_NAME, START_HP))

        

        -- hook OnHit
        
        boss:SetOnHit(LevelFuncs.OnBossHit)

--        boss:SetOnKilled(function(obj)
--            print("[Boss.lua] KILLED (anim:", obj:GetAnim(), ")")
--        end)

        lastHP = boss:GetHP()
    else
        print("[Boss.lua] Boss non ancora presente, barra non creata.")
    end



    -- ===== Boss 2 (nuovo) =====
    boss2 = TEN.Objects.GetMoveableByName(BOSS_NAME2)
    if boss2 then
        boss2:SetHP(START_HP2)
        print(("[Boss.lua] '%s' HP iniziali: %d"):format(BOSS_NAME2, START_HP2))

         
        boss2:SetOnHit(LevelFuncs.OnBossHit)

 

        lastHP2 = boss2:GetHP()
    else
        print("[Boss.lua] Boss2 non ancora presente, barra2 non creata.")
    end




        -- ===== Boss 3 =====
    boss3 = TEN.Objects.GetMoveableByName(BOSS_NAME3)
    if boss3 then
        boss3:SetHP(START_HP3)
        print(("[Boss.lua] '%s' HP iniziali: %d"):format(BOSS_NAME3, START_HP3))

         
        boss3:SetOnHit(LevelFuncs.OnBossHit)

        -- opzionale: solo log
--        boss3:SetOnKilled(function(obj)
--            print("[Boss.lua] BOSS3 KILLED (anim:", obj:GetAnim(), ")")
--        end)

        lastHP3 = boss3:GetHP()
    else
        print("[Boss.lua] Boss3 non ancora presente, barra3 non creata.")
    end

    -- ===== Boss 4 =====
    boss4 = TEN.Objects.GetMoveableByName(BOSS_NAME4)
    if boss4 then
        boss4:SetHP(START_HP4)
        print(("[Boss.lua] '%s' HP iniziali: %d"):format(BOSS_NAME4, START_HP4))

         
        boss4:SetOnHit(LevelFuncs.OnBossHit)

--        boss4:SetOnKilled(function(obj)
--            print("[Boss.lua] BOSS4 KILLED (anim:", obj:GetAnim(), ")")
--        end)

        lastHP4 = boss4:GetHP()
    else
        print("[Boss.lua] Boss4 non ancora presente, barra4 non creata.")
    end

----------------------------------------------------------------------------------------
-- SCRITTA INIZIALE
 	local pos1 = Vec2(PercentToScreen(50, 88))
 	local pos2 = Vec2(PercentToScreen(50, 94))
 	-- crea l'oggetto stringa
    local s1 = DisplayString(
        "Somewhere around Zafferana Etnea, Italy",
        pos1,
        1.0,                          -- scala (facoltativa)
        Color(255, 255, 255, 255)     -- colore
        -- , false                    -- translated (facoltativo)
    )

    -- opzionale: centra rispetto a 'pos' e aggiungi ombra
    s1:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }

    -- MOSTRA per 6s e poi elimina l'oggetto (autoDelete=true)
    Strings.ShowString(s1, 6, true)
    
    local s2 = DisplayString(
        "Lara is looking for the entrance to the lost city of Topaz",
        pos2,
        1.0,                          -- scala (facoltativa)
        Color(0, 128, 160, 255)     -- colore
        -- , false                    -- translated (facoltativo)
    )

    -- opzionale: centra rispetto a 'pos' e aggiungi ombra
    s2:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }

    -- MOSTRA per 6s e poi elimina l'oggetto (autoDelete=true)
    Strings.ShowString(s2, 6, true)
----------------------------------------------------------------------------------------------------------




-----------------------------
-- settiamo le piastrelle di room 1 a invisibili


	piastrella1 = TEN.Objects.GetStaticByName("static_mesh_273")
	piastrella2 = TEN.Objects.GetStaticByName("static_mesh_274")
	piastrella3 = TEN.Objects.GetStaticByName("static_mesh_275")
	
	
	if piastrella1 then
        piastrella1:Disable()   
    end
    if piastrella2 then
        piastrella2:Disable()   
    end
    if piastrella3 then
        piastrella3:Disable()   
    end


----------------------------

-- inizializza i timer (randomizzati per non avere puff sincronizzati)
    for i=1,#spots_pozze_nebbia do
        timers[i] = math.random(120, 240)  -- 2–4 secondi
    end

end -- end OnStart


LevelFuncs.OnLoop = function(dt)

---------------------------------------------------------------------
--- questo lo metto per sicurezza per evitare che qualche flare rimasto nascosto
--- possa essere preso e rovinare il meccanismo della custom portable light
    Inventory.SetItemCount(983, 0)   -- azzera flare costantemente


    
---------------------------------------------------------------
-- fuochi camera alta

	FuochiCameraAltaOn()
---------------------------------------------------------------
-- fuochi boss Tinnos finali

	fuochiBossTinnos()

	
---------------------------------------------------------------
-- ARCHI TOPAZ

	archiTopaz(dt)
	if not flagPortaIntermezza then
		DoorIntermezza:Enable()
	else
		DoorIntermezza:Disable()
	end

---------------------------------------------------------------------------------------
-- ANIMAZIONE CUSTOM PENDOLI TINNOS
--		print("PENDOLO FLAGS", pendolo_flags[1])
 -- 🔹 Incrementa il tempo (solo se almeno un pendolo è attivo)
    if pendolo_flags[1] or pendolo_flags[2] or pendolo_flags[3] then
        tPendolo = tPendolo + dt
    end

    -- 🔹 Calcola i frame correnti per i tre pendoli
    --    (sfasi naturali: 0°, 120°, 240°)
    local f1 = math.floor((tPendolo / PeriodPendolo) * nFrames) % nFrames
    local f2 = math.floor(((tPendolo + PeriodPendolo/3) / PeriodPendolo) * nFrames) % nFrames
    local f3 = math.floor(((tPendolo + 2*PeriodPendolo/3) / PeriodPendolo) * nFrames) % nFrames

    -- 🔹 Pendolo 1
    if pendolo_flags[1] and pendolo1 then
        pendolo1:SetFrame(f1)
        EmitFlameAtLocal(pendolo1, 5, Vec3(0, -256, 0), 32, 1)
        local pos1tinnospen = pendolo1:GetJointPosition(5, Vec3(0,-256,0))
		Effects.EmitLight(pos1tinnospen, Color(110,160,255,255), 10, 16, "p1_light")
    end

    -- 🔹 Pendolo 2
    if pendolo_flags[2] and pendolo2 then
        pendolo2:SetFrame(f2)
        EmitFlameAtLocal(pendolo2, 5, Vec3(0, -256, 0), 32, 2)
        local pos2tinnospen = pendolo2:GetJointPosition(5, Vec3(0,-256,0))
		Effects.EmitLight(pos2tinnospen, Color(150,140,255,255), 10, 16, "p2_light")
    end

    -- 🔹 Pendolo 3
    if pendolo_flags[3] and pendolo3 then
        pendolo3:SetFrame(f3)
        EmitFlameAtLocal(pendolo3, 5, Vec3(0, -256, 0), 32, 3)
        local pos3tinnospen = pendolo3:GetJointPosition(5, Vec3(0,-256,0))
		Effects.EmitLight(pos3tinnospen, Color(180,100,255,255), 10, 16, "p3_light")
    end
   

		
----------------------------------------------------------------------------------------
-- CONDIZIONE sulle porte di Tinnos


    if boss3:GetHP() == 0 then
    	Boss3Set = true
    end
    if boss4:GetHP() == 0 then
    	Boss4Set = true
    end
	 
 	if not TinnosPorteFlag and Boss3Set and Boss4Set then
		ApriPorteTinnos()
	end


---------------------------------------------------------------------------------------
-- AGGIORNA posizione Lara dopo fmv Malachia
--[[ 
    Post-video restore:
    - Rimette Lara in stato "standing" (state=2, anim=11)
    - Azzera velocità per eliminare residui di salto
    - Riposiziona e ruota correttamente prima della riattivazione della fisica
    - Usa Rotation() per fissare la rotazione di Lara dopo il filmato, la sintassi evita freeze
]]


	if video_active and not View.IsVideoPlaying(video_name) then
        local poslaraafter = Vec3(59392, 28416, 83456)
        local vellaraafter = Vec3(0,0,0)
        local rotlaraafter = Rotation(0, 235, 0)
		Lara:SetRotation(rotlaraafter)

        Lara:SetAnim(11)     -- animazione Lara Standing STILL
        Lara:SetState(2)     -- stato di Lara in OnStart
        Lara:SetPosition(poslaraafter)
        Lara:SetVelocity(vellaraafter)
 
        video_active = false
    end


 




----------------------------------------------------------------------------------------
-- DIARIO

	if Input.IsKeyHit(Input.ActionID.H) then
        diary:ShowDiary(1)
    end
    
----------------------------------------------------------------------------------------

----------------------------------------------------------------------------------
-- camera per registrare nella tomba di Malachia
   if CameraMalachiaFlag and CameraMalachia then
   CameraMalachia:Play(Lara)
   end

--------------------------------------------------------------

Inventory.SetItemCount(983, 0)    -- setta a 0 i flare, per sicurezza, non ricordo se ho inserito flare pickups nel livello

------------------------------------------------------------------
-- CUSTOM FLARE


if Input.IsKeyHit(Input.ActionID.FLARE) then -- FLARE
    flare_on = not flare_on
    Sound.PlaySound(379)
end


-- se attivo, emetti spotlight ogni frame
    if flare_on then
    
    
    	if Input.IsKeyHit(Input.ActionID.L) then    
            flare_pitch = flare_pitch - 0.1
        end
        if Input.IsKeyHit(Input.ActionID.K) then  
            flare_pitch = 0
        end
        if Input.IsKeyHit(Input.ActionID.J) then  
            flare_pitch = flare_pitch + 0.1
        end
    
 		local localOffset = Vec3(-128, -512, 64)
 	

		local pos = Lara:GetJointPosition(11, Vec3(-32, -64, 64)) -- spotlight posizionata sulla spalla sinistra di Lara

        local rot = Lara:GetRotation()
 		local dir = rot:Direction()
 		dir = dir + Vec3(0, flare_pitch, 0)   -- tilt verticale
        dir:Normalize()
		
		pos = pos + dir*16

 
        -- spotlight
        Effects.EmitSpotLight(
            pos,
            dir,
            Color(255, 250, 220), -- colore     --(255, 250, 220) --(255, 240, 200)
            12,  -- radius      --12
            6,   -- falloff
            24,  -- distanza     --24
            false,
            "test_spot"
        )
        
        
        -- pointlight "riempimento"  
		Effects.EmitLight(
		    pos,
		    Color(200,180,160),  -- più tenue
		    8,                   -- radius corto
		    12,                  -- falloff
		    "flare_fill"
		)
        
        
    end     -- end custom flare



--------------------------------------------------------------------------------------------------------------
-- flow per statistiche di fine livello
	level_time = level_time + dt  -- time per statistiche
	if stats_active and Flow.GetFreezeMode() == Flow.FreezeMode.FULL then
        return
    end
---------------------------------------------------------------------------------------------------------------   


    if fire_flag_dopo then
    	Effects.EmitFire(FuocoDopo,SizeFuocoDopo)
    end 


    local anim1 = SW1:GetAnim()
    if not BoxMinot then return end
    
    local condizione_ok = (anim1 == 1 )

    if condizione_ok and not opening then
        opening = true
        t_open = 0.0

    end

    if opening and t_open < OPEN_TIME then
    
    
    	 if Input.IsKeyHit(Input.ActionID.LOOK) then -- LOOK riporta la camera su Lara
    		flag_camera_minotauro = true
   
   		end
    
    
    	if not flag_camera_minotauro then
    
   		 	CameraBoxMinot:Play(BaddyCamera)
    	
    	
       	end
    
    	
    	
    	
    	
    	
    	
    	
    
        t_open = t_open + dt
        local frac = math.min(t_open / OPEN_TIME, 1.0) -- va da 0 a 1
        local p = BoxMinot:GetPosition()
        local y_base = base_BoxMinot + OPEN_DY * frac
        
        
        
        
        -- aggiorna il target del jitter ogni SHAKE_UPDATE secondi
		shake_timer = shake_timer + dt
		if shake_timer >= SHAKE_UPDATE then
		    local amp_scale = math.sqrt(1.0 - frac)        -- si attenua verso la fine
		    shake_tx = (math.random() - 0.5) * 2 * SHAKE_AMP_XZ * amp_scale
		    shake_ty = (math.random() - 0.5) * 2 * SHAKE_AMP_Y  * amp_scale
		    shake_tz = (math.random() - 0.5) * 2 * SHAKE_AMP_XZ * amp_scale
		    shake_timer = 0
		end
		
		-- filtro (smussa i cambi: niente scatti)
		local s = 0.35
		shake_x = shake_x + (shake_tx - shake_x) * s
		shake_y = shake_y + (shake_ty - shake_y) * s
		shake_z = shake_z + (shake_tz - shake_z) * s
		
		-- posizione finale = base + tremolio (niente drift su x/z!)
		local p = Vec3(
		    base_BoxMinot_x + shake_x,
		    y_base          + shake_y,
		    base_BoxMinot_z + shake_z
		)
        
        
        
        BoxMinot:SetPosition(p)
        
            
		    EmitSparks(ZampilloPos1+ Vec3(0, -8, 0))
		    EmitSparks(ZampilloPos2+ Vec3(0, -8, 0))
		    EmitSparks(ZampilloPos3+ Vec3(0, -8, 0))
		    EmitSparks(ZampilloPos4+ Vec3(0, -8, 0))
		    EmitSparks(ZampilloPos5+ Vec3(0, -16, 0))
		    EmitSparks(ZampilloPos6+ Vec3(0, -16, 0))

    
    
    
    end
    
    
    
    
    -- prova sempre a prendere i riferimenti (spawn tardivo)
    boss  = boss  or TEN.Objects.GetMoveableByName(BOSS_NAME)
    
    try_bind_boss2()
    try_bind_boss3()
    try_bind_boss4() 
    
    -- mostra barre se serve
    if not bar_shown  then update_bar_visibility()  end
    if not bar_shown2 then update_bar_visibility2() end
    if not bar_shown3  then update_bar_visibility3()  end
    if not bar_shown4 then update_bar_visibility4() end

    -- debug HP boss1
    if boss then
        local hp = boss:GetHP()
        if hp ~= lastHP then
            print("[Boss.lua] HP boss1 cambiati ->", hp)
            lastHP = hp
        end
    end

    -- debug HP boss2
    if boss2 then
        local hp2 = boss2:GetHP()
        if hp2 ~= lastHP2 then
            print("[Boss.lua] HP boss2 cambiati ->", hp2)
            lastHP2 = hp2
        end
    end


    -- porta fuori dallo scope degli if
    local want3, want4 = false, false


    -- barra 3: visibile solo se Lara LO PUNTA
    if tile_ok_once3 and boss3 and bar_created3 then
        want3 = boss3:GetHitStatus()  -- true se mirato
        if want3 ~= bar_shown3 then
--            CustomBar.HideBar("boss_hp3", not want3)
              hide_bar_safe("boss_hp3", not want3) 
            bar_shown3 = want3
        end
    end

    -- barra 4: idem
    if tile_ok_once4 and boss4 and bar_created4 then
        want4 = boss4:GetHitStatus()
        if want4 ~= bar_shown4 then
 --           CustomBar.HideBar("boss_hp4", not want4)
             hide_bar_safe("boss_hp4", not want4)
            bar_shown4 = want4
        end
    end

    


 


---------------------------------------------------------------------
-- === HUD AMMO + NOME ARMA (OnLoop) ===

--	local wt = Objects.LaraObject.GetWeaponType(Lara)
	-- wt == 1 → Pistols a munizioni infinite: ignoriamo
--	if wt ~= 1 then
--	    local tttt = Lara:GetHandStatus()  -- 4 = WEAPON_READY
--	    if tttt == 4 then
	        -- prendi UI (label, y, color) dalla tabella; fallback se manca
--	        local ui    = WEAPON_UI[wt]
--	        local label = (ui and ui.label) or tostring(wt)
--	        local y     = (ui and ui.y)     or 60
--	        local col   = (ui and ui.color) or Color(255,255,255,255)
	
--	        local ammo  = Lara:GetAmmoCount()
--	        local text  = string.format("%s: %s", label, tostring(ammo))
	
--	        local s = DisplayString(text, Vec2(40, y), 1.0, col, false)
--	        Strings.ShowString(s, 0.1, true)
--	    end
--	end

-- === HUD AMMO + NOME ARMA + tag N/W per Shotgun (OnLoop) ===

	-- === aggiunta: colore rosso/blu per Shotgun ===
	local wt = Objects.LaraObject.GetWeaponType(Lara)
	if wt ~= 1 then
	    local tttt = Lara:GetHandStatus()  -- 4 = WEAPON_READY
	    if tttt == 4 then
	        local ui    = WEAPON_UI[wt]
	        local label = (ui and ui.label) or tostring(wt)
	        local y     = (ui and ui.y)     or 60
	        local col   = (ui and ui.color) or Color(255,255,255,255)
	
	        if wt == Objects.WeaponType.SHOTGUN then
	            local at    = Lara:GetAmmoType()
	            local isWide = (at == Objects.AmmoType.SHOTGUN_WIDE)
	            label = string.format("%s (%s)", label, isWide and "W" or "N")
	            -- 🔴 normale = rosso, 🔵 wide = blu
	            col   = isWide and Color(0,160,255,255) or Color(255,80,80,255)
	        end
	
	        local ammo  = Lara:GetAmmoCount()
	        local text  = string.format("%s: %s", label, tostring(ammo))
	
	        local s = DisplayString(text, Vec2(40, y), 1.0, col, false)
	        Strings.ShowString(s, 0.1, true)
	    end
	end


----------------------------------------------------------------------------
-- FUOCHI BRACIERI sala TINNOS

	local posizionebrac1 = Vec3(47616, 17408, 73216)
	local posizionebrac2 = Vec3(52736, 17408, 73216)
	local size_brac = 3
	Effects.EmitFire(posizionebrac1,size_brac)
	Effects.EmitFire(posizionebrac2,size_brac)

--------------------------------------------------------------------
-- FUOCHI room BLU FAITH LEAP aggiuntivi small

 

		local posizioneaggiu1 = Vec3(4608, -512, 2560)
		local posizioneaggiu2 = Vec3(2560, -512, 2560)
		local size_aggiuntivi = 1
	    Effects.EmitFire(posizioneaggiu1,size_aggiuntivi)
	    Effects.EmitFire(posizioneaggiu2,size_aggiuntivi)
---------------------------------------------------------------------

--------------------------------------------------------------------
-- FUOCHI room DIAMA

 


	    Effects.EmitFire(pos_roomdiama_1,size_roomdiama)
	    Effects.EmitFire(pos_roomdiama_2,size_roomdiama)
---------------------------------------------------------------------
-- FUOCHI in alto
     
	    
	    
	    Effects.EmitFire(pos_fire1,sizell)
	    Effects.EmitFire(pos_fire2,sizell)
	    Effects.EmitFire(pos_fire3,sizell)

-- FUOCO su tetto  altare  
     

			--Effects.EmitFire(pos_fire4,sizeff)
			
-- FUOCHI in room1			
			
	 
	 Effects.EmitFire(pos_room1,size_room)
	 Effects.EmitFire(pos_room2,size_room)
	 Effects.EmitFire(pos_room3,size_room)
	 
	 
-- FUOCHI in room primo topazio			
			
	 
--	 Effects.EmitFire(pos_room4,size_room)
--	 Effects.EmitFire(pos_room5,size_room)
	 
	 
-- FUOCHI in room secondo e terzo topazio			
			
	 
	 Effects.EmitFire(pos_room6,size_room)
	 Effects.EmitFire(pos_room7,size_room)
	 Effects.EmitFire(pos_room8,size_room)
	 Effects.EmitFire(pos_room9,size_room)
	  
-- FUOCHI in room CENTAURO boss	
			
	  
	 Effects.EmitFire(pos_room10,size_roomC)
	 Effects.EmitFire(pos_room11,size_roomC)
	 
	 
	 -- fuochi corridoio
	 Effects.EmitFire(pos_roomR1,size_roomCORR)
	 Effects.EmitFire(pos_roomR2,size_roomCORR)
	 Effects.EmitFire(pos_roomR3,size_roomCORR)
	 Effects.EmitFire(pos_roomR4,size_roomCORR)
	 Effects.EmitFire(pos_roomR5,size_roomCORR)
	 Effects.EmitFire(pos_roomR6,size_roomCORR)
	 
	 Effects.EmitFire(pos_roomL1,size_roomCORR)
	 Effects.EmitFire(pos_roomL2,size_roomCORR)
	 Effects.EmitFire(pos_roomL3,size_roomCORR)
	 Effects.EmitFire(pos_roomL4,size_roomCORR)
	 Effects.EmitFire(pos_roomL5,size_roomCORR)
	 Effects.EmitFire(pos_roomL6,size_roomCORR)
	  
	 
	 
-- FUOCHI pozza room altare	

	 Effects.EmitFire(pos_fiamme,size_roomPA)
	 
	 
	 
	 
-- FUOCHI ARENA MINOTAURO			


if is_boss1_spawned_alive() then

	  
	 Effects.EmitFire(pos_room12,size_roomM)
	 Effects.EmitFire(pos_room13,size_roomM)
	 Effects.EmitFire(pos_room14,size_roomM)
	 Effects.EmitFire(pos_room15,size_roomM)	 
	 Effects.EmitFire(pos_room16,size_roomM)
	 Effects.EmitFire(pos_room17,size_roomM)
	 Effects.EmitFire(pos_room18,size_roomM)
	 Effects.EmitFire(pos_room19,size_roomM)

end

--          postest = Vec3(10752, 256, 10752)
--          Effects.EmitFire(postest,size_roomM)
          

-- FUOCHI TOMBA MALACHIA
if lara_tomba then
--	 Effects.EmitFire(pos_room20,size_roomMALA)
--	 Effects.EmitFire(pos_room21,size_roomMALA)
--	 Effects.EmitFire(pos_room22,size_roomMALA)
--	 Effects.EmitFire(pos_room23,size_roomMALA)
	 Effects.EmitFire(pos_room24,size_roomMALA)
	 Effects.EmitFire(pos_room25,size_roomMALA)
end


--------------------------------------------------------------------------------    

---------------------------------------------------------------------
-- POZZE con timer randomizzate
     for i,posA in ipairs(spots_pozze_nebbia) do
        timers[i] = timers[i] - 1
        if timers[i] <= 0 then
            spawnNebbia(posA)
            timers[i] = math.random(140, 280)  -- reset
        end
    end
----------------------------------------------------------------------------------------    






---------------------------------------------------------------------
-- FOG varie
     
    	Effects.EmitFogBulb(Vec3(52736, 26368, 82432), 30, 50, Color(70, 130, 180), "NebbiaScaleMalachia") -- room scale Malachia
    	Effects.EmitFogBulb(Vec3(19968, 18688, 54784), 30, 40, Color(178, 34, 34), "NebbiaCentaurBoss") -- room centauro boss
    	Effects.EmitFogBulb(Vec3(49664, 19712, 65024), 30, 15, Color(178, 34, 34), "NebbiaTinnosBoss") -- room Tinnos bosses
    	Effects.EmitFogBulb(Vec3(69120, 27392, 56832), 30, 40, Color(70, 130, 180), "NebbiaPilastri") -- room pilastri sospesi
--    	Effects.EmitFogBulb(Vec3(68608, 23808, 50688), 30, 40, Color(25, 25, 112), "NebbiaVuoto") -- room vuoto profondo
    	Effects.EmitFogBulb(Vec3(67072, 28352, 93696), 30, 20, Color(148, 0, 211), "NebbiaTinnosMonster") -- room segreto mostro Tinnos
    	Effects.EmitFogBulb(Vec3(10752, -9728, 9216), 30, 20, Color(148, 0, 211), "NebbiaOutside") -- nebbia livello outside
    	Effects.EmitFogBulb(Vec3(38912, 21824, 35328), 40, 30, Color(178, 34, 34), "NebbiaRossaTopaz") -- nebbia Topaz
    	
    	
    	Effects.EmitFogBulb(Vec3(71168, 26624, 45568), 40, 30, Color(25, 25, 112), "NebbiaRossaSalaNuova") -- nebbia sala nuova
    	Effects.EmitFogBulb(Vec3(73728, 26624, 45568), 40, 30, Color(25, 25, 112), "NebbiaRossaSalaNuova2") -- nebbia sala nuova 2
    	 
	 
---------------------------------------------------------------------------------------- 

 

end   -- end di OnLoop


 

LevelFuncs.OnSave  = function() 

    LevelVars.opening = opening
    LevelVars.t_open  = t_open
    
    if BoxMinot then
	    LevelVars.BoxMinot_y = BoxMinot:GetPosition().y
	end

	LevelVars.level_time = level_time -- per timer statistiche
	
	LevelVars.flare_on = flare_on
	LevelVars.flare_pitch = flare_pitch

--Camera per cutscenes	
	LevelVars.CameraMalachiaFlag = CameraMalachiaFlag
	
--piastrelle invisibili
    LevelVars.piastrelle_visibili = piastrelle_visibili

-- sflag per messaggio update diario
    LevelVars.sflag = sflag
    
    LevelVars.flag_camera_minotauro = flag_camera_minotauro
    
    LevelVars.TinnosPorteFlag = TinnosPorteFlag
    LevelVars.Boss3Set = Boss3Set
    LevelVars.Boss4Set = Boss4Set
    
    LevelVars.pendolo_flags = pendolo_flags
    LevelVars.tPendolo = tPendolo
    
    LevelVars.flagArchi = flagArchi
    
    LevelVars.timeArchi = timeArchi
    
    LevelVars.flagSpegniArcoLetale = flagSpegniArcoLetale
    LevelVars.flagFuocoTinnos = flagFuocoTinnos
    LevelVars.flagPortaIntermezza = flagPortaIntermezza
    LevelVars.flagArchiStdby = flagArchiStdby
    
--    LevelVars.tile_ok_once = tile_ok_once
--    LevelVars.tile_ok_once2 = tile_ok_once2
--    LevelVars.tile_ok_once3 = tile_ok_once3
--    LevelVars.tile_ok_once4 = tile_ok_once4
     
	LevelVars.flagTinnosBoss = flagTinnosBoss
	
--	LevelVars.flag_fuochi_cameraalta = flag_fuochi_cameraalta

end -- end OnSave
 

 
LevelFuncs.OnEnd = function()
      
end

LevelFuncs.OnFreeze = function()
     
if not stats_active then return end
    if Flow.GetFreezeMode() ~= Flow.FreezeMode.FULL then return end

    -- usare IsKeyHeld è più affidabile del “colpo singolo” IsKeyHit in freeze
    if Input.IsKeyHeld(Input.ActionID.RETURN) or Input.IsKeyHeld(Input.ActionID.ESCAPE) then
        stats_active = false
        Flow.SetFreezeMode(Flow.FreezeMode.NONE)
        Flow.EndLevel()
    end    
         
end -- end OnFreeze








LevelFuncs.OnUseItem  = function() end




 






