-- FILE: Levels\Catacombs.lua

local Common = require("Levels.commonfunctions")
local AudioDurations = require("Levels.AudioDurations")
local EventSequence = require("Engine.EventSequence")

local ok, CustomBar = pcall(require, "CustomBar")
if not ok then CustomBar = require("Engine.CustomBar") end

------------------------------------------------------------------------------------------
-- DIARIO

local CustomDiary = require("Engine.CustomDiary")
CustomDiary.ImportDiary("DiarySetup")
local diary = CustomDiary.Get(TEN.Objects.ObjID.DIARY_ITEM)

local sflag = 0



--------------------------------------------------------------
-- FUNZIONE AUSILIARIA per fuoco più luce

local function EmitFuocoMio(posizione, stren, ii)

			Effects.EmitFire(posizione, stren)
		    Effects.EmitLight(
		        posizione,                        -- posizione
		        Color(255, 140, 40),        -- colore
		        12,                         -- raggio
		        16,                         -- falloff
		        "lucefireandlight_" .. ii     -- chiave univoca per ogni luce
		    )

end 
----------------------------------------------------------------------------------------

LevelFuncs.OnArtefattiAprePortone = function()
	local TrackNameWrai = "peace"
	local ttwrai = Sound.SoundTrackType.ONESHOT
	
	Sound.PlayAudioTrack(TrackNameWrai, ttwrai)
	TEN.Objects.GetMoveableByName("door_type9_118"):Enable()
end

local TinnosFlagPerFuochi = false
LevelFuncs.OnEnterCameraSegreto = function()
-- distrugge la statua di un Tinnos monster e attiva un Tinnos monster
	local statuaTinnos = TEN.Objects.GetStaticByName("static_mesh_216")
	local mostroTinnos = TEN.Objects.GetMoveableByName("claw_mutant_216")
	
	if not TinnosFlagPerFuochi then
		statuaTinnos:Shatter()
		Sound.PlaySound(1199) -- custom sound
		mostroTinnos:Enable()
	TinnosFlagPerFuochi = true
	end
end

local function AccendiFuochiCameraTinnosIniziale()
-- da mandare a OnLoop
	local posizione1 = Vec3(96768, 0, 51712)
	local posizione2 = Vec3(98816, -512, 54784)
	local posizione3 = Vec3(99840, -512, 54784)
--	local posizione4 = Vec3(88064, -128, 44544)

	local stren = 3
	local stren2 = 1
 

	if TinnosFlagPerFuochi then
		EmitFuocoMio(posizione1, stren, 918)
		EmitFuocoMio(posizione2, stren2, 928)
		EmitFuocoMio(posizione3, stren2, 938)
	end
end

----------------------------------------------------------------------------------------

local TinnosFlagAltroMostro = false
LevelFuncs.OnEnterCameraTinnosAltro = function()
-- distrugge la statua di un Tinnos monster e attiva un Tinnos monster
	local statuaTinnos = TEN.Objects.GetStaticByName("static_mesh_215")
	local mostroTinnos = TEN.Objects.GetMoveableByName("claw_mutant_223")
	local id_item = 501   -- puzzle item 2
	local count_item = GetItemCount(id_item)
	
	if not TinnosFlagAltroMostro and (count_item > 0) then
		statuaTinnos:Shatter()
		Sound.PlaySound(1199) -- custom sound
		mostroTinnos:Enable()
		TinnosFlagAltroMostro = true
	end
end

local function AccendiFuochiCameraTinnosAltro()
-- da mandare a OnLoop
	local posizione1 = Vec3(96768, 0, 49664)

	local stren = 3

 

	if TinnosFlagAltroMostro then
		EmitFuocoMio(posizione1, stren, 1918)
	end
end



----------------------------------------------------------------------------------------
local flag_lara_threshold = false
LevelFuncs.OnLaraThreshold = function()

    TEN.Objects.GetMoveableByName("door_type9_227"):Enable()

	local ttwrai = Sound.SoundTrackType.ONESHOT
	local TrackNameWrai = "threshold" 
	if not flag_lara_threshold then
		Sound.PlayAudioTrack(TrackNameWrai, ttwrai)
		flag_lara_threshold = true
		
		local pos = Vec2(PercentToScreen(50, 92))
 		local duration = 3.5  

    	local s = DisplayString(
        "This place... It must be the Threshold of the First Breath",
        pos,
        1.0,
        Color(200, 220, 255)  
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true)
		
	end
		
		 
    
    
end


-----------------------------------------------------------------------------------------

LevelFuncs.OnPiscinaMorte = function()
	Lara:SetHP(0)
end




----------------------------------------------------------------------------
local flag_musica_accessolivello = false
local flag_fuoco_camereiniziali = false
LevelFuncs.OnIngressoLivelloMusica = function()
-- fa partire la musica, mette a true la flag per i fuochi e apre il gate

	local doorDaAprire = TEN.Objects.GetMoveableByName("door_type8_202")
	doorDaAprire:Enable()
	
	if not flag_fuoco_camereiniziali then
		flag_fuoco_camereiniziali = true
	end
	
	local ttwrai = Sound.SoundTrackType.ONESHOT
	local TrackNameWrai = "scarysoundhorror" 
	if not flag_musica_accessolivello then
		Sound.PlayAudioTrack(TrackNameWrai, ttwrai)
	end
	flag_musica_accessolivello = true
end 

-----------------------------------------------------------------------------
-- accende fuochi nelle due room iniziali
local function AccendiFuochiCamereIniziali()
-- da mandare a OnLoop
	local posizione1 = Vec3(88064, -128, 44544)
	local posizione2 = Vec3(88064, -128, 46592)
	local posizione3 = Vec3(97411, -128, 44544)
--	local posizione4 = Vec3(88064, -128, 44544)

	local stren = 1
	
 

	if flag_fuoco_camereiniziali then
		EmitFuocoMio(posizione1, stren, 818)
		EmitFuocoMio(posizione2, stren, 828)
		EmitFuocoMio(posizione3, stren, 838)
	end
end

------------------------------------------------------------------------------------------

--------------------------------------------------------------------------------------------
-- APRE PORTE ULTIMA ROOM dopo labirinto

LevelFuncs.OnAfterMaze = function()
	local id_item = 503   -- puzzle item 4
	local count_item = GetItemCount(id_item)
	
	if count_item == 2 then
       local porta4_1 = TEN.Objects.GetMoveableByName("door_type9_225")
       local porta4_2 = TEN.Objects.GetMoveableByName("door_type9_90")
       local porta4_3 = TEN.Objects.GetMoveableByName("door_type9_226")
       porta4_1:Enable()
       porta4_2:Enable()
       porta4_3:Enable()
       
		
       
       
    end   -- end su count_item

end

LevelFuncs.OnAfterMazeDiary = function()

	local id_item = 503   -- puzzle item 4
	local count_item = GetItemCount(id_item)
	
	if count_item == 2 then
		diary:UnlockPages(18, false)
		
		local pos = Vec2(PercentToScreen(50, 92))
 		local duration = 8.0  

    	local s = DisplayString(
        "Notes added to the diary. Press H to check",
        pos,
        1.0,
        Color(200, 220, 255)  
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true) 
    Sound.PlaySound(1198) -- custom suono notifica
    
    end -- end su if items nell'inventario
end

---------------------------------------------------------------------------------
-- NOTA per 4 chiavi prese

LevelFuncs.OnAfter4chiavi = function()
	diary:UnlockPages(19, false)
		
		local pos = Vec2(PercentToScreen(50, 92))
 		local duration = 8.0  

    	local s = DisplayString(
        "Notes added to the diary. Press H to check",
        pos,
        1.0,
        Color(200, 220, 255)  
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true) 
    Sound.PlaySound(1198) -- custom suono notifica
end
--------------------------------------------------------------------------------------------------


local flag_musica_adamo = false
LevelFuncs.OnIngressoAdamo = function()
	local ttwrai = Sound.SoundTrackType.ONESHOT
	local TrackNameWrai = "035" 
	if not flag_musica_adamo then
		Sound.PlayAudioTrack(TrackNameWrai, ttwrai)
	end
	flag_musica_adamo = true
end

local flag_musica_bloccovolante = false
LevelFuncs.OnIngressoBloccoVolante = function()
	local ttwrai = Sound.SoundTrackType.ONESHOT
	local TrackNameWrai = "052" 
	if not flag_musica_bloccovolante then
		Sound.PlayAudioTrack(TrackNameWrai, ttwrai)
	end
	flag_musica_bloccovolante = true
end

local flag_musica_accessoeva = false
local DoorEvaPre -- inizializzata in InitAll()
local function IngressoEvaUno()
-- fa partire la musica quando si apre il gate pre-boss della tomba di Eva
	local ttwrai = Sound.SoundTrackType.ONESHOT
	local TrackNameWrai = "055" 
	local AnimPortaPre = DoorEvaPre:GetAnim()
	if not flag_musica_accessoeva and AnimPortaPre==2 then
		flag_musica_accessoeva = true
		Sound.PlayAudioTrack(TrackNameWrai, ttwrai)
	end
	
end






local flag_musica_tuttiequattro = false
LevelFuncs.OnTuttiEQuattro = function()
	local ttwrai = Sound.SoundTrackType.ONESHOT
	local TrackNameWrai = "aidawn" 
	if not flag_musica_tuttiequattro then
		Sound.PlayAudioTrack(TrackNameWrai, ttwrai)
	end
	flag_musica_tuttiequattro = true
end

local flag_musica_percamerablu = false
LevelFuncs.OnCameraBlu = function()
	local ttwrai = Sound.SoundTrackType.ONESHOT
	local TrackNameWrai = "amirror" 
	if not flag_musica_percamerablu then
		Sound.PlayAudioTrack(TrackNameWrai, ttwrai)
	end
	flag_musica_percamerablu = true
end

local flag_risata = false
LevelFuncs.OnLaraItemRisata = function()
    local id_book = 500   -- flare item
    local count_book = GetItemCount(id_book)

    if count_book == 1 and not flag_risata then
        
        Sound.PlaySound(1203)
         
            print("PROVA SOUND FILE")
            print("FLAG RISATA", flag_risata)

            flag_risata = true
         
    end

end    

local flag_musica_dopoboss = false
LevelFuncs.OnMusicaDopoBoss = function()
	local ttwrai = Sound.SoundTrackType.ONESHOT
	local TrackNameWrai = "unity1min" 
	if not flag_musica_dopoboss then
		Sound.PlayAudioTrack(TrackNameWrai, ttwrai)
	end
	flag_musica_dopoboss = true
end

local flag_text_laramaze = false
LevelFuncs.OnTextLaraMaze = function()
	local ttwrai = Sound.SoundTrackType.ONESHOT
	local TrackNameWrai = "laramaze2"
	local pos = Vec2(PercentToScreen(50, 88))
	local duration = 5.0
	local s = DisplayString(
        "This must be the infamous Maze of Madness... \n Something tells me I won't like it here",
        pos,
        1.0,
        Color(200, 220, 255)  
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
	if not flag_text_laramaze then
		Strings.ShowString(s, duration, true)
		Sound.PlayAudioTrack(TrackNameWrai, ttwrai)
	end
	flag_text_laramaze = true
end


-------------------------------------------------------------------------------------------


local tombaeva_flag = false

LevelFuncs.OnTombaEvaFuochi = function()
	if not tombaeva_flag then
		tombaeva_flag = true
	end

end



local function EmitFireTombaEva()
	if tombaeva_flag then
		local ppfe1 = Vec3(69120, -6784, 84992)
		local ppfe2 = Vec3(69120, -6784, 87040)
		local ppfe3 = Vec3(67072, -6784, 87552)
		local ppfe4 = Vec3(67072, -6784, 84480)
		local ppfe5 = Vec3(66048, -6784, 86016)
		
		local strengEva = 2
		
		
		EmitFuocoMio(ppfe1, strengEva, 1)
		EmitFuocoMio(ppfe2, strengEva, 2)
		EmitFuocoMio(ppfe3, strengEva, 3)
		EmitFuocoMio(ppfe4, strengEva, 4)
		EmitFuocoMio(ppfe5, strengEva, 5)
		
		
	
	end
end




LevelFuncs.OnDiaryCatacombsEntrance = function()


	 
 
	if  sflag == 0 then
		diary:UnlockPages(16, false)
		sflag = 1
		
		local pos = Vec2(PercentToScreen(50, 92))
 		local duration = 8.0  

    	local s = DisplayString(
        "Notes added to the diary. Press H to check",
        pos,
        1.0,
        Color(200, 220, 255)  
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true) 
    Sound.PlaySound(1198) -- custom suono notifica
	end

end


LevelFuncs.OnDiaryTinnosEntrance = function()


	 
 
--	if  sflag == 0 then
		diary:UnlockPages(17, false)
--		sflag = 1
		
		local pos = Vec2(PercentToScreen(50, 92))
 		local duration = 8.0  

    	local s = DisplayString(
        "Notes added to the diary. Press H to check",
        pos,
        1.0,
        Color(200, 220, 255)  
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true) 
    Sound.PlaySound(1198) -- custom suono notifica
--	end

end

----------------------------------------------------------
-- VARIABILi TRAPPOLA 4 FUOCHI


----------------------------------------------------------
-- TRAPPOLA: 4 FUOCHI SEQUENZIALI CHE PUNTANO A LARA
----------------------------------------------------------

--local ROOM_ID_TRAP = 100
local TRAP_DELAY   = 14.0          -- secondi prima che inizi la trappola
local FIRE_SPEED   = 4800.0       -- velocità delle fiamme
local FIRE_INTERVAL = 1.0         -- ritardo tra le quattro
--local FIRE_COLOR = { Color(255,120,40,255), Color(80,0,0,0) } -- giallo-rosso
local FIRE_COLOR = {
    Color(160, 100, 255, 255),   -- viola-azzurro luminoso
    Color(0, 0, 60, 0)           -- dissolvenza scura
}


local PosFuo1 = Vec3(70144, -1024, 29184)
local PosFuo2 = Vec3(74240, -1024, 29184)
local PosFuo3 = Vec3(74240, -1024, 24064)
local PosFuo4 = Vec3(70144, -1024, 24064)

----------------------------------------------------------
-- Variabili runtime
----------------------------------------------------------
local trap_timer = 0.0
local countdown_timer = TRAP_DELAY
local fires = {}     -- conterrà fino a 4 fuochi attivi
local fired = {false, false, false, false} -- segna se ciascun getto è stato sparato
local ira_eva = false
local ira_eva_door = false
local trap_cycle_timer = 0.0
local flag_wraith = false
local roomWraith = TEN.Objects.GetRoomByName("evawraith")
local roomWraithNumber = roomWraith:GetRoomNumber()



----------------------------------------------------------
-- Utility: emissione particelle fiamma
----------------------------------------------------------


local function EmitChasingFlame(pos, vel)
    local speed = vel:Length()
    local dir = vel:Normalize()

-- nucleo compatto della fireball
    for i = 1, 8 do
        local jitter = Vec3(
            (math.random()-0.5)*16,
            (math.random()-0.5)*16,
            (math.random()-0.5)*16
        )
        Effects.EmitParticle(
            pos + jitter,
            Vec3(0,0,0),                      -- quasi statiche
            0, 0, 0,
            Color(255, 160 + math.random(0,40), 60),  -- caldo e luminoso
            Color(40, 0, 0, 0),
            TEN.Effects.BlendID.ADDITIVE,
            96, 192,
            0.4 + math.random()*0.3,
            true,    --DAMAGE
            false,
            Objects.ObjID.DEFAULT_SPRITES, 0
        )
    end

    -- scia – emette particelle lungo la direzione opposta
    for i = 1, 6 do
        local backOffset = dir * (-i * 32)
        local jitter = Vec3(
            (math.random()-0.5)*8,
            (math.random()-0.5)*8,
            (math.random()-0.5)*8
        )
        Effects.EmitParticle(
            pos + backOffset + jitter,
            Vec3(0,0,0),
            0, 0, 0,
            Color(255, 100 + math.random(0,60), 20, 255),
            Color(60, 0, 0, 0),
            TEN.Effects.BlendID.ADDITIVE,
            64, 160,
            0.25 + math.random()*0.25,
            false,     --DAMAGE
            false,
            Objects.ObjID.DEFAULT_SPRITES, 0
        )
    end
end


----------------------------------------------------------
-- Funzione principale di aggiornamento
----------------------------------------------------------
function UpdateTrapFourFires(dt)


 
    
    local roomLara = Lara:GetRoomNumber()
    
    local offsetLara = Vec3(0, -768, 0)

-- rileva presenza di Lara nella stanza bersaglio
    if roomLara == roomWraithNumber then
        trap_timer = trap_timer + dt
        countdown_timer = TRAP_DELAY - trap_timer
        
        
        if countdown_timer > 0 then
   
	        Effects.EmitLight(Vec3(72192, -1408, 26624), Color(220, 150, 70, 255), 60, 160, "ambient_fire1")
 
	        
        end
  
        
        if countdown_timer > 0 then
		    local posScrittaEva = Vec2(PercentToScreen(95, 5))  -- top-right
		    local s = DisplayString(
		        string.format("Ira Hevae in: %02d", math.max(0, math.ceil(countdown_timer))),
		        posScrittaEva, 1.0, Color(150, 180, 255, 255)  -- azzurro mistico
		    )
		    s:SetFlags{
		        TEN.Strings.DisplayStringOption.RIGHT,
		        TEN.Strings.DisplayStringOption.SHADOW
		    }
		    Strings.ShowString(s, 0.15, true)
		end
		
		if countdown_timer <= 0 and not ira_eva_door then
		    local doorEva2 = TEN.Objects.GetMoveableByName("door_type9_90")
		    if doorEva2 then
		        doorEva2:Disable()
		    end
		    ira_eva_door = true
		end
		
		
--		if countdown_timer <= 0  then

		
		     
--		end

		
		
		
-- Dopo la chiusura porta, continua a generare ondate di fireballs
-- fino a quando Lara è nella room 100
		if countdown_timer <= 0 then
		    trap_cycle_timer = trap_cycle_timer + dt
		
		    if trap_cycle_timer >= (FIRE_INTERVAL * 4) then
		        trap_cycle_timer = 0.0
		        fired = {false, false, false, false}  -- riattiva i 4 fuochi
		    end
		end
		
		
		if countdown_timer <= 0 and not flag_wraith then
			local ttwrai = Sound.SoundTrackType.ONESHOT
	        local TrackNameWrai = "perwraith" 
			Sound.PlayAudioTrack(TrackNameWrai, ttwrai)
			flag_wraith = true
		end 

        
    else
        trap_timer = 0.0
        fires = {}
        fired = {false, false, false, false}
        trap_cycle_timer = 0.0
        
        if ambient_lights_on then
	        
	        ambient_lights_on = false
	    end
	    if wrath_lights_on then
	         
	        wrath_lights_on = false
	    end
    
        return
    end
    
    



--  attiva i getti in sequenza
    if trap_timer >= TRAP_DELAY then
        local delay = (countdown_timer > 0) and (trap_timer - TRAP_DELAY) or trap_cycle_timer

        if (not fired[1]) and delay >= (0 * FIRE_INTERVAL) then
        	local targetPos1 = Lara:GetPosition()+ offsetLara
            local dir = (targetPos1 - PosFuo1):Normalize()
            table.insert(fires, {pos = Vec3(PosFuo1.x, PosFuo1.y, PosFuo1.z), vel = dir * FIRE_SPEED})
            fired[1] = true
            print("[TRAP] Fuoco 1 lanciato!")
        end
        if (not fired[2]) and delay >= (1 * FIRE_INTERVAL) then
        local targetPos2 = Lara:GetPosition()+ offsetLara
            local dir = (targetPos2 - PosFuo2):Normalize()
            table.insert(fires, {pos = Vec3(PosFuo2.x, PosFuo2.y, PosFuo2.z), vel = dir * FIRE_SPEED})
            fired[2] = true
            print("[TRAP] Fuoco 2 lanciato!")
        end
        if (not fired[3]) and delay >= (2 * FIRE_INTERVAL) then
        local targetPos3 = Lara:GetPosition()+ offsetLara
            local dir = (targetPos3 - PosFuo3):Normalize()
            table.insert(fires, {pos = Vec3(PosFuo3.x, PosFuo3.y, PosFuo3.z), vel = dir * FIRE_SPEED})
            fired[3] = true
            print("[TRAP] Fuoco 3 lanciato!")
        end
        if (not fired[4]) and delay >= (3 * FIRE_INTERVAL) then
        local targetPos4 = Lara:GetPosition() + offsetLara
            local dir = (targetPos4 - PosFuo4):Normalize()
            table.insert(fires, {pos = Vec3(PosFuo4.x, PosFuo4.y, PosFuo4.z), vel = dir * FIRE_SPEED})
            fired[4] = true
            print("[TRAP] Fuoco 4 lanciato!")
        end
    end

-- 3) aggiorna e disegna i fuochi già creati
    if #fires > 0 then
        for i = 1, #fires do
            local f = fires[i]
            f.pos = f.pos + f.vel * dt
            
            EmitChasingFlame(f.pos, f.vel * 0.05)
            
           


			Effects.EmitLight(
			    f.pos,
			    Color(140 + math.random(0,40), 160 + math.random(0,60), 255),
			    14,        -- radius
			    22,        -- falloff
			    "hevae_light_" .. tostring(i)
			)


        end
    end

end

LevelFuncs.OnTrapEvaIra = function()
	local tt = Sound.SoundTrackType.ONESHOT
    local TrackNameIra = "contoallarovescia" 
    
    if not ira_eva then
    
	    Sound.PlayAudioTrack(TrackNameIra, tt)
	    
    end
    ira_eva = true
     

end

------------------------------------------------------------------------------------
-- PENDOLI DI TINNOS custom animazione e fuochi

local pendolo1 = TEN.Objects.GetMoveableByName("fire_pendulum_134")
local pendolo2 = TEN.Objects.GetMoveableByName("fire_pendulum_135")
local pendolo3 = TEN.Objects.GetMoveableByName("fire_pendulum_136")

local pendolo_flags = {false, false, false}
local tPendolo = 0.0
local nFrames = 88        -- quanti frame ha l'animazione del pendolo nel WAD
local PeriodPendolo = 3.0 -- tempo di un ciclo completo (oscillazione)




local function InizializzaPendoli()
--	pendolo1 = TEN.Objects.GetMoveableByName("fire_pendulum_282")
--	pendolo2 = TEN.Objects.GetMoveableByName("fire_pendulum_283")
--	pendolo3 = TEN.Objects.GetMoveableByName("fire_pendulum_284")
	
	
	for _,p in ipairs({pendolo1, pendolo2, pendolo3}) do
	    if p then
	        p:SetAnim(0)
	        p:SetFrame(0)
	    end
	end

end

LevelFuncs.OnPendoloTrigger1 = function()
--	pendoli[1]:Enable()
	pendolo_flags[1] = true
end

LevelFuncs.OnPendoloTrigger2 = function()
--	pendoli[2]:Enable()
	pendolo_flags[2] = true
end

LevelFuncs.OnPendoloTrigger3 = function()
--	pendoli[3]:Enable()
	pendolo_flags[3] = true
end

 

LevelFuncs.OnPendoliSequence = function()

	

	

	local delaypendoli1 = 0.25 -- secondi
	local delaypendoli2 = 0.5 -- secondi
	local pendoloSequence = EventSequence.Create
	    (
	    "pendolo_sequence",  
	    false, -- ff sequence loops then true, if not: false.
	    false, -- in-game timer 
		delaypendoli1,
	    LevelFuncs.OnPendoloTrigger1,
	    delaypendoli2,
	    LevelFuncs.OnPendoloTrigger2,
	    delaypendoli2,
	    LevelFuncs.OnPendoloTrigger3 
	    )
	
	   
	    pendoloSequence:Start()
 

end

-- === FUOCHI CUSTOM DEI PENDOLI ===
local joint_coppa = 5
local offsetFiammaPendolo = Vec3(0, -256, 0)
local forzaFiamma = 32

-- Palette colori pendoli Tinnos
local FlameColorsPendoli = {
    -- Pendolo 1 → azzurro ghiaccio
    { Color(110,180,235,255), Color(0,40,80,0) },

    -- Pendolo 2 → azzurro-violetto intermedio
    { Color(150,140,255,255), Color(40,20,100,0) },

    -- Pendolo 3 → violetto profondo
    { Color(180,100,255,255), Color(60,10,120,0) }
}


-- Funzione che emette le particelle di fiamma dalla coppa del pendolo
function EmitFlameAtLocal(obj, meshIndex, offset, strength, paletteIndex)
    if not obj then return end
    offset   = offset   or Vec3(0,0,0)
    strength = strength or 32
    paletteIndex = paletteIndex or 1

    local colors = FlameColorsPendoli[paletteIndex]
    local base = obj:GetJointPosition(meshIndex, offset)
    local up   = obj:GetJointPosition(meshIndex, offset + Vec3(0,-128,0))
    local dir  = (up - base):Normalize() * strength

    for i=1,8 do
        local jitter = Vec3((math.random()-0.5)*8, (math.random()-0.5)*8, (math.random()-0.5)*8)
        Effects.EmitParticle(
            base,
            dir + jitter,
            math.random(0,1),
            0, 0,
            colors[1], colors[2],
            TEN.Effects.BlendID.ADDITIVE,
            64, 128,
            0.3 + math.random()*0.3,
            true, false,
            Objects.ObjID.DEFAULT_SPRITES,
            0
        )
    end
end




------------------------------------------------------------------------------------------
--   FUNCTIONS AUSILIARIE NEBBIE

local function spawnNebbiaScura(pos, nomeFog)
    local radiusfog = 10     -- unità di click
	local densityFog = 55 -- density
--	local nomeFog = "FogBaseTorre"
	Effects.EmitFogBulb(
    pos, 
    radiusfog, 
    densityFog, 
    Color(106, 90, 205), 
    nomeFog
    
    )
 
end

local function spawnNebbiaMinori(pos, raggio, density, nomeFog)

 
	Effects.EmitFogBulb(
    pos, 
    raggio, 
    density, 
    Color(106, 90, 205), 
    nomeFog
    
    )
 
end

local function spawnNebbiaGialloRossa(pos, raggio, density, nomeFog)

 
	Effects.EmitFogBulb(
    pos, 
    raggio, 
    density, 
    Color(200, 120, 30), 
    nomeFog
    
    )
 
end

local emitter_fog_pos
local emitter_fog_pos2
local emitter_fog_pos3
local emitter_fog_pos4
local emitter_fog_pos5


 
-----------------------------------------------------------------------------------------------
-- BADDYs per POSIZIONI LABIRINTO e LevelFuncs per teletrasporto

local baddy_lab_pos1
local baddy_lab_pos2
local baddy_lab_pos3
local baddy_lab_pos4
 
local tele_flag1 = false
local tele_flag2 = false
local tele_flag3 = false
local tele_flag4 = false

LevelFuncs.OnLaraTrasportoLab1 = function()

		if not tele_flag1 then
		
			Sound.PlaySound(1200) -- custom sound

			local poslaraafter = baddy_lab_pos1
	        local vellaraafter = Vec3(0,0,0)
	        local rotlaraafter = Rotation(0, 90, 0)
			Lara:SetRotation(rotlaraafter)
	
	        Lara:SetAnim(11)     -- animazione Lara Standing STILL
	        Lara:SetState(2)     -- in OnStart è lo stato di Lara 
	        Lara:SetPosition(poslaraafter)
	        Lara:SetVelocity(vellaraafter)
        
        	tele_flag1 = true
        
        end

end

LevelFuncs.OnLaraTrasportoLab2 = function()

		if not tele_flag2 then
		
			Sound.PlaySound(1200) -- custom sound

			local poslaraafter = baddy_lab_pos2
	        local vellaraafter = Vec3(0,0,0)
	        local rotlaraafter = Rotation(0, 180, 0)
			Lara:SetRotation(rotlaraafter)
	
	        Lara:SetAnim(11)     -- animazione Lara Standing STILL
	        Lara:SetState(2)     -- in OnStart è lo stato di Lara 
	        Lara:SetPosition(poslaraafter)
	        Lara:SetVelocity(vellaraafter)
        
        	tele_flag2 = true
        
        end

end

LevelFuncs.OnLaraTrasportoLab3 = function()

		if not tele_flag3 then
		
			Sound.PlaySound(1200) -- custom sound

			local poslaraafter = baddy_lab_pos3
	        local vellaraafter = Vec3(0,0,0)
	        local rotlaraafter = Rotation(0, 270, 0)
			Lara:SetRotation(rotlaraafter)
	
	        Lara:SetAnim(11)     -- animazione Lara Standing STILL
	        Lara:SetState(2)     -- in OnStart è lo stato di Lara 
	        Lara:SetPosition(poslaraafter)
	        Lara:SetVelocity(vellaraafter)
        
        	tele_flag3 = true
        
        end

end

LevelFuncs.OnLaraTrasportoLab4 = function()

		if not tele_flag4 then
		
			Sound.PlaySound(1200) -- custom sound

			local poslaraafter = baddy_lab_pos4
	        local vellaraafter = Vec3(0,0,0)
	        local rotlaraafter = Rotation(0, 270, 0)
			Lara:SetRotation(rotlaraafter)
	
	        Lara:SetAnim(11)     -- animazione Lara Standing STILL
	        Lara:SetState(2)     -- in OnStart è lo stato di Lara 
	        Lara:SetPosition(poslaraafter)
	        Lara:SetVelocity(vellaraafter)
        
        	tele_flag4 = true
        
        end

end

-------------------------------------------------------------------------------------------------
-- VARIABILI per ACCENSIONE FUOCHI

local fuoco_flag_1 = false

LevelFuncs.OnFireFlag1 = function()
	if not fuoco_flag_1 then
		fuoco_flag_1 = true
	end
end

LevelFuncs.OnFireFlagExit = function()
	if fuoco_flag_1 then
		fuoco_flag_1 = false
	end
end


------------------------------------------------------------
-- BOULDER fluttuante

local boulder1mobile
local bou_initpos = Vec3(61952, -0, 23040)
local room104_timer = 0.0
local AllowedRoom1 = TEN.Objects.GetRoomByName("roomBOUL")
local AllowedRoom1Number = AllowedRoom1:GetRoomNumber()
local AllowedRoom2 = TEN.Objects.GetRoomByName("corridoioIN")
local AllowedRoom2Number = AllowedRoom2:GetRoomNumber()
local AllowedRoom3 = TEN.Objects.GetRoomByName("corridoioOUT")
local AllowedRoom3Number = AllowedRoom3:GetRoomNumber()

--------------------------------------------------------------------
-- FUNZIONE AUSILIARIA: EVOLUZIONE DEL BOULDER MOBILE ed environment
--------------------------------------------------------------------

local function UpdateBoulderMotion(dt)

    local roomLaraB = Lara:GetRoomNumber()
    
    local raggio_2 = 80
    local inte1 = 40
    local inte2 = 30
    local emitter_fog_pos33 = Vec3(61952, 6144, 23040)
    spawnNebbiaGialloRossa(emitter_fog_pos33, raggio_2, inte1, "FogBase4a")
    spawnNebbiaMinori(emitter_fog_pos33, raggio_2, inte2, "FogBase5a")
    
    
    
    local fuochi_eva = {
	    Vec3(58880, -640, 23040),
	    Vec3(59904, -640, 23040),
	    Vec3(60928, -640, 23040),
	    Vec3(61952, -640, 23040),
	    Vec3(62976, -640, 23040),
	    Vec3(64000, -640, 23040),
	    Vec3(65024, -640, 23040)
	}
    
    local stren_fuochi = 2
    
    
    local T = 12.0          -- periodo in secondi
	local A = 2048.0         -- ampiezza in unità di posizione WORLD COORDINATES 1 blocco = 1024
	local omega = (2 * math.pi) / T
	
	local allowed_rooms = {
    [AllowedRoom1Number] = true,
    [AllowedRoom2Number] = true,
    [AllowedRoom3Number] = true
     }
    
    if allowed_rooms[roomLaraB] and boulder1mobile then
    
    
    	for i, pos in ipairs(fuochi_eva) do
		    Effects.EmitFire(pos, stren_fuochi)
		    Effects.EmitLight(
		        pos,                        -- posizione
		        Color(255, 140, 40),        -- colore
		        12,                         -- raggio
		        16,                         -- falloff
		        "lucefiamma_light_" .. i     -- chiave univoca per ogni luce
		    )
		end
    
    


    	
    	room104_timer = room104_timer + dt
    	
--    	print("ROOM TIMER 104", room104_timer)
    	
    	local X0 = bou_initpos.x
    	local Y0 = bou_initpos.y
    	local Z0 = bou_initpos.z
    	
    	local xt = X0 + A * math.sin((2 * math.pi * room104_timer) / T)
    	local yt = Y0 -- - 512
    	local zt = Z0
         
         

        -- sposta il boulder
        boulder1mobile:SetPosition(Vec3(
            xt,
            yt,zt
        ))
    end  -- if sulle rooms permesse
end -- end function

-----------------------------------------------------------------------------------------------
-- FUOCHI LETALI a tempo ASSE Z 

 
local firestreams = {
    { pos = Vec3(79360, -320, 22016), dir = Vec3(0,0,-1), timer = 0.0 },
    { pos = Vec3(79360, -320, 19968), dir = Vec3(0,0,1), timer = 1.0 },  
    { pos = Vec3(82432, -320, 19968), dir = Vec3(0,0,1), timer = 2.0 },
    { pos = Vec3(82432, -320, 22016), dir = Vec3(0,0,-1), timer = 3.0 } -- in opposizione di fase
}


local FIRESTREAM_DIR = Vec3(0, 0, -1)               -- direzione lungo +Z
local FIRESTREAM_SPEED = 96.0                     -- velocità particelle
local FIRESTREAM_ACTIVE_TIME = 5.0                 -- secondi accesi
local FIRESTREAM_INACTIVE_TIME = 7.0               -- secondi spenti
local FIRESTREAM_TIMER = 0.0                       -- timer cumulativo
local FIRESTREAM_ON = false                        -- stato attivo/spento


local function EmitStreamParticle(pos, dir)
    for i = 1, 6 do
        local offset = dir * (i * 32)  -- crea colonna lungo la direzione
        local jitter = Vec3(
            (math.random() - 0.5) * 8,
            (math.random() - 0.5) * 8,
            (math.random() - 0.5) * 8
        )
        Effects.EmitParticle(
            pos + offset + jitter,
            dir * FIRESTREAM_SPEED,
            0, 0, 0,
            Color(255, 150 + math.random(0,50), 40, 255),
            Color(60, 0, 0, 0),
            TEN.Effects.BlendID.ADDITIVE,
            64, 192,
            0.25 + math.random() * 0.25,
            true,   -- DAMAGE (gestire in estensione FireFX se vuoi danno)
            false,
            Objects.ObjID.DEFAULT_SPRITES, 0
        )
    end

    -- luce pulsante legata alla sorgente
    Effects.EmitLight(
        pos,
        Color(255, 140, 60, 255),
        24, 48,
        "firestream_light"
    )
end

 

function UpdateFireStreams(dt)
    for i, f in ipairs(firestreams) do
        f.timer = f.timer + dt
        local cycle = FIRESTREAM_ACTIVE_TIME + FIRESTREAM_INACTIVE_TIME
        local phase = f.timer % cycle
        local active = (phase <= FIRESTREAM_ACTIVE_TIME)
        if active then
            EmitStreamParticle(f.pos, f.dir)
        end
    end
end


-----------------------------------------------------------------------------------------------
-- VARIABILI PORTONE e functions da mandare in OnLoop(dt)

local PortoneEva
local porta9_accessoria
local posPortoneEvaInit = Vec3(92672, -0, 56320)
local posPortoneEvaFin = Vec3(92672, -1792, 56320)
local tempo_salita_eva = 12.0 -- secondi
local velSalitaEva = (posPortoneEvaFin.y - posPortoneEvaInit.y) / tempo_salita_eva
local time_PortoneEva = 0.0
local flagPortoneEva = 0

function UpdateFlagPortoneEva()
    if porta9_accessoria and flagPortoneEva == 0 then
        if porta9_accessoria:GetAnim() == 2 then
            flagPortoneEva = 1
        end
    end
end

local flag_playing = false

function UpdatePortoneEva(dt)

	if not PortoneEva then return end
	
	if PortoneEva and flagPortoneEva == 1 then   -- if 1


        if not flag_playing then
            Sound.PlaySound(1196)
            flag_playing = true
         end
		
		time_PortoneEva = time_PortoneEva + dt
		
		if time_PortoneEva < tempo_salita_eva then   -- if 2

             

			local p = posPortoneEvaInit.y + velSalitaEva * time_PortoneEva
			local positionEva = Vec3(posPortoneEvaInit.x, p, posPortoneEvaInit.z)
			PortoneEva:SetPosition(positionEva)
			--Sound.PlayAudioTrack("eqs", Sound.SoundTrackType.ONESHOT)
          --  Sound.PlaySound(1196)
			MakeEarthquake(3)
			
			
		else
			PortoneEva:SetPosition(posPortoneEvaFin)
		end  -- end if 2



        

		
	end   --end if 1

end




-----------------------------------------------------------------------------------------------
-- VARIABILI PORTONE TOMBA EVA e functions da mandare in OnLoop(dt)

local PortoneEvaTomba
local porta9_accessoriaTomba
local posPortoneEvaInitTomba = Vec3(73216, -6144, 86528)
local posPortoneEvaFinTomba = Vec3(73216, -8128, 86528)
local tempo_salita_evaTomba = 12.0 -- secondi
local velSalitaEvaTomba = (posPortoneEvaFinTomba.y - posPortoneEvaInitTomba.y) / tempo_salita_evaTomba
local time_PortoneEvaTomba = 0.0
local flagPortoneEvaTomba = 0
local flag_playing_tomba = false

function UpdateFlagPortoneEvaTomba()
    if porta9_accessoriaTomba and flagPortoneEvaTomba == 0 then
        if porta9_accessoriaTomba:GetAnim() == 2 then
            flagPortoneEvaTomba = 1
        end
    end
end



function UpdatePortoneEvaTomba(dt)

	if not PortoneEvaTomba then return end
	
	if PortoneEvaTomba and flagPortoneEvaTomba == 1 then   -- if 1

         if not flag_playing_tomba then
            Sound.PlaySound(1196)
            flag_playing_tomba = true
         end
		
		time_PortoneEvaTomba = time_PortoneEvaTomba + dt
		
		if time_PortoneEvaTomba < tempo_salita_evaTomba then   -- if 2

             


			local p = posPortoneEvaInitTomba.y + velSalitaEvaTomba * time_PortoneEvaTomba
			local positionEvaTomba = Vec3(posPortoneEvaInitTomba.x, p, posPortoneEvaInitTomba.z)
			PortoneEvaTomba:SetPosition(positionEvaTomba)
		--	Sound.PlayAudioTrack("eqs", Sound.SoundTrackType.ONESHOT)
           -- Sound.PlaySound(1196)
			MakeEarthquake(3)
			
			 
			
			
		else
			PortoneEvaTomba:SetPosition(posPortoneEvaFinTomba)
		end  -- end if 2


     
        
	end   --end if 1

end


-----------------------------------------------------------------------------------------
-- FUOCHI PIETRA FINALE TOMBA EVA
-- legato ad apertura portone finale tomba Eva


local fuochiFinaliFlag = false

LevelFuncs.OnPietraFinale = function()
	if not fuochiFinaliFlag then
		fuochiFinaliFlag = true
	end
end


local function AccendiFuochiFinali()
	if fuochiFinaliFlag and PortoneEvaTomba and flagPortoneEvaTomba == 1 then  -- if 1  
	
		local ppfe1 = Vec3(79360, -8704, 85504)
		local ppfe2 = Vec3(79360, -8704, 87552)
		
		local strengEva = 1
		
		EmitFuocoMio(ppfe1, strengEva, 121)
		EmitFuocoMio(ppfe2, strengEva, 221)
	end   -- end if 1
end
-----------------------------------------------------------------------------------------------
-- TINNOS MONSTERS bosses


local BOSS1_NAME = "claw_mutant_129"
local BOSS2_NAME = "claw_mutant_130"
local boss1, boss2
local boss1statua, boss2statua
local boss1HPinit = 200
local boss2HPinit = 200
local boss1HP, boss2HP
local DoorTinnosDefeat
local accendiFuochiTinnos = false





local function AccendiFuochiBoss()

	if accendiFuochiTinnos then

		local position1 = Vec3(83456, -6400, 79360)
		local position2 = Vec3(83456, -6400, 81408)
		local position3 = Vec3(87552, -6400, 81408)
		local position4 = Vec3(87552, -6400, 79360)
		local stren = 3
		EmitFuocoMio(position1, stren, 11)
		EmitFuocoMio(position2, stren, 12)
		EmitFuocoMio(position3, stren, 13)
		EmitFuocoMio(position4, stren, 14)
		
		
	
	end

end


local AccendiNebbiaFlag = false
LevelFuncs.OnNebbiaPreTinnos = function()
	AccendiNebbiaFlag = true
end

local function VaiNebbiaTinnos()
	if AccendiNebbiaFlag then
		local posnebbia = Vec3(85504, -5248, 77824)
		local raggio = 20
		local density = 25
		
		
		spawnNebbiaGialloRossa(posnebbia, raggio, density, "nebbia_boss_tinnos")
	end
end

local UI_Y1, UI_Y2 = 92, 84
local ALPHA_SPEED, BLINK_LIMIT = 35, 0.15

local bar_created1, bar_created2 = false, false

local function hide_bar_safe(name, hidden)
    if not CustomBar then return end
    if CustomBar.HideBar then
        CustomBar.HideBar(name, hidden)
    elseif CustomBar.SetBarHidden then
        CustomBar.SetBarHidden(name, hidden)
    end
end

local function is_active_and_alive(m)
    if not m or (m.GetValid and not m:GetValid()) then return false end
    if m.GetActive and not m:GetActive() then return false end
    if m.GetStatus and m:GetStatus() ~= TEN.Objects.MoveableStatus.ACTIVE then return false end
    if m.GetHP and m:GetHP() <= 0 then return false end
    return true
end

local function ensure_bar1()
    if bar_created1 or not CustomBar then return end
    boss1 = boss1 or TEN.Objects.GetMoveableByName(BOSS1_NAME)
    if not boss1 then return end

    local bgPos  = TEN.Vec2(50, UI_Y1)
    local bgSize = TEN.Vec2(42, 4)
    local leftX  = bgPos.x - (bgSize.x / 2)

    CustomBar.CreateEnemyHpBar({
        barName      = "tinnos1_hp",
        object       = BOSS1_NAME,

        objectIdBg   = TEN.Objects.ObjID.DIARY_SPRITES,
        spriteIdBg   = 1,
        colorBg      = TEN.Color(0, 0, 0),
        posBg        = bgPos,
        rotBg        = 0,
        scaleBg      = bgSize,
        alignModeBg  = TEN.View.AlignMode.CENTER,
        scaleModeBg  = TEN.View.ScaleMode.STRETCH,
        blendModeBg  = TEN.Effects.BlendID.ALPHABLEND,

        objectIdBar  = TEN.Objects.ObjID.DIARY_SPRITES,
        spriteIdBar  = 1,
        colorBar     = TEN.Color(30, 200, 80),    
        posBar       = TEN.Vec2(leftX, bgPos.y),--TEN.Vec2(leftX, bgPos.y),
        rot          = 0,
        scaleBar     = TEN.Vec2(bgSize.x - 1, bgSize.y - 1),--TEN.Vec2(bgSize.x - 2, bgSize.y - 1),
        alignMode    = TEN.View.AlignMode.CENTER_LEFT,
        scaleMode    = TEN.View.ScaleMode.STRETCH,
        blendMode    = TEN.Effects.BlendID.ALPHABLEND,

        hideText        = true,
        alphaBlendSpeed = ALPHA_SPEED,
        blink           = true,
        blinkLimit      = BLINK_LIMIT,
        showBar         = false
    })
    bar_created1 = true
end

local function ensure_bar2()
    if bar_created2 or not CustomBar then return end
    boss2 = boss2 or TEN.Objects.GetMoveableByName(BOSS2_NAME)
    if not boss2 then return end

    local bgPos  = TEN.Vec2(50, UI_Y2)
    local bgSize = TEN.Vec2(42, 4)
    local leftX  = bgPos.x - (bgSize.x / 2)

    CustomBar.CreateEnemyHpBar({
        barName      = "tinnos2_hp",
        object       = BOSS2_NAME,

        objectIdBg   = TEN.Objects.ObjID.DIARY_SPRITES,
        spriteIdBg   = 1,
        colorBg      = TEN.Color(0, 0, 0),
        posBg        = bgPos,
        rotBg        = 0,
        scaleBg      = bgSize,
        alignModeBg  = TEN.View.AlignMode.CENTER,
        scaleModeBg  = TEN.View.ScaleMode.STRETCH,
        blendModeBg  = TEN.Effects.BlendID.ALPHABLEND,

        objectIdBar  = TEN.Objects.ObjID.DIARY_SPRITES,
        spriteIdBar  = 1,
        colorBar     = TEN.Color(0, 128, 255),   
        posBar       = TEN.Vec2(leftX, bgPos.y),--TEN.Vec2(leftX, bgPos.y),
        rot          = 0,
        scaleBar     = TEN.Vec2(bgSize.x - 1, bgSize.y - 1),--TEN.Vec2(bgSize.x - 2, bgSize.y - 1),
        alignMode    = TEN.View.AlignMode.CENTER_LEFT,
        scaleMode    = TEN.View.ScaleMode.STRETCH,
        blendMode    = TEN.Effects.BlendID.ALPHABLEND,

        hideText        = true,
        alphaBlendSpeed = ALPHA_SPEED,
        blink           = true,
        blinkLimit      = BLINK_LIMIT,
        showBar         = false
    })
    bar_created2 = true
end

LevelFuncs.OnActivateTinnos = function()

    TEN.Objects.GetMoveableByName("door_type8_223"):Disable()

	boss1statua:Shatter()
	boss2statua:Shatter()
	
	accendiFuochiTinnos = true
	
	
	
	boss1:Enable()
	boss2:Enable()
	
	ensure_bar1()
    ensure_bar2()
    
    
	local trackname = "apos"
	local tt = Sound.SoundTrackType.ONESHOT
    Sound.PlayAudioTrack(trackname, tt)
	
end
---------------------------------------------------------------------------
----------------------------------------------------------
-- ausiliarie per gli screenshots
local cameraScreenshot
local baddyScreenshot
local flag_screen = false
LevelFuncs.OnCamPerScreen = function()
	 
		flag_screen = true
	 
	
end


local function PlayCameraScreenshots()

	
	cameraScreenshot = TEN.Objects.GetCameraByName("camera_222")
	baddyScreenshot = TEN.Objects.GetMoveableByName("baddy1_202")

	if flag_screen then
		cameraScreenshot:Play(baddyScreenshot)
		if Input.IsKeyHit(Input.ActionID.LOOK) then  
    	flag_screen = not flag_screen
        end
	end
	

	
end
-----------------------------------------------------------------------------------------------
-- Function per inizializzazione
-- Da usare in OnStart e OnLoad
local function InitAll()

-------------------------------------------------------------------
-- AUSILIARIE per screenshots


    







------------------------------------------------------------------

	DoorEvaPre = TEN.Objects.GetMoveableByName("door_type9_224")

	PortoneEva = TEN.Objects.GetStaticByName("static_mesh_120")
	porta9_accessoria = TEN.Objects.GetMoveableByName("door_type9_121")
	
	
	boss1statua = TEN.Objects.GetStaticByName("static_mesh_132")
	boss2statua = TEN.Objects.GetStaticByName("static_mesh_133")
	boss1 = TEN.Objects.GetMoveableByName("claw_mutant_129")
	boss2 = TEN.Objects.GetMoveableByName("claw_mutant_130")
	DoorTinnosDefeat = TEN.Objects.GetMoveableByName("door_type8_125")
	
	PortoneEvaTomba = TEN.Objects.GetStaticByName("static_mesh_122")
	porta9_accessoriaTomba = TEN.Objects.GetMoveableByName("door_type9_123")
	
	
 





--BOULDER MOBILE per room
	boulder1mobile = TEN.Objects.GetMoveableByName("pushable_object_climbable1_91")
	 

-- inizializzazione dei pendoli
--    for i, p in ipairs(pendoli_character) do
--        local obj = TEN.Objects.GetMoveableByName(p.name)
--        if obj then
--            pendoli[i] = obj
--            FixedPendulum(obj, p.color)
--        else
--            print("Pendolo non trovato: "..p.name)
--        end
--    end

   local baddy1 = TEN.Objects.GetMoveableByName("baddy1_11")
   emitter_fog_pos = baddy1:GetPosition()
   local baddy2 = TEN.Objects.GetMoveableByName("baddy1_12")
   emitter_fog_pos2 = baddy2:GetPosition()

-- posizioni baddies per il teletrasporto nel labirinto   

   local baddy4 = TEN.Objects.GetMoveableByName("baddy1_28")
   baddy_lab_pos1 = baddy4:GetPosition()


   local baddy3 = TEN.Objects.GetMoveableByName("baddy1_31")
   baddy_lab_pos2 = baddy3:GetPosition()
   
   local baddy5 = TEN.Objects.GetMoveableByName("baddy1_35")
   baddy_lab_pos3 = baddy5:GetPosition()
   
   local baddy6 = TEN.Objects.GetMoveableByName("baddy1_20")
   baddy_lab_pos4 = baddy6:GetPosition()

   
end -- end InitAll



--------------------------------------------------------------------------------
-- FUNCTION di fine livello per statistiche
-- da matchare con blocco in OnLoop e in OnFreeze

 

LevelFuncs.OnFineLivello = function()

	local id_book = 500   -- puzzle item 1
	local count_book = GetItemCount(id_book)
	
	if count_book == 1 then
       Common.ShowStatsHUD()
    end

end -- end OnFineLivello
-----------------------------------------------------------------------------------------------------------


----------------------------------------------------------------------
-- FLAG fuoco segreto tre pietre

local flag_fuoco_segreti = false

LevelFuncs.OnFlagFuocoSegreto = function()

	flag_fuoco_segreti = not flag_fuoco_segreti

end


LevelFuncs.OnAttivaDoorBoss = function()
    TEN.Objects.GetMoveableByName("door_type8_223"):Enable()
end    

LevelFuncs.OnStart = function() 


InizializzaPendoli()

 

diary:UnlockPages(15,false)  



     


--------------------------------------------------------------------------------------------------------
-- INVENTORY STUFF 

------------------
-- TEST da togliere in release

--TEN.Objects.GetMoveableByName("door_type9_63"):Enable()

--Inventory.SetItemCount(503, 4)  -- serafi per provare meccanismo portone
--Inventory.SetItemCount(501, 1)  -- pietra per provare meccanismo gate uscita livello
--Inventory.SetItemCount(503, 2) -- serafi per prova meccanismo apertura porte 4
 
local id_flare = 983   -- flare item
local count_flare = GetItemCount(id_flare)

if count_flare ~= 0 then     -- se ci sono flare nell'inventario allora si sono saltati i primi due livelli
	Inventory.SetItemCount(954, 1)	   -- mette lo shotgun in inventario 
	Inventory.SetItemCount(955, 18)    -- cartucce rosse
	Inventory.SetItemCount(956, 6)    -- cartucce blu
	Inventory.SetItemCount(978, 3)    -- medikit grande
	Inventory.SetItemCount(979, 6)    -- medikit piccolo
	Inventory.SetItemCount(983, 0)   -- azzera flare
	
	Lara:SetWeaponType(WeaponType.SHOTGUN, false)
    Lara:SetWeaponType(WeaponType.PISTOLS, false)
    
end

    

--------------------------------------------------------------------------------------
-- Energia iniziale Lara 
	Lara:SetHP(1000)
    print("LARA HEALTH INIZIO =", Lara:GetHP())


----------------------------------------------------------------------------------------------------------




	Common.level_time = 0      -- inizio timer per statistiche

---------------------------------------------------------------------------------------------------------
-- inizializzazione moveables e statics

     InitAll()

--   print("=== Module View functions ===")
--for k, v in pairs(View) do
--    print(k, type(v))
--end




	if boss1 then 
		boss1:SetHP(boss1HPinit)   
		boss1HP = boss1:GetHP()
		print("BOSS 1 OK", boss1HP)
     end
     
     if boss2 then 
		boss2:SetHP(boss2HPinit) 
		boss2HP = boss2:GetHP()
		print("BOSS 2 OK",  boss2HP)
     end

	 

end  -- end OnStart

LevelFuncs.OnLoop = function(dt) 

  

--PlayCameraScreenshots()    -- per screenshots

	IngressoEvaUno()
	AccendiFuochiCamereIniziali()
	AccendiFuochiCameraTinnosIniziale()
	AccendiFuochiCameraTinnosAltro()


	UpdateFlagPortoneEva()
	UpdatePortoneEva(dt)
	
	UpdateFlagPortoneEvaTomba()
	UpdatePortoneEvaTomba(dt)

	UpdateFireStreams(dt)
	
	UpdateBoulderMotion(dt)

	UpdateTrapFourFires(dt)
	
	EmitFireTombaEva()
	AccendiFuochiFinali()
	
	AccendiFuochiBoss()
	VaiNebbiaTinnos()

-------------------------------------------------------------------
--  FUOCO camera SEGRETO tre PIETRE

	if flag_fuoco_segreti then
	local posizione_fuoco_segreto = Vec3(51712, -896, 33280)
	local strength__fuoco_segreto = 3
	local posizione_pointlight_segreto = Vec3(51712, -2048, 33280)
	
		Effects.EmitFire(posizione_fuoco_segreto, strength__fuoco_segreto)
		Effects.EmitLight(
	        posizione_pointlight_segreto,   -- posizione  
	        Color(255, 140, 40),         -- colore  
	        12,                          -- radius
	        16,                          -- falloff
	        "segreto_light_1"                 -- chiave univoca
	    )
	
	end


--------------------------------------------------------------------
   ---------------------------------------------------------------------------------------
-- ANIMAZIONE CUSTOM PENDOLI TINNOS
--		print("PENDOLO FLAGS", pendolo_flags[1])
 -- 🔹 Incrementa il tempo (solo se almeno un pendolo è attivo)
    if pendolo_flags[1] or pendolo_flags[2] or pendolo_flags[3] then
        tPendolo = tPendolo + dt
    end

    -- 🔹 Calcola i frame correnti per i tre pendoli
    --    (sfasi naturali: 0°, 120°, 240°)
    local f1 = math.floor((tPendolo / PeriodPendolo) * nFrames) % nFrames
    local f2 = math.floor(((tPendolo + PeriodPendolo/3) / PeriodPendolo) * nFrames) % nFrames
    local f3 = math.floor(((tPendolo + 2*PeriodPendolo/3) / PeriodPendolo) * nFrames) % nFrames

    -- 🔹 Pendolo 1
    if pendolo_flags[1] and pendolo1 then
        pendolo1:SetFrame(f1)
        EmitFlameAtLocal(pendolo1, 5, Vec3(0, -256, 0), 32, 1)
        local pos1tinnospen = pendolo1:GetJointPosition(5, Vec3(0,-256,0))
		Effects.EmitLight(pos1tinnospen, Color(110,160,255,255), 10, 16, "p1_light")
    end

    -- 🔹 Pendolo 2
    if pendolo_flags[2] and pendolo2 then
        pendolo2:SetFrame(f2)
        EmitFlameAtLocal(pendolo2, 5, Vec3(0, -256, 0), 32, 2)
        local pos2tinnospen = pendolo2:GetJointPosition(5, Vec3(0,-256,0))
		Effects.EmitLight(pos2tinnospen, Color(150,140,255,255), 10, 16, "p2_light")
    end

    -- 🔹 Pendolo 3
    if pendolo_flags[3] and pendolo3 then
        pendolo3:SetFrame(f3)
        EmitFlameAtLocal(pendolo3, 5, Vec3(0, -256, 0), 32, 3)
        local pos3tinnospen = pendolo3:GetJointPosition(5, Vec3(0,-256,0))
		Effects.EmitLight(pos3tinnospen, Color(180,100,255,255), 10, 16, "p3_light")
    end
   




----------------------------------------------------------------------------------------
-- DIARIO

	if Input.IsKeyHit(Input.ActionID.H) then
        diary:ShowDiary(1)
    end
    
---------------------------------------------------------------------------------------- 

    Common.UpdateLevelTime(dt)
    Common.DrawWeaponHUD()
    Common.UpdateFlare(dt)
 

---------------------------------------------------------------------------------------
-- NEBBIE

    spawnNebbiaScura(emitter_fog_pos, 40, 40, "FogBase1")
    local raggio_2 = 80
    local inte1 = 40
    local inte2 = 30
	spawnNebbiaGialloRossa(emitter_fog_pos2, raggio_2, inte1, "FogBase2")
    spawnNebbiaMinori(emitter_fog_pos2, raggio_2, inte2, "FogBase3")
    
--    local emitter_fog_pos_nuovo = Vec3(88576, 3072, 48640)
--    spawnNebbiaGialloRossa(emitter_fog_pos_nuovo, raggio_2, inte2, "FogBaseA1")
--    spawnNebbiaMinori(emitter_fog_pos_nuovo, raggio_2, inte2, "FogBaseA2")
    
    local fire_emitter_nuovo_1 = Vec3(88576, 3072, 48640)
    local fire_emitter_nuovo_2 = Vec3(87552, 3072, 48640)
    local fire_emitter_nuovo_3 = Vec3(89600, 3072, 48640)
    local fire_nuovo_forza = 6
    
    EmitFuocoMio(fire_emitter_nuovo_1, fire_nuovo_forza, 717)
    EmitFuocoMio(fire_emitter_nuovo_2, fire_nuovo_forza, 727)
    EmitFuocoMio(fire_emitter_nuovo_3, fire_nuovo_forza, 737)
    
    
--   spawnNebbiaScura(emitter_fog_pos4, 80, 40, "FogBase4")


----------------------------------------------------------------------------------------------
-- FUOCHI camera fine labirinto


	if fuoco_flag_1 then

		local pp1 = Vec3(50688, 3072, 50688)
		local pp2 = Vec3(48640, 3072, 50688)
		local pp3 = Vec3(49664, 3584, 51712)
	 
	 	Effects.EmitFire(pp1,3)
	 	Effects.EmitFire(pp2,3)
	 	Effects.EmitFire(pp3,1)
	 	
	 	Effects.EmitLight(
	        pp1,   -- posizione  
	        Color(255, 140, 40),         -- colore  
	        12,                          -- radius
	        16,                          -- falloff
	        "fire_light_1"                 -- chiave univoca
	    )
	    
	    Effects.EmitLight(
	        pp2,   -- posizione  
	        Color(255, 140, 40),         -- colore  
	        12,                          -- radius
	        16,                          -- falloff
	        "fire_light_2"                 -- chiave univoca
	    )
	    
	    Effects.EmitLight(
	        pp3,   -- posizione  
	        Color(255, 140, 40),         -- colore  
	        12,                          -- radius
	        16,                          -- falloff
	        "fire_light_3"                 -- chiave univoca
	    )
 	
 	end
 	
----------------------------------------------------------------------------------
-- APERTURA PORTA TOMBA dopo defeat boss2 



 if boss1 then
	boss1HP = boss1:GetHP()
 end
 if boss2 then
	boss2HP = boss2:GetHP()
	if boss2:GetHP() == 0 then
		DoorTinnosDefeat:Enable()
	end
 end	 
 
-------------------------------------------------------
-- barre boss
--    if not bar_created1 then ensure_bar1() end
--    if not bar_created2 then ensure_bar2() end

    -- visibilità “on target” (solo quando Lara li punta)
    if bar_created1 and boss1 then
        local want1 = is_active_and_alive(boss1) and (boss1.GetHitStatus and boss1:GetHitStatus() or false)
        hide_bar_safe("tinnos1_hp", not want1)
    end

    if bar_created2 and boss2 then
        local want2 = is_active_and_alive(boss2) and (boss2.GetHitStatus and boss2:GetHitStatus() or false)
        hide_bar_safe("tinnos2_hp", not want2)
    end

----------------------------------------------------- 

end  -- end OnLoop


LevelFuncs.OnSave = function() 

	LevelVars.level_time = Common.level_time
    LevelVars.flare_on = Common.flare_on
    LevelVars.flare_pitch = Common.flare_pitch
    
    LevelVars.sflag = sflag
    
    LevelVars.tele_flag1 = tele_flag1
    LevelVars.tele_flag2 = tele_flag2
    LevelVars.tele_flag3 = tele_flag3
    LevelVars.tele_flag4 = tele_flag4
    
    LevelVars.fuoco_flag_1 = fuoco_flag_1
    
    LevelVars.flag_fuoco_segreti = flag_fuoco_segreti
    
    LevelVars.trap_timer = trap_timer
    LevelVars.countdown_timer  = countdown_timer 
    
    LevelVars.ira_eva = ira_eva 
    LevelVars.ira_eva_door = ira_eva_door
    LevelVars.trap_cycle_timer = trap_cycle_timer
    LevelVars.flag_wraith = flag_wraith
    
  
    LevelVars.room104_timer = room104_timer 
    
    LevelVars.firestreams_timers = {}
    for i, f in ipairs(firestreams) do
        LevelVars.firestreams_timers[i] = f.timer
    end
    
    LevelVars.time_PortoneEva = time_PortoneEva
    LevelVars.flagPortoneEva = flagPortoneEva
    
    LevelVars.boss1HP = boss1HP
    LevelVars.boss2HP = boss2HP
     
    LevelVars.time_PortoneEvaTomba = time_PortoneEvaTomba
    LevelVars.flagPortoneEvaTomba = flagPortoneEvaTomba
    
    LevelVars.tombaeva_flag = tombaeva_flag
    
    LevelVars.accendiFuochiTinnos = accendiFuochiTinnos
    LevelVars.AccendiNebbiaFlag = AccendiNebbiaFlag
    
    LevelVars.fuochiFinaliFlag = fuochiFinaliFlag
    
    LevelVars.bar_created1 = bar_created1
	LevelVars.bar_created2 = bar_created2
	
	LevelVars.flag_musica_adamo = flag_musica_adamo
	LevelVars.flag_musica_bloccovolante = flag_musica_bloccovolante
	LevelVars.flag_musica_accessoeva = flag_musica_accessoeva
	LevelVars.flag_musica_accessolivello = flag_musica_accessolivello
	LevelVars.flag_musica_tuttiequattro = flag_musica_tuttiequattro
	LevelVars.flag_musica_percamerablu = flag_musica_percamerablu
	LevelVars.flag_musica_dopoboss = flag_musica_dopoboss
	LevelVars.flag_text_laramaze = flag_text_laramaze
	
	LevelVars.flag_fuoco_camereiniziali = flag_fuoco_camereiniziali
	
	LevelVars.TinnosFlagPerFuochi = TinnosFlagPerFuochi
	
	LevelVars.TinnosFlagAltroMostro = TinnosFlagAltroMostro
	
	LevelVars.flag_lara_threshold = flag_lara_threshold
	
	LevelVars.flag_screen = flag_screen

    LevelVars.pendolo_flags = pendolo_flags
    LevelVars.tPendolo = tPendolo

    LevelVars.flag_risata = flag_risata
     
    LevelVars.flag_playing = flag_playing
    LevelVars.flag_playing_tomba = flag_playing_tomba
     


end -- end OnSave


LevelFuncs.OnLoad = function() 

    InitAll()
    InizializzaPendoli()

	Common.level_time = LevelVars.level_time or 0
    Common.flare_on = LevelVars.flare_on or false
    Common.flare_pitch = LevelVars.flare_pitch or 0	
    
    sflag = LevelVars.sflag or 0 
    
    tele_flag1 = LevelVars.tele_flag1 or false
    tele_flag2 = LevelVars.tele_flag2 or false
    tele_flag3 = LevelVars.tele_flag3 or false
    tele_flag4 = LevelVars.tele_flag4 or false
    
    fuoco_flag_1 = LevelVars.fuoco_flag_1 or false
    
    flag_fuoco_segreti = LevelVars.flag_fuoco_segreti or false
    
    trap_timer = LevelVars.trap_timer or 0.0
    countdown_timer = LevelVars.countdown_timer or TRAP_DELAY
    ira_eva = LevelVars.ira_eva or false
    ira_eva_door = LevelVars.ira_eva_door or false
    trap_cycle_timer = LevelVars.trap_cycle_timer or 0.0
    flag_wraith = LevelVars.flag_wraith or false
    

    
    room104_timer = LevelVars.room104_timer or 0.0
    
    if LevelVars.firestreams_timers then
        for i, t in ipairs(LevelVars.firestreams_timers) do
            if firestreams[i] then
                firestreams[i].timer = t
            end
        end
    end
    
    
    time_PortoneEva = LevelVars.time_PortoneEva or 0.0 
    flagPortoneEva = LevelVars.flagPortoneEva or 0
    
    boss1HP = LevelVars.boss1HP or boss1HPinit
    boss2HP = LevelVars.boss2HP or boss2HPinit
    if boss1 then boss1:SetHP(boss1HP) end
    if boss2 then boss2:SetHP(boss2HP) end

	bar_created1 = LevelVars.bar_created1 or false
	bar_created2 = LevelVars.bar_created2 or false

    
    
    if boss1 then 
		 
		print("BOSS 1 OK FROM OnLoad()", boss1HP)
     end
     
     if boss2 then 
		 
		print("BOSS 2 OK FROM OnLoad()",  boss2HP)
     end
     
     time_PortoneEvaTomba = LevelVars.time_PortoneEvaTomba or 0.0 
     flagPortoneEvaTomba = LevelVars.flagPortoneEvaTomba or 0
     
     tombaeva_flag = LevelVars.tombaeva_flag or false
     
     accendiFuochiTinnos = LevelVars.accendiFuochiTinnos or false
     AccendiNebbiaFlag = LevelVars.AccendiNebbiaFlag or false
     
     fuochiFinaliFlag = LevelVars.fuochiFinaliFlag or false
     
     flag_musica_adamo = LevelVars.flag_musica_adamo or false
     flag_musica_bloccovolante = LevelVars.flag_musica_bloccovolante or false
     flag_musica_accessoeva = LevelVars.flag_musica_accessoeva or false
     flag_musica_accessolivello = LevelVars.flag_musica_accessolivello or false
     flag_musica_tuttiequattro = LevelVars.flag_musica_tuttiequattro or false
     flag_musica_percamerablu = LevelVars.flag_musica_percamerablu or false
     flag_musica_dopoboss = LevelVars.flag_musica_dopoboss or false
     flag_text_laramaze = LevelVars.flag_text_laramaze or false
     
     flag_fuoco_camereiniziali = LevelVars.flag_fuoco_camereiniziali or false 
    
	 TinnosFlagPerFuochi = LevelVars.TinnosFlagPerFuochi or false    
	 
	 TinnosFlagAltroMostro = LevelVars.TinnosFlagAltroMostro or false
	 
	 flag_lara_threshold = LevelVars.flag_lara_threshold or false
	 
	 flag_screen = LevelVars.flag_screen or false
	 
	 pendolo_flags = LevelVars.pendolo_flags or {false,false,false}
	 tPendolo = LevelVars.tPendolo or false 

     flag_risata = LevelVars.flag_risata or false

     flag_playing = LevelVars.flag_playing or false
     flag_playing_tomba = LevelVars.flag_playing_tomba or false

end -- end OnLoad

LevelFuncs.OnFreeze = function() 

   Common.OnFreeze()
    
    
end    -- end OnFreeze    


LevelFuncs.OnEnd = function() end
LevelFuncs.OnUseItem = function() end
