-- FILE: Levels\Matera.lua



--------------------------------------------------------------
-- FUNZIONE AUSILIARIA per fuoco più luce

local function EmitFuocoMio(posizione, stren, ii)

			Effects.EmitFire(posizione, stren)
		    Effects.EmitLight(
		        posizione,                        -- posizione
		        Color(255, 140, 40),        -- colore
		        12,                         -- raggio
		        16,                         -- falloff
		        "lucefireandlight_" .. ii     -- chiave univoca per ogni luce
		    )

end 
----------------------------------------------------------------------------------------


LevelFuncs.OnPortaSegretoGere = function()
    TEN.Objects.GetMoveableByName("door_type9_205"):Enable()
end

LevelFuncs.OnSegretoDisattivaPorta = function()
    TEN.Objects.GetMoveableByName("door_type9_360"):Disable()
end
---------------------------------------------------------------------------------
----- DINAMICA shatter e enable Tinnos statua e Tinnos monster

local flag_perilfuoco = false
local flag_esplosione = false

local function perilfuoco()

    if flag_perilfuoco then

        local posiTinnosStatua = Vec3(38400, -256, 15872)
        local strenT = 2
        local id_luce_altare = 1341

        EmitFuocoMio(posiTinnosStatua, strenT, id_luce_altare)

    end

end

LevelFuncs.OnTinnosActivateAndShatter = function()

    local SW1 = TEN.Objects.GetMoveableByName("switch_type2_2")
    local SW2 = TEN.Objects.GetMoveableByName("switch_type2_3")
    local SW3 = TEN.Objects.GetMoveableByName("switch_type2_4")
    local SW4 = TEN.Objects.GetMoveableByName("switch_type2_5")       


       local anim1 = SW1:GetAnim()
       local anim2 = SW2:GetAnim()
       local anim3 = SW3:GetAnim()
       local anim4 = SW4:GetAnim()


        local condizione_ok = (anim1 == 1 and anim3 == 1 and anim4 == 1 and anim2 == 0)

    if not flag_perilfuoco and condizione_ok then
        
        flag_perilfuoco = true

    end

    if flag_perilfuoco and not flag_esplosione then


        local statuaTinnosShatter = TEN.Objects.GetStaticByName("static_mesh_370")
        local MonsterAltare = TEN.Objects.GetMoveableByName("claw_mutant_250")

        statuaTinnosShatter:Shatter()
        MonsterAltare:Enable()

        Sound.PlaySound(1199)

    --    flag_perilfuoco = true
        flag_esplosione = true

    end

end









-----------------------------------------------------

local flag_camera_portone1 = false
local flag_camera_portone2 = false
local flag_camera_portone3 = false

-----------------------------------------------
-- BARRE suggerimento

LevelFuncs.OnBarre = function()

 
	local pos = Vec2(PercentToScreen(50, 88))
 		local duration = 8.0  

    	local s = DisplayString(
        [[Press ACTION to grab the bar. 
          Release ACTION to let go and launch Lara forward]],
        pos,
        1.0,
        Color(200, 220, 255)  
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true) 
    Sound.PlaySound(1198) -- custom suono notifica
	
end



------------------------------------------------------------------------------------------
-- DIARIO

local CustomDiary = require("Engine.CustomDiary")
CustomDiary.ImportDiary("DiarySetup")
local diary = CustomDiary.Get(TEN.Objects.ObjID.DIARY_ITEM)
 

local sflag = 0

LevelFuncs.OnBookExit = function()


	 
 
	if  sflag == 0 then
		diary:UnlockPages(14, false)
		sflag = 1
		
		local pos = Vec2(PercentToScreen(50, 92))
 		local duration = 8.0  

    	local s = DisplayString(
        "Notes added to the diary. Press H to check",
        pos,
        1.0,
        Color(200, 220, 255)  
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true) 
    Sound.PlaySound(1198) -- custom suono notifica
	end

end


LevelFuncs.OnSeasonsPuzzle = function()


	 
 
	if  sflag == 1 then
		diary:UnlockPages(15, false)
		sflag = 2
		
		local pos = Vec2(PercentToScreen(50, 92))
 		local duration = 8.0  

    	local s = DisplayString(
        "Notes added to the diary. Press H to check",
        pos,
        1.0,
        Color(200, 220, 255)  
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true) 
    Sound.PlaySound(1198) -- custom suono notifica
	end

end



------------------------------------------------------------------------------------------
--   NEBBIA TORRE LAMENTAZIONI




local function spawnNebbiaScura(pos, nomeFog)
    local radiusfog = 10     -- unità di click
	local densityFog = 55 -- density
--	local nomeFog = "FogBaseTorre"
	Effects.EmitFogBulb(
    pos, 
    radiusfog, 
    densityFog, 
    Color(106, 90, 205), 
    nomeFog
    
    )
 
end

local function spawnNebbiaMinori(pos, raggio, density, nomeFog)

 
	Effects.EmitFogBulb(
    pos, 
    raggio, 
    density, 
    Color(106, 90, 205), 
    nomeFog
    
    )
 
end



-- punti di emissione 
local spots_pozze_nebbia = {
    Vec3(28160, -0, 38400),
    Vec3(30720, -0, 41472),
    Vec3(28160, -0, 44544),
    Vec3(25600, -0, 41984),
    Vec3(20992, -0, 45568),
    Vec3(20992, -0, 38400),
    Vec3(36352, -0, 38400),
    Vec3(36352, -0, 45568)
}

local spots_pozze_nebbia_minori = {

	Vec3(16896, -5888, 48128)   -- pozza primo cunicolo torre
	
}

local spots_pozze_nebbia_segreto = {

	 
	Vec3(29696, -0, 61440)       -- sala segreto due mostri
 
}


------------------------------------------------------------------------------------------
-- POINTLIGHT A TEMPO per CAMERA SEGRETA LAMENTAZIONI

local door_timer = -1

LevelFuncs.OnDoorTimer = function()
	door_timer = 10 ----- timer porta, da usare per pointlight
end

----------------------------------------------------------------------------------------
-- ===== Ammo HUD universale con Shotgun dettagliato =====

local WEAPON_UI = {
    [Objects.WeaponType.PISTOLS]  = { label = "Pistols",  y = 50,  color = Color(255, 255,   0, 255) },
    [Objects.WeaponType.UZI]      = { label = "Uzi",      y = 70,  color = Color(  0, 200, 255, 255) },
    [Objects.WeaponType.SHOTGUN]  = { label = "Shotgun",  y = 70,  color = Color(255, 100, 100, 255) },
    [Objects.WeaponType.HK] = { label = "HK", y = 70, color = Color(255, 180,  60, 255) },
}

-----------------------------------------------------------------------
-- CAMERA PARKOUR
local CameraParkourFlag = false
LevelFuncs.OnCameraParkourON = function()
	CameraParkourFlag = true
end
LevelFuncs.OnCameraParkourOFF = function()
	CameraParkourFlag = false
end


--------------------------------------------------------------------
-- CUSTOM FLARE

local flare_on = false
local flare_pitch = 0



--------------------------------------------------------------------
-- require
local AudioDurations = require("Levels.AudioDurations")

--local Common = require("Levels.commonfunctions")

 
--------------------------------------------------
-- PUZZLE FUOCHI A ROMBO

local Interruttore1
local Interruttore2
local Interruttore3
local Interruttore4
--local PosizioniFuochiPuzzle = {Vec3(9728, 10240, 43520),       
--							   Vec3(9728, 10240, 41472),        
--							   Vec3(8704, 10240, 42496),         
--							   Vec3(10752, 10240, 42496)       
--}


local PosizioniFuochiPuzzle = {Vec3(9728, 9728, 44032),       --
							   Vec3(9728, 9728, 40960),       --
							   Vec3(8192, 9728, 42496),       --  
							   Vec3(11264, 9728, 42496)       --
}

local PosizioniFuochiMuro = {Vec3(9728, 10240, 36352),
						     Vec3(9728, 10240, 38400),
						     Vec3(9728, 10240, 37376)
}
 

-- stato booleano dei fuochi
local fire_on = { false, false, false, false }

-- definizione collegamenti a rombo
local ADJ = {
    [1] = {1,2,4},
    [2] = {1,2,3},
    [3] = {2,3,4},
    [4] = {3,4,1}
}

-- animazioni precedenti degli switch
local prev_anim = {0,0,0,0}

-- helper: toggle fuochi
local function toggle_fires(list)
    for _,i in ipairs(list) do
        fire_on[i] = not fire_on[i]
    end
    -- stampa lo stato corrente
    print(string.format("Stato fuochi: [%s, %s, %s, %s]",
        tostring(fire_on[1]),
        tostring(fire_on[2]),
        tostring(fire_on[3]),
        tostring(fire_on[4])
    ))
end

-- check se tutti i fuochi sono accesi
local function all_on()
    for i=1,4 do if not fire_on[i] then return false end end
    return true
end

local function update_fire_puzzle()
	    local anims = { 
	        Interruttore1:GetAnim(), 
	        Interruttore2:GetAnim(), 
	        Interruttore3:GetAnim(), 
	        Interruttore4:GetAnim() 
	    }
	
	    for i=1,4 do
	        local a = anims[i]
	        -- Considera solo stati stabili (0 su, 1 giù)
	        if (a == 0 or a == 1) and a ~= prev_anim[i] then
	            toggle_fires(ADJ[i])
	            prev_anim[i] = a
	        end
	    end
	
--	    if all_on() then
--	        print("Puzzle completato! Tutti i fuochi ON.")
--	    end
end

------------------------------------------------------- 
 

local SW1_NAME   = "switch_type2_2"            
local SW2_NAME   = "switch_type2_3"
local SW3_NAME   = "switch_type2_4"            
local SW4_NAME   = "switch_type2_5"        
local DOOR_NAME  = "static_mesh_32" 
local GhostDoorName = "door_type8_20"
local StaticAltarName = "static_mesh_34"
local BaddyGhostName = "baddy1_27"
local BaddyGhostName2 = "baddy1_29"
local CameraAltareName = "camera_28"
local CameraPortoneName = "camera_53"
local Pendolo1Name = "pendolo1"
local Pendolo2Name = "pendolo2"
local Pendolo3Name = "pendolo3"
local Pendolo4Name = "pendolo4"
local Pendolo5Name = "pendolo5"


 

 
 
local SW1, SW2, SW3, SW4
local portone1 
local base_portone1 
local BaddyGhost
local BaddyGhost2
local CameraAltare
local CameraPortone

local portonesmall1
local baseportsmall1
local portaperportsmall
local SWsmall
local flagPortoneSmall = false
local t_open_small = 0.0
local CameraPortoneSmall
local base_portonesmall1_x, base_portonesmall1_z


-------------------------------------------------------
-- PENDOLI

local phase = {0, 0.2, 0.4, 0.6, 0.8}
local Pendolo1
local Pendolo2
local Pendolo3
local Pendolo4
local Pendolo5

 

local offsetFiammaPendolo = Vec3(0, -256, 0)
local joint_coppa = 5
local forzaFiamma = 32


local FlagPendolo = false
local tPendolo = 0               -- tempo accumulato
local PeriodPendolo = 3.0        -- periodo dell’oscillazione in secondi
local nFrames = 88     -- frames animazione letto da wad2

local FlameColorsPendoli = {
    { Color(50,200,255,255), Color(0,50,100,0) },     -- blu glaciale
    { Color(80,200,120,255), Color(20,60,40,0) },      -- verde smeraldo
    { Color(255,180,50,255), Color(100,40,0,0) },     -- arancio dorato
    { Color(80,160,255,255), Color(20,40,80,0) },      -- azzurro mistico
    { Color(255,180,80,255), Color(120,40,0,0) }     -- giallo mistico
}



-- Emette particelle di fiamma solidali con l'orientamento della mesh
function EmitFlameAtLocal(obj, meshIndex, offset, strength, paletteIndex)
    if not obj then return end
    offset   = offset   or Vec3(0,0,0)
    strength = strength or 32
    paletteIndex = paletteIndex or 1

    local colors = FlameColorsPendoli[paletteIndex]

    local base = obj:GetJointPosition(meshIndex, offset)
    local up   = obj:GetJointPosition(meshIndex, offset + Vec3(0,-128,0))
    local dir  = (up - base):Normalize() * strength

    for i=1,8 do
        local jitter = Vec3(
            (math.random()-0.5)*8,
            (math.random()-0.5)*8,
            (math.random()-0.5)*8
        )
        Effects.EmitParticle(
            base,
            dir + jitter,
            math.random(0,1),
            0, 0,
            colors[1], colors[2],
            TEN.Effects.BlendID.ADDITIVE,
            64, 128,
            0.3 + math.random()*0.3,
            true, false,
            Objects.ObjID.DEFAULT_SPRITES,
            0
        )
    end
end



----------------------------------------------------------------------------
-- TRAPPOLE INFERNO pendoli infuocati (countdown + fiamme a pavimento) 
local COUNTDOWN_TIME = 10.0   -- secondi
local FLAME_TIME     = 8.0    -- secondi "ON"

-- Stato
local inferno_state = "idle"  -- "idle" -> "countdown" -> "flames" -> "done"
local inferno_t     = 0.0

 


local baddyInfernoNames = {
    "baddy1_64", "baddy1_65", "baddy1_66",
    "baddy1_67", "baddy1_68", "baddy1_69",
    "baddy1_70", "baddy1_71", "baddy1_73", "baddy1_74", "baddy1_75"
}

local baddyInferno = {}   -- qui finiranno gli oggetti
local inferno_pos = {}    -- qui le posizioni
local StrengthInferno = 32


-- Testo timer in alto a sinistra (usa string effimera "rinfrescata" ogni frame)
local function draw_inferno_timer(seconds_left)
    local pos = Vec2(PercentToScreen(95, 5)) -- top-right
    local s = DisplayString(
        string.format("Inferno in: %02d", math.max(0, math.ceil(seconds_left))),
        pos, 1.0, Color(255, 200, 50, 255) -- colore giallo-arancio più leggibile
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.RIGHT, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, 0.15, true)
end


-- Fiamma a pavimento in coordinate MONDO (provoca danno a Lara)
local function EmitFloorFlame(pos, strength)
    strength = strength or 200

    -- base = posizione nel mondo
    local base = pos
    -- direzione: verso l’alto fisso
    local dir  = Vec3(0,-1,0) * strength






    for i=1,16 do
        local jitter = Vec3(
            (math.random() - 0.5) * 32,
            (math.random() - 0.5) * 32,
            (math.random() - 0.5) * 32
        )
        Effects.EmitParticle(
            base,
            dir + jitter,
            math.random(0,1),
            0, 0,
            Color(255,40,20,255),  -- rosso vivo
			Color(80,0,0,0),        -- rosso sangue scurissimo
            TEN.Effects.BlendID.ADDITIVE,
            96, 256,               -- più grandi
            1.5 + math.random()*0.5,
            true, false,
            Objects.ObjID.DEFAULT_SPRITES,
            0
        )
    end
end







-----------------------------------------------------------------------------
--FIAMME ROOM LACRIMA 2

-- nomi degli oggetti
local BaddyLacrimaNames = {
    "baddy1_111","baddy1_112","baddy1_113","baddy1_114",
    "baddy1_115","baddy1_116","baddy1_117","baddy1_118",
    "baddy1_119","baddy1_120","baddy1_121","baddy1_122"
}

-- contenitori
local BaddyLacrima = {}
local FiammaLacrimaVec = {}

local lacrima_cycle = 8.0
local lacrima_t = 0.0
local lacrima_cols = {}
local lacrima_active_cols = {}

local safe_fires_coord = {
    Vec3(78336, 5120, 33280),  -- colonna safe 1
    Vec3(78336, 5120, 31232),  -- colonna safe 2
    Vec3(78336, 5120, 29184),  -- colonna safe 3
    Vec3(78336, 5120, 27136)   -- colonna safe 4
}


local function EmitFloorFlameBlue(pos, strength)
    strength = strength or 200

    local base = pos
    local dir  = Vec3(0,-1,0) * strength

    for i=1,16 do
        local jitter = Vec3(
            (math.random() - 0.5) * 32,
            (math.random() - 0.5) * 32,
            (math.random() - 0.5) * 32
        )
        Effects.EmitParticle(
            base,
            dir + jitter,
            0,     -- sprite ID
            0, 0,
            Color(80,180,255,255),  -- blu vivo
            Color(0,30,80,0),        -- blu scurissimo
            TEN.Effects.BlendID.ADDITIVE,
            96, 256,
            1.5 + math.random()*0.5,
            true, false,
            Objects.ObjID.FIRE_SPRITES, -- Objects.ObjID.DEFAULT_SPRITES
            0
        )
    end
end

local function EmitLoculuFlame(pos, strength)
    strength = strength or 120  -- più contenuta delle colonne letali

    local base = pos
    local dir  = Vec3(0,-1,0) * strength

    for i=1,10 do   -- meno particelle: più sobria
        local jitter = Vec3(
            (math.random() - 0.5) * 20,
            (math.random() - 0.5) * 20,
            (math.random() - 0.5) * 20
        )
        Effects.EmitParticle(
            base,
            dir + jitter,
            0,
            0, 0,
            Color(255,80,40),   -- verde smeraldo mistico
            Color(120,0,0),        -- verde scurissimo in fade
            TEN.Effects.BlendID.ADDITIVE,
            32, 64,                 -- più piccole
            0.6 + math.random()*0.3, -- vita leggermente più corta
            false, false,
            Objects.ObjID.FIRE_SPRITES,
            0
        )
    end
end


-------------------------------------------------------------------------------------------
-- FIAMME ROOM PIETRO
-- accese quando Lara supera il portone

local RoomLacrimaPietro_flag = false


-------------------------------------------------------------------------------------------
-- FIAMME ROOM 3
-- accese quando Lara supera il portone
local RoomLacrima3_flag = false

local function EmitFloorFlameBlueInnoc(pos, strength)
    strength = strength or 200

    local base = pos
    local dir  = Vec3(0,-1,0) * strength

    for i=1,16 do
        local jitter = Vec3(
            (math.random() - 0.5) * 8,
            (math.random() - 0.5) * 32,
            (math.random() - 0.5) * 8
        )
        Effects.EmitParticle(
            base,
            dir + jitter,
            0,     -- sprite ID
            0, 0,
            Color(200,160,60,255),  -- blu vivo
            Color(40,120,40,0),        -- blu scurissimo
            TEN.Effects.BlendID.ADDITIVE,
            48, 96,
            1.5 + math.random()*0.5,
            false, false,
            Objects.ObjID.FIRE_SPRITES, -- Objects.ObjID.DEFAULT_SPRITES
            0
        )
    end
end


-------------------------------------------------------------------------------------------
-- FIAMME ROOM 3
-- accese quando Lara supera il portone
local RoomLacrimaGeremia_flag = false

local function EmitFloorFlameBlueGeremia(pos, strength)
    strength = strength or 200

    local base = pos
    local dir  = Vec3(0,-1,0) * strength

    for i=1,16 do
        local jitter = Vec3(
            (math.random() - 0.5) * 8,
            (math.random() - 0.5) * 32,
            (math.random() - 0.5) * 8
        )
        Effects.EmitParticle(
            base,
            dir + jitter,
            0,     -- sprite ID
            0, 0,
            Color(200,160,60,255),  -- blu vivo
            Color(40,120,40,0),        -- blu scurissimo
            TEN.Effects.BlendID.ADDITIVE,
            48, 96,
            1.5 + math.random()*0.5,
            false, false,
            Objects.ObjID.FIRE_SPRITES, -- Objects.ObjID.DEFAULT_SPRITES
            0
        )
    end
end



------------------------------------------------------------------------------
-- parametri apertura portone

local OPEN_DY = -1984       -- offset di apertura: negativo = su
local OPEN_TIME  = 12.0     -- tempo di apertura del portone



local opening = false
local t_open = 0.0

local dust_timer = 0

-- Tremolio
local SHAKE_AMP_Y  = 16    -- ampiezza max tremolio verticale (unità)
local SHAKE_AMP_XZ = 8     -- ampiezza max su X/Z
local SHAKE_UPDATE = 0.07  -- aggiorna target jitter ogni ~0.07s

local shake_timer = 0
local shake_tx, shake_ty, shake_tz = 0, 0, 0   -- target
local shake_x,  shake_y,  shake_z  = 0, 0, 0   -- stato filtrato

local base_portone1_x, base_portone1_z


------------------------------------------------------------------------------
-- PUZZLE FIORI STAGIONI

local FlagAutunno = false
local FlagInverno = false
local FlagPrimavera = false
local FlagEstate = false

local portone2
local base_portone2
local opening2 = false
local t_open2 = 0.0



 -----------------------------------------------------------------------------
 --ALTARE da muovere
local GhostDoor 
local StaticAltar
local flag_altar = false
local altar_moving = false
local t_altar = 0.0

local MOVE_DX = 1024   -- offset lungo X dell'altare
local OPEN_TIME_ALTAR = 12.0 -- tempo di movimento dell'altare
local base_altar_x

------------------------------------------------------------------------------
-- POLVERE APERTURA PORTONE
 
local DUST_SPRITE_ID = 3   

local function spawnDust(pos)
    Effects.EmitParticle(
    pos,
    Vec3(math.random(-1,1), 0.3, math.random(-1,1)), -- velocità iniziale
    DUST_SPRITE_ID,                -- spriteID  
    1.0,                          -- gravità 
    0,                             -- rotVel
    Color(180,170,150,100),        -- colore iniziale
    Color(120,110,100,0),          -- colore finale
    TEN.Effects.BlendID.ALPHA_BLEND, -- blendMode
    40,                            -- startSize
    96,                            -- endSize
    12,                           -- vita in secondi
    false,                         -- damage
    false,                         -- poison
    Objects.ObjID.DEFAULT_SPRITES, -- spriteSeqID
    0                              -- startRot
)
end






-----------------------------------------------------------------------
--SOUNDTRACK

local TrackNameFiammata = "fiammatainferno"  -- ogg in Audio
local ttFiammata = Sound.SoundTrackType.ONESHOT

MusicOnce = MusicOnce or {}
local function PlayOnce(track_name, loop, key)
    key = key or track_name
    if MusicOnce[key] then return end
    local tt = loop and Sound.SoundTrackType.LOOPED or Sound.SoundTrackType.ONESHOT
    Sound.PlayAudioTrack(track_name, tt)
    MusicOnce[key] = true
end



-----------------------------------------------------------------------
 
local function InitAll()

-----------------------------------------------------------------------------------------
--TESTS da rimuovere nella release
    
   --TEN.Objects.GetMoveableByName("door_type9_202"):Enable()
 --  TEN.Objects.GetMoveableByName("door_type9_366"):Enable()

 --Inventory.SetItemCount(978, 25)    -- ObjID è quello dello slot dell'object nel wad2 del livello
--Inventory.SetItemCount(979, 12)

--Inventory.SetItemCount(501, 4) -- puzzle item 2 per test altare, da commentare in release

     
    
---------------------------------------------------------------------------------------------------------
--

	CameraParkour = TEN.Objects.GetCameraByName("camera_304")

    Pendolo1 = TEN.Objects.GetMoveableByName(Pendolo1Name)
    Pendolo2 = TEN.Objects.GetMoveableByName(Pendolo2Name)
    Pendolo3 = TEN.Objects.GetMoveableByName(Pendolo3Name)
    Pendolo4 = TEN.Objects.GetMoveableByName(Pendolo4Name)
    Pendolo5 = TEN.Objects.GetMoveableByName(Pendolo5Name)

    local pendoli = {Pendolo1, Pendolo2, Pendolo3, Pendolo4, Pendolo5}
    for _, p in ipairs(pendoli) do
        if p then
            p:SetAnim(0)
            p:SetFrame(0)
            for i=0, p:GetMeshCount()-1 do
                p:SetMeshVisible(i, false)
            end
        end
    end
    
    
    
    for i, name in ipairs(baddyInfernoNames) do
    local obj = TEN.Objects.GetMoveableByName(name)
    baddyInferno[i] = obj
    if obj then
        inferno_pos[i] = obj:GetPosition()
    end
	end


     
	BaddyGhost = TEN.Objects.GetMoveableByName(BaddyGhostName)
	BaddyGhost2 = TEN.Objects.GetMoveableByName(BaddyGhostName2)	
	CameraAltare = TEN.Objects.GetCameraByName(CameraAltareName)
	CameraPortone = TEN.Objects.GetCameraByName(CameraPortoneName)
	
	
	GhostDoor = TEN.Objects.GetMoveableByName(GhostDoorName)
    StaticAltar = TEN.Objects.GetStaticByName(StaticAltarName) 

	SW1 = TEN.Objects.GetMoveableByName(SW1_NAME)
    SW2 = TEN.Objects.GetMoveableByName(SW2_NAME)
    SW3 = TEN.Objects.GetMoveableByName(SW3_NAME)
    SW4 = TEN.Objects.GetMoveableByName(SW4_NAME)
	
	portone1 = TEN.Objects.GetStaticByName(DOOR_NAME) 
	
	
	if portone1 then
        base_portone1 = portone1:GetPosition().y
        base_portone1_x = portone1:GetPosition().x
        base_portone1_z = portone1:GetPosition().z
    --    print("[INIT] baseY =", baseY)
    else
        print("[INIT] ATTENZIONE: '"..DOOR_NAME.."' non trovato")
    end
    
    
    portonesmall1 = TEN.Objects.GetStaticByName("static_mesh_246") 
    portaperportsmall = TEN.Objects.GetMoveableByName("door_type8_247")
    SWsmall = TEN.Objects.GetMoveableByName("switch_type2_248")
    baddyPortSmall = TEN.Objects.GetMoveableByName("baddy1_249")
    CameraPortoneSmall = TEN.Objects.GetCameraByName("camera_250")
    if portonesmall1 then
        baseportonesmall1 = portonesmall1:GetPosition().y
        base_portonesmall1_x = portonesmall1:GetPosition().x
        base_portonesmall1_z = portonesmall1:GetPosition().z
        print("[INIT] base small Y =", baseportonesmall1)
    else
        print("[INIT] ATTENZIONE: portonesmall1 non trovato")
    end
    
    
    if StaticAltar then
        base_altar_x = StaticAltar:GetPosition().x
    end
    
    if Pendolo1 then
    	print("Pendolo 1 OK")
    else
        print("ATTENZIONE Pendolo 1 NON OK")
    end
    
    
     for i, name in ipairs(BaddyLacrimaNames) do
    local obj = TEN.Objects.GetMoveableByName(name)
    BaddyLacrima[i] = obj
    if obj then
        FiammaLacrimaVec[i] = obj:GetPosition()
    end
end

lacrima_cols = {
    { FiammaLacrimaVec[1],  FiammaLacrimaVec[5],  FiammaLacrimaVec[9]  },
    { FiammaLacrimaVec[2],  FiammaLacrimaVec[6],  FiammaLacrimaVec[10] },
    { FiammaLacrimaVec[3],  FiammaLacrimaVec[7],  FiammaLacrimaVec[11] },
    { FiammaLacrimaVec[4],  FiammaLacrimaVec[8],  FiammaLacrimaVec[12] }
}


     

	portone2 = TEN.Objects.GetStaticByName("static_mesh_174")
	
	if portone2 then
	    base_portone2 = portone2:GetPosition().y
	    base_portone2_x = portone2:GetPosition().x
	    base_portone2_z = portone2:GetPosition().z
	else
	    print("[INIT] ATTENZIONE: 'static_mesh_174' non trovato")
	end
	
	
	Interruttore1 = TEN.Objects.GetMoveableByName("switch_type2_191")
	Interruttore2 = TEN.Objects.GetMoveableByName("switch_type2_193")
	Interruttore3 = TEN.Objects.GetMoveableByName("switch_type2_194")
	Interruttore4 = TEN.Objects.GetMoveableByName("switch_type2_195")


    
end -- end InitAll()


local function choose_lacrima_cols()
    local pool = {1,2,3,4}
    lacrima_active_cols = {}
    for i=1,3 do
        local idx = math.random(1,#pool)
        table.insert(lacrima_active_cols, pool[idx])
        table.remove(pool, idx)
    end
end

 
---------------------------------------------------------------------------
-- FUNCTIONS per eventi di volume

LevelFuncs.OnFiammePietro = function()
	RoomLacrimaPietro_flag = true
end

 
LevelFuncs.OnGhostDoor = function() -- Per animare l'altare
	print("Dummy test 2")
	if GhostDoor and StaticAltar then  
		if GhostDoor:GetAnim() == 2 and not altar_moving and not flag_altar then
            flag_altar = true
            local track = "055"
            local tt = Sound.SoundTrackType.ONESHOT
            Sound.PlayAudioTrack(track, tt)
        end
	end
	
end



LevelFuncs.OnShatterTest = function()   -- Per shatter di statici  
    if ShatterColonna then
         ShatterColonna:Shatter()
    end
end



 


LevelFuncs.OnTrapInferno = function()

    TEN.Objects.GetMoveableByName("door_type9_364"):Disable()


    local tt = Sound.SoundTrackType.ONESHOT
    local TrackNameInferno = "contoallarovescia" 
    if inferno_state == "idle" or inferno_state == "done" then
        inferno_state = "countdown"
        inferno_t = 0.0
        
        Sound.PlayAudioTrack(TrackNameInferno, tt)

    end
end


LevelFuncs.OnDeadWater = function()
    Lara:SetHP(0)  -- morte istantanea
end

LevelFuncs.OnAutunnoSuAutunno = function()
	FlagAutunno = true
end

LevelFuncs.OnInvernoSuInverno = function()
	FlagInverno = true
end

LevelFuncs.OnPrimaveraSuPrimavera = function()
	FlagPrimavera = true
end

LevelFuncs.OnEstateSuEstate = function()
	FlagEstate = true
end



LevelFuncs.OnRoom3LacrimaFlame = function()
	RoomLacrima3_flag = true
end

LevelFuncs.OnRoomGeremiaFlag = function()
	RoomLacrimaGeremia_flag = true
end

-------------------------------------------------------------------------------
-- LevelFuncs per Soundtrack

LevelFuncs.OnMusicHorrorRandom = function()
     PlayOnce("horrorfuochirandom", false, "HORRORRAND")
end


--------------------------------------------------------------------------------
-- FUNCTION di fine livello per statistiche
-- da matchare con blocco in OnLoop e in OnFreeze

local level_time = 0 -- per timer
                     -- inizializzato in OnStart, aggiornato in OnLoop(dt), salvato e riletto in OnSave e OnLoad
local stats_active = false
local function ShowStatsHUD()

	stats_active = true
    Flow.SetFreezeMode(Flow.FreezeMode.FULL)
    Input.ClearAllKeys()
    
    
    -- MUSIC STATS
	local statsMusic = "datr3finelivello"   
	local ttFINE = Sound.SoundTrackType.ONESHOT
	Sound.PlayAudioTrack(statsMusic, ttFINE)

    
    local lvl = Flow.GetCurrentLevel()
--	local levelName = (lvl and lvl.nameKey) or "???"
	local levelName = Flow.GetString(lvl.nameKey)


	
    local stats = Flow.GetStatistics()

    -- tempo HH:MM:SS da level_time
    local lt = level_time or 0
    local h = math.floor(lt / 3600)
    local m = math.floor((lt % 3600) / 60)
    local s = math.floor(lt % 60)
    local time_str = string.format("%02d:%02d:%02d", h, m, s)

    -- segreti livello / gioco
    local lvl = Flow.GetCurrentLevel()
    local secrets_level_total  = (lvl and lvl.secrets) and tonumber(lvl.secrets) or 0
    local secrets_level_found  = tonumber(stats.secrets)  or 0
    local secrets_game_found   = tonumber(Flow.GetSecretCount())     or 0
    local secrets_game_total   = tonumber(Flow.GetTotalSecretCount()) or 0

    local kills    = tonumber(stats.kills)    or 0
    local ammoUsed = tonumber(stats.ammoUsed) or 0

    -- posizioni
    local pos_levname = Vec2(PercentToScreen(50, 47))
    local pos_title = Vec2(PercentToScreen(50, 55))
	
	local pos_line  = Vec2(PercentToScreen(50, 63))
    local pos_stats = Vec2(PercentToScreen(50, 70))

    -- titolo
    
    local tempoEsposizione = 300
    
    local levName = DisplayString(levelName, pos_levname, 1.2, Color(165,42,42))
    levName:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(levName, tempoEsposizione, true)
    
    local title = DisplayString("Statistics", pos_title, 1.2, Color(150, 200, 255))
    title:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(title, tempoEsposizione, true)
    
    

    -- separatore ASCII (niente Unicode)
    local sep = DisplayString("========================", pos_line, 1.0, Color(150, 200, 255))
    sep:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(sep, tempoEsposizione, true)

    -- blocco dettagli
    local text = string.format(
        "Time: %s\nSecrets: %d/%d (%d/%d)\nKills: %d\nAmmo used: %d",
        time_str,
        secrets_level_found, secrets_level_total,
        secrets_game_found,  secrets_game_total,
        kills, ammoUsed
    )

    local sstr = DisplayString(text, pos_stats, 1.0, Color(200, 220, 255))
    sstr:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(sstr, tempoEsposizione, true)
end


LevelFuncs.OnFineLivello = function()
	ShowStatsHUD()
	--Common.ShowStatsHUD()
end
-----------------------------------------------------------------------------------------------------------








 
--------------------------------------------------------------------------------
-- TESTI DI LARA
--------------------------------------------------------------------------------

LevelFuncs.OnLaraLevaLamentazioniText = function()

	

    local pos = Vec2(PercentToScreen(50, 70))
    local track = "LaraPiastraLame"
	local duration = AudioDurations[track] or 8.0  -- fallback se manca
     
    local s = DisplayString(
        "Thus shall you, O visitor, obtain the passage to the Tower of Lamentations. \n Bow before the Wall of Weeping,  \n and behold the marvels wrought by the lost craft of Tinnos.   \n The Tower binds the wailing spirits of sinners from the middle world.\n Ascend to its summit, or be cast into eternal damnation",
        pos,
        1.0,
        Color(200, 220, 255) -- bianco
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true)   
    Sound.PlayAudioTrack(track, Sound.SoundTrackType.ONESHOT)
end


LevelFuncs.OnLaraFuochiIngressoText = function()
    local pos = Vec2(PercentToScreen(50, 74))
    local track = "LaraFourFlames"
	local duration = AudioDurations[track] or 8.0  -- fallback se manca
--     local duration = 8.0
    local s = DisplayString(
        "Four flames guard the hidden tear. \n Without their light, the path remains sealed.  \n Kindle the fire at each pedestal,   \n and only then shall the Tear of Jeremiah be granted",
        pos,
        1.0,
        Color(200, 220, 255) -- bianco
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true)   
    Sound.PlayAudioTrack(track, Sound.SoundTrackType.ONESHOT)
end


LevelFuncs.OnLaraChambersText = function()
    local pos = Vec2(PercentToScreen(50, 70))
    local track = "FourChambers"
	local duration = 12.0  -- fallback se manca

    local s = DisplayString(
        "These must be the four chambers that guard the Tears of \n Eve, Peter, Judas, and Jeremiah. \n According to the writings of Brother John Blackarrow in 1428, \n they can be reached by opening the gates \n from the Tower of Lamentations",
        pos,
        1.0,
        Color(200, 220, 255) -- bianco
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true)   
    Sound.PlayAudioTrack(track, Sound.SoundTrackType.ONESHOT)
end


LevelFuncs.OnLaraTowerText = function()
    local pos = Vec2(PercentToScreen(50, 70))
    local track = "TowerLame"
	local duration = AudioDurations[track] or 8.0  -- fallback se manca

    local s = DisplayString(
        "The legendary Tower of Lamentations... \n Brother John Blackarrow wrote that it was built around 2000 BC \n by a civilization directly descended from Tinnos, \n and that in the centuries that followed it was used to guard \n the passage to the Chambers of Tears",
        pos,
        1.0,
        Color(200, 220, 255) -- azzurrino tenue per differenziarlo
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true)  
    Sound.PlayAudioTrack(track, Sound.SoundTrackType.ONESHOT)
end

LevelFuncs.OnLaraMuroPiantoText = function()
    local pos = Vec2(PercentToScreen(50, 88))
    local track = "MuroPianto"
	local duration = AudioDurations[track] or 8.0  -- fallback se manca

    local s = DisplayString(
        "This is the Wailing Wall, \n built at the base of the cyclopean walls by the priests of Tinnos",
        pos,
        1.0,
        Color(200, 220, 255) -- azzurrino tenue per differenziarlo
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true)  
    Sound.PlayAudioTrack(track, Sound.SoundTrackType.ONESHOT)
end

LevelFuncs.OnLaraCiclopicheText = function()
    local pos = Vec2(PercentToScreen(50, 88))
    local track = "MuraCiclo"
--	local duration = AudioDurations[track] or 8.0  
	local duration = 8.03

    local s = DisplayString(
        "The Tower of Lamentations lies hidden within the cyclopean walls, \n said to have been raised by the engineers of Tinnos thousands of years ago",
        pos,
        1.0,
        Color(200, 220, 255) -- azzurrino tenue per differenziarlo
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true)   
    Sound.PlayAudioTrack(track, Sound.SoundTrackType.ONESHOT)
end

LevelFuncs.OnLaraParkourText = function()
    local pos = Vec2(PercentToScreen(50, 92))
    local track = "Parkour"
	local duration = AudioDurations[track] or 8.0  -- fallback se manca

    local s = DisplayString(
        "Reaching the top of the tower will need some parkour",
        pos,
        1.0,
        Color(200, 220, 255) -- azzurrino tenue per differenziarlo
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true)   
    Sound.PlayAudioTrack(track, Sound.SoundTrackType.ONESHOT)
end


LevelFuncs.OnLaraRandomFiresText = function()
    local pos = Vec2(PercentToScreen(50, 88))
    local track = "RandomFires"
	local duration = AudioDurations[track] or 8.0  -- fallback se manca

    local s = DisplayString(
        "These fires seem to switch off randomly... \n and remain off for a few seconds",
        pos,
        1.0,
        Color(200, 220, 255) 
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true)   
    Sound.PlayAudioTrack(track, Sound.SoundTrackType.ONESHOT)
end


LevelFuncs.OnLaraLacrimaEva = function()
    local pos = Vec2(PercentToScreen(50, 92))
    local track = "LacrimaEva"
	local duration = AudioDurations[track] or 8.0  -- fallback se manca
    local s = DisplayString(
        "This has to be Lacrima Hevae",
        pos,
        1.0,
        Color(200, 220, 255) -- azzurrino tenue per differenziarlo
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true)   
    Sound.PlayAudioTrack("LacrimaEva", Sound.SoundTrackType.ONESHOT)
end

LevelFuncs.OnLaraLacrimaPietro = function()
    local pos = Vec2(PercentToScreen(50, 92))

    local track = "LacrimaPietro"
    local duration = AudioDurations[track] or 8.0  -- fallback se manca
--    local duration = 8.0
    local s = DisplayString(
        "This has to be Lacrima Petri",
        pos,
        1.0,
        Color(200, 220, 255) -- azzurrino tenue per differenziarlo
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true)  -- durata 11 secondi
    Sound.PlayAudioTrack(track, Sound.SoundTrackType.ONESHOT)
end

LevelFuncs.OnLaraFlowerPuzzle1 = function()
    local pos = Vec2(PercentToScreen(50, 82))

    local track1 = "LaraBloom"
    local duration = 10.0
    local s = DisplayString(
        "The puzzle in this room must be about connecting \n each flower to its season of bloom. \n Better be careful: choosing the wrong season for a stone could be risky",
        pos,
        1.0,
        Color(200, 220, 255) -- azzurrino tenue per differenziarlo
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true)   
    Sound.PlayAudioTrack(track1, Sound.SoundTrackType.ONESHOT)
    
end

LevelFuncs.OnLaraFlowerPuzzle2 = function()
    local pos = Vec2(PercentToScreen(50, 88))

    local track = "aidawn"
    --local duration = AudioDurations[track] or 8.0  -- fallback se manca
    local duration = 5.0
    local s = DisplayString(
        "Better be careful: \n choosing the wrong season for a stone could be risky",
        pos,
        1.0,
        Color(200, 220, 255) -- azzurrino tenue per differenziarlo
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true)  -- durata 11 secondi
--    Sound.PlayAudioTrack(track, Sound.SoundTrackType.ONESHOT)
end


LevelFuncs.OnLaraLacrimaGiuda = function()
    local pos = Vec2(PercentToScreen(50, 92))

    local track = "LacrimaGiuda"
    local duration = AudioDurations[track] or 8.0  -- fallback se manca
--    local duration = 8.0
    local s = DisplayString(
        "This has to be Lacrima Iudae",
        pos,
        1.0,
        Color(200, 220, 255) -- azzurrino tenue per differenziarlo
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true)   
    Sound.PlayAudioTrack(track, Sound.SoundTrackType.ONESHOT)
end

LevelFuncs.OnLaraLacrimaGeremia = function()
    local pos = Vec2(PercentToScreen(50, 92))

    local track = "LacrimaGeremia"
    local duration = AudioDurations[track] or 8.0  -- fallback se manca
--    local duration = 8.0
    local s = DisplayString(
        "This has to be Lacrima Ieremiae",
        pos,
        1.0,
        Color(200, 220, 255) -- azzurrino tenue per differenziarlo
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true)  -- durata 11 secondi
    Sound.PlayAudioTrack(track, Sound.SoundTrackType.ONESHOT)
end


LevelFuncs.OnLaraFires = function()
    local pos = Vec2(PercentToScreen(50, 88))
    local track = "LaraProbablyFires"
    local duration = AudioDurations[track] or 8.0  -- fallback se manca
    local s = DisplayString(
        "I probably have to light fires on top of the pedestals \n to extinguish the blue flames and proceed further",
        pos,
        1.0,
        Color(200, 220, 255) -- azzurrino tenue per differenziarlo
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    if not all_on() then
	    Strings.ShowString(s, duration, true)  
	    Sound.PlayAudioTrack(track, Sound.SoundTrackType.ONESHOT)
	end
end
----------------------------------------------------------------------------



LevelFuncs.OnStart = function() 


 -- print("ROOM LARA", roomLara)



-------------------------------------------------------------------------------------------
-- VIDEO INIZIALE

   local videoName = "abarcelona25fpsV2"
   View.PlayVideo(videoName)


--------------------------------------------------------------------------------------
-- Energia iniziale Lara 
	Lara:SetHP(1000)
    print("LARA HEALTH INIZIO =", Lara:GetHP())


diary:UnlockPages(9,false)   

-------------------------------------------------------------------------------------------
-- inventory stuff
 
	Inventory.SetItemCount(954, 1)	   -- mette lo shotgun in inventario 
 

-- ASSEGNA munizioni shotgun e medikit se PUZZLE_ITEM1 non è in inventario, ovvero se il giocatore
-- ha saltato il livello precedente e ha iniziato direttamente da questo

local id_puzzle1 = 500
local count_puzzle1 = GetItemCount(id_puzzle1)

if count_puzzle1 == 0 then
	
	Inventory.SetItemCount(955, 18)    -- cartucce rosse
	Inventory.SetItemCount(956, 6)    -- cartucce blu
	Inventory.SetItemCount(978, 3)    -- medikit grande
	Inventory.SetItemCount(979, 6)    -- medikit piccolo
end
 

 
Inventory.SetItemCount(983, 0)   -- azzera flare
Inventory.SetItemCount(500, 0)   -- toglie il libro 1 dall'inventario in quanto inutile per il gameplay


	Lara:SetWeaponType(WeaponType.SHOTGUN, false)
    Lara:SetWeaponType(WeaponType.PISTOLS, false)

----------------------------------------------------------------------------------------
-- SCRITTA INIZIALE
    local showtime = 10 
 	local pos1 = Vec2(PercentToScreen(50, 72))
 	local pos2 = Vec2(PercentToScreen(50, 80))
 	-- crea l'oggetto stringa
    local s1 = DisplayString(
        "Caves of Bats near Matera, Italy",
        pos1,
        1.0,                          -- scala (facoltativa)
        Color(255, 255, 255, 255)     -- colore
        -- , false                    -- translated (facoltativo)
    )

    -- opzionale: centra rispetto a 'pos' e aggiungi ombra
    s1:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }

    -- MOSTRA per showtime secondi e poi elimina l'oggetto (autoDelete=true)
    Strings.ShowString(s1, showtime, true)
    
    local s2 = DisplayString(
        "Lara is searching for the entrance to the catacombs of Saint Francis of Assisi, "
        .."\n which, according to medieval writings, lead to the tomb of Eve,  \n "
        .."where the Lacrimosa is kept.",
        pos2,
        1.0,                          -- scala (facoltativa)
        Color(0, 128, 160, 255)     -- colore
        -- , false                    -- translated (facoltativo)
    )

    -- opzionale: centra rispetto a 'pos' e aggiungi ombra
    s2:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }

    -- MOSTRA per showtime secondi e poi elimina l'oggetto (autoDelete=true)
    Strings.ShowString(s2, showtime, true)
----------------------------------------------------------------------------------------------------------




	level_time = 0      -- inizio timer per statistiche

---------------------------------------------------------------------------------------------------------
-- inizializzazione moveables e statics

     InitAll()
	 choose_lacrima_cols()
	
---------------------------------------------------------- 
	
	if CameraPortone then
		print("Camera:",CameraPortoneName)
	else
		print("Errore Camera:",CameraPortoneName)
	end


     
    
    
  
    
    
    
    
    

end   -- end OnStart

LevelFuncs.OnLoop = function(dt) 




-----------------------------------------------------------------
---- DA COMMENTARE PER LA RELEASE
---
--    TEN.Objects.GetMoveableByName("door_type8_6"):Enable()
    
 

---------------------------------------------------------------------
--- questo lo metto per sicurezza per evitare che qualche flare rimasto nascosto
--- possa essere preso e rovinare il meccanismo della custom portable light
    Inventory.SetItemCount(983, 0)   -- azzera flare costantemente


    
-------------------------------------------------------------------
-- fuoco dopo shatter Tinnos altare

    perilfuoco()

-----------------------------------------------------------------
-- FUOCHI camera iniziale

	local c1fuoco = Vec3(53760, -7936, 11776)
	local c2fuoco = Vec3(53760, -7936, 13824)
	Effects.EmitFire(c1fuoco,1)
	Effects.EmitFire(c2fuoco,1)




------------------------------------------------------------------
-- FUOCHI fossa scheletro corridoio 1

	local b1fuoco = Vec3(40448, -6656, 29184)
	local b2fuoco = Vec3(41472, -6656, 29184)
	Effects.EmitFire(b1fuoco,4)
	Effects.EmitFire(b2fuoco,4)

-----------------------------------------------------------------
-- POINTLIGHT door stanza segreta LAMENTAZIONI

	if door_timer > 0 then
	    door_timer = door_timer - dt
	    Effects.EmitLight(
	        Vec3(35328, -2496, 48640),   -- posizione  
	        Color(100, 220, 160),         -- colore  
	        12,                          -- radius
	        16,                          -- falloff
	        "door_light"                 -- chiave univoca
	    )
	end

-----------------------------------------------------------------
-- CAMERA PARKOUR

	if CameraParkour and CameraParkourFlag then
		CameraParkour:Play(Lara)
	end

------------------------------------------------------------------
-- CUSTOM FLARE


if Input.IsKeyHit(Input.ActionID.FLARE) then -- FLARE
    flare_on = not flare_on
    Sound.PlaySound(379)
end


-- se attivo, emetti spotlight ogni frame
    if flare_on then
    
    
    	if Input.IsKeyHit(Input.ActionID.L) then    
            flare_pitch = flare_pitch - 0.1
        end
        if Input.IsKeyHit(Input.ActionID.K) then  
            flare_pitch = 0
        end
        if Input.IsKeyHit(Input.ActionID.J) then 
            flare_pitch = flare_pitch + 0.1
        end
    
 		local localOffset = Vec3(-128, -512, 64)
 	

		local pos = Lara:GetJointPosition(11, Vec3(-32, -64, 64)) -- spotlight posizionata sulla spalla sinistra di Lara

        local rot = Lara:GetRotation()
 		local dir = rot:Direction()
 		dir = dir + Vec3(0, flare_pitch, 0)   -- tilt verticale
        dir:Normalize()
		
		pos = pos + dir*16

 
        -- spotlight
        Effects.EmitSpotLight(
            pos,
            dir,
            Color(255, 250, 220), -- colore     --(255, 250, 220) --(255, 240, 200)
            12,  -- radius       -- 20,6,32
            6,   -- falloff
            24,  -- distanza     
            false,--ombra
            "test_spot"
        )
        
        -- pointlight "riempimento"  
		Effects.EmitLight(
		    pos,
		    Color(200,180,160),  -- più tenue
		    8,                   -- radius corto
		    12,                  -- falloff
		    "flare_fill"
		)
    end   -- end custom flare

--------------------------------------------------------------------------------------------------------------
-- WEAPON HUD
	local wt = Objects.LaraObject.GetWeaponType(Lara)
	if wt ~= 1 then
	    local tttt = Lara:GetHandStatus()  -- 4 = WEAPON_READY
	    if tttt == 4 then
	        local ui    = WEAPON_UI[wt]
	        local label = (ui and ui.label) or tostring(wt)
	        local y     = (ui and ui.y)     or 60
	        local col   = (ui and ui.color) or Color(255,255,255,255)
	
	        if wt == Objects.WeaponType.SHOTGUN then
	            local at    = Lara:GetAmmoType()
	            local isWide = (at == Objects.AmmoType.SHOTGUN_WIDE)
	            label = string.format("%s (%s)", label, isWide and "W" or "N")
	            -- 🔴 normale = rosso, 🔵 wide = blu
	            col   = isWide and Color(0,160,255,255) or Color(255,80,80,255)
	        end
	
	        local ammo  = Lara:GetAmmoCount()
	        local text  = string.format("%s: %s", label, tostring(ammo))
	
	        local s = DisplayString(text, Vec2(40, y), 1.0, col, false)
	        Strings.ShowString(s, 0.1, true)
	    end
	end

--------------------------------------------------------------------------------------------------------------
-- flow per statistiche di fine livello
	level_time = level_time + dt  -- time per statistiche
	if stats_active and Flow.GetFreezeMode() == Flow.FreezeMode.FULL then
        return
    end
---------------------------------------------------------------------------------------------------------------    


-----------------------------------------------------------------------
-- FUOCHI ANTICAMERA LAMENTAZIONI

	local pp1A = Vec3(32256, -1024, 27648) 
	local pp2A = Vec3(25088, -1024, 27648) 
	local pp3A = Vec3(27136, -512, 24064) 
	local pp4A = Vec3(29184, -512, 24064) 
	Effects.EmitFire(pp1A,3)
	Effects.EmitFire(pp2A,3)
	Effects.EmitFire(pp3A,1)
	Effects.EmitFire(pp4A,1)
----------------------------------------------------------------------------------------------------------------
-- DUE FUOCHI camera PIETRO
-- le posizioni sono quelle dei due baddy
	if RoomLacrimaPietro_flag then
	local pp1P = Vec3(82432, 5120, 32256) 
	local pp2P = Vec3(82432, 5120, 28160) 
	Effects.EmitFire(pp1P,3)
	Effects.EmitFire(pp2P,3)
	end
	
	
----------------------------------------------------------------------------------------------------------------
-- DUE FUOCHI camera GEREMIA
-- le posizioni sono quelle dei due baddy
	if RoomLacrimaGeremia_flag then
	local pp1G = Vec3(8704, 9728, 33280) 
	local pp2G = Vec3(10752, 9728, 33280) 
	Effects.EmitFire(pp1G,1)
	Effects.EmitFire(pp2G,1)
	end

----------------------------------------------------------------------------------------------------------------
-- DUE FUOCHI camera lacrima
-- le posizioni sono quelle dei due baddy
	if RoomLacrima3_flag then
	local pp1RE = Vec3(3584, -6144, 26112) 
	local pp2RE = Vec3(5632, -6144, 26112) 

        EmitFuocoMio(pp1RE, 3, 1414)
        EmitFuocoMio(pp2RE, 3, 1424)

	--Effects.EmitFire(pp1RE,3)
	--Effects.EmitFire(pp2RE,3)
	end

--------------------------------------------------------------------------------------------------------------
-- TRAPPOLA MORTE CERTA stanza stagioni
   
  
  PosizioneMorteCerta = Vec3(11776, -5120, 25088)
  BloccoInverno = TEN.Objects.GetMoveableByName("pushable_object_climbable3_163")
  PosizioneBloccoInverno = BloccoInverno:GetPosition()
  
  if PosizioneBloccoInverno == PosizioneMorteCerta then
  	print("POSIZIONE COINCIDE")
  	posLara = Lara:GetPosition()
  	EmitFloorFlameBlue(posLara, 24)
  	Lara:SetHP(0)
  end


-----------------------------------------------------------------------------------------------------
-- MECCANISMI ROOM STAGIONI
  
  local common_shift = Vec3(0,-256,0)
  local FuocoSuAutunno1 = Vec3(11776, -6016, 24064) + common_shift
  local FuocoSuInverno1 = Vec3(12800, -6016, 24064) + common_shift
  local FuocoSuPrimavera1 = Vec3(12800, -6016, 25088) + common_shift
  local FuocoSuEstate1 = Vec3(11776, -6016, 25088) + common_shift

 

  local SizeFuocoStagioni1 = 2
 
  if FlagAutunno then
  	Effects.EmitFire(FuocoSuAutunno1,SizeFuocoStagioni1)
 
  end
  if FlagInverno then
  	Effects.EmitFire(FuocoSuInverno1,SizeFuocoStagioni1)
 
  end
  if FlagPrimavera then
  	Effects.EmitFire(FuocoSuPrimavera1,SizeFuocoStagioni1)
 
  end
  if FlagEstate then
  	Effects.EmitFire(FuocoSuEstate1,SizeFuocoStagioni1)
 
  end
  
  
  -- Portone stagioni
	if FlagAutunno and FlagInverno and FlagPrimavera and FlagEstate and not opening2 then
	    opening2 = true
	    t_open2 = 0.0
	    Sound.PlaySound(1196) --- sound effect provvisorio
	    
	end
	
	if opening2 and t_open2 < OPEN_TIME then
	    t_open2 = t_open2 + dt
        local frac = math.min(t_open2 / OPEN_TIME, 1.0) -- va da 0 a 1
        local p = portone2:GetPosition()
        local y_base = base_portone2 + OPEN_DY * frac
        
                
        
        
        
        -- aggiorna il target del jitter ogni SHAKE_UPDATE secondi
		shake_timer = shake_timer + dt
		if shake_timer >= SHAKE_UPDATE then
		    local amp_scale = math.sqrt(1.0 - frac)        -- si attenua verso la fine
		    shake_tx = (math.random() - 0.5) * 2 * SHAKE_AMP_XZ * amp_scale
		    shake_ty = (math.random() - 0.5) * 2 * SHAKE_AMP_Y  * amp_scale
		    shake_tz = (math.random() - 0.5) * 2 * SHAKE_AMP_XZ * amp_scale
		    shake_timer = 0
		end
		
		-- filtro (smussa i cambi: niente scatti)
		local s = 0.35
		shake_x = shake_x + (shake_tx - shake_x) * s
		shake_y = shake_y + (shake_ty - shake_y) * s
		shake_z = shake_z + (shake_tz - shake_z) * s
		
		-- posizione finale = base + tremolio (niente drift su x/z!)
		local p = Vec3(
		    base_portone2_x + shake_x,
		    y_base          + shake_y,
		    base_portone2_z + shake_z
		)
        
        
        
        portone2:SetPosition(p)
--        Sound.PlayAudioTrack("eqs", Sound.SoundTrackType.ONESHOT)
        MakeEarthquake(3)
	end
	
--	if t_open2 > OPEN_TIME then
--		if (Sound.IsAudioTrackPlaying("eqs")) then
--    	Sound.StopAudioTrack(Sound.SoundTrackType.ONESHOT)
--		end
--	end
	


-----------------------------------------------------------------------
-- FUOCHI ROOM EVA

-----------------------------------------------------------------------
-- ROOM EVA

local FuocoEva1 = Vec3(55808, -256, 46592)  
local FuocoEva2 = Vec3(55808, -256, 48640)
local SizeFuocoEva = 1

Effects.EmitFire(FuocoEva1,SizeFuocoEva)
Effects.EmitFire(FuocoEva2,SizeFuocoEva)

------------------------------------------------------------------------
-- TRAPPOLA RANDOM FIRES

      lacrima_t = lacrima_t + dt
		if lacrima_t >= lacrima_cycle then
		    lacrima_t = 0
		    choose_lacrima_cols()
		end
		
		for _, col in ipairs(lacrima_active_cols) do
		    for _, pos in ipairs(lacrima_cols[col]) do
		        EmitFloorFlameBlue(pos, 12)
		        
		    end
		end
		
		
		-- Fuoco direzionale per la colonna NON attiva
		for col = 1, 4 do
		    local isActive = false
		    for _, ac in ipairs(lacrima_active_cols) do
		        if ac == col then
		            isActive = true
		            break
		        end
		    end
		
		    if not isActive then
		        Effects.EmitFire(safe_fires_coord[col], 2)  -- 2 = size, regola a gusto
		    end
		end
 



-------------------------------------------------------------------------------------------------
-- APERTURA portone principale con i 4 switch

       local anim1 = SW1:GetAnim()
       local anim2 = SW2:GetAnim()
       local anim3 = SW3:GetAnim()
       local anim4 = SW4:GetAnim()
     
        
       
   
 
   
    if not portone1 then return end

    
    local condizione_ok = (anim1 == 1 and anim3 == 1 and anim4 == 1 and anim2 == 0)
    
    if condizione_ok then   -- attiva i fuochi nella room principale
    	local posfuocomio1 = Vec3(39424, -768, 14848)
    	local posfuocomio2 = Vec3(39424, -768, 16896)
    	local posfuocomio3 = Vec3(42496, -768, 16896)
    	local posfuocomio4 = Vec3(42496, -768, 14848)
    	EmitFuocoMio(posfuocomio1, 1, 111)
    	EmitFuocoMio(posfuocomio2, 1, 121)
    	EmitFuocoMio(posfuocomio3, 1, 131)
    	EmitFuocoMio(posfuocomio4, 1, 141)
    end

    if condizione_ok and not opening then
        opening = true
        t_open = 0.0
        Sound.PlaySound(1196) --- sound effect provvisorio
--        Sound.PlayAudioTrack("eqs", Sound.SoundTrackType.ONESHOT)

    end

    if opening and t_open < OPEN_TIME then
    
    
    	if Input.IsKeyHit(Input.ActionID.LOOK) then -- 0 riporta la camera su Lara
    		flag_camera_portone1 = true
   
   		end
    
    
    	if not flag_camera_portone1 then
    
   		 	CameraPortone:Play(BaddyGhost)
    	
    	
       	end
    	
    	
    	
    
        t_open = t_open + dt
        local frac = math.min(t_open / OPEN_TIME, 1.0) -- va da 0 a 1
        local p = portone1:GetPosition()
        local y_base = base_portone1 + OPEN_DY * frac
        
        
        
        
        -- aggiorna il target del jitter ogni SHAKE_UPDATE secondi
		shake_timer = shake_timer + dt
		if shake_timer >= SHAKE_UPDATE then
		    local amp_scale = math.sqrt(1.0 - frac)        -- si attenua verso la fine
		    shake_tx = (math.random() - 0.5) * 2 * SHAKE_AMP_XZ * amp_scale
		    shake_ty = (math.random() - 0.5) * 2 * SHAKE_AMP_Y  * amp_scale
		    shake_tz = (math.random() - 0.5) * 2 * SHAKE_AMP_XZ * amp_scale
		    shake_timer = 0
		end
		
		-- filtro (smussa i cambi: niente scatti)
		local s = 0.35
		shake_x = shake_x + (shake_tx - shake_x) * s
		shake_y = shake_y + (shake_ty - shake_y) * s
		shake_z = shake_z + (shake_tz - shake_z) * s
		
		-- posizione finale = base + tremolio (niente drift su x/z!)
		local p = Vec3(
		    base_portone1_x + shake_x,
		    y_base          + shake_y,
		    base_portone1_z + shake_z
		)
        
        
        
        portone1:SetPosition(p)
        Sound.PlayAudioTrack("eqs", Sound.SoundTrackType.ONESHOT)
        MakeEarthquake(3)
        
   
        
    end -- end opening
    
    if t_open > OPEN_TIME then

		if (Sound.IsAudioTrackPlaying("eqs")) then
    	Sound.StopAudioTrack(Sound.SoundTrackType.ONESHOT)
		end

	end

        -- azzeramente jitter
	    if opening and t_open >= OPEN_TIME then
	         shake_x, shake_y, shake_z = 0, 0, 0
	    end

-----------------------------------------------------------------------------------------------------
-- APERTURA PORTONE SMALL   CAMERA LAMENTAZIONI

	local animSmall1 = SWsmall:GetAnim()
   
    if not portonesmall1 then return end

    
    local condizione_small = (animSmall1 == 1)

    if condizione_small and not flagPortoneSmall then
        flagPortoneSmall = true
        t_open_small = 0.0
        Sound.PlaySound(1197) --- sound effect provvisorio
    end
    
   

    if flagPortoneSmall and t_open_small < OPEN_TIME then
    
    
    	 if Input.IsKeyHit(Input.ActionID.LOOK) then -- 0 riporta la camera su Lara
    		flag_camera_portone2 = true
   
   		end
    
    
    	if not flag_camera_portone2 then
    
   		 	CameraPortoneSmall:Play(baddyPortSmall)
    	
    	
       	end
    
    	
    	
    	
    	
    	
    	
    	
    
        t_open_small = t_open_small + dt
        local fracSmall = math.min(t_open_small / OPEN_TIME, 1.0) -- va da 0 a 1
        local pSmall = portonesmall1:GetPosition()
--        print("[ON LOOP] base small Y =", baseportonesmall1)
        local y_baseSmall = baseportonesmall1 + OPEN_DY * fracSmall
--        print("[ON LOOP] y_baseSmall =", y_baseSmall)
        
        
        
        
        -- aggiorna il target del jitter ogni SHAKE_UPDATE secondi
		shake_timer = shake_timer + dt
		if shake_timer >= SHAKE_UPDATE then
		    local amp_scale = math.sqrt(1.0 - fracSmall)        -- si attenua verso la fine
		    shake_tx = (math.random() - 0.5) * 2 * SHAKE_AMP_XZ * amp_scale
		    shake_ty = (math.random() - 0.5) * 2 * SHAKE_AMP_Y  * amp_scale
		    shake_tz = (math.random() - 0.5) * 2 * SHAKE_AMP_XZ * amp_scale
		    shake_timer = 0
		end
		
		-- filtro (smussa i cambi: niente scatti)
		local s = 0.15
		shake_x = shake_x + (shake_tx - shake_x) * s
		shake_y = shake_y + (shake_ty - shake_y) * s
		shake_z = shake_z + (shake_tz - shake_z) * s
		
		-- posizione finale = base + tremolio (niente drift su x/z!)
		pSmall = Vec3(
		    base_portonesmall1_x + shake_x,
		    y_baseSmall          + shake_y,
		    base_portonesmall1_z + shake_z
		)
        
        
        
        portonesmall1:SetPosition(pSmall)
        
        
        
		
		
		 

        
    end -- end opening portone small

       

-------------------------------------------------------------------------------------------------
-- MOVIMENTO pendoli infuocati

 
     
     

 
        
        EmitFlameAtLocal(Pendolo1, joint_coppa, offsetFiammaPendolo, forzaFiamma, 1) -- blu
		EmitFlameAtLocal(Pendolo2, joint_coppa, offsetFiammaPendolo, forzaFiamma, 2) -- verde
		EmitFlameAtLocal(Pendolo3, joint_coppa, offsetFiammaPendolo, forzaFiamma, 3) -- arancio
		EmitFlameAtLocal(Pendolo4, joint_coppa, offsetFiammaPendolo, forzaFiamma, 4) -- viola
		EmitFlameAtLocal(Pendolo5, joint_coppa, offsetFiammaPendolo, forzaFiamma, 5) -- giallo

   
        tPendolo = tPendolo + dt

        local f1 = math.floor(((tPendolo + PeriodPendolo*phase[1]) / PeriodPendolo) * nFrames) % nFrames
		local f2 = math.floor(((tPendolo + PeriodPendolo*phase[2]) / PeriodPendolo) * nFrames) % nFrames
        local f3 = math.floor(((tPendolo + PeriodPendolo*phase[3]) / PeriodPendolo) * nFrames) % nFrames
		local f4 = math.floor(((tPendolo + PeriodPendolo*phase[4]) / PeriodPendolo) * nFrames) % nFrames
		local f5 = math.floor(((tPendolo + PeriodPendolo*phase[5]) / PeriodPendolo) * nFrames) % nFrames

-- OSCILLAZIONI dei pendoli     

        Pendolo1:SetFrame(f1)
        Pendolo2:SetFrame(f2)
        Pendolo3:SetFrame(f3)
        Pendolo4:SetFrame(f4)
        Pendolo5:SetFrame(f5)
        
 


------------------------------------------------------------------------------------------------
-- TRAP INFERNO

-- === TRAPPOLA INFERNO: countdown -> fiamme ===
if inferno_state == "countdown" then
    inferno_t = inferno_t + dt
    local remaining = COUNTDOWN_TIME - inferno_t
    draw_inferno_timer(remaining)
    if remaining <= 0.0 then
        inferno_state = "flames"
        inferno_t = 0.0
         
        
        
	    Sound.PlayAudioTrack(TrackNameFiammata, ttFiammata)
	        
    end

elseif inferno_state == "flames" then
    -- emetti fiamme dal pavimento per FLAME_TIME secondi
     local delta_pInf = Vec3(0, 8, 0)
    for i, pos in ipairs(inferno_pos) do
        EmitFloorFlame(pos + delta_pInf, StrengthInferno)
    end

    inferno_t = inferno_t + dt
    if inferno_t >= FLAME_TIME then
        inferno_state = "done"
        -- finito: smette di emettere, residui svaniscono da soli
    end
end





-------------------------------------------------------------------------------------------------
-- MOVIMENTO ALTARE con le 4 pietre


-- trigger del movimento
    if flag_altar and not altar_moving then
        altar_moving = true
        t_altar = 0.0
        flag_altar = false
    end

    -- movimento smooth
    if altar_moving and t_altar < OPEN_TIME_ALTAR then
    
    
    	 if Input.IsKeyHit(Input.ActionID.LOOK) then -- LOOK riporta la camera su Lara
    		flag_camera_portone3 = true
   
   		end
    
    
    	if not flag_camera_portone3 then
    
   		 	CameraAltare:Play(BaddyGhost2)
    	
    	
       	end
    
    
    
    	
    
        t_altar = t_altar + dt
        local frac = math.min(t_altar / OPEN_TIME_ALTAR, 1.0)

        local pos = StaticAltar:GetPosition()
        pos.x = base_altar_x + MOVE_DX * frac
        StaticAltar:SetPosition(pos)

        if frac == 1.0 then
            altar_moving = false
            flag_altar = false
        end
    end


------------------------------------------------------------------------------------
-- PUZZLE 4 FUOCHI
	

	if not all_on() then
		for i = 1, #PosizioniFuochiMuro do
		    EmitFloorFlameBlue(PosizioniFuochiMuro[i], 20)
		end

	end

	update_fire_puzzle()
	

	for i=1,4 do
	    if fire_on[i] then
	        --Effects.EmitFire(PosizioniFuochiPuzzle[i], 1)  -- secondo argomento = size 
            ilabel = i + 345
            EmitFuocoMio(PosizioniFuochiPuzzle[i], 1, ilabel)
	    end
	end
	
	 
	
	

-------------------------------------------------------------------------------------


---------------------------------------------------------------------
-- FOG BASE TORRE
    for i, posA in ipairs(spots_pozze_nebbia) do
    	spawnNebbiaScura(posA, "FogBase"..i)
	end
---------------------------------------------------------------------------------------- 


---------------------------------------------------------------------
-- NEBBIE pozze
    for j, posB in ipairs(spots_pozze_nebbia_minori) do
    	spawnNebbiaMinori(posB, 10, 40, "NebbiaMinore"..j)
	end
---------------------------------------------------------------------------------------- 

---------------------------------------------------------------------
-- NEBBIE sala mostri
    for j, posB in ipairs(spots_pozze_nebbia_segreto) do
    	spawnNebbiaMinori(posB, 20, 40, "NebbiaMostri"..j)
	end
---------------------------------------------------------------------------------------- 


----------------------------------------------------------------------------------------
-- DIARIO

	if Input.IsKeyHit(Input.ActionID.H) then
        diary:ShowDiary(1)
    end
    
----------------------------------------------------------------------------------------    
	
end   -- end OnLoop












LevelFuncs.OnSave = function() 

	LevelVars.sflag = sflag

    LevelVars.opening = opening
    LevelVars.t_open  = t_open
    
    LevelVars.flagPortoneSmall = flagPortoneSmall
    LevelVars.t_open_small = t_open_small
    
    
    LevelVars.altar_moving = altar_moving
	LevelVars.t_altar      = t_altar
	LevelVars.flag_altar   = flag_altar
	
	LevelVars.inferno_state = inferno_state
    LevelVars.inferno_t     = inferno_t
    
    LevelVars.FlagAutunno = FlagAutunno
	LevelVars.FlagInverno = FlagInverno
	LevelVars.FlagPrimavera = FlagPrimavera
	LevelVars.FlagEstate = FlagEstate
	LevelVars.opening2 = opening2
    LevelVars.t_open2  = t_open2
    
    if portone2 then
	    LevelVars.portone2_y = portone2:GetPosition().y
	end
	
	if portone1 then
	    LevelVars.portone1_y = portone1:GetPosition().y
	end
	
	if portonesmall1 then
	    LevelVars.portonesmall1_y = portonesmall1:GetPosition().y
	    print("ON SAVE portone small y", LevelVars.portonesmall1_y)
	end

	LevelVars.RoomLacrima3_flag = RoomLacrima3_flag
	
	if StaticAltar then
    	LevelVars.altar_x = StaticAltar:GetPosition().x
	end
	
	
	LevelVars.fire_on   = { fire_on[1], fire_on[2], fire_on[3], fire_on[4] }
    LevelVars.prev_anim = { prev_anim[1], prev_anim[2], prev_anim[3], prev_anim[4] }
    
    LevelVars.level_time = level_time -- per timer statistiche
    
    
    LevelVars.flare_on = flare_on
    LevelVars.flare_pitch = flare_pitch
    
    LevelVars.flag_camera_portone1 = flag_camera_portone1
    LevelVars.flag_camera_portone2 = flag_camera_portone2
    LevelVars.flag_camera_portone3 = flag_camera_portone3

    LevelVars.flag_perilfuoco = flag_perilfuoco
    LevelVars.flag_esplosione = flag_esplosione
    
     


end -- end OnSave




LevelFuncs.OnLoad = function() 





   InitAll()
   choose_lacrima_cols()
   
    sflag = LevelVars.sflag or 0 

    opening = LevelVars.opening or false
    t_open  = LevelVars.t_open  or 0.0
    
    flagPortoneSmall = LevelVars.flagPortoneSmall or false
    t_open_small = LevelVars.t_open_small or 0.0 
 


	altar_moving = LevelVars.altar_moving or false
	t_altar      = LevelVars.t_altar or 0.0
	flag_altar   = LevelVars.flag_altar or false
	
	inferno_state = LevelVars.inferno_state or "idle"
    inferno_t     = LevelVars.inferno_t or 0.0
    
    
    FlagAutunno = LevelVars.FlagAutunno or false
	FlagInverno = LevelVars.FlagInverno or false
	FlagPrimavera = LevelVars.FlagPrimavera or false 
	FlagEstate = LevelVars.FlagEstate or false
	
	opening2 = LevelVars.opening2 or false
    t_open2  = LevelVars.t_open2  or 0.0
    
    if portone2 and LevelVars.portone2_y then
	    base_portone2 = LevelVars.portone2_y - OPEN_DY * (t_open2 / OPEN_TIME)
	end
	
	if portone1 and LevelVars.portone1_y then
	    base_portone1 = LevelVars.portone1_y - OPEN_DY * (t_open / OPEN_TIME)
	end
	
	if portonesmall1 and LevelVars.portonesmall1_y then
	    baseportonesmall1 = LevelVars.portonesmall1_y - OPEN_DY * (t_open_small / OPEN_TIME)
	    print("ON LOAD portone small y", LevelVars.portonesmall1_y, baseportonesmall1)
	end


    RoomLacrima3_flag = LevelVars.RoomLacrima3_flag or false
    
    if StaticAltar and LevelVars.altar_x then
	    base_altar_x = LevelVars.altar_x - MOVE_DX * (t_altar / OPEN_TIME_ALTAR)
	else
	    base_altar_x = StaticAltar:GetPosition().x
	end
	
	fire_on   = LevelVars.fire_on   or {false,false,false,false}
    prev_anim = LevelVars.prev_anim or {0,0,0,0}
    
	   
    level_time = LevelVars.level_time or 0 -- per timer statistiche
    
    flare_on = LevelVars.flare_on or false
    flare_pitch = LevelVars.flare_pitch or 0
    
    flag_camera_portone1 = LevelVars.flag_camera_portone1 or false
    flag_camera_portone2 = LevelVars.flag_camera_portone2 or false
    flag_camera_portone3 = LevelVars.flag_camera_portone3 or false

    flag_perilfuoco = LevelVars.flag_perilfuoco or false
    flag_esplosione = LevelVars.flag_esplosione or false



end -- end OnLoad


LevelFuncs.OnFreeze = function() 


if not stats_active then return end
    if Flow.GetFreezeMode() ~= Flow.FreezeMode.FULL then return end

    -- usare IsKeyHeld è più affidabile del “colpo singolo” IsKeyHit in freeze
    if Input.IsKeyHeld(Input.ActionID.RETURN) or Input.IsKeyHeld(Input.ActionID.ESCAPE) then
        stats_active = false
        Flow.SetFreezeMode(Flow.FreezeMode.NONE)
        Flow.EndLevel()
    end

end  -- end OnFreeze



LevelFuncs.OnEnd = function() end
LevelFuncs.OnUseItem = function() end

