-- Salva lo stato di uno static che si muove
function SaveMovingStatic(key, obj, t_open, opening, delta, open_time)
    if not LevelVars.movingStatics then
        LevelVars.movingStatics = {}
    end

    LevelVars.movingStatics[key] = {
        opening = opening,
        t_open  = t_open,
        pos_y   = obj and obj:GetPosition().y or nil,
        pos_x   = obj and obj:GetPosition().x or nil,
        pos_z   = obj and obj:GetPosition().z or nil,
        delta   = delta,
        open_time = open_time
    }
end

-- Ricarica lo stato e riallinea la base
function LoadMovingStatic(key, obj, axis)
    if not LevelVars.movingStatics or not LevelVars.movingStatics[key] then
        return 0.0, false, obj and obj:GetPosition()[axis] or 0
    end

    local data = LevelVars.movingStatics[key]
    local t_open  = data.t_open or 0.0
    local opening = data.opening or false

    local base
    if obj and data["pos_"..axis] then
        local frac = t_open / (data.open_time or 1.0)
        base = data["pos_"..axis] - (data.delta or 0) * frac
    else
        base = obj and obj:GetPosition()[axis] or 0
    end

    return t_open, opening, base
end



-- in OnSave
SaveMovingStatic("portone1", portone1, t_open1, opening1, OPEN_DY, OPEN_TIME)
SaveMovingStatic("portone2", portone2, t_open2, opening2, OPEN_DY, OPEN_TIME)
SaveMovingStatic("boxminot", BoxMinot, t_open, opening, OPEN_DY, OPEN_TIME)
SaveMovingStatic("altare",  StaticAltar, t_altar, altar_moving, MOVE_DX, OPEN_TIME_ALTAR)

-- in OnLoad
t_open1, opening1, base_portone1 = LoadMovingStatic("portone1", portone1, "y")
t_open2, opening2, base_portone2 = LoadMovingStatic("portone2", portone2, "y")
t_open,  opening,  base_BoxMinot = LoadMovingStatic("boxminot", BoxMinot, "y")
t_altar, altar_moving, base_altar_x = LoadMovingStatic("altare", StaticAltar, "x")



