----------------------------------------------------------
-- SISTEMA DI VARIABILI PERSISTENTI AUTOMATICHE
----------------------------------------------------------

local Persistent = {
    vars = {}
}

-- Registra una variabile (nome, valore iniziale)
function Persistent:Register(name, initial)
    self.vars[name] = initial
    _G[name] = initial     -- crea anche la variabile globale se non esiste
end

-- Leggi da LevelVars o usa default
function Persistent:LoadAll()
    for name, default in pairs(self.vars) do
        local v = LevelVars[name]
        if v == nil then
            v = default
        end
        _G[name] = v
        LevelVars[name] = v
        print("[LOAD]", name, "=", v)
    end
end

-- Salva tutte le variabili registrate in LevelVars
function Persistent:SaveAll()
    for name, _ in pairs(self.vars) do
        LevelVars[name] = _G[name]
        print("[SAVE]", name, "=", _G[name])
    end
end
