-- FILE: Levels\home.lua

local Common = require("Levels.commonfunctions")

local function EmitFuocoMio(posizione, stren, ii)

			Effects.EmitFire(posizione, stren)
		    Effects.EmitLight(
		        posizione,                        -- posizione
		        Color(255, 140, 40),        -- colore
		        12,                         -- raggio
		        16,                         -- falloff
		        "lucefireandlight_" .. ii     -- chiave univoca per ogni luce
		    )

end 

local flag_accendifuochi = false
local DoorFantasma = TEN.Objects.GetMoveableByName("door_type9_18")
local Skeleton1 = TEN.Objects.GetMoveableByName("skeleton_23")
local Skeleton2 = TEN.Objects.GetMoveableByName("skeleton_22")
local Skeleton3 = TEN.Objects.GetMoveableByName("skeleton_24")

local function spawnNebbiaMinori(pos, raggio, density, nomeFog)

 
	Effects.EmitFogBulb(
    pos, 
    raggio, 
    density, 
    Color(190, 255, 80), 
    nomeFog
    
    )
 
end

local function accendifuochi()

	local position1 = Vec3(34304, -512, 25600) 
	local position2 = Vec3(34304, -512, 23552) 
	local position3 = Vec3(36352, -512, 23552)  
	local position4 = Vec3(36352, -512, 25600)
	
	local position5 = Vec3(34304, -512, 30208)
	local position6 = Vec3(36352, -512, 30208)
	local position7 = Vec3(36352, -512, 35328)
	local position8 = Vec3(34304, -512, 35328)
	
	
	
	
	local stren = 1
	
	if DoorFantasma:GetAnim()==1 or DoorFantasma:GetAnim()==2 then
		flag_accendifuochi = true		
	end
	
	
	local track = "scarysoundhorror"
	if DoorFantasma:GetAnim()==2 then
--		Sound.PlayAudioTrack(track, Sound.SoundTrackType.ONESHOT)
		Sound.PlaySound(1202) 
	end
	
	if flag_accendifuochi then
	
		EmitFuocoMio(position1, stren, 1)
		EmitFuocoMio(position2, stren, 2)
		EmitFuocoMio(position3, stren, 3)
		EmitFuocoMio(position4, stren, 4)
		
		EmitFuocoMio(position5, stren, 5)
		EmitFuocoMio(position6, stren, 6)
		EmitFuocoMio(position7, stren, 7)
		EmitFuocoMio(position8, stren, 8)


	end
	
	local positionFog = Vec3(44544, 3072, 39424)
	local raggio_2 = 8
    local inte1 = 15
    
    spawnNebbiaMinori(positionFog, raggio_2, inte1, "nebbia1")

	
	
	
	

end

LevelFuncs.OnLaraEntrance = function()

	 
		
		local pos = Vec2(PercentToScreen(50, 86))
 		local duration = 6.0  
 		

    	local s = DisplayString(
        [[This crypt located under the Benedictine monastery is the ideal place 
          to try my new custom portable light system]],
        pos,
        1.0,
        Color(200, 220, 255)  
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true)

	local track = "t1"
	Sound.PlayAudioTrack(track, Sound.SoundTrackType.ONESHOT)
		
	 
		
		 
    
    
end


LevelFuncs.OnLaraFirstDark = function()

	 
		
		local pos = Vec2(PercentToScreen(50, 86))
 		local duration = 4.0  

    	local s = DisplayString(
        [[This corridor is pitch-dark.  
          Use the FLARE-ON key to switch on the light]],
        pos,
        1.0,
        Color(200, 220, 255)  
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true)
		
	local track = "t2"
	Sound.PlayAudioTrack(track, Sound.SoundTrackType.ONESHOT)
		
		 
    
    
end


LevelFuncs.OnLaraSecondDark = function()

	 
		
		local pos = Vec2(PercentToScreen(50, 82))
 		local duration = 10.0  

    	local s = DisplayString(
        [[Let's explore this room. We need to find the item that activates the previous chamber.
          Use the J and L keys to aim my spotlight down or up.
          Press K to reset its direction]],
        pos,
        1.0,
        Color(200, 220, 255)  
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true)
		
	 
		
	local track = "t3"
	Sound.PlayAudioTrack(track, Sound.SoundTrackType.ONESHOT)
    
    
end


LevelFuncs.OnLaraActivateRooms = function()

	 
		
		local pos = Vec2(PercentToScreen(50, 82))
 		local duration = 11  

    	local s = DisplayString(
        [[This mosaic... it is a Tinnos symbol. The murals on the walls confirm it.
          This artwork is far older than the monastery above,
          proof that Tinnos reached southern Italy in ancient times]],
        pos,
        1.0,
        Color(200, 220, 255)  
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true)
    
    local track = "t4"
	Sound.PlayAudioTrack(track, Sound.SoundTrackType.ONESHOT)
		
	 
end



local Skeleton1 = TEN.Objects.GetMoveableByName("skeleton_23")
local Skeleton2 = TEN.Objects.GetMoveableByName("skeleton_22")
local Skeleton3 = TEN.Objects.GetMoveableByName("skeleton_24")


LevelFuncs.OnActiSkel = function()
	Skeleton1:Enable()
	Skeleton2:Enable()
	Skeleton3:Enable()
	
	    local pos = Vec2(PercentToScreen(50, 82))
 		local duration = 10  

    	local s = DisplayString(
        [[To let me grab the bar, press the ACTION key.
          To launch me from the bar, release the ACTION key.
          The bar is directional: I cannot use the same bar to go in the opposite direction]],
        pos,
        1.0,
        Color(200, 220, 255)  
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true)
    
    local track = "t5"
	Sound.PlayAudioTrack(track, Sound.SoundTrackType.ONESHOT)
	
end

LevelFuncs.OnRollSprint = function()

	local pos = Vec2(PercentToScreen(50, 92))
 	local duration = 3 
 	
 	local s = DisplayString(
        [[When crouched, press the SPRINT key to roll forward quickly]],
        pos,
        1.0,
        Color(200, 220, 255)  
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    
    Strings.ShowString(s, duration, true)
    
    local track = "t6"
	Sound.PlayAudioTrack(track, Sound.SoundTrackType.ONESHOT)

	
end


local flagTinnos = false
LevelFuncs.OnTinnosActivate = function()
	if not flagTinnos then
		flagTinnos = true
		TEN.Objects.GetStaticByName("static_mesh_27"):Shatter()
		Sound.PlaySound(1199)
		TEN.Objects.GetMoveableByName("claw_mutant_26"):Enable()
	end
end
local function activateTinnos()

	local posFuoco = Vec3(57856, -0, 38400)
	local posBrac1 = Vec3(51712, -512, 40448)
	local posBrac2 = Vec3(51712, -512, 38400)
	local strenTinnos = 3
	local strenBrac = 1
	
	if flagTinnos then
		EmitFuocoMio(posFuoco, strenTinnos, 121)
		EmitFuocoMio(posBrac1, strenBrac, 122)
		EmitFuocoMio(posBrac2, strenBrac, 123)
	end

end

local showStringClavis = false
LevelFuncs.OnClavis = function()
	
	local id_pi4 = 503   -- flare item
	local count_pi4 = GetItemCount(id_pi4)
	
	local pos = Vec2(PercentToScreen(50, 76))
 	local duration = 12 
 	
 	local s = DisplayString(
        [[This must be one of the Clavis Malachi keys.
        Brother Blackarrow wrote that these keys allow to progress through 
        the City of Topaz and open the tomb of Saint Malachy.
        I must be close to Topaz... and to the actual tomb then]],
        pos,
        1.0,
        Color(200, 220, 255)  
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }

	if count_pi4 == 1 and not showStringClavis then
		Strings.ShowString(s, duration, true)
		showStringClavis = true
		
		local track = "t7"
		Sound.PlayAudioTrack(track, Sound.SoundTrackType.ONESHOT)
		
	end
end

LevelFuncs.OnAfterTinnos = function()
	
	    local pos = Vec2(PercentToScreen(50, 76))
 		local duration = 11  

    	local s = DisplayString(
        [[New devices checked. Time to change my clothes.
          I am ready to head to Zafferana Etnea tonight 
          and begin the exploration of the Lost City of Topaz, 
          searching for the tomb of Saint Malachy]],
        pos,
        1.0,
        Color(200, 220, 255)  
    )
    s:SetFlags{ TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW }
    Strings.ShowString(s, duration, true)
    
    
    local track = "t8"
	Sound.PlayAudioTrack(track, Sound.SoundTrackType.ONESHOT)
	
end


LevelFuncs.OnStart = function() 

------------------------------------------------------------
-- da eliminare in RELEASE

--Inventory.SetItemCount(501, 1)
--Inventory.SetItemCount(503, 1)

------------------------------------------------------------
Common.level_time = 0      -- inizio timer per statistiche

local id_flare = 983   -- flare item
local count_flare = GetItemCount(id_flare)

if count_flare ~= 0 then     -- se ci sono flare nell'inventario 
	Inventory.SetItemCount(954, 1)	   -- mette lo shotgun in inventario 
	Inventory.SetItemCount(955, 18)    -- cartucce rosse
	Inventory.SetItemCount(956, 6)    -- cartucce blu
	Inventory.SetItemCount(978, 1)    -- medikit grande
	Inventory.SetItemCount(979, 4)    -- medikit piccolo
	Inventory.SetItemCount(983, 0)   -- azzera flare
end

    Lara:SetWeaponType(WeaponType.SHOTGUN, false)
    Lara:SetWeaponType(WeaponType.PISTOLS, false)



end

LevelFuncs.OnLoop = function(dt) 


	Common.UpdateFlare(dt)
	Common.UpdateLevelTime(dt)
    Common.DrawWeaponHUD()
	
		accendifuochi()
		
		activateTinnos()
	 


end



LevelFuncs.OnSave = function() 

	LevelVars.level_time = Common.level_time
    LevelVars.flare_on = Common.flare_on
    LevelVars.flare_pitch = Common.flare_pitch
    
    LevelVars.flag_accendifuochi = flag_accendifuochi
    
    LevelVars.flagTinnos = flagTinnos
    
    LevelVars.showStringClavis = showStringClavis


end




LevelFuncs.OnLoad = function() 


	Common.level_time = LevelVars.level_time or 0
    Common.flare_on = LevelVars.flare_on or false
    Common.flare_pitch = LevelVars.flare_pitch or 0	
    
    flag_accendifuochi = LevelVars.flag_accendifuochi or false
    
    flagTinnos = LevelVars.flagTinnos or false
    
    showStringClavis = LevelVars.showStringClavis or false

end



LevelFuncs.OnEnd = function() end
LevelFuncs.OnUseItem = function() end
LevelFuncs.OnFreeze = function() end
