-- =====================================================================
-- TEMPLATE BASE DI LIVELLO  (TEN ENGINE)
-- Autore: Marco [Fisico Teorico]
-- Struttura universale per tutti i livelli futuri
--
-- Include:
--  - HUD armi personalizzato
--  - Flare direzionale custom
--  - Statistiche di fine livello
--  - Gestione salvataggi/caricamenti
-- =====================================================================

-- IMPORT MODULI COMUNI
local Common = require("Levels.commonfunctions")
local AudioDurations = require("Levels.AudioDurations")  -- opzionale, utile per sincronizzazioni audio future


------------------------------------------------------------------------------------
-- VARIABILI LOCALI DI LIVELLO
------------------------------------------------------------------------------------

-- Qui puoi dichiarare riferimenti a oggetti specifici del livello
-- (es. leve, porte, meccanismi, puzzle, ecc.)
local myObject


------------------------------------------------------------------------------------
-- FUNZIONI AUSILIARIE
------------------------------------------------------------------------------------

-- Correzione standard dell’inversione index/value nelle SetItemFlags
function FixedSetItemFlags(p, index, value)
    p:SetItemFlags(value, index)
end


------------------------------------------------------------------------------------
-- FUNZIONE DI INIZIALIZZAZIONE
-- Chiamata da OnStart e OnLoad
------------------------------------------------------------------------------------

local function InitAll()
    -- Esempio: ottenere un moveable o uno static per manipolazioni iniziali
    -- myObject = TEN.Objects.GetMoveableByName("nome_moveable")

    -- Inizializzazioni custom del livello qui
    -- FixedSetItemFlags(myObject, 0, 255)
end


------------------------------------------------------------------------------------
-- STATISTICHE DI FINE LIVELLO
------------------------------------------------------------------------------------

LevelFuncs.OnFineLivello = function()
    Common.ShowStatsHUD()
end


------------------------------------------------------------------------------------
-- ONSTART  (chiamata all’inizio del livello)
------------------------------------------------------------------------------------

LevelFuncs.OnStart = function()

    --------------------------------------------------------------------
    -- ESEMPIO: gestione inventario iniziale
    -- (Puoi personalizzare questo blocco per i tuoi livelli)
    --------------------------------------------------------------------
    local id_flare = 983
    local count_flare = GetItemCount(id_flare)

    if count_flare ~= 0 then
        Inventory.SetItemCount(954, 1)    -- Shotgun
        Inventory.SetItemCount(955, 18)   -- Cartucce rosse
        Inventory.SetItemCount(956, 6)    -- Cartucce blu
        Inventory.SetItemCount(978, 3)    -- Medikit grande
        Inventory.SetItemCount(979, 6)    -- Medikit piccolo
        Inventory.SetItemCount(983, 0)    -- Azzera flare
    end

    --------------------------------------------------------------------
    -- TIMER STATISTICHE
    --------------------------------------------------------------------
    Common.level_time = 0

    --------------------------------------------------------------------
    -- INIZIALIZZAZIONE OGGETTI
    --------------------------------------------------------------------
    InitAll()

end


------------------------------------------------------------------------------------
-- ONLOOP  (aggiornato ogni frame)
------------------------------------------------------------------------------------

LevelFuncs.OnLoop = function(dt)

    --------------------------------------------------------------------
    -- AGGIORNA TIMER PER STATISTICHE
    --------------------------------------------------------------------
    Common.UpdateLevelTime(dt)

    --------------------------------------------------------------------
    -- HUD ARMI
    --------------------------------------------------------------------
    Common.DrawWeaponHUD()

    --------------------------------------------------------------------
    -- FLARE DIREZIONALE CUSTOM
    --------------------------------------------------------------------
    Common.UpdateFlare(dt)

    --------------------------------------------------------------------
    -- SEZIONE CUSTOM PER SCRIPT DI LIVELLO
    -- (Es. puzzle, trigger, effettistica, ecc.)
    --------------------------------------------------------------------
    -- Esempio:
    -- if Input.IsKeyHit(Input.ActionID.ACTION) then
    --     Effects.EmitLight(Vec3(0,0,0), Color(255,0,0), 8, 12, "test")
    -- end

end


------------------------------------------------------------------------------------
-- ONSAVE / ONLOAD  (salvataggio e caricamento stato)
------------------------------------------------------------------------------------

LevelFuncs.OnSave = function()

    LevelVars.level_time   = Common.level_time
    LevelVars.flare_on     = Common.flare_on
    LevelVars.flare_pitch  = Common.flare_pitch

end


LevelFuncs.OnLoad = function()

    Common.level_time   = LevelVars.level_time  or 0
    Common.flare_on     = LevelVars.flare_on    or false
    Common.flare_pitch  = LevelVars.flare_pitch or 0

    InitAll()

end


------------------------------------------------------------------------------------
-- ONFREEZE  (freeze durante le statistiche di fine livello)
------------------------------------------------------------------------------------

LevelFuncs.OnFreeze = function()
    Common.OnFreeze()
end


------------------------------------------------------------------------------------
-- SEZIONI PLACEHOLDER (facoltative)
------------------------------------------------------------------------------------

LevelFuncs.OnEnd = function() end
LevelFuncs.OnUseItem = function() end

-- =====================================================================
-- FINE TEMPLATE DI LIVELLO
-- =====================================================================
