---- FILE: \Part_1_End.lua
---@diagnostic disable: duplicate-set-field
require("Levels.MISC_LOOP_FUNCTIONS")

LevelFuncs.OnLoad = function() end
LevelFuncs.OnSave = function() end
LevelFuncs.OnStart = function() 
	Flow.SetTotalSecretCount(0)
end
LevelFuncs.OnControlPhase = function() 
	Knock_Out_Baddies()
	Make_Dummy_Invincible()
end
LevelFuncs.OnEnd = function() end

LevelFuncs.SetClassicModeSecretCount = function()
	print("Starting Classic Mode")
end

LevelFuncs.EndPart1Check = function(levelSecrets)

	-- flag for demo functionality HEHE
	local isPart1 = false

	-- display level end stats
	LevelFuncs.Engine.Node.DrawText("Escape From Meteorite Cavern", 37, 50, true, true, TEN.Color(255,255,255))
	LevelFuncs.Engine.Node.DrawText("LEVEL STATISTICS", 37, 60, true, true, TEN.Color(255,255,255))
	
	-- display secrets missed if applicable
	if missedSecrets == 0.0 then
		LevelFuncs.Engine.Node.DrawText("Collected All Secrets!", 37, 70, true, true, TEN.Color(255,255,255))
	else
		LevelFuncs.Engine.Node.DrawText("SECRETS MISSED", 37, 70, true, true, TEN.Color(255,255,255))
		LevelFuncs.Engine.Node.DrawText(tostring(missedSecrets), 37, 75, true, true, TEN.Color(255,255,255))
	end 
	
	-- display prompt to proceed
	LevelFuncs.Engine.Node.DrawText("Press the LOOK Key to Continue", 50, 85, true, true, TEN.Color(255,255,255))
	
	-- end level when any movement key is pressed (or any movement key)
	if EndLevelKeyIsHit() then
		-- remove key item 2 (helicopter keys) from inventory
		LevelFuncs.Engine.Node.RemoveInventoryItem(TEN.Objects.ObjID.KEY_ITEM2, 1)
		-- determine which level to jump to
		if isDemo == true then 
			if missedSecrets == 0.0 then
				-- proceed to bonus level if all secrets were collected
				LevelFuncs.Engine.Node.EndLevel(5)
			else
				-- otherwise return to title screen
				LevelFuncs.Engine.Node.EndLevel(99)
			end
		-- else not a demo
		else
			-- proceed to next level
			LevelFuncs.Engine.Node.EndLevel(2)
		end
	end
end

LevelFuncs.ExportedNodeFunction = function(activator)
	LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 3, TEN.Color(255,255,255), 6, 12, 0, 10, 5, 0, 0, 0, 7)
end

--LevelFuncs.SwapOutfit = function(activator)
	--for i = 0,14,1
	--do
		--Lara:SwapMesh(i, 22, i)
	--end
--end

local EventSequence = require("Engine.EventSequence")
local canPulseAgain = true
function Knock_Out_Baddy(baddy_name, moveableSlot)
	-- if enemy is within 128 units of Lara
	local baddyPosition = TEN.Objects.GetMoveableByName(baddy_name):GetPosition()
	local laraPosition = TEN.Objects.GetMoveableByName("LARA_MAIN"):GetPosition()
	local distanceFromLara = math.abs(laraPosition:Distance(baddyPosition))
	local baddyObj = TEN.Objects.GetMoveableByName(baddy_name)

	--local isLaraFacingEnemy = Util.HasLineOfSight(lara:GetRoomNumber(), lara:GetPosition(), baddyPosition)
	
	-- if (LevelFuncs.Engine.Node.TestMoveableDistance(3, 256, 0, baddy_name, "LARA_MAIN")) then
	if distanceFromLara <= 256.0 and baddyObj:GetHP() >= 1 then
		--print("distance : " .. distanceFromLara)
		-- SPRINT SLIDE KNOCKOUT LOGIC
		-- if lara is performing a sprint slide
		if (LevelFuncs.Engine.Node.TestMoveableAnimation("LARA_MAIN", 956) or LevelFuncs.Engine.Node.TestMoveableAnimation("LARA_MAIN", 957)) then
			SetBaddyKnockoutAnim(moveableSlot, baddy_name)
		-- else use kick mechanics
		else
			-- KNEE AND TWIST KICK LOGIC
			print("distance : " .. distanceFromLara)
			if Input.IsKeyPulsed(Input.ActionID.ACTION, 3, 2) and canPulseAgain == true then
				canPulseAgain = false
				-- Get the random attack anim for Lara
				if Lara:GetHandStatus() == Objects.HandStatus.WEAPON_DRAW or Lara:GetHandStatus() == Objects.HandStatus.WEAPON_READY then
					attackAnimIDs = {976} -- 976, 1005, 1003
				else
					attackAnimIDs = {977, 976, 1005, 1006}
				end
				randomAttackAnim = attackAnimIDs[math.random(1, #attackAnimIDs)]
				lara : SetAnim(randomAttackAnim)
				LevelFuncs.LaraKickOrganizer(moveableSlot, baddy_name)
			end
		end
	end
end

function SetBaddyKnockoutAnim(moveableSlot, baddy_name)
	-- determine the knock out anim based off the moveable slot
	if moveableSlot == 176 then -- SAS
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 23)
	elseif moveableSlot == 169 then -- flamethrower
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 24)
	elseif moveableSlot == 173 then -- mp with gun
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 39)
	elseif moveableSlot == 170 then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 31)
	elseif moveableSlot == 131 then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 25)
	elseif moveableSlot == 175 then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 71)
	elseif moveableSlot == 183 then -- scottsman
		defenseAnimIDs = {1,2}
		randomDefenseAnim = defenseAnimIDs[math.random(1, #defenseAnimIDs)]
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, randomDefenseAnim)
	end
end

LevelFuncs.LaraKickOrganizer = function(moveableSlot, baddy_name)
	local attack_org = EventSequence.Create(
						"attack_org", -- sequence's name
						false, -- loop
						false, -- no countdown is displayed
						0.4,
						{LevelFuncs.KickAManBecauseItsWhatHeDeservesBINCH, moveableSlot, baddy_name}, 
						0.9, 
						LevelFuncs.RestoreLaraWeaponStatus,
						0.01,
						LevelFuncs.RestoreLaraAnim
						)
	-- event sequences are inactive to begin with and so need to be started
    attack_org:Start()
end

LevelFuncs.KickAManBecauseItsWhatHeDeservesBINCH = function(moveableSlot, baddy_name)
	SetBaddyKnockoutAnim(moveableSlot, baddy_name)
end

LevelFuncs.RestoreLaraWeaponStatus = function()
	if Lara:GetHandStatus() == Objects.HandStatus.WEAPON_DRAW or Lara:GetHandStatus() == Objects.HandStatus.WEAPON_READY then
		-- init weaponLaraSlot
		local weaponLaraSlot = 0
		if Lara:GetWeaponType() == Objects.WeaponType.PISTOLS then
			weaponLaraSlot = 2
		elseif Lara:GetWeaponType() == Objects.WeaponType.UZIS then
			weaponLaraSlot = 3
		elseif Lara:GetWeaponType() == Objects.WeaponType.SHOTGUN then
			weaponLaraSlot = 4
		elseif Lara:GetWeaponType() == Objects.WeaponType.REVOLVER then
			weaponLaraSlot = 5
		elseif Lara:GetWeaponType() == Objects.WeaponType.CROSSBOW then
			weaponLaraSlot = 6
		elseif Lara:GetWeaponType() == Objects.WeaponType.HK then
			weaponLaraSlot = 7
		elseif Lara:GetWeaponType() == Objects.WeaponType.GRENADE_LAUNCHER then
			weaponLaraSlot = 8
		elseif Lara:GetWeaponType() == Objects.WeaponType.ROCKET_LAUNCHER then
			weaponLaraSlot = 9
		elseif Lara:GetWeaponType() == Objects.WeaponType.HARPOON_GUN then
			weaponLaraSlot = 10
		end
		print("WEAPON ID: "..Lara:GetWeaponType())
		LevelFuncs.Engine.Node.SetLaraWeaponType(Lara:GetWeaponType(), true)
		lara : SetAnim(0, weaponLaraSlot) -- perform anim 4 LARA_PISTOLS is slot 2
	end
end

LevelFuncs.RestoreLaraAnim = function()
	canPulseAgain = true
	if Lara:GetHandStatus() == Objects.HandStatus.WEAPON_DRAW or Lara:GetHandStatus() == Objects.HandStatus.WEAPON_READY then
		lara : SetAnim(103) -- perform anim 4 LARA_PISTOLS is slot 2
	end
end

function Knock_Out_Baddies()
    local moveableSlots = {
        176, --'SAS CAIRO'
        169, -- FlameThrower Baddy
        173, -- 'MP wiht Gun'
        175, -- 'Baddy2'
        170,   -- scottsman
        183 -- dummy animtaing
    }
    for index, moveableSlot in pairs(moveableSlots) do
        local moveables = GetMoveablesBySlot(moveableSlot)
        for index, moveable in pairs(moveables) do
        	if moveableSlot == 176 then -- if the moveable is a SAS
        		Knock_Out_Baddy(moveable:GetName(), moveableSlot)
            end
            if moveableSlot == 169 then -- if the moveable is a Flamethrower
            	Knock_Out_Baddy(moveable:GetName(), moveableSlot)
            end
            if moveableSlot == 173 then -- if the moveable is a Flamethrower
            	Knock_Out_Baddy(moveable:GetName(), moveableSlot)
            end
            if moveableSlot == 170 then -- if the moveable is a Flamethrower
            	Knock_Out_Baddy(moveable:GetName(), moveableSlot)
            end
            if moveableSlot == 131 then -- if the moveable is a Flamethrower
            	Knock_Out_Baddy(moveable:GetName(), moveableSlot)
            end
            if moveableSlot == 175 then -- if the moveable is a Flamethrower
            	Knock_Out_Baddy(moveable:GetName(), moveableSlot)
            end
            if moveableSlot == 183 then -- if the moveable is a Flamethrower
            	Knock_Out_Baddy(moveable:GetName(), moveableSlot)
            end
        end
    end
end

function Make_Dummy_Invincible()
	LevelFuncs.Engine.Node.SetMoveableHitPoints(1, 100, "animating37_197")
end


LevelFuncs.SWINGPOLE_TUT_1 = function()
	-- if lara is hanging on a swingpole
	if lara:GetAnim() == 619 or lara:GetAnim() == 612 or 
	   lara:GetAnim() == 622 or
	   lara:GetAnim() == 640 or lara:GetAnim() == 641 then
		-- prompt
		LevelFuncs.Engine.Node.DrawText("SWINGPOLES (HANGING)", 50, 5, 1, 1, TEN.Color(255,255,255), 2, 1)

		LevelFuncs.Engine.Node.DrawText("Hold UP to swing forward\non a swingpole", 50, 20, 1, 1, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DrawText("Press JUMP while \nHANGING on a \nswingpole\nto PERCH on the \nswingpole", 30, 40, 1, 1, TEN.Color(255,255,255), 0.75, 1)
		LevelFuncs.Engine.Node.DrawText("Press DOWN while\nPERCHED on a \nswingpole\nto return to a \nhanging stance", 70, 40, 1, 1, TEN.Color(255,255,255), 0.75, 1)
		LevelFuncs.Engine.Node.DrawText("Press LEFT or RIGHT to shimmy on the swingpole", 50, 75, 1, 1, TEN.Color(255,255,255), 0.8, 1)
	end

	-- perch tutorial
	if lara:GetAnim() == 647 or lara:GetAnim() == 666 or lara:GetAnim() == 648 or lara:GetAnim() == 645 then
		-- prompt
		LevelFuncs.Engine.Node.DrawText("SWINGPOLES (PERCHED)", 50, 5, 1, 1, TEN.Color(255,255,255), 2, 1)

		LevelFuncs.Engine.Node.DrawText("Press JUMP to\njump forward off\na swingpole", 30, 42, 1, 1, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DrawText("Press DOWN while\nPERCHED on a \nswingpole\nto return to a \nhanging stance", 70, 40, 1, 1, TEN.Color(255,255,255), 0.75, 1)
		LevelFuncs.Engine.Node.DrawText("Press LEFT or RIGHT to segue to a tighrope walk", 50, 85, 1, 1, TEN.Color(255,255,255), 0.8, 1)
	end

	-- swinging tutorial
	if lara:GetAnim() == 462 or 
	   lara:GetAnim() == 630 or lara:GetAnim() == 631 or lara:GetAnim() == 632 or 
	   lara:GetAnim() == 634 or lara:GetAnim() == 615 or lara:GetAnim() == 620 then
		-- prompt
		LevelFuncs.Engine.Node.DrawText("SWINGPOLES (SWINGING)", 50, 5, 1, 1, TEN.Color(255,255,255), 2, 1)
		LevelFuncs.Engine.Node.DrawText("Press ROLL or DOWN while swinging forward to perform a 180 turn", 50, 20, 1, 1, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DrawText("Hold SPRINT to\nswitch to\nfaster swinging\nfor longer jumps", 30, 40, 1, 1, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DrawText("Press JUMP to\njump forward off\na swingpole", 70, 42, 1, 1, TEN.Color(255,255,255), 0.75, 1)
		LevelFuncs.Engine.Node.DrawText("PERCHING can also be performed\nby letting go of UP \nwhile SWINGING FORWARD", 50, 80, 1, 1, TEN.Color(255,255,255), 0.8, 1)
	end

	-- tightrope tutorial
	if lara:GetAnim() == 668 or 
	   lara:GetAnim() == 658 or lara:GetAnim() == 654 or
	   lara:GetAnim() == 670 or 
	   lara:GetAnim() == 656 or lara:GetAnim() == 659 or lara:GetAnim() == 657 then
		-- prompt
		LevelFuncs.Engine.Node.DrawText("TIGHTROPE", 50, 5, 1, 1, TEN.Color(255,255,255), 2, 1)
		LevelFuncs.Engine.Node.DrawText("Press DOWN to perform a 180 turn", 50, 20, 1, 1, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DrawText("PRESS CROUCH to\nswitch to\nhanging on\na swingpole", 30, 40, 1, 1, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DrawText("Press SPRINT to\nperform a\ncartwheel", 70, 42, 1, 1, TEN.Color(255,255,255), 0.75, 1)
		LevelFuncs.Engine.Node.DrawText("Press JUMP to jump forward off a tightrope", 50, 85, 1, 1, TEN.Color(255,255,255), 0.8, 1)
	end
end