---- FILE: \Meteorite_Cavern.lua
---@diagnostic disable: duplicate-set-field
--package.preload["MISC_LOOP_FUNCTIONS"] = function() require ("MISC_LOOP_FUNCTIONS") end require ("Levels.MISC_LOOP_FUNCTIONS")
require("Levels.MISC_LOOP_FUNCTIONS")
local cut1strTimeSpan1 = 6.0
LevelFuncs.OnLoad = function() end
LevelFuncs.OnSave = function() end
LevelFuncs.OnStart = function() 
	Flow.SetTotalSecretCount(25)
end
LevelFuncs.OnControlPhase = function() 
	Knock_Out_Baddies()
	drawSubSprite()
	showStatsSpritesBackGround()
	-- print("cut1strTimeSpan1: " .. cut1strTimeSpan1)
end
LevelFuncs.OnEnd = function() end

LevelFuncs.RED_GOO_KILL = function()
	LevelFuncs.Engine.Node.ParticleEmitter("animating15_284", 14, 0, TEN.Vec3(2,3,4), 0, 0, TEN.Color(255,0,0), TEN.Color(255,0,0), 2, 64, 1024, 6, false, false)
end



LevelFuncs.GetStatistics = function(nextLevel, totalSecretsSoFar)
-- nextLevel = 13, totalSecretsSoFar = 4
	-- flag for demo functionality HEHE
	local isDemo = false
	
	-- play level end stats
	TEN.Misc.PlayAudioTrack("001 level statistic", 1)
	
	-- get the collected secrets for the level
	local secretsCollected = GetSecretCount()
	
	-- compute the missed secrets
	local missedSecrets = totalSecretsSoFar - secretsCollected
	
	-- display level end stats
	LevelFuncs.Engine.Node.DrawText("Escape From Meteorite Cavern", 37, 50, true, true, TEN.Color(255,255,255))
	LevelFuncs.Engine.Node.DrawText("LEVEL STATISTICS", 37, 60, true, true, TEN.Color(255,255,255))
	
	-- display secrets missed if applicable
	if missedSecrets == 0.0 then
		LevelFuncs.Engine.Node.DrawText("Collected All Secrets!", 37, 70, true, true, TEN.Color(255,255,255))
	else
		LevelFuncs.Engine.Node.DrawText("TOTAL SECRETS MISSED", 37, 70, true, true, TEN.Color(255,255,255))
		LevelFuncs.Engine.Node.DrawText(tostring(missedSecrets), 37, 75, true, true, TEN.Color(255,255,255))
	end 
	
	-- display prompt to proceed
	LevelFuncs.Engine.Node.DrawText("Press the LOOK Key to Continue", 50, 85, true, true, TEN.Color(255,255,255))
	
	-- end level when any movement key is pressed (or any movement key)
	if EndLevelKeyIsHit() then
		-- remove key item 2 (helicopter keys) from inventory
		LevelFuncs.Engine.Node.RemoveInventoryItem(TEN.Objects.ObjID.KEY_ITEM2, 1)
		-- determine which level to jump to
		if isDemo == true then 
			if missedSecrets == 0.0 then
				-- proceed to bonus level if all secrets were collected
				LevelFuncs.Engine.Node.EndLevel(nextLevel)
			else
				-- otherwise return to title screen
				LevelFuncs.Engine.Node.EndLevel(99)
			end
		-- else not a demo
		else
			-- proceed to next level
			LevelFuncs.Engine.Node.EndLevel(3)
		end
	end
end

function EndLevelKeyIsHit()
	-- returns true if the following keys are hit:
	-- INVENTORY, BACK, LOOK, ROLL, DRAW
	-- (bitch don't ask me what the values are for each key. All I know is 13 is inventory (taylor's version))
	return (LevelFuncs.Engine.Node.KeyIsHit(13) or LevelFuncs.Engine.Node.KeyIsHit(1) or LevelFuncs.Engine.Node.KeyIsHit(11) or 
			LevelFuncs.Engine.Node.KeyIsHit(12) or LevelFuncs.Engine.Node.KeyIsHit(9))
end

-- DisplayText() : Will display text on screen for numSec seconds
function DisplayText (text, numSec, xPos, yPos)
    local string = DisplayString(text, xPos, yPos, Color.new(250,250,250))
    ShowString(string, numSec)
end

LevelFuncs.ExportedNodeFunction = function(activator)
	LevelFuncs.Engine.Node.DrawText("LEVEL COMPLETE!", 50, 60, true, false, TEN.Color(255,255,255))
	LevelFuncs.Engine.Node.DrawText("SECRETS MISSED: ", 50, 80, true, false, TEN.Color(255,255,255))
end


LevelFuncs.UW_MUTANT_PUZZLE = function(mutantName, volName)
	-- if Lara equipped a flare
	if (LevelFuncs.Engine.Node.TestLaraWeaponType(7)) then
		-- stun the swimmer mutant (play anim 1)
		LevelFuncs.Engine.Node.SetMoveableAnimation(mutantName, 1)
		-- disable the volume box
		LevelFuncs.Engine.Node.DisableVolume(volName)
	else
		-- if Lara is close to the swimmer mutant
		if (LevelFuncs.Engine.Node.TestMoveableDistance(2, 1000, 0, "LARA_MAIN", mutantName)) then
			-- trigger swimmer mutant attack anim (play anim 3)
			LevelFuncs.Engine.Node.SetMoveableAnimation(mutantName, 3)
			-- kill Lara
			LevelFuncs.Engine.Node.SetMoveableHitPoints(1, 0, "LARA_MAIN")
			-- shatter Lara's head mesh
			LevelFuncs.Engine.Node.ShatterMoveableMesh("LARA_MAIN", 14)
			-- disable the volume box
			LevelFuncs.Engine.Node.DisableVolume(volName)
		end
	end
end

local EventSequence = require("Engine.EventSequence")

LevelFuncs.UWKillLaraOrg = function()
	local uw_kill_lara_org = EventSequence.Create
	(
    	"uw_kill_lara_org", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.
    	0.5, -- I made an enumerator for this so I don't have to change all manually
    	LevelFuncs.BeheadLara
    )

   -- last : now we have created the Event Sequence: you must Start it:
    uw_kill_lara_org:Start()
end

LevelFuncs.BeheadLara = function(activator)
	-- kill lara
	LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 14, TEN.Objects.ObjID.LARA_SPEECH_HEAD3, 14)
	LevelFuncs.Engine.Node.ParticleEmitter("LARA_MAIN", 14, 0, TEN.Vec3(0,0,0), 0, 0, TEN.Color(206,43,47), TEN.Color(255,0,0), 2, 15, 512, 10, false, false)
end

-----------------------------
--- PHYSICAL COMBAT BEGIN ---
-----------------------------
local canPulseAgain = true
function Knock_Out_Baddy(baddy_name, moveableSlot)
	-- if enemy is within 128 units of Lara
	local baddyPosition = TEN.Objects.GetMoveableByName(baddy_name):GetPosition()
	local laraPosition = TEN.Objects.GetMoveableByName("LARA_MAIN"):GetPosition()
	local distanceFromLara = math.abs(laraPosition:Distance(baddyPosition))
	local baddyObj = TEN.Objects.GetMoveableByName(baddy_name)
	
	if distanceFromLara <= 256.0 and baddyObj:GetActive() then
		--print("distance : " .. distanceFromLara)
		-- SPRINT SLIDE KNOCKOUT LOGIC
		-- if lara is performing a sprint slide
		if (LevelFuncs.Engine.Node.TestMoveableAnimation("LARA_MAIN", 956) or LevelFuncs.Engine.Node.TestMoveableAnimation("LARA_MAIN", 957)) then
			SetBaddyKnockoutAnim(moveableSlot, baddy_name, 0)
		-- else use kick mechanics
		else
			-- KNEE AND TWIST KICK LOGIC
			print("distance : " .. distanceFromLara)
			if Input.IsKeyPulsed(Input.ActionID.ACTION, 3, 2) and canPulseAgain == true and
			   LevelFuncs.Engine.Node.TestLaraVehicle() == false then -- and lara is not on a vehicle
				canPulseAgain = false
				local attackAnimIDs = {}
				-- Get the random attack anim for Lara
				if Lara:GetHandStatus() == Objects.HandStatus.WEAPON_DRAW or Lara:GetHandStatus() == Objects.HandStatus.WEAPON_READY then
					attackAnimIDs = {976} -- 976, 1005, 1003
				else
					attackAnimIDs = {977, 976, 1005, 1006}
				end
				local randomAttackAnim = attackAnimIDs[math.random(1, #attackAnimIDs)]
				lara : SetAnim(randomAttackAnim)
				LevelFuncs.LaraKickOrganizer(moveableSlot, baddy_name, randomAttackAnim)
			end
		end
	end
end

function SetBaddyKnockoutAnim(moveableSlot, baddy_name, laraAttackAnim)
	-- determine the knock out anim based off the moveable slot
	if moveableSlot == ObjID.SAS_CAIRO then -- SAS

		defenseAnimIDs = {23, 23, 23, 26}
		randomDefenseAnim = defenseAnimIDs[math.random(1, #defenseAnimIDs)]

		-- -- if lara does a low kick or a pistol kick
		-- if laraAttackAnim == 1006 or laraAttackAnim == 1005 then
		-- 	-- do a defense anim
		-- 	LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 26)
		-- else
		-- 	-- do the fall back anim
		-- 	LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 23)
		-- end

		-- do the fall back anim
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 23)

	elseif moveableSlot == ObjID.FLAMETHROWER_BADDY then -- flamethrower
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 24)
	elseif moveableSlot == ObjID.MP_WITH_GUN then -- mp with gun
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 39)
	elseif moveableSlot == ObjID.TRIBESMAN_WITH_AX then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 31)
	elseif moveableSlot == ObjID.DOG then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 25)
	elseif moveableSlot == ObjID.SEAL_MUTANT then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 7)
	elseif moveableSlot == ObjID.BADDY2 then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 71)
	end
end

LevelFuncs.LaraKickOrganizer = function(moveableSlot, baddy_name, laraAttackAnim)
	local attack_org = EventSequence.Create(
						"attack_org", -- sequence's name
						false, -- loop
						false, -- no countdown is displayed
						0.4,
						{LevelFuncs.KickAManBecauseItsWhatHeDeservesBINCH, moveableSlot, baddy_name, laraAttackAnim}, 
						0.9, 
						LevelFuncs.RestoreLaraWeaponStatus,
						0.01,
						LevelFuncs.RestoreLaraAnim
						)
	-- event sequences are inactive to begin with and so need to be started
    attack_org:Start()
end

LevelFuncs.KickAManBecauseItsWhatHeDeservesBINCH = function(moveableSlot, baddy_name, laraAttackAnim)
	SetBaddyKnockoutAnim(moveableSlot, baddy_name, laraAttackAnim)
end

LevelFuncs.RestoreLaraWeaponStatus = function()
	if Lara:GetHandStatus() == Objects.HandStatus.WEAPON_DRAW or Lara:GetHandStatus() == Objects.HandStatus.WEAPON_READY then
		-- init weaponLaraSlot
		local weaponLaraSlot = 0
		if Lara:GetWeaponType() == Objects.WeaponType.PISTOLS then
			weaponLaraSlot = 2
		elseif Lara:GetWeaponType() == Objects.WeaponType.UZIS then
			weaponLaraSlot = 3
		elseif Lara:GetWeaponType() == Objects.WeaponType.SHOTGUN then
			weaponLaraSlot = 4
		elseif Lara:GetWeaponType() == Objects.WeaponType.REVOLVER then
			weaponLaraSlot = 5
		elseif Lara:GetWeaponType() == Objects.WeaponType.CROSSBOW then
			weaponLaraSlot = 6
		elseif Lara:GetWeaponType() == Objects.WeaponType.HK then
			weaponLaraSlot = 7
		elseif Lara:GetWeaponType() == Objects.WeaponType.GRENADE_LAUNCHER then
			weaponLaraSlot = 8
		elseif Lara:GetWeaponType() == Objects.WeaponType.ROCKET_LAUNCHER then
			weaponLaraSlot = 9
		elseif Lara:GetWeaponType() == Objects.WeaponType.HARPOON_GUN then
			weaponLaraSlot = 10
		end
		print("WEAPON ID: "..Lara:GetWeaponType())
		LevelFuncs.Engine.Node.SetLaraWeaponType(Lara:GetWeaponType(), true)
		lara : SetAnim(0, weaponLaraSlot) -- perform anim 4 LARA_PISTOLS is slot 2
	end
end

LevelFuncs.RestoreLaraAnim = function()
	canPulseAgain = true
	if Lara:GetHandStatus() == Objects.HandStatus.WEAPON_DRAW or Lara:GetHandStatus() == Objects.HandStatus.WEAPON_READY then
		lara : SetAnim(103) -- perform anim 4 LARA_PISTOLS is slot 2
	end
end

function Knock_Out_Baddies()
    local moveableSlots = {
        ObjID.SAS_CAIRO, --'SAS CAIRO'
        ObjID.FLAMETHROWER_BADDY, -- FlameThrower Baddy
        ObjID.MP_WITH_GUN, -- 'MP wiht Gun'
        ObjID.BADDY2, -- 'Baddy2'
        ObjID.TRIBESMAN_WITH_AX,   -- scottsman
		ObjID.SEAL_MUTANT
    }
    for index, moveableSlot in pairs(moveableSlots) do
        local moveables = GetMoveablesBySlot(moveableSlot)
        for index, moveable in pairs(moveables) do
        	if moveableSlot == ObjID.SAS_CAIRO then -- if the moveable is a SAS
        		Knock_Out_Baddy(moveable:GetName(), moveableSlot)
            end
            if moveableSlot == ObjID.FLAMETHROWER_BADDY then -- if the moveable is a Flamethrower
            	Knock_Out_Baddy(moveable:GetName(), moveableSlot)
            end
            if moveableSlot == ObjID.MP_WITH_GUN then -- if the moveable is a Flamethrower
            	Knock_Out_Baddy(moveable:GetName(), moveableSlot)
            end
            if moveableSlot == ObjID.TRIBESMAN_WITH_AX then -- if the moveable is a Flamethrower
            	Knock_Out_Baddy(moveable:GetName(), moveableSlot)
            end
            if moveableSlot == ObjID.DOG then -- if the moveable is a Flamethrower
            	Knock_Out_Baddy(moveable:GetName(), moveableSlot)
            end
            if moveableSlot == ObjID.BADDY2 then -- if the moveable is a Flamethrower
            	Knock_Out_Baddy(moveable:GetName(), moveableSlot)
            end
			if moveableSlot == ObjID.SEAL_MUTANT then -- if the moveable is a Flamethrower
            	Knock_Out_Baddy(moveable:GetName(), moveableSlot)
            end
        end
    end
end
---------------------------
--- PHYSICAL COMBAT END ---
---------------------------

--============
-- SUB TITLES
--============
LevelFuncs.clearSprites = function()
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 0)
end
local flags = {TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW}
local stringTest = TEN.Strings.DisplayString("", TEN.Vec2(0,0), 1.0, TEN.Color(255,255,255), false, flags)
local subXpos = 15
local laraStartCutTimeSpan1 = 3.0
local laraStartCut_str = TEN.Strings.DisplayString("Lara: \nSo much for evolution on steroids...", 
											   TEN.Vec2(TEN.Util.PercentToScreen(subXpos, 75)), -- pos
											   0.7, -- scale
											   TEN.Color(12,123,220), -- color
											   false, --translated bool
											   {TEN.Strings.DisplayStringOption.SHADOW} -- flags
											   )
LevelFuncs.laraStartCut = function()
	TEN.Strings.ShowString(laraStartCut_str, -- DisplayString to display
						   laraStartCutTimeSpan1-0.1, -- time span 
						   true -- autoDelete
						   )
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
end
LevelFuncs.laraStartCutSubOrg = function()
	
	local laraStartCutSub_part1 = EventSequence.Create
	(
    	"laraStartCutSub_part1", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.
    	0.5, 
    	LevelFuncs.laraStartCut, 
		3.1,
		LevelFuncs.clearSprites
    )

   -- last : now we have created the Event Sequence: you must Start it:
    laraStartCutSub_part1:Start()
end
											   
local laraBallKickStartTimeSpan1 = 1.5
local laraBallKickStart_str = TEN.Strings.DisplayString("Lara: \nGo On, try it.", 
											   TEN.Vec2(TEN.Util.PercentToScreen(subXpos, 75)), -- pos
											   0.7, -- scale
											   TEN.Color(12,123,220), -- color
											   false, --translated bool
											   {TEN.Strings.DisplayStringOption.SHADOW} -- flags
											   )
LevelFuncs.laraBallKickStartCut_Lara1 = function()
	TEN.Strings.ShowString(laraBallKickStart_str, -- DisplayString to display
						   laraBallKickStartTimeSpan1-0.1, -- time span 
						   true -- autoDelete
						   )
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
end
LevelFuncs.laraBallKickStartCutSubOrg = function()
	
	local laraBallKickStartCutSub = EventSequence.Create
	(
    	"laraBallKickCutSub", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.
    	0.0, 
    	LevelFuncs.laraBallKickStartCut_Lara1,
		1.6,
		LevelFuncs.clearSprites
    )

   -- last : now we have created the Event Sequence: you must Start it:
    laraBallKickStartCutSub:Start()
end

local laraBallKickEndTimeSpan1 = 2.5
local laraBallKickEnd_str = TEN.Strings.DisplayString("Lara: \nHey, I like the look of this!", 
											   TEN.Vec2(TEN.Util.PercentToScreen(subXpos, 75)), -- pos
											   0.7, -- scale
											   TEN.Color(12,123,220), -- color
											   false, --translated bool
											   {TEN.Strings.DisplayStringOption.SHADOW} -- flags
											   )
LevelFuncs.laraBallKickEndCut_Lara1 = function()
	TEN.Strings.ShowString(laraBallKickEnd_str, -- DisplayString to display
						   laraBallKickEndTimeSpan1-0.1, -- time span 
						   true -- autoDelete
						   )
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
end
LevelFuncs.laraBallKickEndCutSubOrg = function()
	
	local laraBallKickEndCutSub = EventSequence.Create
	(
    	"laraBallKickCutSub", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.
    	0.0, 
    	LevelFuncs.laraBallKickEndCut_Lara1,
		2.6,
		LevelFuncs.clearSprites
    )

   -- last : now we have created the Event Sequence: you must Start it:
    laraBallKickEndCutSub:Start()
end


local laraTimeSpan1 = 4.0
local laraTimeSpan2 = 4.0
local laraTimeSpan3 = 6.0
local laraTimeSpan4 = 8.0
local laraTimeSpan5 = 7.0

-- Cutscene Strings (hate that I'm doing this but whatever lmao)
local cut1str = TEN.Strings.DisplayString("Courier: \nWillard! There's a fifth artifact! \nDon't do it!", 
											   TEN.Vec2(TEN.Util.PercentToScreen(subXpos, 75)), -- pos
											   0.7, -- scale
											   TEN.Color(255,255,255), -- color
											   false, --translated bool
											   {TEN.Strings.DisplayStringOption.SHADOW} -- flags
											   )

LevelFuncs.EndingCut_cut1str = function()
	TEN.Strings.ShowString(cut1str, -- DisplayString to display
						   cut1strTimeSpan1-0.5, -- time span 
						   true -- autoDelete
						   )
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 2)
end

local lara1_str = TEN.Strings.DisplayString("Lara: \nWell that's the last of Willard's henchmen...", 
											   TEN.Vec2(TEN.Util.PercentToScreen(subXpos, 75)), -- pos
											   0.7, -- scale
											   TEN.Color(12,123,220), -- color
											   false, --translated bool
											   {TEN.Strings.DisplayStringOption.SHADOW} -- flags
											   )

LevelFuncs.EndingCut_Lara1 = function()
	TEN.Strings.ShowString(lara1_str, -- DisplayString to display
						   laraTimeSpan1-0.1, -- time span 
						   true -- autoDelete
						   )
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
end

local lara2_str = TEN.Strings.DisplayString("Lara: \nHmm... What have we here?", 
										 	   TEN.Vec2(TEN.Util.PercentToScreen(subXpos, 75)), -- pos
									     	   0.7, -- scale
										 	   TEN.Color(12,123,220), -- color
										 	   false, --translated bool
										 	   {TEN.Strings.DisplayStringOption.SHADOW} -- flags
										 	   )


LevelFuncs.EndingCut_Lara2 = function()
	TEN.Strings.ShowString(lara2_str, -- DisplayString to display
						   laraTimeSpan2-0.1, -- time span 
						   true -- autoDelete
						   )
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
end

local lara3_str = TEN.Strings.DisplayString("Lara: \nFifth artifact found STOP \n Delivery confirmed to your Loch Ness Estate STOP", 
											TEN.Vec2(TEN.Util.PercentToScreen(subXpos, 75)), -- pos
											0.7, -- scale
											TEN.Color(12,123,220), -- color
											false, --translated bool
											{TEN.Strings.DisplayStringOption.SHADOW} -- flags
											)

LevelFuncs.EndingCut_Lara3 = function()
	TEN.Strings.ShowString(lara3_str, -- DisplayString to display
						   laraTimeSpan3-0.1, -- time span 
						   true -- autoDelete
						   )
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
end

local lara4_str = TEN.Strings.DisplayString("Lara: \nSomeone else knows about the fifth artifact? \nWow... Willard's perception of good timing really is bad!",
											   TEN.Vec2(TEN.Util.PercentToScreen(subXpos, 73)), -- pos
									     	   0.7, -- scale
										 	   TEN.Color(12,123,220), -- color
										 	   false, --translated bool
										 	   {TEN.Strings.DisplayStringOption.SHADOW} -- flags
										 	   )

LevelFuncs.EndingCut_Lara4 = function()
	TEN.Strings.ShowString(lara4_str, -- DisplayString to display
						   laraTimeSpan4-0.1, -- time span 
						   true -- autoDelete
						   )
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
end

local lara5_str = TEN.Strings.DisplayString("Lara: \nOh well, so it's back to the UK for me! \nWhere's that helicopter of mine?", 
											TEN.Vec2(TEN.Util.PercentToScreen(subXpos, 75)), -- pos
											0.7, -- scale
											TEN.Color(12,123,220), -- color
											false, --translated bool
											{TEN.Strings.DisplayStringOption.SHADOW} -- flags
											)

LevelFuncs.EndingCut_Lara5 = function()
	TEN.Strings.ShowString(lara5_str, -- DisplayString to display
						   laraTimeSpan5-0.1, -- time span 
						   true -- autoDelete
						   )
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
end

LevelFuncs.EndingCutLaraSubOrg = function()
    
    local laraCut = EventSequence.Create
	(
    	"laraCut", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.
    	cut1strTimeSpan1,
    	LevelFuncs.EndingCut_Lara1,
    	laraTimeSpan1-0.1,
		LevelFuncs.clearSprites,
		0.1,
    	LevelFuncs.EndingCut_Lara2,
    	laraTimeSpan2-0.1,
		LevelFuncs.clearSprites,
		0.1,
    	LevelFuncs.EndingCut_Lara3,
    	laraTimeSpan3-0.1,
		LevelFuncs.clearSprites,
		0.1,
    	LevelFuncs.EndingCut_Lara4,
    	laraTimeSpan4-0.1,
		LevelFuncs.clearSprites,
		0.1,
    	LevelFuncs.EndingCut_Lara5,
		laraTimeSpan5-0.1,
		LevelFuncs.clearSprites
    )
    
    -- last : now we have created the Event Sequence: you must Start it:
    laraCut:Start()
    
end

LevelFuncs.EndingCutCourierSubOrg = function()
    
    local EndingCutCourier = EventSequence.Create
	(
    	"EndingCutCourier", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.
    	0.0, 
    	LevelFuncs.EndingCut_cut1str,
		cut1strTimeSpan1-0.4,
		LevelFuncs.clearSprites
    )
    
    -- last : now we have created the Event Sequence: you must Start it:
    EndingCutCourier:Start()
    
end

function drawSubSprite()
	-- -- text background blur (for easier viewing)
	-- if TEN.Strings.IsStringDisplaying(cut1str) or 
	--    TEN.Strings.IsStringDisplaying(laraStartCut_str) or 
	--    TEN.Strings.IsStringDisplaying(laraBallKickStart_str) or TEN.Strings.IsStringDisplaying(laraBallKickEnd_str) or
	--    TEN.Strings.IsStringDisplaying(lara1_str) or TEN.Strings.IsStringDisplaying(lara2_str) or 
	--    TEN.Strings.IsStringDisplaying(lara3_str) or TEN.Strings.IsStringDisplaying(lara4_str) or TEN.Strings.IsStringDisplaying(lara5_str) then
	-- 	LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 82, 0, 100, 27, 0, 0, 2, 9)
	-- end
	
	-- -- Lara view (for easier viewing)
	-- if TEN.Strings.IsStringDisplaying(laraStartCut_str) or 
	--    TEN.Strings.IsStringDisplaying(laraBallKickStart_str) or 
	--    TEN.Strings.IsStringDisplaying(laraBallKickEnd_str) or
	--    TEN.Strings.IsStringDisplaying(lara1_str) or TEN.Strings.IsStringDisplaying(lara2_str) or 
	--    TEN.Strings.IsStringDisplaying(lara3_str) or TEN.Strings.IsStringDisplaying(lara4_str) or TEN.Strings.IsStringDisplaying(lara5_str) then
	-- 	LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 13, TEN.Color(255,255,255), 10, 82, 0, 25, 25, 0, 0, 0, 9)
	-- end
	
	-- -- Courier view (for easier viewing)
	-- if TEN.Strings.IsStringDisplaying(cut1str) then
	-- 	LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 15, TEN.Color(255,255,255), 10, 82, 0, 25, 25, 0, 0, 0, 9)
	-- end

	-- lara subtitle
	if LevelFuncs.Engine.Node.TestMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1) then
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 82, 0, 100, 27, 0, 0, 2, 9)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 13, TEN.Color(255,255,255), 10, 82, 0, 25, 25, 0, 0, 0, 9)
	-- courier subtitle
	elseif LevelFuncs.Engine.Node.TestMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 2) then
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 82, 0, 100, 27, 0, 0, 2, 9)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 15, TEN.Color(255,255,255), 10, 82, 0, 25, 25, 0, 0, 0, 9)
	end

end


LevelFuncs.finalCutsceneLogicOrg = function()
    
    local finalCutsceneLogic = EventSequence.Create
	(
    	"finalCutsceneLogic", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.
    	0.0, 
    	LevelFuncs.HELI_CUT_1_LUA,
    	7.0,
    	LevelFuncs.decapitate_telegram_dude_LUA,
    	9.0,
    	LevelFuncs.HELI_CUT_2_LUA
    )
    -- last : now we have created the Event Sequence: you must Start it:
    finalCutsceneLogic:Start()
end

-- This plays the flyby of the courier and lara
LevelFuncs.HELI_CUT_1_LUA = function(activator)
	LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, "LARA_MAIN", "lara_start_pos_275")
	LevelFuncs.Engine.Node.PlayAudioTrack("013", 0)
	LevelFuncs.Engine.Node.PlayFlyBy(5)
	LevelFuncs.Engine.Node.SetMoveableAnimation("LARA_MAIN", 991)
	LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 13, TEN.Objects.ObjID.PISTOLS_ANIM, 13)
	LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 10, TEN.Objects.ObjID.PISTOLS_ANIM, 10)
end

LevelFuncs.decapitate_telegram_dude_LUA = function(activator)
	LevelFuncs.Engine.Node.ShatterMoveableMesh("animating15_284", 14)
	LevelFuncs.Engine.Node.RunLuaScript(LevelFuncs.RED_GOO_KILL, "")
end

-- teleports lara to the crouching stance
LevelFuncs.HELI_CUT_2_LUA = function(activator)
	LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 10, TEN.Objects.ObjID.LARA_SKIN, 10)
	LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 13, TEN.Objects.ObjID.LARA_SKIN, 13)
end

LevelFuncs.finalCutsceneCamOrg = function()
    
    local finalCutsceneCam = EventSequence.Create
	(
    	"finalCutsceneCam", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.
    	0.0, 
    	LevelFuncs.camCut1,
    	4.0,
    	LevelFuncs.camCut2,
    	5.0,
    	LevelFuncs.camCut3,
    	3.0,
    	LevelFuncs.camCut4,
    	3.5,
    	LevelFuncs.camCut5,
    	4.0,
    	LevelFuncs.camCut6,
    	5.0,
    	LevelFuncs.camCut7,
    	3.0,
    	LevelFuncs.camCut8
    )
    -- last : now we have created the Event Sequence: you must Start it:
    finalCutsceneCam:Start()
end

LevelFuncs.camCut1 = function()
	LevelFuncs.Engine.Node.PlayFlyBy(5)
end

LevelFuncs.camCut2 = function()
	LevelFuncs.Engine.Node.PlayFlyBy(6)
end

LevelFuncs.camCut3 = function()
	LevelFuncs.Engine.Node.PlayFlyBy(9)
	LevelFuncs.Engine.Node.EnableMoveable("examine1_combo1_293", 0)
	LevelFuncs.Engine.Node.EnableMoveable("key_item2_294", 0)
end

LevelFuncs.camCut4 = function()
	LevelFuncs.Engine.Node.PlayFlyBy(10)
	LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, "LARA_MAIN", "lara_start_pos_290")
	LevelFuncs.Engine.Node.SetMoveableAnimation("LARA_MAIN", 990)
end

LevelFuncs.camCut5 = function()
	LevelFuncs.Engine.Node.PlayFlyBy(11)
end

LevelFuncs.camCut6 = function()
	LevelFuncs.Engine.Node.PlayFlyBy(12)
end

LevelFuncs.camCut7 = function()
	LevelFuncs.Engine.Node.PlayFlyBy(14)
	LevelFuncs.Engine.Node.SetMoveableAnimation("LARA_MAIN", 997) -- 996 : hands on hips | 997 : crossed arms
end

LevelFuncs.camCut8 = function()
	LevelFuncs.Engine.Node.PlayFlyBy(13)
	--LevelFuncs.Engine.Node.SetMoveableAnimation("LARA_MAIN", 103)
end

LevelFuncs.CutFadeOut = function()
	LevelFuncs.Engine.Node.UndrawWeapon()
	FadeOut(1.0);
end;

LevelFuncs.CutFadeIn = function()
	FadeIn(1.5);
end;


LevelFuncs.finalCutOrg = function()
    
    local finalCut = EventSequence.Create
	(
    	"finalCut", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.
    	0.0, 
    	--LevelFuncs.CutFadeOut,
    	--1.5, -- I made an enumerator for this so I don't have to change all manually
    	LevelFuncs.performFinalCut
    )
    -- last : now we have created the Event Sequence: you must Start it:
    finalCut:Start()
end


LevelFuncs.performFinalCut = function()
	FadeIn(0.5)
	LevelFuncs.Engine.Node.RunLuaScript(LevelFuncs.finalCutsceneLogicOrg, "")
	LevelFuncs.Engine.Node.RunLuaScript(LevelFuncs.EndingCutLaraSubOrg, "")
	LevelFuncs.Engine.Node.RunLuaScript(LevelFuncs.EndingCutCourierSubOrg, "")
	LevelFuncs.Engine.Node.RunLuaScript(LevelFuncs.finalCutsceneCamOrg, "")
end

local endTimeTaken = tostring(Flow.GetStatistics().timeTaken) -- this will be a toString(Time()) 
local statsHeader_str = TEN.Strings.DisplayString("Escape From Meteorite Cavern", 
											   TEN.Vec2(TEN.Util.PercentToScreen(50, 20)), -- pos
											   1.0, -- scale
											   TEN.Color(255,255,255), -- color
											   false, --translated bool
											   {TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW} -- flags
											   )
											   
LevelFuncs.DisplayStats = function()
	LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, "LARA_MAIN", "END_LSP")
	LevelFuncs.Engine.Node.PlayFlyBy(16)
	LevelFuncs.Engine.Node.PlayAudioTrack("001", 1)
	LevelFuncs.Engine.Node.SetMoveableAnimation("LARA_MAIN", 975)
	
	TEN.Strings.ShowString(statsHeader_str)
	local leftJustify = 30
	local rightJustify = 70
	local yStatsPos = 30
	-- time taken
	local timeTaken = tostring(Flow.GetStatistics().timeTaken)
	LevelFuncs.Engine.Node.DrawText("Time Taken: ", leftJustify, yStatsPos, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(endTimeTaken, rightJustify, yStatsPos, 2, 1, TEN.Color(255,255,255), 0.8)
	-- secrets found
	local secretsFound = ""..Flow.GetStatistics().secrets
	LevelFuncs.Engine.Node.DrawText("Secrets Found: ", leftJustify, yStatsPos+5, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(secretsFound, rightJustify, yStatsPos+5, 2, 1, TEN.Color(255,255,255), 0.8)
	-- Pickups
	local pickupsFound = ""..Flow.GetStatistics().pickups
	LevelFuncs.Engine.Node.DrawText("Pickups: ", leftJustify, yStatsPos+10, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(pickupsFound, rightJustify, yStatsPos+10, 2, 1, TEN.Color(255,255,255), 0.8)
	-- Kills
	local killsStats = ""..Flow.GetStatistics().kills
	LevelFuncs.Engine.Node.DrawText("Kills: ", leftJustify, yStatsPos+15, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(killsStats, rightJustify, yStatsPos+15, 2, 1, TEN.Color(255,255,255), 0.8)
	-- Ammo Used/Hits
	local ammoUsedHits = ""..Flow.GetStatistics().ammoUsed .. "/" .. Flow.GetStatistics().ammoHits
	LevelFuncs.Engine.Node.DrawText("Ammo Used/Hits: ", leftJustify, yStatsPos+20, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(ammoUsedHits, rightJustify, yStatsPos+20, 2, 1, TEN.Color(255,255,255), 0.8)
	-- Medipacks Used
	local healthPacksUsed = ""..Flow.GetStatistics().healthPacksUsed
	LevelFuncs.Engine.Node.DrawText("Medi Packs Used: ", leftJustify, yStatsPos+25, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(healthPacksUsed, rightJustify, yStatsPos+25, 2, 1, TEN.Color(255,255,255), 0.8)
	-- Distance Travelled in km
	-- convert to km : 1 m = 240 units -> 1km - 0.240 units
	local distanceTravelled = "" .. string.format("%.2f", (Flow.GetStatistics().distanceTraveled / 240) ) .. "m"
	LevelFuncs.Engine.Node.DrawText("Distance Travelled: ", leftJustify, yStatsPos+30, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(distanceTravelled, rightJustify, yStatsPos+30, 2, 1, TEN.Color(255,255,255), 0.8)
	
	LevelFuncs.Engine.Node.DrawText("(Press ACTION to continue)", 50, yStatsPos+40, 1, 3, TEN.Color(255,255,255), 0.8)
end
							   
function showStatsSpritesBackGround()
	-- text background blur (for easier viewing)
	if TEN.Strings.IsStringDisplaying(statsHeader_str) then
		--LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 50, 0, 100, 100, 0, 0, 2, 9)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 48, 0, 60, 80, 0, 0, 2, 9)
	end
end

LevelFuncs.GetEndLevelTime = function()
	endTimeTaken = tostring(Flow.GetStatistics().timeTaken)
end