-- FILE: \Shakespeare_Cliff.lua
---@diagnostic disable: duplicate-set-field
--package.preload["MISC_LOOP_FUNCTIONS"] = function() require ("MISC_LOOP_FUNCTIONS") end require ("Levels.MISC_LOOP_FUNCTIONS")
require("Levels.MISC_LOOP_FUNCTIONS")
local maxLaraAnim = 985

LevelFuncs.OnLoad = function() end
LevelFuncs.OnSave = function() end
LevelFuncs.OnStart = function()
	LevelFuncs.BlinkOrganizer()
end
LevelFuncs.OnControlPhase = function()
	Knock_Out_Baddies()
	TrainKillCheck()
	showStatsSpritesBackGround()
end
LevelFuncs.OnEnd = function() end

LevelFuncs.CutFadeOut = function()
	FadeOut(1.0); 
end;

LevelFuncs.CutFadeIn = function()
	FadeIn(1.5);
end;

local EventSequence = require("Engine.EventSequence")


----------------
--- BLINKING ---
----------------
LevelFuncs.BlinkOrganizer = function ()
	local lara_blink_org = EventSequence.Create(
						"lara_blink_org", -- sequence's name
						true, -- loop
						false, -- no countdown is displayed
						0,
						LevelFuncs.BlinkOff, 
						3, 
						LevelFuncs.BlinkOn,
						1,
						LevelFuncs.BlinkOff
						)
	-- event sequences are inactive to begin with and so need to be started
    lara_blink_org:Start()
end

LevelFuncs.BlinkOn = function ()
	LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 14, TEN.Objects.ObjID.LARA_SPEECH_HEAD3, 14)
	print("BLINKING ON")
end
LevelFuncs.BlinkOff = function ()
	LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 14, TEN.Objects.ObjID.LARA_SKIN, 14)
	print("BLINKING OFF")
end

--=====================
-- FMV START
--=====================
LevelFuncs.FMVStartOrg = function()
	local FMVStartSeq = EventSequence.Create
	(
    	"FMVStartSeq", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.
    	0.0, -- I made an enumerator for this so I don't have to change all manually
    	LevelFuncs.PlayIntroFMV,
    	0.1,
    	LevelFuncs.PlayIntroFlyby
    )

   -- last : now we have created the Event Sequence: you must Start it:
    FMVStartSeq:Start()
end

LevelFuncs.PlayIntroFMV = function()
	View.PlayVideo("Previously_On_With_Home.mp4")
end
LevelFuncs.PlayIntroFlyby = function()
	LevelFuncs.Engine.Node.SetMoveableAnimation("LARA_MAIN", 981)
	LevelFuncs.Engine.Node.PlayFlyBy(5)
	LevelFuncs.Engine.Node.PlayAudioTrack("002", 0)
end
--=====================
-- WRECK INTRO CUTSCENE START
--=====================
LevelFuncs.WreckCutsceneIntroOrg = function()
	local WreckCutsceneOrg = EventSequence.Create
	(
    	"WreckCutsceneOrg", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.
    	0.0, -- I made an enumerator for this so I don't have to change all manually
    	LevelFuncs.WreckCutsceneIntroFlyby1,
    	3,
    	LevelFuncs.WreckCutsceneIntroFlyby2,
		3,
		LevelFuncs.WreckCutsceneIntroFlyby3,
		3,
		LevelFuncs.WreckCutsceneIntroFlyby4,
		3,
		LevelFuncs.WreckCutsceneIntroFlyby5,
		3,
		LevelFuncs.WreckCutsceneIntroFlyby6
    )

   -- last : now we have created the Event Sequence: you must Start it:
    WreckCutsceneOrg:Start()
end

LevelFuncs.WreckCutsceneIntroFlyby1 = function()
	LevelFuncs.Engine.Node.PlayFlyBy(14)
	LevelFuncs.Engine.Node.PlaySoundAroundMoveable("LARA_MAIN", 238)
	if Sound.IsAudioTrackPlaying("082") or Sound.IsAudioTrackPlaying("081") then
		Sound.StopAudioTrack(SoundTrackType.ONESHOT)
	end
	Sound.PlayAudioTrack("014", SoundTrackType.ONESHOT)
end

LevelFuncs.WreckCutsceneIntroFlyby2 = function()
	LevelFuncs.Engine.Node.PlayFlyBy(15)
end

LevelFuncs.WreckCutsceneIntroFlyby3 = function()
	LevelFuncs.Engine.Node.PlayFlyBy(16)
end

LevelFuncs.WreckCutsceneIntroFlyby4 = function()
	LevelFuncs.Engine.Node.PlayFlyBy(17)
end

LevelFuncs.WreckCutsceneIntroFlyby5 = function()
	LevelFuncs.Engine.Node.PlayFlyBy(18)
end

LevelFuncs.WreckCutsceneIntroFlyby6 = function()
	LevelFuncs.Engine.Node.PlayFlyBy(19)
end

LevelFuncs.UseValveRoom93 = function()
	-- if lara is idle (anim 103)
	if lara : GetAnim() == 103 or 
	   lara:GetAnim() == 984 or lara:GetAnim() == 985 or
	   (lara:GetAnim() == 1025 and lara:GetAnim() == 1029) then
		-- if the player presses ACTION
		if Input.IsKeyPulsed(Input.ActionID.ACTION, 2, 2) then
			lara : SetAnim(470)
			LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, "LARA_MAIN", "lara_start_pos_909")
			local valveObj = TEN.Objects.GetMoveableByName("airlock_switch_907")
			valveObj:SetAnim(1)
			LevelFuncs.Engine.Node.EnableMoveable("door_type4_899", 0)
		end
	end
	if lara:GetAnim() == 470 then
		LevelFuncs.Engine.Node.ActivateCamera("camera_906", "door_type4_899")
	end
	if (LevelFuncs.Engine.Node.TestMoveableAnimation("door_type4_899", 2)) then
		LevelFuncs.Engine.Node.DisableVolume("volume_908")
	end
end
--=====================
-- WRECK INTRO CUTSCENE END
--=====================
--=====================
-- PIPE PUZZLE 1 START
--=====================
LevelFuncs.PipePuzzle1Hint = function()
	-- if lara is idle (anim 103)
	if lara : GetAnim() == 103 or 
	   lara:GetAnim() == 984 or lara:GetAnim() == 985 or
	   (lara:GetAnim() == 1025 and lara:GetAnim() == 1029) then
		-- print a hint
		LevelFuncs.Engine.Node.DrawText("Press ACTION to use HINT CRYSTAL", 50, 85, 1, 3, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 87, 0, 50, 9, 0, 0, 2, 9)
	elseif lara : GetAnim() == 999 then
		LevelFuncs.Engine.Node.DrawText("(Press ACTION to exit)", 50, 85, 1, 3, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 87, 0, 40, 9, 0, 0, 2, 9)
	end
	
	-- if lara is idle (anim 103)
	if lara : GetAnim() == 103 or 
	   lara:GetAnim() == 984 or lara:GetAnim() == 985 or
	   (lara:GetAnim() == 1025 and lara:GetAnim() == 1029) then
		-- if the player presses ACTION
		if Input.IsKeyPulsed(Input.ActionID.ACTION, 2, 2) then
			-- perform animation 998 (crystal start)
			lara : SetAnim(998)
		end
	end

	-- if lara is crystal idle (anim 999)
	if lara : GetAnim() == 999 then 
	
		-- << HINT LOGIC BEGIN >>
		-- play cam hint
		LevelFuncs.Engine.Node.ActivateCamera("camera_806", "camera_target_805")

		LevelFuncs.Engine.Node.DrawText("It looks like a water\ntank connected to a \nseries of disconnected\n pipes...", 35, 40, 1, 1, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 35, 49, 0, 30, 30, 0, 0, 2, 9)
		LevelFuncs.Engine.Node.DrawText("Maybe there's\na way to connect\nall the pipes\nto prevent any leaks?", 65, 40, 1, 1, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 65, 49, 0, 30, 30, 0, 0, 2, 9)
		-- << HINT LOGIC END >>
		
		-- if the player presses ACTION
		if Input.IsKeyPulsed(Input.ActionID.ACTION, 2, 2) then
			-- perform animation 998 (crystal start)
			lara : SetAnim(1000)
		end
	end
end

function PipePuzzle1Logic(lsp_name, valve_name, pipe_name, cam_name)
	-- PROMPT
	if lara : GetAnim() == 1019 then

		LevelFuncs.Engine.Node.DrawText("Turn Valve to Rotate Pipe?", 50, 5, 1, 1, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 7, 0, 40, 9, 0, 0, 2, 9)

		LevelFuncs.Engine.Node.DrawText("<", 35, 45, 1, 3, TEN.Color(255,255,255), 2, 1)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 35, 52, 0, 10, 10, 0, 0, 2, 9)

		LevelFuncs.Engine.Node.DrawText(">", 65, 45, 1, 3, TEN.Color(255,255,255), 2, 1)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 65, 52, 0, 10, 10, 0, 0, 2, 9)

		LevelFuncs.Engine.Node.DrawText("(Press ACTION to exit)", 50, 85, 1, 3, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 87, 0, 40, 9, 0, 0, 2, 9)
	end

	local valveObj = TEN.Objects.GetMoveableByName(valve_name)

	-- use Pipe
	if lara : GetAnim() == 103 or 
	   lara:GetAnim() == 984 or lara:GetAnim() == 985 or
	   (lara:GetAnim() == 1025 and lara:GetAnim() == 1029) then
		if Input.IsKeyPulsed(Input.ActionID.ACTION, 2, 2) then
			lara:SetAnim(1018)
			LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, "LARA_MAIN", lsp_name)
		end
	end

	-- revert to idle 
	if lara : GetAnim() == 1019 then
		-- exit
		if Input.IsKeyPulsed(Input.ActionID.ACTION, 2, 2) then
			print("Exiting valve!")
			lara:SetAnim(1022)
		-- turn left (counter clockwise)
		elseif Input.IsKeyPulsed(Input.ActionID.LEFT, 2, 2) then
			print("Turning valve left!")
			lara:SetAnim(1020)
			valveObj:SetAnim(1)
			LevelFuncs.Engine.Node.ChangeMoveableRotationOverTimespan(pipe_name, 
															  -90,   -- rotation to change by
															  true, -- relative angle
															  5,    -- time in seconds
															  true) -- smooth motion
		-- turn right (clockwise)
		elseif Input.IsKeyPulsed(Input.ActionID.RIGHT, 2, 2) then
			print("Turning valve right!")
			lara:SetAnim(1021)
			valveObj:SetAnim(2)
			LevelFuncs.Engine.Node.ChangeMoveableRotationOverTimespan(pipe_name, 
															  90,   -- rotation to change by
															  true, -- relative angle
															  5,    -- time in seconds
															  true) -- smooth motion
		end
	end

	if lara:GetAnim() == 1020 or lara:GetAnim() == 1021 then
		LevelFuncs.Engine.Node.ActivateCamera(cam_name, pipe_name)
	end
end

LevelFuncs.PIPE_PUZZLE_1_A = function()
	PipePuzzle1Logic("lara_start_pos_770", -- lsp_name
					 "animating37_764", -- valve_name
					 "animating38_760", -- pipe_name
					 "camera_772" -- cam_name
					 )
end

LevelFuncs.PIPE_PUZZLE_1_B = function()
	PipePuzzle1Logic("lara_start_pos_776", -- lsp_name
					 "animating37_743", -- valve_name
					 "animating38_741", -- pipe_name
					 "camera_781" -- cam_name
					 )
end

LevelFuncs.PIPE_PUZZLE_1_C = function()
	PipePuzzle1Logic("lara_start_pos_777", -- lsp_name
					 "animating37_740", -- valve_name
					 "animating39_746", -- pipe_name
					 "camera_780" -- cam_name
					 )
end

LevelFuncs.PIPE_PUZZLE_1_D = function()
	PipePuzzle1Logic("lara_start_pos_778", -- lsp_name
					 "animating37_738", -- valve_name
					 "animating39_771", -- pipe_name
					 "camera_779" -- cam_name 
					 )
end

LevelFuncs.PIPE_PUZZLE_1_LOGIC_CHECK = function()
	
	local PipePuzzle1LogicOrg = EventSequence.Create
	(
    	"PipePuzzle1LogicOrg", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.
    	0.0, -- I made an enumerator for this so I don't have to change all manually
    	LevelFuncs.PipePuzzle1Flyby1,
    	2,
    	LevelFuncs.PipePuzzle1Check
    )

   -- last : now we have created the Event Sequence: you must Start it:
    PipePuzzle1LogicOrg:Start()
end

LevelFuncs.StopAudioONESHOT = function()
	Sound.StopAudioTrack(SoundTrackType.ONESHOT)
end

LevelFuncs.PipePuzzle1Flyby1 = function()
	LevelFuncs.Engine.Node.PlayFlyBy(12)
	LevelFuncs.Engine.Node.PlaySoundAroundMoveable("LARA_MAIN", 238)
	if Sound.IsAudioTrackPlaying("011") or Sound.IsAudioTrackPlaying("034") then
		Sound.StopAudioTrack(SoundTrackType.ONESHOT)
	end
	Sound.PlayAudioTrack("011", SoundTrackType.ONESHOT)
end

LevelFuncs.PipePuzzle1Check = function()
	local pipeAObj = TEN.Objects.GetMoveableByName("animating38_760")
	local pipeBObj = TEN.Objects.GetMoveableByName("animating38_741")
	local pipeCObj = TEN.Objects.GetMoveableByName("animating39_746")
	local pipeDObj = TEN.Objects.GetMoveableByName("animating39_771")
	print("pipeAObj: " .. pipeAObj:GetRotation().y)
	print("pipeBObj: " .. pipeBObj:GetRotation().y)
	print("pipeCObj: " .. pipeCObj:GetRotation().y)
	print("pipeDObj: " .. pipeDObj:GetRotation().y)
	-- rotation 
	-- 1 : 270
	-- 2 : 0.0
	-- 3 : 90
	-- 4 : 180
	-- correct logic
	if  (pipeAObj:GetRotation().y == 0.0 or pipeAObj:GetRotation().y == 180.0) and
		(pipeBObj:GetRotation().y == 0.0 or pipeBObj:GetRotation().y == 180.0) and
		(pipeCObj:GetRotation().y == 90.0) and
		(pipeDObj:GetRotation().y == 180.0) then
		-- enable waterfall
		LevelFuncs.Engine.Node.EnableMoveable("waterfall_emitter_716", 0)
		LevelFuncs.Engine.Node.EnableMoveable("waterfall_emitter_797", 0)
		-- disable fire
		LevelFuncs.Engine.Node.DisableMoveable("flame_emitter_720")
		LevelFuncs.Engine.Node.DisableMoveable("flame_emitter_718")
		LevelFuncs.Engine.Node.DisableMoveable("flame_emitter_83")

		LevelFuncs.Engine.Node.DisableMoveable("flame_emitter_719")
		LevelFuncs.Engine.Node.DisableMoveable("flame_emitter_717")
		LevelFuncs.Engine.Node.DisableMoveable("flame_emitter_84")

		LevelFuncs.Engine.Node.PlayFlyBy(11)
	-- else check for leaks
	else
		local time_to_flood = 7
		LevelFuncs.Engine.Node.PlayFlyBy(13)
		-- pipe A leak logic
		if (pipeAObj:GetRotation().y == 270.0 or pipeAObj:GetRotation().y == 90.0) then
			-- enable waterfall
			LevelFuncs.Engine.Node.EnableMoveable("waterfall_emitter_766", time_to_flood)
		end
		-- pipe B leak logic
		if (pipeBObj:GetRotation().y == 270.0 or pipeBObj:GetRotation().y == 90.0) then
			-- enable waterfall
			LevelFuncs.Engine.Node.EnableMoveable("waterfall_emitter_767", time_to_flood)
		end
		-- pipe C leak logic
		if (pipeCObj:GetRotation().y == 270.0 or pipeCObj:GetRotation().y == 0.0) then
			-- enable waterfall
			LevelFuncs.Engine.Node.EnableMoveable("waterfall_emitter_768", time_to_flood)
		end
		if (pipeCObj:GetRotation().y == 180.0) then
			-- enable waterfall
			LevelFuncs.Engine.Node.EnableMoveable("waterfall_emitter_769", time_to_flood)
		end
		-- pipe D leak logic
		if (pipeDObj:GetRotation().y == 270.0 or pipeDObj:GetRotation().y == 0.0) and
		   (pipeAObj:GetRotation().y == 0.0 or pipeAObj:GetRotation().y == 180.0) then
			-- enable waterfall
			LevelFuncs.Engine.Node.EnableMoveable("waterfall_emitter_770", time_to_flood)
		end
		if (pipeDObj:GetRotation().y == 90.0) and
		   (pipeAObj:GetRotation().y == 0.0 or pipeAObj:GetRotation().y == 180.0) then
			-- enable waterfall
			LevelFuncs.Engine.Node.EnableMoveable("waterfall_emitter_771", time_to_flood)
		end
	end
end

--===================
-- PIPE PUZZLE 1 END
--===================
LevelFuncs.ElectrocuteLaraSwitch = function()
	if lara:GetAnim() == 195 and lara:GetFrame() == 30 then
		LevelFuncs.Engine.Node.RunLuaScript(LevelFuncs.BloodifyLara, "")
		LevelFuncs.Engine.Node.PlaySoundAroundMoveable("LARA_MAIN", 30)
		LevelFuncs.Engine.Node.PlaySoundAroundMoveable("LARA_MAIN", 145)
		LevelFuncs.Engine.Node.PlaySoundAroundMoveable("LARA_MAIN", 128)
		LevelFuncs.Engine.Node.SetEffectForSpecifiedMoveables(TEN.Objects.ObjID.LARA, "LARA_MAIN", 2)
		-- LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, "LARA_MAIN", "lara_start_pos_252")
		-- LevelFuncs.Engine.Node.SetMoveableAnimation("LARA_MAIN", 978)
		LevelFuncs.Engine.Node.SetMoveableAnimation("LARA_MAIN", 1030)
		LevelFuncs.Engine.Node.SetMoveableAnimation("switch_type1_247", 0)
		LevelFuncs.Engine.Node.ActivateCamera("camera_250", "LARA_MAIN")
		LevelFuncs.Engine.Node.ParticleEmitter("LARA_MAIN", 0, 0, TEN.Vec3(2,3,4), 0, 0, TEN.Color(0,255,255), TEN.Color(128,255,255), 2, 64, 1024, 6, false, false)
		LevelFuncs.Engine.Node.DisableVolume("volume_877")
	end
end



--===========================================
-- Throw Rope at Pit Entrance Sequence START
--===========================================
LevelFuncs.ThrowRopeAtPitHallCheck = function()
	LevelFuncs.Engine.Node.ActivateCamera("camera_448", "camera_target_449")
	LevelFuncs.Engine.Node.DrawText("If I had some rope,\nI reckon I could throw it\nat that hook...", 50, 5, 1, 1, TEN.Color(255,255,255), 0.7, 1)
	if (LevelFuncs.Engine.Node.KeyIsHeld(11)) then
		if (LevelFuncs.Engine.Node.TestInventoryItem(TEN.Objects.ObjID.PUZZLE_ITEM16)) then
			LevelFuncs.Engine.Node.PlayFlyBy(3)
			LevelFuncs.Engine.Node.RunLuaScript(LevelFuncs.ThrowRopeAtPitHallSeq, "")
			LevelFuncs.Engine.Node.DisableVolume("volume_441")
		else
			LevelFuncs.Engine.Node.DrawText("MISSING ROPE!", 50, 70, 1, 3, TEN.Color(255,0,0), 0.7, 1)
		end
	end
	LevelFuncs.Engine.Node.DrawText("Press ACTION to THROW", 50, 90, 1, 3, TEN.Color(255,255,255), 0.7, 1)
end


LevelFuncs.LaraThrowRopeAnim = function()
	LevelFuncs.Engine.Node.UndrawWeapon()
	LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, "LARA_MAIN", "lara_start_pos_440")
	LevelFuncs.Engine.Node.SetMoveableAnimation("LARA_MAIN", 979)
end

LevelFuncs.TriggerRope_439 = function()
	LevelFuncs.Engine.Node.EnableMoveable("rope_439", 0)
end

LevelFuncs.ThrowRopeAtPitHallSeq = function()
	local ThrowRopeAtPitHallSequence = EventSequence.Create
	(
    	"Throw_Rope_At_Pit_Hall", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.

    	0.0, -- I made an enumerator for this so I don't have to change all manually
    	LevelFuncs.LaraThrowRopeAnim,
    	5.0,
    	LevelFuncs.TriggerRope_439
    )

   -- last : now we have created the Event Sequence: you must Start it:
    ThrowRopeAtPitHallSequence:Start()
end
--===========================================
-- Throw Rope at Pit Entrance Sequence END 
--===========================================

--===========================================
-- Throw Rope at Pit Entrance Sequence START
--===========================================
LevelFuncs.TriggerRope_526 = function()
	LevelFuncs.Engine.Node.EnableMoveable("rope_526", 0)
end

LevelFuncs.LaraThrowRopeAnim2 = function()
	LevelFuncs.Engine.Node.UndrawWeapon()
	LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, "LARA_MAIN", "lara_start_pos_528")
	LevelFuncs.Engine.Node.SetMoveableAnimation("LARA_MAIN", 979)
end

LevelFuncs.ThrowRopeAtSmallHallSeq = function()
	local ThrowRopeAtPitHallSequence = EventSequence.Create
	(
    	"Throw_Rope_At_Small_Hall", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.

    	0.0, -- I made an enumerator for this so I don't have to change all manually
    	LevelFuncs.LaraThrowRopeAnim2,
    	5.0,
    	LevelFuncs.TriggerRope_526
    )

   -- last : now we have created the Event Sequence: you must Start it:
    ThrowRopeAtPitHallSequence:Start()
end
--===========================================
-- Throw Rope at Pit Entrance Sequence END 
--===========================================

LevelFuncs.BloodifyLara = function()
	for i = 0,14,1
	do
		LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", i, TEN.Objects.ObjID.LARA_SPEECH_HEAD1, i)
	end
end

LevelFuncs.TrainKillLara = function(obj1, obj2)
	print(obj1:GetName() .. " collided with " .. obj2:GetName())
	if obj2:GetObjectID() == ObjID.LARA and lara:GetHP() <= 1 then
		print("Bloodify Lara!")
		LevelFuncs.Engine.Node.RunLuaScript(LevelFuncs.BloodifyLara, "")
	end

	-- if Lara is on a vehicle (if she's on the quad bike)
	if obj2:GetObjectID() == ObjID.QUAD then
		print("Exploding Quad!")
    	LevelFuncs.Engine.Node.ParticleEmitter("LARA_MAIN", 0, 0, TEN.Vec3(0,0,0), 0, 0, TEN.Color(165,18,18), TEN.Color(85,0,0), 2, 64, 1024, 1, false, false)
		LevelFuncs.Engine.Node.ShatterMoveable("LARA_MAIN")
		LevelFuncs.Engine.Node.PlaySoundAroundMoveable("LARA_MAIN", 145)
		LevelFuncs.Engine.Node.SetMoveableHitPoints(1, 0, "LARA_MAIN")
		LevelFuncs.Engine.Node.ExplodeMoveable("quad_253")
	end
end

function TrainKillCheck()
	local train_slot = 445
	-- local train_slot = 1239
	local moveables = Objects.GetMoveablesBySlot(train_slot)
	for index, moveable in pairs(moveables) do
		if moveable:GetActive() == true then
			moveable:SetOnCollidedWithObject(LevelFuncs.TrainKillLara)
		end
	end
end

LevelFuncs.AddSecretID = function(secretID)
	Flow.AddSecret(tonumber(secretID))
	LevelFuncs.Engine.Node.PlayAudioTrack("005", 0)
end

LevelFuncs.AddSecret5Org = function()
	local Secret5Org = EventSequence.Create
	(
    	"Secret5Org", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.

    	0.0, -- I made an enumerator for this so I don't have to change all manually
    	LevelFuncs.AddSecret5,
    	6.0,
    	LevelFuncs.PlayPuzzleAmbience
    )

   -- last : now we have created the Event Sequence: you must Start it:
    Secret5Org:Start()
end

LevelFuncs.AddSecret5 = function()
	LevelFuncs.Engine.Node.RunLuaScript(LevelFuncs.AddSecretID, "5")
	LevelFuncs.Engine.Node.PlayAudioTrack("005", 0)
end

LevelFuncs.PlayPuzzleAmbience = function()
	if Sound.IsAudioTrackPlaying("005") then
		Sound.StopAudioTrack(SoundTrackType.ONESHOT)
	end
	LevelFuncs.Engine.Node.PlayAudioTrack("002", 0)
end

-----------------------------
--- PHYSICAL COMBAT BEGIN ---
-----------------------------
local canPulseAgain = true
function Knock_Out_Baddy(baddy_name, moveableSlot)
	-- if enemy is within 128 units of Lara
	local baddyPosition = TEN.Objects.GetMoveableByName(baddy_name):GetPosition()
	local laraPosition = TEN.Objects.GetMoveableByName("LARA_MAIN"):GetPosition()
	local distanceFromLara = math.abs(laraPosition:Distance(baddyPosition))
	local baddyObj = TEN.Objects.GetMoveableByName(baddy_name)
	
	if distanceFromLara <= 256.0 and baddyObj:GetActive() then
		--print("distance : " .. distanceFromLara)
		-- SPRINT SLIDE KNOCKOUT LOGIC
		-- if lara is performing a sprint slide
		if (LevelFuncs.Engine.Node.TestMoveableAnimation("LARA_MAIN", 956) or LevelFuncs.Engine.Node.TestMoveableAnimation("LARA_MAIN", 957)) then
			SetBaddyKnockoutAnim(moveableSlot, baddy_name, 0)
		-- else use kick mechanics
		else
			-- KNEE AND TWIST KICK LOGIC
			print("distance : " .. distanceFromLara)
			if Input.IsKeyPulsed(Input.ActionID.ACTION, 3, 2) and canPulseAgain == true and
			   LevelFuncs.Engine.Node.TestLaraVehicle() == false then -- and lara is not on a vehicle
				canPulseAgain = false
				local attackAnimIDs = {}
				-- Get the random attack anim for Lara
				if Lara:GetHandStatus() == Objects.HandStatus.WEAPON_DRAW or Lara:GetHandStatus() == Objects.HandStatus.WEAPON_READY then
					attackAnimIDs = {976} -- 976, 1005, 1003
				else
					attackAnimIDs = {977, 976, 1005, 1006}
				end
				local randomAttackAnim = attackAnimIDs[math.random(1, #attackAnimIDs)]
				lara : SetAnim(randomAttackAnim)
				LevelFuncs.LaraKickOrganizer(moveableSlot, baddy_name, randomAttackAnim)
			end
		end
	end
end

function SetBaddyKnockoutAnim(moveableSlot, baddy_name, laraAttackAnim)
	-- determine the knock out anim based off the moveable slot
	if moveableSlot == ObjID.SAS_CAIRO then -- SAS

		defenseAnimIDs = {23, 23, 23, 26}
		randomDefenseAnim = defenseAnimIDs[math.random(1, #defenseAnimIDs)]

		-- if lara does a low kick or a pistol kick
		if laraAttackAnim == 1006 or laraAttackAnim == 1005 then
			-- do a defense anim
			LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 26)
		else
			-- do the fall back anim
			LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 23)
		end

	elseif moveableSlot == ObjID.FLAMETHROWER_BADDY then -- flamethrower
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 24)
	elseif moveableSlot == ObjID.MP_WITH_GUN then -- mp with gun
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 39)
	elseif moveableSlot == ObjID.TRIBESMAN_WITH_AX then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 31)
	elseif moveableSlot == ObjID.DOG then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 25)
	elseif moveableSlot == ObjID.BADDY2 then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 71)
	end
end

LevelFuncs.LaraKickOrganizer = function(moveableSlot, baddy_name, laraAttackAnim)
	local attack_org = EventSequence.Create(
						"attack_org", -- sequence's name
						false, -- loop
						false, -- no countdown is displayed
						0.4,
						{LevelFuncs.KickAManBecauseItsWhatHeDeservesBINCH, moveableSlot, baddy_name, laraAttackAnim}, 
						0.9, 
						LevelFuncs.RestoreLaraWeaponStatus,
						0.01,
						LevelFuncs.RestoreLaraAnim
						)
	-- event sequences are inactive to begin with and so need to be started
    attack_org:Start()
end

LevelFuncs.KickAManBecauseItsWhatHeDeservesBINCH = function(moveableSlot, baddy_name, laraAttackAnim)
	SetBaddyKnockoutAnim(moveableSlot, baddy_name, laraAttackAnim)
end

LevelFuncs.RestoreLaraWeaponStatus = function()
	if Lara:GetHandStatus() == Objects.HandStatus.WEAPON_DRAW or Lara:GetHandStatus() == Objects.HandStatus.WEAPON_READY then
		-- init weaponLaraSlot
		local weaponLaraSlot = 0
		if Lara:GetWeaponType() == Objects.WeaponType.PISTOLS then
			weaponLaraSlot = 2
		elseif Lara:GetWeaponType() == Objects.WeaponType.UZIS then
			weaponLaraSlot = 3
		elseif Lara:GetWeaponType() == Objects.WeaponType.SHOTGUN then
			weaponLaraSlot = 4
		elseif Lara:GetWeaponType() == Objects.WeaponType.REVOLVER then
			weaponLaraSlot = 5
		elseif Lara:GetWeaponType() == Objects.WeaponType.CROSSBOW then
			weaponLaraSlot = 6
		elseif Lara:GetWeaponType() == Objects.WeaponType.HK then
			weaponLaraSlot = 7
		elseif Lara:GetWeaponType() == Objects.WeaponType.GRENADE_LAUNCHER then
			weaponLaraSlot = 8
		elseif Lara:GetWeaponType() == Objects.WeaponType.ROCKET_LAUNCHER then
			weaponLaraSlot = 9
		elseif Lara:GetWeaponType() == Objects.WeaponType.HARPOON_GUN then
			weaponLaraSlot = 10
		end
		print("WEAPON ID: "..Lara:GetWeaponType())
		LevelFuncs.Engine.Node.SetLaraWeaponType(Lara:GetWeaponType(), true)
		lara : SetAnim(0, weaponLaraSlot) -- perform anim 4 LARA_PISTOLS is slot 2
	end
end

LevelFuncs.RestoreLaraAnim = function()
	canPulseAgain = true
	if Lara:GetHandStatus() == Objects.HandStatus.WEAPON_DRAW or Lara:GetHandStatus() == Objects.HandStatus.WEAPON_READY then
		lara : SetAnim(103) -- perform anim 4 LARA_PISTOLS is slot 2
	end
end

function Knock_Out_Baddies()
    local moveableSlots = {
        ObjID.SAS_CAIRO, --'SAS CAIRO'
        ObjID.FLAMETHROWER_BADDY, -- FlameThrower Baddy
        ObjID.MP_WITH_GUN, -- 'MP wiht Gun'
        ObjID.BADDY2, -- 'Baddy2'
        ObjID.TRIBESMAN_WITH_AX  -- scottsman
    }
    for index, moveableSlot in pairs(moveableSlots) do
        local moveables = GetMoveablesBySlot(moveableSlot)
        for index, moveable in pairs(moveables) do
        	if moveableSlot == ObjID.SAS_CAIRO then -- if the moveable is a SAS
        		Knock_Out_Baddy(moveable:GetName(), moveableSlot)
            end
            if moveableSlot == ObjID.FLAMETHROWER_BADDY then -- if the moveable is a Flamethrower
            	Knock_Out_Baddy(moveable:GetName(), moveableSlot)
            end
            if moveableSlot == ObjID.MP_WITH_GUN then -- if the moveable is a Flamethrower
            	Knock_Out_Baddy(moveable:GetName(), moveableSlot)
            end
            if moveableSlot == ObjID.TRIBESMAN_WITH_AX then -- if the moveable is a Flamethrower
            	Knock_Out_Baddy(moveable:GetName(), moveableSlot)
            end
            if moveableSlot == ObjID.DOG then -- if the moveable is a Flamethrower
            	Knock_Out_Baddy(moveable:GetName(), moveableSlot)
            end
            if moveableSlot == ObjID.BADDY2 then -- if the moveable is a Flamethrower
            	Knock_Out_Baddy(moveable:GetName(), moveableSlot)
            end
        end
    end
end
---------------------------
--- PHYSICAL COMBAT END ---
---------------------------
--=================================
-- DEMO END START
--=================================
LevelFuncs.FinishShakespeareDemo = function()
	local finish_level_org = EventSequence.Create
	(
    	"finish_level_org", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.


    	-- The below section is where you put all the events you want
    	-- in your sequence, in the order you want them,
    	-- with the timings between)
    	0.0,
		LevelFuncs.DemoEndFlyby,
    	22.0, -- I made an enumerator for this so I don't have to change all manually
    	LevelFuncs.DisplayStats
    )

   -- last : now we have created the Event Sequence: you must Start it:
    finish_level_org:Start()
end

LevelFuncs.DemoEndFlyby = function()
	LevelFuncs.Engine.Node.PlayAudioTrack("011", 0)
	LevelFuncs.Engine.Node.PlayFlyBy(21)
end

LevelFuncs.DemoFlybyText = function()
	LevelFuncs.Engine.Node.DrawText("You have reached the end of the\nSHAKESPEARE CLIFF demo!", 50, 20, 1, 1, TEN.Color(255,255,255), 1.1, 1)
	LevelFuncs.Engine.Node.DrawText("Act 2 Coming Soon...", 50, 43, 1, 1, TEN.Color(255,255,255), 1.6, 1)
	LevelFuncs.Engine.Node.DrawText("THANK YOU FOR PLAYING!", 50, 70, 1, 1, TEN.Color(255,255,255), 1.3, 1)
end

local endTimeTaken = tostring(Flow.GetStatistics().timeTaken) -- this will be a toString(Time()) 
local statsHeader_str = TEN.Strings.DisplayString("Shakespeare Cliff (Demo)", 
											   TEN.Vec2(TEN.Util.PercentToScreen(50, 20)), -- pos
											   1.0, -- scale
											   TEN.Color(255,255,255), -- color
											   false, --translated bool
											   {TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW} -- flags
											   )
											   
LevelFuncs.DisplayStats = function()
	LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, "LARA_MAIN", "END_LSP")
	LevelFuncs.Engine.Node.PlayFlyBy(22)
	if Sound.IsAudioTrackPlaying("011") then
		Sound.StopAudioTrack(SoundTrackType.ONESHOT)
	end
	LevelFuncs.Engine.Node.PlayAudioTrack("001", SoundTrackType.LOOPED)
	LevelFuncs.Engine.Node.SetMoveableAnimation("LARA_MAIN", 975)
	
	TEN.Strings.ShowString(statsHeader_str)
	local leftJustify = 30
	local rightJustify = 70
	local yStatsPos = 30
	-- time taken
	--local endTimeTakenFormatted = "".. endTimeTaken.h .. ":" .. endTimeTaken.m .. ":" .. endTimeTaken.s
	LevelFuncs.Engine.Node.DrawText("Time Taken: ", leftJustify, yStatsPos, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(endTimeTaken, rightJustify, yStatsPos, 2, 1, TEN.Color(255,255,255), 0.8)
	-- secrets found
	local secretsFound = ""..Flow.GetStatistics().secrets
	LevelFuncs.Engine.Node.DrawText("Secrets Found: ", leftJustify, yStatsPos+5, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(secretsFound, rightJustify, yStatsPos+5, 2, 1, TEN.Color(255,255,255), 0.8)
	-- Pickups
	local pickupsFound = ""..Flow.GetStatistics().pickups
	LevelFuncs.Engine.Node.DrawText("Pickups: ", leftJustify, yStatsPos+10, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(pickupsFound, rightJustify, yStatsPos+10, 2, 1, TEN.Color(255,255,255), 0.8)
	-- Kills
	local killsStats = ""..Flow.GetStatistics().kills
	LevelFuncs.Engine.Node.DrawText("Kills: ", leftJustify, yStatsPos+15, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(killsStats, rightJustify, yStatsPos+15, 2, 1, TEN.Color(255,255,255), 0.8)
	-- Ammo Used/Hits
	local ammoUsedHits = ""..Flow.GetStatistics().ammoUsed .. "/" .. Flow.GetStatistics().ammoHits
	LevelFuncs.Engine.Node.DrawText("Ammo Used/Hits: ", leftJustify, yStatsPos+20, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(ammoUsedHits, rightJustify, yStatsPos+20, 2, 1, TEN.Color(255,255,255), 0.8)
	-- Medipacks Used
	local healthPacksUsed = ""..Flow.GetStatistics().healthPacksUsed
	LevelFuncs.Engine.Node.DrawText("Medi Packs Used: ", leftJustify, yStatsPos+25, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(healthPacksUsed, rightJustify, yStatsPos+25, 2, 1, TEN.Color(255,255,255), 0.8)
	-- Distance Travelled in km
	-- convert to km : 1 m = 240 units -> 1km - 0.240 units
	local distanceTravelled = "" .. string.format("%.2f", (Flow.GetStatistics().distanceTraveled / 240) ) .. "m"
	LevelFuncs.Engine.Node.DrawText("Distance Travelled: ", leftJustify, yStatsPos+30, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(distanceTravelled, rightJustify, yStatsPos+30, 2, 1, TEN.Color(255,255,255), 0.8)
	
	LevelFuncs.Engine.Node.DrawText("(Press ACTION to continue)", 50, yStatsPos+40, 1, 3, TEN.Color(255,255,255), 0.8)
end
											   
function showStatsSpritesBackGround()
	-- text background blur (for easier viewing)
	if TEN.Strings.IsStringDisplaying(statsHeader_str) then
		--LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 50, 0, 100, 100, 0, 0, 2, 9)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 48, 0, 60, 80, 0, 0, 2, 9)
	end
end

LevelFuncs.GetEndLevelTime = function()
	endTimeTaken = tostring(Flow.GetStatistics().timeTaken)
end


--=================================
-- CRAFT RAMP EVENT SEQUENCE START
--=================================

LevelFuncs.CraftRampCheck = function()
	CheckCraftRampLogic()
end

function CheckCraftRampLogic()
	local required_planks = 2
	local required_pipes = 2
	local required_rope = 1
	local remaining_planks = required_planks - Inventory.GetItemCount(ObjID.PUZZLE_ITEM14)
	local remaining_pipes = required_pipes - Inventory.GetItemCount(ObjID.PUZZLE_ITEM13)
	local remaining_rope = required_rope - Inventory.GetItemCount(ObjID.PUZZLE_ITEM16)
	
	-- if lara is idle (anim 103)
	if lara : GetAnim() == 103 or 
	   lara:GetAnim() == 984 or lara:GetAnim() == 985 or
	   (lara:GetAnim() == 1025 and lara:GetAnim() == 1029) then
		-- print a hint
		LevelFuncs.Engine.Node.DrawText("Press ACTION to CRAFT", 50, 85, 1, 3, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 87, 0, 50, 9, 0, 0, 2, 9)
	elseif lara : GetAnim() == 999 then
		if Inventory.GetItemCount(ObjID.PUZZLE_ITEM16) == required_rope and -- rope
		   Inventory.GetItemCount(ObjID.PUZZLE_ITEM13) == required_pipes and -- pipes
		   Inventory.GetItemCount(ObjID.PUZZLE_ITEM14) == required_planks then -- planks
			LevelFuncs.Engine.Node.DrawText("Press ACTION to CRAFT", 50, 85, 1, 3, TEN.Color(255,255,255), 0.8, 1)
			LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 87, 0, 50, 9, 0, 0, 2, 9)
		else
			LevelFuncs.Engine.Node.DrawText("(Press ACTION to exit)", 50, 85, 1, 3, TEN.Color(255,255,255), 0.8, 1)
			LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 87, 0, 40, 9, 0, 0, 2, 9)
		end
	end

	-- if lara is idle (anim 103)
	if lara : GetAnim() == 103 or 
	   lara:GetAnim() == 984 or lara:GetAnim() == 985 or
	   (lara:GetAnim() == 1025 and lara:GetAnim() == 1029) then
		-- if the player presses ACTION
		if Input.IsKeyPulsed(Input.ActionID.ACTION, 2, 2) then
			-- perform animation 998 (crystal start)
			lara : SetAnim(998)
		end
	end

	-- if lara is crystal idle (anim 999)
	if lara : GetAnim() == 999 then
		-- << HINT LOGIC BEGIN >>
		-- play cam hint
		-- LevelFuncs.Engine.Node.ActivateCamera("camera_806", "camera_target_805")
		LevelFuncs.Engine.Node.DrawText("I reckon I could craft a ramp \nif I had enough construction materials...", 50, 5, 1, 1, TEN.Color(255,255,255), 0.7, 1)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 9, 0, 40, 13, 0, 0, 2, 9)

		LevelFuncs.Engine.Node.DrawText("Total Required\n Construction Materials:\n" .. 
										tostring(required_planks) .. " Construction Plank Set\n" ..
		                                tostring(required_pipes) .. " Construction Pipe Set\n" .. 
										tostring(required_rope) .. " Bundle of Rope", 35, 40, 1, 1, TEN.Color(255,255,255), 0.7, 1)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 35, 50, 0, 30, 30, 0, 0, 2, 9)

		LevelFuncs.Engine.Node.DrawText("Remaining Required\n Construction Materials:\n" .. 
										tostring(remaining_planks) .. " Construction Plank Set\n" ..
		                                tostring(remaining_pipes) .. " Construction Pipe Set\n" .. 
										tostring(remaining_rope) .. " Bundle of Rope", 68, 40, 1, 1, TEN.Color(255,255,255), 0.7, 1)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 68, 50, 0, 30, 30, 0, 0, 2, 9)
		-- << HINT LOGIC END >>	

		-- if the player presses ACTION
		if Input.IsKeyPulsed(Input.ActionID.ACTION, 2, 2) then
			if Inventory.GetItemCount(ObjID.PUZZLE_ITEM16) == required_rope and -- rope
				Inventory.GetItemCount(ObjID.PUZZLE_ITEM13) == required_pipes and -- pipes
				Inventory.GetItemCount(ObjID.PUZZLE_ITEM14) == required_planks then -- planks
					Objects.GetMoveableByName("animating41_849"):Destroy()
					LevelFuncs.Engine.Node.RunLuaScript(LevelFuncs.CraftARampOnTrain, "")
					LevelFuncs.Engine.Node.DisableVolume("volume_437")
			else
				-- perform animation 998 (crystal start)
				lara : SetAnim(1000)
			end
		end
	end
end

LevelFuncs.LaraCraftAnim = function()
	LevelFuncs.Engine.Node.UndrawWeapon()
	LevelFuncs.Engine.Node.SetMoveableAnimation("LARA_MAIN", 1031)
	LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 10, TEN.Objects.ObjID.LARA_SPEECH_HEAD3, 10)
	LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 13, TEN.Objects.ObjID.LARA_SPEECH_HEAD3, 13)
end

LevelFuncs.FlipMapRamp = function()
    LevelFuncs.Engine.Node.ToggleFlipMap(1)
    LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, "LARA_MAIN", "lara_start_pos_436")
    LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, "quad_253", "lara_start_pos_436")
	LevelFuncs.Engine.Node.PlayAudioTrack("029", 0)
	LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 10, TEN.Objects.ObjID.LARA_SKIN, 10)
	LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 13, TEN.Objects.ObjID.LARA_SKIN, 13)
end

LevelFuncs.CraftARampOnTrain = function()
	local CraftARampOnTrainSequence = EventSequence.Create
	(
    	"Craft_A_Ramp_On_Train", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.

    	0.0, -- I made an enumerator for this so I don't have to change all manually
    	LevelFuncs.LaraCraftAnim,
    	1.0,
    	LevelFuncs.CutFadeOut,
    	3.0,
    	LevelFuncs.FlipMapRamp,
    	2.0,
    	LevelFuncs.CutFadeIn
    )

   -- last : now we have created the Event Sequence: you must Start it:
    CraftARampOnTrainSequence:Start()
end
--===============================
-- CRAFT RAMP EVENT SEQUENCE END
--===============================