-- Place in this Lua script all the levels of your game
-- Title is mandatory and must be the first level.

-- Intro image is a splash screen which appears before actual loading screen.
-- If you don't want it to appear, just remove this line.

Flow.SetIntroImagePath("Screens\\intro.jpg")

-- Intro video plays right after or instead of intro image, if specified.
-- If you don't want it to appear, just remove this line.

Flow.SetIntroVideoPath("Fmv\\intro.mp4")

-- Set overall amount of secrets in game.
-- If set to 0, secrets won't be displayed in statistics.

Flow.SetTotalSecretCount(8)

-- Enable/Disable Point Filter (square, unsmoothed pixels).

Flow.EnablePointFilter(false)

-- Enable/Disable saving and loading of savegames.

Flow.EnableLoadSave(true)

-- Disable/enable flycheat globally

Flow.EnableFlyCheat(true)

-- Disable/enable Lara drawing in title level

Flow.EnableLaraInTitle(false)

-- Disable/enable level selection in title level

Flow.EnableLevelSelect(true)

-- Disable/enable mass pickup (collect all pickups at once)

Flow.EnableMassPickup(true)

--------------------------------------------------

-- Title level

title = Level.new()

title.ambientTrack = "009"
title.levelFile = "Data\\title.ten"
title.scriptFile = "Scripts\\Levels\\title.lua"
title.loadScreenFile = "Screens\\main.png"

Flow.AddLevel(title)

--------------------------------------------------

Palazzo_Dario = Level.new()

Palazzo_Dario.nameKey = "Ca' Dario Palace"
Palazzo_Dario.scriptFile = "Scripts\\Levels\\Palazzo_Dario.lua"
Palazzo_Dario.ambientTrack = "120"
Palazzo_Dario.horizon = true
Palazzo_Dario.secrets = 8
Palazzo_Dario.levelFile = "Data\\Palazzo_Dario.ten"
Palazzo_Dario.loadScreenFile = "Screens\\dario.png"
Palazzo_Dario.objects =
{
    InventoryItem.new ("Golden Key", ObjID.KEY_ITEM1, -10, 0.7, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE);
    InventoryItem.new ("Rusty Key", ObjID.KEY_ITEM2, -10, 0.7, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE);
    InventoryItem.new ("Blue Key", ObjID.KEY_ITEM3, -10, 0.7, Rotation.new(0, 0, 0), RotationAxis.Y, 0, ItemAction.USE);
}

Flow.AddLevel(Palazzo_Dario)

--------------------------------------------------
