-- Place in this Lua script all the levels of your game
-- Title is mandatory and must be the first level.

-- Intro image is a splash screen which appears before actual loading screen.
-- If you don't want it to appear, just remove this line.

-- Flow.SetIntroImagePath("Screens\\main.jpg")

-- Set overall amount of secrets in game.
-- If set to 0, secrets won't be displayed in statistics.

Flow.SetTotalSecretCount(0)

-- Enable/Disable Point Filter (square, unsmoothed pixels).

Flow.EnablePointFilter(false)

-- Enable/Disable saving and loading of savegames.

Flow.EnableLoadSave(true)

-- Disable/enable flycheat globally

Flow.EnableFlyCheat(false)

-- Disable/enable Lara drawing in title level

Flow.EnableLaraInTitle(true)

-- Disable/enable level selection in title level

Flow.EnableLevelSelect(false)

-- Disable/enable mass pickup (collect all pickups at once)

Flow.EnableMassPickup(true)

--------------------------------------------------

-- Title level

title = Level.new()

title.ambientTrack = "050_alicia"
title.levelFile = "Data\\NYE_2025.ten"
title.scriptFile = "Scripts\\Levels\\NYE_2025_title.lua"
title.loadScreenFile = "Screens\\main.jpg"

Flow.AddLevel(title)

--------------------------------------------------
-- When You Wish Upon a Star level

NYE_2025 = TEN.Flow.Level()

NYE_2025.nameKey = "NYE_2025"
NYE_2025.scriptFile = "Scripts\\Levels\\NYE_2025.lua"
NYE_2025.ambientTrack = "110"
NYE_2025.horizon1.enabled = true
NYE_2025.levelFile = "Data\\NYE_2025.ten"
NYE_2025.loadScreenFile = "Screens\\loading.png"
NYE_2025.weather = WeatherType.Snow
NYE_2025.weatherStrength = 0.2

NYE_2025.objects = {
	InventoryItem.new(
		"Shooting_Star_Fragment",
		ObjID.PUZZLE_ITEM2,
		100,
		0.25,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"Jean_Harlow",
		ObjID.PICKUP_ITEM1,
		235,
		0.75,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"Hollywood_Martini",
		ObjID.PICKUP_ITEM2,
		235,
		0.75,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"Bond_Martini",
		ObjID.PICKUP_ITEM3,
		235,
		0.75,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"Gone_With_The_Gin",
		ObjID.PICKUP_ITEM4,
		235,
		0.75,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"Some_Like_It_ManHOTtan",
		ObjID.PICKUP_ITEM5,
		235,
		0.75,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"The_Award_Goes_To",
		ObjID.PICKUP_ITEM6,
		235,
		0.75,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"The_Red_Carpet",
		ObjID.PICKUP_ITEM7,
		235,
		0.75,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"The_Marlene_Dietrich",
		ObjID.PICKUP_ITEM8,
		235,
		0.75,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"Piramasu",
		ObjID.PICKUP_ITEM9,
		235,
		0.75,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"CD_Player",
		ObjID.PUZZLE_ITEM1,
		75,
		0.75,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"Pole_Tutorial_Toggle",
		ObjID.PICKUP_ITEM10,
		75,
		0.75,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
}

TEN.Flow.AddLevel(NYE_2025)

--------------------------------------------------
-- Winter_2025 level

Winter_2025 = TEN.Flow.Level()

Winter_2025.nameKey = "Winter_2025"
Winter_2025.scriptFile = "Scripts\\Levels\\Winter_2025.lua"
Winter_2025.ambientTrack = "110"
Winter_2025.horizon1.enabled = true
Winter_2025.levelFile = "Data\\Winter_2025.ten"
Winter_2025.loadScreenFile = "Screens\\loading.png"
Winter_2025.weather = WeatherType.Snow
Winter_2025.weatherStrength = 0.5
TEN.Flow.AddLevel(Winter_2025)

--------------------------------------------------
--------------------------------------------------
-- Intro level

Intro = TEN.Flow.Level()

Intro.nameKey = "Intro"
Intro.scriptFile = "Scripts\\Levels\\Intro.lua"
Intro.ambientTrack = "025"
Intro.horizon = true
Intro.levelFile = "Data\\Intro.ten"
Intro.loadScreenFile = "Screens\\rome.jpg"
Intro.weather = WeatherType.Snow
Intro.weatherStrength = 1.0

TEN.Flow.AddLevel(Intro)

--------------------------------------------------
-- Child_Lara level

Child_Lara = TEN.Flow.Level()

Child_Lara.nameKey = "Child_Lara"
Child_Lara.scriptFile = "Scripts\\Levels\\Child_Lara.lua"
Child_Lara.ambientTrack = "026"
Child_Lara.horizon = true
Child_Lara.levelFile = "Data\\Child_Lara.ten"
Child_Lara.loadScreenFile = "Screens\\rome.jpg"
Child_Lara.weather = WeatherType.Snow
Child_Lara.weatherStrength = 1.0

Child_Lara.objects = {
	InventoryItem.new(
		"Set_Santa_Outfit",
		ObjID.PICKUP_ITEM1,
		100,
		0.25,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	),
	InventoryItem.new(
		"Set_Default_Outfit",
		ObjID.PICKUP_ITEM2,
		100,
		0.25,
		Rotation.new(0, 0, 0),
		RotationAxis.Y,
		-1,
		ItemAction.USE
	)
}

TEN.Flow.AddLevel(Child_Lara)

--------------------------------------------------

-- Nevada_TR3 level

Nevada_TR3 = TEN.Flow.Level()

Nevada_TR3.nameKey = "Nevada_TR3"
Nevada_TR3.scriptFile = "Scripts\\Levels\\Nevada_TR3.lua"
Nevada_TR3.ambientTrack = "106 area 51"
Nevada_TR3.horizon = true
Nevada_TR3.levelFile = "Data\\Nevada_TR3.ten"
Nevada_TR3.loadScreenFile = "Screens\\rome.jpg"

TEN.Flow.AddLevel(Nevada_TR3)

--------------------------------------------------

-- Fire Temple Test level

Fire_Temple = TEN.Flow.Level()

Fire_Temple.nameKey = "Fire_Temple"
Fire_Temple.scriptFile = "Scripts\\Levels\\Fire_Temple.lua"
Fire_Temple.ambientTrack = "106 area 51"
Fire_Temple.horizon = true
Fire_Temple.levelFile = "Data\\Fire_Temple.ten"
Fire_Temple.loadScreenFile = "Screens\\rome.jpg"

TEN.Flow.AddLevel(Fire_Temple)


