-- FILE: Levels\Intro.lua

LevelFuncs.OnLoad = function() end
LevelFuncs.OnSave = function() end
LevelFuncs.OnStart = function() 
	LevelFuncs.Engine.Node.AddInventoryItem(TEN.Objects.ObjID.PISTOLS_ITEM, 1)
	--LevelFuncs.Engine.Node.AddInventoryItem(TEN.Objects.ObjID.PICKUP_ITEM1, 1)
	--LevelFuncs.Engine.Node.AddInventoryItem(TEN.Objects.ObjID.PICKUP_ITEM2, 1)
end
LevelFuncs.OnLoop = function() 
	SprintSlide("LARA_MAIN")
	--TR3_INV_SFX_OPEN()
	ShowAmmoCounter() 
	SetSantaOutfit()
	SetStandardOutfit()
end
LevelFuncs.OnEnd = function() end
LevelFuncs.OnUseItem = function() end


function SetSantaOutfit()
	if (LevelFuncs.Engine.Node.TesttUsedItem(TEN.Objects.ObjID.PICKUP_ITEM1, true)) then
		LevelFuncs.Engine.Node.FlashScreen(TEN.Color(0,0,0), 0.1)
		LevelFuncs.Engine.Node.PlaySoundAroundMoveable("LARA_MAIN", 1158)
		for i = 0,14,1
		do
			LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", i, TEN.Objects.ObjID.LARA_SPEECH_HEAD1, i)
		end
	end
end

function SetStandardOutfit()
	if (LevelFuncs.Engine.Node.TesttUsedItem(TEN.Objects.ObjID.PICKUP_ITEM2, true)) then
		LevelFuncs.Engine.Node.FlashScreen(TEN.Color(0,0,0), 0.1)
		LevelFuncs.Engine.Node.PlaySoundAroundMoveable("LARA_MAIN", 1158)
		for i = 0,14,1
		do
			LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", i, TEN.Objects.ObjID.LARA_SPEECH_HEAD2, i)
		end
	end
end

function ShowAmmoCounter()
    local weaponType = " "
    local ammoCounterPosX = 100 -- X Position of counter.
    local ammoCounterPosY = 300 -- Y Position of counter.
    local holdWeapon = Lara:GetHandStatus() -- Check Lara's hand status.
    local ammoCounterColor = Color(255, 255, 255) 
    local ammoMessage = DisplayString(
    "Ammo: "..Lara:GetHandStatus(), 100,
    300, Color(255, 255, 255))

    if (holdWeapon == 4 and not(Lara:GetWeaponType() == 7) and not(Lara:GetWeaponType() == 8)) then
	    	-- get the weapon type
	    if Lara:GetWeaponType() == 1 then
	    	LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 3, TEN.Color(255,255,255), 5, 12, 0, 12, 7, 0, 0, 0, 9)
	    elseif Lara:GetWeaponType() == 2 then
	    	LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 4, TEN.Color(255,255,255), 5, 12, 0, 12, 7, 0, 0, 0, 9)
	    elseif Lara:GetWeaponType() == 3 then
	    	LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 5, TEN.Color(255,255,255), 5, 12, 0, 12, 7, 0, 0, 0, 9)
	    elseif Lara:GetWeaponType() == 4 then
	    	LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 6, TEN.Color(255,255,255), 5, 12, 0, 12, 7, 0, 0, 0, 9)
	    elseif Lara:GetWeaponType() == 5 then
	    	LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 7, TEN.Color(255,255,255), 5, 12, 0, 12, 7, 0, 0, 0, 9)
	    elseif Lara:GetWeaponType() == 6 then
	    	LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 8, TEN.Color(255,255,255), 5, 12, 0, 12, 7, 0, 0, 0, 9)
	    elseif Lara:GetWeaponType() == 9 then
	    	LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 9, TEN.Color(255,255,255), 5, 12, 0, 12, 7, 0, 0, 0, 9)
	    elseif Lara:GetWeaponType() == 10 then
	    	LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 10, TEN.Color(255,255,255), 5, 12, 0, 12, 7, 0, 0, 0, 9)
	    elseif Lara:GetWeaponType() == 11 then
	    	LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 11, TEN.Color(255,255,255), 5, 12, 0, 12, 7, 0, 0, 0, 9)
	    end
	    
		if (Lara:GetAmmoCount() == -1) then
			LevelFuncs.Engine.Node.DrawText("Unlimited", 9, 10, 0, 3, TEN.Color(255,255,255), 0.8)
		else
			LevelFuncs.Engine.Node.DrawText(""..Lara:GetAmmoCount(), 9, 10, 0, 3, TEN.Color(255,255,255), 0.8)
		end
    else
        HideString(ammoMessage)
    end
end

function SprintSlide(lara_obj)
	-- lara_obj = "lara_17"
	-- if Lara is sprinting
	if (LevelFuncs.Engine.Node.TestMoveableAnimation(lara_obj, 223)) then
		-- if the player presses the WALK key
		if (LevelFuncs.Engine.Node.KeyIsHeld(6)) then
			-- if the key was hit in the frame range [9,18]
			if (LevelFuncs.Engine.Node.TestMoveableFrameNumber(lara_obj, 9, 18)) then
				-- play anim 957 (sprint slide right)
				LevelFuncs.Engine.Node.SetMoveableAnimation(lara_obj, 957)
			elseif (LevelFuncs.Engine.Node.TestMoveableFrameNumber(lara_obj, 0, 9)) then
				-- play anim 956 (sprint slide left)
				LevelFuncs.Engine.Node.SetMoveableAnimation(lara_obj, 956)
			end
		end
	-- else if Lara is running sprint left
	elseif (LevelFuncs.Engine.Node.TestMoveableAnimation(lara_obj, 224)) then
		-- if the player presses the WALK key
		if (LevelFuncs.Engine.Node.KeyIsHeld(6)) then
			-- play anim 956 (sprint slide left)
			LevelFuncs.Engine.Node.SetMoveableAnimation(lara_obj, 956)
		end
	-- else if Lara is run to sprint right
	elseif (LevelFuncs.Engine.Node.TestMoveableAnimation(lara_obj, 225)) then
		-- if the player presses the WALK key
		if (LevelFuncs.Engine.Node.KeyIsHeld(6)) then
			-- play anim 957 (sprint slide right)
			LevelFuncs.Engine.Node.SetMoveableAnimation(lara_obj, 957)
		end
	end
	-- if Lara is running
	if (LevelFuncs.Engine.Node.TestMoveableAnimation(lara_obj, 0)) then
		-- if the player presses the WALK key
		if (LevelFuncs.Engine.Node.KeyIsHeld(6)) and (LevelFuncs.Engine.Node.KeyIsHeld(7)) then
			-- if the key was hit in the frame range [9,18]
			if (LevelFuncs.Engine.Node.TestMoveableFrameNumber(lara_obj, 9, 18)) then
				-- play anim 957 (sprint slide right)
				LevelFuncs.Engine.Node.SetMoveableAnimation(lara_obj, 957)
			elseif (LevelFuncs.Engine.Node.TestMoveableFrameNumber(lara_obj, 0, 9)) then
				-- play anim 956 (sprint slide left)
				LevelFuncs.Engine.Node.SetMoveableAnimation(lara_obj, 956)
			end
		end
	end
	
end

function TR3_INV_SFX_OPEN()
	if (LevelFuncs.Engine.Node.KeyIsHit(37)) then
		LevelFuncs.Engine.Node.PlaySoundAroundMoveable("LARA_MAIN", 109)
	end
	if (LevelFuncs.Engine.Node.KeyIsHit(38)) then
		LevelFuncs.Engine.Node.PlaySoundAroundMoveable("LARA_MAIN", 109)
	end
end