---@diagnostic disable: duplicate-set-field
require("Levels.MISC_LOOP_FUNCTIONS")
-- Timer Functions
local Timer = require("Engine.Timer")
local useTimer = 1.0
-- EventSequences
local EventSequence = require("Engine.EventSequence")

-----------------------------
-- LEVEL FUNCTIONS STANDARD SET UP
-----------------------------
LevelFuncs.OnLoad = function() end
LevelFuncs.OnSave = function() end
LevelFuncs.OnStart = function()
	Inventory.SetItemCount(ObjID.PISTOLS_ITEM, 0)
	Inventory.SetItemCount(ObjID.PISTOLS_AMMO_ITEM, 0)
	Inventory.SetItemCount(ObjID.PUZZLE_ITEM1, 1)
	Inventory.SetItemCount(ObjID.PICKUP_ITEM10, 1)
	LevelVars.IsSnowBallEquipped = false
	LevelVars.SplatCounter = 0
	-- LevelFuncs.BlinkOrganizer()
	LevelFuncs.IntroClubCutOrg()
	LevelVars.canPulse = true
	LevelVars.CanShowStarCounter = false
	-- LevelFuncs.EnableStarCounter()
	LevelVars.TotalStars = 25
	LevelVars.CocktailOption = 1
	LevelVars.NumDrinksConsumed = 0
	LevelVars.ClubMusicOption = 1
	LevelVars.HeadphoneMusicOption = 1
	LevelVars.IsLaraOutside = 1
	LevelVars.ShowPoleTutorial = 0
	LevelVars.ShowWinstonPrompt = false
end
LevelFuncs.OnLoop = function()
    KnockOutBaddies()
	-- EquipSnowBall()
	ShootingStarEffects()
	-- SetSpeakers()
	RenderSpriteChecker()
	ShowStarCounter()
	LevelFuncs.HeadphoneLogic()
	BellTowerGateCamCheck()
	ShowPoleTutorial()
	showStatsSpritesBackGround()
end
LevelFuncs.OnEnd = function() end
LevelFuncs.OnUseItem = function()
	DrinkGurlDrink()
	ShowPoleTutorialToggle()
	
end
LevelFuncs.OnFreeze = function() end

function SetSoftCollisionToAllStatics()
	local staticFirstSlot = 0
	local staticLastSlot = 177
	-- init empty list of all static items
	local allStatics = {}
	local numEntries = 0
	for i = staticFirstSlot, staticLastSlot, 1 do
		local currStatics = Objects.GetStaticsBySlot(i)
		-- get length of table
		local numEntriesForSlot = #currStatics
		if numEntriesForSlot > 0 then
			-- append table of elements over to interactiveObjects
			table.move(currStatics, 1, numEntriesForSlot, #allStatics+1, allStatics)
			numEntries = numEntries + numEntriesForSlot
		end
	end
	-- parse through all the moveables in
	for index, currStatic in pairs(allStatics) do
		currStatic:SetSolid(false)
	end
end

------------------
-- FREE WINSTON --
------------------
LevelFuncs.FreeWinstonCheck = function()
	-- if lara is idle (anim 103)
	if IsLaraStandingWalkingRunning() and LevelVars.ShowWinstonPrompt == true then
		-- print a hint
		LevelFuncs.Engine.Node.DrawText("Press ACTION to MAKE A WISH", 50, 85, 1, 3, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 87, 0, 50, 9, 0, 0, 2, 9)
	elseif lara : GetAnim() == 999 then
		if Inventory.GetItemCount(ObjID.PUZZLE_ITEM2) < 25 then
			LevelFuncs.Engine.Node.DrawText("Press ACTION to exit", 50, 85, 1, 3, TEN.Color(255,255,255), 0.8, 1)
			LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 87, 0, 40, 9, 0, 0, 2, 9)
		else
			LevelFuncs.Engine.Node.DrawText("Press ACTION to MAKE A WISH", 50, 85, 1, 3, TEN.Color(255,255,255), 0.8, 1)
			LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 87, 0, 40, 9, 0, 0, 2, 9)
		end
	end
	
	-- if lara is idle (anim 103)
	if IsLaraStandingWalkingRunning() and LevelVars.ShowWinstonPrompt ==  true then
		-- if the player presses ACTION
		if IsKeyPulsed(Input.ActionID.ACTION, 2, 2) then
			-- perform animation 998 (crystal start)
			lara : SetAnim(998)
		end
	end

	if lara : GetAnim() == 998  then
		if lara:GetFrame() == 0 then
			MoveLaraToLSP(true, "lara_start_pos_2367")
		end
		LevelFuncs.Engine.Node.ActivateCamera("camera_2368", "camera_target_2369")
	end 

	-- if lara is crystal idle (anim 999)
	if lara : GetAnim() == 999 then 
	
		-- << HINT LOGIC BEGIN >>
		-- play cam hint
		LevelFuncs.Engine.Node.ActivateCamera("camera_2368", "camera_target_2369")
		LevelFuncs.Engine.Node.DrawText("Make a wish to free Winston?", 50, 6, 1, 1, TEN.Color(255,255,255), 1.0, 1)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 9, 0, 50, 13, 0, 0, 2, 9)
		if Inventory.GetItemCount(ObjID.PUZZLE_ITEM2) < 25 then
			LevelFuncs.Engine.Node.DrawText("You need:\n" .. 
											tostring(LevelVars.TotalStars - Inventory.GetItemCount(ObjID.PUZZLE_ITEM2)) .. " more shooting star(s)\n to make this wish!", 
											50, 42, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 50, 0, 30, 30, 0, 0, 2, 9)
		end
		-- << HINT LOGIC END >>
		
		-- if the player presses ACTION
		if IsKeyPulsed(Input.ActionID.ACTION, 2, 2) then
			-- perform animation 998 (crystal start)
			lara : SetAnim(1000)
		end
	end

	if lara : GetAnim() == 1000 and lara : GetFrame() == 0 then
		if Inventory.GetItemCount(ObjID.PUZZLE_ITEM2) < 25 then
			Sound.PlayAudioTrack("010 not stronk", SoundTrackType.VOICE)
			-- LevelFuncs.Engine.Node.DrawTextForTimespan(5, 
			-- 									"YOUR WISH \nIS NOT \nSTRONG ENOUGH!", 
			-- 									50, 40, 1, 1, 
			-- 									TEN.Color(255,255,255), 
			-- 									1, 1)
		else
			-- play Free Winston Org
			LevelFuncs.FreeWinstonOrg()
		end
	end
end
LevelFuncs.FreeWinstonOrg = function ()
	local free_winston_org = EventSequence.Create(
						"free_winston_org", -- sequence's name
						false, -- loop
						false, -- no countdown is displayed
						0,
						LevelFuncs.FreeWinston1, 
						2,
						LevelFuncs.clearSprites,
						2,
						LevelFuncs.FreeWinston2,
						5,
						LevelFuncs.clearSprites,
						6,
						LevelFuncs.DisplayStats
						)
	-- event sequences are inactive to begin with and so need to be started
    free_winston_org:Start()
end
LevelFuncs.FreeWinston1 = function()
	LevelVars.ShowWinstonPrompt = false
	MoveLaraToLSP(true, "lara_start_pos_2367")
	LevelFuncs.Engine.Node.PlayFlyBy(19)
	local winston_obj1 = Objects.GetMoveableByName("winston_obj")
	LevelFuncs.Engine.Node.EnableMoveable("winston_obj_free", 0)
    LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 1165)
	LevelFuncs.Engine.Node.FlashScreen(TEN.Color(255,255,0), 1)
    winston_obj1:Shatter()
    winston_obj1:Disable()
    winston_obj1:Destroy()
	
	Sound.StopAudioTrack(SoundTrackType.ONESHOT)
	Sound.PlayAudioTrack("066_flamegrace_octopath", SoundTrackType.LOOPED)
	Sound.PlayAudioTrack("064_WINSTON_THANKS_BINCH", SoundTrackType.VOICE)
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
	LevelFuncs.Engine.Node.DrawTextForTimespan(2, 
                                               "Winston:\n  Thank you for saving me Ms. Croft.", 
                                               50, 82, 1, 1, 
                                               TEN.Color(255,255,255), 
                                               0.7, 1)
end
LevelFuncs.FreeWinston2 = function()
	Sound.PlayAudioTrack("065_LARA_THANKS_BB", SoundTrackType.VOICE)
	local winston_obj_free = Objects.GetMoveableByName("winston_obj_free")
	winston_obj_free:SetAnim(4)
	lara:SetAnim(1098)
	LevelFuncs.Engine.Node.PlayFlyBy(20)
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
	LevelFuncs.Engine.Node.DrawTextForTimespan(5, 
                                               "Lara Croft:\n  Of course Winston! What would I do without you!\n Happy New Year!", 
                                               50, 82, 1, 1, 
                                               TEN.Color(255,255,255), 
                                               0.7, 1)
end

-----------------------------
-- PLEASE IM A STAR
-----------------------------
LevelFuncs.HediCheck = function ()
	print("CHECKING")
	if LevelFuncs.Engine.Node.SoundIsPlaying(1165) then
		print("DOING THE THING")
		LevelFuncs.HediIsASTAROrg()
	end
end
LevelFuncs.HediIsASTAROrg = function ()
	local hedi_star_org = EventSequence.Create(
						"hedi_star_org", -- sequence's name
						false, -- loop
						false, -- no countdown is displayed
						0,
						LevelFuncs.Hedi1, 
						5,
						LevelFuncs.clearSprites
						)
	-- event sequences are inactive to begin with and so need to be started
    hedi_star_org:Start()
end
LevelFuncs.Hedi1 = function()
	LevelFuncs.Engine.Node.PlayFlyBy(18)
	LevelFuncs.Engine.Node.EnableMoveable("animating74_2160", 0)
	Sound.StopAudioTrack(SoundTrackType.ONESHOT)
	Sound.PlayAudioTrack("063_HEDI_IS_A_STAR", SoundTrackType.VOICE)
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
	LevelFuncs.Engine.Node.DrawTextForTimespan(5, 
                                               "Hedi:\n  I'M A STAR! PLEASE, I'M A STAR!", 
                                               50, 82, 1, 1, 
                                               TEN.Color(255,255,255), 
                                               0.7, 1)
end

-----------------------------
-- SWINGPOLE TUTORIAL TEXT
-----------------------------
function ShowPoleTutorialToggle()
	
	if (LevelFuncs.Engine.Node.TesttUsedItem(TEN.Objects.ObjID.PICKUP_ITEM10)) then
		if LevelVars.ShowPoleTutorial == 0 then 
			LevelVars.ShowPoleTutorial = 1 
			LevelFuncs.Engine.Node.DrawTextForTimespan(5, 
													"SWINGPOLE TUTORIAL TEXT ENABLED!", 
													50, 50, 1, 1, 
													TEN.Color(255,255,255), 
													1, 1)
		else
			LevelVars.ShowPoleTutorial = 0
			LevelFuncs.Engine.Node.DrawTextForTimespan(5, 
													"SWINGPOLE TUTORIAL TEXT DISABLED!", 
													50, 50, 1, 1, 
													TEN.Color(255,255,255), 
													1, 1)
		end
	end

	
end

function ShowPoleTutorial()
	if LevelVars.ShowPoleTutorial == 1 then 
		LevelFuncs.SWINGPOLE_TUT()
	end
end

LevelFuncs.SWINGPOLE_TUT = function()
	-- if lara is hanging on a swingpole
	if lara:GetAnim() == 619 or lara:GetAnim() == 612 or 
	   lara:GetAnim() == 622 or
	   lara:GetAnim() == 640 or lara:GetAnim() == 641 then
		-- prompt
		LevelFuncs.Engine.Node.DrawText("SWINGPOLES (HANGING)", 50, 5, 1, 1, TEN.Color(255,255,255), 2, 1)

		LevelFuncs.Engine.Node.DrawText("Hold UP to swing forward\non a swingpole", 50, 20, 1, 1, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DrawText("Press JUMP while \nHANGING on a \nswingpole\nto PERCH on the \nswingpole", 30, 40, 1, 1, TEN.Color(255,255,255), 0.75, 1)
		LevelFuncs.Engine.Node.DrawText("Press DOWN while\nPERCHED on a \nswingpole\nto return to a \nhanging stance", 70, 40, 1, 1, TEN.Color(255,255,255), 0.75, 1)
		LevelFuncs.Engine.Node.DrawText("Press LEFT or RIGHT to shimmy on the swingpole", 50, 75, 1, 1, TEN.Color(255,255,255), 0.8, 1)
	end

	-- perch tutorial
	if lara:GetAnim() == 647 or lara:GetAnim() == 666 or lara:GetAnim() == 648 or lara:GetAnim() == 645 then
		-- prompt
		LevelFuncs.Engine.Node.DrawText("SWINGPOLES (PERCHED)", 50, 5, 1, 1, TEN.Color(255,255,255), 2, 1)

		LevelFuncs.Engine.Node.DrawText("Press JUMP to\njump forward off\na swingpole", 30, 42, 1, 1, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DrawText("Press DOWN while\nPERCHED on a \nswingpole\nto return to a \nhanging stance", 70, 40, 1, 1, TEN.Color(255,255,255), 0.75, 1)
		LevelFuncs.Engine.Node.DrawText("Press LEFT or RIGHT to segue to a tighrope walk", 50, 85, 1, 1, TEN.Color(255,255,255), 0.8, 1)
	end

	-- swinging tutorial
	if lara:GetAnim() == 462 or 
	   lara:GetAnim() == 630 or lara:GetAnim() == 631 or lara:GetAnim() == 632 or 
	   lara:GetAnim() == 634 or lara:GetAnim() == 615 or lara:GetAnim() == 620 then
		-- prompt
		LevelFuncs.Engine.Node.DrawText("SWINGPOLES (SWINGING)", 50, 5, 1, 1, TEN.Color(255,255,255), 2, 1)
		LevelFuncs.Engine.Node.DrawText("Press ROLL or DOWN while swinging forward to perform a 180 turn", 50, 20, 1, 1, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DrawText("Hold SPRINT to\nswitch to\nfaster swinging\nfor longer jumps", 30, 40, 1, 1, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DrawText("Press JUMP to\njump forward off\na swingpole", 70, 42, 1, 1, TEN.Color(255,255,255), 0.75, 1)
		LevelFuncs.Engine.Node.DrawText("PERCHING can also be performed\nby letting go of UP \nwhile SWINGING FORWARD", 50, 80, 1, 1, TEN.Color(255,255,255), 0.8, 1)
	end

	-- tightrope tutorial
	if lara:GetAnim() == 668 or 
	   lara:GetAnim() == 658 or lara:GetAnim() == 654 or
	   lara:GetAnim() == 670 or 
	   lara:GetAnim() == 656 or lara:GetAnim() == 659 or lara:GetAnim() == 657 then
		-- prompt
		LevelFuncs.Engine.Node.DrawText("TIGHTROPE", 50, 5, 1, 1, TEN.Color(255,255,255), 2, 1)
		LevelFuncs.Engine.Node.DrawText("Press DOWN to perform a 180 turn", 50, 20, 1, 1, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DrawText("PRESS CROUCH to\nswitch to\nhanging on\na swingpole", 30, 40, 1, 1, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DrawText("Press SPRINT to\nperform a\ncartwheel", 70, 42, 1, 1, TEN.Color(255,255,255), 0.75, 1)
		LevelFuncs.Engine.Node.DrawText("Press JUMP to jump forward off a tightrope", 50, 85, 1, 1, TEN.Color(255,255,255), 0.8, 1)
	end
end

-----------------------------
-- BELL TOWER CAMERA
-----------------------------
function BellTowerGateCamCheck()
	 if LevelFuncs.Engine.Node.TestMoveableAnimation("door_type5_1583", 2) or 
	    LevelFuncs.Engine.Node.TestMoveableAnimation("door_type5_1583", 3) then
		LevelFuncs.Engine.Node.ActivateCamera("camera_1584", "door_type5_1583")
	 end
end

-----------------------------
-- SPRITE LOGIC CHECK
-----------------------------
function RenderSpriteChecker()
    local blend_mode = 9
    -- Background
    if LevelFuncs.Engine.Node.TestMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1) then
        -- LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 17, TEN.Color(255,255,255), 50, 50, 0, 50, 50, 0, 0, 0, blend_mode)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 89, 0, 80, 20, 0, 0, 2, 9)

	-- NYE
	elseif LevelFuncs.Engine.Node.TestMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 2) then
        LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 19, TEN.Color(255,255,255), 50, 50, 0, 50, 50, 0, 0, 0, blend_mode)

	-- NYE
	elseif LevelFuncs.Engine.Node.TestMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 3) then
        LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 20, TEN.Color(255,255,255), 50, 50, 0, 50, 50, 0, 0, 0, blend_mode)

    -- title card
    elseif LevelFuncs.Engine.Node.TestMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 4) then
        LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 18, TEN.Color(255,255,255), 50, 50, 0, 70, 70, 0, 0, 0, blend_mode)

    -- title card
    elseif LevelFuncs.Engine.Node.TestMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 5) then
        LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 22, TEN.Color(255,255,255), 47, 50, 0, 50, 50, 0, 0, 0, blend_mode)
    end
end

-----------------------------
-- CLUB MUSIC LOGIC
-----------------------------
LevelFuncs.ClubMusicCheck = function()
	Sound.StopAudioTrack(SoundTrackType.ONESHOT)
	-- play prompt that drink was ordered
	if LevelVars.ClubMusicOption == 1 then
		Sound.PlayAudioTrack("050_alicia", SoundTrackType.LOOPED)
	elseif LevelVars.ClubMusicOption == 2 then
		Sound.PlayAudioTrack("062_Le_Serpent_Rouge", SoundTrackType.LOOPED)
	elseif LevelVars.ClubMusicOption == 3 then
		Sound.PlayAudioTrack("053_Metallic_Madness_Act_2", SoundTrackType.LOOPED)
	elseif LevelVars.ClubMusicOption == 4 then
		Sound.PlayAudioTrack("054_Splash_Canyon", SoundTrackType.LOOPED)
	elseif LevelVars.ClubMusicOption == 5 then
		Sound.PlayAudioTrack("055_Bomberman_Cell", SoundTrackType.LOOPED)
	elseif LevelVars.ClubMusicOption == 6 then
		Sound.PlayAudioTrack("056_Goblu_Boss", SoundTrackType.LOOPED)
	elseif LevelVars.ClubMusicOption == 7 then
		Sound.PlayAudioTrack("057_Jump", SoundTrackType.LOOPED)
	elseif LevelVars.ClubMusicOption == 8 then
		Sound.PlayAudioTrack("058_Falling_Off_Ledge", SoundTrackType.LOOPED)
	elseif LevelVars.ClubMusicOption == 9 then
		Sound.PlayAudioTrack("059_skidoo", SoundTrackType.LOOPED)
	elseif LevelVars.ClubMusicOption == 10 then
		Sound.PlayAudioTrack("060_Pusher", SoundTrackType.LOOPED)
	elseif LevelVars.ClubMusicOption == 11 then
		Sound.PlayAudioTrack("061_ada_mercenaries", SoundTrackType.LOOPED)
	end
end

LevelFuncs.HeadphoneMusicCheck = function()
	Sound.StopAudioTrack(SoundTrackType.ONESHOT)
	-- play prompt that drink was ordered
	if LevelVars.HeadphoneMusicOption == 1 then
		Sound.PlayAudioTrack("067 Octopath Traveler OST - The Frostlands", SoundTrackType.ONESHOT)
	elseif LevelVars.HeadphoneMusicOption == 2 then
		Sound.PlayAudioTrack("068 Animal Crossing New Horizons - New Years Eve Soundtrack 11_50", SoundTrackType.ONESHOT)
	elseif LevelVars.HeadphoneMusicOption == 3 then
		Sound.PlayAudioTrack("070 Traverse Town KH DDD", SoundTrackType.ONESHOT)
	elseif LevelVars.HeadphoneMusicOption == 4 then
		Sound.PlayAudioTrack("054_Splash_Canyon", SoundTrackType.ONESHOT)
	elseif LevelVars.HeadphoneMusicOption == 5 then
		Sound.PlayAudioTrack("119 silver snow story", SoundTrackType.ONESHOT)
	elseif LevelVars.HeadphoneMusicOption == 6 then
		Sound.PlayAudioTrack("069 Animal Crossing New Horizons - New Years Eve Soundtrack 11_55PM", SoundTrackType.ONESHOT)
	elseif LevelVars.HeadphoneMusicOption == 7 then
		Sound.PlayAudioTrack("057_Jump", SoundTrackType.ONESHOT)
	elseif LevelVars.HeadphoneMusicOption == 8 then
		Sound.PlayAudioTrack("058_Falling_Off_Ledge", SoundTrackType.ONESHOT)
	elseif LevelVars.HeadphoneMusicOption == 9 then
		Sound.PlayAudioTrack("073 Spyro - Year of the Dragon OST_ Icy Peak", SoundTrackType.ONESHOT)
	elseif LevelVars.HeadphoneMusicOption == 10 then
		Sound.PlayAudioTrack("071 Spyro - Year of the Dragon OST_ Harbor Speedway", SoundTrackType.ONESHOT)
	elseif LevelVars.HeadphoneMusicOption == 11 then
		Sound.PlayAudioTrack("072 Spyro - Year of the Dragon OST_ Charmed Ridge", SoundTrackType.ONESHOT)
	elseif LevelVars.HeadphoneMusicOption == 12 then
		Sound.StopAudioTrack(SoundTrackType.ONESHOT)
	end
end

LevelFuncs.JukeboxLogic = function()

	-- TEXT AND SPRITE PROMPTS
	if IsLaraStandingWalkingRunning() then
		-- print a hint
		LevelFuncs.Engine.Node.DrawText("Press ACTION to USE JUKEBOX", 50, 85, 1, 3, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 87, 0, 55, 9, 0, 0, 2, 9)
	elseif lara : GetAnim() == 1087 then
		if LevelVars.ClubMusicOption >= 1 and LevelVars.ClubMusicOption <= 11 then
			LevelFuncs.Engine.Node.DrawText("Press ACTION to REQUEST SONG", 50, 85, 1, 3, TEN.Color(255,255,255), 0.8, 1)
			LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 87, 0, 55, 9, 0, 0, 2, 9)
		else
			LevelFuncs.Engine.Node.DrawText("Press ACTION to exit", 50, 85, 1, 3, TEN.Color(255,255,255), 0.8, 1)
			LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 87, 0, 40, 9, 0, 0, 2, 9)
		end
	end
	
	-- CHECK TO GO TO BAR IDLE
	if IsLaraStandingWalkingRunning() then
		-- if the player presses ACTION
		if IsKeyPulsed(Input.ActionID.ACTION, 2, 2) then
			MoveLaraToLSP(true, "lara_start_pos_1005")
			lara : SetAnim(1086)
		end
	end

	-- if lara is bar idle (anim 1087)
	if lara : GetAnim() == 1087 then
		-- play cam hint
		LevelFuncs.Engine.Node.ActivateCamera("camera_1010", "animating63_1004")
		
		if IsKeyPulsed(Input.ActionID.ARROW_DOWN, 2, 2) then
			LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 109) -- menu select
			if LevelVars.ClubMusicOption >= 11 then
				LevelVars.ClubMusicOption = 1
			else
				LevelVars.ClubMusicOption = LevelVars.ClubMusicOption + 1
			end
		elseif IsKeyPulsed(Input.ActionID.ARROW_UP, 2, 2) then
			LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 109) -- menu select
			if LevelVars.ClubMusicOption <= 1 then
				LevelVars.ClubMusicOption = 11
			else
				LevelVars.ClubMusicOption = LevelVars.ClubMusicOption - 1
			end
		elseif IsKeyPulsed(Input.ActionID.ACTION, 2, 2) then
			LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 111) -- menu select
			-- perform animation 1088 (bar end)
			lara : SetAnim(1088)
		end

		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 45, 0, 70, 90, 0, 0, 2, 9)
		LevelFuncs.Engine.Node.DrawText("SELECT A SONG", 50, 15, 1, 1, TEN.Color(255,255,255), 1.5, 1)

		-- play prompt that drink was ordered
		if LevelVars.ClubMusicOption == 1 then
			LevelFuncs.Engine.Node.DrawText("Alicia's Birthday (Clair Obscur)", 50, 25, 1, 3, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Le Serpent Rouge (Tomb Raider Angel of Darkness)", 50, 30, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Metallic Madness Act 2 (Sonic Mania)", 50, 35, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Splash Canyon (Sonic Riders)", 50, 40, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Cell (Bomberman Hero)", 50, 45, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Goblu Boss Fight But Like The Rave Part (Clair Obscur)", 50, 50, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Lara Croft - Jump (Ligu)", 50, 55, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Falling Off Ledges (ThatNorskChick2)", 50, 60, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Skidoo (Tomb Raider 2)", 50, 65, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Pusher (Tetris Effect Connected)", 50, 70, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Mercenaries - Ada (Resident Evil 4)", 50, 75, 1, 1, TEN.Color(255,255,255), 0.7, 1)
		elseif LevelVars.ClubMusicOption == 2 then
			LevelFuncs.Engine.Node.DrawText("Alicia's Birthday (Clair Obscur)", 50, 25, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Le Serpent Rouge (Tomb Raider Angel of Darkness)", 50, 30, 1, 3, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Metallic Madness Act 2 (Sonic Mania)", 50, 35, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Splash Canyon (Sonic Riders)", 50, 40, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Cell (Bomberman Hero)", 50, 45, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Goblu Boss Fight But Like The Rave Part (Clair Obscur)", 50, 50, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Lara Croft - Jump (Ligu)", 50, 55, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Falling Off Ledges (ThatNorskChick2)", 50, 60, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Skidoo (Tomb Raider 2)", 50, 65, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Pusher (Tetris Effect Connected)", 50, 70, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Mercenaries - Ada (Resident Evil 4)", 50, 75, 1, 1, TEN.Color(255,255,255), 0.7, 1)
		elseif LevelVars.ClubMusicOption == 3 then
			LevelFuncs.Engine.Node.DrawText("Alicia's Birthday (Clair Obscur)", 50, 25, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Le Serpent Rouge (Tomb Raider Angel of Darkness)", 50, 30, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Metallic Madness Act 2 (Sonic Mania)", 50, 35, 1, 3, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Splash Canyon (Sonic Riders)", 50, 40, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Cell (Bomberman Hero)", 50, 45, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Goblu Boss Fight But Like The Rave Part (Clair Obscur)", 50, 50, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Lara Croft - Jump (Ligu)", 50, 55, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Falling Off Ledges (ThatNorskChick2)", 50, 60, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Skidoo (Tomb Raider 2)", 50, 65, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Pusher (Tetris Effect Connected)", 50, 70, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Mercenaries - Ada (Resident Evil 4)", 50, 75, 1, 1, TEN.Color(255,255,255), 0.7, 1)
		elseif LevelVars.ClubMusicOption == 4 then
			LevelFuncs.Engine.Node.DrawText("Alicia's Birthday (Clair Obscur)", 50, 25, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Le Serpent Rouge (Tomb Raider Angel of Darkness)", 50, 30, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Metallic Madness Act 2 (Sonic Mania)", 50, 35, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Splash Canyon (Sonic Riders)", 50, 40, 1, 3, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Cell (Bomberman Hero)", 50, 45, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Goblu Boss Fight But Like The Rave Part (Clair Obscur)", 50, 50, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Lara Croft - Jump (Ligu)", 50, 55, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Falling Off Ledges (ThatNorskChick2)", 50, 60, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Skidoo (Tomb Raider 2)", 50, 65, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Pusher (Tetris Effect Connected)", 50, 70, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Mercenaries - Ada (Resident Evil 4)", 50, 75, 1, 1, TEN.Color(255,255,255), 0.7, 1)
		elseif LevelVars.ClubMusicOption == 5 then
			LevelFuncs.Engine.Node.DrawText("Alicia's Birthday (Clair Obscur)", 50, 25, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Le Serpent Rouge (Tomb Raider Angel of Darkness)", 50, 30, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Metallic Madness Act 2 (Sonic Mania)", 50, 35, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Splash Canyon (Sonic Riders)", 50, 40, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Cell (Bomberman Hero)", 50, 45, 1, 3, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Goblu Boss Fight But Like The Rave Part (Clair Obscur)", 50, 50, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Lara Croft - Jump (Ligu)", 50, 55, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Falling Off Ledges (ThatNorskChick2)", 50, 60, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Skidoo (Tomb Raider 2)", 50, 65, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Pusher (Tetris Effect Connected)", 50, 70, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Mercenaries - Ada (Resident Evil 4)", 50, 75, 1, 1, TEN.Color(255,255,255), 0.7, 1)
		elseif LevelVars.ClubMusicOption == 6 then
			LevelFuncs.Engine.Node.DrawText("Alicia's Birthday (Clair Obscur)", 50, 25, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Le Serpent Rouge (Tomb Raider Angel of Darkness)", 50, 30, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Metallic Madness Act 2 (Sonic Mania)", 50, 35, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Splash Canyon (Sonic Riders)", 50, 40, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Cell (Bomberman Hero)", 50, 45, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Goblu Boss Fight But Like The Rave Part (Clair Obscur)", 50, 50, 1, 3, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Lara Croft - Jump (Ligu)", 50, 55, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Falling Off Ledges (ThatNorskChick2)", 50, 60, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Skidoo (Tomb Raider 2)", 50, 65, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Pusher (Tetris Effect Connected)", 50, 70, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Mercenaries - Ada (Resident Evil 4)", 50, 75, 1, 1, TEN.Color(255,255,255), 0.7, 1)
		elseif LevelVars.ClubMusicOption == 7 then
			LevelFuncs.Engine.Node.DrawText("Alicia's Birthday (Clair Obscur)", 50, 25, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Le Serpent Rouge (Tomb Raider Angel of Darkness)", 50, 30, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Metallic Madness Act 2 (Sonic Mania)", 50, 35, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Splash Canyon (Sonic Riders)", 50, 40, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Cell (Bomberman Hero)", 50, 45, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Goblu Boss Fight But Like The Rave Part (Clair Obscur)", 50, 50, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Lara Croft - Jump (Ligu)", 50, 55, 1, 3, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Falling Off Ledges (ThatNorskChick2)", 50, 60, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Skidoo (Tomb Raider 2)", 50, 65, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Pusher (Tetris Effect Connected)", 50, 70, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Mercenaries - Ada (Resident Evil 4)", 50, 75, 1, 1, TEN.Color(255,255,255), 0.7, 1)
		elseif LevelVars.ClubMusicOption == 8 then
			LevelFuncs.Engine.Node.DrawText("Alicia's Birthday (Clair Obscur)", 50, 25, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Le Serpent Rouge (Tomb Raider Angel of Darkness)", 50, 30, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Metallic Madness Act 2 (Sonic Mania)", 50, 35, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Splash Canyon (Sonic Riders)", 50, 40, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Cell (Bomberman Hero)", 50, 45, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Goblu Boss Fight But Like The Rave Part (Clair Obscur)", 50, 50, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Lara Croft - Jump (Ligu)", 50, 55, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Falling Off Ledges (ThatNorskChick2)", 50, 60, 1, 3, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Skidoo (Tomb Raider 2)", 50, 65, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Pusher (Tetris Effect Connected)", 50, 70, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Mercenaries - Ada (Resident Evil 4)", 50, 75, 1, 1, TEN.Color(255,255,255), 0.7, 1)
		elseif LevelVars.ClubMusicOption == 9 then
			LevelFuncs.Engine.Node.DrawText("Alicia's Birthday (Clair Obscur)", 50, 25, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Le Serpent Rouge (Tomb Raider Angel of Darkness)", 50, 30, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Metallic Madness Act 2 (Sonic Mania)", 50, 35, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Splash Canyon (Sonic Riders)", 50, 40, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Cell (Bomberman Hero)", 50, 45, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Goblu Boss Fight But Like The Rave Part (Clair Obscur)", 50, 50, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Lara Croft - Jump (Ligu)", 50, 55, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Falling Off Ledges (ThatNorskChick2)", 50, 60, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Skidoo (Tomb Raider 2)", 50, 65, 1, 3, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Pusher (Tetris Effect Connected)", 50, 70, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Mercenaries - Ada (Resident Evil 4)", 50, 75, 1, 1, TEN.Color(255,255,255), 0.7, 1)
		elseif LevelVars.ClubMusicOption == 10 then
			LevelFuncs.Engine.Node.DrawText("Alicia's Birthday (Clair Obscur)", 50, 25, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Le Serpent Rouge (Tomb Raider Angel of Darkness)", 50, 30, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Metallic Madness Act 2 (Sonic Mania)", 50, 35, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Splash Canyon (Sonic Riders)", 50, 40, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Cell (Bomberman Hero)", 50, 45, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Goblu Boss Fight But Like The Rave Part (Clair Obscur)", 50, 50, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Lara Croft - Jump (Ligu)", 50, 55, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Falling Off Ledges (ThatNorskChick2)", 50, 60, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Skidoo (Tomb Raider 2)", 50, 65, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Pusher (Tetris Effect Connected)", 50, 70, 1, 3, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Mercenaries - Ada (Resident Evil 4)", 50, 75, 1, 1, TEN.Color(255,255,255), 0.7, 1)
		elseif LevelVars.ClubMusicOption == 11 then
			LevelFuncs.Engine.Node.DrawText("Alicia's Birthday (Clair Obscur)", 50, 25, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Le Serpent Rouge (Tomb Raider Angel of Darkness)", 50, 30, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Metallic Madness Act 2 (Sonic Mania)", 50, 35, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Splash Canyon (Sonic Riders)", 50, 40, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Cell (Bomberman Hero)", 50, 45, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Goblu Boss Fight But Like The Rave Part (Clair Obscur)", 50, 50, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Lara Croft - Jump (Ligu)", 50, 55, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Falling Off Ledges (ThatNorskChick2)", 50, 60, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Skidoo (Tomb Raider 2)", 50, 65, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Pusher (Tetris Effect Connected)", 50, 70, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Mercenaries - Ada (Resident Evil 4)", 50, 75, 1, 3, TEN.Color(255,255,255), 0.7, 1)
		end
	end

	-- if Lara is about to order a drink
	if lara : GetAnim() == 1086 then
		LevelFuncs.Engine.Node.ActivateCamera("camera_1010", "animating63_1004")
	end
	-- if Lara just ordered a drink
	if lara : GetAnim() == 1088 then
		LevelFuncs.Engine.Node.ActivateCamera("camera_1010", "animating63_1004")
		if lara:GetFrame() == 0 then
			LevelFuncs.ClubMusicCheck()
		end
	end
end

LevelFuncs.HeadphoneLogic = function()
	-- TEXT AND SPRITE PROMPTS
	if lara : GetAnim() == 468 then
		if LevelVars.HeadphoneMusicOption >= 1 and LevelVars.HeadphoneMusicOption <= 11 then
			LevelFuncs.Engine.Node.DrawText("Press ACTION to PLAY SONG", 50, 87, 1, 3, TEN.Color(255,255,255), 0.8, 1)
			LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 89, 0, 55, 9, 0, 0, 2, 9)
		elseif LevelVars.HeadphoneMusicOption >= 12 then
			LevelFuncs.Engine.Node.DrawText("Press ACTION to EXIT", 50, 87, 1, 3, TEN.Color(255,255,255), 0.8, 1)
			LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 89, 0, 40, 9, 0, 0, 2, 9)
		end
	end

	-- if lara is bar idle (anim 1087)
	if lara : GetAnim() == 468 then
		-- play cam hint
		-- LevelFuncs.Engine.Node.ActivateCamera("camera_1010", "animating63_1004")
		if IsKeyPulsed(Input.ActionID.ARROW_DOWN, 2, 2) then
			LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 109) -- menu select
			if LevelVars.HeadphoneMusicOption >= 12 then
				LevelVars.HeadphoneMusicOption = 1
			else
				LevelVars.HeadphoneMusicOption = LevelVars.HeadphoneMusicOption + 1
			end
		elseif IsKeyPulsed(Input.ActionID.ARROW_UP, 2, 2) then
			LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 109) -- menu select
			if LevelVars.HeadphoneMusicOption <= 1 then
				LevelVars.HeadphoneMusicOption = 12
			else
				LevelVars.HeadphoneMusicOption = LevelVars.HeadphoneMusicOption - 1
			end
		elseif IsKeyPulsed(Input.ActionID.ACTION, 2, 2) then
			LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 111) -- menu select
			-- perform animation 1088 (bar end)
			lara : SetAnim(469)
		end

		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 47, 0, 70, 100, 0, 0, 2, 9)
		LevelFuncs.Engine.Node.DrawText("SELECT A SONG", 50, 15, 1, 1, TEN.Color(255,255,255), 1.5, 1)

		-- play prompt that drink was ordered
		if LevelVars.HeadphoneMusicOption == 1 then
			LevelFuncs.Engine.Node.DrawText("The Frostlands (Octopath Traveller)", 50, 25, 1, 3, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("NYE 11:50PM (Animal Crossing New Horizons)", 50, 30, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Traverse Town (Kingdom Hearts Dream Drop Distance)", 50, 35, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Splash Canyon (Sonic Riders)", 50, 40, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Silver Snow Story (Kirby Triple Deluxe)", 50, 45, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("NYE 11:55PM (Animal Crossing New Horizons)", 50, 50, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Lara Croft - Jump (Ligu)", 50, 55, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Falling Off Ledges (ThatNorskChick2)", 50, 60, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Icy Peak (Spyro Year of the Dragon)", 50, 65, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Harbor Speedway (Spyro Year of the Dragon)", 50, 70, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Charmed Ridge (Spyro Year of the Dragon)", 50, 75, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("No Music", 50, 80, 1, 1, TEN.Color(255,255,255), 0.7, 1)
		elseif LevelVars.HeadphoneMusicOption == 2 then
			LevelFuncs.Engine.Node.DrawText("The Frostlands (Octopath Traveller)", 50, 25, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("NYE 11:50PM (Animal Crossing New Horizons)", 50, 30, 1, 3, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Traverse Town (Kingdom Hearts Dream Drop Distance)", 50, 35, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Splash Canyon (Sonic Riders)", 50, 40, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Silver Snow Story (Kirby Triple Deluxe)", 50, 45, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("NYE 11:55PM (Animal Crossing New Horizons)", 50, 50, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Lara Croft - Jump (Ligu)", 50, 55, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Falling Off Ledges (ThatNorskChick2)", 50, 60, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Icy Peak (Spyro Year of the Dragon)", 50, 65, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Harbor Speedway (Spyro Year of the Dragon)", 50, 70, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Charmed Ridge (Spyro Year of the Dragon)", 50, 75, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("No Music", 50, 80, 1, 1, TEN.Color(255,255,255), 0.7, 1)
		elseif LevelVars.HeadphoneMusicOption == 3 then
			LevelFuncs.Engine.Node.DrawText("The Frostlands (Octopath Traveller)", 50, 25, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("NYE 11:50PM (Animal Crossing New Horizons)", 50, 30, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Traverse Town (Kingdom Hearts Dream Drop Distance)", 50, 35, 1, 3, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Splash Canyon (Sonic Riders)", 50, 40, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Silver Snow Story (Kirby Triple Deluxe)", 50, 45, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("NYE 11:55PM (Animal Crossing New Horizons)", 50, 50, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Lara Croft - Jump (Ligu)", 50, 55, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Falling Off Ledges (ThatNorskChick2)", 50, 60, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Icy Peak (Spyro Year of the Dragon)", 50, 65, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Harbor Speedway (Spyro Year of the Dragon)", 50, 70, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Charmed Ridge (Spyro Year of the Dragon)", 50, 75, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("No Music", 50, 80, 1, 1, TEN.Color(255,255,255), 0.7, 1)
		elseif LevelVars.HeadphoneMusicOption == 4 then
			LevelFuncs.Engine.Node.DrawText("The Frostlands (Octopath Traveller)", 50, 25, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("NYE 11:50PM (Animal Crossing New Horizons)", 50, 30, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Traverse Town (Kingdom Hearts Dream Drop Distance)", 50, 35, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Splash Canyon (Sonic Riders)", 50, 40, 1, 3, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Silver Snow Story (Kirby Triple Deluxe)", 50, 45, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("NYE 11:55PM (Animal Crossing New Horizons)", 50, 50, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Lara Croft - Jump (Ligu)", 50, 55, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Falling Off Ledges (ThatNorskChick2)", 50, 60, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Icy Peak (Spyro Year of the Dragon)", 50, 65, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Harbor Speedway (Spyro Year of the Dragon)", 50, 70, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Charmed Ridge (Spyro Year of the Dragon)", 50, 75, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("No Music", 50, 80, 1, 1, TEN.Color(255,255,255), 0.7, 1)
		elseif LevelVars.HeadphoneMusicOption == 5 then
			LevelFuncs.Engine.Node.DrawText("The Frostlands (Octopath Traveller)", 50, 25, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("NYE 11:50PM (Animal Crossing New Horizons)", 50, 30, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Traverse Town (Kingdom Hearts Dream Drop Distance)", 50, 35, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Splash Canyon (Sonic Riders)", 50, 40, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Silver Snow Story (Kirby Triple Deluxe)", 50, 45, 1, 3, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("NYE 11:55PM (Animal Crossing New Horizons)", 50, 50, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Lara Croft - Jump (Ligu)", 50, 55, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Falling Off Ledges (ThatNorskChick2)", 50, 60, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Icy Peak (Spyro Year of the Dragon)", 50, 65, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Harbor Speedway (Spyro Year of the Dragon)", 50, 70, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Charmed Ridge (Spyro Year of the Dragon)", 50, 75, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("No Music", 50, 80, 1, 1, TEN.Color(255,255,255), 0.7, 1)
		elseif LevelVars.HeadphoneMusicOption == 6 then
			LevelFuncs.Engine.Node.DrawText("The Frostlands (Octopath Traveller)", 50, 25, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("NYE 11:50PM (Animal Crossing New Horizons)", 50, 30, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Traverse Town (Kingdom Hearts Dream Drop Distance)", 50, 35, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Splash Canyon (Sonic Riders)", 50, 40, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Silver Snow Story (Kirby Triple Deluxe)", 50, 45, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("NYE 11:55PM (Animal Crossing New Horizons)", 50, 50, 1, 3, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Lara Croft - Jump (Ligu)", 50, 55, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Falling Off Ledges (ThatNorskChick2)", 50, 60, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Icy Peak (Spyro Year of the Dragon)", 50, 65, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Harbor Speedway (Spyro Year of the Dragon)", 50, 70, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Charmed Ridge (Spyro Year of the Dragon)", 50, 75, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("No Music", 50, 80, 1, 1, TEN.Color(255,255,255), 0.7, 1)
		elseif LevelVars.HeadphoneMusicOption == 7 then
			LevelFuncs.Engine.Node.DrawText("The Frostlands (Octopath Traveller)", 50, 25, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("NYE 11:50PM (Animal Crossing New Horizons)", 50, 30, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Traverse Town (Kingdom Hearts Dream Drop Distance)", 50, 35, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Splash Canyon (Sonic Riders)", 50, 40, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Silver Snow Story (Kirby Triple Deluxe)", 50, 45, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("NYE 11:55PM (Animal Crossing New Horizons)", 50, 50, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Lara Croft - Jump (Ligu)", 50, 55, 1, 3, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Falling Off Ledges (ThatNorskChick2)", 50, 60, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Icy Peak (Spyro Year of the Dragon)", 50, 65, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Harbor Speedway (Spyro Year of the Dragon)", 50, 70, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Charmed Ridge (Spyro Year of the Dragon)", 50, 75, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("No Music", 50, 80, 1, 1, TEN.Color(255,255,255), 0.7, 1)
		elseif LevelVars.HeadphoneMusicOption == 8 then
			LevelFuncs.Engine.Node.DrawText("The Frostlands (Octopath Traveller)", 50, 25, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("NYE 11:50PM (Animal Crossing New Horizons)", 50, 30, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Traverse Town (Kingdom Hearts Dream Drop Distance)", 50, 35, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Splash Canyon (Sonic Riders)", 50, 40, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Silver Snow Story (Kirby Triple Deluxe)", 50, 45, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("NYE 11:55PM (Animal Crossing New Horizons)", 50, 50, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Lara Croft - Jump (Ligu)", 50, 55, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Falling Off Ledges (ThatNorskChick2)", 50, 60, 1, 3, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Icy Peak (Spyro Year of the Dragon)", 50, 65, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Harbor Speedway (Spyro Year of the Dragon)", 50, 70, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Charmed Ridge (Spyro Year of the Dragon)", 50, 75, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("No Music", 50, 80, 1, 1, TEN.Color(255,255,255), 0.7, 1)
		elseif LevelVars.HeadphoneMusicOption == 9 then
			LevelFuncs.Engine.Node.DrawText("The Frostlands (Octopath Traveller)", 50, 25, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("NYE 11:50PM (Animal Crossing New Horizons)", 50, 30, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Traverse Town (Kingdom Hearts Dream Drop Distance)", 50, 35, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Splash Canyon (Sonic Riders)", 50, 40, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Silver Snow Story (Kirby Triple Deluxe)", 50, 45, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("NYE 11:55PM (Animal Crossing New Horizons)", 50, 50, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Lara Croft - Jump (Ligu)", 50, 55, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Falling Off Ledges (ThatNorskChick2)", 50, 60, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Icy Peak (Spyro Year of the Dragon)", 50, 65, 1, 3, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Harbor Speedway (Spyro Year of the Dragon)", 50, 70, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Charmed Ridge (Spyro Year of the Dragon)", 50, 75, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("No Music", 50, 80, 1, 1, TEN.Color(255,255,255), 0.7, 1)
		elseif LevelVars.HeadphoneMusicOption == 10 then
			LevelFuncs.Engine.Node.DrawText("The Frostlands (Octopath Traveller)", 50, 25, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("NYE 11:50PM (Animal Crossing New Horizons)", 50, 30, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Traverse Town (Kingdom Hearts Dream Drop Distance)", 50, 35, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Splash Canyon (Sonic Riders)", 50, 40, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Silver Snow Story (Kirby Triple Deluxe)", 50, 45, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("NYE 11:55PM (Animal Crossing New Horizons)", 50, 50, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Lara Croft - Jump (Ligu)", 50, 55, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Falling Off Ledges (ThatNorskChick2)", 50, 60, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Icy Peak (Spyro Year of the Dragon)", 50, 65, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Harbor Speedway (Spyro Year of the Dragon)", 50, 70, 1, 3, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Charmed Ridge (Spyro Year of the Dragon)", 50, 75, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("No Music", 50, 80, 1, 1, TEN.Color(255,255,255), 0.7, 1)
		elseif LevelVars.HeadphoneMusicOption == 11 then
			LevelFuncs.Engine.Node.DrawText("The Frostlands (Octopath Traveller)", 50, 25, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("NYE 11:50PM (Animal Crossing New Horizons)", 50, 30, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Traverse Town (Kingdom Hearts Dream Drop Distance)", 50, 35, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Splash Canyon (Sonic Riders)", 50, 40, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Silver Snow Story (Kirby Triple Deluxe)", 50, 45, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("NYE 11:55PM (Animal Crossing New Horizons)", 50, 50, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Lara Croft - Jump (Ligu)", 50, 55, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Falling Off Ledges (ThatNorskChick2)", 50, 60, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Icy Peak (Spyro Year of the Dragon)", 50, 65, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Harbor Speedway (Spyro Year of the Dragon)", 50, 70, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Charmed Ridge (Spyro Year of the Dragon)", 50, 75, 1, 3, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("No Music", 50, 80, 1, 1, TEN.Color(255,255,255), 0.7, 1)
		elseif LevelVars.HeadphoneMusicOption == 12 then
			LevelFuncs.Engine.Node.DrawText("The Frostlands (Octopath Traveller)", 50, 25, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("NYE 11:50PM (Animal Crossing New Horizons)", 50, 30, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Traverse Town (Kingdom Hearts Dream Drop Distance)", 50, 35, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Splash Canyon (Sonic Riders)", 50, 40, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Silver Snow Story (Kirby Triple Deluxe)", 50, 45, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("NYE 11:55PM (Animal Crossing New Horizons)", 50, 50, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Lara Croft - Jump (Ligu)", 50, 55, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Falling Off Ledges (ThatNorskChick2)", 50, 60, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Icy Peak (Spyro Year of the Dragon)", 50, 65, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Harbor Speedway (Spyro Year of the Dragon)", 50, 70, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("Charmed Ridge (Spyro Year of the Dragon)", 50, 75, 1, 1, TEN.Color(255,255,255), 0.7, 1)
			LevelFuncs.Engine.Node.DrawText("No Music", 50, 80, 1, 3, TEN.Color(255,255,255), 0.7, 1)
		end
	end

	-- if Lara just ordered a drink
	if lara : GetAnim() == 469 then
		if lara:GetFrame() == 0 then
			if LevelVars.IsLaraOutside == 1 then
				LevelFuncs.HeadphoneMusicCheck()
			else
				if LevelVars.HeadphoneMusicOption <= 11 then
					LevelFuncs.Engine.Node.DrawTextForTimespan(5, 
															"THE CD PLAYER CAN ONLY \nCAN ONLY BE USED \nOUTSIDE OF THE CLUB!", 
															50, 40, 1, 1, 
															TEN.Color(255,255,255), 
															1, 1)
				end
			end
		end
	end
end

-----------------------------
-- BAR LOGIC
-----------------------------
LevelFuncs.HeyBartenderOrg = function ()
	local hey_bartender_org = EventSequence.Create(
						"hey_bartender_org", -- sequence's name
						false, -- loop
						false, -- no countdown is displayed
						0,
						LevelFuncs.BartenderHey,
						2.0,
						LevelFuncs.clearSprites
						)
	-- event sequences are inactive to begin with and so need to be started
    hey_bartender_org:Start()
end
LevelFuncs.BartenderHey = function()
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
	LevelFuncs.Engine.Node.DrawTextForTimespan(2, 
                                               "Bartender:\n  Hey Happy New Year! What can I get you?", 
                                               50, 84, 1, 1, 
                                               TEN.Color(255,255,255), 
                                               0.7, 1)
end

LevelFuncs.BartenderOrderOrg = function ()
	if LevelVars.CocktailOption >= 1 and LevelVars.CocktailOption <= 8 then
		local bartender_order_org = EventSequence.Create(
						"bartender_order_org", -- sequence's name
						false, -- loop
						false, -- no countdown is displayed
						0,
						LevelFuncs.BartenderOrder,
						1.5,
						LevelFuncs.clearSprites
						)
		-- event sequences are inactive to begin with and so need to be started
		bartender_order_org:Start()
	elseif LevelVars.CocktailOption == 9 then
		local bartender_order_org = EventSequence.Create(
						"bartender_order_org", -- sequence's name
						false, -- loop
						false, -- no countdown is displayed
						0,
						LevelFuncs.BartenderOrder,
						3.5,
						LevelFuncs.clearSprites
						)
		-- event sequences are inactive to begin with and so need to be started
		bartender_order_org:Start()
	end
end

LevelFuncs.BartenderOrder = function()
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
	-- play prompt that drink was ordered
	if LevelVars.CocktailOption >= 1 and LevelVars.CocktailOption <= 8 then
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.INTERACTION_SPRITES, 0, TEN.Color(255,255,255), 61.5, 20, 0, 3, 6, 0, 0, 2, 9)
		LevelFuncs.Engine.Node.DrawTextForTimespan(1.5, 
                                               "Bartender:\n  Here you go miss.\n Enjoy!", 
                                               50, 82.5, 1, 1, 
                                               TEN.Color(255,255,255), 
                                               0.7, 1)
	elseif LevelVars.CocktailOption == 9 then
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.INTERACTION_SPRITES, 0, TEN.Color(255,255,255), 61.75, 74.55, 0, 3, 6, 0, 0, 2, 9)
		LevelFuncs.Engine.Node.DrawTextForTimespan(3.5, 
                                               "Bartender:\n That's fine. Let me know if you change your mind!\n Drinks are on the house tonight!", 
                                               50, 82, 1, 1, 
                                               TEN.Color(255,255,255), 
                                               0.7, 1)
	end
	
end

LevelFuncs.BarLogic = function()

	-- TEXT AND SPRITE PROMPTS
	if IsLaraStandingWalkingRunning() then
		-- print a hint
		LevelFuncs.Engine.Node.DrawText("Press ACTION to REQUEST COCKTAIL", 50, 85, 1, 3, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 87, 0, 55, 9, 0, 0, 2, 9)
	elseif lara : GetAnim() == 1087 then
		if LevelVars.CocktailOption >= 1 and LevelVars.CocktailOption <= 8 then
			LevelFuncs.Engine.Node.DrawText("Press ACTION to REQUEST COCKTAIL", 50, 85, 1, 3, TEN.Color(255,255,255), 0.8, 1)
			LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 87, 0, 55, 9, 0, 0, 2, 9)
		else
			LevelFuncs.Engine.Node.DrawText("Press ACTION to EXIT", 50, 85, 1, 3, TEN.Color(255,255,255), 0.8, 1)
			LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 87, 0, 40, 9, 0, 0, 2, 9)
		end
	end
	
	-- CHECK TO GO TO BAR IDLE
	if IsLaraStandingWalkingRunning() then
		-- if the player presses ACTION
		if IsKeyPulsed(Input.ActionID.ACTION, 2, 2) then
			-- perform animation 1086 (bar start)
			MoveLaraToLSP(true, "lara_start_pos_971")
			-- play wave to bar idle
			lara : SetAnim(1085)
		end
	end

	-- if lara is bar idle (anim 1087)
	if lara : GetAnim() == 1087 then
		-- play cam hint
		LevelFuncs.Engine.Node.ActivateCamera("camera_972", "camera_target_973")
		
		if IsKeyPulsed(Input.ActionID.ARROW_DOWN, 2, 2) then
			LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 109) -- menu select
			if LevelVars.CocktailOption >= 9 then
				LevelVars.CocktailOption = 1
			else
				LevelVars.CocktailOption = LevelVars.CocktailOption + 1
			end
		elseif IsKeyPulsed(Input.ActionID.ARROW_UP, 2, 2) then
			LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 109) -- menu select
			if LevelVars.CocktailOption <= 1 then
				LevelVars.CocktailOption = 9
			else
				LevelVars.CocktailOption = LevelVars.CocktailOption - 1
			end
		elseif IsKeyPulsed(Input.ActionID.ACTION, 2, 2) then
			LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 111) -- menu select
			-- perform animation 1088 (bar end)
			lara : SetAnim(1088)
		end

		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 21, TEN.Color(255,255,255), 56, 41, 0, 40, 80, 0, 0, 2, 9)
		-- play prompt that drink was ordered
		if LevelVars.CocktailOption == 1 then
			-- LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 87, 0, 40, 9, 0, 0, 2, 9)
			LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.INTERACTION_SPRITES, 0, TEN.Color(255,255,255), 61.5, 20, 0, 3, 6, 0, 0, 2, 9)
		elseif LevelVars.CocktailOption == 2 then
			LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.INTERACTION_SPRITES, 0, TEN.Color(255,255,255), 62.25, 27, 0, 3, 6, 0, 0, 2, 9)
		elseif LevelVars.CocktailOption == 3 then
			LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.INTERACTION_SPRITES, 0, TEN.Color(255,255,255), 60.25, 33.75, 0, 3, 6, 0, 0, 2, 9)
		elseif LevelVars.CocktailOption == 4 then
			LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.INTERACTION_SPRITES, 0, TEN.Color(255,255,255), 61.75, 40.25, 0, 3, 6, 0, 0, 2, 9)
		elseif LevelVars.CocktailOption == 5 then
			LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.INTERACTION_SPRITES, 0, TEN.Color(255,255,255), 64, 46.75, 0, 3, 6, 0, 0, 2, 9)
		elseif LevelVars.CocktailOption == 6 then
			LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.INTERACTION_SPRITES, 0, TEN.Color(255,255,255), 63, 53.75, 0, 3, 6, 0, 0, 2, 9)
		elseif LevelVars.CocktailOption == 7 then
			LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.INTERACTION_SPRITES, 0, TEN.Color(255,255,255), 61.25, 60.75, 0, 3, 6, 0, 0, 2, 9)
		elseif LevelVars.CocktailOption == 8 then
			LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.INTERACTION_SPRITES, 0, TEN.Color(255,255,255), 63.5, 67.55, 0, 3, 6, 0, 0, 2, 9)
		elseif LevelVars.CocktailOption == 9 then
			LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.INTERACTION_SPRITES, 0, TEN.Color(255,255,255), 61.75, 74.55, 0, 3, 6, 0, 0, 2, 9)
		end
	end
	-- if Lara is about to order a drink
	if lara : GetAnim() == 1085 then
		if lara:GetFrame() == 0 then
			LevelFuncs.HeyBartenderOrg()
			-- play prompt to order a drink
			print("Bartender: Happy New Year, what can I get you?")
			Sound.PlayAudioTrack("031_Hey_Bartender", SoundTrackType.VOICE)
		end
	end
	-- if Lara is about to order a drink
	if lara : GetAnim() == 1086 then
		LevelFuncs.Engine.Node.ActivateCamera("camera_972", "camera_target_973")
	end
	-- if Lara just ordered a drink
	if lara : GetAnim() == 1088 then
		LevelFuncs.Engine.Node.ActivateCamera("camera_972", "camera_target_973")
		if lara:GetFrame() == 0 then
			LevelFuncs.BartenderOrderOrg()
			-- play prompt that drink was ordered
			if LevelVars.CocktailOption == 1 then
				print("Bartender: Whipped up a [INSERT DRINK] for you, miss! Enjoy!")
				LevelFuncs.Engine.Node.AddInventoryItem(TEN.Objects.ObjID.PICKUP_ITEM1, 1, true)
				Sound.PlayAudioTrack("032_here_you_go_miss", SoundTrackType.VOICE)
			elseif LevelVars.CocktailOption == 2 then
				print("Bartender: Whipped up a [INSERT DRINK] for you, miss! Enjoy!")
				LevelFuncs.Engine.Node.AddInventoryItem(TEN.Objects.ObjID.PICKUP_ITEM2, 1, true)
				Sound.PlayAudioTrack("032_here_you_go_miss", SoundTrackType.VOICE)
			elseif LevelVars.CocktailOption == 3 then
				print("Bartender: Whipped up a [INSERT DRINK] for you, miss! Enjoy!")
				LevelFuncs.Engine.Node.AddInventoryItem(TEN.Objects.ObjID.PICKUP_ITEM3, 1, true)
				Sound.PlayAudioTrack("032_here_you_go_miss", SoundTrackType.VOICE)
			elseif LevelVars.CocktailOption == 4 then
				print("Bartender: Whipped up a [INSERT DRINK] for you, miss! Enjoy!")
				LevelFuncs.Engine.Node.AddInventoryItem(TEN.Objects.ObjID.PICKUP_ITEM4, 1, true)
				Sound.PlayAudioTrack("032_here_you_go_miss", SoundTrackType.VOICE)
			elseif LevelVars.CocktailOption == 5 then
				print("Bartender: Whipped up a [INSERT DRINK] for you, miss! Enjoy!")
				LevelFuncs.Engine.Node.AddInventoryItem(TEN.Objects.ObjID.PICKUP_ITEM5, 1, true)
				Sound.PlayAudioTrack("032_here_you_go_miss", SoundTrackType.VOICE)
			elseif LevelVars.CocktailOption == 6 then
				print("Bartender: Whipped up a [INSERT DRINK] for you, miss! Enjoy!")
				LevelFuncs.Engine.Node.AddInventoryItem(TEN.Objects.ObjID.PICKUP_ITEM6, 1, true)
				Sound.PlayAudioTrack("032_here_you_go_miss", SoundTrackType.VOICE)
			elseif LevelVars.CocktailOption == 7 then
				print("Bartender: Whipped up a [INSERT DRINK] for you, miss! Enjoy!")
				LevelFuncs.Engine.Node.AddInventoryItem(TEN.Objects.ObjID.PICKUP_ITEM7, 1, true)
				Sound.PlayAudioTrack("032_here_you_go_miss", SoundTrackType.VOICE)
			elseif LevelVars.CocktailOption == 8 then
				print("Bartender: Whipped up a [INSERT DRINK] for you, miss! Enjoy!")
				LevelFuncs.Engine.Node.AddInventoryItem(TEN.Objects.ObjID.PICKUP_ITEM8, 1, true)
				Sound.PlayAudioTrack("032_here_you_go_miss", SoundTrackType.VOICE)
			elseif LevelVars.CocktailOption == 9 then
				print("Bartender: Let me know if you change your mind! Drinks are on the house tonight!")
				Sound.PlayAudioTrack("033_drink_on_house", SoundTrackType.VOICE)
			end
		end
	end
end

function DrinkGurlDrink()
	if (LevelFuncs.Engine.Node.TesttUsedItem(TEN.Objects.ObjID.PICKUP_ITEM1)) then
		
		LevelVars.NumDrinksConsumed = LevelVars.NumDrinksConsumed + 1
		HealLara()
		LevelFuncs.Engine.Node.RemoveInventoryItem(TEN.Objects.ObjID.PICKUP_ITEM1, 1)
	end
	if (LevelFuncs.Engine.Node.TesttUsedItem(TEN.Objects.ObjID.PICKUP_ITEM2)) then
		
		LevelVars.NumDrinksConsumed = LevelVars.NumDrinksConsumed + 1
		HealLara()
		LevelFuncs.Engine.Node.RemoveInventoryItem(TEN.Objects.ObjID.PICKUP_ITEM2, 1)
	end
	if (LevelFuncs.Engine.Node.TesttUsedItem(TEN.Objects.ObjID.PICKUP_ITEM3)) then
		
		LevelVars.NumDrinksConsumed = LevelVars.NumDrinksConsumed + 1
		HealLara()
		LevelFuncs.Engine.Node.RemoveInventoryItem(TEN.Objects.ObjID.PICKUP_ITEM3, 1)
	end
	if (LevelFuncs.Engine.Node.TesttUsedItem(TEN.Objects.ObjID.PICKUP_ITEM4)) then
		
		LevelVars.NumDrinksConsumed = LevelVars.NumDrinksConsumed + 1
		HealLara()
		LevelFuncs.Engine.Node.RemoveInventoryItem(TEN.Objects.ObjID.PICKUP_ITEM4, 1)
	end
	if (LevelFuncs.Engine.Node.TesttUsedItem(TEN.Objects.ObjID.PICKUP_ITEM5)) then
		
		LevelVars.NumDrinksConsumed = LevelVars.NumDrinksConsumed + 1
		HealLara()
		LevelFuncs.Engine.Node.RemoveInventoryItem(TEN.Objects.ObjID.PICKUP_ITEM5, 1)
	end
	if (LevelFuncs.Engine.Node.TesttUsedItem(TEN.Objects.ObjID.PICKUP_ITEM6)) then
		
		LevelVars.NumDrinksConsumed = LevelVars.NumDrinksConsumed + 1
		HealLara()
		LevelFuncs.Engine.Node.RemoveInventoryItem(TEN.Objects.ObjID.PICKUP_ITEM6, 1)
	end
	if (LevelFuncs.Engine.Node.TesttUsedItem(TEN.Objects.ObjID.PICKUP_ITEM7)) then
		
		LevelVars.NumDrinksConsumed = LevelVars.NumDrinksConsumed + 1
		HealLara()
		LevelFuncs.Engine.Node.RemoveInventoryItem(TEN.Objects.ObjID.PICKUP_ITEM7, 1)
	end
	if (LevelFuncs.Engine.Node.TesttUsedItem(TEN.Objects.ObjID.PICKUP_ITEM8)) then
		LevelVars.NumDrinksConsumed = LevelVars.NumDrinksConsumed + 1
		HealLara()
		LevelFuncs.Engine.Node.RemoveInventoryItem(TEN.Objects.ObjID.PICKUP_ITEM8, 1)
	end
	if (LevelFuncs.Engine.Node.TesttUsedItem(TEN.Objects.ObjID.PICKUP_ITEM9)) then
		EatLara()
		LevelFuncs.Engine.Node.RemoveInventoryItem(TEN.Objects.ObjID.PICKUP_ITEM9, 1)
	end
	-- radio
	if (LevelFuncs.Engine.Node.TesttUsedItem(TEN.Objects.ObjID.PUZZLE_ITEM1)) then
		if IsLaraStandingWalkingRunning() then
			lara:SetAnim(467)
		else
			LevelFuncs.Engine.Node.DrawTextForTimespan(5.0, 
                                               "CAN ONLY USE CD PLAYER \nWHILE STANDING OR RUNNING!", 
                                               50, 47, 1, 1, 
                                               TEN.Color(255,255,255), 
                                               1.0, 1)
		end
	end
end

function HealLara()
	LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 1164)
	--LevelFuncs.Engine.Node.FlashScreen(TEN.Color(128,255,255), 1)
	LevelFuncs.Engine.Node.FlashScreen(TEN.Color(0,255,0), 1)
	-- set hp to 100%
	Lara:SetHP(32767)

	-- Give Lara Champagne Glass
	LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 13, TEN.Objects.ObjID.LARA_SPEECH_HEAD1, 13)

	if IsLaraStandingWalkingRunning() then
		if LevelVars.NumDrinksConsumed > 2 then
			lara:SetAnim(1093)
		else
			lara:SetAnim(1092)
		end
	end
	
end

function EatLara()
	LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 1164)
	--LevelFuncs.Engine.Node.FlashScreen(TEN.Color(128,255,255), 1)
	LevelFuncs.Engine.Node.FlashScreen(TEN.Color(0,255,0), 1)
	-- set hp to 100%
	Lara:SetHP(32767)
end

-----------------------------
-- SHOOTING STAR GLOW
-----------------------------
function ShootingStarEffects()
	local shootingStarSlots = {
        ObjID.ANIMATING34
    }
	-- init empty list of all interactive items
	local interactiveObjects = {}
	local numEntries = 0
	-- for all moveable slots
	for index, shootingStarSlot in pairs(shootingStarSlots) do
		-- get the associated moveables for that slot
        local shootingStarObjs = GetMoveablesBySlot(shootingStarSlot)
		-- get length of table
		local numEntriesForSlot = #shootingStarObjs
		if numEntriesForSlot > 0 then
			-- append table of elements over to interactiveObjects
			table.move(shootingStarObjs, 1, numEntriesForSlot, #interactiveObjects+1, interactiveObjects)
			numEntries = numEntries + numEntriesForSlot
		end
	end
	-- parse through all the moveables in
	for index, currObj in pairs(interactiveObjects) do
		if currObj:GetActive() then
			-- apply the effect
			ShootingStarGlow(currObj:GetName())

			-- do the distance check logic
			-- print(currObj:GetName())
			local shootingStarPosition = currObj:GetPosition()
			local laraPosition = lara:GetPosition()
			local distanceFromLara = math.abs(laraPosition:Distance(shootingStarPosition))
			-- if lara is near the hole 650.0
			if distanceFromLara <= 500.0 and IsLaraStandingWalkingRunning() then
				-- FULL TEXT PROMPT
				LevelFuncs.Engine.Node.DrawText("Press ACTION to Claim Shooting Star Fragment", 50, 84, 1, 3, TEN.Color(255,255,255), 1, 1)
				LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 87, 0, 80, 9, 0, 0, 2, 9)
				-- -- AOD HAND
				-- LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.INTERACTION_SPRITES, 0, TEN.Color(255,255,255), 90, 90, 0, 5, 8, 0, 0, 2, 9)
				if Input.IsKeyPulsed(ActionID.ACTION, 5, 5) and LevelVars.canPulse == true then
					LevelVars.canPulse = false
					LevelFuncs.ClaimingShootingStarOrg(currObj:GetName())
				end
			end
		end
	end
end

function IsLaraStandingWalkingRunning()
	if Lara:GetAnim() == 103 or 
		(Lara:GetAnim() >= 0 and Lara:GetAnim() <= 13) or
		(Lara:GetAnim() >= 20 and Lara:GetAnim() <= 21) or 
		(Lara:GetAnim() >= 38 and Lara:GetAnim() <= 41) or
		(lara:GetAnim() == 984 or lara:GetAnim() == 985) or
	    (lara:GetAnim() == 1025 and lara:GetAnim() == 1029) then
		return true
	else
		return false
	end
end

function ShootingStarGlow(star_moveable_name)
    local shooting_star = Objects.GetMoveableByName(star_moveable_name)
    if shooting_star:GetActive() then
        LevelFuncs.Engine.Node.ParticleEmitter(star_moveable_name, 
                                                0, 0, 
                                                TEN.Vec3(0,0,0), 
                                                0, 0, 
                                                TEN.Color(255,255,0), 
                                                TEN.Color(255,128,64), 
                                                2, 150, 100, 0.5, false, false)
		LevelFuncs.Engine.Node.MoveableLight(star_moveable_name, 0, TEN.Color(255,242,0), 6, TEN.Vec3(0.1,0.1,0.1), true, "")
    end
end

LevelFuncs.ClaimingShootingStarOrg = function(shooting_star_name)
    local shooting_shooting_star_org = EventSequence.Create
	(
    	"shooting_shooting_star_org", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.
    	0.0, -- I made an enumerator for this so I don't have to change all manually
    	LevelFuncs.LaraShatterOrbStart,
		2.0,
		{LevelFuncs.ShatterShootingStar, shooting_star_name},
		2.0,
		LevelFuncs.ResetCanPulse
    )

   -- last : now we have created the Event Sequence: you must Start it:
    shooting_shooting_star_org:Start()
end	


LevelFuncs.LaraShatterOrbStart = function()
    lara:SetAnim(1071)
end

LevelFuncs.ShatterShootingStar = function(shooting_star_name)
    local shooting_star = Objects.GetMoveableByName(shooting_star_name)
    LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 1165)
    shooting_star:Shatter()
    shooting_star:Disable()
    shooting_star:Destroy()
	LevelFuncs.Engine.Node.AddInventoryItem(TEN.Objects.ObjID.PUZZLE_ITEM2, 1, true)
	LevelFuncs.EnableStarCounter()
end

LevelFuncs.ResetCanPulse = function ()
	LevelVars.canPulse = true
end

function FreezeWinston(winston_name)
	LevelFuncs.Engine.Node.FlashScreen(TEN.Color(255,255,0), 1)
	for i = 0,25,1
	do
		LevelFuncs.Engine.Node.SwapMoveableMesh(winston_name, i, TEN.Objects.ObjID.ANIMATING50, i)
	end 
end

function ShowStarCounter()
    local weaponType = " "
    local ammoCounterPosX = 100 -- X Position of counter.
    local ammoCounterPosY = 300 -- Y Position of counter.
    local holdWeapon = Lara:GetHandStatus() -- Check Lara's hand status.
    local ammoCounterColor = Color(255, 255, 255) 
    local ammoMessage = DisplayString(
    "Ammo: ".. Lara:GetHandStatus(), 100,
    300, Color(255, 255, 255))

	if LevelVars.CanShowStarCounter == true then
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 17, TEN.Color(255,255,255), 5, 12, 0, 12, 7, 0, 0, 0, 9)
		if (Inventory.GetItemCount(ObjID.PUZZLE_ITEM2) == -1) then
			LevelFuncs.Engine.Node.DrawText("Unlimited", 9, 10, 0, 3, TEN.Color(255,255,255), 0.8)
		else
			LevelFuncs.Engine.Node.DrawText(""..Inventory.GetItemCount(ObjID.PUZZLE_ITEM2).."/"..tostring(LevelVars.TotalStars), 9, 10, 0, 1, TEN.Color(255,255,255), 0.8)
		end
	else
		HideString(ammoMessage)
	end
end

-----------------------------
-- INTRO CLUB CUTSCENE
-----------------------------
LevelFuncs.IntroClubCutOrg = function ()
    local intro_club_cut_org = EventSequence.Create

	(
    	"intro_club_cut_org", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.
    	0.0, -- I made an enumerator for this so I don't have to change all manually
    	LevelFuncs.ClubCutFlyby1,
		4.0,
		LevelFuncs.ClubCutFlyby2,
		3.5,
		LevelFuncs.PlayClubAmbience,
		3,
		LevelFuncs.ClubCutFlyby3,
		7,
		LevelFuncs.CutFadeOut,
		1.5,
		LevelFuncs.ClubCutFlyby4,
		0.5,
		LevelFuncs.CutFadeIn,
		3.5,
		LevelFuncs.ClubCutFlyby4_5,
		3.5,
		LevelFuncs.ClubCutFlyby5,
		9,
		LevelFuncs.clearSprites,
		0.5,
		LevelFuncs.ClubCutFlyby6,
		5,
		LevelFuncs.ClubCutFlyby7,
		5,
		LevelFuncs.ClubCutFlyby8,
		3,
		LevelFuncs.ClubCutFlyby9,
		3,
		LevelFuncs.ClubCutFlyby10
    )

   -- last : now we have created the Event Sequence: you must Start it:
    intro_club_cut_org:Start()
end

LevelFuncs.ClubCutFlyby1 = function ()
	LevelFuncs.Engine.Node.SetStaticCollisionStatus(false, "static_mesh_324")
	MoveLaraToLSP(true, "lara_start_pos_246")
	LevelFuncs.Engine.Node.PlayFlyBy(1)
	Sound.PlayAudioTrack("052_lower", SoundTrackType.ONESHOT)
	-- Club Idle
	Lara:SetAnim(1080)
	-- Give Lara Champagne Glass
	LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 13, TEN.Objects.ObjID.LARA_SPEECH_HEAD1, 13)

	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 2)
	
end

LevelFuncs.ClubCutFlyby2 = function ()
	LevelFuncs.Engine.Node.SetMoveableAnimation("animating20_246", 32)
	Lara:SetAnim(1081)
	LevelFuncs.Engine.Node.PlayFlyBy(2)
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 3)
	
end

LevelFuncs.PlayClubAmbience = function ()
	-- Sound.PlayAudioTrack("050", SoundTrackType.LOOPED)
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 0)
end

LevelFuncs.ClubCutFlyby3 = function ()
	LevelFuncs.Engine.Node.PlayFlyBy(9)
	Lara:SetAnim(1083)
	-- LevelFuncs.Engine.Node.SetStaticCollisionStatus(true, "static_mesh_324")
	Sound.PlayAudioTrack("027_Sorrytobutleryou", SoundTrackType.VOICE)
	LevelFuncs.Engine.Node.DrawTextForTimespan(9, 
                                               "Winston:\n Ms Croft... may I invite you to step outside for a moment?\n You might be interested in coming outside!", 
                                               50, 82, 1, 1, 
                                               TEN.Color(255,255,255), 
                                               0.7, 1)
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
end

-- show lara chilling outside with winston
LevelFuncs.ClubCutFlyby4 = function ()
	LevelFuncs.Engine.Node.SetStaticCollisionStatus(true, "static_mesh_324")
	MoveLaraToLSP(true, "lara_start_pos_493")
	Lara:SetAnim(1080)
	LevelFuncs.Engine.Node.PlayFlyBy(5)
	LevelFuncs.Engine.Node.SetMoveableVisibility("animating38_523", 1)
	Sound.PlayAudioTrack("030_STARS", SoundTrackType.VOICE)
	LevelFuncs.Engine.Node.DrawTextForTimespan(3.7, 
                                               "Lara Croft:\n  The stars look beautiful tonight! \nThank you Winston!", 
                                               50, 82, 1, 1, 
                                               TEN.Color(255,255,255), 
                                               0.7, 1)
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
end

LevelFuncs.ClubCutFlyby4_5 = function()
	Sound.PlayAudioTrack("028_WINSTON_PLEASE", SoundTrackType.VOICE)
	LevelFuncs.Engine.Node.PlayFlyBy(8)
	LevelFuncs.Engine.Node.SetStarField(50, -- star count 
										20, -- meteor count
										100, -- meteor spawn density
										15) -- meteor velocity
	LevelFuncs.Engine.Node.DrawTextForTimespan(3.4, 
                                               "Lara Croft:\n  Look Winston! A shooting star!\n Quick! Make a...", 
                                               50, 82, 1, 1, 
                                               TEN.Color(255,255,255), 
                                               0.7, 1)
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
end

-- freeze winston cam
LevelFuncs.ClubCutFlyby5 = function ()
	-- -- TITLE CARD
    -- LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 0)
	MoveLaraToLSP(true, "lara_start_pos_492")
	Lara:SetAnim(1079)
	LevelFuncs.Engine.Node.PlayFlyBy(6)
	FreezeWinston("winston_obj")
	LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 1161)
	LevelFuncs.Engine.Node.DrawTextForTimespan(9, 
                                               "Lara Croft:\n  ...wish. I should have seen that coming...\n I guess I know what I'm wishing for...", 
                                               50, 82, 1, 1, 
                                               TEN.Color(255,255,255), 
                                               0.7, 1)
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
end

-- shabaobab presents cam
LevelFuncs.ClubCutFlyby6 = function ()
	-- -- TITLE CARD
    -- LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 0)
	LevelFuncs.Engine.Node.PlayFlyBy(13)
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 5)
	-- LevelFuncs.Engine.Node.DrawTextForTimespan(5, 
    --                                            "The 2025 Tomb Raider Community Advent Calendar presents...", 
    --                                            50, 50, 1, 1, 
    --                                            TEN.Color(255,255,255), 
    --                                            1.0, 1)
end

-- title card  cam
LevelFuncs.ClubCutFlyby7 = function ()
	LevelFuncs.Engine.Node.PlayFlyBy(14)
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 4) -- TITLE CARD
end

LevelFuncs.ClubCutFlyby8 = function()
	LevelFuncs.EnableStarCounter()
	LevelFuncs.Engine.Node.PlayFlyBy(15)
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 0)
	LevelFuncs.Engine.Node.DrawTextForTimespan(9, 
                                               "Collect all the \nShooting Star Fragments\nto make a wish powerful enough\nto free Winston from\nhis frozen state!", 
                                               50, 35, 1, 1, 
                                               TEN.Color(255,255,255), 
                                               1.0, 1)
end

LevelFuncs.EnableStarCounter = function()
	-- -- TITLE CARD
	LevelVars.CanShowStarCounter = true
	LevelVars.ShowWinstonPrompt = true
	SetSoftCollisionToAllStatics()
end

-- title card  cam
LevelFuncs.ClubCutFlyby9 = function ()
	LevelFuncs.Engine.Node.PlayFlyBy(16)
end

LevelFuncs.ClubCutFlyby10 = function ()
	LevelFuncs.Engine.Node.PlayFlyBy(17)
end
-----------------------------
-- DANCE FLOOR CUTSCENE
-----------------------------
LevelFuncs.DanceFloorCheck = function()
	if IsLaraStandingWalkingRunning() then
		LevelFuncs.Engine.Node.DrawText("Press ACTION to DANCE", 50, 84, 1, 3, TEN.Color(255,255,255), 1, 1)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 87, 0, 55, 9, 0, 0, 2, 9)
		if (IsKeyPulsed(Input.ActionID.ACTION, 2, 2)) then
			LevelFuncs.Engine.Node.RunLuaScript(LevelFuncs.DanceFloorOrg, "")
		end
	end
end

LevelFuncs.DanceFloorOrg = function ()
    local dance_floor_org = EventSequence.Create
	(
    	"dance_floor_org", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.
    	0.0, -- I made an enumerator for this so I don't have to change all manually
		LevelFuncs.CutFadeOut,
		1.5,
    	LevelFuncs.DanceFloorOrg1,
		0.5,
		LevelFuncs.CutFadeIn,
		18.5,
		LevelFuncs.CutFadeOut,
		1.5,
		LevelFuncs.DanceFloorOrg2,
		0.5,
		LevelFuncs.CutFadeIn
    )
   -- last : now we have created the Event Sequence: you must Start it:
    dance_floor_org:Start()
end

LevelFuncs.DanceFloorOrg1 = function ()
	MoveLaraToLSP(true, "lara_start_pos_247")
	local danceAnimIDs = {}

	danceAnimIDs = {1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	                1094, 1094, 1094, 
					1096, 1097}

	local randomDanceAnim = danceAnimIDs[math.random(1, #danceAnimIDs)]
	
	Lara:SetAnim(randomDanceAnim)
	-- Lara:SetAnim(1082)
	LevelFuncs.Engine.Node.PlayFlyBy(3)
end
LevelFuncs.DanceFloorOrg2 = function ()
	Lara:SetAnim(103)
end
-----------------------------
-- HELPER CUTSCENE FUNCTIONS
-----------------------------
LevelFuncs.CutFadeOut = function()
	FadeOut(1.0); 
end;

LevelFuncs.CutFadeIn = function()
	FadeIn(1.5);
end;

function MoveLaraToLSP(with_rotation, target_LSP_name)
    LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(with_rotation, 
                                                                lara_name, 
                                                                target_LSP_name)
end

LevelFuncs.clearSprites = function()
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 0)
end
-----------------------------
-- SLEEPY EEPY EVENT
-----------------------------
LevelFuncs.SleepyEepyCheck = function ()
	print("CHECKING")
	if LevelFuncs.Engine.Node.SoundIsPlaying(1165) then
		print("DOING THE THING")
		LevelFuncs.SleepyEepyOrg()
	end
end

LevelFuncs.SleepyEepyOrg = function ()
	local sleepy_eepy_org = EventSequence.Create(
						"sleepy_eepy_org", -- sequence's name
						false, -- loop
						false, -- no countdown is displayed
						0,
						LevelFuncs.SleepyEepy1, 
						0.5, 
						LevelFuncs.SleepyEepy2,
						2.5,
						LevelFuncs.SleepyEepy3,
						2.2,
						LevelFuncs.SleepyEepy4,
						2.2,
						LevelFuncs.SleepyEepy5
						)
	-- event sequences are inactive to begin with and so need to be started
    sleepy_eepy_org:Start()
end
LevelFuncs.SleepyEepy1 = function()
	LevelFuncs.Engine.Node.PlayFlyBy(11)
	LevelFuncs.Engine.Node.EnableMoveable("animating36_330", 0)
	Sound.StopAudioTrack(SoundTrackType.ONESHOT)
	Sound.StopAudioTrack(SoundTrackType.LOOPED)
	Sound.PlayAudioTrack("029_OH_FFS_NAUR", SoundTrackType.VOICE)
	Sound.PlayAudioTrack("110", SoundTrackType.LOOPED)
end

LevelFuncs.SleepyEepy2 = function()
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
	LevelFuncs.Engine.Node.DrawTextForTimespan(2.5, 
                                               "Sleepy Eepy Guy:\n  Eugh! Oh! Wait did I miss the new year already?!", 
                                               50, 82, 1, 1, 
                                               TEN.Color(255,255,255), 
                                               0.7, 1)
end

LevelFuncs.SleepyEepy3 = function()
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
	LevelFuncs.Engine.Node.DrawTextForTimespan(2.2, 
                                               "Sleepy Eepy Guy:\n  Ugh! Dang it! Man... Not again...", 
                                               50, 82, 1, 1, 
                                               TEN.Color(255,255,255), 
                                               0.7, 1)
end

LevelFuncs.SleepyEepy4 = function()
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
	LevelFuncs.Engine.Node.DrawTextForTimespan(2.2, 
                                               "Sleepy Eepy Guy:\n  At least it's nice outside...", 
                                               50, 82, 1, 1, 
                                               TEN.Color(255,255,255), 
                                               0.7, 1)
end

LevelFuncs.SleepyEepy5 = function()
	LevelFuncs.ClubMusicCheck()
	LevelFuncs.clearSprites()
end

----------------
--- BLINKING ---
----------------
LevelFuncs.BlinkOrganizer = function ()
	local lara_blink_org = EventSequence.Create(
						"lara_blink_org", -- sequence's name
						true, -- loop
						false, -- no countdown is displayed
						0,
						LevelFuncs.BlinkOff, 
						3, 
						LevelFuncs.BlinkOn,
						1,
						LevelFuncs.BlinkOff
						)
	-- event sequences are inactive to begin with and so need to be started
    lara_blink_org:Start()
end

LevelFuncs.BlinkOn = function ()
	LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 14, TEN.Objects.ObjID.LARA_SPEECH_HEAD1, 14)
	print("BLINKING ON")
end
LevelFuncs.BlinkOff = function ()
	LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 14, TEN.Objects.ObjID.LARA_SKIN, 14)
	print("BLINKING OFF")
end

----------------------
--- SNOWBALL LOGIC ---
----------------------
function EquipSnowBall()
	ShowSnowballCounter()
	if (Inventory.GetItemCount(ObjID.PUZZLE_ITEM9) >= 1) then
		if Input.IsKeyPulsed(Input.ActionID.DRAW, 3, 2) then
			if (Lara:GetAnim() >= 0 and Lara:GetAnim() <= 13) or Lara:GetAnim() == 103 then
				LevelFuncs.DrawSnowballOrganizer()
			else
				-- play draw sound
				LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 6)
				LevelFuncs.SwapSnowMesh()
			end
		end
	else
		LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 10, TEN.Objects.ObjID.LARA_SKIN, 10)
		LevelVars.IsSnowBallEquipped = false
	end
	-- if Lara:GetHandStatus() == Objects.HandStatus.WEAPON_DRAW then
	-- 	LevelVars.IsSnowBallEquipped = false
	-- end
end

LevelFuncs.PlayDrawSnowballAnim = function()
	Lara:SetAnim(1076)
end

LevelFuncs.SwapSnowMesh = function()
	if LevelVars.IsSnowBallEquipped == true then
		LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 10, TEN.Objects.ObjID.LARA_SKIN, 10)
		LevelVars.IsSnowBallEquipped = false
	else
		LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 10, TEN.Objects.ObjID.LARA_SPEECH_HEAD1, 10)
		LevelVars.IsSnowBallEquipped = true
	end
end

LevelFuncs.DrawSnowballOrganizer = function()
	local draw_snowball = EventSequence.Create(
						"draw_snowball", -- sequence's name
						false, -- loop
						false, -- no countdown is displayed
						0,
						LevelFuncs.PlayDrawSnowballAnim, 
						0.3, 
						LevelFuncs.SwapSnowMesh
						)
	-- event sequences are inactive to begin with and so need to be started
    draw_snowball:Start()
end

function FreezeBaddy(baddy_name)
	LevelFuncs.Engine.Node.FlashScreen(TEN.Color(128,255,255), 1)
	for i = 0,25,1
	do
		LevelFuncs.Engine.Node.SwapMoveableMesh(baddy_name, i, TEN.Objects.ObjID.ACTOR1_SPEECH_HEAD1, i)
	end 
end

function ShowSnowballCounter()
    local weaponType = " "
    local ammoCounterPosX = 100 -- X Position of counter.
    local ammoCounterPosY = 300 -- Y Position of counter.
    local holdWeapon = Lara:GetHandStatus() -- Check Lara's hand status.
    local ammoCounterColor = Color(255, 255, 255) 
    local ammoMessage = DisplayString(
    "Ammo: ".. Lara:GetHandStatus(), 100,
    300, Color(255, 255, 255))

	if LevelVars.IsSnowBallEquipped == true then
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 16, TEN.Color(255,255,255), 5, 12, 0, 12, 7, 0, 0, 0, 9)
		if (Inventory.GetItemCount(ObjID.PUZZLE_ITEM9) == -1) then
			LevelFuncs.Engine.Node.DrawText("Unlimited", 9, 10, 0, 3, TEN.Color(255,255,255), 0.8)
		else
			LevelFuncs.Engine.Node.DrawText(""..Inventory.GetItemCount(ObjID.PUZZLE_ITEM9), 9, 10, 0, 3, TEN.Color(255,255,255), 0.8)
		end
	else
		HideString(ammoMessage)
	end
end


-------------------------------
--- KNOCK OUT BADDIES BEGIN ---
-------------------------------
local canPulseAgain = true
function Knock_Out_Baddy(baddy_name, moveableSlot)
	-- if enemy is within 128 units of Lara
	local baddyObj = TEN.Objects.GetMoveableByName(baddy_name)
	local baddyPosition = TEN.Objects.GetMoveableByName(baddy_name):GetPosition()
	local laraPosition = TEN.Objects.GetMoveableByName("LARA_MAIN"):GetPosition()
	local distanceFromLara = math.abs(laraPosition:Distance(baddyPosition))
	
	if distanceFromLara <= 256.0 and baddyObj:GetActive() then
		--print("distance : " .. distanceFromLara)
		-- SPRINT SLIDE KNOCKOUT LOGIC
		-- if lara is performing a sprint slide
		-- if (LevelFuncs.Engine.Node.TestMoveableAnimation("LARA_MAIN", 956) or LevelFuncs.Engine.Node.TestMoveableAnimation("LARA_MAIN", 957)) then
		if (lara:GetAnim() == 956 or lara:GetAnim() == 957) and distanceFromLara <= 150.0 then
			SetBaddyKnockoutAnim(moveableSlot, baddy_name, 0)
		-- else use kick mechanics
		else
			-- KNEE AND TWIST KICK LOGIC
			print("distance : " .. distanceFromLara)
			if Input.IsKeyPulsed(Input.ActionID.ACTION, 3, 2) and canPulseAgain == true and
			   LevelFuncs.Engine.Node.TestLaraVehicle() == false then -- and lara is not on a vehicle
				canPulseAgain = false
				local attackAnimIDs = {}

				-- Get the random attack anim for Lara
				if Lara:GetHandStatus() == Objects.HandStatus.WEAPON_DRAW or Lara:GetHandStatus() == Objects.HandStatus.WEAPON_READY then
					attackAnimIDs = {976} -- 976, 1005, 1003
				else
					attackAnimIDs = {977, 976, 1005} -- 1006
				end

				if LevelVars.IsSnowBallEquipped == true then
					attackAnimIDs = {1075}
				end

				local randomAttackAnim = attackAnimIDs[math.random(1, #attackAnimIDs)]

				if moveableSlot == ObjID.DOG then
					randomAttackAnim = 1006
				end

				if moveableSlot == ObjID.SMALL_SCORPION then
					randomAttackAnim = 1003
					LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 1162)
				end

				lara : SetAnim(randomAttackAnim)
				LevelFuncs.LaraKickOrganizer(moveableSlot, baddy_name, randomAttackAnim)
			end
		end
	end
end

function SetBaddyKnockoutAnim(moveableSlot, baddy_name, laraAttackAnim)
	baddy_obj = Objects.GetMoveableByName(baddy_name)
	-- determine the knock out anim based off the moveable slot
	if moveableSlot == ObjID.SAS_CAIRO then -- SAS

		defenseAnimIDs = {23, 23, 23, 26}
		randomDefenseAnim = defenseAnimIDs[math.random(1, #defenseAnimIDs)]

		-- if lara does a low kick or a pistol kick
		if laraAttackAnim == 1006 or laraAttackAnim == 1005 then
			-- do a defense anim
			LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 26)
		else
			-- do the fall back anim
			LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 23)
		end

	elseif moveableSlot == ObjID.FLAMETHROWER_BADDY then -- flamethrower
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 24)
	elseif moveableSlot == ObjID.MP_WITH_GUN then -- mp with gun
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 39)
	elseif moveableSlot == ObjID.TRIBESMAN_WITH_AX then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 31)
	elseif moveableSlot == ObjID.DOG then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 25)
	elseif moveableSlot == ObjID.MP_WITH_STICK then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 35)
	elseif moveableSlot == ObjID.CIVVY then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 35)
	elseif moveableSlot == ObjID.MUMMY then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 74)
	elseif moveableSlot == ObjID.YETI then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 38)

	elseif moveableSlot == ObjID.MERCENARY_UZI then 
		-- if lara is using enchanted snowball
		if laraAttackAnim == 1075 then
			LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 36)
			FreezeBaddy(baddy_name)
			-- LevelFuncs.Engine.Node.ChangeMoveableColourOverTimespan(baddy_name, TEN.Color(183,255,255), 1.5)
		else

			-- if baddy is frozen
			if baddy_obj:GetAnim() == 36 then
				print("HES FROZEN!")
				-- shatter moveable
				LevelFuncs.Engine.Node.ShatterMoveable(baddy_name)
				baddy_obj:Destroy()
				-- play shatter sound
				LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 347)
				LevelFuncs.Engine.Node.FlashScreen(TEN.Color(128,255,255), 1)
			end

			-- if lara does a knee attack or a groin kick
			if laraAttackAnim == 1005 then
				-- do a knee groin attacked anim
				LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 30)
			else
				-- do the fall back anim
				LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 33)
			end

		end

	elseif moveableSlot == ObjID.MERCENARY_AUTOPISTOLS1 then 
		-- if lara is using enchanted snowball
		if laraAttackAnim == 1075 then
			LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 34)
			FreezeBaddy(baddy_name)
			-- LevelFuncs.Engine.Node.ChangeMoveableColourOverTimespan(baddy_name, TEN.Color(183,255,255), 1.5)
		else
			
			-- if baddy is frozen
			if baddy_obj:GetAnim() == 34 then
				print("HES FROZEN!")
				-- shatter moveable
				LevelFuncs.Engine.Node.ShatterMoveable(baddy_name)
				baddy_obj:Destroy()
				-- play shatter sound
				LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 347)
				LevelFuncs.Engine.Node.FlashScreen(TEN.Color(128,255,255), 1)
			end

			-- if lara does a low kick or a pistol kick
			if laraAttackAnim == 1005 then
				LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 28)
			else
				-- do the fall back anim
				LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 31)
			end

			
		end

	elseif moveableSlot == ObjID.BADDY2 then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 71)

	elseif moveableSlot == ObjID.SMALL_SCORPION then
		local new_splat_name = "splat_EW_" .. tostring(LevelVars.SplatCounter)
		LevelVars.SplatCounter = LevelVars.SplatCounter + 1
		local spider_position = baddy_obj:GetPosition()
		local new_splat = Moveable(TEN.Objects.ObjID.ANIMATING10, -- object id
								  new_splat_name, -- name
								  spider_position) -- position
		LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, 
                                                                new_splat_name, 
                                                                baddy_name)
		-- shatter moveable
		LevelFuncs.Engine.Node.ShatterMoveable(baddy_name)
		baddy_obj:Destroy()
		LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 1163)
	end
end

LevelFuncs.LaraKickOrganizer = function(moveableSlot, baddy_name, laraAttackAnim)
	local attack_org = EventSequence.Create(
						"attack_org", -- sequence's name
						false, -- loop
						false, -- no countdown is displayed
						0.4,
						{LevelFuncs.KickAManBecauseItsWhatHeDeservesBINCH, moveableSlot, baddy_name, laraAttackAnim}, 
						0.9, 
						LevelFuncs.RestoreLaraWeaponStatus,
						0.01,
						LevelFuncs.RestoreLaraAnim
						)
	-- event sequences are inactive to begin with and so need to be started
    attack_org:Start()
end

LevelFuncs.KickAManBecauseItsWhatHeDeservesBINCH = function(moveableSlot, baddy_name, laraAttackAnim)
	SetBaddyKnockoutAnim(moveableSlot, baddy_name, laraAttackAnim)
end

LevelFuncs.RestoreLaraWeaponStatus = function()
	if Lara:GetHandStatus() == Objects.HandStatus.WEAPON_DRAW or Lara:GetHandStatus() == Objects.HandStatus.WEAPON_READY then
		-- init weaponLaraSlot
		local weaponLaraSlot = 0
		if Lara:GetWeaponType() == Objects.WeaponType.PISTOLS then
			weaponLaraSlot = 2
		elseif Lara:GetWeaponType() == Objects.WeaponType.UZIS then
			weaponLaraSlot = 3
		elseif Lara:GetWeaponType() == Objects.WeaponType.SHOTGUN then
			weaponLaraSlot = 4
		elseif Lara:GetWeaponType() == Objects.WeaponType.REVOLVER then
			weaponLaraSlot = 5
		elseif Lara:GetWeaponType() == Objects.WeaponType.CROSSBOW then
			weaponLaraSlot = 6
		elseif Lara:GetWeaponType() == Objects.WeaponType.HK then
			weaponLaraSlot = 7
		elseif Lara:GetWeaponType() == Objects.WeaponType.GRENADE_LAUNCHER then
			weaponLaraSlot = 8
		elseif Lara:GetWeaponType() == Objects.WeaponType.ROCKET_LAUNCHER then
			weaponLaraSlot = 9
		elseif Lara:GetWeaponType() == Objects.WeaponType.HARPOON_GUN then
			weaponLaraSlot = 10
		end
		print("WEAPON ID: "..Lara:GetWeaponType())
		LevelFuncs.Engine.Node.SetLaraWeaponType(Lara:GetWeaponType(), true)
		lara : SetAnim(0, weaponLaraSlot) -- perform anim 4 LARA_PISTOLS is slot 2
	end
end

LevelFuncs.RestoreLaraAnim = function()
	canPulseAgain = true
	if Lara:GetHandStatus() == Objects.HandStatus.WEAPON_DRAW or Lara:GetHandStatus() == Objects.HandStatus.WEAPON_READY then
		lara : SetAnim(103) -- perform anim 4 LARA_PISTOLS is slot 2
	end
end

function KnockOutBaddies()
    local moveableSlots = {
        ObjID.SAS_CAIRO,
        ObjID.MP_WITH_STICK,
        ObjID.CIVVY,
		ObjID.DOG,
		ObjID.MUMMY,
		ObjID.YETI,
		ObjID.MERCENARY_AUTOPISTOLS1,
		ObjID.MERCENARY_UZI,
		ObjID.SMALL_SCORPION
    }
    for index, moveableSlot in pairs(moveableSlots) do
        local moveables = GetMoveablesBySlot(moveableSlot)
        for index, moveable in pairs(moveables) do
			if moveable:GetActive() and moveable:GetHP() >= 1 then
				if moveableSlot == ObjID.SAS_CAIRO then -- if the moveable is a SAS
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.MP_WITH_STICK then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.CIVVY then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.DOG then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.MUMMY then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.YETI then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.MERCENARY_AUTOPISTOLS1 then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.MERCENARY_UZI then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.SMALL_SCORPION then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
			end
        end
    end
end
-----------------------------
--- KNOCK OUT BADDIES END ---
-----------------------------
local endTimeTaken = tostring(Flow.GetStatistics().timeTaken) -- this will be a toString(Time()) 
local statsHeader_str = TEN.Strings.DisplayString("When You Wish Upon a Star", 
											   TEN.Vec2(TEN.Util.PercentToScreen(50, 20)), -- pos
											   1.0, -- scale
											   TEN.Color(255,255,255), -- color
											   false, --translated bool
											   {TEN.Strings.DisplayStringOption.CENTER, TEN.Strings.DisplayStringOption.SHADOW} -- flags
											   )
LevelFuncs.DisplayStats = function()
	LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, "LARA_MAIN", "END_LSP")
	LevelFuncs.Engine.Node.PlayFlyBy(22)
	LevelFuncs.Engine.Node.SetMoveableAnimation("LARA_MAIN", 975)
	
	TEN.Strings.ShowString(statsHeader_str)
	local leftJustify = 30
	local rightJustify = 70
	local yStatsPos = 30
	-- time taken
	--local endTimeTakenFormatted = "".. endTimeTaken.h .. ":" .. endTimeTaken.m .. ":" .. endTimeTaken.s
	LevelFuncs.Engine.Node.DrawText("Time Taken: ", leftJustify, yStatsPos, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(endTimeTaken, rightJustify, yStatsPos, 2, 1, TEN.Color(255,255,255), 0.8)
	-- secrets found
	local secretsFound = ""..Flow.GetStatistics().secrets
	LevelFuncs.Engine.Node.DrawText("Secrets Found: ", leftJustify, yStatsPos+5, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(secretsFound, rightJustify, yStatsPos+5, 2, 1, TEN.Color(255,255,255), 0.8)
	-- Pickups
	local pickupsFound = ""..Flow.GetStatistics().pickups
	LevelFuncs.Engine.Node.DrawText("Pickups: ", leftJustify, yStatsPos+10, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(pickupsFound, rightJustify, yStatsPos+10, 2, 1, TEN.Color(255,255,255), 0.8)
	-- Kills
	local killsStats = ""..Flow.GetStatistics().kills
	LevelFuncs.Engine.Node.DrawText("Kills: ", leftJustify, yStatsPos+15, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(killsStats, rightJustify, yStatsPos+15, 2, 1, TEN.Color(255,255,255), 0.8)
	-- Ammo Used/Hits
	local ammoUsedHits = ""..Flow.GetStatistics().ammoUsed .. "/" .. Flow.GetStatistics().ammoHits
	LevelFuncs.Engine.Node.DrawText("Ammo Used/Hits: ", leftJustify, yStatsPos+20, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(ammoUsedHits, rightJustify, yStatsPos+20, 2, 1, TEN.Color(255,255,255), 0.8)
	-- Medipacks Used
	local healthPacksUsed = ""..Flow.GetStatistics().healthPacksUsed
	LevelFuncs.Engine.Node.DrawText("Medi Packs Used: ", leftJustify, yStatsPos+25, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(healthPacksUsed, rightJustify, yStatsPos+25, 2, 1, TEN.Color(255,255,255), 0.8)
	-- Distance Travelled in km
	-- convert to km : 1 m = 240 units -> 1km - 0.240 units
	local distanceTravelled = "" .. string.format("%.2f", (Flow.GetStatistics().distanceTraveled / 240) ) .. "m"
	LevelFuncs.Engine.Node.DrawText("Distance Travelled: ", leftJustify, yStatsPos+30, 0, 1, TEN.Color(255,255,255), 0.8)
	LevelFuncs.Engine.Node.DrawText(distanceTravelled, rightJustify, yStatsPos+30, 2, 1, TEN.Color(255,255,255), 0.8)
	
	LevelFuncs.Engine.Node.DrawText("(Press ACTION to continue)", 50, yStatsPos+40, 1, 3, TEN.Color(255,255,255), 0.8)
end
											   
function showStatsSpritesBackGround()
	-- text background blur (for easier viewing)
	if TEN.Strings.IsStringDisplaying(statsHeader_str) then
		--LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 50, 0, 100, 100, 0, 0, 2, 9)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 48, 0, 60, 80, 0, 0, 2, 9)
	end
end

LevelFuncs.GetEndLevelTime = function()
	endTimeTaken = tostring(Flow.GetStatistics().timeTaken)
end