---@diagnostic disable: duplicate-set-field
require("Levels.MISC_LOOP_FUNCTIONS")
-- Timer Functions
local Timer = require("Engine.Timer")
local useTimer = 1.0
-- EventSequences
local EventSequence = require("Engine.EventSequence")

-----------------------------
-- LEVEL FUNCTIONS STANDARD SET UP
-----------------------------
LevelFuncs.OnLoad = function() end
LevelFuncs.OnSave = function() end
LevelFuncs.OnStart = function()
	LevelFuncs.BlinkOrganizer()
    LevelFuncs.Engine.Node.SetMoveableAnimation("animating20_246", 32)
    LevelFuncs.Engine.Node.PlayFlyBy(12)
    LevelFuncs.Engine.Node.SetStaticCollisionStatus(false, "static_mesh_324")
	MoveLaraToLSP(true, "lara_start_pos_968")
    -- Give Lara Champagne Glass
	LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 13, TEN.Objects.ObjID.LARA_SPEECH_HEAD1, 13)
    LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 10, TEN.Objects.ObjID.LARA_SPEECH_HEAD1, 10)
    -- MoveLaraToLSP(true, "lara_start_pos_246")
	Lara:SetAnim(1084)
    LevelFuncs.Engine.Node.SetStarField(50, -- star count 
										20, -- meteor count
										100, -- meteor spawn density
										15) -- meteor velocity
end
LevelFuncs.OnLoop = function()
	ShootingStarEffects()
end
LevelFuncs.OnEnd = function() end
LevelFuncs.OnUseItem = function() end
LevelFuncs.OnFreeze = function() end

-----------------------------
-- SPRITE LOGIC CHECK
-----------------------------
function RenderSpriteChecker()
    local blend_mode = 9
    -- Background
    if LevelFuncs.Engine.Node.TestMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1) then
        -- LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 17, TEN.Color(255,255,255), 50, 50, 0, 50, 50, 0, 0, 0, blend_mode)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 89, 0, 80, 20, 0, 0, 2, 9)

	-- NYE
	elseif LevelFuncs.Engine.Node.TestMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 2) then
        LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 19, TEN.Color(255,255,255), 50, 50, 0, 50, 50, 0, 0, 0, blend_mode)

	-- NYE
	elseif LevelFuncs.Engine.Node.TestMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 3) then
        LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 20, TEN.Color(255,255,255), 50, 50, 0, 50, 50, 0, 0, 0, blend_mode)

    -- title card
    elseif LevelFuncs.Engine.Node.TestMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 4) then
        LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 18, TEN.Color(255,255,255), 50, 50, 0, 50, 50, 0, 0, 0, blend_mode)
    end
end

-----------------------------
-- SHOOTING STAR GLOW
-----------------------------
function ShootingStarEffects()
	local shootingStarSlots = {
        ObjID.ANIMATING34
    }
	-- init empty list of all interactive items
	local interactiveObjects = {}
	local numEntries = 0
	-- for all moveable slots
	for index, shootingStarSlot in pairs(shootingStarSlots) do
		-- get the associated moveables for that slot
        local shootingStarObjs = GetMoveablesBySlot(shootingStarSlot)
		-- get length of table
		local numEntriesForSlot = #shootingStarObjs
		if numEntriesForSlot > 0 then
			-- append table of elements over to interactiveObjects
			table.move(shootingStarObjs, 1, numEntriesForSlot, #interactiveObjects+1, interactiveObjects)
			numEntries = numEntries + numEntriesForSlot
		end
	end
	-- parse through all the moveables in
	for index, currObj in pairs(interactiveObjects) do
		if currObj:GetActive() then
			-- apply the effect
			ShootingStarGlow(currObj:GetName())

			-- do the distance check logic
			-- print(currObj:GetName())
			local shootingStarPosition = currObj:GetPosition()
			local laraPosition = lara:GetPosition()
			local distanceFromLara = math.abs(laraPosition:Distance(shootingStarPosition))
			-- if lara is near the hole 650.0
			if distanceFromLara <= 500.0 then
				-- FULL TEXT PROMPT
				-- LevelFuncs.Engine.Node.DrawText("Press ACTION to Claim Shooting Star Fragment", 50, 84, 1, 3, TEN.Color(255,255,255), 1, 1)
				-- LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 87, 0, 80, 9, 0, 0, 2, 9)
				-- AOD HAND
				LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.INTERACTION_SPRITES, 0, TEN.Color(255,255,255), 90, 90, 0, 5, 8, 0, 0, 2, 9)
				if Input.IsKeyPulsed(ActionID.ACTION, 5, 5) and LevelVars.canPulse == true then
					LevelVars.canPulse = false
					LevelFuncs.ClaimingShootingStarOrg(currObj:GetName())
				end
			end
		end
	end
end

function ShootingStarGlow(star_moveable_name)
    local shooting_star = Objects.GetMoveableByName(star_moveable_name)
    if shooting_star:GetActive() then
        LevelFuncs.Engine.Node.ParticleEmitter(star_moveable_name, 
                                                0, 0, 
                                                TEN.Vec3(0,0,0), 
                                                0, 0, 
                                                TEN.Color(255,255,0), 
                                                TEN.Color(255,128,64), 
                                                2, 150, 100, 0.5, false, false)
		LevelFuncs.Engine.Node.MoveableLight(star_moveable_name, 0, TEN.Color(255,242,0), 6, TEN.Vec3(0.1,0.1,0.1), true, "")
    end
end

LevelFuncs.ClaimingShootingStarOrg = function(shooting_star_name)
    local shooting_shooting_star_org = EventSequence.Create
	(
    	"shooting_shooting_star_org", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.
    	0.0, -- I made an enumerator for this so I don't have to change all manually
    	LevelFuncs.LaraShatterOrbStart,
		2.0,
		{LevelFuncs.ShatterShootingStar, shooting_star_name},
		2.0,
		LevelFuncs.ResetCanPulse
    )

   -- last : now we have created the Event Sequence: you must Start it:
    shooting_shooting_star_org:Start()
end	


LevelFuncs.LaraShatterOrbStart = function()
    lara:SetAnim(1071)
end

LevelFuncs.ShatterShootingStar = function(shooting_star_name)
    local shooting_star = Objects.GetMoveableByName(shooting_star_name)
    LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 1165)
    shooting_star:Shatter()
    shooting_star:Disable()
    shooting_star:Destroy()
	LevelFuncs.Engine.Node.AddInventoryItem(TEN.Objects.ObjID.PUZZLE_ITEM2, 1, true)
end

LevelFuncs.ResetCanPulse = function ()
	LevelVars.canPulse = true
end

function FreezeWinston(winston_name)
	LevelFuncs.Engine.Node.FlashScreen(TEN.Color(255,255,0), 1)
	for i = 0,25,1
	do
		LevelFuncs.Engine.Node.SwapMoveableMesh(winston_name, i, TEN.Objects.ObjID.ANIMATING50, i)
	end 
end

function ShowStarCounter()
    local weaponType = " "
    local ammoCounterPosX = 100 -- X Position of counter.
    local ammoCounterPosY = 300 -- Y Position of counter.
    local holdWeapon = Lara:GetHandStatus() -- Check Lara's hand status.
    local ammoCounterColor = Color(255, 255, 255) 
    local ammoMessage = DisplayString(
    "Ammo: ".. Lara:GetHandStatus(), 100,
    300, Color(255, 255, 255))

	if LevelVars.CanShowStarCounter == true then
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 17, TEN.Color(255,255,255), 5, 12, 0, 12, 7, 0, 0, 0, 9)
		if (Inventory.GetItemCount(ObjID.PUZZLE_ITEM2) == -1) then
			LevelFuncs.Engine.Node.DrawText("Unlimited", 9, 10, 0, 3, TEN.Color(255,255,255), 0.8)
		else
			LevelFuncs.Engine.Node.DrawText(""..Inventory.GetItemCount(ObjID.PUZZLE_ITEM2).."/"..tostring(LevelVars.TotalStars), 9, 10, 0, 1, TEN.Color(255,255,255), 0.8)
		end
	else
		HideString(ammoMessage)
	end
end

-----------------------------
-- INTRO CLUB CUTSCENE
-----------------------------
LevelFuncs.IntroClubCutOrg = function ()
    local intro_club_cut_org = EventSequence.Create

	(
    	"intro_club_cut_org", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.
    	0.0, -- I made an enumerator for this so I don't have to change all manually
    	LevelFuncs.ClubCutFlyby1,
		4.0,
		LevelFuncs.ClubCutFlyby2,
		3.5,
		LevelFuncs.PlayClubAmbience,
		3,
		LevelFuncs.ClubCutFlyby3,
		7,
		LevelFuncs.CutFadeOut,
		1.5,
		LevelFuncs.ClubCutFlyby4,
		0.5,
		LevelFuncs.CutFadeIn,
		3,
		LevelFuncs.ClubCutFlyby4_5,
		3.5,
		LevelFuncs.ClubCutFlyby5,
		9,
		LevelFuncs.clearSprites,
		1,
		LevelFuncs.EnableStarCounter
    )

   -- last : now we have created the Event Sequence: you must Start it:
    intro_club_cut_org:Start()
end

LevelFuncs.ClubCutFlyby1 = function ()
	LevelFuncs.Engine.Node.SetStaticCollisionStatus(false, "static_mesh_324")
	MoveLaraToLSP(true, "lara_start_pos_246")
	LevelFuncs.Engine.Node.PlayFlyBy(1)
	Sound.PlayAudioTrack("052_lower", SoundTrackType.ONESHOT)
	-- Club Idle
	Lara:SetAnim(1080)
	-- Give Lara Champagne Glass
	LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 13, TEN.Objects.ObjID.LARA_SPEECH_HEAD1, 13)

	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 2)
	
end

LevelFuncs.ClubCutFlyby2 = function ()
	LevelFuncs.Engine.Node.SetMoveableAnimation("animating20_246", 32)
	Lara:SetAnim(1081)
	LevelFuncs.Engine.Node.PlayFlyBy(2)
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 3)
	
end

LevelFuncs.PlayClubAmbience = function ()
	-- Sound.PlayAudioTrack("050", SoundTrackType.LOOPED)
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 0)
end

LevelFuncs.ClubCutFlyby3 = function ()
	LevelFuncs.Engine.Node.PlayFlyBy(9)
	Lara:SetAnim(1083)
	-- LevelFuncs.Engine.Node.SetStaticCollisionStatus(true, "static_mesh_324")
	Sound.PlayAudioTrack("027_Sorrytobutleryou", SoundTrackType.VOICE)
	LevelFuncs.Engine.Node.DrawTextForTimespan(9, 
                                               "Winston:\n Ms Croft... may I invite you to step outside for a moment?\n You might be interested in coming outside!", 
                                               50, 82, 1, 1, 
                                               TEN.Color(255,255,255), 
                                               0.7, 1)
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
end

-- show lara chilling outside with winston
LevelFuncs.ClubCutFlyby4 = function ()
	LevelFuncs.Engine.Node.SetStaticCollisionStatus(true, "static_mesh_324")
	MoveLaraToLSP(true, "lara_start_pos_493")
	Lara:SetAnim(1080)
	LevelFuncs.Engine.Node.PlayFlyBy(5)
	LevelFuncs.Engine.Node.SetMoveableVisibility("animating38_523", 1)
	LevelFuncs.Engine.Node.DrawTextForTimespan(3.7, 
                                               "Lara Croft:\n  The stars look beautiful tonight! \nThank you Winston!", 
                                               50, 82, 1, 1, 
                                               TEN.Color(255,255,255), 
                                               0.7, 1)
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
	
end

LevelFuncs.ClubCutFlyby4_5 = function()
	Sound.PlayAudioTrack("028_WINSTON_PLEASE", SoundTrackType.VOICE)
	LevelFuncs.Engine.Node.PlayFlyBy(8)
	LevelFuncs.Engine.Node.SetStarField(50, -- star count 
										20, -- meteor count
										100, -- meteor spawn density
										15) -- meteor velocity
	LevelFuncs.Engine.Node.DrawTextForTimespan(3.4, 
                                               "Lara Croft:\n  Look Winston! A shooting star!\n Quick! Make a...", 
                                               50, 82, 1, 1, 
                                               TEN.Color(255,255,255), 
                                               0.7, 1)
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
end

-- freeze winston cam
LevelFuncs.ClubCutFlyby5 = function ()
	-- -- TITLE CARD
    -- LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 0)
	MoveLaraToLSP(true, "lara_start_pos_492")
	Lara:SetAnim(1079)
	LevelFuncs.Engine.Node.PlayFlyBy(6)
	FreezeWinston("winston_obj")
	LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 1161)
	LevelFuncs.Engine.Node.DrawTextForTimespan(9, 
                                               "Lara Croft:\n  ...wish. I should have seen that coming...\n I guess I know what I'm wishing for...", 
                                               50, 82, 1, 1, 
                                               TEN.Color(255,255,255), 
                                               0.7, 1)
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
end

-- shabaobab presents cam
LevelFuncs.ClubCutFlyby6 = function ()
	-- -- TITLE CARD
    -- LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 0)
	LevelFuncs.Engine.Node.PlayFlyBy(6)
	FreezeWinston("winston_obj")
	LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 1161)
end

-- title card  cam
LevelFuncs.ClubCutFlyby7 = function ()
	-- -- TITLE CARD
    -- LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 0)
	LevelFuncs.Engine.Node.PlayFlyBy(6)
end

LevelFuncs.EnableStarCounter = function()
	-- -- TITLE CARD
    -- LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 3)
	LevelVars.CanShowStarCounter = true
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 0)
end

LevelFuncs.DanceFloorOrg = function ()
    local dance_floor_org = EventSequence.Create

	(
    	"dance_floor_org", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.
    	0.0, -- I made an enumerator for this so I don't have to change all manually
    	LevelFuncs.DanceFloorOrg1,
		20.5,
		LevelFuncs.DanceFloorOrg2
    )

   -- last : now we have created the Event Sequence: you must Start it:
    dance_floor_org:Start()
end

LevelFuncs.DanceFloorOrg1 = function ()
	MoveLaraToLSP(true, "lara_start_pos_247")
	Lara:SetAnim(1082)
	LevelFuncs.Engine.Node.PlayFlyBy(3)

	
	
end
LevelFuncs.DanceFloorOrg2 = function ()
	Lara:SetAnim(103)
end
-----------------------------
-- HELPER CUTSCENE FUNCTIONS
-----------------------------
LevelFuncs.CutFadeOut = function()
	FadeOut(1.0); 
end;

LevelFuncs.CutFadeIn = function()
	FadeIn(1.5);
end;

function MoveLaraToLSP(with_rotation, target_LSP_name)
    LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(with_rotation, 
                                                                lara_name, 
                                                                target_LSP_name)
end

LevelFuncs.clearSprites = function()
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 0)
end
-----------------------------
-- SLEEPY EEPY EVENT
-----------------------------

LevelFuncs.SleepyEepyCheck = function ()
	print("CHECKING")
	if LevelFuncs.Engine.Node.SoundIsPlaying(1165) then
		print("DOING THE THING")
		LevelFuncs.SleepyEepyOrg()
	end
end

LevelFuncs.SleepyEepyOrg = function ()
	local sleepy_eepy_org = EventSequence.Create(
						"sleepy_eepy_org", -- sequence's name
						false, -- loop
						false, -- no countdown is displayed
						0,
						LevelFuncs.SleepyEepy1, 
						0.5, 
						LevelFuncs.SleepyEepy2,
						2.5,
						LevelFuncs.SleepyEepy3,
						2.2,
						LevelFuncs.SleepyEepy4,
						2.2,
						LevelFuncs.clearSprites
						)
	-- event sequences are inactive to begin with and so need to be started
    sleepy_eepy_org:Start()
end
LevelFuncs.SleepyEepy1 = function()
	LevelFuncs.Engine.Node.PlayFlyBy(11)
	LevelFuncs.Engine.Node.EnableMoveable("animating36_330", 0)
	Sound.PlayAudioTrack("029_OH_FFS_NAUR", SoundTrackType.VOICE)
	
end

LevelFuncs.SleepyEepy2 = function()
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
	LevelFuncs.Engine.Node.DrawTextForTimespan(2.5, 
                                               "Sleepy Eepy Guy:\n  Eugh! Oh! Wait did I miss the new year already?!", 
                                               50, 82, 1, 1, 
                                               TEN.Color(255,255,255), 
                                               0.7, 1)
end

LevelFuncs.SleepyEepy3 = function()
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
	LevelFuncs.Engine.Node.DrawTextForTimespan(2.2, 
                                               "Sleepy Eepy Guy:\n  Ugh! Dang it! Man... Not again...", 
                                               50, 82, 1, 1, 
                                               TEN.Color(255,255,255), 
                                               0.7, 1)
end

LevelFuncs.SleepyEepy4 = function()
	LevelFuncs.Engine.Node.SetMoveableAnimation("SPRITE_LOGIC_CHECKER_OBJ", 1)
	LevelFuncs.Engine.Node.DrawTextForTimespan(2.2, 
                                               "Sleepy Eepy Guy:\n  At least it's nice outside...", 
                                               50, 82, 1, 1, 
                                               TEN.Color(255,255,255), 
                                               0.7, 1)
end

----------------
--- BLINKING ---
----------------
LevelFuncs.BlinkOrganizer = function ()
	local lara_blink_org = EventSequence.Create(
						"lara_blink_org", -- sequence's name
						true, -- loop
						false, -- no countdown is displayed
						0,
						LevelFuncs.BlinkOff, 
						3, 
						LevelFuncs.BlinkOn,
						1,
						LevelFuncs.BlinkOff
						)
	-- event sequences are inactive to begin with and so need to be started
    lara_blink_org:Start()
end

LevelFuncs.BlinkOn = function ()
	LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 14, TEN.Objects.ObjID.LARA_SPEECH_HEAD1, 14)
	print("BLINKING ON")
end
LevelFuncs.BlinkOff = function ()
	LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 14, TEN.Objects.ObjID.LARA_SKIN, 14)
	print("BLINKING OFF")
end

----------------------
--- SNOWBALL LOGIC ---
----------------------
function EquipSnowBall()
	ShowSnowballCounter()
	if (Inventory.GetItemCount(ObjID.PUZZLE_ITEM9) >= 1) then
		if Input.IsKeyPulsed(Input.ActionID.DRAW, 3, 2) then
			if (Lara:GetAnim() >= 0 and Lara:GetAnim() <= 13) or Lara:GetAnim() == 103 then
				LevelFuncs.DrawSnowballOrganizer()
			else
				-- play draw sound
				LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 6)
				LevelFuncs.SwapSnowMesh()
			end
		end
	else
		LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 10, TEN.Objects.ObjID.LARA_SKIN, 10)
		LevelVars.IsSnowBallEquipped = false
	end
	-- if Lara:GetHandStatus() == Objects.HandStatus.WEAPON_DRAW then
	-- 	LevelVars.IsSnowBallEquipped = false
	-- end
end

LevelFuncs.PlayDrawSnowballAnim = function()
	Lara:SetAnim(1076)
end

LevelFuncs.SwapSnowMesh = function()
	if LevelVars.IsSnowBallEquipped == true then
		LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 10, TEN.Objects.ObjID.LARA_SKIN, 10)
		LevelVars.IsSnowBallEquipped = false
	else
		LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 10, TEN.Objects.ObjID.LARA_SPEECH_HEAD1, 10)
		LevelVars.IsSnowBallEquipped = true
	end
end

LevelFuncs.DrawSnowballOrganizer = function()
	local draw_snowball = EventSequence.Create(
						"draw_snowball", -- sequence's name
						false, -- loop
						false, -- no countdown is displayed
						0,
						LevelFuncs.PlayDrawSnowballAnim, 
						0.3, 
						LevelFuncs.SwapSnowMesh
						)
	-- event sequences are inactive to begin with and so need to be started
    draw_snowball:Start()
end

function FreezeBaddy(baddy_name)
	LevelFuncs.Engine.Node.FlashScreen(TEN.Color(128,255,255), 1)
	for i = 0,25,1
	do
		LevelFuncs.Engine.Node.SwapMoveableMesh(baddy_name, i, TEN.Objects.ObjID.ACTOR1_SPEECH_HEAD1, i)
	end 
end

function ShowSnowballCounter()
    local weaponType = " "
    local ammoCounterPosX = 100 -- X Position of counter.
    local ammoCounterPosY = 300 -- Y Position of counter.
    local holdWeapon = Lara:GetHandStatus() -- Check Lara's hand status.
    local ammoCounterColor = Color(255, 255, 255) 
    local ammoMessage = DisplayString(
    "Ammo: ".. Lara:GetHandStatus(), 100,
    300, Color(255, 255, 255))

	if LevelVars.IsSnowBallEquipped == true then
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 16, TEN.Color(255,255,255), 5, 12, 0, 12, 7, 0, 0, 0, 9)
		if (Inventory.GetItemCount(ObjID.PUZZLE_ITEM9) == -1) then
			LevelFuncs.Engine.Node.DrawText("Unlimited", 9, 10, 0, 3, TEN.Color(255,255,255), 0.8)
		else
			LevelFuncs.Engine.Node.DrawText(""..Inventory.GetItemCount(ObjID.PUZZLE_ITEM9), 9, 10, 0, 3, TEN.Color(255,255,255), 0.8)
		end
	else
		HideString(ammoMessage)
	end
end


-------------------------------
--- KNOCK OUT BADDIES BEGIN ---
-------------------------------
local canPulseAgain = true
function Knock_Out_Baddy(baddy_name, moveableSlot)
	-- if enemy is within 128 units of Lara
	local baddyObj = TEN.Objects.GetMoveableByName(baddy_name)
	local baddyPosition = TEN.Objects.GetMoveableByName(baddy_name):GetPosition()
	local laraPosition = TEN.Objects.GetMoveableByName("LARA_MAIN"):GetPosition()
	local distanceFromLara = math.abs(laraPosition:Distance(baddyPosition))
	
	if distanceFromLara <= 256.0 and baddyObj:GetActive() then
		--print("distance : " .. distanceFromLara)
		-- SPRINT SLIDE KNOCKOUT LOGIC
		-- if lara is performing a sprint slide
		-- if (LevelFuncs.Engine.Node.TestMoveableAnimation("LARA_MAIN", 956) or LevelFuncs.Engine.Node.TestMoveableAnimation("LARA_MAIN", 957)) then
		if (lara:GetAnim() == 956 or lara:GetAnim() == 957) and distanceFromLara <= 150.0 then
			SetBaddyKnockoutAnim(moveableSlot, baddy_name, 0)
		-- else use kick mechanics
		else
			-- KNEE AND TWIST KICK LOGIC
			print("distance : " .. distanceFromLara)
			if Input.IsKeyPulsed(Input.ActionID.ACTION, 3, 2) and canPulseAgain == true and
			   LevelFuncs.Engine.Node.TestLaraVehicle() == false then -- and lara is not on a vehicle
				canPulseAgain = false
				local attackAnimIDs = {}

				-- Get the random attack anim for Lara
				if Lara:GetHandStatus() == Objects.HandStatus.WEAPON_DRAW or Lara:GetHandStatus() == Objects.HandStatus.WEAPON_READY then
					attackAnimIDs = {976} -- 976, 1005, 1003
				else
					attackAnimIDs = {977, 976, 1005} -- 1006
				end

				if LevelVars.IsSnowBallEquipped == true then
					attackAnimIDs = {1075}
				end

				local randomAttackAnim = attackAnimIDs[math.random(1, #attackAnimIDs)]

				if moveableSlot == ObjID.DOG then
					randomAttackAnim = 1006
				end

				if moveableSlot == ObjID.SMALL_SCORPION then
					randomAttackAnim = 1003
					LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 1162)
				end

				lara : SetAnim(randomAttackAnim)
				LevelFuncs.LaraKickOrganizer(moveableSlot, baddy_name, randomAttackAnim)
			end
		end
	end
end

function SetBaddyKnockoutAnim(moveableSlot, baddy_name, laraAttackAnim)
	baddy_obj = Objects.GetMoveableByName(baddy_name)
	-- determine the knock out anim based off the moveable slot
	if moveableSlot == ObjID.SAS_CAIRO then -- SAS

		defenseAnimIDs = {23, 23, 23, 26}
		randomDefenseAnim = defenseAnimIDs[math.random(1, #defenseAnimIDs)]

		-- if lara does a low kick or a pistol kick
		if laraAttackAnim == 1006 or laraAttackAnim == 1005 then
			-- do a defense anim
			LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 26)
		else
			-- do the fall back anim
			LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 23)
		end

	elseif moveableSlot == ObjID.FLAMETHROWER_BADDY then -- flamethrower
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 24)
	elseif moveableSlot == ObjID.MP_WITH_GUN then -- mp with gun
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 39)
	elseif moveableSlot == ObjID.TRIBESMAN_WITH_AX then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 31)
	elseif moveableSlot == ObjID.DOG then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 25)
	elseif moveableSlot == ObjID.MP_WITH_STICK then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 35)
	elseif moveableSlot == ObjID.CIVVY then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 35)
	elseif moveableSlot == ObjID.MUMMY then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 74)
	elseif moveableSlot == ObjID.YETI then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 38)

	elseif moveableSlot == ObjID.MERCENARY_UZI then 
		-- if lara is using enchanted snowball
		if laraAttackAnim == 1075 then
			LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 36)
			FreezeBaddy(baddy_name)
			-- LevelFuncs.Engine.Node.ChangeMoveableColourOverTimespan(baddy_name, TEN.Color(183,255,255), 1.5)
		else

			-- if baddy is frozen
			if baddy_obj:GetAnim() == 36 then
				print("HES FROZEN!")
				-- shatter moveable
				LevelFuncs.Engine.Node.ShatterMoveable(baddy_name)
				baddy_obj:Destroy()
				-- play shatter sound
				LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 347)
				LevelFuncs.Engine.Node.FlashScreen(TEN.Color(128,255,255), 1)
			end

			-- if lara does a knee attack or a groin kick
			if laraAttackAnim == 1005 then
				-- do a knee groin attacked anim
				LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 30)
			else
				-- do the fall back anim
				LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 33)
			end

		end

	elseif moveableSlot == ObjID.MERCENARY_AUTOPISTOLS1 then 
		-- if lara is using enchanted snowball
		if laraAttackAnim == 1075 then
			LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 34)
			FreezeBaddy(baddy_name)
			-- LevelFuncs.Engine.Node.ChangeMoveableColourOverTimespan(baddy_name, TEN.Color(183,255,255), 1.5)
		else
			
			-- if baddy is frozen
			if baddy_obj:GetAnim() == 34 then
				print("HES FROZEN!")
				-- shatter moveable
				LevelFuncs.Engine.Node.ShatterMoveable(baddy_name)
				baddy_obj:Destroy()
				-- play shatter sound
				LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 347)
				LevelFuncs.Engine.Node.FlashScreen(TEN.Color(128,255,255), 1)
			end

			-- if lara does a low kick or a pistol kick
			if laraAttackAnim == 1005 then
				LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 28)
			else
				-- do the fall back anim
				LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 31)
			end

			
		end

	elseif moveableSlot == ObjID.BADDY2 then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 71)

	elseif moveableSlot == ObjID.SMALL_SCORPION then
		local new_splat_name = "splat_EW_" .. tostring(LevelVars.SplatCounter)
		LevelVars.SplatCounter = LevelVars.SplatCounter + 1
		local spider_position = baddy_obj:GetPosition()
		local new_splat = Moveable(TEN.Objects.ObjID.ANIMATING10, -- object id
								  new_splat_name, -- name
								  spider_position) -- position
		LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, 
                                                                new_splat_name, 
                                                                baddy_name)
		-- shatter moveable
		LevelFuncs.Engine.Node.ShatterMoveable(baddy_name)
		baddy_obj:Destroy()
		LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 1163)
	end
end

LevelFuncs.LaraKickOrganizer = function(moveableSlot, baddy_name, laraAttackAnim)
	local attack_org = EventSequence.Create(
						"attack_org", -- sequence's name
						false, -- loop
						false, -- no countdown is displayed
						0.4,
						{LevelFuncs.KickAManBecauseItsWhatHeDeservesBINCH, moveableSlot, baddy_name, laraAttackAnim}, 
						0.9, 
						LevelFuncs.RestoreLaraWeaponStatus,
						0.01,
						LevelFuncs.RestoreLaraAnim
						)
	-- event sequences are inactive to begin with and so need to be started
    attack_org:Start()
end

LevelFuncs.KickAManBecauseItsWhatHeDeservesBINCH = function(moveableSlot, baddy_name, laraAttackAnim)
	SetBaddyKnockoutAnim(moveableSlot, baddy_name, laraAttackAnim)
end

LevelFuncs.RestoreLaraWeaponStatus = function()
	if Lara:GetHandStatus() == Objects.HandStatus.WEAPON_DRAW or Lara:GetHandStatus() == Objects.HandStatus.WEAPON_READY then
		-- init weaponLaraSlot
		local weaponLaraSlot = 0
		if Lara:GetWeaponType() == Objects.WeaponType.PISTOLS then
			weaponLaraSlot = 2
		elseif Lara:GetWeaponType() == Objects.WeaponType.UZIS then
			weaponLaraSlot = 3
		elseif Lara:GetWeaponType() == Objects.WeaponType.SHOTGUN then
			weaponLaraSlot = 4
		elseif Lara:GetWeaponType() == Objects.WeaponType.REVOLVER then
			weaponLaraSlot = 5
		elseif Lara:GetWeaponType() == Objects.WeaponType.CROSSBOW then
			weaponLaraSlot = 6
		elseif Lara:GetWeaponType() == Objects.WeaponType.HK then
			weaponLaraSlot = 7
		elseif Lara:GetWeaponType() == Objects.WeaponType.GRENADE_LAUNCHER then
			weaponLaraSlot = 8
		elseif Lara:GetWeaponType() == Objects.WeaponType.ROCKET_LAUNCHER then
			weaponLaraSlot = 9
		elseif Lara:GetWeaponType() == Objects.WeaponType.HARPOON_GUN then
			weaponLaraSlot = 10
		end
		print("WEAPON ID: "..Lara:GetWeaponType())
		LevelFuncs.Engine.Node.SetLaraWeaponType(Lara:GetWeaponType(), true)
		lara : SetAnim(0, weaponLaraSlot) -- perform anim 4 LARA_PISTOLS is slot 2
	end
end

LevelFuncs.RestoreLaraAnim = function()
	canPulseAgain = true
	if Lara:GetHandStatus() == Objects.HandStatus.WEAPON_DRAW or Lara:GetHandStatus() == Objects.HandStatus.WEAPON_READY then
		lara : SetAnim(103) -- perform anim 4 LARA_PISTOLS is slot 2
	end
end

function KnockOutBaddies()
    local moveableSlots = {
        ObjID.SAS_CAIRO,
        ObjID.MP_WITH_STICK,
        ObjID.CIVVY,
		ObjID.DOG,
		ObjID.MUMMY,
		ObjID.YETI,
		ObjID.MERCENARY_AUTOPISTOLS1,
		ObjID.MERCENARY_UZI,
		ObjID.SMALL_SCORPION
    }
    for index, moveableSlot in pairs(moveableSlots) do
        local moveables = GetMoveablesBySlot(moveableSlot)
        for index, moveable in pairs(moveables) do
			if moveable:GetActive() and moveable:GetHP() >= 1 then
				if moveableSlot == ObjID.SAS_CAIRO then -- if the moveable is a SAS
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.MP_WITH_STICK then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.CIVVY then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.DOG then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.MUMMY then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.YETI then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.MERCENARY_AUTOPISTOLS1 then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.MERCENARY_UZI then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.SMALL_SCORPION then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
			end
        end
    end
end
-----------------------------
--- KNOCK OUT BADDIES END ---
-----------------------------