
---@diagnostic disable: duplicate-set-field
require("Levels.MISC_LOOP_FUNCTIONS")
-- Timer Functions
local Timer = require("Engine.Timer")
local useTimer = 1.0
-- EventSequences
local EventSequence = require("Engine.EventSequence")

LevelFuncs.OnLoad = function() end
LevelFuncs.OnSave = function() end
LevelFuncs.OnStart = function()
	LevelFuncs.Engine.Node.RemoveInventoryItem(TEN.Objects.ObjID.PISTOLS_ITEM, 0)
end
LevelFuncs.OnLoop = function()
	BloodifyLaraIfDed()
	LaserLightLogic()
	KnockOutBaddies()
end
LevelFuncs.OnEnd = function() end
LevelFuncs.OnUseItem = function() end
LevelFuncs.OnFreeze = function() end

LevelFuncs.NoOp = function()
	print("Hi bb :) <3 xoxo gossip girl")
end

LevelFuncs.TestMoveForwardOrg = function()
	local movement_org = EventSequence.Create(
						"movement_org", -- sequence's name
						false, -- loop
						true, -- no countdown is displayed
						0.0,
						{LevelFuncs.PressKey, Input.ActionID.JUMP},
						10.0,
						{LevelFuncs.PressKey, {Input.ActionID.WALK, Input.ActionID.FORWARD}},
						5.0,
						LevelFuncs.NoOp
						)
	-- event sequences are inactive to begin with and so need to be started
    movement_org:Start()
end

LevelFuncs.PressKey = function (desiredKeyPress)
	SimulateKeyPress(desiredKeyPress)
end

LevelFuncs.PressKeys = function(desiredKeyPresses)
	SimulateKeyPresses(desiredKeyPresses)
end

function SimulateKeyPresses(desiredKeyPresses)
	-- now simulate the key push
	for index, desiredKeyPress in pairs(desiredKeyPresses) do
		SimulateKeyPress(desiredKeyPress)
	end
end

function SimulateKeyPress(desiredKeyPress)
	local keyPresses = {
		Input.ActionID.FORWARD,
		Input.ActionID.BACK,
		Input.ActionID.LEFT,
		Input.ActionID.RIGHT,
		Input.ActionID.STEP_LEFT,
		Input.ActionID.STEP_RIGHT,
		Input.ActionID.WALK,
		Input.ActionID.SPRINT,
		Input.ActionID.CROUCH,
		Input.ActionID.JUMP,
		Input.ActionID.ROLL,
		Input.ActionID.ACTION,
		Input.ActionID.DRAW,
		Input.ActionID.LOOK
	}
	-- filter desired key press table (we will use this to cancel all other inputs)
	table.remove(keyPresses, desiredKeyPress)
	-- parse all available actions
	for index, keyPress in pairs(keyPresses) do
		-- if the user presses a key that is not the desired key press
		if Input.IsKeyHeld(keyPress) then
			-- cancel that input
			Input.ClearKey(keyPress)
			-- now simulate the key push
			Input.PushKey(desiredKeyPress)
		end
	end
	-- now simulate the key push
	Input.PushKey(desiredKeyPress)
end


function LaserLightLogic()
	EmitLaserLightBinch()
	MovingLaserCollisionCheck()
end

function EmitLaserLightBinch()
	local moveables = GetMoveablesBySlot(ObjID.COG)
	for index, moveable in pairs(moveables) do
		moveable:SetOnCollidedWithObject(LevelFuncs.RE1_moviefy_lara_EW)
		LevelFuncs.Engine.Node.MoveableLight(moveable:GetName(), 0, TEN.Color(255,0,0), 6, TEN.Vec3(0.1,0.1,0.1), true, "")
	end
end

LevelFuncs.RE1_moviefy_lara_EW = function(obj1, obj2)
	if obj2:GetObjectID() ~= ObjID.LARA then
		return
	end
	bloodify_lara()
end

function MovingLaserCollisionCheck()
    local moveableSlots = {
        ObjID.COG  --'COG (moving laser)'
    }
    for index, moveableSlot in pairs(moveableSlots) do
        local moveables = GetMoveablesBySlot(moveableSlot)
        for index, moveable in pairs(moveables) do
        	if moveableSlot == ObjID.COG and moveable:GetActive() then -- if the moveable is a moving laser (cog)
            	moveable:SetOnCollidedWithObject(LevelFuncs.RE1_moviefy_lara_EW)
            end
        end
    end
end

function BloodifyLara()
	for i = 0,14,1
	do
		LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", i, TEN.Objects.ObjID.LARA_SPEECH_HEAD1, i)
	end 
	LevelFuncs.Engine.Node.PlaySoundAroundMoveable("LARA_MAIN", 145)
	LevelFuncs.Engine.Node.SetMoveableHitPoints(1, 0, "LARA_MAIN")
	LevelFuncs.Engine.Node.ParticleEmitter("LARA_MAIN", 0, 0, TEN.Vec3(0,0,0), 0, 0, TEN.Color(165,18,18), TEN.Color(85,0,0), 2, 64, 1024, 1, false, false)
end

function BloodifyLaraIfDed()
	lara = TEN.Objects.GetMoveableByName("LARA_MAIN")
	if lara:GetHP() == 0 then
		BloodifyLara()
	end
end

local canPulseAgain = true
function Knock_Out_Baddy(baddy_name, moveableSlot)
	-- if enemy is within 128 units of Lara
	local baddyPosition = TEN.Objects.GetMoveableByName(baddy_name):GetPosition()
	local laraPosition = TEN.Objects.GetMoveableByName("LARA_MAIN"):GetPosition()
	local distanceFromLara = math.abs(laraPosition:Distance(baddyPosition))
	local baddyObj = TEN.Objects.GetMoveableByName(baddy_name)
	
	if distanceFromLara <= 256.0 and baddyObj:GetActive() then
		--print("distance : " .. distanceFromLara)
		-- SPRINT SLIDE KNOCKOUT LOGIC
		-- if lara is performing a sprint slide
		-- if (LevelFuncs.Engine.Node.TestMoveableAnimation("LARA_MAIN", 956) or LevelFuncs.Engine.Node.TestMoveableAnimation("LARA_MAIN", 957)) then
		if lara:GetAnim() == 956 or lara:GetAnim() == 957 then
			SetBaddyKnockoutAnim(moveableSlot, baddy_name, 0)
		-- else use kick mechanics
		else
			-- KNEE AND TWIST KICK LOGIC
			print("distance : " .. distanceFromLara)
			if Input.IsKeyPulsed(Input.ActionID.ACTION, 3, 2) and canPulseAgain == true and
			   LevelFuncs.Engine.Node.TestLaraVehicle() == false then -- and lara is not on a vehicle
				canPulseAgain = false
				local attackAnimIDs = {}

				-- Get the random attack anim for Lara
				if Lara:GetHandStatus() == Objects.HandStatus.WEAPON_DRAW or Lara:GetHandStatus() == Objects.HandStatus.WEAPON_READY then
					attackAnimIDs = {976} -- 976, 1005, 1003
				else
					attackAnimIDs = {977, 976, 1005, 1006}
				end

				local randomAttackAnim = attackAnimIDs[math.random(1, #attackAnimIDs)]

				if moveableSlot == ObjID.DOG then
					randomAttackAnim = 1006
				end

				lara : SetAnim(randomAttackAnim)
				LevelFuncs.LaraKickOrganizer(moveableSlot, baddy_name, randomAttackAnim)
			end
		end
	end
end

function SetBaddyKnockoutAnim(moveableSlot, baddy_name, laraAttackAnim)
	-- determine the knock out anim based off the moveable slot
	if moveableSlot == ObjID.SAS_CAIRO then -- SAS

		defenseAnimIDs = {23, 23, 23, 26}
		randomDefenseAnim = defenseAnimIDs[math.random(1, #defenseAnimIDs)]

		-- if lara does a low kick or a pistol kick
		if laraAttackAnim == 1006 or laraAttackAnim == 1005 then
			-- do a defense anim
			LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 26)
		else
			-- do the fall back anim
			LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 23)
		end

	elseif moveableSlot == ObjID.FLAMETHROWER_BADDY then -- flamethrower
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 24)
	elseif moveableSlot == ObjID.MP_WITH_GUN then -- mp with gun
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 39)
	elseif moveableSlot == ObjID.TRIBESMAN_WITH_AX then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 31)
	elseif moveableSlot == ObjID.DOG then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 25)
	elseif moveableSlot == ObjID.MP_WITH_STICK then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 35)
	elseif moveableSlot == ObjID.CIVVY then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 35)
	elseif moveableSlot == ObjID.BADDY2 then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 71)
	end
end

LevelFuncs.LaraKickOrganizer = function(moveableSlot, baddy_name, laraAttackAnim)
	local attack_org = EventSequence.Create(
						"attack_org", -- sequence's name
						false, -- loop
						false, -- no countdown is displayed
						0.4,
						{LevelFuncs.KickAManBecauseItsWhatHeDeservesBINCH, moveableSlot, baddy_name, laraAttackAnim}, 
						0.9, 
						LevelFuncs.RestoreLaraWeaponStatus,
						0.01,
						LevelFuncs.RestoreLaraAnim
						)
	-- event sequences are inactive to begin with and so need to be started
    attack_org:Start()
end

LevelFuncs.KickAManBecauseItsWhatHeDeservesBINCH = function(moveableSlot, baddy_name, laraAttackAnim)
	SetBaddyKnockoutAnim(moveableSlot, baddy_name, laraAttackAnim)
end

LevelFuncs.RestoreLaraWeaponStatus = function()
	if Lara:GetHandStatus() == Objects.HandStatus.WEAPON_DRAW or Lara:GetHandStatus() == Objects.HandStatus.WEAPON_READY then
		-- init weaponLaraSlot
		local weaponLaraSlot = 0
		if Lara:GetWeaponType() == Objects.WeaponType.PISTOLS then
			weaponLaraSlot = 2
		elseif Lara:GetWeaponType() == Objects.WeaponType.UZIS then
			weaponLaraSlot = 3
		elseif Lara:GetWeaponType() == Objects.WeaponType.SHOTGUN then
			weaponLaraSlot = 4
		elseif Lara:GetWeaponType() == Objects.WeaponType.REVOLVER then
			weaponLaraSlot = 5
		elseif Lara:GetWeaponType() == Objects.WeaponType.CROSSBOW then
			weaponLaraSlot = 6
		elseif Lara:GetWeaponType() == Objects.WeaponType.HK then
			weaponLaraSlot = 7
		elseif Lara:GetWeaponType() == Objects.WeaponType.GRENADE_LAUNCHER then
			weaponLaraSlot = 8
		elseif Lara:GetWeaponType() == Objects.WeaponType.ROCKET_LAUNCHER then
			weaponLaraSlot = 9
		elseif Lara:GetWeaponType() == Objects.WeaponType.HARPOON_GUN then
			weaponLaraSlot = 10
		end
		print("WEAPON ID: "..Lara:GetWeaponType())
		LevelFuncs.Engine.Node.SetLaraWeaponType(Lara:GetWeaponType(), true)
		lara : SetAnim(0, weaponLaraSlot) -- perform anim 4 LARA_PISTOLS is slot 2
	end
end

LevelFuncs.RestoreLaraAnim = function()
	canPulseAgain = true
	if Lara:GetHandStatus() == Objects.HandStatus.WEAPON_DRAW or Lara:GetHandStatus() == Objects.HandStatus.WEAPON_READY then
		lara : SetAnim(103) -- perform anim 4 LARA_PISTOLS is slot 2
	end
end

function KnockOutBaddies()
    local moveableSlots = {
        ObjID.SAS_CAIRO,
        ObjID.MP_WITH_STICK,
        ObjID.CIVVY,
		ObjID.DOG
    }
    for index, moveableSlot in pairs(moveableSlots) do
        local moveables = GetMoveablesBySlot(moveableSlot)
        for index, moveable in pairs(moveables) do
        	if moveableSlot == ObjID.SAS_CAIRO then -- if the moveable is a SAS
        		Knock_Out_Baddy(moveable:GetName(), moveableSlot)
            end
            if moveableSlot == ObjID.MP_WITH_STICK then -- if the moveable is a Flamethrower
            	Knock_Out_Baddy(moveable:GetName(), moveableSlot)
            end
            if moveableSlot == ObjID.CIVVY then -- if the moveable is a Flamethrower
            	Knock_Out_Baddy(moveable:GetName(), moveableSlot)
            end
			if moveableSlot == ObjID.DOG then -- if the moveable is a Flamethrower
            	Knock_Out_Baddy(moveable:GetName(), moveableSlot)
            end
        end
    end
end