---@diagnostic disable: duplicate-set-field
require("Levels.MISC_LOOP_FUNCTIONS")
-- Timer Functions
local Timer = require("Engine.Timer")
local useTimer = 1.0
-- EventSequences
local EventSequence = require("Engine.EventSequence")

-----------------------------
-- SPEECH HEAD SET UP
-----------------------------
local CutsceneScript = require("Engine.CutsceneScript")
-- Hold Lua name of current actor speaking.
LevelVars.CurrentActorSpeaking = {}
-- Hold Lua name of last actor speaking (use this to make them go back to normal when not speaking.)
LevelVars.LastActorSpeaking = {}
-- Put Lua name of object here with their corresponding head bone number.
LevelVars.ActorHeadBoneTable = {
    LARA_MAIN = 14
}
LevelVars.ActorMouthWeights = {
    LARA_MAIN = LevelVars.LaraWeights
}
LevelVars.LaraWeights = {
    {0.01, ObjID.LARA_SKIN},
    {0.05, ObjID.LARA_SPEECH_HEAD2},
    {0.1, ObjID.LARA_SPEECH_HEAD3},
	{0.1, ObjID.LARA_SPEECH_HEAD4},
    {0.4, ObjID.LARA_SPEECH_HEAD1}
}
LevelFuncs.SetActorSpeaking = function(lua_name)
	print("Setting current speaking actor to: " .. lua_name)
    LevelVars.CurrentActorSpeaking = lua_name
end

function SetSpeakers()
	-- If anyone is speaking, we want to make their mouths move.
	if LevelVars.CurrentActorSpeaking and LevelVars.CurrentActorSpeaking ~= '' then
    
        local actor = GetMoveableByName(LevelVars.CurrentActorSpeaking)
        local head_bone = LevelVars.ActorHeadBoneTable[LevelVars.CurrentActorSpeaking]

        -- Someone is talking, so get current voice track loudness.
        local voice_level = GetAudioTrackLoudness(SoundTrackType.VOICE)
        
        for _, i in ipairs(LevelVars.ActorMouthWeights[LevelVars.CurrentActorSpeaking]) do
        	local weight = i[1]
        	local meshswap = i[2]
        	
            if voice_level >= weight then
                actor:SwapMesh(head_bone, meshswap)
			end
        
			if LevelVars.LastActorSpeaking ~= LevelVars.CurrentActorSpeaking and LevelVars.LastActorSpeaking ~= '' then

				print(LevelVars.CurrentActorSpeaking .. "is now speaking...")
				print("Looking for ".. tostring(LevelVars.LastActorSpeaking))
				local old_actor = GetMoveableByName(LevelVars.LastActorSpeaking)
				old_actor:UnswapMesh(LevelVars.ActorHeadBoneTable[LevelVars.LastActorSpeaking])
			end
        
        LevelVars.LastActorSpeaking = LevelVars.CurrentActorSpeaking
		end
    -- Otherwise, if we just stopped speaking, check who was last speaking and close their mouth.
    else
		if LevelVars.LastActorSpeaking ~= LevelVars.CurrentActorSpeaking and LevelVars.LastActorSpeaking ~= '' then
			print(LevelVars.LastActorSpeaking .. " is no longer speaking, so reverting their head meshswap...")
			local actor = GetMoveableByName(LevelVars.LastActorSpeaking)
			actor:UnswapMesh(LevelVars.ActorHeadBoneTable[LevelVars.LastActorSpeaking])
			LevelVars.LastActorSpeaking = ''
        end
    end
end



-----------------------------
-- LEVEL FUNCTIONS STANDARD SET UP
-----------------------------
LevelFuncs.OnLoad = function() end
LevelFuncs.OnSave = function() end
LevelFuncs.OnStart = function()
	Inventory.SetItemCount(ObjID.PISTOLS_ITEM, 0)
	LevelVars.IsSnowBallEquipped = false
	LevelVars.SplatCounter = 0
	LevelFuncs.BlinkOrganizer()

	-- initialize the speakers
	LevelVars.LastActorSpeaking = ''
	LevelVars.CurrentActorSpeaking = ''
end
LevelFuncs.OnLoop = function()
    KnockOutBaddies()
	EquipSnowBall()
	-- SetSpeakers()
end
LevelFuncs.OnEnd = function() end
LevelFuncs.OnUseItem = function() end
LevelFuncs.OnFreeze = function() end


-----------------------------
-- INTRO CAVE CUTSCENE
-----------------------------
LevelFuncs.IntroCaveCutOrg = function ()
    local intro_cave_cut_org = EventSequence.Create
	(
    	"intro_cave_cut_org", -- Lua name for event sequence
    	false, -- If sequence loops then true, if not: false.
    	false, -- We will not show the in-game timer for this example.
    	0.0, -- I made an enumerator for this so I don't have to change all manually
    	LevelFuncs.CaveCutFlyby1,
		5,
		LevelFuncs.LaraInvestigateCave1Cut
		-- 7.5,
		-- LevelFuncs.LaraTwirl
    )

   -- last : now we have created the Event Sequence: you must Start it:
    intro_cave_cut_org:Start()
end
LevelFuncs.CaveCutFlyby1 = function ()
	LevelFuncs.Engine.Node.PlayFlyBy(1)
end
LevelFuncs.LaraInvestigateCave1Cut = function ()
	MoveLaraToLSP(true, "lara_start_pos_181")
	Lara:SetAnim(1077)
	
	-- Sound.PlayAudioTrack("006", SoundTrackType.VOICE)
	-- local introCut_whatLaraMouthDoTho_ew_hate_it_here = CutsceneScript.Create("introCut_whatLaraMouthDoTho_ew_hate_it_here", false,
	-- 	0.0, { LevelFuncs.SetActorSpeaking, lara_name}
	-- )
	-- introCut_whatLaraMouthDoTho_ew_hate_it_here:Start()
end
-----------------------------
-- HELPER CUTSCENE FUNCTIONS
-----------------------------
LevelFuncs.CutFadeOut = function()
	FadeOut(1.0); 
end;

LevelFuncs.CutFadeIn = function()
	FadeIn(1.5);
end;

function MoveLaraToLSP(with_rotation, target_LSP_name)
    LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(with_rotation, 
                                                                lara_name, 
                                                                target_LSP_name)
end

----------------
--- BLINKING ---
----------------
LevelFuncs.BlinkOrganizer = function ()
	local lara_blink_org = EventSequence.Create(
						"lara_blink_org", -- sequence's name
						true, -- loop
						false, -- no countdown is displayed
						0,
						LevelFuncs.BlinkOff, 
						3, 
						LevelFuncs.BlinkOn,
						1,
						LevelFuncs.BlinkOff
						)
	-- event sequences are inactive to begin with and so need to be started
    lara_blink_org:Start()
end

LevelFuncs.BlinkOn = function ()
	LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 14, TEN.Objects.ObjID.LARA_SPEECH_HEAD1, 14)
	print("BLINKING ON")
end
LevelFuncs.BlinkOff = function ()
	LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 14, TEN.Objects.ObjID.LARA_SKIN, 14)
	print("BLINKING OFF")
end

--=====================
-- FAIRY HEAL LOGIC
--=====================
LevelFuncs.FairyHealSector = function()
	-- if lara is idle (anim 103)
	if lara : GetAnim() == 103 or 
	   lara:GetAnim() == 984 or lara:GetAnim() == 985 or
	   (lara:GetAnim() == 1025 and lara:GetAnim() == 1029) then
		-- print a hint
		LevelFuncs.Engine.Node.DrawText("Press ACTION to talk to Fairy)", 50, 85, 1, 3, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 87, 0, 50, 9, 0, 0, 2, 9)
	elseif lara : GetAnim() == 999 then
		LevelFuncs.Engine.Node.DrawText("(Press ACTION to HEAL AILMENTS)", 50, 85, 1, 3, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 50, 87, 0, 40, 9, 0, 0, 2, 9)
	end
	
	-- if lara is idle (anim 103)
	if lara : GetAnim() == 103 or 
	   lara:GetAnim() == 984 or lara:GetAnim() == 985 or
	   (lara:GetAnim() == 1025 and lara:GetAnim() == 1029) then
		-- if the player presses ACTION
		if Input.IsKeyPulsed(Input.ActionID.ACTION, 2, 2) then
			-- perform animation 998 (crystal start)
			lara : SetAnim(998)
		end
	end

	-- if lara is crystal idle (anim 999)
	if lara : GetAnim() == 999 then 
	
		-- << HINT LOGIC BEGIN >>
		-- play cam hint
		-- LevelFuncs.Engine.Node.ActivateCamera("camera_806", "camera_target_805")

		LevelFuncs.Engine.Node.DrawText("Thank you for \nhelping us with\nsaving the\ntoy factory!", 35, 40, 1, 1, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 35, 49, 0, 30, 30, 0, 0, 2, 9)
		LevelFuncs.Engine.Node.DrawText("Please let me \nheal your ailments!\nIt would be \nan honor!", 65, 40, 1, 1, TEN.Color(255,255,255), 0.8, 1)
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 12, TEN.Color(255,255,255), 65, 49, 0, 30, 30, 0, 0, 2, 9)
		-- << HINT LOGIC END >>
		
		-- if the player presses ACTION
		if Input.IsKeyPulsed(Input.ActionID.ACTION, 2, 2) then
			-- perform animation 998 (crystal start)
			lara : SetAnim(1000)
		end
	end

	-- if lara is exiting crystal anim (anim 1000)
	if lara : GetAnim() == 1000 and lara:GetFrame() == 0 then 
		-- play shatter sound
		LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 1164)
		--LevelFuncs.Engine.Node.FlashScreen(TEN.Color(128,255,255), 1)
		LevelFuncs.Engine.Node.FlashScreen(TEN.Color(0,255,0), 1)
		-- remove poison
		LevelFuncs.Engine.Node.ModifyLaraPoison(1, 0)
		-- set hp to 100%
		Lara:SetHP(32767)
	end

end

----------------------
--- SNOWBALL LOGIC ---
----------------------
function EquipSnowBall()
	ShowSnowballCounter()
	if (Inventory.GetItemCount(ObjID.PUZZLE_ITEM9) >= 1) then
		if Input.IsKeyPulsed(Input.ActionID.DRAW, 3, 2) then
			if (Lara:GetAnim() >= 0 and Lara:GetAnim() <= 13) or Lara:GetAnim() == 103 then
				LevelFuncs.DrawSnowballOrganizer()
			else
				-- play draw sound
				LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 6)
				LevelFuncs.SwapSnowMesh()
			end
		end
	else
		LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 10, TEN.Objects.ObjID.LARA_SKIN, 10)
		LevelVars.IsSnowBallEquipped = false
	end
	-- if Lara:GetHandStatus() == Objects.HandStatus.WEAPON_DRAW then
	-- 	LevelVars.IsSnowBallEquipped = false
	-- end
end

LevelFuncs.PlayDrawSnowballAnim = function()
	Lara:SetAnim(1076)
end

LevelFuncs.SwapSnowMesh = function()
	if LevelVars.IsSnowBallEquipped == true then
		LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 10, TEN.Objects.ObjID.LARA_SKIN, 10)
		LevelVars.IsSnowBallEquipped = false
	else
		LevelFuncs.Engine.Node.SwapMoveableMesh("LARA_MAIN", 10, TEN.Objects.ObjID.LARA_SPEECH_HEAD1, 10)
		LevelVars.IsSnowBallEquipped = true
	end
end

LevelFuncs.DrawSnowballOrganizer = function()
	local draw_snowball = EventSequence.Create(
						"draw_snowball", -- sequence's name
						false, -- loop
						false, -- no countdown is displayed
						0,
						LevelFuncs.PlayDrawSnowballAnim, 
						0.3, 
						LevelFuncs.SwapSnowMesh
						)
	-- event sequences are inactive to begin with and so need to be started
    draw_snowball:Start()
end

function FreezeBaddy(baddy_name)
	Inventory.TakeItem(ObjID.PUZZLE_ITEM9, 1)
	LevelFuncs.Engine.Node.FlashScreen(TEN.Color(128,255,255), 1)
	for i = 0,24,1
	do
		LevelFuncs.Engine.Node.SwapMoveableMesh(baddy_name, i, TEN.Objects.ObjID.ACTOR1_SPEECH_HEAD1, i)
	end 
end

function ShowSnowballCounter()
    local weaponType = " "
    local ammoCounterPosX = 100 -- X Position of counter.
    local ammoCounterPosY = 300 -- Y Position of counter.
    local holdWeapon = Lara:GetHandStatus() -- Check Lara's hand status.
    local ammoCounterColor = Color(255, 255, 255) 
    local ammoMessage = DisplayString(
    "Ammo: ".. Lara:GetHandStatus(), 100,
    300, Color(255, 255, 255))

	if LevelVars.IsSnowBallEquipped == true then
		LevelFuncs.Engine.Node.DisplaySprite(TEN.Objects.ObjID.MISC_SPRITES, 16, TEN.Color(255,255,255), 5, 12, 0, 12, 7, 0, 0, 0, 9)
		if (Inventory.GetItemCount(ObjID.PUZZLE_ITEM9) == -1) then
			LevelFuncs.Engine.Node.DrawText("Unlimited", 9, 10, 0, 3, TEN.Color(255,255,255), 0.8)
		else
			LevelFuncs.Engine.Node.DrawText(""..Inventory.GetItemCount(ObjID.PUZZLE_ITEM9), 9, 10, 0, 3, TEN.Color(255,255,255), 0.8)
		end
	else
		HideString(ammoMessage)
	end
end


-------------------------------
--- KNOCK OUT BADDIES BEGIN ---
-------------------------------
local canPulseAgain = true
function Knock_Out_Baddy(baddy_name, moveableSlot)
	-- if enemy is within 128 units of Lara
	local baddyObj = TEN.Objects.GetMoveableByName(baddy_name)
	local baddyPosition = TEN.Objects.GetMoveableByName(baddy_name):GetPosition()
	local laraPosition = TEN.Objects.GetMoveableByName("LARA_MAIN"):GetPosition()
	local distanceFromLara = math.abs(laraPosition:Distance(baddyPosition))
	
	if distanceFromLara <= 256.0 and baddyObj:GetActive() then
		--print("distance : " .. distanceFromLara)
		-- SPRINT SLIDE KNOCKOUT LOGIC
		-- if lara is performing a sprint slide
		-- if (LevelFuncs.Engine.Node.TestMoveableAnimation("LARA_MAIN", 956) or LevelFuncs.Engine.Node.TestMoveableAnimation("LARA_MAIN", 957)) then
		if (lara:GetAnim() == 956 or lara:GetAnim() == 957) and distanceFromLara <= 150.0 then
			SetBaddyKnockoutAnim(moveableSlot, baddy_name, 0)
		-- else use kick mechanics
		else
			-- KNEE AND TWIST KICK LOGIC
			print("distance : " .. distanceFromLara)
			if Input.IsKeyPulsed(Input.ActionID.ACTION, 3, 2) and canPulseAgain == true and
			   LevelFuncs.Engine.Node.TestLaraVehicle() == false then -- and lara is not on a vehicle
				canPulseAgain = false
				local attackAnimIDs = {}

				-- Get the random attack anim for Lara
				if Lara:GetHandStatus() == Objects.HandStatus.WEAPON_DRAW or Lara:GetHandStatus() == Objects.HandStatus.WEAPON_READY then
					attackAnimIDs = {976} -- 976, 1005, 1003
				else
					attackAnimIDs = {977, 976, 1005} -- 1006
				end

				if LevelVars.IsSnowBallEquipped == true then
					attackAnimIDs = {1075}
				end

				local randomAttackAnim = attackAnimIDs[math.random(1, #attackAnimIDs)]

				if moveableSlot == ObjID.DOG then
					randomAttackAnim = 1006
				end

				if moveableSlot == ObjID.SMALL_SCORPION then
					randomAttackAnim = 1003
					LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 1162)
				end

				lara : SetAnim(randomAttackAnim)
				LevelFuncs.LaraKickOrganizer(moveableSlot, baddy_name, randomAttackAnim)
			end
		end
	end
end

function SetBaddyKnockoutAnim(moveableSlot, baddy_name, laraAttackAnim)
	baddy_obj = Objects.GetMoveableByName(baddy_name)
	-- determine the knock out anim based off the moveable slot
	if moveableSlot == ObjID.SAS_CAIRO then -- SAS

		defenseAnimIDs = {23, 23, 23, 26}
		randomDefenseAnim = defenseAnimIDs[math.random(1, #defenseAnimIDs)]

		-- if lara does a low kick or a pistol kick
		if laraAttackAnim == 1006 or laraAttackAnim == 1005 then
			-- do a defense anim
			LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 26)
		else
			-- do the fall back anim
			LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 23)
		end

	elseif moveableSlot == ObjID.FLAMETHROWER_BADDY then -- flamethrower
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 24)
	elseif moveableSlot == ObjID.MP_WITH_GUN then -- mp with gun
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 39)
	elseif moveableSlot == ObjID.TRIBESMAN_WITH_AX then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 31)
	elseif moveableSlot == ObjID.DOG then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 25)
	elseif moveableSlot == ObjID.MP_WITH_STICK then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 35)
	elseif moveableSlot == ObjID.CIVVY then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 35)
	elseif moveableSlot == ObjID.MUMMY then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 74)
	elseif moveableSlot == ObjID.YETI then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 38)

	elseif moveableSlot == ObjID.MERCENARY_UZI then 
		-- if lara is using enchanted snowball
		if laraAttackAnim == 1075 then
			LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 36)
			FreezeBaddy(baddy_name)
			-- LevelFuncs.Engine.Node.ChangeMoveableColourOverTimespan(baddy_name, TEN.Color(183,255,255), 1.5)
		else

			-- if baddy is frozen
			if baddy_obj:GetAnim() == 36 then
				print("HES FROZEN!")
				-- shatter moveable
				LevelFuncs.Engine.Node.ShatterMoveable(baddy_name)
				baddy_obj:Destroy()
				-- play shatter sound
				LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 347)
				LevelFuncs.Engine.Node.FlashScreen(TEN.Color(128,255,255), 1)
			end

			-- if lara does a knee attack or a groin kick
			if laraAttackAnim == 1005 then
				-- do a knee groin attacked anim
				LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 30)
			else
				-- do the fall back anim
				LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 33)
			end

		end

	elseif moveableSlot == ObjID.MERCENARY_AUTOPISTOLS1 then 
		-- if lara is using enchanted snowball
		if laraAttackAnim == 1075 then
			LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 34)
			FreezeBaddy(baddy_name)
			-- LevelFuncs.Engine.Node.ChangeMoveableColourOverTimespan(baddy_name, TEN.Color(183,255,255), 1.5)
		else
			
			-- if baddy is frozen
			if baddy_obj:GetAnim() == 34 then
				print("HES FROZEN!")
				-- shatter moveable
				LevelFuncs.Engine.Node.ShatterMoveable(baddy_name)
				baddy_obj:Destroy()
				-- play shatter sound
				LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 347)
				LevelFuncs.Engine.Node.FlashScreen(TEN.Color(128,255,255), 1)
			end

			-- if lara does a low kick or a pistol kick
			if laraAttackAnim == 1005 then
				LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 28)
			else
				-- do the fall back anim
				LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 31)
			end

			
		end

	elseif moveableSlot == ObjID.BADDY2 then -- scottsman
		LevelFuncs.Engine.Node.SetMoveableAnimation(baddy_name, 71)

	elseif moveableSlot == ObjID.SMALL_SCORPION then
		local new_splat_name = "splat_EW_" .. tostring(LevelVars.SplatCounter)
		LevelVars.SplatCounter = LevelVars.SplatCounter + 1
		local spider_position = baddy_obj:GetPosition()
		local new_splat = Moveable(TEN.Objects.ObjID.ANIMATING10, -- object id
								  new_splat_name, -- name
								  spider_position) -- position
		LevelFuncs.Engine.Node.SetMoveablePositionToAnotherMoveable(true, 
                                                                new_splat_name, 
                                                                baddy_name)
		-- shatter moveable
		LevelFuncs.Engine.Node.ShatterMoveable(baddy_name)
		baddy_obj:Destroy()
		LevelFuncs.Engine.Node.PlaySoundAroundMoveable(lara_name, 1163)
	end
end

LevelFuncs.LaraKickOrganizer = function(moveableSlot, baddy_name, laraAttackAnim)
	local attack_org = EventSequence.Create(
						"attack_org", -- sequence's name
						false, -- loop
						false, -- no countdown is displayed
						0.4,
						{LevelFuncs.KickAManBecauseItsWhatHeDeservesBINCH, moveableSlot, baddy_name, laraAttackAnim}, 
						0.9, 
						LevelFuncs.RestoreLaraWeaponStatus,
						0.01,
						LevelFuncs.RestoreLaraAnim
						)
	-- event sequences are inactive to begin with and so need to be started
    attack_org:Start()
end

LevelFuncs.KickAManBecauseItsWhatHeDeservesBINCH = function(moveableSlot, baddy_name, laraAttackAnim)
	SetBaddyKnockoutAnim(moveableSlot, baddy_name, laraAttackAnim)
end

LevelFuncs.RestoreLaraWeaponStatus = function()
	if Lara:GetHandStatus() == Objects.HandStatus.WEAPON_DRAW or Lara:GetHandStatus() == Objects.HandStatus.WEAPON_READY then
		-- init weaponLaraSlot
		local weaponLaraSlot = 0
		if Lara:GetWeaponType() == Objects.WeaponType.PISTOLS then
			weaponLaraSlot = 2
		elseif Lara:GetWeaponType() == Objects.WeaponType.UZIS then
			weaponLaraSlot = 3
		elseif Lara:GetWeaponType() == Objects.WeaponType.SHOTGUN then
			weaponLaraSlot = 4
		elseif Lara:GetWeaponType() == Objects.WeaponType.REVOLVER then
			weaponLaraSlot = 5
		elseif Lara:GetWeaponType() == Objects.WeaponType.CROSSBOW then
			weaponLaraSlot = 6
		elseif Lara:GetWeaponType() == Objects.WeaponType.HK then
			weaponLaraSlot = 7
		elseif Lara:GetWeaponType() == Objects.WeaponType.GRENADE_LAUNCHER then
			weaponLaraSlot = 8
		elseif Lara:GetWeaponType() == Objects.WeaponType.ROCKET_LAUNCHER then
			weaponLaraSlot = 9
		elseif Lara:GetWeaponType() == Objects.WeaponType.HARPOON_GUN then
			weaponLaraSlot = 10
		end
		print("WEAPON ID: "..Lara:GetWeaponType())
		LevelFuncs.Engine.Node.SetLaraWeaponType(Lara:GetWeaponType(), true)
		lara : SetAnim(0, weaponLaraSlot) -- perform anim 4 LARA_PISTOLS is slot 2
	end
end

LevelFuncs.RestoreLaraAnim = function()
	canPulseAgain = true
	if Lara:GetHandStatus() == Objects.HandStatus.WEAPON_DRAW or Lara:GetHandStatus() == Objects.HandStatus.WEAPON_READY then
		lara : SetAnim(103) -- perform anim 4 LARA_PISTOLS is slot 2
	end
end

function KnockOutBaddies()
    local moveableSlots = {
        ObjID.SAS_CAIRO,
        ObjID.MP_WITH_STICK,
        ObjID.CIVVY,
		ObjID.DOG,
		ObjID.MUMMY,
		ObjID.YETI,
		ObjID.MERCENARY_AUTOPISTOLS1,
		ObjID.MERCENARY_UZI,
		ObjID.SMALL_SCORPION
    }
    for index, moveableSlot in pairs(moveableSlots) do
        local moveables = GetMoveablesBySlot(moveableSlot)
        for index, moveable in pairs(moveables) do
			if moveable:GetActive() and moveable:GetHP() >= 1 then
				if moveableSlot == ObjID.SAS_CAIRO then -- if the moveable is a SAS
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.MP_WITH_STICK then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.CIVVY then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.DOG then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.MUMMY then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.YETI then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.MERCENARY_AUTOPISTOLS1 then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.MERCENARY_UZI then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
				if moveableSlot == ObjID.SMALL_SCORPION then -- if the moveable is a Flamethrower
					Knock_Out_Baddy(moveable:GetName(), moveableSlot)
				end
			end
        end
    end
end
-----------------------------
--- KNOCK OUT BADDIES END ---
-----------------------------