-- Place in this Lua script all the levels of your game
-- Title is mandatory and must be the first level.

-- Intro image is a splash screen which appears before actual loading screen.
-- If you don't want it to appear, just remove this line.

Flow.SetIntroImagePath("Screens\\intro.jpg")

-- Intro video plays right after or instead of intro image, if specified.
-- If you don't want it to appear, just remove this line.

Flow.SetIntroVideoPath("Fmv\\intro.mp4")

-- Set overall amount of secrets in game.
-- If set to 0, secrets won't be displayed in statistics.

Flow.SetTotalSecretCount(7)

-- Enable/Disable Point Filter (square, unsmoothed pixels).

Flow.EnablePointFilter(true)

-- Enable/Disable saving and loading of savegames.

Flow.EnableLoadSave(true)

-- Disable/enable flycheat globally

Flow.EnableFlyCheat(false)

-- Disable/enable Lara drawing in title level

Flow.EnableLaraInTitle(true)

-- Disable/enable level selection in title level

Flow.EnableLevelSelect(false)

-- Disable/enable mass pickup (collect all pickups at once)

Flow.EnableMassPickup(true)

--------------------------------------------------

-- Title level

title = Level.new()

title.ambientTrack = "108"
title.levelFile = "Data\\TITLE.ten"
title.scriptFile = "Scripts\\Levels\\title.lua"
title.loadScreenFile = "Screens\\main.png"
title.horizon1.enabled = true

Flow.AddLevel(title)

--------------------------------------------------
-- Mediterranean_Sea level

Mediterranean_Sea = TEN.Flow.Level()

Mediterranean_Sea.nameKey = "Mediterranean_Sea"
Mediterranean_Sea.scriptFile = "Scripts\\Levels\\Mediterranean_Sea.lua"
Mediterranean_Sea.ambientTrack = "110"
Mediterranean_Sea.horizon1.enabled = true
Mediterranean_Sea.levelFile = "Data\\Mediterranean_Sea.ten"
Mediterranean_Sea.loadScreenFile = "Screens\\loading.png"
Mediterranean_Sea.objects = {

InventoryItem.new ("Circuit Breaker", ObjID.PUZZLE_ITEM2, 10, 0.5, Rotation.new(0, 0, 0),RotationAxis.Y, -1, ItemAction.USE),
InventoryItem.new ("Treasure", ObjID.PUZZLE_ITEM1, 10, 0.5, Rotation.new(0, 0, 0),RotationAxis.Y, -1, ItemAction.EXAMINE),
InventoryItem.new ("Green Keycard", ObjID.KEY_ITEM3, 10, 0.5, Rotation.new(0, 0, 0),RotationAxis.Y, -1, ItemAction.USE),
InventoryItem.new ("Yellow Keycard", ObjID.KEY_ITEM2, 10, 0.5, Rotation.new(0, 0, 0),RotationAxis.Y, -1, ItemAction.USE),
InventoryItem.new ("Heckler & Koch USP Match", ObjID.PISTOLS_ITEM, 10, 0.5, Rotation.new(0, 0, 0),RotationAxis.Y, -1, ItemAction.USE)

}



TEN.Flow.AddLevel(Mediterranean_Sea)

--------------------------------------------------

-- TITLE level

TITLE = TEN.Flow.Level()

TITLE.nameKey = "TITLE"
TITLE.scriptFile = "Scripts\\Levels\\TITLE.lua"
TITLE.ambientTrack = "110"
TITLE.horizon1.enabled = true
TITLE.levelFile = "Data\\TITLE.ten"
TITLE.loadScreenFile = "Screens\\loading.png"

TEN.Flow.AddLevel(TITLE)

--------------------------------------------------

-- Remnants level

Remnants = TEN.Flow.Level()

Remnants.nameKey = "Remnants"
Remnants.scriptFile = "Scripts\\Levels\\Remnants.lua"
Remnants.ambientTrack = "61"
Remnants.horizon1.enabled = true
Remnants.levelFile = "Data\\Remnants.ten"
Remnants.loadScreenFile = "Screens\\loading.png"
Remnants.objects = {

InventoryItem.new ("Circuit Breaker", ObjID.PUZZLE_ITEM2, 10, 0.5, Rotation.new(0, 0, 0),RotationAxis.Y, -1, ItemAction.USE),
InventoryItem.new ("Treasure", ObjID.PUZZLE_ITEM1, 10, 0.5, Rotation.new(0, 0, 0),RotationAxis.Y, -1, ItemAction.EXAMINE),
InventoryItem.new ("Left Chamber Key", ObjID.KEY_ITEM4, 10, 0.9, Rotation.new(0, 0, 0),RotationAxis.Y, -1, ItemAction.USE),
InventoryItem.new ("Right Chamber Key", ObjID.KEY_ITEM1, 10, 0.9, Rotation.new(0, 0, 0),RotationAxis.Y, -1, ItemAction.USE),
InventoryItem.new ("Heckler & Koch USP Match", ObjID.PISTOLS_ITEM, 10, 0.5, Rotation.new(0, 0, 0),RotationAxis.Y, -1, ItemAction.USE)

}

TEN.Flow.AddLevel(Remnants)

--------------------------------------------------
