-- Place in this Lua script all the levels of your game
-- Title is mandatory and must be the first level.

-- Intro image is a splash screen which appears before actual loading screen.
-- If you don't want it to appear, just remove this line.

Flow.SetIntroImagePath("Screens\\intro.jpg")

-- Intro video plays right after or instead of intro image, if specified.
-- If you don't want it to appear, just remove this line.

Flow.SetIntroVideoPath("Fmv\\intro.mp4")

-- Set overall amount of secrets in game.
-- If set to 0, secrets won't be displayed in statistics.

Flow.SetTotalSecretCount(5)

-- Enable/Disable Point Filter (square, unsmoothed pixels).

Flow.EnablePointFilter(false)

-- Enable/Disable saving and loading of savegames.

Flow.EnableLoadSave(true)

-- Disable/enable flycheat globally

Flow.EnableFlyCheat(false)

-- Disable/enable Lara drawing in title level

Flow.EnableLaraInTitle(false)

-- Disable/enable level selection in title level

Flow.EnableLevelSelect(false)

-- Disable/enable mass pickup (collect all pickups at once)

Flow.EnableMassPickup(true)

--------------------------------------------------

-- Title level

title = Level.new()

title.ambientTrack = "108"
title.levelFile = "Data\\title.ten"
title.scriptFile = "Scripts\\Levels\\title.lua"
title.loadScreenFile = "Screens\\main.png"

Flow.AddLevel(title)

--------------------------------------------------
-- CWB_Streets level

CWB_Streets = TEN.Flow.Level()

CWB_Streets.nameKey = "CWB_Streets"
CWB_Streets.scriptFile = "Scripts\\Levels\\CWB_Streets.lua"
CWB_Streets.ambientTrack = "110"
CWB_Streets.horizon1.enabled = true
CWB_Streets.levelFile = "Data\\CWB_Streets.ten"
CWB_Streets.loadScreenFile = "Screens\\loading.png"
CWB_Streets.fog = Flow.Fog.new(Color.new(240,5,66),2,70)

TEN.Flow.AddLevel(CWB_Streets)

--------------------------------------------------

-- Shinobis level

Shinobis = TEN.Flow.Level()

Shinobis.nameKey = "Shinobis"
Shinobis.scriptFile = "Scripts\\Levels\\Shinobis.lua"
Shinobis.ambientTrack = "110"
Shinobis.horizon1.enabled = true
Shinobis.levelFile = "Data\\Shinobis.ten"
Shinobis.loadScreenFile = "Screens\\loading.png"

TEN.Flow.AddLevel(Shinobis)

--------------------------------------------------

-- GREEN_LINE_WAY level

GREEN_LINE_WAY = TEN.Flow.Level()

GREEN_LINE_WAY.nameKey = "GREEN_LINE_WAY"
GREEN_LINE_WAY.scriptFile = "Scripts\\Levels\\GREEN_LINE_WAY.lua"
GREEN_LINE_WAY.ambientTrack = "110"
GREEN_LINE_WAY.horizon1.enabled = true
GREEN_LINE_WAY.levelFile = "Data\\GREEN_LINE_WAY.ten"
GREEN_LINE_WAY.loadScreenFile = "Screens\\loading.png"

TEN.Flow.AddLevel(GREEN_LINE_WAY)

--------------------------------------------------
