----------------------------------------------------
-- PHOTOMODE MODULE CREATED BY Mathew9R(Varcarus) --
----------------------------------------------------

---------------
-- ARGUMENTS --
---------------

-----------------------------------------------
-- DO NOT MODIFY ANYTHING BEYOND THIS POINT! --
-----------------------------------------------

-- Tables for Alterations via Main Script
local Photomode = {}
Photomode.__index = Photomode
Photomode.ControlsTable = {}
Photomode.ObjectsName = {}
Photomode.ControlStringTable = {}

-- Default Controls
local defaultControls = {
	forwardControl = ActionID.W,
	backwardControl = ActionID.S,
	leftControl = ActionID.A,
	rightControl = ActionID.D,
	camEnableDisable = ActionID.C,
	camHideText = ActionID.H,
	camSlowDown = ActionID.SHIFT,
	camCameraControl = AxisID.MOUSE
}
Photomode.Controls = defaultControls

Photomode.SetControls = function(controls)
    if controls then
        for key, value in pairs(controls) do
            Photomode.ControlsTable[key] = value
        end
    else
        Photomode.ControlsTable = defaultControls
    end
end

function Photomode.GetControls()
    return Photomode.ControlsTable
end

Photomode.SetControls()

-- Default Object Names
local defaultObjectNames = {
	camTarget = "Photomode_Camera_Target",
	camCenter = "Photomode_Camera_Center",
	camCamera = "Photomode_Camera"
}
Photomode.ObjectsName = defaultObjectNames

Photomode.SetObjectNames = function(objectNames)
    if objectNames then
        for key, value in pairs(objectNames) do
            Photomode.ObjectsName[key] = value
        end
    else
        Photomode.ObjectsName = defaultObjectNames
    end
end

Photomode.GetObjectNames = function()
    return Photomode.ObjectsName
end

Photomode.SetObjectNames()

local defaultStrings = {
	controlStrings = "WASD",
	camEnableDisableString = "C",
	camHideTextString = "H",
	camSlowDownString = "SHIFT",
	camCameraControlString = "Mouse"
}
Photomode.ControlStrings = defaultStrings

Photomode.SetControlStrings = function(controlStrings)
    if controlStrings then
        for key, value in pairs(controlStrings) do
            Photomode.ControlStringTable[key] = value
            print("Setting " .. key .. " to " .. value)
        end
    else
        Photomode.ControlStringTable = defaultStrings
    end
end

Photomode.GetControlStrings = function()
    return Photomode.ControlStringTable
end

Photomode.SetControlStrings()

LevelVars.PhotomodeMousePosY = 0
LevelVars.PhotomodeMousePosX = 0
LevelVars.IsPhotomodeEnabled = false
LevelVars.isTextVisible = true

-- Enabling the Camera function
LevelFuncs.PhotomodeEnabler = function()

	photomodeCameraTarget = GetMoveableByName(Photomode.ObjectsName.camTarget)
    photomodeCameraCenter = GetMoveableByName(Photomode.ObjectsName.camCenter)
    photomodeCamera = GetCameraByName(Photomode.ObjectsName.camCamera)

	if KeyIsHit(Photomode.Controls.camEnableDisable) and not LevelVars.IsPhotomodeEnabled then
		LevelVars.IsPhotomodeEnabled = true
		LevelVars.isTextVisible = true
		LevelVars.PhotomodeMousePosY = 0
		LevelVars.PhotomodeMousePosX = Lara:GetRotation().y
		photomodeCameraTarget:SetPosition(GetCameraPosition())
		photomodeCameraCenter:SetPosition(GetCameraPosition())
		photomodeCameraCenter:SetRotation(Rotation(0, Lara:GetRotation().y, 0))
		photomodeCamera:SetPosition(GetCameraPosition())
		SetFreezeMode(2)
	end
end

-- Enabling the Camera function in FreezeMode
LevelFuncs.PhotomodeFreeze = function()
	if LevelVars.IsPhotomodeEnabled then
		LevelFuncs.Photomode()
	end
end

-- Callbacks
AddCallback(TEN.Logic.CallbackPoint.PRE_LOOP, LevelFuncs.PhotomodeEnabler)
AddCallback(TEN.Logic.CallbackPoint.PRE_FREEZE, LevelFuncs.PhotomodeFreeze)

LevelFuncs.Photomode = function()

	-- Calulcations for Orbiting around the central Camera Position(to turn camera)
	pCamRot = photomodeCameraCenter:GetRotation()
	local pCamPos = photomodeCameraCenter:GetPosition()
	local pCamPitch = pCamRot.x
	local pCamYaw = pCamRot.y + -90
	local cosPitch = math.cos(math.rad(-pCamPitch))
	local sinPitch = math.sin(math.rad(-pCamPitch))
	local cosYaw = math.cos(math.rad(-pCamYaw))
	local sinYaw = math.sin(math.rad(-pCamYaw))

	pCamMathsCombined = {
    x = pCamPos.x + (512 * (cosYaw * cosPitch)),
    y = pCamPos.y + (512 * (sinPitch)),
    z = pCamPos.z + (512 * (sinYaw * cosPitch))
	}
	
	pCamMathsEast = {
    x = pCamPos.x + (512 * (sinYaw * cosPitch)),
    y = pCamPos.y + (512 * (sinPitch)),
    z = pCamPos.z + (-512 * (cosYaw * cosPitch))
	}
	
	pCamMathsWest = {
    x = pCamPos.x + (-512 * (sinYaw * cosPitch)),
    y = pCamPos.y + (-512 * (sinPitch)),
    z = pCamPos.z + (512 * (cosYaw * cosPitch)) -- 384
	}

	-- Probes
	local ProbeNorth = Probe(Vec3(pCamMathsCombined.x, pCamMathsCombined.y, pCamMathsCombined.z), photomodeCameraCenter:GetRoomNumber())
	local ProbeSouth = Probe(Vec3(pCamMathsCombined.x - 1024, pCamMathsCombined.y - (512 * (sinPitch)), pCamMathsCombined.z - 1024), photomodeCameraCenter:GetRoomNumber())
	local ProbeEast = Probe(Vec3(pCamMathsEast.x, pCamMathsEast.y, pCamMathsEast.z), photomodeCameraCenter:GetRoomNumber())
	local ProbeWest = Probe(Vec3(pCamMathsWest.x, pCamMathsWest.y, pCamMathsWest.z), photomodeCameraCenter:GetRoomNumber())

	-- Position Changes for when Photomode is active(stability)
	photomodeCameraTarget:SetPosition(Vec3(pCamMathsCombined.x, pCamMathsCombined.y, pCamMathsCombined.z))
	photomodeCameraCenter:SetRotation(Rotation(LevelVars.PhotomodeMousePosY, LevelVars.PhotomodeMousePosX, pCamRot.z))
	photomodeCamera:SetPosition(Vec3(pCamPos.x, pCamPos.y, pCamPos.z))
	
	-- Required for Camera Movement
	local normalizedPitch = pCamPitch % 360
	if normalizedPitch > 180 then
    	normalizedPitch = normalizedPitch - 360
	end

	local yawmove = math.rad(pCamYaw + 90)
	local pitchmove = math.rad(pCamPitch)
	
	local forwardX = math.cos(pitchmove) * math.cos(yawmove)
	local forwardY = math.sin(pitchmove)
	local forwardZ = math.cos(pitchmove) * math.sin(yawmove)
	
	local forwardLength = math.sqrt(forwardX^2 + forwardY^2 + forwardZ^2)
	if forwardLength > 0 then
    	forwardX = forwardX / forwardLength
    	forwardY = forwardY / forwardLength
    	forwardZ = forwardZ / forwardLength
	end

	local leftX = forwardZ
	local leftZ = -forwardX
	local rightX = -forwardZ
	local rightZ = forwardX
	local deltaX = 0
	local deltaZ = 0
	local deltaY = 0

	-- Speed Control
	if not KeyIsHeld(Photomode.Controls.camSlowDown) then
		camMovementSpeed = 128
		verticalMovementSpeed = camMovementSpeed
	elseif KeyIsHeld(Photomode.Controls.camSlowDown) then
		camMovementSpeed = 128 / 4
		verticalMovementSpeed = camMovementSpeed / 4
	end

	-- Keyboard inputs for controls
	if KeyIsHeld(Photomode.Controls.forwardControl) and not ProbeNorth:IsInsideSolidGeometry() then
    	deltaX = forwardX * camMovementSpeed
    	deltaY = -forwardY * camMovementSpeed
    	deltaZ = forwardZ * camMovementSpeed
	end

	if KeyIsHeld(Photomode.Controls.backwardControl) and not ProbeSouth:IsInsideSolidGeometry() then
    	deltaX = -forwardX * camMovementSpeed
    	deltaY = forwardY * camMovementSpeed
    	deltaZ = -forwardZ * camMovementSpeed
	end

	if KeyIsHeld(Photomode.Controls.leftControl) and not ProbeWest:IsInsideSolidGeometry() then
		deltaX = deltaX + leftX * camMovementSpeed
		deltaZ = deltaZ + leftZ * camMovementSpeed
	end

	if KeyIsHeld(Photomode.Controls.rightControl) and not ProbeEast:IsInsideSolidGeometry() then
		deltaX = deltaX + rightX * camMovementSpeed
		deltaZ = deltaZ + rightZ * camMovementSpeed
	end
	
	if KeyIsHit(Photomode.Controls.camHideText) and LevelVars.isTextVisible then
		LevelVars.isTextVisible = false
	elseif KeyIsHit(Photomode.Controls.camHideText) and not LevelVars.isTextVisible then
		LevelVars.isTextVisible = true
	end
	
	if KeyIsHit(ActionID.ESCAPE) or KeyIsHit(Photomode.Controls.camEnableDisable) then
		LevelVars.IsPhotomodeEnabled = false
		SetFreezeMode(0)
	end
	
	-- Mouse Axis control
	local MouseAxisY = GetAnalogAxisValue(Photomode.Controls.camCameraControl).y * 32
	local MouseAxisX = GetAnalogAxisValue(Photomode.Controls.camCameraControl).x * 32
	
	if GetAnalogAxisValue(Photomode.Controls.camCameraControl).x > 0 then
		LevelVars.PhotomodeMousePosX = LevelVars.PhotomodeMousePosX + MouseAxisX
	end
	if GetAnalogAxisValue(Photomode.Controls.camCameraControl).x < 0 then
		LevelVars.PhotomodeMousePosX = LevelVars.PhotomodeMousePosX + MouseAxisX
	end
	if GetAnalogAxisValue(Photomode.Controls.camCameraControl).y > 0 then
		LevelVars.PhotomodeMousePosY = LevelVars.PhotomodeMousePosY - MouseAxisY
	end
	if GetAnalogAxisValue(Photomode.Controls.camCameraControl).y < 0 then
		LevelVars.PhotomodeMousePosY = LevelVars.PhotomodeMousePosY - MouseAxisY
	end
	
	if KeyIsHit(ActionID.BRACKET_LEFT) then
		Lara:SetAnim(Lara:GetAnim() - 1)
	elseif KeyIsHit(ActionID.BRACKET_RIGHT) then
		Lara:SetAnim(Lara:GetAnim() + 1)
	end
	
	if LevelVars.PhotomodeMousePosY > 85 then
		LevelVars.PhotomodeMousePosY = 84
	elseif LevelVars.PhotomodeMousePosY < -85 then
		LevelVars.PhotomodeMousePosY = -84
	end

	-- Actual Movements, also fixes issues with Engine
	if deltaX ~= 0 or deltaZ ~= 0 or deltaY ~= 0 then
		photomodeCameraCenter:SetPosition(Vec3(pCamPos.x + deltaZ, pCamPos.y + deltaY, pCamPos.z + deltaX))
	end
	
	-- Just encase you're using a different model
	photomodeCameraCenter:SetMeshVisible(0, false)
	
	-- Plays the actual Camera to target the ... target.
	photomodeCamera:Play(photomodeCameraTarget)

	-- Helper Text
	if LevelVars.isTextVisible then
		LevelFuncs.Engine.Node.DrawTextForTimespan(1/30, "- Photo Mode -", 50, 2, 1, 1, TEN.Color(255,255,255), 0.75, 1)
		local stringFormat = string.format("%s - Move Camera | %s - Move Camera View\n%s - Slow Movement | %s - Hide Text | %s - Exit Photomode", Photomode.ControlStrings.controlStrings, Photomode.ControlStrings.camCameraControlString, Photomode.ControlStrings.camSlowDownString, Photomode.ControlStrings.camHideTextString, Photomode.ControlStrings.camEnableDisableString)
		LevelFuncs.Engine.Node.DrawTextForTimespan(1/30, stringFormat, 50, 90, 1, 1, TEN.Color(255,255,255), 0.75, 1)
	end

end

return Photomode

-- If you're reading this, you went down too far...ehe...